import time
import pytest
from unittest.mock import patch

from telectron.raw import types
from telectron.client import RequestingChats, Sequences
from telectron.methods.advanced.handle_updates import HandleUpdates

updates = [
    types.UpdateShort(update=types.UpdateUserStatus(user_id=1994482620, status=types.UserStatusOnline(expires=1666303970)), date=1666303669),
    types.UpdateShort(update=types.UpdateUserStatus(user_id=1994482620, status=types.UserStatusOffline(was_online=1666303681)), date=1666303680),
    types.Updates(updates=[types.UpdateDraftMessage(peer=types.PeerUser(user_id=1994482620), draft=types.DraftMessageEmpty(date=1666303682))], users=[types.User(id=1994482620, is_self=True, contact=False, mutual_contact=False, deleted=False, bot=False, bot_chat_history=False, bot_nochats=False, verified=False, restricted=False, min=False, bot_inline_geo=False, support=False, scam=False, apply_min_photo=False, fake=False, bot_attach_menu=False, premium=False, attach_menu_enabled=False, access_hash=-7947991963177256564, first_name='Kubrick', phone='79910277672', status=types.UserStatusOffline(was_online=1666303681), restriction_reason=[])], chats=[], date=1666303681, seq=2),
    types.Updates(updates=[types.UpdateNewChannelMessage(message=types.Message(id=7139, peer_id=types.PeerChannel(channel_id=1647858514), date=1666303770, message='В Белгородской области в руках у девятилетнего ребёнка взорвался военный дрон\\nМальчик в тяжелом состоянии доставлен в областную больницу - сообщает губернатор Гладков.\\nПутин развязал войну на границах России. Теперь дети не могут гулять на улице — там валяются бомбы. Дома тоже не безопасно — туда могут упасть бомбы. Надёжно защитить Белгород не получается: ПВО нужнее в Херсоне, Запорожье, Донецке и Луганске.', out=False, mentioned=False, media_unread=False, silent=False, post=True, from_scheduled=False, legacy=False, edit_hide=False, pinned=False, noforwards=False, media=types.MessageMediaPhoto(photo=types.Photo(id=5372975509039857039, access_hash=-6966045240077830140, file_reference=b'', date=1666303673, sizes=[types.PhotoStrippedSize(type='i', bytes=b''), types.PhotoSize(type='m', w=320, h=96, size=10973), types.PhotoSize(type='x', w=800, h=241, size=53668), types.PhotoSizeProgressive(type='y', w=1041, h=314, sizes=[3681, 11893, 35918, 52525, 62432])], dc_id=2, has_stickers=False, video_sizes=[])), entities=[types.MessageEntityBold(offset=0, length=79), types.MessageEntityTextUrl(offset=301, length=18, url='https://t.me/svtvnews/16654')], views=1, forwards=0, replies=types.MessageReplies(replies=0, replies_pts=0, comments=True, recent_repliers=[], channel_id=1269890003), restriction_reason=[]), pts=20235, pts_count=1)], users=[types.User(id=136817688, is_self=False, contact=False, mutual_contact=False, deleted=False, bot=True, bot_chat_history=False, bot_nochats=False, verified=False, restricted=False, min=True, bot_inline_geo=False, support=False, scam=False, apply_min_photo=True, fake=False, bot_attach_menu=False, premium=False, attach_menu_enabled=False, access_hash=1953598452476464818, first_name='Channel', username='Channel_Bot', photo=types.UserProfilePhoto(photo_id=587627495930570665, dc_id=1, has_video=False, stripped_thumb=b''), bot_info_version=4, restriction_reason=[])], chats=[types.Channel(id=1647858514, title='SVTV NEWS Free', photo=types.ChatPhoto(photo_id=5882112872316778690, dc_id=4, has_video=False, stripped_thumb=b''), date=1655754612, creator=False, left=False, broadcast=True, verified=False, megagroup=False, restricted=False, signatures=False, min=True, scam=False, has_link=True, has_geo=False, slowmode_enabled=False, call_active=False, call_not_empty=False, fake=False, gigagroup=False, noforwards=False, join_to_send=False, join_request=False, access_hash=-7938697320137857505, username='svtvnewsfree', restriction_reason=[])], date=1666303752, seq=0),
    types.Updates(updates=[types.UpdateNewChannelMessage(message=types.Message(id=51816, peer_id=types.PeerChannel(channel_id=1269890003), date=1666303773, message='В Белгородской области в руках у девятилетнего ребёнка взорвался военный дрон\\nМальчик в тяжелом состоянии доставлен в областную больницу - сообщает губернатор Гладков.\\nПутин развязал войну на границах России. Теперь дети не могут гулять на улице — там валяются бомбы. Дома тоже не безопасно — туда могут упасть бомбы. Надёжно защитить Белгород не получается: ПВО нужнее в Херсоне, Запорожье, Донецке и Луганске.', out=False, mentioned=False, media_unread=False, silent=False, post=False, from_scheduled=False, legacy=False, edit_hide=False, pinned=False, noforwards=False, from_id=types.PeerChannel(channel_id=1647858514), fwd_from=types.MessageFwdHeader(date=1666303770, imported=False, from_id=types.PeerChannel(channel_id=1647858514), channel_post=7139, saved_from_peer=types.PeerChannel(channel_id=1647858514), saved_from_msg_id=7139), media=types.MessageMediaPhoto(photo=types.Photo(id=5372975509039857039, access_hash=7867810648686487972, file_reference=b'', date=1666303673, sizes=[types.PhotoStrippedSize(type='i', bytes=b''), types.PhotoSize(type='m', w=320, h=96, size=10973), types.PhotoSize(type='x', w=800, h=241, size=53668), types.PhotoSizeProgressive(type='y', w=1041, h=314, sizes=[3681, 11893, 35918, 52525, 62432])], dc_id=2, has_stickers=False, video_sizes=[])), entities=[types.MessageEntityBold(offset=0, length=79), types.MessageEntityTextUrl(offset=301, length=18, url='https://t.me/svtvnews/16654')], views=3, forwards=0, replies=types.MessageReplies(replies=0, replies_pts=95566, comments=False, recent_repliers=[]), restriction_reason=[]), pts=95566, pts_count=1)], users=[types.User(id=136817688, is_self=False, contact=False, mutual_contact=False, deleted=False, bot=True, bot_chat_history=False, bot_nochats=False, verified=False, restricted=False, min=False, bot_inline_geo=False, support=False, scam=False, apply_min_photo=True, fake=False, bot_attach_menu=False, premium=False, attach_menu_enabled=False, access_hash=291445910502548092, first_name='Channel', username='Channel_Bot', photo=types.UserProfilePhoto(photo_id=587627495930570665, dc_id=1, has_video=False, stripped_thumb=b''), bot_info_version=4, restriction_reason=[])], chats=[types.Channel(id=1269890003, title='Чат SVTV NEWS Free', photo=types.ChatPhoto(photo_id=5391297921128972228, dc_id=2, has_video=False, stripped_thumb=b''), date=1666290863, creator=False, left=False, broadcast=False, verified=False, megagroup=True, restricted=False, signatures=False, min=False, scam=False, has_link=True, has_geo=False, slowmode_enabled=False, call_active=False, call_not_empty=False, fake=False, gigagroup=False, noforwards=False, join_to_send=False, join_request=False, access_hash=-1641089314234313153, restriction_reason=[], default_banned_rights=types.ChatBannedRights(until_date=2147483647, view_messages=False, send_messages=False, send_media=False, send_stickers=False, send_gifs=False, send_games=False, send_inline=False, embed_links=False, send_polls=False, change_info=True, invite_users=False, pin_messages=True)), types.Channel(id=1647858514, title='SVTV NEWS Free', photo=types.ChatPhoto(photo_id=5882112872316778690, dc_id=4, has_video=False, stripped_thumb=b''), date=1664896973, creator=False, left=False, broadcast=True, verified=False, megagroup=False, restricted=False, signatures=False, min=False, scam=False, has_link=True, has_geo=False, slowmode_enabled=False, call_active=False, call_not_empty=False, fake=False, gigagroup=False, noforwards=False, join_to_send=False, join_request=False, access_hash=-7566577635619473865, username='svtvnewsfree', restriction_reason=[])], date=1666303772, seq=0),
    types.Updates(updates=[types.UpdateEditChannelMessage(message=types.Message(id=7139, peer_id=types.PeerChannel(channel_id=1647858514), date=1666303770, message='В Белгородской области в руках у девятилетнего ребёнка взорвался военный дрон\\nМальчик в тяжелом состоянии доставлен в областную больницу - сообщает губернатор Гладков.\\nПутин развязал войну на границах России. Теперь дети не могут гулять на улице — там валяются бомбы. Дома тоже не безопасно — туда могут упасть бомбы. Надёжно защитить Белгород не получается: ПВО нужнее в Херсоне, Запорожье, Донецке и Луганске.', out=False, mentioned=False, media_unread=False, silent=False, post=True, from_scheduled=False, legacy=False, edit_hide=True, pinned=False, noforwards=False, media=types.MessageMediaPhoto(photo=types.Photo(id=5372975509039857039, access_hash=-6966045240077830140, file_reference=b'', date=1666303673, sizes=[types.PhotoStrippedSize(type='i', bytes=b''), types.PhotoSize(type='m', w=320, h=96, size=10973), types.PhotoSize(type='x', w=800, h=241, size=53668), types.PhotoSizeProgressive(type='y', w=1041, h=314, sizes=[3681, 11893, 35918, 52525, 62432])], dc_id=2, has_stickers=False, video_sizes=[])), entities=[types.MessageEntityBold(offset=0, length=79), types.MessageEntityTextUrl(offset=301, length=18, url='https://t.me/svtvnews/16654')], views=3, forwards=0, replies=types.MessageReplies(replies=0, replies_pts=95567, comments=True, recent_repliers=[], channel_id=1269890003), edit_date=1666303773, restriction_reason=[]), pts=20236, pts_count=1)], users=[types.User(id=136817688, is_self=False, contact=False, mutual_contact=False, deleted=False, bot=True, bot_chat_history=False, bot_nochats=False, verified=False, restricted=False, min=True, bot_inline_geo=False, support=False, scam=False, apply_min_photo=True, fake=False, bot_attach_menu=False, premium=False, attach_menu_enabled=False, access_hash=1953598452476464818, first_name='Channel', username='Channel_Bot', photo=types.UserProfilePhoto(photo_id=587627495930570665, dc_id=1, has_video=False, stripped_thumb=b''), bot_info_version=4, restriction_reason=[])], chats=[types.Channel(id=1647858514, title='SVTV NEWS Free', photo=types.ChatPhoto(photo_id=5882112872316778690, dc_id=4, has_video=False, stripped_thumb=b''), date=1655754612, creator=False, left=False, broadcast=True, verified=False, megagroup=False, restricted=False, signatures=False, min=True, scam=False, has_link=True, has_geo=False, slowmode_enabled=False, call_active=False, call_not_empty=False, fake=False, gigagroup=False, noforwards=False, join_to_send=False, join_request=False, access_hash=-7938697320137857505, username='svtvnewsfree', restriction_reason=[])], date=1666303773, seq=0),
    types.Updates(updates=[types.UpdateEditChannelMessage(message=types.Message(id=7139, peer_id=types.PeerChannel(channel_id=1647858514), date=1666303770, message='В Белгородской области в руках у девятилетнего ребёнка взорвался военный дрон\\nМальчик в тяжелом состоянии доставлен в областную больницу - сообщает губернатор Гладков.\\nПутин развязал войну на границах России. Теперь дети не могут гулять на улице — там валяются бомбы. Дома тоже не безопасно — туда могут упасть бомбы. Надёжно защитить Белгород не получается: ПВО нужнее в Херсоне, Запорожье, Донецке и Луганске.', out=False, mentioned=False, media_unread=False, silent=False, post=True, from_scheduled=False, legacy=False, edit_hide=True, pinned=False, noforwards=False, media=types.MessageMediaPhoto(photo=types.Photo(id=5372975509039857039, access_hash=-6966045240077830140, file_reference=b'', date=1666303673, sizes=[types.PhotoStrippedSize(type='i', bytes=b''), types.PhotoSize(type='m', w=320, h=96, size=10973), types.PhotoSize(type='x', w=800, h=241, size=53668), types.PhotoSizeProgressive(type='y', w=1041, h=314, sizes=[3681, 11893, 35918, 52525, 62432])], dc_id=2, has_stickers=False, video_sizes=[])), entities=[types.MessageEntityBold(offset=0, length=79), types.MessageEntityTextUrl(offset=301, length=18, url='https://t.me/svtvnews/16654')], views=15, forwards=0, replies=types.MessageReplies(replies=0, replies_pts=95567, comments=True, recent_repliers=[], channel_id=1269890003), edit_date=1666303870, reactions=types.MessageReactions(results=[], min=True, can_see_list=False, recent_reactions=[]), restriction_reason=[]), pts=20237, pts_count=1)], users=[types.User(id=136817688, is_self=False, contact=False, mutual_contact=False, deleted=False, bot=True, bot_chat_history=False, bot_nochats=False, verified=False, restricted=False, min=True, bot_inline_geo=False, support=False, scam=False, apply_min_photo=True, fake=False, bot_attach_menu=False, premium=False, attach_menu_enabled=False, access_hash=1953598452476464818, first_name='Channel', username='Channel_Bot', photo=types.UserProfilePhoto(photo_id=587627495930570665, dc_id=1, has_video=False, stripped_thumb=b''), bot_info_version=4, restriction_reason=[])], chats=[types.Channel(id=1647858514, title='SVTV NEWS Free', photo=types.ChatPhoto(photo_id=5882112872316778690, dc_id=4, has_video=False, stripped_thumb=b''), date=1655754612, creator=False, left=False, broadcast=True, verified=False, megagroup=False, restricted=False, signatures=False, min=True, scam=False, has_link=True, has_geo=False, slowmode_enabled=False, call_active=False, call_not_empty=False, fake=False, gigagroup=False, noforwards=False, join_to_send=False, join_request=False, access_hash=-7938697320137857505, username='svtvnewsfree', restriction_reason=[])], date=1666303870, seq=0),
    types.Updates(updates=[types.UpdateEditChannelMessage(message=types.Message(id=51816, peer_id=types.PeerChannel(channel_id=1269890003), date=1666303773, message='В Белгородской области в руках у девятилетнего ребёнка взорвался военный дрон\\nМальчик в тяжелом состоянии доставлен в областную больницу - сообщает губернатор Гладков.\\nПутин развязал войну на границах России. Теперь дети не могут гулять на улице — там валяются бомбы. Дома тоже не безопасно — туда могут упасть бомбы. Надёжно защитить Белгород не получается: ПВО нужнее в Херсоне, Запорожье, Донецке и Луганске.', out=False, mentioned=False, media_unread=False, silent=False, post=False, from_scheduled=False, legacy=False, edit_hide=True, pinned=True, noforwards=False, from_id=types.PeerChannel(channel_id=1647858514), fwd_from=types.MessageFwdHeader(date=1666303770, imported=False, from_id=types.PeerChannel(channel_id=1647858514), channel_post=7139, saved_from_peer=types.PeerChannel(channel_id=1647858514), saved_from_msg_id=7139), media=types.MessageMediaPhoto(photo=types.Photo(id=5372975509039857039, access_hash=7867810648686487972, file_reference=b'', date=1666303673, sizes=[types.PhotoStrippedSize(type='i', bytes=b''), types.PhotoSize(type='m', w=320, h=96, size=10973), types.PhotoSize(type='x', w=800, h=241, size=53668), types.PhotoSizeProgressive(type='y', w=1041, h=314, sizes=[3681, 11893, 35918, 52525, 62432])], dc_id=2, has_stickers=False, video_sizes=[])), entities=[types.MessageEntityBold(offset=0, length=79), types.MessageEntityTextUrl(offset=301, length=18, url='https://t.me/svtvnews/16654')], views=15, forwards=0, replies=types.MessageReplies(replies=0, replies_pts=95569, comments=False, recent_repliers=[]), edit_date=1666303870, reactions=types.MessageReactions(results=[], min=False, can_see_list=False, recent_reactions=[]), restriction_reason=[]), pts=95569, pts_count=2)], users=[types.User(id=136817688, is_self=False, contact=False, mutual_contact=False, deleted=False, bot=True, bot_chat_history=False, bot_nochats=False, verified=False, restricted=False, min=False, bot_inline_geo=False, support=False, scam=False, apply_min_photo=True, fake=False, bot_attach_menu=False, premium=False, attach_menu_enabled=False, access_hash=291445910502548092, first_name='Channel', username='Channel_Bot', photo=types.UserProfilePhoto(photo_id=587627495930570665, dc_id=1, has_video=False, stripped_thumb=b''), bot_info_version=4, restriction_reason=[])], chats=[types.Channel(id=1269890003, title='Чат SVTV NEWS Free', photo=types.ChatPhoto(photo_id=5391297921128972228, dc_id=2, has_video=False, stripped_thumb=b''), date=1666290863, creator=False, left=False, broadcast=False, verified=False, megagroup=True, restricted=False, signatures=False, min=False, scam=False, has_link=True, has_geo=False, slowmode_enabled=False, call_active=False, call_not_empty=False, fake=False, gigagroup=False, noforwards=False, join_to_send=False, join_request=False, access_hash=-1641089314234313153, restriction_reason=[], default_banned_rights=types.ChatBannedRights(until_date=2147483647, view_messages=False, send_messages=False, send_media=False, send_stickers=False, send_gifs=False, send_games=False, send_inline=False, embed_links=False, send_polls=False, change_info=True, invite_users=False, pin_messages=True)), types.Channel(id=1647858514, title='SVTV NEWS Free', photo=types.ChatPhoto(photo_id=5882112872316778690, dc_id=4, has_video=False, stripped_thumb=b''), date=1664896973, creator=False, left=False, broadcast=True, verified=False, megagroup=False, restricted=False, signatures=False, min=False, scam=False, has_link=True, has_geo=False, slowmode_enabled=False, call_active=False, call_not_empty=False, fake=False, gigagroup=False, noforwards=False, join_to_send=False, join_request=False, access_hash=-7566577635619473865, username='svtvnewsfree', restriction_reason=[])], date=1666303869, seq=0),
    types.UpdateShort(update=types.UpdateUserStatus(user_id=1994482620, status=types.UserStatusOnline(expires=1666304382)), date=1666304081),
    types.UpdateShort(update=types.UpdateUserStatus(user_id=1994482620, status=types.UserStatusOffline(was_online=1666304097)), date=1666304096),
    types.UpdateShort(update=types.UpdateUserStatus(user_id=1994482620, status=types.UserStatusOnline(expires=1666304398)), date=1666304097),
    types.Updates(updates=[types.UpdateWebPage(webpage=types.WebPageEmpty(id=9170793120944384150), pts=557, pts_count=0)], users=[], chats=[], date=1666304097, seq=0),
    types.Updates(updates=[types.UpdateNewMessage(message=types.Message(id=255, peer_id=types.PeerUser(user_id=1994482620), date=1666304100, message='https://t.me/+85ZFhrVlMww3Nzcy', out=False, mentioned=False, media_unread=False, silent=False, post=False, from_scheduled=False, legacy=False, edit_hide=False, pinned=False, noforwards=False, entities=[types.MessageEntityUrl(offset=0, length=30)], restriction_reason=[]), pts=558, pts_count=1), types.UpdateReadHistoryInbox(peer=types.PeerUser(user_id=1994482620), max_id=255, still_unread_count=0, pts=559, pts_count=1)], users=[types.User(id=1994482620, is_self=True, contact=False, mutual_contact=False, deleted=False, bot=False, bot_chat_history=False, bot_nochats=False, verified=False, restricted=False, min=False, bot_inline_geo=False, support=False, scam=False, apply_min_photo=False, fake=False, bot_attach_menu=False, premium=False, attach_menu_enabled=False, access_hash=-7947991963177256564, first_name='Kubrick', phone='79910277672', status=types.UserStatusOnline(expires=1666304398), restriction_reason=[])], chats=[], date=1666304099, seq=0),
    types.Updates(updates=[types.UpdateChannel(channel_id=1723780867)], users=[], chats=[types.Channel(id=1723780867, title='Системный тест канал 1', photo=types.ChatPhotoEmpty(), date=1666304103, creator=False, left=False, broadcast=True, verified=False, megagroup=False, restricted=False, signatures=False, min=False, scam=False, has_link=True, has_geo=False, slowmode_enabled=False, call_active=False, call_not_empty=False, fake=False, gigagroup=False, noforwards=True, join_to_send=False, join_request=False, access_hash=6208618429072922326, restriction_reason=[])], date=1666304102, seq=3),
    types.UpdateShort(update=types.UpdateUserStatus(user_id=1994482620, status=types.UserStatusOffline(was_online=1666304136)), date=1666304135),
    types.UpdateShort(update=types.UpdateChannelMessageViews(channel_id=1710046483, id=2635, views=60), date=1666346445),
    types.Updates(updates=[types.UpdateNewChannelMessage(message=types.Message(id=51878, peer_id=types.PeerChannel(channel_id=1269890003), date=1666346661, message='Может деятельность бидона на это проверить?', out=False, mentioned=False, media_unread=False, silent=False, post=False, from_scheduled=False, legacy=False, edit_hide=False, pinned=False, noforwards=False, from_id=types.PeerUser(user_id=583559478), reply_to=types.MessageReplyHeader(reply_to_msg_id=51875, reply_to_scheduled=False), entities=[], restriction_reason=[]), pts=95723, pts_count=1)], users=[types.User(id=583559478, is_self=False, contact=False, mutual_contact=False, deleted=False, bot=False, bot_chat_history=False, bot_nochats=False, verified=False, restricted=False, min=False, bot_inline_geo=False, support=False, scam=False, apply_min_photo=True, fake=False, bot_attach_menu=False, premium=False, attach_menu_enabled=False, access_hash=-8093678979214852747, first_name='account was deleted', username='fds_fgs', photo=types.UserProfilePhoto(photo_id=2506368873737070508, dc_id=2, has_video=False, stripped_thumb=b''), status=types.UserStatusRecently(), restriction_reason=[])], chats=[types.Channel(id=1269890003, title='Чат SVTV NEWS Free', photo=types.ChatPhoto(photo_id=5391297921128972228, dc_id=2, has_video=False, stripped_thumb=b''), date=1666290863, creator=False, left=False, broadcast=False, verified=False, megagroup=True, restricted=False, signatures=False, min=False, scam=False, has_link=True, has_geo=False, slowmode_enabled=False, call_active=False, call_not_empty=False, fake=False, gigagroup=False, noforwards=False, join_to_send=False, join_request=False, access_hash=-1641089314234313153, restriction_reason=[], default_banned_rights=types.ChatBannedRights(until_date=2147483647, view_messages=False, send_messages=False, send_media=False, send_stickers=False, send_gifs=False, send_games=False, send_inline=False, embed_links=False, send_polls=False, change_info=True, invite_users=False, pin_messages=True))], date=1666346660, seq=0),
    types.UpdateShort(update=types.UpdateChannelMessageViews(channel_id=1710046483, id=2636, views=59), date=1666346668),
    types.Updates(updates=[types.UpdateNewChannelMessage(message=types.Message(id=7166, peer_id=types.PeerChannel(channel_id=1647858514), date=1666347491, message='В Ульяновске военкомат дал отсрочку отцу троих детей после того, как он обратился в суд — Павел Чиков\\nВласти согласились предоставить отсрочку призывнику, сославшись на «секретные Указания Генерального штаба» ВС РФ.\\nНедавно челябинский суд также признал незаконным мобилизацию призывника с тремя детьми. Призывную комиссию тогда обязали пересмотреть решение «с учётом указаний Генштаба ВС РФ».\\nНо многие, как погибший айтишник из «Райфайзен-банка», просто не получают времени на то, чтобы оспорить решение о мобилизации. У Путина всё под контролем, а потому солдаты нужны ему здесь и сейчас. Дать им шанс сбежать — значит лишить себя шансов на победу в бессмысленной войне.', out=False, mentioned=False, media_unread=False, silent=False, post=True, from_scheduled=False, legacy=False, edit_hide=False, pinned=False, noforwards=False, media=types.MessageMediaWebPage(webpage=types.WebPage(id=7709704822470471308, url='https://svtv.org/news/2022-10-21/v-ulianovskie-chikov-mobil-sud-otsrochka/', display_url='svtv.org/news/2022-10-21/v-ulianovskie-chikov-mobil-sud-otsrochka', hash=-1023197231, type='photo', site_name='СВТВ Либертарианское СМИ', title='В Ульяновске военкомат дал отсрочку отцу троих детей после того, как он обратился в суд — Павел Чиков', description='В Ульяновске военкомат пошёл на сделку с призывником, который подал иск в суд — передаёт Павел Чиков. У мужчины трое детей. Власти сослались на «секретные Указания Генерального штаба» ВС РФ, чтобы пообещать мобилизованному отсрочку. Как рассказал руководитель «Агоры», у Ивана Герея на содержании трое детей младше 16 лет. По закону о', photo=types.Photo(id=5952649639910027022, access_hash=8644289735331141346, file_reference=b'', date=1666346584, sizes=[types.PhotoStrippedSize(type='i', bytes=b''), types.PhotoSize(type='m', w=320, h=168, size=12429), types.PhotoSize(type='x', w=800, h=420, size=46814), types.PhotoSize(type='y', w=1200, h=630, size=62698)], dc_id=4, has_stickers=False, video_sizes=[]), cached_page=types.Page(url='https://svtv.org/news/2022-10-21/v-ulianovskie-chikov-mobil-sud-otsrochka/', blocks=[types.PageBlockCover(cover=types.PageBlockPhoto(photo_id=5950881148471193404, caption=types.PageCaption(text=types.TextEmpty(), credit=types.TextEmpty()))), types.PageBlockChannel(channel=types.Channel(id=1513669961, title='SVTV NEWS', photo=types.ChatPhoto(photo_id=5037774425646279275, dc_id=1, has_video=True, stripped_thumb=b''), date=1636394242, creator=False, left=False, broadcast=True, verified=False, megagroup=False, restricted=False, signatures=False, min=True, scam=False, has_link=True, has_geo=False, slowmode_enabled=False, call_active=False, call_not_empty=False, fake=False, gigagroup=False, noforwards=False, join_to_send=False, join_request=False, access_hash=-6192698774674749794, username='svtvnews', restriction_reason=[])), types.PageBlockTitle(text=types.TextPlain(text='В Ульяновске военкомат дал отсрочку отцу троих детей после того, как он обратился в суд — Павел Чиков')), types.PageBlockAuthorDate(author=types.TextEmpty(), published_date=1666346536), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='В Ульяновске военкомат пошёл на сделку с призывником, который подал иск в суд — '), types.TextUrl(text=types.TextPlain(text='передаёт Павел Чиков'), url='https://t.me/pchikov/5235', webpage_id=0), types.TextPlain(text='. У мужчины трое детей. Власти сослались на «'), types.TextItalic(text=types.TextPlain(text='секретные Указания Генерального штаба»')), types.TextPlain(text=' ВС РФ, чтобы пообещать мобилизованному отсрочку.')])), types.PageBlockParagraph(text=types.TextPlain(text='Как рассказал руководитель «Агоры», у Ивана Герея на содержании трое детей младше 16 лет. По закону о мобилизации, для получения отсрочки нужно минимум четверо таких детей. Тем не менее, мужчина подал иск в Засвияжский районный суд Ульяновска.')), types.PageBlockParagraph(text=types.TextPlain(text='Суд принял меры предварительной защиты и приостановил исполнение решения о призыве. Тогда военкомат согласился на сделку во внесудебном порядке.')), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='Герей отозвал своё административное исковое заявление. Как передаёт Чиков, в ответ «'), types.TextItalic(text=types.TextPlain(text='в военкомате пообещали пересмотреть решение и предоставить отсрочку от службы, опираясь на секретные Указания Генерального штаба Вооруженных Сил РФ от 04 октября 2022 года №315/2/3658дсп')), types.TextPlain(text='».')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='По словам правозащитника, правовых оснований для предоставления таких «броней» или отсрочек не существует. Такое решение легально могут принимать только законодательные органы и президент страны. Указания Генштаба «'), types.TextItalic(text=types.TextPlain(text='не могут переопределять текущее нормативно-правовое регулировани')), types.TextPlain(text='е», сообщает Чиков. Однако, отмечается, что такие меры всё же работают.')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='Недавно челябинский суд также признал незаконным мобилизацию призывника с тремя детьми. Призывную комиссию тогда обязали пересмотреть решение «'), types.TextItalic(text=types.TextPlain(text='с учётом указаний Генштаба ВС РФ')), types.TextPlain(text='».')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='Председатель комитета Госдумы по обороне Андрей Картаполов '), types.TextUrl(text=types.TextPlain(text='заявил'), url='https://tass.ru/obschestvo/16117583', webpage_id=0), types.TextPlain(text=', что «на сегодняшний день вернули по стране порядка почти 10 тысяч человек по разным причинам». Так он ответил на вопрос о мобилизованных по ошибке во время встречи с волонтёрами «ЕР».')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='В начале октября глава Хабаровского края '), types.TextUrl(text=types.TextPlain(text='признался, что половину мобилизованных вернули домой'), url='https://svtv.org/news/2022-10-03/khabarovsk-voenkom-osvobodili-polovina/', webpage_id=7709704823534883124), types.TextPlain(text=' из-за многочисленных нарушений. Это стало поводом для перевода местного военкома в Магаданскую область.')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='В Москве работника Гознака мобилизовали, когда '), types.TextUrl(text=types.TextPlain(text='он принёс справку о брони и больничном'), url='https://svtv.org/news/2022-10-18/bron-goznak-mobiliz/', webpage_id=7709704821864713697), types.TextPlain(text=' в военкомат. Документ ему просто перечеркнули. Генпрокурор РФ посоветовал ошибочно мобилизованным '), types.TextUrl(text=types.TextPlain(text='прийти в военкомат'), url='https://svtv.org/news/2022-10-12/gienieralnyi-prokuror-rossii-ighor-krasnov-rasskazal-chto-nado-dielat-niezakonno-popavshim-pod-mobilizatsiiu/', webpage_id=7709704823642672147), types.TextPlain(text=', чтобы получить освобождение.')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='Ранее отправить на фронт пытались '), types.TextUrl(text=types.TextPlain(text='инвалида второй группы'), url='https://svtv.org/news/2022-09-25/kapitonov-i-kamiery-voenkomat/', webpage_id=7709704823442188767), types.TextPlain(text=', задержав его по камерам в метро, и '), types.TextUrl(text=types.TextPlain(text='колясочника с неизлечимым заболеванием'), url='https://svtv.org/news/2022-10-09/sma-vasiliev-poviestka-4-etazh/', webpage_id=7709704822510996939), types.TextPlain(text=', который не мог бы даже подняться в кабинет к приёмной комиссии. В Пензе мобилизовали '), types.TextUrl(text=types.TextPlain(text='мужчину с больной матерью на иждивении'), url='https://t.me/svtvnews/15517', webpage_id=0), types.TextPlain(text='.')])), types.PageBlockParagraph(text=types.TextPlain(text='Наш отдел новостей каждый день отсматривает тонны пропаганды, чтобы найти среди неё крупицу правды и рассказать её вам. Помогите новостникам не сойти с ума.')), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextUrl(text=types.TextPlain(text='ПОДДЕРЖАТЬ ПРОЕКТ\\n'), url='https://svtv.org/support/', webpage_id=7709704823265455524), types.TextPlain(text='Карта любого банка или криптовалюта')]))], photos=[types.Photo(id=5950881148471193404, access_hash=-2639209488335026044, file_reference=b'', date=1666346584, sizes=[types.PhotoStrippedSize(type='i', bytes=b''), types.PhotoSize(type='m', w=320, h=180, size=10917), types.PhotoSize(type='x', w=800, h=449, size=55069), types.PhotoSize(type='y', w=1280, h=719, size=143008), types.PhotoSize(type='w', w=1920, h=1079, size=229011)], dc_id=4, has_stickers=False, video_sizes=[])], documents=[], part=False, rtl=False, v2=False), attributes=[])), entities=[types.MessageEntityBold(offset=0, length=101), types.MessageEntityTextUrl(offset=110, length=11, url='https://svtv.org/news/2022-10-21/v-ulianovskie-chikov-mobil-sud-otsrochka/'), types.MessageEntityTextUrl(offset=412, length=17, url='https://t.me/svtvnews/17176?single'), types.MessageEntityTextUrl(offset=537, length=13, url='https://t.me/svtvnews/16443')], views=1, forwards=0, replies=types.MessageReplies(replies=0, replies_pts=0, comments=True, recent_repliers=[], channel_id=1269890003), restriction_reason=[]), pts=20313, pts_count=1)], users=[types.User(id=136817688, is_self=False, contact=False, mutual_contact=False, deleted=False, bot=True, bot_chat_history=False, bot_nochats=False, verified=False, restricted=False, min=True, bot_inline_geo=False, support=False, scam=False, apply_min_photo=True, fake=False, bot_attach_menu=False, premium=False, attach_menu_enabled=False, access_hash=1953598452476464818, first_name='Channel', username='Channel_Bot', photo=types.UserProfilePhoto(photo_id=587627495930570665, dc_id=1, has_video=False, stripped_thumb=b''), bot_info_version=4, restriction_reason=[])], chats=[types.Channel(id=1647858514, title='SVTV NEWS Free', photo=types.ChatPhoto(photo_id=5882112872316778690, dc_id=4, has_video=False, stripped_thumb=b''), date=1655754612, creator=False, left=False, broadcast=True, verified=False, megagroup=False, restricted=False, signatures=False, min=True, scam=False, has_link=True, has_geo=False, slowmode_enabled=False, call_active=False, call_not_empty=False, fake=False, gigagroup=False, noforwards=False, join_to_send=False, join_request=False, access_hash=-7938697320137857505, username='svtvnewsfree', restriction_reason=[])], date=1666347483, seq=0),
    types.Updates(updates=[types.UpdateNewChannelMessage(message=types.Message(id=51879, peer_id=types.PeerChannel(channel_id=1269890003), date=1666347494, message='В Ульяновске военкомат дал отсрочку отцу троих детей после того, как он обратился в суд — Павел Чиков\\nВласти согласились предоставить отсрочку призывнику, сославшись на «секретные Указания Генерального штаба» ВС РФ.\\nНедавно челябинский суд также признал незаконным мобилизацию призывника с тремя детьми. Призывную комиссию тогда обязали пересмотреть решение «с учётом указаний Генштаба ВС РФ».\\nНо многие, как погибший айтишник из «Райфайзен-банка», просто не получают времени на то, чтобы оспорить решение о мобилизации. У Путина всё под контролем, а потому солдаты нужны ему здесь и сейчас. Дать им шанс сбежать — значит лишить себя шансов на победу в бессмысленной войне.', out=False, mentioned=False, media_unread=False, silent=False, post=False, from_scheduled=False, legacy=False, edit_hide=False, pinned=False, noforwards=False, from_id=types.PeerChannel(channel_id=1647858514), fwd_from=types.MessageFwdHeader(date=1666347491, imported=False, from_id=types.PeerChannel(channel_id=1647858514), channel_post=7166, saved_from_peer=types.PeerChannel(channel_id=1647858514), saved_from_msg_id=7166), media=types.MessageMediaWebPage(webpage=types.WebPage(id=7709704822470471308, url='https://svtv.org/news/2022-10-21/v-ulianovskie-chikov-mobil-sud-otsrochka/', display_url='svtv.org/news/2022-10-21/v-ulianovskie-chikov-mobil-sud-otsrochka', hash=-1023197231, type='photo', site_name='СВТВ Либертарианское СМИ', title='В Ульяновске военкомат дал отсрочку отцу троих детей после того, как он обратился в суд — Павел Чиков', description='В Ульяновске военкомат пошёл на сделку с призывником, который подал иск в суд — передаёт Павел Чиков. У мужчины трое детей. Власти сослались на «секретные Указания Генерального штаба» ВС РФ, чтобы пообещать мобилизованному отсрочку. Как рассказал руководитель «Агоры», у Ивана Герея на содержании трое детей младше 16 лет. По закону о', photo=types.Photo(id=5952649639910027022, access_hash=8410528076299722526, file_reference=b'', date=1666346584, sizes=[types.PhotoStrippedSize(type='i', bytes=b''), types.PhotoSize(type='m', w=320, h=168, size=12429), types.PhotoSize(type='x', w=800, h=420, size=46814), types.PhotoSize(type='y', w=1200, h=630, size=62698)], dc_id=4, has_stickers=False, video_sizes=[]), cached_page=types.Page(url='https://svtv.org/news/2022-10-21/v-ulianovskie-chikov-mobil-sud-otsrochka/', blocks=[types.PageBlockCover(cover=types.PageBlockPhoto(photo_id=5950881148471193404, caption=types.PageCaption(text=types.TextEmpty(), credit=types.TextEmpty()))), types.PageBlockChannel(channel=types.Channel(id=1513669961, title='SVTV NEWS', photo=types.ChatPhoto(photo_id=5037774425646279275, dc_id=1, has_video=True, stripped_thumb=b''), date=1636394242, creator=False, left=False, broadcast=True, verified=False, megagroup=False, restricted=False, signatures=False, min=True, scam=False, has_link=True, has_geo=False, slowmode_enabled=False, call_active=False, call_not_empty=False, fake=False, gigagroup=False, noforwards=False, join_to_send=False, join_request=False, access_hash=-6192698774674749794, username='svtvnews', restriction_reason=[])), types.PageBlockTitle(text=types.TextPlain(text='В Ульяновске военкомат дал отсрочку отцу троих детей после того, как он обратился в суд — Павел Чиков')), types.PageBlockAuthorDate(author=types.TextEmpty(), published_date=1666346536), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='В Ульяновске военкомат пошёл на сделку с призывником, который подал иск в суд — '), types.TextUrl(text=types.TextPlain(text='передаёт Павел Чиков'), url='https://t.me/pchikov/5235', webpage_id=0), types.TextPlain(text='. У мужчины трое детей. Власти сослались на «'), types.TextItalic(text=types.TextPlain(text='секретные Указания Генерального штаба»')), types.TextPlain(text=' ВС РФ, чтобы пообещать мобилизованному отсрочку.')])), types.PageBlockParagraph(text=types.TextPlain(text='Как рассказал руководитель «Агоры», у Ивана Герея на содержании трое детей младше 16 лет. По закону о мобилизации, для получения отсрочки нужно минимум четверо таких детей. Тем не менее, мужчина подал иск в Засвияжский районный суд Ульяновска.')), types.PageBlockParagraph(text=types.TextPlain(text='Суд принял меры предварительной защиты и приостановил исполнение решения о призыве. Тогда военкомат согласился на сделку во внесудебном порядке.')), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='Герей отозвал своё административное исковое заявление. Как передаёт Чиков, в ответ «'), types.TextItalic(text=types.TextPlain(text='в военкомате пообещали пересмотреть решение и предоставить отсрочку от службы, опираясь на секретные Указания Генерального штаба Вооруженных Сил РФ от 04 октября 2022 года №315/2/3658дсп')), types.TextPlain(text='».')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='По словам правозащитника, правовых оснований для предоставления таких «броней» или отсрочек не существует. Такое решение легально могут принимать только законодательные органы и президент страны. Указания Генштаба «'), types.TextItalic(text=types.TextPlain(text='не могут переопределять текущее нормативно-правовое регулировани')), types.TextPlain(text='е», сообщает Чиков. Однако, отмечается, что такие меры всё же работают.')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='Недавно челябинский суд также признал незаконным мобилизацию призывника с тремя детьми. Призывную комиссию тогда обязали пересмотреть решение «'), types.TextItalic(text=types.TextPlain(text='с учётом указаний Генштаба ВС РФ')), types.TextPlain(text='».')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='Председатель комитета Госдумы по обороне Андрей Картаполов '), types.TextUrl(text=types.TextPlain(text='заявил'), url='https://tass.ru/obschestvo/16117583', webpage_id=0), types.TextPlain(text=', что «на сегодняшний день вернули по стране порядка почти 10 тысяч человек по разным причинам». Так он ответил на вопрос о мобилизованных по ошибке во время встречи с волонтёрами «ЕР».')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='В начале октября глава Хабаровского края '), types.TextUrl(text=types.TextPlain(text='признался, что половину мобилизованных вернули домой'), url='https://svtv.org/news/2022-10-03/khabarovsk-voenkom-osvobodili-polovina/', webpage_id=7709704823534883124), types.TextPlain(text=' из-за многочисленных нарушений. Это стало поводом для перевода местного военкома в Магаданскую область.')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='В Москве работника Гознака мобилизовали, когда '), types.TextUrl(text=types.TextPlain(text='он принёс справку о брони и больничном'), url='https://svtv.org/news/2022-10-18/bron-goznak-mobiliz/', webpage_id=7709704821864713697), types.TextPlain(text=' в военкомат. Документ ему просто перечеркнули. Генпрокурор РФ посоветовал ошибочно мобилизованным '), types.TextUrl(text=types.TextPlain(text='прийти в военкомат'), url='https://svtv.org/news/2022-10-12/gienieralnyi-prokuror-rossii-ighor-krasnov-rasskazal-chto-nado-dielat-niezakonno-popavshim-pod-mobilizatsiiu/', webpage_id=7709704823642672147), types.TextPlain(text=', чтобы получить освобождение.')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='Ранее отправить на фронт пытались '), types.TextUrl(text=types.TextPlain(text='инвалида второй группы'), url='https://svtv.org/news/2022-09-25/kapitonov-i-kamiery-voenkomat/', webpage_id=7709704823442188767), types.TextPlain(text=', задержав его по камерам в метро, и '), types.TextUrl(text=types.TextPlain(text='колясочника с неизлечимым заболеванием'), url='https://svtv.org/news/2022-10-09/sma-vasiliev-poviestka-4-etazh/', webpage_id=7709704822510996939), types.TextPlain(text=', который не мог бы даже подняться в кабинет к приёмной комиссии. В Пензе мобилизовали '), types.TextUrl(text=types.TextPlain(text='мужчину с больной матерью на иждивении'), url='https://t.me/svtvnews/15517', webpage_id=0), types.TextPlain(text='.')])), types.PageBlockParagraph(text=types.TextPlain(text='Наш отдел новостей каждый день отсматривает тонны пропаганды, чтобы найти среди неё крупицу правды и рассказать её вам. Помогите новостникам не сойти с ума.')), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextUrl(text=types.TextPlain(text='ПОДДЕРЖАТЬ ПРОЕКТ\\n'), url='https://svtv.org/support/', webpage_id=7709704823265455524), types.TextPlain(text='Карта любого банка или криптовалюта')]))], photos=[types.Photo(id=5950881148471193404, access_hash=3163438251273157252, file_reference=b'', date=1666346584, sizes=[types.PhotoStrippedSize(type='i', bytes=b''), types.PhotoSize(type='m', w=320, h=180, size=10917), types.PhotoSize(type='x', w=800, h=449, size=55069), types.PhotoSize(type='y', w=1280, h=719, size=143008), types.PhotoSize(type='w', w=1920, h=1079, size=229011)], dc_id=4, has_stickers=False, video_sizes=[])], documents=[], part=False, rtl=False, v2=False), attributes=[])), entities=[types.MessageEntityBold(offset=0, length=101), types.MessageEntityTextUrl(offset=110, length=11, url='https://svtv.org/news/2022-10-21/v-ulianovskie-chikov-mobil-sud-otsrochka/'), types.MessageEntityTextUrl(offset=412, length=17, url='https://t.me/svtvnews/17176?single'), types.MessageEntityTextUrl(offset=537, length=13, url='https://t.me/svtvnews/16443')], views=2, forwards=0, replies=types.MessageReplies(replies=0, replies_pts=95724, comments=False, recent_repliers=[]), restriction_reason=[]), pts=95724, pts_count=1)], users=[types.User(id=136817688, is_self=False, contact=False, mutual_contact=False, deleted=False, bot=True, bot_chat_history=False, bot_nochats=False, verified=False, restricted=False, min=False, bot_inline_geo=False, support=False, scam=False, apply_min_photo=True, fake=False, bot_attach_menu=False, premium=False, attach_menu_enabled=False, access_hash=291445910502548092, first_name='Channel', username='Channel_Bot', photo=types.UserProfilePhoto(photo_id=587627495930570665, dc_id=1, has_video=False, stripped_thumb=b''), bot_info_version=4, restriction_reason=[])], chats=[types.Channel(id=1269890003, title='Чат SVTV NEWS Free', photo=types.ChatPhoto(photo_id=5391297921128972228, dc_id=2, has_video=False, stripped_thumb=b''), date=1666290863, creator=False, left=False, broadcast=False, verified=False, megagroup=True, restricted=False, signatures=False, min=False, scam=False, has_link=True, has_geo=False, slowmode_enabled=False, call_active=False, call_not_empty=False, fake=False, gigagroup=False, noforwards=False, join_to_send=False, join_request=False, access_hash=-1641089314234313153, restriction_reason=[], default_banned_rights=types.ChatBannedRights(until_date=2147483647, view_messages=False, send_messages=False, send_media=False, send_stickers=False, send_gifs=False, send_games=False, send_inline=False, embed_links=False, send_polls=False, change_info=True, invite_users=False, pin_messages=True)), types.Channel(id=1647858514, title='SVTV NEWS Free', photo=types.ChatPhoto(photo_id=5882112872316778690, dc_id=4, has_video=False, stripped_thumb=b''), date=1664896973, creator=False, left=False, broadcast=True, verified=False, megagroup=False, restricted=False, signatures=False, min=False, scam=False, has_link=True, has_geo=False, slowmode_enabled=False, call_active=False, call_not_empty=False, fake=False, gigagroup=False, noforwards=False, join_to_send=False, join_request=False, access_hash=-7566577635619473865, username='svtvnewsfree', restriction_reason=[])], date=1666347493, seq=0),
    types.Updates(updates=[types.UpdateEditChannelMessage(message=types.Message(id=7166, peer_id=types.PeerChannel(channel_id=1647858514), date=1666347491, message='В Ульяновске военкомат дал отсрочку отцу троих детей после того, как он обратился в суд — Павел Чиков\\nВласти согласились предоставить отсрочку призывнику, сославшись на «секретные Указания Генерального штаба» ВС РФ.\\nНедавно челябинский суд также признал незаконным мобилизацию призывника с тремя детьми. Призывную комиссию тогда обязали пересмотреть решение «с учётом указаний Генштаба ВС РФ».\\nНо многие, как погибший айтишник из «Райфайзен-банка», просто не получают времени на то, чтобы оспорить решение о мобилизации. У Путина всё под контролем, а потому солдаты нужны ему здесь и сейчас. Дать им шанс сбежать — значит лишить себя шансов на победу в бессмысленной войне.', out=False, mentioned=False, media_unread=False, silent=False, post=True, from_scheduled=False, legacy=False, edit_hide=True, pinned=False, noforwards=False, media=types.MessageMediaWebPage(webpage=types.WebPage(id=7709704822470471308, url='https://svtv.org/news/2022-10-21/v-ulianovskie-chikov-mobil-sud-otsrochka/', display_url='svtv.org/news/2022-10-21/v-ulianovskie-chikov-mobil-sud-otsrochka', hash=-1023197231, type='photo', site_name='СВТВ Либертарианское СМИ', title='В Ульяновске военкомат дал отсрочку отцу троих детей после того, как он обратился в суд — Павел Чиков', description='В Ульяновске военкомат пошёл на сделку с призывником, который подал иск в суд — передаёт Павел Чиков. У мужчины трое детей. Власти сослались на «секретные Указания Генерального штаба» ВС РФ, чтобы пообещать мобилизованному отсрочку. Как рассказал руководитель «Агоры», у Ивана Герея на содержании трое детей младше 16 лет. По закону о', photo=types.Photo(id=5952649639910027022, access_hash=8644289735331141346, file_reference=b'', date=1666346584, sizes=[types.PhotoStrippedSize(type='i', bytes=b''), types.PhotoSize(type='m', w=320, h=168, size=12429), types.PhotoSize(type='x', w=800, h=420, size=46814), types.PhotoSize(type='y', w=1200, h=630, size=62698)], dc_id=4, has_stickers=False, video_sizes=[]), cached_page=types.Page(url='https://svtv.org/news/2022-10-21/v-ulianovskie-chikov-mobil-sud-otsrochka/', blocks=[types.PageBlockCover(cover=types.PageBlockPhoto(photo_id=5950881148471193404, caption=types.PageCaption(text=types.TextEmpty(), credit=types.TextEmpty()))), types.PageBlockChannel(channel=types.Channel(id=1513669961, title='SVTV NEWS', photo=types.ChatPhoto(photo_id=5037774425646279275, dc_id=1, has_video=True, stripped_thumb=b''), date=1636394242, creator=False, left=False, broadcast=True, verified=False, megagroup=False, restricted=False, signatures=False, min=True, scam=False, has_link=True, has_geo=False, slowmode_enabled=False, call_active=False, call_not_empty=False, fake=False, gigagroup=False, noforwards=False, join_to_send=False, join_request=False, access_hash=-6192698774674749794, username='svtvnews', restriction_reason=[])), types.PageBlockTitle(text=types.TextPlain(text='В Ульяновске военкомат дал отсрочку отцу троих детей после того, как он обратился в суд — Павел Чиков')), types.PageBlockAuthorDate(author=types.TextEmpty(), published_date=1666346536), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='В Ульяновске военкомат пошёл на сделку с призывником, который подал иск в суд — '), types.TextUrl(text=types.TextPlain(text='передаёт Павел Чиков'), url='https://t.me/pchikov/5235', webpage_id=0), types.TextPlain(text='. У мужчины трое детей. Власти сослались на «'), types.TextItalic(text=types.TextPlain(text='секретные Указания Генерального штаба»')), types.TextPlain(text=' ВС РФ, чтобы пообещать мобилизованному отсрочку.')])), types.PageBlockParagraph(text=types.TextPlain(text='Как рассказал руководитель «Агоры», у Ивана Герея на содержании трое детей младше 16 лет. По закону о мобилизации, для получения отсрочки нужно минимум четверо таких детей. Тем не менее, мужчина подал иск в Засвияжский районный суд Ульяновска.')), types.PageBlockParagraph(text=types.TextPlain(text='Суд принял меры предварительной защиты и приостановил исполнение решения о призыве. Тогда военкомат согласился на сделку во внесудебном порядке.')), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='Герей отозвал своё административное исковое заявление. Как передаёт Чиков, в ответ «'), types.TextItalic(text=types.TextPlain(text='в военкомате пообещали пересмотреть решение и предоставить отсрочку от службы, опираясь на секретные Указания Генерального штаба Вооруженных Сил РФ от 04 октября 2022 года №315/2/3658дсп')), types.TextPlain(text='».')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='По словам правозащитника, правовых оснований для предоставления таких «броней» или отсрочек не существует. Такое решение легально могут принимать только законодательные органы и президент страны. Указания Генштаба «'), types.TextItalic(text=types.TextPlain(text='не могут переопределять текущее нормативно-правовое регулировани')), types.TextPlain(text='е», сообщает Чиков. Однако, отмечается, что такие меры всё же работают.')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='Недавно челябинский суд также признал незаконным мобилизацию призывника с тремя детьми. Призывную комиссию тогда обязали пересмотреть решение «'), types.TextItalic(text=types.TextPlain(text='с учётом указаний Генштаба ВС РФ')), types.TextPlain(text='».')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='Председатель комитета Госдумы по обороне Андрей Картаполов '), types.TextUrl(text=types.TextPlain(text='заявил'), url='https://tass.ru/obschestvo/16117583', webpage_id=0), types.TextPlain(text=', что «на сегодняшний день вернули по стране порядка почти 10 тысяч человек по разным причинам». Так он ответил на вопрос о мобилизованных по ошибке во время встречи с волонтёрами «ЕР».')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='В начале октября глава Хабаровского края '), types.TextUrl(text=types.TextPlain(text='признался, что половину мобилизованных вернули домой'), url='https://svtv.org/news/2022-10-03/khabarovsk-voenkom-osvobodili-polovina/', webpage_id=7709704823534883124), types.TextPlain(text=' из-за многочисленных нарушений. Это стало поводом для перевода местного военкома в Магаданскую область.')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='В Москве работника Гознака мобилизовали, когда '), types.TextUrl(text=types.TextPlain(text='он принёс справку о брони и больничном'), url='https://svtv.org/news/2022-10-18/bron-goznak-mobiliz/', webpage_id=7709704821864713697), types.TextPlain(text=' в военкомат. Документ ему просто перечеркнули. Генпрокурор РФ посоветовал ошибочно мобилизованным '), types.TextUrl(text=types.TextPlain(text='прийти в военкомат'), url='https://svtv.org/news/2022-10-12/gienieralnyi-prokuror-rossii-ighor-krasnov-rasskazal-chto-nado-dielat-niezakonno-popavshim-pod-mobilizatsiiu/', webpage_id=7709704823642672147), types.TextPlain(text=', чтобы получить освобождение.')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='Ранее отправить на фронт пытались '), types.TextUrl(text=types.TextPlain(text='инвалида второй группы'), url='https://svtv.org/news/2022-09-25/kapitonov-i-kamiery-voenkomat/', webpage_id=7709704823442188767), types.TextPlain(text=', задержав его по камерам в метро, и '), types.TextUrl(text=types.TextPlain(text='колясочника с неизлечимым заболеванием'), url='https://svtv.org/news/2022-10-09/sma-vasiliev-poviestka-4-etazh/', webpage_id=7709704822510996939), types.TextPlain(text=', который не мог бы даже подняться в кабинет к приёмной комиссии. В Пензе мобилизовали '), types.TextUrl(text=types.TextPlain(text='мужчину с больной матерью на иждивении'), url='https://t.me/svtvnews/15517', webpage_id=0), types.TextPlain(text='.')])), types.PageBlockParagraph(text=types.TextPlain(text='Наш отдел новостей каждый день отсматривает тонны пропаганды, чтобы найти среди неё крупицу правды и рассказать её вам. Помогите новостникам не сойти с ума.')), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextUrl(text=types.TextPlain(text='ПОДДЕРЖАТЬ ПРОЕКТ\\n'), url='https://svtv.org/support/', webpage_id=7709704823265455524), types.TextPlain(text='Карта любого банка или криптовалюта')]))], photos=[types.Photo(id=5950881148471193404, access_hash=-2639209488335026044, file_reference=b'', date=1666346584, sizes=[types.PhotoStrippedSize(type='i', bytes=b''), types.PhotoSize(type='m', w=320, h=180, size=10917), types.PhotoSize(type='x', w=800, h=449, size=55069), types.PhotoSize(type='y', w=1280, h=719, size=143008), types.PhotoSize(type='w', w=1920, h=1079, size=229011)], dc_id=4, has_stickers=False, video_sizes=[])], documents=[], part=False, rtl=False, v2=False), attributes=[])), entities=[types.MessageEntityBold(offset=0, length=101), types.MessageEntityTextUrl(offset=110, length=11, url='https://svtv.org/news/2022-10-21/v-ulianovskie-chikov-mobil-sud-otsrochka/'), types.MessageEntityTextUrl(offset=412, length=17, url='https://t.me/svtvnews/17176?single'), types.MessageEntityTextUrl(offset=537, length=13, url='https://t.me/svtvnews/16443')], views=2, forwards=0, replies=types.MessageReplies(replies=0, replies_pts=95725, comments=True, recent_repliers=[], channel_id=1269890003), edit_date=1666347494, restriction_reason=[]), pts=20314, pts_count=1)], users=[types.User(id=136817688, is_self=False, contact=False, mutual_contact=False, deleted=False, bot=True, bot_chat_history=False, bot_nochats=False, verified=False, restricted=False, min=True, bot_inline_geo=False, support=False, scam=False, apply_min_photo=True, fake=False, bot_attach_menu=False, premium=False, attach_menu_enabled=False, access_hash=1953598452476464818, first_name='Channel', username='Channel_Bot', photo=types.UserProfilePhoto(photo_id=587627495930570665, dc_id=1, has_video=False, stripped_thumb=b''), bot_info_version=4, restriction_reason=[])], chats=[types.Channel(id=1647858514, title='SVTV NEWS Free', photo=types.ChatPhoto(photo_id=5882112872316778690, dc_id=4, has_video=False, stripped_thumb=b''), date=1655754612, creator=False, left=False, broadcast=True, verified=False, megagroup=False, restricted=False, signatures=False, min=True, scam=False, has_link=True, has_geo=False, slowmode_enabled=False, call_active=False, call_not_empty=False, fake=False, gigagroup=False, noforwards=False, join_to_send=False, join_request=False, access_hash=-7938697320137857505, username='svtvnewsfree', restriction_reason=[])], date=1666347494, seq=0),
    types.Updates(updates=[types.UpdateEditChannelMessage(message=types.Message(id=7166, peer_id=types.PeerChannel(channel_id=1647858514), date=1666347491, message='В Ульяновске военкомат дал отсрочку отцу троих детей после того, как он обратился в суд — Павел Чиков\\nВласти согласились предоставить отсрочку призывнику, сославшись на «секретные Указания Генерального штаба» ВС РФ.\\nНедавно челябинский суд также признал незаконным мобилизацию призывника с тремя детьми. Призывную комиссию тогда обязали пересмотреть решение «с учётом указаний Генштаба ВС РФ».\\nНо многие, как погибший айтишник из «Райфайзен-банка», просто не получают времени на то, чтобы оспорить решение о мобилизации. У Путина всё под контролем, а потому солдаты нужны ему здесь и сейчас. Дать им шанс сбежать — значит лишить себя шансов на победу в бессмысленной войне.', out=False, mentioned=False, media_unread=False, silent=False, post=True, from_scheduled=False, legacy=False, edit_hide=True, pinned=False, noforwards=False, media=types.MessageMediaWebPage(webpage=types.WebPage(id=7709704822470471308, url='https://svtv.org/news/2022-10-21/v-ulianovskie-chikov-mobil-sud-otsrochka/', display_url='svtv.org/news/2022-10-21/v-ulianovskie-chikov-mobil-sud-otsrochka', hash=-1023197231, type='photo', site_name='СВТВ Либертарианское СМИ', title='В Ульяновске военкомат дал отсрочку отцу троих детей после того, как он обратился в суд — Павел Чиков', description='В Ульяновске военкомат пошёл на сделку с призывником, который подал иск в суд — передаёт Павел Чиков. У мужчины трое детей. Власти сослались на «секретные Указания Генерального штаба» ВС РФ, чтобы пообещать мобилизованному отсрочку. Как рассказал руководитель «Агоры», у Ивана Герея на содержании трое детей младше 16 лет. По закону о', photo=types.Photo(id=5952649639910027022, access_hash=8644289735331141346, file_reference=b'', date=1666346584, sizes=[types.PhotoStrippedSize(type='i', bytes=b''), types.PhotoSize(type='m', w=320, h=168, size=12429), types.PhotoSize(type='x', w=800, h=420, size=46814), types.PhotoSize(type='y', w=1200, h=630, size=62698)], dc_id=4, has_stickers=False, video_sizes=[]), cached_page=types.Page(url='https://svtv.org/news/2022-10-21/v-ulianovskie-chikov-mobil-sud-otsrochka/', blocks=[types.PageBlockCover(cover=types.PageBlockPhoto(photo_id=5950881148471193404, caption=types.PageCaption(text=types.TextEmpty(), credit=types.TextEmpty()))), types.PageBlockChannel(channel=types.Channel(id=1513669961, title='SVTV NEWS', photo=types.ChatPhoto(photo_id=5037774425646279275, dc_id=1, has_video=True, stripped_thumb=b''), date=1636394242, creator=False, left=False, broadcast=True, verified=False, megagroup=False, restricted=False, signatures=False, min=True, scam=False, has_link=True, has_geo=False, slowmode_enabled=False, call_active=False, call_not_empty=False, fake=False, gigagroup=False, noforwards=False, join_to_send=False, join_request=False, access_hash=-6192698774674749794, username='svtvnews', restriction_reason=[])), types.PageBlockTitle(text=types.TextPlain(text='В Ульяновске военкомат дал отсрочку отцу троих детей после того, как он обратился в суд — Павел Чиков')), types.PageBlockAuthorDate(author=types.TextEmpty(), published_date=1666346536), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='В Ульяновске военкомат пошёл на сделку с призывником, который подал иск в суд — '), types.TextUrl(text=types.TextPlain(text='передаёт Павел Чиков'), url='https://t.me/pchikov/5235', webpage_id=0), types.TextPlain(text='. У мужчины трое детей. Власти сослались на «'), types.TextItalic(text=types.TextPlain(text='секретные Указания Генерального штаба»')), types.TextPlain(text=' ВС РФ, чтобы пообещать мобилизованному отсрочку.')])), types.PageBlockParagraph(text=types.TextPlain(text='Как рассказал руководитель «Агоры», у Ивана Герея на содержании трое детей младше 16 лет. По закону о мобилизации, для получения отсрочки нужно минимум четверо таких детей. Тем не менее, мужчина подал иск в Засвияжский районный суд Ульяновска.')), types.PageBlockParagraph(text=types.TextPlain(text='Суд принял меры предварительной защиты и приостановил исполнение решения о призыве. Тогда военкомат согласился на сделку во внесудебном порядке.')), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='Герей отозвал своё административное исковое заявление. Как передаёт Чиков, в ответ «'), types.TextItalic(text=types.TextPlain(text='в военкомате пообещали пересмотреть решение и предоставить отсрочку от службы, опираясь на секретные Указания Генерального штаба Вооруженных Сил РФ от 04 октября 2022 года №315/2/3658дсп')), types.TextPlain(text='».')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='По словам правозащитника, правовых оснований для предоставления таких «броней» или отсрочек не существует. Такое решение легально могут принимать только законодательные органы и президент страны. Указания Генштаба «'), types.TextItalic(text=types.TextPlain(text='не могут переопределять текущее нормативно-правовое регулировани')), types.TextPlain(text='е», сообщает Чиков. Однако, отмечается, что такие меры всё же работают.')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='Недавно челябинский суд также признал незаконным мобилизацию призывника с тремя детьми. Призывную комиссию тогда обязали пересмотреть решение «'), types.TextItalic(text=types.TextPlain(text='с учётом указаний Генштаба ВС РФ')), types.TextPlain(text='».')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='Председатель комитета Госдумы по обороне Андрей Картаполов '), types.TextUrl(text=types.TextPlain(text='заявил'), url='https://tass.ru/obschestvo/16117583', webpage_id=0), types.TextPlain(text=', что «на сегодняшний день вернули по стране порядка почти 10 тысяч человек по разным причинам». Так он ответил на вопрос о мобилизованных по ошибке во время встречи с волонтёрами «ЕР».')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='В начале октября глава Хабаровского края '), types.TextUrl(text=types.TextPlain(text='признался, что половину мобилизованных вернули домой'), url='https://svtv.org/news/2022-10-03/khabarovsk-voenkom-osvobodili-polovina/', webpage_id=7709704823534883124), types.TextPlain(text=' из-за многочисленных нарушений. Это стало поводом для перевода местного военкома в Магаданскую область.')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='В Москве работника Гознака мобилизовали, когда '), types.TextUrl(text=types.TextPlain(text='он принёс справку о брони и больничном'), url='https://svtv.org/news/2022-10-18/bron-goznak-mobiliz/', webpage_id=7709704821864713697), types.TextPlain(text=' в военкомат. Документ ему просто перечеркнули. Генпрокурор РФ посоветовал ошибочно мобилизованным '), types.TextUrl(text=types.TextPlain(text='прийти в военкомат'), url='https://svtv.org/news/2022-10-12/gienieralnyi-prokuror-rossii-ighor-krasnov-rasskazal-chto-nado-dielat-niezakonno-popavshim-pod-mobilizatsiiu/', webpage_id=7709704823642672147), types.TextPlain(text=', чтобы получить освобождение.')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='Ранее отправить на фронт пытались '), types.TextUrl(text=types.TextPlain(text='инвалида второй группы'), url='https://svtv.org/news/2022-09-25/kapitonov-i-kamiery-voenkomat/', webpage_id=7709704823442188767), types.TextPlain(text=', задержав его по камерам в метро, и '), types.TextUrl(text=types.TextPlain(text='колясочника с неизлечимым заболеванием'), url='https://svtv.org/news/2022-10-09/sma-vasiliev-poviestka-4-etazh/', webpage_id=7709704822510996939), types.TextPlain(text=', который не мог бы даже подняться в кабинет к приёмной комиссии. В Пензе мобилизовали '), types.TextUrl(text=types.TextPlain(text='мужчину с больной матерью на иждивении'), url='https://t.me/svtvnews/15517', webpage_id=0), types.TextPlain(text='.')])), types.PageBlockParagraph(text=types.TextPlain(text='Наш отдел новостей каждый день отсматривает тонны пропаганды, чтобы найти среди неё крупицу правды и рассказать её вам. Помогите новостникам не сойти с ума.')), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextUrl(text=types.TextPlain(text='ПОДДЕРЖАТЬ ПРОЕКТ\\n'), url='https://svtv.org/support/', webpage_id=7709704823265455524), types.TextPlain(text='Карта любого банка или криптовалюта')]))], photos=[types.Photo(id=5950881148471193404, access_hash=-2639209488335026044, file_reference=b'', date=1666346584, sizes=[types.PhotoStrippedSize(type='i', bytes=b''), types.PhotoSize(type='m', w=320, h=180, size=10917), types.PhotoSize(type='x', w=800, h=449, size=55069), types.PhotoSize(type='y', w=1280, h=719, size=143008), types.PhotoSize(type='w', w=1920, h=1079, size=229011)], dc_id=4, has_stickers=False, video_sizes=[])], documents=[], part=False, rtl=False, v2=False), attributes=[])), entities=[types.MessageEntityBold(offset=0, length=101), types.MessageEntityTextUrl(offset=110, length=11, url='https://svtv.org/news/2022-10-21/v-ulianovskie-chikov-mobil-sud-otsrochka/'), types.MessageEntityTextUrl(offset=412, length=17, url='https://t.me/svtvnews/17176?single'), types.MessageEntityTextUrl(offset=537, length=13, url='https://t.me/svtvnews/16443')], views=35, forwards=1, replies=types.MessageReplies(replies=0, replies_pts=95727, comments=True, recent_repliers=[], channel_id=1269890003), edit_date=1666347828, reactions=types.MessageReactions(results=[], min=True, can_see_list=False, recent_reactions=[]), restriction_reason=[]), pts=20315, pts_count=1)], users=[types.User(id=136817688, is_self=False, contact=False, mutual_contact=False, deleted=False, bot=True, bot_chat_history=False, bot_nochats=False, verified=False, restricted=False, min=True, bot_inline_geo=False, support=False, scam=False, apply_min_photo=True, fake=False, bot_attach_menu=False, premium=False, attach_menu_enabled=False, access_hash=1953598452476464818, first_name='Channel', username='Channel_Bot', photo=types.UserProfilePhoto(photo_id=587627495930570665, dc_id=1, has_video=False, stripped_thumb=b''), bot_info_version=4, restriction_reason=[])], chats=[types.Channel(id=1647858514, title='SVTV NEWS Free', photo=types.ChatPhoto(photo_id=5882112872316778690, dc_id=4, has_video=False, stripped_thumb=b''), date=1655754612, creator=False, left=False, broadcast=True, verified=False, megagroup=False, restricted=False, signatures=False, min=True, scam=False, has_link=True, has_geo=False, slowmode_enabled=False, call_active=False, call_not_empty=False, fake=False, gigagroup=False, noforwards=False, join_to_send=False, join_request=False, access_hash=-7938697320137857505, username='svtvnewsfree', restriction_reason=[])], date=1666347828, seq=0),
    types.Updates(updates=[types.UpdateEditChannelMessage(message=types.Message(id=51879, peer_id=types.PeerChannel(channel_id=1269890003), date=1666347494, message='В Ульяновске военкомат дал отсрочку отцу троих детей после того, как он обратился в суд — Павел Чиков\\nВласти согласились предоставить отсрочку призывнику, сославшись на «секретные Указания Генерального штаба» ВС РФ.\\nНедавно челябинский суд также признал незаконным мобилизацию призывника с тремя детьми. Призывную комиссию тогда обязали пересмотреть решение «с учётом указаний Генштаба ВС РФ».\\nНо многие, как погибший айтишник из «Райфайзен-банка», просто не получают времени на то, чтобы оспорить решение о мобилизации. У Путина всё под контролем, а потому солдаты нужны ему здесь и сейчас. Дать им шанс сбежать — значит лишить себя шансов на победу в бессмысленной войне.', out=False, mentioned=False, media_unread=False, silent=False, post=False, from_scheduled=False, legacy=False, edit_hide=True, pinned=True, noforwards=False, from_id=types.PeerChannel(channel_id=1647858514), fwd_from=types.MessageFwdHeader(date=1666347491, imported=False, from_id=types.PeerChannel(channel_id=1647858514), channel_post=7166, saved_from_peer=types.PeerChannel(channel_id=1647858514), saved_from_msg_id=7166), media=types.MessageMediaWebPage(webpage=types.WebPage(id=7709704822470471308, url='https://svtv.org/news/2022-10-21/v-ulianovskie-chikov-mobil-sud-otsrochka/', display_url='svtv.org/news/2022-10-21/v-ulianovskie-chikov-mobil-sud-otsrochka', hash=-1023197231, type='photo', site_name='СВТВ Либертарианское СМИ', title='В Ульяновске военкомат дал отсрочку отцу троих детей после того, как он обратился в суд — Павел Чиков', description='В Ульяновске военкомат пошёл на сделку с призывником, который подал иск в суд — передаёт Павел Чиков. У мужчины трое детей. Власти сослались на «секретные Указания Генерального штаба» ВС РФ, чтобы пообещать мобилизованному отсрочку. Как рассказал руководитель «Агоры», у Ивана Герея на содержании трое детей младше 16 лет. По закону о', photo=types.Photo(id=5952649639910027022, access_hash=8410528076299722526, file_reference=b'', date=1666346584, sizes=[types.PhotoStrippedSize(type='i', bytes=b''), types.PhotoSize(type='m', w=320, h=168, size=12429), types.PhotoSize(type='x', w=800, h=420, size=46814), types.PhotoSize(type='y', w=1200, h=630, size=62698)], dc_id=4, has_stickers=False, video_sizes=[]), cached_page=types.Page(url='https://svtv.org/news/2022-10-21/v-ulianovskie-chikov-mobil-sud-otsrochka/', blocks=[types.PageBlockCover(cover=types.PageBlockPhoto(photo_id=5950881148471193404, caption=types.PageCaption(text=types.TextEmpty(), credit=types.TextEmpty()))), types.PageBlockChannel(channel=types.Channel(id=1513669961, title='SVTV NEWS', photo=types.ChatPhoto(photo_id=5037774425646279275, dc_id=1, has_video=True, stripped_thumb=b''), date=1636394242, creator=False, left=False, broadcast=True, verified=False, megagroup=False, restricted=False, signatures=False, min=True, scam=False, has_link=True, has_geo=False, slowmode_enabled=False, call_active=False, call_not_empty=False, fake=False, gigagroup=False, noforwards=False, join_to_send=False, join_request=False, access_hash=-6192698774674749794, username='svtvnews', restriction_reason=[])), types.PageBlockTitle(text=types.TextPlain(text='В Ульяновске военкомат дал отсрочку отцу троих детей после того, как он обратился в суд — Павел Чиков')), types.PageBlockAuthorDate(author=types.TextEmpty(), published_date=1666346536), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='В Ульяновске военкомат пошёл на сделку с призывником, который подал иск в суд — '), types.TextUrl(text=types.TextPlain(text='передаёт Павел Чиков'), url='https://t.me/pchikov/5235', webpage_id=0), types.TextPlain(text='. У мужчины трое детей. Власти сослались на «'), types.TextItalic(text=types.TextPlain(text='секретные Указания Генерального штаба»')), types.TextPlain(text=' ВС РФ, чтобы пообещать мобилизованному отсрочку.')])), types.PageBlockParagraph(text=types.TextPlain(text='Как рассказал руководитель «Агоры», у Ивана Герея на содержании трое детей младше 16 лет. По закону о мобилизации, для получения отсрочки нужно минимум четверо таких детей. Тем не менее, мужчина подал иск в Засвияжский районный суд Ульяновска.')), types.PageBlockParagraph(text=types.TextPlain(text='Суд принял меры предварительной защиты и приостановил исполнение решения о призыве. Тогда военкомат согласился на сделку во внесудебном порядке.')), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='Герей отозвал своё административное исковое заявление. Как передаёт Чиков, в ответ «'), types.TextItalic(text=types.TextPlain(text='в военкомате пообещали пересмотреть решение и предоставить отсрочку от службы, опираясь на секретные Указания Генерального штаба Вооруженных Сил РФ от 04 октября 2022 года №315/2/3658дсп')), types.TextPlain(text='».')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='По словам правозащитника, правовых оснований для предоставления таких «броней» или отсрочек не существует. Такое решение легально могут принимать только законодательные органы и президент страны. Указания Генштаба «'), types.TextItalic(text=types.TextPlain(text='не могут переопределять текущее нормативно-правовое регулировани')), types.TextPlain(text='е», сообщает Чиков. Однако, отмечается, что такие меры всё же работают.')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='Недавно челябинский суд также признал незаконным мобилизацию призывника с тремя детьми. Призывную комиссию тогда обязали пересмотреть решение «'), types.TextItalic(text=types.TextPlain(text='с учётом указаний Генштаба ВС РФ')), types.TextPlain(text='».')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='Председатель комитета Госдумы по обороне Андрей Картаполов '), types.TextUrl(text=types.TextPlain(text='заявил'), url='https://tass.ru/obschestvo/16117583', webpage_id=0), types.TextPlain(text=', что «на сегодняшний день вернули по стране порядка почти 10 тысяч человек по разным причинам». Так он ответил на вопрос о мобилизованных по ошибке во время встречи с волонтёрами «ЕР».')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='В начале октября глава Хабаровского края '), types.TextUrl(text=types.TextPlain(text='признался, что половину мобилизованных вернули домой'), url='https://svtv.org/news/2022-10-03/khabarovsk-voenkom-osvobodili-polovina/', webpage_id=7709704823534883124), types.TextPlain(text=' из-за многочисленных нарушений. Это стало поводом для перевода местного военкома в Магаданскую область.')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='В Москве работника Гознака мобилизовали, когда '), types.TextUrl(text=types.TextPlain(text='он принёс справку о брони и больничном'), url='https://svtv.org/news/2022-10-18/bron-goznak-mobiliz/', webpage_id=7709704821864713697), types.TextPlain(text=' в военкомат. Документ ему просто перечеркнули. Генпрокурор РФ посоветовал ошибочно мобилизованным '), types.TextUrl(text=types.TextPlain(text='прийти в военкомат'), url='https://svtv.org/news/2022-10-12/gienieralnyi-prokuror-rossii-ighor-krasnov-rasskazal-chto-nado-dielat-niezakonno-popavshim-pod-mobilizatsiiu/', webpage_id=7709704823642672147), types.TextPlain(text=', чтобы получить освобождение.')])), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextPlain(text='Ранее отправить на фронт пытались '), types.TextUrl(text=types.TextPlain(text='инвалида второй группы'), url='https://svtv.org/news/2022-09-25/kapitonov-i-kamiery-voenkomat/', webpage_id=7709704823442188767), types.TextPlain(text=', задержав его по камерам в метро, и '), types.TextUrl(text=types.TextPlain(text='колясочника с неизлечимым заболеванием'), url='https://svtv.org/news/2022-10-09/sma-vasiliev-poviestka-4-etazh/', webpage_id=7709704822510996939), types.TextPlain(text=', который не мог бы даже подняться в кабинет к приёмной комиссии. В Пензе мобилизовали '), types.TextUrl(text=types.TextPlain(text='мужчину с больной матерью на иждивении'), url='https://t.me/svtvnews/15517', webpage_id=0), types.TextPlain(text='.')])), types.PageBlockParagraph(text=types.TextPlain(text='Наш отдел новостей каждый день отсматривает тонны пропаганды, чтобы найти среди неё крупицу правды и рассказать её вам. Помогите новостникам не сойти с ума.')), types.PageBlockParagraph(text=types.TextConcat(texts=[types.TextUrl(text=types.TextPlain(text='ПОДДЕРЖАТЬ ПРОЕКТ\\n'), url='https://svtv.org/support/', webpage_id=7709704823265455524), types.TextPlain(text='Карта любого банка или криптовалюта')]))], photos=[types.Photo(id=5950881148471193404, access_hash=3163438251273157252, file_reference=b'', date=1666346584, sizes=[types.PhotoStrippedSize(type='i', bytes=b''), types.PhotoSize(type='m', w=320, h=180, size=10917), types.PhotoSize(type='x', w=800, h=449, size=55069), types.PhotoSize(type='y', w=1280, h=719, size=143008), types.PhotoSize(type='w', w=1920, h=1079, size=229011)], dc_id=4, has_stickers=False, video_sizes=[])], documents=[], part=False, rtl=False, v2=False), attributes=[])), entities=[types.MessageEntityBold(offset=0, length=101), types.MessageEntityTextUrl(offset=110, length=11, url='https://svtv.org/news/2022-10-21/v-ulianovskie-chikov-mobil-sud-otsrochka/'), types.MessageEntityTextUrl(offset=412, length=17, url='https://t.me/svtvnews/17176?single'), types.MessageEntityTextUrl(offset=537, length=13, url='https://t.me/svtvnews/16443')], views=35, forwards=1, replies=types.MessageReplies(replies=0, replies_pts=95727, comments=False, recent_repliers=[]), edit_date=1666347828, reactions=types.MessageReactions(results=[], min=False, can_see_list=False, recent_reactions=[]), restriction_reason=[]), pts=95727, pts_count=2)], users=[types.User(id=136817688, is_self=False, contact=False, mutual_contact=False, deleted=False, bot=True, bot_chat_history=False, bot_nochats=False, verified=False, restricted=False, min=False, bot_inline_geo=False, support=False, scam=False, apply_min_photo=True, fake=False, bot_attach_menu=False, premium=False, attach_menu_enabled=False, access_hash=291445910502548092, first_name='Channel', username='Channel_Bot', photo=types.UserProfilePhoto(photo_id=587627495930570665, dc_id=1, has_video=False, stripped_thumb=b''), bot_info_version=4, restriction_reason=[])], chats=[types.Channel(id=1269890003, title='Чат SVTV NEWS Free', photo=types.ChatPhoto(photo_id=5391297921128972228, dc_id=2, has_video=False, stripped_thumb=b''), date=1666290863, creator=False, left=False, broadcast=False, verified=False, megagroup=True, restricted=False, signatures=False, min=False, scam=False, has_link=True, has_geo=False, slowmode_enabled=False, call_active=False, call_not_empty=False, fake=False, gigagroup=False, noforwards=False, join_to_send=False, join_request=False, access_hash=-1641089314234313153, restriction_reason=[], default_banned_rights=types.ChatBannedRights(until_date=2147483647, view_messages=False, send_messages=False, send_media=False, send_stickers=False, send_gifs=False, send_games=False, send_inline=False, embed_links=False, send_polls=False, change_info=True, invite_users=False, pin_messages=True)), types.Channel(id=1647858514, title='SVTV NEWS Free', photo=types.ChatPhoto(photo_id=5882112872316778690, dc_id=4, has_video=False, stripped_thumb=b''), date=1664896973, creator=False, left=False, broadcast=True, verified=False, megagroup=False, restricted=False, signatures=False, min=False, scam=False, has_link=True, has_geo=False, slowmode_enabled=False, call_active=False, call_not_empty=False, fake=False, gigagroup=False, noforwards=False, join_to_send=False, join_request=False, access_hash=-7566577635619473865, username='svtvnewsfree', restriction_reason=[])], date=1666347827, seq=0),
    types.UpdateShort(update=types.UpdateMessagePoll(poll_id=5350515604174406035, results=types.PollResults(min=True, results=[types.PollAnswerVoters(option=b'', voters=766, chosen=False, correct=False), types.PollAnswerVoters(option=b'', voters=1637, chosen=False, correct=False), types.PollAnswerVoters(option=b'', voters=587, chosen=False, correct=False)], total_voters=2990, recent_voters=[], solution_entities=[])), date=1666347925),
    types.UpdateShort(update=types.UpdateChannelMessageViews(channel_id=1710046483, id=2636, views=63), date=1666348143),
    types.Updates(updates=[types.UpdateNewChannelMessage(message=types.Message(id=7167, peer_id=types.PeerChannel(channel_id=1647858514), date=1666348632, message='ФБК добавили в свой санкционный список Венедиктова и других участников внедрения системы электронного голосования\\n«Они сознательно создали инструмент, который используется властью для прямых фальсификаций в крупнейшем регионе страны и полностью непрозрачен для общественного контроля», — говорится в сообщении фонда.\\nПомимо бывшего главреда «Эха Москвы» в списке значатся фигурант расследования о коррупции вице-премьер Татьяна Голикова, сотрудник АП и директор авиакомпаний, которые сотрудничают с Министерством обороны, а также новый командующий объединённой группировкой путинских войск в Украине Сергей Суровикин.\\nРанее составители списка учли критику и вернули в него создателей системы цифровой слежки из компании NTechLab, ответственных за то, что мужчинам теперь нельзя свободно передвигаться по Москве. Мы неоднократно говорили и о том, что список «разжигателей войны» выглядит посмешищем, пока в нём не находится Алексей Венедиктов, усилиями которого выборы в России  окончательно стали формальностью.\\nОлег Кашин, с самого начала вторжения в Украину выступавший против войны, всё ещё включён в список ФБК. Мы надеемся, что и это решение будет в конце концов пересмотрено.', out=False, mentioned=False, media_unread=False, silent=False, post=True, from_scheduled=False, legacy=False, edit_hide=False, pinned=False, noforwards=False, media=types.MessageMediaWebPage(webpage=types.WebPage(id=9170793120728340119, url='https://t.me/svtvnews/16154', display_url='t.me/svtvnews/16154', hash=-270650917, type='telegram_album', site_name='Telegram', title='SVTV NEWS', description='ФБК вернул создателей системы цифровой слежки Артёма Кухаренко и Александра Кабакова  в список «разжигателей войны»\\nОни стоят за компанией NTechLab, которая по заказу российских силовиков разработала систему тотальной слежки и распознавания лиц. Эта система используется государством для отлова уклонистов и оппозиционеров.\\nСами Кабаков и Кухаренко из созданного ими техно-рая сбежали, и, раскаявшись, обратились к ФБК за индульгенцией. Леонид Волков тогда объявил, что наказывать их сильнее, чем они сами себя наказали, поработав на государство, смысла нет. И намекал на некие негласные договорённости. Но что-то заставило его передумать.\\nSVTV с самого начала раскритиковало ФБК за решение исключить Кабакова и Кухаренко из санкционного списка. Сегодня члены ФБК признали нашу критику обоснованной и согласились, что «Раскаяние Кабакова и Кухаренко было не достаточно публичным, а информация, которую они предоставили несопоставима по значимости с их вкладом в построение полицейского государства».\\nМы рады, что создатели системы тотальной слежки не смогли уйти от ответственности за счёт личных договорённостей, и обещаем дальше привлекать внимание к попыткам отмыть репутацию архитекторов путинского режима.', photo=types.Photo(id=5332571896987893556, access_hash=-2857507827451710956, file_reference=b'', date=1665142496, sizes=[types.PhotoStrippedSize(type='i', bytes=b''), types.PhotoSize(type='m', w=320, h=240, size=22896), types.PhotoSizeProgressive(type='x', w=635, h=476, sizes=[4541, 11096, 15699, 25872, 50496])], dc_id=2, has_stickers=False, video_sizes=[]), cached_page=types.Page(url='https://t.me/svtvnews/16154', blocks=[types.PageBlockTitle(text=types.TextPlain(text='SVTV NEWS')), types.PageBlockAuthorDate(author=types.TextPlain(text='@svtvnews'), published_date=1665142613), types.PageBlockCollage(items=[types.PageBlockPhoto(photo_id=5332571896987893556, caption=types.PageCaption(text=types.TextEmpty(), credit=types.TextEmpty())), types.PageBlockPhoto(photo_id=5332571896987893557, caption=types.PageCaption(text=types.TextEmpty(), credit=types.TextEmpty())), types.PageBlockPhoto(photo_id=5332571896987893558, caption=types.PageCaption(text=types.TextEmpty(), credit=types.TextEmpty()))], caption=types.PageCaption(text=types.TextPlain(text='ФБК вернул создателей системы цифровой слежки Артёма Кухаренко и Александра Кабакова  в список «разжигателей войны»\\nОни стоят за компанией NTechLab, которая по заказу российских силовиков разработала систему тотальной слежки и распознавания лиц. Эта система используется государством для отлова уклонистов и оппозиционеров.\\nСами Кабаков и Кухаренко из созданного ими техно-рая сбежали, и, раскаявшись, обратились к ФБК за индульгенцией. Леонид Волков тогда объявил, что наказывать их сильнее, чем они сами себя наказали, поработав на государство, смысла нет. И намекал на некие негласные договорённости. Но что-то заставило его передумать.\\nSVTV с самого начала раскритиковало ФБК за решение исключить Кабакова и Кухаренко из санкционного списка. Сегодня члены ФБК признали нашу критику обоснованной и согласились, что «Раскаяние Кабакова и Кухаренко было не достаточно публичным, а информация, которую они предоставили несопоставима по значимости с их вкладом в построение полицейского государства».\\nМы рады, что создатели системы тотальной слежки не смогли уйти от ответственности за счёт личных договорённостей, и обещаем дальше привлекать внимание к попыткам отмыть репутацию архитекторов путинского режима.'), credit=types.TextEmpty()))], photos=[types.Photo(id=5332571896987893557, access_hash=-6022094697165746851, file_reference=b'', date=1665142612, sizes=[types.PhotoStrippedSize(type='i', bytes=b''), types.PhotoSize(type='m', w=320, h=137, size=13211), types.PhotoSize(type='x', w=800, h=342, size=65054), types.PhotoSizeProgressive(type='y', w=1170, h=500, sizes=[5091, 14478, 34811, 50855, 76878])], dc_id=2, has_stickers=False, video_sizes=[]), types.Photo(id=5332571896987893558, access_hash=6218079462356200768, file_reference=b'', date=1665142654, sizes=[types.PhotoStrippedSize(type='i', bytes=b''), types.PhotoSize(type='m', w=319, h=320, size=34641), types.PhotoSize(type='x', w=797, h=800, size=156063), types.PhotoSizeProgressive(type='y', w=1184, h=1188, sizes=[11338, 33841, 76424, 113047, 177582])], dc_id=2, has_stickers=False, video_sizes=[])], documents=[], part=False, rtl=False, v2=False), attributes=[])), entities=[types.MessageEntityBold(offset=0, length=115), types.MessageEntityItalic(offset=116, length=170), types.MessageEntityTextUrl(offset=663, length=7, url='https://t.me/svtvnews/16154'), types.MessageEntityTextUrl(offset=928, length=18, url='https://t.me/svtvnews/11948'), types.MessageEntityTextUrl(offset=948, length=17, url='https://t.me/svtvnews/976')], views=1, forwards=0, replies=types.MessageReplies(replies=0, replies_pts=0, comments=True, recent_repliers=[], channel_id=1269890003), restriction_reason=[]), pts=20316, pts_count=1)], users=[types.User(id=136817688, is_self=False, contact=False, mutual_contact=False, deleted=False, bot=True, bot_chat_history=False, bot_nochats=False, verified=False, restricted=False, min=True, bot_inline_geo=False, support=False, scam=False, apply_min_photo=True, fake=False, bot_attach_menu=False, premium=False, attach_menu_enabled=False, access_hash=1953598452476464818, first_name='Channel', username='Channel_Bot', photo=types.UserProfilePhoto(photo_id=587627495930570665, dc_id=1, has_video=False, stripped_thumb=b''), bot_info_version=4, restriction_reason=[])], chats=[types.Channel(id=1647858514, title='SVTV NEWS Free', photo=types.ChatPhoto(photo_id=5882112872316778690, dc_id=4, has_video=False, stripped_thumb=b''), date=1655754612, creator=False, left=False, broadcast=True, verified=False, megagroup=False, restricted=False, signatures=False, min=True, scam=False, has_link=True, has_geo=False, slowmode_enabled=False, call_active=False, call_not_empty=False, fake=False, gigagroup=False, noforwards=False, join_to_send=False, join_request=False, access_hash=-7938697320137857505, username='svtvnewsfree', restriction_reason=[])], date=1666348630, seq=0),
    types.UpdateShort(update=types.UpdateChannelWebPage(channel_id=1647858514, webpage=types.WebPage(id=9170793120728340119, url='https://t.me/svtvnews/16154', display_url='t.me/svtvnews/16154', hash=-270650917, type='telegram_album', site_name='Telegram', title='SVTV NEWS', description='ФБК вернул создателей системы цифровой слежки Артёма Кухаренко и Александра Кабакова  в список «разжигателей войны»\\nОни стоят за компанией NTechLab, которая по заказу российских силовиков разработала систему тотальной слежки и распознавания лиц. Эта система используется государством для отлова уклонистов и оппозиционеров.\\nСами Кабаков и Кухаренко из созданного ими техно-рая сбежали, и, раскаявшись, обратились к ФБК за индульгенцией. Леонид Волков тогда объявил, что наказывать их сильнее, чем они сами себя наказали, поработав на государство, смысла нет. И намекал на некие негласные договорённости. Но что-то заставило его передумать.\\nSVTV с самого начала раскритиковало ФБК за решение исключить Кабакова и Кухаренко из санкционного списка. Сегодня члены ФБК признали нашу критику обоснованной и согласились, что «Раскаяние Кабакова и Кухаренко было не достаточно публичным, а информация, которую они предоставили несопоставима по значимости с их вкладом в построение полицейского государства».\\nМы рады, что создатели системы тотальной слежки не смогли уйти от ответственности за счёт личных договорённостей, и обещаем дальше привлекать внимание к попыткам отмыть репутацию архитекторов путинского режима.', photo=types.Photo(id=5332571896987893556, access_hash=-2857507827451710956, file_reference=b'', date=1665142496, sizes=[types.PhotoStrippedSize(type='i', bytes=b''), types.PhotoSize(type='m', w=320, h=240, size=22896), types.PhotoSizeProgressive(type='x', w=635, h=476, sizes=[4541, 11096, 15699, 25872, 50496])], dc_id=2, has_stickers=False, video_sizes=[]), cached_page=types.Page(url='https://t.me/svtvnews/16154', blocks=[types.PageBlockTitle(text=types.TextPlain(text='SVTV NEWS')), types.PageBlockAuthorDate(author=types.TextPlain(text='@svtvnews'), published_date=1665142613), types.PageBlockCollage(items=[types.PageBlockPhoto(photo_id=5332571896987893556, caption=types.PageCaption(text=types.TextEmpty(), credit=types.TextEmpty())), types.PageBlockPhoto(photo_id=5332571896987893557, caption=types.PageCaption(text=types.TextEmpty(), credit=types.TextEmpty())), types.PageBlockPhoto(photo_id=5332571896987893558, caption=types.PageCaption(text=types.TextEmpty(), credit=types.TextEmpty()))], caption=types.PageCaption(text=types.TextPlain(text='ФБК вернул создателей системы цифровой слежки Артёма Кухаренко и Александра Кабакова  в список «разжигателей войны»\\nОни стоят за компанией NTechLab, которая по заказу российских силовиков разработала систему тотальной слежки и распознавания лиц. Эта система используется государством для отлова уклонистов и оппозиционеров.\\nСами Кабаков и Кухаренко из созданного ими техно-рая сбежали, и, раскаявшись, обратились к ФБК за индульгенцией. Леонид Волков тогда объявил, что наказывать их сильнее, чем они сами себя наказали, поработав на государство, смысла нет. И намекал на некие негласные договорённости. Но что-то заставило его передумать.\\nSVTV с самого начала раскритиковало ФБК за решение исключить Кабакова и Кухаренко из санкционного списка. Сегодня члены ФБК признали нашу критику обоснованной и согласились, что «Раскаяние Кабакова и Кухаренко было не достаточно публичным, а информация, которую они предоставили несопоставима по значимости с их вкладом в построение полицейского государства».\\nМы рады, что создатели системы тотальной слежки не смогли уйти от ответственности за счёт личных договорённостей, и обещаем дальше привлекать внимание к попыткам отмыть репутацию архитекторов путинского режима.'), credit=types.TextEmpty()))], photos=[types.Photo(id=5332571896987893557, access_hash=-6022094697165746851, file_reference=b'', date=1665142612, sizes=[types.PhotoStrippedSize(type='i', bytes=b''), types.PhotoSize(type='m', w=320, h=137, size=13211), types.PhotoSize(type='x', w=800, h=342, size=65054), types.PhotoSizeProgressive(type='y', w=1170, h=500, sizes=[5091, 14478, 34811, 50855, 76878])], dc_id=2, has_stickers=False, video_sizes=[]), types.Photo(id=5332571896987893558, access_hash=6218079462356200768, file_reference=b'', date=1665142654, sizes=[types.PhotoStrippedSize(type='i', bytes=b''), types.PhotoSize(type='m', w=319, h=320, size=34641), types.PhotoSize(type='x', w=797, h=800, size=156063), types.PhotoSizeProgressive(type='y', w=1184, h=1188, sizes=[11338, 33841, 76424, 113047, 177582])], dc_id=2, has_stickers=False, video_sizes=[])], documents=[], part=False, rtl=False, v2=False), attributes=[]), pts=20317, pts_count=1), date=1666348631),
    types.Updates(updates=[types.UpdateNewChannelMessage(message=types.Message(id=51880, peer_id=types.PeerChannel(channel_id=1269890003), date=1666348635, message='ФБК добавили в свой санкционный список Венедиктова и других участников внедрения системы электронного голосования\\n«Они сознательно создали инструмент, который используется властью для прямых фальсификаций в крупнейшем регионе страны и полностью непрозрачен для общественного контроля», — говорится в сообщении фонда.\\nПомимо бывшего главреда «Эха Москвы» в списке значатся фигурант расследования о коррупции вице-премьер Татьяна Голикова, сотрудник АП и директор авиакомпаний, которые сотрудничают с Министерством обороны, а также новый командующий объединённой группировкой путинских войск в Украине Сергей Суровикин.\\nРанее составители списка учли критику и вернули в него создателей системы цифровой слежки из компании NTechLab, ответственных за то, что мужчинам теперь нельзя свободно передвигаться по Москве. Мы неоднократно говорили и о том, что список «разжигателей войны» выглядит посмешищем, пока в нём не находится Алексей Венедиктов, усилиями которого выборы в России  окончательно стали формальностью.\\nОлег Кашин, с самого начала вторжения в Украину выступавший против войны, всё ещё включён в список ФБК. Мы надеемся, что и это решение будет в конце концов пересмотрено.', out=False, mentioned=False, media_unread=False, silent=False, post=False, from_scheduled=False, legacy=False, edit_hide=False, pinned=False, noforwards=False, from_id=types.PeerChannel(channel_id=1647858514), fwd_from=types.MessageFwdHeader(date=1666348632, imported=False, from_id=types.PeerChannel(channel_id=1647858514), channel_post=7167, saved_from_peer=types.PeerChannel(channel_id=1647858514), saved_from_msg_id=7167), media=types.MessageMediaWebPage(webpage=types.WebPage(id=9170793120728340119, url='https://t.me/svtvnews/16154', display_url='t.me/svtvnews/16154', hash=-270650917, type='telegram_album', site_name='Telegram', title='SVTV NEWS', description='ФБК вернул создателей системы цифровой слежки Артёма Кухаренко и Александра Кабакова  в список «разжигателей войны»\\nОни стоят за компанией NTechLab, которая по заказу российских силовиков разработала систему тотальной слежки и распознавания лиц. Эта система используется государством для отлова уклонистов и оппозиционеров.\\nСами Кабаков и Кухаренко из созданного ими техно-рая сбежали, и, раскаявшись, обратились к ФБК за индульгенцией. Леонид Волков тогда объявил, что наказывать их сильнее, чем они сами себя наказали, поработав на государство, смысла нет. И намекал на некие негласные договорённости. Но что-то заставило его передумать.\\nSVTV с самого начала раскритиковало ФБК за решение исключить Кабакова и Кухаренко из санкционного списка. Сегодня члены ФБК признали нашу критику обоснованной и согласились, что «Раскаяние Кабакова и Кухаренко было не достаточно публичным, а информация, которую они предоставили несопоставима по значимости с их вкладом в построение полицейского государства».\\nМы рады, что создатели системы тотальной слежки не смогли уйти от ответственности за счёт личных договорённостей, и обещаем дальше привлекать внимание к попыткам отмыть репутацию архитекторов путинского режима.', photo=types.Photo(id=5332571896987893556, access_hash=-7501656356701457158, file_reference=b'', date=1665142496, sizes=[types.PhotoStrippedSize(type='i', bytes=b''), types.PhotoSize(type='m', w=320, h=240, size=22896), types.PhotoSizeProgressive(type='x', w=635, h=476, sizes=[4541, 11096, 15699, 25872, 50496])], dc_id=2, has_stickers=False, video_sizes=[]), cached_page=types.Page(url='https://t.me/svtvnews/16154', blocks=[types.PageBlockTitle(text=types.TextPlain(text='SVTV NEWS')), types.PageBlockAuthorDate(author=types.TextPlain(text='@svtvnews'), published_date=1665142613), types.PageBlockCollage(items=[types.PageBlockPhoto(photo_id=5332571896987893556, caption=types.PageCaption(text=types.TextEmpty(), credit=types.TextEmpty())), types.PageBlockPhoto(photo_id=5332571896987893557, caption=types.PageCaption(text=types.TextEmpty(), credit=types.TextEmpty())), types.PageBlockPhoto(photo_id=5332571896987893558, caption=types.PageCaption(text=types.TextEmpty(), credit=types.TextEmpty()))], caption=types.PageCaption(text=types.TextPlain(text='ФБК вернул создателей системы цифровой слежки Артёма Кухаренко и Александра Кабакова  в список «разжигателей войны»\\nОни стоят за компанией NTechLab, которая по заказу российских силовиков разработала систему тотальной слежки и распознавания лиц. Эта система используется государством для отлова уклонистов и оппозиционеров.\\nСами Кабаков и Кухаренко из созданного ими техно-рая сбежали, и, раскаявшись, обратились к ФБК за индульгенцией. Леонид Волков тогда объявил, что наказывать их сильнее, чем они сами себя наказали, поработав на государство, смысла нет. И намекал на некие негласные договорённости. Но что-то заставило его передумать.\\nSVTV с самого начала раскритиковало ФБК за решение исключить Кабакова и Кухаренко из санкционного списка. Сегодня члены ФБК признали нашу критику обоснованной и согласились, что «Раскаяние Кабакова и Кухаренко было не достаточно публичным, а информация, которую они предоставили несопоставима по значимости с их вкладом в построение полицейского государства».\\nМы рады, что создатели системы тотальной слежки не смогли уйти от ответственности за счёт личных договорённостей, и обещаем дальше привлекать внимание к попыткам отмыть репутацию архитекторов путинского режима.'), credit=types.TextEmpty()))], photos=[types.Photo(id=5332571896987893557, access_hash=4419315944895750791, file_reference=b'', date=1665142612, sizes=[types.PhotoStrippedSize(type='i', bytes=b''), types.PhotoSize(type='m', w=320, h=137, size=13211), types.PhotoSize(type='x', w=800, h=342, size=65054), types.PhotoSizeProgressive(type='y', w=1170, h=500, sizes=[5091, 14478, 34811, 50855, 76878])], dc_id=2, has_stickers=False, video_sizes=[]), types.Photo(id=5332571896987893558, access_hash=777897811537570244, file_reference=b'', date=1665142654, sizes=[types.PhotoStrippedSize(type='i', bytes=b''), types.PhotoSize(type='m', w=319, h=320, size=34641), types.PhotoSize(type='x', w=797, h=800, size=156063), types.PhotoSizeProgressive(type='y', w=1184, h=1188, sizes=[11338, 33841, 76424, 113047, 177582])], dc_id=2, has_stickers=False, video_sizes=[])], documents=[], part=False, rtl=False, v2=False), attributes=[])), entities=[types.MessageEntityBold(offset=0, length=115), types.MessageEntityItalic(offset=116, length=170), types.MessageEntityTextUrl(offset=663, length=7, url='https://t.me/svtvnews/16154'), types.MessageEntityTextUrl(offset=928, length=18, url='https://t.me/svtvnews/11948'), types.MessageEntityTextUrl(offset=948, length=17, url='https://t.me/svtvnews/976')], views=2, forwards=0, replies=types.MessageReplies(replies=0, replies_pts=95728, comments=False, recent_repliers=[]), restriction_reason=[]), pts=95728, pts_count=1)], users=[types.User(id=136817688, is_self=False, contact=False, mutual_contact=False, deleted=False, bot=True, bot_chat_history=False, bot_nochats=False, verified=False, restricted=False, min=False, bot_inline_geo=False, support=False, scam=False, apply_min_photo=True, fake=False, bot_attach_menu=False, premium=False, attach_menu_enabled=False, access_hash=291445910502548092, first_name='Channel', username='Channel_Bot', photo=types.UserProfilePhoto(photo_id=587627495930570665, dc_id=1, has_video=False, stripped_thumb=b''), bot_info_version=4, restriction_reason=[])], chats=[types.Channel(id=1269890003, title='Чат SVTV NEWS Free', photo=types.ChatPhoto(photo_id=5391297921128972228, dc_id=2, has_video=False, stripped_thumb=b''), date=1666290863, creator=False, left=False, broadcast=False, verified=False, megagroup=True, restricted=False, signatures=False, min=False, scam=False, has_link=True, has_geo=False, slowmode_enabled=False, call_active=False, call_not_empty=False, fake=False, gigagroup=False, noforwards=False, join_to_send=False, join_request=False, access_hash=-1641089314234313153, restriction_reason=[], default_banned_rights=types.ChatBannedRights(until_date=2147483647, view_messages=False, send_messages=False, send_media=False, send_stickers=False, send_gifs=False, send_games=False, send_inline=False, embed_links=False, send_polls=False, change_info=True, invite_users=False, pin_messages=True)), types.Channel(id=1647858514, title='SVTV NEWS Free', photo=types.ChatPhoto(photo_id=5882112872316778690, dc_id=4, has_video=False, stripped_thumb=b''), date=1664896973, creator=False, left=False, broadcast=True, verified=False, megagroup=False, restricted=False, signatures=False, min=False, scam=False, has_link=True, has_geo=False, slowmode_enabled=False, call_active=False, call_not_empty=False, fake=False, gigagroup=False, noforwards=False, join_to_send=False, join_request=False, access_hash=-7566577635619473865, username='svtvnewsfree', restriction_reason=[])], date=1666348634, seq=0),
    types.Updates(updates=[types.UpdateEditChannelMessage(message=types.Message(id=7167, peer_id=types.PeerChannel(channel_id=1647858514), date=1666348632, message='ФБК добавили в свой санкционный список Венедиктова и других участников внедрения системы электронного голосования\\n«Они сознательно создали инструмент, который используется властью для прямых фальсификаций в крупнейшем регионе страны и полностью непрозрачен для общественного контроля», — говорится в сообщении фонда.\\nПомимо бывшего главреда «Эха Москвы» в списке значатся фигурант расследования о коррупции вице-премьер Татьяна Голикова, сотрудник АП и директор авиакомпаний, которые сотрудничают с Министерством обороны, а также новый командующий объединённой группировкой путинских войск в Украине Сергей Суровикин.\\nРанее составители списка учли критику и вернули в него создателей системы цифровой слежки из компании NTechLab, ответственных за то, что мужчинам теперь нельзя свободно передвигаться по Москве. Мы неоднократно говорили и о том, что список «разжигателей войны» выглядит посмешищем, пока в нём не находится Алексей Венедиктов, усилиями которого выборы в России  окончательно стали формальностью.\\nОлег Кашин, с самого начала вторжения в Украину выступавший против войны, всё ещё включён в список ФБК. Мы надеемся, что и это решение будет в конце концов пересмотрено.', out=False, mentioned=False, media_unread=False, silent=False, post=True, from_scheduled=False, legacy=False, edit_hide=True, pinned=False, noforwards=False, media=types.MessageMediaWebPage(webpage=types.WebPage(id=9170793120728340119, url='https://t.me/svtvnews/16154', display_url='t.me/svtvnews/16154', hash=-270650917, type='telegram_album', site_name='Telegram', title='SVTV NEWS', description='ФБК вернул создателей системы цифровой слежки Артёма Кухаренко и Александра Кабакова  в список «разжигателей войны»\\nОни стоят за компанией NTechLab, которая по заказу российских силовиков разработала систему тотальной слежки и распознавания лиц. Эта система используется государством для отлова уклонистов и оппозиционеров.\\nСами Кабаков и Кухаренко из созданного ими техно-рая сбежали, и, раскаявшись, обратились к ФБК за индульгенцией. Леонид Волков тогда объявил, что наказывать их сильнее, чем они сами себя наказали, поработав на государство, смысла нет. И намекал на некие негласные договорённости. Но что-то заставило его передумать.\\nSVTV с самого начала раскритиковало ФБК за решение исключить Кабакова и Кухаренко из санкционного списка. Сегодня члены ФБК признали нашу критику обоснованной и согласились, что «Раскаяние Кабакова и Кухаренко было не достаточно публичным, а информация, которую они предоставили несопоставима по значимости с их вкладом в построение полицейского государства».\\nМы рады, что создатели системы тотальной слежки не смогли уйти от ответственности за счёт личных договорённостей, и обещаем дальше привлекать внимание к попыткам отмыть репутацию архитекторов путинского режима.', photo=types.Photo(id=5332571896987893556, access_hash=-2857507827451710956, file_reference=b'', date=1665142496, sizes=[types.PhotoStrippedSize(type='i', bytes=b''), types.PhotoSize(type='m', w=320, h=240, size=22896), types.PhotoSizeProgressive(type='x', w=635, h=476, sizes=[4541, 11096, 15699, 25872, 50496])], dc_id=2, has_stickers=False, video_sizes=[]), cached_page=types.Page(url='https://t.me/svtvnews/16154', blocks=[types.PageBlockTitle(text=types.TextPlain(text='SVTV NEWS')), types.PageBlockAuthorDate(author=types.TextPlain(text='@svtvnews'), published_date=1665142613), types.PageBlockCollage(items=[types.PageBlockPhoto(photo_id=5332571896987893556, caption=types.PageCaption(text=types.TextEmpty(), credit=types.TextEmpty())), types.PageBlockPhoto(photo_id=5332571896987893557, caption=types.PageCaption(text=types.TextEmpty(), credit=types.TextEmpty())), types.PageBlockPhoto(photo_id=5332571896987893558, caption=types.PageCaption(text=types.TextEmpty(), credit=types.TextEmpty()))], caption=types.PageCaption(text=types.TextPlain(text='ФБК вернул создателей системы цифровой слежки Артёма Кухаренко и Александра Кабакова  в список «разжигателей войны»\\nОни стоят за компанией NTechLab, которая по заказу российских силовиков разработала систему тотальной слежки и распознавания лиц. Эта система используется государством для отлова уклонистов и оппозиционеров.\\nСами Кабаков и Кухаренко из созданного ими техно-рая сбежали, и, раскаявшись, обратились к ФБК за индульгенцией. Леонид Волков тогда объявил, что наказывать их сильнее, чем они сами себя наказали, поработав на государство, смысла нет. И намекал на некие негласные договорённости. Но что-то заставило его передумать.\\nSVTV с самого начала раскритиковало ФБК за решение исключить Кабакова и Кухаренко из санкционного списка. Сегодня члены ФБК признали нашу критику обоснованной и согласились, что «Раскаяние Кабакова и Кухаренко было не достаточно публичным, а информация, которую они предоставили несопоставима по значимости с их вкладом в построение полицейского государства».\\nМы рады, что создатели системы тотальной слежки не смогли уйти от ответственности за счёт личных договорённостей, и обещаем дальше привлекать внимание к попыткам отмыть репутацию архитекторов путинского режима.'), credit=types.TextEmpty()))], photos=[types.Photo(id=5332571896987893557, access_hash=-6022094697165746851, file_reference=b'', date=1665142612, sizes=[types.PhotoStrippedSize(type='i', bytes=b''), types.PhotoSize(type='m', w=320, h=137, size=13211), types.PhotoSize(type='x', w=800, h=342, size=65054), types.PhotoSizeProgressive(type='y', w=1170, h=500, sizes=[5091, 14478, 34811, 50855, 76878])], dc_id=2, has_stickers=False, video_sizes=[]), types.Photo(id=5332571896987893558, access_hash=6218079462356200768, file_reference=b'', date=1665142654, sizes=[types.PhotoStrippedSize(type='i', bytes=b''), types.PhotoSize(type='m', w=319, h=320, size=34641), types.PhotoSize(type='x', w=797, h=800, size=156063), types.PhotoSizeProgressive(type='y', w=1184, h=1188, sizes=[11338, 33841, 76424, 113047, 177582])], dc_id=2, has_stickers=False, video_sizes=[])], documents=[], part=False, rtl=False, v2=False), attributes=[])), entities=[types.MessageEntityBold(offset=0, length=115), types.MessageEntityItalic(offset=116, length=170), types.MessageEntityTextUrl(offset=663, length=7, url='https://t.me/svtvnews/16154'), types.MessageEntityTextUrl(offset=928, length=18, url='https://t.me/svtvnews/11948'), types.MessageEntityTextUrl(offset=948, length=17, url='https://t.me/svtvnews/976')], views=3, forwards=0, replies=types.MessageReplies(replies=0, replies_pts=95729, comments=True, recent_repliers=[], channel_id=1269890003), edit_date=1666348635, restriction_reason=[]), pts=20318, pts_count=1)], users=[types.User(id=136817688, is_self=False, contact=False, mutual_contact=False, deleted=False, bot=True, bot_chat_history=False, bot_nochats=False, verified=False, restricted=False, min=True, bot_inline_geo=False, support=False, scam=False, apply_min_photo=True, fake=False, bot_attach_menu=False, premium=False, attach_menu_enabled=False, access_hash=1953598452476464818, first_name='Channel', username='Channel_Bot', photo=types.UserProfilePhoto(photo_id=587627495930570665, dc_id=1, has_video=False, stripped_thumb=b''), bot_info_version=4, restriction_reason=[])], chats=[types.Channel(id=1647858514, title='SVTV NEWS Free', photo=types.ChatPhoto(photo_id=5882112872316778690, dc_id=4, has_video=False, stripped_thumb=b''), date=1655754612, creator=False, left=False, broadcast=True, verified=False, megagroup=False, restricted=False, signatures=False, min=True, scam=False, has_link=True, has_geo=False, slowmode_enabled=False, call_active=False, call_not_empty=False, fake=False, gigagroup=False, noforwards=False, join_to_send=False, join_request=False, access_hash=-7938697320137857505, username='svtvnewsfree', restriction_reason=[])], date=1666348635, seq=0),
    types.Updates(updates=[types.UpdateNewChannelMessage(message=types.Message(id=155, peer_id=types.PeerChannel(channel_id=1470199555), date=1666376578, message='5', out=False, mentioned=False, media_unread=False, silent=False, post=True, from_scheduled=False, legacy=False, edit_hide=False, pinned=False, noforwards=False, entities=[], views=1, forwards=0, restriction_reason=[]), pts=221, pts_count=1)], users=([types.User(id=136817688, is_self=False, contact=False, mutual_contact=False, deleted=False, bot=True, bot_chat_history=False, bot_nochats=False, verified=False, restricted=False, min=True, bot_inline_geo=False, support=False, scam=False, apply_min_photo=True, fake=False, bot_attach_menu=False, premium=False, attach_menu_enabled=False, access_hash=1953598452476464818, first_name='Channel', username='Channel_Bot', photo=types.UserProfilePhoto(photo_id=587627495930570665, dc_id=1, has_video=False, stripped_thumb=b'\x01\x08\x08\xb1\xf2\xf9_\xedg4QEp3\xad\x1f'), bot_info_version=4, restriction_reason=[])]), chats=([types.Channel(id=1470199555, title='Калуга • Жуков • Обнинск', photo=types.ChatPhoto(photo_id=5262459901660217909, dc_id=2, has_video=False, stripped_thumb=b'\x01\x08\x08\x86Cfm\xf8#\xcc\xd9\xef\xf7\xa8\xa2\x8a\x00'), date=1590258515, creator=False, left=False, broadcast=True, verified=False, megagroup=False, restricted=False, signatures=False, min=True, scam=False, has_link=False, has_geo=False, slowmode_enabled=False, call_active=False, call_not_empty=False, fake=False, gigagroup=False, noforwards=False, join_to_send=False, join_request=False, access_hash=5355861597222767838, restriction_reason=[])]), date=1666376547, seq=0),
    types.Updates(updates=[types.UpdateEditChannelMessage(message=types.Message(id=155, peer_id=types.PeerChannel(channel_id=1470199555), date=1666376578, message='5 123123', out=False, mentioned=False, media_unread=False, silent=False, post=True, from_scheduled=False, legacy=False, edit_hide=False, pinned=False, noforwards=False, entities=[], views=1, forwards=0, edit_date=1666376613, restriction_reason=[]), pts=222, pts_count=1)], users=([types.User(id=136817688, is_self=False, contact=False, mutual_contact=False, deleted=False, bot=True, bot_chat_history=False, bot_nochats=False, verified=False, restricted=False, min=True, bot_inline_geo=False, support=False, scam=False, apply_min_photo=True, fake=False, bot_attach_menu=False, premium=False, attach_menu_enabled=False, access_hash=1953598452476464818, first_name='Channel', username='Channel_Bot', photo=types.UserProfilePhoto(photo_id=587627495930570665, dc_id=1, has_video=False, stripped_thumb=b'\x01\x08\x08\xb1\xf2\xf9_\xedg4QEp3\xad\x1f'), bot_info_version=4, restriction_reason=[])]), chats=([types.Channel(id=1470199555, title='Калуга • Жуков • Обнинск', photo=types.ChatPhoto(photo_id=5262459901660217909, dc_id=2, has_video=False, stripped_thumb=b'\x01\x08\x08\x86Cfm\xf8#\xcc\xd9\xef\xf7\xa8\xa2\x8a\x00'), date=1590258515, creator=False, left=False, broadcast=True, verified=False, megagroup=False, restricted=False, signatures=False, min=True, scam=False, has_link=False, has_geo=False, slowmode_enabled=False, call_active=False, call_not_empty=False, fake=False, gigagroup=False, noforwards=False, join_to_send=False, join_request=False, access_hash=5355861597222767838, restriction_reason=[])]), date=1666376613, seq=0),
    types.UpdateShort(update=types.UpdateUserStatus(user_id=1994482620, status=types.UserStatusOnline(expires=1666376964)), date=1666376663),
    types.Updates(updates=[types.UpdateReadChannelInbox(channel_id=1470199555, max_id=155, still_unread_count=0, pts=222)], users=([]), chats=([]), date=1666376664, seq=0),
    types.Updates(updates=[types.UpdateReadChannelInbox(channel_id=1269890003, max_id=52010, still_unread_count=0, pts=95989)], users=([]), chats=([]), date=1666376667, seq=0),
    types.UpdateShort(update=types.UpdateUserStatus(user_id=1994482620, status=types.UserStatusOffline(was_online=1666376681)), date=1666376680),
]


class Client(HandleUpdates):
    def __init__(self):
        self.requesting_chats = RequestingChats(self)
        self.sequences = Sequences()

    async def fetch_peers(self, *args, **kwargs):
        pass

    async def update_min_users_and_chats(self, *args, **kwargs):
        pass


@pytest.mark.asyncio
async def test_handle_updates():
    client = Client()
    for u in updates:
        with patch('telectron.methods.advanced.handle_updates.HandleUpdates.put_update') as mock:
            await client.handle_updates(u)
            assert mock.called


@pytest.mark.asyncio
async def test_update_not_handled_twice():
    client = Client()
    checking_updates = []
    for u in updates:
        if hasattr(u, 'updates'):
            for update in u.updates:
                if hasattr(update, 'pts') and getattr(update, 'pts_count', 0) != 0:
                    checking_updates.append(u)
                    break
    for u in checking_updates:
        with patch('telectron.methods.advanced.handle_updates.HandleUpdates.put_update') as mock:
            await client.handle_updates(u)
            assert mock.called
        with patch('telectron.methods.advanced.handle_updates.HandleUpdates.put_update') as mock:
            await client.handle_updates(u)
            assert not mock.called


@pytest.mark.asyncio
async def test_requesting_chats_start_and_stop():
    start_time = time.time()
    client = Client()
    await client.requesting_chats.start()
    await client.requesting_chats.stop()
    assert time.time() - start_time < 1


@pytest.mark.asyncio
async def test_requesting_chats_timer():
    TEST_CHANNELS = [123, 456, 789]
    start_time = time.time()
    client = Client()
    client.requesting_chats.last_check -= RequestingChats.CHANNELS_CHECK_DELAY
    await client.requesting_chats.add_requesting_chats(TEST_CHANNELS)
    await client.requesting_chats.add_requesting_chats(TEST_CHANNELS)
    with patch('telectron.methods.advanced.handle_updates.HandleUpdates.check_channels_difference') as mock:
        await client.requesting_chats.start()
        await client.requesting_chats.stop()
        assert mock.called
        assert len(mock.call_args.args) == 1
        assert len(mock.call_args.args[0]) == len(TEST_CHANNELS)
        assert set(mock.call_args.args[0]) == set(TEST_CHANNELS)
        mock.reset_mock()
        client.requesting_chats.last_update -= RequestingChats.NO_UPDATES_TIMEOUT
        with patch('telectron.methods.advanced.handle_updates.HandleUpdates.check_difference') as smock:
            await client.requesting_chats.start()
            await client.requesting_chats.stop()
            assert mock.called
            assert len(mock.call_args.args) == 1
            assert len(mock.call_args.args[0]) == len(list(client.sequences.channel_pts.keys()))
            assert set(mock.call_args.args[0]) == set(list(client.sequences.channel_pts.keys()))
            assert smock.called

    assert time.time() - start_time < 1

