"""
Parallel-LLM: Ultra-Fast Parallel Training and Inference for Language Models

A production-ready library for training and inference of language models with
revolutionary parallel token generation using hybrid diffusion-energy architecture.
"""

__version__ = "0.4.0"

# Core exports (backward compatible)
from .core import (
    ModelConfig,
    MultimodalConfig,
    DiffusionTransformer,
    get_default_config,
)

# Training exports (backward compatible)
from .training import (
    TrainingConfig,
    DistributedTrainer,
    DiffusionLoss,
    ContrastiveLoss,
)

# Inference exports (backward compatible)
from .inference import (
    InferenceConfig,
    GenerationConfig,
    ParallelGenerator,
    create_generator,
)

# Utils exports
from .utils import (
    TextDataset,
    MultimodalDataset,
    PreTokenizedDataset,
)

__all__ = [
    # Version
    '__version__',
    
    # Core
    'ModelConfig',
    'MultimodalConfig',
    'DiffusionTransformer',
    'get_default_config',
    
    # Training
    'TrainingConfig',
    'DistributedTrainer',
    'DiffusionLoss',
    'ContrastiveLoss',
    
    # Inference
    'InferenceConfig',
    'GenerationConfig',
    'ParallelGenerator',
    'create_generator',
    
    # Utils
    'TextDataset',
    'MultimodalDataset',
    'PreTokenizedDataset',
]
