import os
import sys

import Orange.data
from AnyQt.QtWidgets import QApplication
from Orange.widgets import widget
from Orange.widgets.utils.signals import Input, Output


if "site-packages/Orange/widgets" in os.path.dirname(os.path.abspath(__file__)).replace("\\", "/"):
    from Orange.widgets.orangecontrib.AAIT.utils.import_uic import uic
    from Orange.widgets.orangecontrib.AAIT.utils.initialize_from_ini import apply_modification_from_python_file
else:
    from orangecontrib.AAIT.utils.import_uic import uic
    from orangecontrib.AAIT.utils.initialize_from_ini import apply_modification_from_python_file

@apply_modification_from_python_file(filepath_original_widget=__file__)
class OWTrigger(widget.OWWidget):
    name = "Trigger"
    description = "Pause a data signal until a trigger signal is received. Be careful to connect the trigger signal AFTER the data signal."
    category = "AAIT - TOOLBOX"
    icon = "icons/owtrigger.svg"
    if "site-packages/Orange/widgets" in os.path.dirname(os.path.abspath(__file__)).replace("\\", "/"):
        icon = "icons_dev/owtrigger.svg"
    gui = os.path.join(os.path.dirname(os.path.abspath(__file__)), "designer/owtrigger.ui")
    want_control_area = False
    priority = 1060

    class Inputs:
        data = Input("Data", Orange.data.Table)
        trigger = Input("Trigger",object)

    class Outputs:
        data = Output("Data", Orange.data.Table)

    @Inputs.data
    def set_data(self, in_data):
        self.data = in_data
        self.Outputs.data.send(None)

    @Inputs.trigger
    def set_trigger(self, in_trigger):
        self.trigger = in_trigger
        self.run()

    def __init__(self):
        super().__init__()
        # Qt Management
        self.setFixedWidth(470)
        self.setFixedHeight(300)
        uic.loadUi(self.gui, self)

        # Data Management
        self.data = None
        self.trigger = None
        self.autorun = True
        self.post_initialized()

    def run(self):
        if self.trigger is None:
            return
        if self.data is not None:
            self.Outputs.data.send(self.data)

    def post_initialized(self):
        pass

if __name__ == "__main__":
    app = QApplication(sys.argv)
    my_widget = OWTrigger()
    my_widget.show()
    if hasattr(app, "exec"):
        app.exec()
    else:
        app.exec_()
