"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _ReleaseStage:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ReleaseStageEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ReleaseStage.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    RELEASE_STAGE_UNSPECIFIED: _ReleaseStage.ValueType  # 0
    """ReleaseStage: UNSPECIFIED"""
    RELEASE_STAGE_ALPHA: _ReleaseStage.ValueType  # 1
    """ReleaseStage: ALPHA"""
    RELEASE_STAGE_BETA: _ReleaseStage.ValueType  # 2
    """ReleaseStage: BETA"""
    RELEASE_STAGE_GENERALLY_AVAILABLE: _ReleaseStage.ValueType  # 3
    """ReleaseStage: GENERALLY_AVAILABLE"""
    RELEASE_STAGE_CUSTOM: _ReleaseStage.ValueType  # 4
    """ReleaseStage: CUSTOM"""

class ReleaseStage(_ReleaseStage, metaclass=_ReleaseStageEnumTypeWrapper):
    """ReleaseStage enumerates the release stages"""

RELEASE_STAGE_UNSPECIFIED: ReleaseStage.ValueType  # 0
"""ReleaseStage: UNSPECIFIED"""
RELEASE_STAGE_ALPHA: ReleaseStage.ValueType  # 1
"""ReleaseStage: ALPHA"""
RELEASE_STAGE_BETA: ReleaseStage.ValueType  # 2
"""ReleaseStage: BETA"""
RELEASE_STAGE_GENERALLY_AVAILABLE: ReleaseStage.ValueType  # 3
"""ReleaseStage: GENERALLY_AVAILABLE"""
RELEASE_STAGE_CUSTOM: ReleaseStage.ValueType  # 4
"""ReleaseStage: CUSTOM"""
global___ReleaseStage = ReleaseStage

class _View:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ViewEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_View.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    VIEW_UNSPECIFIED: _View.ValueType  # 0
    """View: UNSPECIFIED, equivalent to BASIC."""
    VIEW_BASIC: _View.ValueType  # 1
    """View: BASIC, server response only include basic information of the resource"""
    VIEW_FULL: _View.ValueType  # 2
    """View: FULL, full representation of the resource"""

class View(_View, metaclass=_ViewEnumTypeWrapper):
    """View represents a view of any resource. The resource view is implemented by
    adding a parameter to the method request which allows the client to specify
    which view of the resource it wants to receive in the response.
    """

VIEW_UNSPECIFIED: View.ValueType  # 0
"""View: UNSPECIFIED, equivalent to BASIC."""
VIEW_BASIC: View.ValueType  # 1
"""View: BASIC, server response only include basic information of the resource"""
VIEW_FULL: View.ValueType  # 2
"""View: FULL, full representation of the resource"""
global___View = View

@typing_extensions.final
class ModelDefinition(google.protobuf.message.Message):
    """/////////////////////////////////////////////////////////////////
    ModelDefinition represents the definition of a model
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    DOCUMENTATION_URL_FIELD_NUMBER: builtins.int
    ICON_FIELD_NUMBER: builtins.int
    RELEASE_STAGE_FIELD_NUMBER: builtins.int
    MODEL_SPEC_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """ModelDefinition resource name. It must have the format of
    "model-definitions/{model-definition}"
    """
    uid: builtins.str
    """ModelDefinition ID in UUIDv4"""
    id: builtins.str
    """ModelDefinition resource ID (the last segment of the resource name) used to
    construct the resource name.
    """
    title: builtins.str
    """ModelDefinition display official title"""
    documentation_url: builtins.str
    """ModelDefinition documentation url"""
    icon: builtins.str
    """ModelDefinition icon"""
    release_stage: global___ReleaseStage.ValueType
    """ModelDefinition release stage"""
    @property
    def model_spec(self) -> google.protobuf.struct_pb2.Struct:
        """ModelDefinition model specification represents the JSON schema used to
        validate the JSON configurations of a model created from a specific model
        source. Must be a valid JSON that includes what fields are needed to
        create/display a model.
        """
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """ModelDefinition create time"""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """ModelDefinition update time"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        uid: builtins.str = ...,
        id: builtins.str = ...,
        title: builtins.str = ...,
        documentation_url: builtins.str = ...,
        icon: builtins.str = ...,
        release_stage: global___ReleaseStage.ValueType = ...,
        model_spec: google.protobuf.struct_pb2.Struct | None = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["create_time", b"create_time", "model_spec", b"model_spec", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["create_time", b"create_time", "documentation_url", b"documentation_url", "icon", b"icon", "id", b"id", "model_spec", b"model_spec", "name", b"name", "release_stage", b"release_stage", "title", b"title", "uid", b"uid", "update_time", b"update_time"]) -> None: ...

global___ModelDefinition = ModelDefinition

@typing_extensions.final
class ListModelDefinitionsRequest(google.protobuf.message.Message):
    """ListModelDefinitionsRequest represents a request to list all supported model
    definitions
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """Page size: the maximum number of resources to return. The service may
    return fewer than this value. If unspecified, at most 10 ModelDefinitions
    will be returned. The maximum value is 100; values above 100 will be
    coereced to 100.
    """
    page_token: builtins.str
    """Page token"""
    view: global___View.ValueType
    """Definition view (default is VIEW_BASIC)
    VIEW_UNSPECIFIED/VIEW_BASIC: omit `ModelDefinition.model_spec` and
    `ModelDefinition.model_spec`
    VIEW_FULL: show full information
    """
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: global___View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "_view", b"_view", "page_size", b"page_size", "page_token", b"page_token", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "_view", b"_view", "page_size", b"page_size", "page_token", b"page_token", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListModelDefinitionsRequest = ListModelDefinitionsRequest

@typing_extensions.final
class ListModelDefinitionsResponse(google.protobuf.message.Message):
    """ListModelDefinitionsResponse represents a response to list all supported
    model definitions
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_DEFINITIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def model_definitions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelDefinition]:
        """a list of ModelDefinition instances"""
    next_page_token: builtins.str
    """Next page token"""
    total_size: builtins.int
    """Total count of model definitions"""
    def __init__(
        self,
        *,
        model_definitions: collections.abc.Iterable[global___ModelDefinition] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_definitions", b"model_definitions", "next_page_token", b"next_page_token", "total_size", b"total_size"]) -> None: ...

global___ListModelDefinitionsResponse = ListModelDefinitionsResponse

@typing_extensions.final
class GetModelDefinitionRequest(google.protobuf.message.Message):
    """GetModelDefinitionRequest represents a request to query a model definition"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Resource name of the model definition.
    For example "model-definitions/{uuid}"
    """
    view: global___View.ValueType
    """Definition view (default is VIEW_BASIC)
    VIEW_UNSPECIFIED/VIEW_BASIC: omit `ModelDefinition.model_spec` and
    `ModelDefinition.model_spec`
    VIEW_FULL: show full information
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: global___View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetModelDefinitionRequest = GetModelDefinitionRequest

@typing_extensions.final
class GetModelDefinitionResponse(google.protobuf.message.Message):
    """GetModelDefinitionResponse represents a response for a model definition"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_DEFINITION_FIELD_NUMBER: builtins.int
    @property
    def model_definition(self) -> global___ModelDefinition:
        """A model definition instance"""
    def __init__(
        self,
        *,
        model_definition: global___ModelDefinition | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model_definition", b"model_definition"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_definition", b"model_definition"]) -> None: ...

global___GetModelDefinitionResponse = GetModelDefinitionResponse
