# generated by datamodel-codegen:
#   filename:  openai_task_text_to_image_input.json

from __future__ import annotations

from dataclasses import dataclass
from enum import Enum
from typing import Any, List, Optional


class Model(Enum):
    dall_e_2 = 'dall-e-2'
    dall_e_3 = 'dall-e-3'


class Quality(Enum):
    standard = 'standard'
    hd = 'hd'


class Size(Enum):
    field_256x256 = '256x256'
    field_512x512 = '512x512'
    field_1024x1024 = '1024x1024'
    field_1792x1024 = '1792x1024'
    field_1024x1792 = '1024x1792'


class Style(Enum):
    vivid = 'vivid'
    natural = 'natural'


@dataclass
class ImageUrl:
    url: str


class Type(Enum):
    text = 'text'
    image_url = 'image_url'


@dataclass
class MultiModalContentItem:
    type: Type
    image_url: Optional[ImageUrl] = None
    text: Optional[str] = None


InstillTypes = Any


@dataclass
class Input:
    model: Model
    prompt: str
    n: Optional[int] = None
    quality: Optional[Quality] = Quality.standard
    size: Optional[Size] = Size.field_1024x1024
    style: Optional[Style] = Style.vivid


@dataclass
class ChatMessage:
    content: List[MultiModalContentItem]
    role: str
