# generated by datamodel-codegen:
#   filename:  openai_task_text_to_speech_input.json

from __future__ import annotations

from dataclasses import dataclass
from enum import Enum
from typing import Any, List, Optional, Union


class Model1(Enum):
    tts_1 = 'tts-1'
    tts_1_hd = 'tts-1-hd'


class ResponseFormat(Enum):
    mp3 = 'mp3'
    opus = 'opus'
    aac = 'aac'
    flac = 'flac'


class Voice(Enum):
    alloy = 'alloy'
    echo = 'echo'
    fable = 'fable'
    onyx = 'onyx'
    nova = 'nova'
    shimmer = 'shimmer'


@dataclass
class ImageUrl:
    url: str


class Type(Enum):
    text = 'text'
    image_url = 'image_url'


@dataclass
class MultiModalContentItem:
    type: Type
    image_url: Optional[ImageUrl] = None
    text: Optional[str] = None


InstillTypes = Any


@dataclass
class InputModel:
    model: Union[str, Model1]
    text: str
    voice: Voice
    response_format: Optional[ResponseFormat] = ResponseFormat.mp3
    speed: Optional[float] = None


@dataclass
class ChatMessage:
    content: List[MultiModalContentItem]
    role: str
