var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/account-provider/is-complete-handler.lambda.ts
var is_complete_handler_lambda_exports = {};
__export(is_complete_handler_lambda_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(is_complete_handler_lambda_exports);
var AWS = __toESM(require("aws-sdk"));
var organizationsClient;
async function handler(event) {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r;
  console.log(`Request of type ${event.RequestType} received`);
  if (!organizationsClient) {
    organizationsClient = new AWS.Organizations({ region: "us-east-1" });
  }
  console.log("Payload: %j", event);
  let accountId;
  if (event.RequestType == "Create" || isLegacyPhysicalResourceId(event)) {
    const response2 = await organizationsClient.describeCreateAccountStatus({
      CreateAccountRequestId: isLegacyPhysicalResourceId(event) ? event.PhysicalResourceId : (_a = event.Data) == null ? void 0 : _a.CreateAccountStatusId
    }).promise();
    if (((_b = response2.CreateAccountStatus) == null ? void 0 : _b.State) == "IN_PROGRESS") {
      return { IsComplete: false, Data: {} };
    }
    if (((_c = response2.CreateAccountStatus) == null ? void 0 : _c.State) == "FAILED" && ((_d = response2.CreateAccountStatus) == null ? void 0 : _d.FailureReason) != "EMAIL_ALREADY_EXISTS") {
      throw new Error(
        `Failed ${event.RequestType} Account ${(_e = response2.CreateAccountStatus) == null ? void 0 : _e.AccountName}, reason: ${(_f = response2.CreateAccountStatus) == null ? void 0 : _f.FailureReason}`
      );
    }
    if (((_g = response2.CreateAccountStatus) == null ? void 0 : _g.FailureReason) == "EMAIL_ALREADY_EXISTS" && event.ResourceProperties.ImportOnDuplicate) {
      const account = await findAccountByEmail(organizationsClient, event.ResourceProperties.Email);
      if (!account) {
        throw new Error(
          `Failed ${event.RequestType} Account ${(_h = response2.CreateAccountStatus) == null ? void 0 : _h.AccountName}, reason: ${(_i = response2.CreateAccountStatus) == null ? void 0 : _i.FailureReason}; could not find account in organization.`
        );
      }
      accountId = account.Id;
    } else if (((_j = response2.CreateAccountStatus) == null ? void 0 : _j.FailureReason) == "EMAIL_ALREADY_EXISTS" && !event.ResourceProperties.ImportOnDuplicate) {
      throw new Error(
        `Failed ${event.RequestType} Account ${(_k = response2.CreateAccountStatus) == null ? void 0 : _k.AccountName}, reason: ${(_l = response2.CreateAccountStatus) == null ? void 0 : _l.FailureReason}.`
      );
    } else {
      accountId = (_m = response2.CreateAccountStatus) == null ? void 0 : _m.AccountId;
    }
  } else {
    accountId = event.PhysicalResourceId;
  }
  const response = await organizationsClient.describeAccount({ AccountId: accountId }).promise();
  await move(organizationsClient, accountId, (_n = event.ResourceProperties) == null ? void 0 : _n.ParentId);
  if (event.RequestType == "Delete" && ((_o = event.ResourceProperties) == null ? void 0 : _o.RemovalPolicy) == "destroy") {
    await close(organizationsClient, accountId);
  }
  return {
    IsComplete: true,
    PhysicalResourceId: accountId,
    Data: {
      ...event.ResourceProperties,
      ...event.Data,
      AccountId: accountId,
      AccountArn: (_p = response.Account) == null ? void 0 : _p.Arn,
      AccountName: (_q = response.Account) == null ? void 0 : _q.Name,
      Email: (_r = response.Account) == null ? void 0 : _r.Email
    }
  };
}
var findCurrentParent = async (client, id) => {
  var _a;
  const response = await client.listParents({
    ChildId: id
  }).promise();
  if ((_a = response.Parents) == null ? void 0 : _a.length) {
    return response.Parents[0];
  }
  throw new Error(`Could not find parent for id '${id}'`);
};
var move = async (client, accountId, destinationParentId) => {
  if (!destinationParentId) {
    return;
  }
  const currentParent = await findCurrentParent(organizationsClient, accountId);
  if (destinationParentId == currentParent.Id) {
    return;
  }
  await client.moveAccount({
    AccountId: accountId,
    SourceParentId: currentParent.Id,
    DestinationParentId: destinationParentId
  }).promise();
};
var isLegacyPhysicalResourceId = (event) => {
  return /car-[a-z0-9]{8,32}/.test(event.PhysicalResourceId);
};
var findAccountByEmail = async (client, email) => {
  let response = await client.listAccounts().promise();
  for (const account of response.Accounts ?? []) {
    if (account.Email == email) {
      return account;
    }
  }
  while (response.NextToken) {
    response = await client.listAccounts({ NextToken: response.NextToken }).promise();
    for (const account of response.Accounts ?? []) {
      if (account.Email == email) {
        return account;
      }
    }
  }
  return void 0;
};
var close = async (client, accountId) => {
  await client.closeAccount({
    AccountId: accountId
  });
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
