var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/organization-provider/on-event-handler.lambda.ts
var on_event_handler_lambda_exports = {};
__export(on_event_handler_lambda_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(on_event_handler_lambda_exports);
var import_aws_sdk = require("aws-sdk");
var organizationsClient;
async function handler(event) {
  var _a, _b;
  console.log(`Request of type ${event.RequestType} received`);
  if (!organizationsClient) {
    organizationsClient = new import_aws_sdk.Organizations({ region: "us-east-1" });
  }
  console.log("Payload: %j", event);
  if (event.RequestType == "Create") {
    try {
      const response2 = await organizationsClient.createOrganization({
        FeatureSet: event.ResourceProperties.FeatureSet
      }).promise();
      console.log("Creating organization: %j", response2);
      return {
        PhysicalResourceId: (_a = response2.Organization) == null ? void 0 : _a.Id,
        Data: {
          ...response2.Organization
        }
      };
    } catch (e) {
      const error = e;
      if (error.code == "AlreadyInOrganizationException") {
        console.log("Organization already created.");
      } else {
        throw error;
      }
    }
  }
  const response = await organizationsClient.describeOrganization().promise();
  return {
    PhysicalResourceId: (_b = response.Organization) == null ? void 0 : _b.Id,
    Data: {
      ...response.Organization
    }
  };
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
