var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/organizational-unit-provider/on-event-handler.lambda.ts
var on_event_handler_lambda_exports = {};
__export(on_event_handler_lambda_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(on_event_handler_lambda_exports);
var import_aws_sdk = require("aws-sdk");
var organizationsClient;
var handler = async (event) => {
  console.log(`Request of type ${event.RequestType} received`);
  if (!organizationsClient) {
    organizationsClient = new import_aws_sdk.Organizations({ region: "us-east-1" });
  }
  console.log("Payload: %j", event);
  const { ParentId, Name, ImportOnDuplicate, RemovalPolicy } = event.ResourceProperties;
  if (event.RequestType == "Create") {
    try {
      const organizationalUnit = await createOrganizationalUnit(organizationsClient, ParentId, Name);
      return {
        PhysicalResourceId: organizationalUnit.Id,
        Data: {
          ...organizationalUnit
        }
      };
    } catch (e) {
      const error = e;
      console.log(error);
      if (error.code == "DuplicateOrganizationalUnitException" && ImportOnDuplicate == "true") {
        console.log(`Organizational unit already created, trying to find existing one in parent.`);
        const organizationalUnit = await findOrganizationalUnitByParentAndName(organizationsClient, ParentId, Name);
        return {
          PhysicalResourceId: organizationalUnit.Id,
          Data: {
            ...organizationalUnit
          }
        };
      } else {
        throw error;
      }
    }
  }
  if (event.RequestType == "Update") {
    const organizationalUnit = await updateOrganizationalUnit(organizationsClient, event.PhysicalResourceId, Name);
    return {
      PhysicalResourceId: organizationalUnit.Id,
      Data: {
        ...organizationalUnit
      }
    };
  }
  if (event.RequestType == "Delete" && RemovalPolicy == "destroy") {
    await deleteOrganizationalUnit(organizationsClient, event.PhysicalResourceId);
  }
  return {
    PhysicalResourceId: event.PhysicalResourceId,
    Data: {
      ...event.ResourceProperties
    }
  };
};
var findOrganizationalUnitByParentAndName = async (client, parentId, name) => {
  let response = await client.listOrganizationalUnitsForParent({ ParentId: parentId }).promise();
  for (const organizationalUnit of response.OrganizationalUnits ?? []) {
    if (organizationalUnit.Name == name) {
      return organizationalUnit;
    }
  }
  while (response.NextToken) {
    response = await client.listOrganizationalUnitsForParent({ ParentId: parentId, NextToken: response.NextToken }).promise();
    for (const organizationalUnit of response.OrganizationalUnits ?? []) {
      if (organizationalUnit.Name == name) {
        return organizationalUnit;
      }
    }
  }
  throw new Error(`Organizational unit '${name}' not found in '${parentId}'`);
};
var createOrganizationalUnit = async (client, parentId, name) => {
  const response = await client.createOrganizationalUnit({
    ParentId: parentId,
    Name: name
  }).promise();
  console.log("Creating organizational unit: %j", response);
  if (!response.OrganizationalUnit) {
    throw new Error("Could not create organizational unit, reason: empty response");
  }
  return response.OrganizationalUnit;
};
var updateOrganizationalUnit = async (client, id, name) => {
  const response = await client.updateOrganizationalUnit({
    OrganizationalUnitId: id,
    Name: name
  }).promise();
  console.log("Updating organizational unit: %j", response);
  if (!response.OrganizationalUnit) {
    throw new Error("Could not update organizational unit, reason: empty response");
  }
  return response.OrganizationalUnit;
};
var deleteOrganizationalUnit = async (client, id) => {
  await client.deleteOrganizationalUnit({
    OrganizationalUnitId: id
  }).promise();
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
