var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/tag-resource-provider/on-event-handler.lambda.ts
var on_event_handler_lambda_exports = {};
__export(on_event_handler_lambda_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(on_event_handler_lambda_exports);
var import_aws_sdk = require("aws-sdk");
var organizationsClient;
async function handler(event) {
  console.log(`Request of type ${event.RequestType} received`);
  if (!organizationsClient) {
    organizationsClient = new import_aws_sdk.Organizations({ region: "us-east-1" });
  }
  console.log("Payload: %j", event);
  const listTagsForResourceResponse = await organizationsClient.listTagsForResource({
    ResourceId: event.ResourceProperties.ResourceId
  }).promise();
  const oldTags = listTagsForResourceResponse.Tags ?? [];
  const oldTagKeys = oldTags.map((tag) => tag.Key);
  const newTags = event.ResourceProperties.Tags ?? [];
  const newTagKeys = newTags.map((tag) => tag.Key);
  const tagKeysToRemove = oldTagKeys.filter((tagKey) => !newTagKeys.includes(tagKey));
  if (tagKeysToRemove.length) {
    await organizationsClient.untagResource({
      ResourceId: event.ResourceProperties.ResourceId,
      TagKeys: tagKeysToRemove
    }).promise();
  }
  if (event.RequestType == "Delete") {
    return { PhysicalResourceId: event.PhysicalResourceId };
  }
  if (newTags.length) {
    await organizationsClient.tagResource({
      ResourceId: event.ResourceProperties.ResourceId,
      Tags: newTags
    }).promise();
  }
  return { PhysicalResourceId: event.ResourceProperties.ResourceId, ResourceProperties: event.ResourceProperties };
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
