"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DependencyChain = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const account_1 = require("./account");
const delegated_administrator_1 = require("./delegated-administrator");
const enable_aws_service_access_1 = require("./enable-aws-service-access");
const enable_policy_type_1 = require("./enable-policy-type");
const organizational_unit_1 = require("./organizational-unit");
const policy_attachment_1 = require("./policy-attachment");
/**
 * Aspect to create dependency chain of organization resource that needs to be deployed sequentially
 * @experimental
 */
class DependencyChain {
    constructor() {
        this.previous = {};
    }
    visit(current) {
        if (!this.needsChaining(current)) {
            return;
        }
        const stackName = aws_cdk_lib_1.Stack.of(current).stackName;
        if (this.previous[stackName]) {
            current.node.addDependency(this.previous[stackName]);
        }
        this.previous[stackName] = current;
    }
    needsChaining(current) {
        switch (true) {
            case current instanceof enable_policy_type_1.EnablePolicyType:
                return true;
            case current instanceof enable_aws_service_access_1.EnableAwsServiceAccess:
                return true;
            case current instanceof delegated_administrator_1.DelegatedAdministrator:
                return true;
            case current instanceof account_1.Account:
                return true;
            case current instanceof organizational_unit_1.OrganizationalUnit:
                return true;
            case current instanceof policy_attachment_1.PolicyAttachment:
                return true;
            default:
                return false;
        }
    }
}
exports.DependencyChain = DependencyChain;
_a = JSII_RTTI_SYMBOL_1;
DependencyChain[_a] = { fqn: "@pepperize/cdk-organizations.DependencyChain", version: "0.7.173" };
//# sourceMappingURL=data:application/json;base64,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