import { Construct } from "constructs";
export interface EnableAwsServiceAccessProps {
    /**
     * The service principal name of the AWS service for which you want to enable integration with your organization. This is typically in the form of a URL, such as service-abbreviation.amazonaws.com.
     */
    readonly servicePrincipal: string;
}
/**
 * Enables the integration of an AWS service (the service that is specified by ServicePrincipal) with AWS Organizations. When you enable integration, you allow the specified service to create a service-linked role in all the accounts in your organization. This allows the service to perform operations on your behalf in your organization and its accounts.
 *
 * <strong>This operation can be called only from the organization's management account and only if the organization has enabled all features.</strong>
 *
 * @see https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_trusted_access_perms
 */
export declare class EnableAwsServiceAccess extends Construct {
    constructor(scope: Construct, id: string, props: EnableAwsServiceAccessProps);
}
