"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnableAwsServiceAccess = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
/**
 * Enables the integration of an AWS service (the service that is specified by ServicePrincipal) with AWS Organizations. When you enable integration, you allow the specified service to create a service-linked role in all the accounts in your organization. This allows the service to perform operations on your behalf in your organization and its accounts.
 *
 * <strong>This operation can be called only from the organization's management account and only if the organization has enabled all features.</strong>
 *
 * @see https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_trusted_access_perms
 */
class EnableAwsServiceAccess extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { servicePrincipal } = props;
        new custom_resources_1.AwsCustomResource(this, "EnableAwsServiceAccessCustomResource", {
            resourceType: "Custom::Organizations_EnableAwsServiceAccess",
            onCreate: {
                service: "Organizations",
                action: "enableAWSServiceAccess",
                region: "us-east-1",
                physicalResourceId: custom_resources_1.PhysicalResourceId.of(`${servicePrincipal}`),
                parameters: {
                    ServicePrincipal: servicePrincipal,
                },
            },
            onDelete: {
                service: "Organizations",
                action: "disableAWSServiceAccess",
                region: "us-east-1",
                parameters: {
                    ServicePrincipal: servicePrincipal,
                },
            },
            installLatestAwsSdk: false,
            policy: custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({
                resources: custom_resources_1.AwsCustomResourcePolicy.ANY_RESOURCE,
            }),
        });
    }
}
exports.EnableAwsServiceAccess = EnableAwsServiceAccess;
_a = JSII_RTTI_SYMBOL_1;
EnableAwsServiceAccess[_a] = { fqn: "@pepperize/cdk-organizations.EnableAwsServiceAccess", version: "0.7.173" };
//# sourceMappingURL=data:application/json;base64,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