"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.stack = exports.app = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const account_1 = require("./account");
const organization_1 = require("./organization");
const organizational_unit_1 = require("./organizational-unit");
const policy_1 = require("./policy");
const app = new aws_cdk_lib_1.App();
exports.app = app;
const stack = new aws_cdk_lib_1.Stack(app, undefined, { env: { account: "123456789012", region: "us-east-1" } });
exports.stack = stack;
// Create an organization
const organization = new organization_1.Organization(stack, "Organization", {
    featureSet: organization_1.FeatureSet.ALL,
});
// Enable AWS Service Access (requires FeatureSet: ALL)
organization.enableAwsServiceAccess("service-abbreviation.amazonaws.com");
organization.enableAwsServiceAccess("ssm.amazonaws.com");
organization.enableAwsServiceAccess("config-multiaccountsetup.amazonaws.com");
// Import an existing account
const account = new account_1.Account(stack, "ImportedAccount", {
    accountName: "test",
    email: "info+integ-test@pepperize.com",
    parent: organization.root,
});
// Enable a delegated admin account
account.delegateAdministrator("service-abbreviation.amazonaws.com");
account.delegateAdministrator("stacksets.cloudformation.amazonaws.com");
account.delegateAdministrator("config.amazonaws.com");
const projects = new organizational_unit_1.OrganizationalUnit(stack, "ProjectsOU", {
    organizationalUnitName: "Projects",
    parent: organization.root,
});
new account_1.Account(stack, "Project1Account", {
    accountName: "SharedAccount",
    email: "info+project1@pepperize.com",
    iamUserAccessToBilling: account_1.IamUserAccessToBilling.DENY,
    parent: projects,
});
const project2 = new organizational_unit_1.OrganizationalUnit(stack, "Project2OU", {
    organizationalUnitName: "Project2",
    parent: projects,
});
new account_1.Account(stack, "Project2DevAccount", {
    accountName: "Project 2 Dev",
    email: "info+project2-dev@pepperize.com",
    parent: project2,
});
// Enable the service control policy (SCP) type within the organization
organization.enablePolicyType(policy_1.PolicyType.SERVICE_CONTROL_POLICY);
// Create and attach Service Control Policy (SCP)
const s3Policy = new policy_1.Policy(stack, "S3Policy", {
    content: '{\n"Version":"2012-10-17","Statement":{\n"Effect":"Allow","Action":"s3:*"\n}\n}',
    description: "Enables admins of attached accounts to delegate all S3 permissions",
    policyName: "AllowAllS3Actions",
    policyType: policy_1.PolicyType.SERVICE_CONTROL_POLICY,
});
organization.attachPolicy(s3Policy);
// Enable the tag policy type within the organization
organization.enablePolicyType(policy_1.PolicyType.TAG_POLICY);
// Create and attach tag Policy
const tagPolicy = new policy_1.Policy(stack, "TagPolicy", {
    content: '{\n"tags":{\n"CostCenter":{\n"tag_key":{\n"@@assign":"CostCenter"\n}\n}\n}\n}',
    description: "Defines the CostCenter tag key",
    policyName: "CostCenterTag",
    policyType: policy_1.PolicyType.TAG_POLICY,
});
// Attach policy to an organizational unit (OU)
projects.attachPolicy(tagPolicy);
// Attach policies to an account
account.attachPolicy(tagPolicy);
account.attachPolicy(s3Policy);
// Tagging AWS organization resources of this stack
aws_cdk_lib_1.Tags.of(stack).add("tagKey", "tagValue");
//# sourceMappingURL=data:application/json;base64,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