import { NestedStack, NestedStackProps } from "aws-cdk-lib";
import { Function } from "aws-cdk-lib/aws-lambda";
import { Provider } from "aws-cdk-lib/custom-resources";
import { Construct } from "constructs";
export interface OrganizationProviderProps extends NestedStackProps {
}
/**
 * Creates a custom resource provider to create the organization in AWS organization.
 *
 * <strong>If the organization already exists, it will be just returned.</strong>
 * <strong>Organization deletion is currently not supported!</strong>
 *
 * @see https://docs.aws.amazon.com/cdk/api/v1/docs/custom-resources-readme.html#provider-framework
 */
export declare class OrganizationProvider extends NestedStack {
    /**
     * Retrieve OrganizationProvider as stack singleton resource.
     *
     * @see https://github.com/aws/aws-cdk/issues/5023
     */
    static getOrCreate(scope: Construct): OrganizationProvider;
    /**
     * Creates an Organization and returns the result from describeOrganization.
     *
     * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/Organizations.html#createOrganization-property
     * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/Organizations.html#describeOrganization-property
     */
    readonly onEventHandler: Function;
    /**
     * The provider to create or describe an organization.
     *
     * @see https://docs.aws.amazon.com/cdk/api/v1/docs/custom-resources-readme.html#asynchronous-providers-iscomplete
     */
    readonly provider: Provider;
    constructor(scope: Construct, id: string, props: OrganizationProviderProps);
}
