import { NestedStack, NestedStackProps } from "aws-cdk-lib";
import { Function } from "aws-cdk-lib/aws-lambda";
import { Provider } from "aws-cdk-lib/custom-resources";
import { Construct } from "constructs";
export interface OrganizationalUnitProviderProps extends NestedStackProps {
}
/**
 * Creates a custom resource provider to create the organizational unit in AWS organization.
 *
 * <ul>
 *   <li><strong>If the organizational unit already exists, it will be imported if `ImportOnDuplicate` is true.</strong>
 *   <li><strong>Only an emptied organizational unit can be deleted!</strong></li>
 * </ul>
 *
 * @see https://docs.aws.amazon.com/cdk/api/v1/docs/custom-resources-readme.html#provider-framework
 */
export declare class OrganizationalUnitProvider extends NestedStack {
    /**
     * Retrieve OrganizationalUnitProvider as stack singleton resource.
     *
     * @see https://github.com/aws/aws-cdk/issues/5023
     */
    static getOrCreate(scope: Construct): OrganizationalUnitProvider;
    /**
     * Creates an Organizational Unit (OU) and returns the result.
     *
     * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/Organizations.html#createOrganizationalUnit-property
     * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/Organizations.html#listOrganizationalUnitsForParent-property
     */
    readonly onEventHandler: Function;
    /**
     * The provider to create, update or delete an organizational unit.
     *
     * @see https://docs.aws.amazon.com/cdk/api/v1/docs/custom-resources-readme.html#asynchronous-providers-iscomplete
     */
    readonly provider: Provider;
    constructor(scope: Construct, id: string, props: OrganizationalUnitProviderProps);
}
