import { Construct, IConstruct } from "constructs";
import { IResource } from "./resource";
export interface IParent extends IConstruct, IResource {
}
export interface IChild extends IConstruct, IResource {
}
export interface ParentProps {
    readonly child: IChild;
}
export interface ParentBaseProps {
    readonly childId: string;
}
export declare abstract class ParentBase extends Construct implements IParent {
    readonly parentId: string;
    protected constructor(scope: Construct, id: string, props: ParentBaseProps);
    identifier(): string;
}
export declare class Parent extends ParentBase {
    static fromChildId(scope: Construct, id: string, childId: string): IParent;
    constructor(scope: Construct, id: string, props: ParentProps);
}
