import { Construct, IDependable } from "constructs";
import { IPolicy } from "./policy";
import { IResource } from "./resource";
export interface IPolicyAttachmentTarget extends IDependable, IResource {
}
export interface PolicyAttachmentProps {
    /**
     * The root, OU, or account that you want to attach the policy to.
     */
    readonly target: IPolicyAttachmentTarget;
    /**
     * The policy that you want to attach to the target.
     */
    readonly policy: IPolicy;
}
/**
 * Attaches a policy to a root, an organizational unit (OU), or an individual account. How the policy affects accounts depends on the type of policy. Refer to the AWS Organizations User Guide for information about each policy type:
 */
export declare class PolicyAttachment extends Construct {
    constructor(scope: Construct, id: string, props: PolicyAttachmentProps);
}
