import { NestedStack, NestedStackProps } from "aws-cdk-lib";
import { Function } from "aws-cdk-lib/aws-lambda";
import { Provider } from "aws-cdk-lib/custom-resources";
import { Construct } from "constructs";
export interface TagResourceProviderProps extends NestedStackProps {
}
/**
 * Creates a custom resource provider to asynchronously attach tags to resources in AWS Organizations.
 *
 * @see https://docs.aws.amazon.com/cdk/api/v1/docs/custom-resources-readme.html#provider-framework
 */
export declare class TagResourceProvider extends NestedStack {
    /**
     * Retrieve TagResourceProvider as stack singleton resource.
     *
     * @see https://github.com/aws/aws-cdk/issues/5023
     */
    static getOrCreate(scope: Construct): TagResourceProvider;
    /**
     * Adds one or more tags to the specified resource.
     *
     * @see https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.custom_resources-readme.html#handling-lifecycle-events-onevent
     * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/Organizations.html#tagResource-property
     * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/Organizations.html#untagResource-property
     */
    readonly onEventHandler: Function;
    /**
     * The provider to tag or untag the resource
     *
     * @see https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.custom_resources-readme.html#provider-framework
     */
    readonly provider: Provider;
    constructor(scope: Construct, id: string, props: TagResourceProviderProps);
}
