"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TagResourceProvider = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const on_event_handler_function_1 = require("./on-event-handler-function");
/**
 * Creates a custom resource provider to asynchronously attach tags to resources in AWS Organizations.
 *
 * @see https://docs.aws.amazon.com/cdk/api/v1/docs/custom-resources-readme.html#provider-framework
 */
class TagResourceProvider extends aws_cdk_lib_1.NestedStack {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.onEventHandler = new on_event_handler_function_1.OnEventHandlerFunction(this, "OnEventHandlerFunction", {
            timeout: aws_cdk_lib_1.Duration.minutes(10),
            initialPolicy: [
                new aws_iam_1.PolicyStatement({
                    actions: ["organizations:ListTagsForResource", "organizations:TagResource", "organizations:UntagResource"],
                    resources: ["*"],
                }),
            ],
        });
        this.provider = new custom_resources_1.Provider(this, "Provider", {
            onEventHandler: this.onEventHandler,
        });
    }
    /**
     * Retrieve TagResourceProvider as stack singleton resource.
     *
     * @see https://github.com/aws/aws-cdk/issues/5023
     */
    static getOrCreate(scope) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const id = "cdk-organizations.TagResourceProvider";
        const existing = stack.node.tryFindChild(id);
        return existing || new TagResourceProvider(stack, id, {});
    }
}
exports.TagResourceProvider = TagResourceProvider;
//# sourceMappingURL=data:application/json;base64,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