import { ITaggable } from "aws-cdk-lib";
import { IResolvable } from "aws-cdk-lib/core/lib/resolvable";
import { Construct } from "constructs";
export interface ITaggableResource extends ITaggable {
}
export interface TagResourceProps {
    readonly resourceId: string;
    readonly tags: IResolvable;
}
/**
 * Add tags to an AWS Organizations resource to make it easier to identify, organize, and search.
 *
 * @see https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html
 * @see https://docs.aws.amazon.com/ARG/latest/APIReference/API_Tag.html
 */
export declare class TagResource extends Construct {
    constructor(scope: Construct, id: string, props: TagResourceProps);
}
