"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TagResource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const tag_resource_provider_1 = require("./tag-resource-provider");
/**
 * Add tags to an AWS Organizations resource to make it easier to identify, organize, and search.
 *
 * @see https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html
 * @see https://docs.aws.amazon.com/ARG/latest/APIReference/API_Tag.html
 */
class TagResource extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { resourceId, tags } = props;
        const tagResourceProvider = tag_resource_provider_1.TagResourceProvider.getOrCreate(this);
        new aws_cdk_lib_1.CustomResource(this, "TagResource", {
            serviceToken: tagResourceProvider.provider.serviceToken,
            resourceType: "Custom::Organizations_TagResource",
            properties: {
                ResourceId: resourceId,
                Tags: tags,
            },
        });
    }
}
exports.TagResource = TagResource;
_a = JSII_RTTI_SYMBOL_1;
TagResource[_a] = { fqn: "@pepperize/cdk-organizations.TagResource", version: "0.7.173" };
//# sourceMappingURL=data:application/json;base64,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