# -*- coding: utf8 -*-
# Copyright (c) 2017-2021 THL A29 Limited, a Tencent company. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class ABTestConfig(AbstractModel):
    """灰度项目配置

    """

    def __init__(self):
        r"""
        :param _ProjectName: 灰度项目名称
        :type ProjectName: str
        :param _Status: true：正在灰度，false：不在灰度
        :type Status: bool
        """
        self._ProjectName = None
        self._Status = None

    @property
    def ProjectName(self):
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._ProjectName = params.get("ProjectName")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AbnormalProcessChildRuleInfo(AbstractModel):
    """容器运行时安全，子策略信息

    """

    def __init__(self):
        r"""
        :param _RuleMode: 策略模式，   RULE_MODE_RELEASE: 放行
   RULE_MODE_ALERT: 告警
   RULE_MODE_HOLDUP:拦截
        :type RuleMode: str
        :param _ProcessPath: 进程路径
        :type ProcessPath: str
        :param _RuleId: 子策略id
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleId: str
        :param _RuleLevel: 威胁等级，HIGH:高，MIDDLE:中，LOW:低
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleLevel: str
        """
        self._RuleMode = None
        self._ProcessPath = None
        self._RuleId = None
        self._RuleLevel = None

    @property
    def RuleMode(self):
        return self._RuleMode

    @RuleMode.setter
    def RuleMode(self, RuleMode):
        self._RuleMode = RuleMode

    @property
    def ProcessPath(self):
        return self._ProcessPath

    @ProcessPath.setter
    def ProcessPath(self, ProcessPath):
        self._ProcessPath = ProcessPath

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RuleLevel(self):
        return self._RuleLevel

    @RuleLevel.setter
    def RuleLevel(self, RuleLevel):
        self._RuleLevel = RuleLevel


    def _deserialize(self, params):
        self._RuleMode = params.get("RuleMode")
        self._ProcessPath = params.get("ProcessPath")
        self._RuleId = params.get("RuleId")
        self._RuleLevel = params.get("RuleLevel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AbnormalProcessEventDescription(AbstractModel):
    """运行时容器访问控制事件描述信息

    """

    def __init__(self):
        r"""
        :param _Description: 事件规则
        :type Description: str
        :param _Solution: 解决方案
        :type Solution: str
        :param _Remark: 事件备注信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Remark: str
        :param _MatchRule: 命中规则详细信息
        :type MatchRule: :class:`tencentcloud.tcss.v20201101.models.AbnormalProcessChildRuleInfo`
        :param _RuleName: 命中规则名称，PROXY_TOOL：代理软件，TRANSFER_CONTROL：横向渗透，ATTACK_CMD：恶意命令，REVERSE_SHELL：反弹shell，FILELESS：无文件程序执行，RISK_CMD：高危命令，ABNORMAL_CHILD_PROC：敏感服务异常子进程启动，USER_DEFINED_RULE：用户自定义规则
        :type RuleName: str
        :param _RuleId: 命中规则的id
        :type RuleId: str
        :param _OperationTime: 事件最后一次处理的时间
注意：此字段可能返回 null，表示取不到有效值。
        :type OperationTime: str
        :param _GroupName: 命中策略名称：SYSTEM_DEFINED_RULE （系统策略）或  用户自定义的策略名字
注意：此字段可能返回 null，表示取不到有效值。
        :type GroupName: str
        """
        self._Description = None
        self._Solution = None
        self._Remark = None
        self._MatchRule = None
        self._RuleName = None
        self._RuleId = None
        self._OperationTime = None
        self._GroupName = None

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Solution(self):
        return self._Solution

    @Solution.setter
    def Solution(self, Solution):
        self._Solution = Solution

    @property
    def Remark(self):
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def MatchRule(self):
        return self._MatchRule

    @MatchRule.setter
    def MatchRule(self, MatchRule):
        self._MatchRule = MatchRule

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def OperationTime(self):
        return self._OperationTime

    @OperationTime.setter
    def OperationTime(self, OperationTime):
        self._OperationTime = OperationTime

    @property
    def GroupName(self):
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName


    def _deserialize(self, params):
        self._Description = params.get("Description")
        self._Solution = params.get("Solution")
        self._Remark = params.get("Remark")
        if params.get("MatchRule") is not None:
            self._MatchRule = AbnormalProcessChildRuleInfo()
            self._MatchRule._deserialize(params.get("MatchRule"))
        self._RuleName = params.get("RuleName")
        self._RuleId = params.get("RuleId")
        self._OperationTime = params.get("OperationTime")
        self._GroupName = params.get("GroupName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AbnormalProcessEventInfo(AbstractModel):
    """容器运行时安全异常进程信息

    """

    def __init__(self):
        r"""
        :param _ProcessPath: 进程目录
        :type ProcessPath: str
        :param _EventType: 事件类型，MALICE_PROCESS_START:恶意进程启动
        :type EventType: str
        :param _MatchRuleName: 命中规则名称，PROXY_TOOL：代理软件，TRANSFER_CONTROL：横向渗透，ATTACK_CMD：恶意命令，REVERSE_SHELL：反弹shell，FILELESS：无文件程序执行，RISK_CMD：高危命令，ABNORMAL_CHILD_PROC：敏感服务异常子进程启动，USER_DEFINED_RULE：用户自定义规则
        :type MatchRuleName: str
        :param _FoundTime: 生成时间
        :type FoundTime: str
        :param _ContainerName: 容器名
        :type ContainerName: str
        :param _ImageName: 镜像名
        :type ImageName: str
        :param _Behavior: 动作执行结果，    BEHAVIOR_NONE: 无
    BEHAVIOR_ALERT: 告警
    BEHAVIOR_RELEASE：放行
    BEHAVIOR_HOLDUP_FAILED:拦截失败
    BEHAVIOR_HOLDUP_SUCCESSED：拦截失败
        :type Behavior: str
        :param _Status: 状态，EVENT_UNDEAL:事件未处理
    EVENT_DEALED:事件已经处理
    EVENT_INGNORE：事件已经忽略
        :type Status: str
        :param _Id: 事件记录的唯一id
        :type Id: str
        :param _ImageId: 镜像id，用于跳转
        :type ImageId: str
        :param _ContainerId: 容器id，用于跳转
        :type ContainerId: str
        :param _Solution: 事件解决方案
        :type Solution: str
        :param _Description: 事件详细描述
        :type Description: str
        :param _MatchRuleId: 命中策略id
        :type MatchRuleId: str
        :param _MatchAction: 命中规则行为：
RULE_MODE_RELEASE 放行
RULE_MODE_ALERT  告警
RULE_MODE_HOLDUP 拦截
        :type MatchAction: str
        :param _MatchProcessPath: 命中规则进程信息
        :type MatchProcessPath: str
        :param _RuleExist: 规则是否存在
        :type RuleExist: bool
        :param _EventCount: 事件数量
        :type EventCount: int
        :param _LatestFoundTime: 最近生成时间
        :type LatestFoundTime: str
        :param _RuleId: 规则组Id
        :type RuleId: str
        :param _MatchGroupName: 命中策略名称：SYSTEM_DEFINED_RULE （系统策略）或  用户自定义的策略名字
        :type MatchGroupName: str
        :param _MatchRuleLevel: 命中规则等级，HIGH：高危，MIDDLE：中危，LOW：低危。
        :type MatchRuleLevel: str
        :param _ContainerNetStatus: 网络状态
未隔离  	NORMAL
已隔离		ISOLATED
隔离中		ISOLATING
隔离失败	ISOLATE_FAILED
解除隔离中  RESTORING
解除隔离失败 RESTORE_FAILED
注意：此字段可能返回 null，表示取不到有效值。
        :type ContainerNetStatus: str
        :param _ContainerNetSubStatus: 容器子状态
"AGENT_OFFLINE"       //Agent离线
"NODE_DESTROYED"      //节点已销毁
"CONTAINER_EXITED"    //容器已退出
"CONTAINER_DESTROYED" //容器已销毁
"SHARED_HOST"         // 容器与主机共享网络
"RESOURCE_LIMIT"      //隔离操作资源超限
"UNKNOW"              // 原因未知
注意：此字段可能返回 null，表示取不到有效值。
        :type ContainerNetSubStatus: str
        :param _ContainerIsolateOperationSrc: 容器隔离操作来源
注意：此字段可能返回 null，表示取不到有效值。
        :type ContainerIsolateOperationSrc: str
        :param _ContainerStatus: 容器状态
正在运行: RUNNING
暂停: PAUSED
停止: STOPPED
已经创建: CREATED
已经销毁: DESTROYED
正在重启中: RESTARTING
迁移中: REMOVING
        :type ContainerStatus: str
        :param _ClusterID: 集群ID
        :type ClusterID: str
        :param _NodeType: 节点类型：NORMAL普通节点、SUPER超级节点
        :type NodeType: str
        :param _PodName: pod 名称
        :type PodName: str
        :param _PodIP: pod ip
        :type PodIP: str
        :param _NodeUniqueID: 集群id
        :type NodeUniqueID: str
        :param _PublicIP: 节点公网ip
        :type PublicIP: str
        :param _NodeName: 节点名称
        :type NodeName: str
        :param _NodeID: 节点id
        :type NodeID: str
        :param _HostID: uuid
        :type HostID: str
        :param _HostIP: 节点内网ip
        :type HostIP: str
        :param _ClusterName: 集群名称
        :type ClusterName: str
        """
        self._ProcessPath = None
        self._EventType = None
        self._MatchRuleName = None
        self._FoundTime = None
        self._ContainerName = None
        self._ImageName = None
        self._Behavior = None
        self._Status = None
        self._Id = None
        self._ImageId = None
        self._ContainerId = None
        self._Solution = None
        self._Description = None
        self._MatchRuleId = None
        self._MatchAction = None
        self._MatchProcessPath = None
        self._RuleExist = None
        self._EventCount = None
        self._LatestFoundTime = None
        self._RuleId = None
        self._MatchGroupName = None
        self._MatchRuleLevel = None
        self._ContainerNetStatus = None
        self._ContainerNetSubStatus = None
        self._ContainerIsolateOperationSrc = None
        self._ContainerStatus = None
        self._ClusterID = None
        self._NodeType = None
        self._PodName = None
        self._PodIP = None
        self._NodeUniqueID = None
        self._PublicIP = None
        self._NodeName = None
        self._NodeID = None
        self._HostID = None
        self._HostIP = None
        self._ClusterName = None

    @property
    def ProcessPath(self):
        return self._ProcessPath

    @ProcessPath.setter
    def ProcessPath(self, ProcessPath):
        self._ProcessPath = ProcessPath

    @property
    def EventType(self):
        return self._EventType

    @EventType.setter
    def EventType(self, EventType):
        self._EventType = EventType

    @property
    def MatchRuleName(self):
        return self._MatchRuleName

    @MatchRuleName.setter
    def MatchRuleName(self, MatchRuleName):
        self._MatchRuleName = MatchRuleName

    @property
    def FoundTime(self):
        return self._FoundTime

    @FoundTime.setter
    def FoundTime(self, FoundTime):
        self._FoundTime = FoundTime

    @property
    def ContainerName(self):
        return self._ContainerName

    @ContainerName.setter
    def ContainerName(self, ContainerName):
        self._ContainerName = ContainerName

    @property
    def ImageName(self):
        return self._ImageName

    @ImageName.setter
    def ImageName(self, ImageName):
        self._ImageName = ImageName

    @property
    def Behavior(self):
        return self._Behavior

    @Behavior.setter
    def Behavior(self, Behavior):
        self._Behavior = Behavior

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ImageId(self):
        return self._ImageId

    @ImageId.setter
    def ImageId(self, ImageId):
        self._ImageId = ImageId

    @property
    def ContainerId(self):
        return self._ContainerId

    @ContainerId.setter
    def ContainerId(self, ContainerId):
        self._ContainerId = ContainerId

    @property
    def Solution(self):
        return self._Solution

    @Solution.setter
    def Solution(self, Solution):
        self._Solution = Solution

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def MatchRuleId(self):
        return self._MatchRuleId

    @MatchRuleId.setter
    def MatchRuleId(self, MatchRuleId):
        self._MatchRuleId = MatchRuleId

    @property
    def MatchAction(self):
        return self._MatchAction

    @MatchAction.setter
    def MatchAction(self, MatchAction):
        self._MatchAction = MatchAction

    @property
    def MatchProcessPath(self):
        return self._MatchProcessPath

    @MatchProcessPath.setter
    def MatchProcessPath(self, MatchProcessPath):
        self._MatchProcessPath = MatchProcessPath

    @property
    def RuleExist(self):
        return self._RuleExist

    @RuleExist.setter
    def RuleExist(self, RuleExist):
        self._RuleExist = RuleExist

    @property
    def EventCount(self):
        return self._EventCount

    @EventCount.setter
    def EventCount(self, EventCount):
        self._EventCount = EventCount

    @property
    def LatestFoundTime(self):
        return self._LatestFoundTime

    @LatestFoundTime.setter
    def LatestFoundTime(self, LatestFoundTime):
        self._LatestFoundTime = LatestFoundTime

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def MatchGroupName(self):
        return self._MatchGroupName

    @MatchGroupName.setter
    def MatchGroupName(self, MatchGroupName):
        self._MatchGroupName = MatchGroupName

    @property
    def MatchRuleLevel(self):
        return self._MatchRuleLevel

    @MatchRuleLevel.setter
    def MatchRuleLevel(self, MatchRuleLevel):
        self._MatchRuleLevel = MatchRuleLevel

    @property
    def ContainerNetStatus(self):
        return self._ContainerNetStatus

    @ContainerNetStatus.setter
    def ContainerNetStatus(self, ContainerNetStatus):
        self._ContainerNetStatus = ContainerNetStatus

    @property
    def ContainerNetSubStatus(self):
        return self._ContainerNetSubStatus

    @ContainerNetSubStatus.setter
    def ContainerNetSubStatus(self, ContainerNetSubStatus):
        self._ContainerNetSubStatus = ContainerNetSubStatus

    @property
    def ContainerIsolateOperationSrc(self):
        return self._ContainerIsolateOperationSrc

    @ContainerIsolateOperationSrc.setter
    def ContainerIsolateOperationSrc(self, ContainerIsolateOperationSrc):
        self._ContainerIsolateOperationSrc = ContainerIsolateOperationSrc

    @property
    def ContainerStatus(self):
        return self._ContainerStatus

    @ContainerStatus.setter
    def ContainerStatus(self, ContainerStatus):
        self._ContainerStatus = ContainerStatus

    @property
    def ClusterID(self):
        return self._ClusterID

    @ClusterID.setter
    def ClusterID(self, ClusterID):
        self._ClusterID = ClusterID

    @property
    def NodeType(self):
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def PodName(self):
        return self._PodName

    @PodName.setter
    def PodName(self, PodName):
        self._PodName = PodName

    @property
    def PodIP(self):
        return self._PodIP

    @PodIP.setter
    def PodIP(self, PodIP):
        self._PodIP = PodIP

    @property
    def NodeUniqueID(self):
        return self._NodeUniqueID

    @NodeUniqueID.setter
    def NodeUniqueID(self, NodeUniqueID):
        self._NodeUniqueID = NodeUniqueID

    @property
    def PublicIP(self):
        return self._PublicIP

    @PublicIP.setter
    def PublicIP(self, PublicIP):
        self._PublicIP = PublicIP

    @property
    def NodeName(self):
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def NodeID(self):
        return self._NodeID

    @NodeID.setter
    def NodeID(self, NodeID):
        self._NodeID = NodeID

    @property
    def HostID(self):
        return self._HostID

    @HostID.setter
    def HostID(self, HostID):
        self._HostID = HostID

    @property
    def HostIP(self):
        return self._HostIP

    @HostIP.setter
    def HostIP(self, HostIP):
        self._HostIP = HostIP

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName


    def _deserialize(self, params):
        self._ProcessPath = params.get("ProcessPath")
        self._EventType = params.get("EventType")
        self._MatchRuleName = params.get("MatchRuleName")
        self._FoundTime = params.get("FoundTime")
        self._ContainerName = params.get("ContainerName")
        self._ImageName = params.get("ImageName")
        self._Behavior = params.get("Behavior")
        self._Status = params.get("Status")
        self._Id = params.get("Id")
        self._ImageId = params.get("ImageId")
        self._ContainerId = params.get("ContainerId")
        self._Solution = params.get("Solution")
        self._Description = params.get("Description")
        self._MatchRuleId = params.get("MatchRuleId")
        self._MatchAction = params.get("MatchAction")
        self._MatchProcessPath = params.get("MatchProcessPath")
        self._RuleExist = params.get("RuleExist")
        self._EventCount = params.get("EventCount")
        self._LatestFoundTime = params.get("LatestFoundTime")
        self._RuleId = params.get("RuleId")
        self._MatchGroupName = params.get("MatchGroupName")
        self._MatchRuleLevel = params.get("MatchRuleLevel")
        self._ContainerNetStatus = params.get("ContainerNetStatus")
        self._ContainerNetSubStatus = params.get("ContainerNetSubStatus")
        self._ContainerIsolateOperationSrc = params.get("ContainerIsolateOperationSrc")
        self._ContainerStatus = params.get("ContainerStatus")
        self._ClusterID = params.get("ClusterID")
        self._NodeType = params.get("NodeType")
        self._PodName = params.get("PodName")
        self._PodIP = params.get("PodIP")
        self._NodeUniqueID = params.get("NodeUniqueID")
        self._PublicIP = params.get("PublicIP")
        self._NodeName = params.get("NodeName")
        self._NodeID = params.get("NodeID")
        self._HostID = params.get("HostID")
        self._HostIP = params.get("HostIP")
        self._ClusterName = params.get("ClusterName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AbnormalProcessEventTendencyInfo(AbstractModel):
    """待处理异常进程事件趋势

    """

    def __init__(self):
        r"""
        :param _Date: 日期
        :type Date: str
        :param _ProxyToolEventCount: 待处理代理软件事件数
        :type ProxyToolEventCount: int
        :param _TransferControlEventCount: 待处理横向参透事件数
        :type TransferControlEventCount: int
        :param _AttackCmdEventCount: 待处理恶意命令事件数
        :type AttackCmdEventCount: int
        :param _ReverseShellEventCount: 待处理反弹shell事件数
        :type ReverseShellEventCount: int
        :param _FilelessEventCount: 待处理无文件程序执行事件数
        :type FilelessEventCount: int
        :param _RiskCmdEventCount: 待处理高危命令事件数
        :type RiskCmdEventCount: int
        :param _AbnormalChildProcessEventCount: 待处理敏感服务异常子进程启动事件数
        :type AbnormalChildProcessEventCount: int
        :param _UserDefinedRuleEventCount: 待处理自定义规则事件数
        :type UserDefinedRuleEventCount: int
        """
        self._Date = None
        self._ProxyToolEventCount = None
        self._TransferControlEventCount = None
        self._AttackCmdEventCount = None
        self._ReverseShellEventCount = None
        self._FilelessEventCount = None
        self._RiskCmdEventCount = None
        self._AbnormalChildProcessEventCount = None
        self._UserDefinedRuleEventCount = None

    @property
    def Date(self):
        return self._Date

    @Date.setter
    def Date(self, Date):
        self._Date = Date

    @property
    def ProxyToolEventCount(self):
        return self._ProxyToolEventCount

    @ProxyToolEventCount.setter
    def ProxyToolEventCount(self, ProxyToolEventCount):
        self._ProxyToolEventCount = ProxyToolEventCount

    @property
    def TransferControlEventCount(self):
        return self._TransferControlEventCount

    @TransferControlEventCount.setter
    def TransferControlEventCount(self, TransferControlEventCount):
        self._TransferControlEventCount = TransferControlEventCount

    @property
    def AttackCmdEventCount(self):
        return self._AttackCmdEventCount

    @AttackCmdEventCount.setter
    def AttackCmdEventCount(self, AttackCmdEventCount):
        self._AttackCmdEventCount = AttackCmdEventCount

    @property
    def ReverseShellEventCount(self):
        return self._ReverseShellEventCount

    @ReverseShellEventCount.setter
    def ReverseShellEventCount(self, ReverseShellEventCount):
        self._ReverseShellEventCount = ReverseShellEventCount

    @property
    def FilelessEventCount(self):
        return self._FilelessEventCount

    @FilelessEventCount.setter
    def FilelessEventCount(self, FilelessEventCount):
        self._FilelessEventCount = FilelessEventCount

    @property
    def RiskCmdEventCount(self):
        return self._RiskCmdEventCount

    @RiskCmdEventCount.setter
    def RiskCmdEventCount(self, RiskCmdEventCount):
        self._RiskCmdEventCount = RiskCmdEventCount

    @property
    def AbnormalChildProcessEventCount(self):
        return self._AbnormalChildProcessEventCount

    @AbnormalChildProcessEventCount.setter
    def AbnormalChildProcessEventCount(self, AbnormalChildProcessEventCount):
        self._AbnormalChildProcessEventCount = AbnormalChildProcessEventCount

    @property
    def UserDefinedRuleEventCount(self):
        return self._UserDefinedRuleEventCount

    @UserDefinedRuleEventCount.setter
    def UserDefinedRuleEventCount(self, UserDefinedRuleEventCount):
        self._UserDefinedRuleEventCount = UserDefinedRuleEventCount


    def _deserialize(self, params):
        self._Date = params.get("Date")
        self._ProxyToolEventCount = params.get("ProxyToolEventCount")
        self._TransferControlEventCount = params.get("TransferControlEventCount")
        self._AttackCmdEventCount = params.get("AttackCmdEventCount")
        self._ReverseShellEventCount = params.get("ReverseShellEventCount")
        self._FilelessEventCount = params.get("FilelessEventCount")
        self._RiskCmdEventCount = params.get("RiskCmdEventCount")
        self._AbnormalChildProcessEventCount = params.get("AbnormalChildProcessEventCount")
        self._UserDefinedRuleEventCount = params.get("UserDefinedRuleEventCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AbnormalProcessRuleInfo(AbstractModel):
    """运行时安全，异常进程检测策略

    """

    def __init__(self):
        r"""
        :param _IsEnable: true:策略启用，false:策略禁用
        :type IsEnable: bool
        :param _ImageIds: 生效镜像id，空数组代表全部镜像
        :type ImageIds: list of str
        :param _ChildRules: 用户策略的子策略数组
        :type ChildRules: list of AbnormalProcessChildRuleInfo
        :param _RuleName: 策略名字
        :type RuleName: str
        :param _RuleId: 策略id
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleId: str
        :param _SystemChildRules: 系统策略的子策略数组
        :type SystemChildRules: list of AbnormalProcessSystemChildRuleInfo
        :param _IsDefault: 是否是系统默认策略
        :type IsDefault: bool
        """
        self._IsEnable = None
        self._ImageIds = None
        self._ChildRules = None
        self._RuleName = None
        self._RuleId = None
        self._SystemChildRules = None
        self._IsDefault = None

    @property
    def IsEnable(self):
        return self._IsEnable

    @IsEnable.setter
    def IsEnable(self, IsEnable):
        self._IsEnable = IsEnable

    @property
    def ImageIds(self):
        return self._ImageIds

    @ImageIds.setter
    def ImageIds(self, ImageIds):
        self._ImageIds = ImageIds

    @property
    def ChildRules(self):
        return self._ChildRules

    @ChildRules.setter
    def ChildRules(self, ChildRules):
        self._ChildRules = ChildRules

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def SystemChildRules(self):
        return self._SystemChildRules

    @SystemChildRules.setter
    def SystemChildRules(self, SystemChildRules):
        self._SystemChildRules = SystemChildRules

    @property
    def IsDefault(self):
        return self._IsDefault

    @IsDefault.setter
    def IsDefault(self, IsDefault):
        self._IsDefault = IsDefault


    def _deserialize(self, params):
        self._IsEnable = params.get("IsEnable")
        self._ImageIds = params.get("ImageIds")
        if params.get("ChildRules") is not None:
            self._ChildRules = []
            for item in params.get("ChildRules"):
                obj = AbnormalProcessChildRuleInfo()
                obj._deserialize(item)
                self._ChildRules.append(obj)
        self._RuleName = params.get("RuleName")
        self._RuleId = params.get("RuleId")
        if params.get("SystemChildRules") is not None:
            self._SystemChildRules = []
            for item in params.get("SystemChildRules"):
                obj = AbnormalProcessSystemChildRuleInfo()
                obj._deserialize(item)
                self._SystemChildRules.append(obj)
        self._IsDefault = params.get("IsDefault")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AbnormalProcessSystemChildRuleInfo(AbstractModel):
    """异常进程系统策略的子策略信息

    """

    def __init__(self):
        r"""
        :param _RuleId: 子策略Id
        :type RuleId: str
        :param _IsEnable: 子策略状态，true为开启，false为关闭
        :type IsEnable: bool
        :param _RuleMode: 策略模式,  RULE_MODE_RELEASE: 放行
   RULE_MODE_ALERT: 告警
   RULE_MODE_HOLDUP:拦截
        :type RuleMode: str
        :param _RuleType: 子策略检测的行为类型
PROXY_TOOL： 代理软件
TRANSFER_CONTROL：横向渗透
ATTACK_CMD： 恶意命令
REVERSE_SHELL：反弹shell
FILELESS：无文件程序执行
RISK_CMD：高危命令
ABNORMAL_CHILD_PROC: 敏感服务异常子进程启动
        :type RuleType: str
        :param _RuleLevel: 威胁等级，HIGH:高，MIDDLE:中，LOW:低
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleLevel: str
        """
        self._RuleId = None
        self._IsEnable = None
        self._RuleMode = None
        self._RuleType = None
        self._RuleLevel = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def IsEnable(self):
        return self._IsEnable

    @IsEnable.setter
    def IsEnable(self, IsEnable):
        self._IsEnable = IsEnable

    @property
    def RuleMode(self):
        return self._RuleMode

    @RuleMode.setter
    def RuleMode(self, RuleMode):
        self._RuleMode = RuleMode

    @property
    def RuleType(self):
        return self._RuleType

    @RuleType.setter
    def RuleType(self, RuleType):
        self._RuleType = RuleType

    @property
    def RuleLevel(self):
        return self._RuleLevel

    @RuleLevel.setter
    def RuleLevel(self, RuleLevel):
        self._RuleLevel = RuleLevel


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._IsEnable = params.get("IsEnable")
        self._RuleMode = params.get("RuleMode")
        self._RuleType = params.get("RuleType")
        self._RuleLevel = params.get("RuleLevel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccessControlChildRuleInfo(AbstractModel):
    """容器运行时安全，访问控制子策略信息

    """

    def __init__(self):
        r"""
        :param _RuleMode: 策略模式,  RULE_MODE_RELEASE: 放行
   RULE_MODE_ALERT: 告警
   RULE_MODE_HOLDUP:拦截
        :type RuleMode: str
        :param _ProcessPath: 进程路径
        :type ProcessPath: str
        :param _TargetFilePath: 被访问文件路径，仅仅在访问控制生效
        :type TargetFilePath: str
        :param _RuleId: 子策略id
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleId: str
        """
        self._RuleMode = None
        self._ProcessPath = None
        self._TargetFilePath = None
        self._RuleId = None

    @property
    def RuleMode(self):
        return self._RuleMode

    @RuleMode.setter
    def RuleMode(self, RuleMode):
        self._RuleMode = RuleMode

    @property
    def ProcessPath(self):
        return self._ProcessPath

    @ProcessPath.setter
    def ProcessPath(self, ProcessPath):
        self._ProcessPath = ProcessPath

    @property
    def TargetFilePath(self):
        return self._TargetFilePath

    @TargetFilePath.setter
    def TargetFilePath(self, TargetFilePath):
        self._TargetFilePath = TargetFilePath

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId


    def _deserialize(self, params):
        self._RuleMode = params.get("RuleMode")
        self._ProcessPath = params.get("ProcessPath")
        self._TargetFilePath = params.get("TargetFilePath")
        self._RuleId = params.get("RuleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccessControlEventDescription(AbstractModel):
    """运行时容器访问控制事件描述信息

    """

    def __init__(self):
        r"""
        :param _Description: 事件规则
        :type Description: str
        :param _Solution: 解决方案
        :type Solution: str
        :param _Remark: 事件备注信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Remark: str
        :param _MatchRule: 命中规则详细信息
        :type MatchRule: :class:`tencentcloud.tcss.v20201101.models.AccessControlChildRuleInfo`
        :param _RuleName: 命中规则名字
        :type RuleName: str
        :param _RuleId: 命中规则id
        :type RuleId: str
        :param _OperationTime: 事件最后一次处理的时间
注意：此字段可能返回 null，表示取不到有效值。
        :type OperationTime: str
        """
        self._Description = None
        self._Solution = None
        self._Remark = None
        self._MatchRule = None
        self._RuleName = None
        self._RuleId = None
        self._OperationTime = None

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Solution(self):
        return self._Solution

    @Solution.setter
    def Solution(self, Solution):
        self._Solution = Solution

    @property
    def Remark(self):
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def MatchRule(self):
        return self._MatchRule

    @MatchRule.setter
    def MatchRule(self, MatchRule):
        self._MatchRule = MatchRule

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def OperationTime(self):
        return self._OperationTime

    @OperationTime.setter
    def OperationTime(self, OperationTime):
        self._OperationTime = OperationTime


    def _deserialize(self, params):
        self._Description = params.get("Description")
        self._Solution = params.get("Solution")
        self._Remark = params.get("Remark")
        if params.get("MatchRule") is not None:
            self._MatchRule = AccessControlChildRuleInfo()
            self._MatchRule._deserialize(params.get("MatchRule"))
        self._RuleName = params.get("RuleName")
        self._RuleId = params.get("RuleId")
        self._OperationTime = params.get("OperationTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccessControlEventInfo(AbstractModel):
    """容器运行时安全访问控制事件信息

    """

    def __init__(self):
        r"""
        :param _ProcessName: 进程名称
        :type ProcessName: str
        :param _MatchRuleName: 命中规则名称
        :type MatchRuleName: str
        :param _FoundTime: 生成时间
        :type FoundTime: str
        :param _ContainerName: 容器名
        :type ContainerName: str
        :param _ImageName: 镜像名
        :type ImageName: str
        :param _Behavior: 动作执行结果，   BEHAVIOR_NONE: 无
    BEHAVIOR_ALERT: 告警
    BEHAVIOR_RELEASE：放行
    BEHAVIOR_HOLDUP_FAILED:拦截失败
    BEHAVIOR_HOLDUP_SUCCESSED：拦截失败
        :type Behavior: str
        :param _Status: 状态0:未处理  “EVENT_UNDEAL”:事件未处理
    "EVENT_DEALED":事件已经处理
    "EVENT_INGNORE"：事件已经忽略
        :type Status: str
        :param _Id: 事件记录的唯一id
        :type Id: str
        :param _FileName: 文件名称
        :type FileName: str
        :param _EventType: 事件类型， FILE_ABNORMAL_READ:文件异常读取
        :type EventType: str
        :param _ImageId: 镜像id, 用于跳转
        :type ImageId: str
        :param _ContainerId: 容器id, 用于跳转
        :type ContainerId: str
        :param _Solution: 事件解决方案
        :type Solution: str
        :param _Description: 事件详细描述
        :type Description: str
        :param _MatchRuleId: 命中策略id
        :type MatchRuleId: str
        :param _MatchAction: 命中规则行为：
RULE_MODE_RELEASE 放行
RULE_MODE_ALERT  告警
RULE_MODE_HOLDUP 拦截
        :type MatchAction: str
        :param _MatchProcessPath: 命中规则进程信息
        :type MatchProcessPath: str
        :param _MatchFilePath: 命中规则文件信息
        :type MatchFilePath: str
        :param _FilePath: 文件路径，包含名字
        :type FilePath: str
        :param _RuleExist: 规则是否存在
        :type RuleExist: bool
        :param _EventCount: 事件数量
        :type EventCount: int
        :param _LatestFoundTime: 最近生成时间
        :type LatestFoundTime: str
        :param _RuleId: 规则组id
        :type RuleId: str
        :param _ContainerNetStatus: 网络状态
未隔离  	NORMAL
已隔离		ISOLATED
隔离中		ISOLATING
隔离失败	ISOLATE_FAILED
解除隔离中  RESTORING
解除隔离失败 RESTORE_FAILED
        :type ContainerNetStatus: str
        :param _ContainerNetSubStatus: 容器子状态
"AGENT_OFFLINE"       //Agent离线
"NODE_DESTROYED"      //节点已销毁
"CONTAINER_EXITED"    //容器已退出
"CONTAINER_DESTROYED" //容器已销毁
"SHARED_HOST"         // 容器与主机共享网络
"RESOURCE_LIMIT"      //隔离操作资源超限
"UNKNOW"              // 原因未知
        :type ContainerNetSubStatus: str
        :param _ContainerIsolateOperationSrc: 容器隔离操作来源
        :type ContainerIsolateOperationSrc: str
        :param _ContainerStatus: 容器状态
正在运行: RUNNING
暂停: PAUSED
停止: STOPPED
已经创建: CREATED
已经销毁: DESTROYED
正在重启中: RESTARTING
迁移中: REMOVING
        :type ContainerStatus: str
        :param _NodeName: 节点名称：如果是超级节点，展示的实质上是它的node_id
        :type NodeName: str
        :param _PodName: pod名称
        :type PodName: str
        :param _PodIP: pod ip
        :type PodIP: str
        :param _NodeType: 节点类型：NORMAL普通节点、SUPER超级节点
        :type NodeType: str
        :param _ClusterID: 集群id
        :type ClusterID: str
        :param _NodeUniqueID: 节点的唯一id，主要是超级节点使用
        :type NodeUniqueID: str
        :param _PublicIP: 节点公网IP
        :type PublicIP: str
        :param _NodeID: 节点id
        :type NodeID: str
        :param _HostID: uuid
        :type HostID: str
        :param _HostIP: 节点内网ip
        :type HostIP: str
        :param _ClusterName: 集群名称
        :type ClusterName: str
        """
        self._ProcessName = None
        self._MatchRuleName = None
        self._FoundTime = None
        self._ContainerName = None
        self._ImageName = None
        self._Behavior = None
        self._Status = None
        self._Id = None
        self._FileName = None
        self._EventType = None
        self._ImageId = None
        self._ContainerId = None
        self._Solution = None
        self._Description = None
        self._MatchRuleId = None
        self._MatchAction = None
        self._MatchProcessPath = None
        self._MatchFilePath = None
        self._FilePath = None
        self._RuleExist = None
        self._EventCount = None
        self._LatestFoundTime = None
        self._RuleId = None
        self._ContainerNetStatus = None
        self._ContainerNetSubStatus = None
        self._ContainerIsolateOperationSrc = None
        self._ContainerStatus = None
        self._NodeName = None
        self._PodName = None
        self._PodIP = None
        self._NodeType = None
        self._ClusterID = None
        self._NodeUniqueID = None
        self._PublicIP = None
        self._NodeID = None
        self._HostID = None
        self._HostIP = None
        self._ClusterName = None

    @property
    def ProcessName(self):
        return self._ProcessName

    @ProcessName.setter
    def ProcessName(self, ProcessName):
        self._ProcessName = ProcessName

    @property
    def MatchRuleName(self):
        return self._MatchRuleName

    @MatchRuleName.setter
    def MatchRuleName(self, MatchRuleName):
        self._MatchRuleName = MatchRuleName

    @property
    def FoundTime(self):
        return self._FoundTime

    @FoundTime.setter
    def FoundTime(self, FoundTime):
        self._FoundTime = FoundTime

    @property
    def ContainerName(self):
        return self._ContainerName

    @ContainerName.setter
    def ContainerName(self, ContainerName):
        self._ContainerName = ContainerName

    @property
    def ImageName(self):
        return self._ImageName

    @ImageName.setter
    def ImageName(self, ImageName):
        self._ImageName = ImageName

    @property
    def Behavior(self):
        return self._Behavior

    @Behavior.setter
    def Behavior(self, Behavior):
        self._Behavior = Behavior

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def FileName(self):
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName

    @property
    def EventType(self):
        return self._EventType

    @EventType.setter
    def EventType(self, EventType):
        self._EventType = EventType

    @property
    def ImageId(self):
        return self._ImageId

    @ImageId.setter
    def ImageId(self, ImageId):
        self._ImageId = ImageId

    @property
    def ContainerId(self):
        return self._ContainerId

    @ContainerId.setter
    def ContainerId(self, ContainerId):
        self._ContainerId = ContainerId

    @property
    def Solution(self):
        return self._Solution

    @Solution.setter
    def Solution(self, Solution):
        self._Solution = Solution

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def MatchRuleId(self):
        return self._MatchRuleId

    @MatchRuleId.setter
    def MatchRuleId(self, MatchRuleId):
        self._MatchRuleId = MatchRuleId

    @property
    def MatchAction(self):
        return self._MatchAction

    @MatchAction.setter
    def MatchAction(self, MatchAction):
        self._MatchAction = MatchAction

    @property
    def MatchProcessPath(self):
        return self._MatchProcessPath

    @MatchProcessPath.setter
    def MatchProcessPath(self, MatchProcessPath):
        self._MatchProcessPath = MatchProcessPath

    @property
    def MatchFilePath(self):
        return self._MatchFilePath

    @MatchFilePath.setter
    def MatchFilePath(self, MatchFilePath):
        self._MatchFilePath = MatchFilePath

    @property
    def FilePath(self):
        return self._FilePath

    @FilePath.setter
    def FilePath(self, FilePath):
        self._FilePath = FilePath

    @property
    def RuleExist(self):
        return self._RuleExist

    @RuleExist.setter
    def RuleExist(self, RuleExist):
        self._RuleExist = RuleExist

    @property
    def EventCount(self):
        return self._EventCount

    @EventCount.setter
    def EventCount(self, EventCount):
        self._EventCount = EventCount

    @property
    def LatestFoundTime(self):
        return self._LatestFoundTime

    @LatestFoundTime.setter
    def LatestFoundTime(self, LatestFoundTime):
        self._LatestFoundTime = LatestFoundTime

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def ContainerNetStatus(self):
        return self._ContainerNetStatus

    @ContainerNetStatus.setter
    def ContainerNetStatus(self, ContainerNetStatus):
        self._ContainerNetStatus = ContainerNetStatus

    @property
    def ContainerNetSubStatus(self):
        return self._ContainerNetSubStatus

    @ContainerNetSubStatus.setter
    def ContainerNetSubStatus(self, ContainerNetSubStatus):
        self._ContainerNetSubStatus = ContainerNetSubStatus

    @property
    def ContainerIsolateOperationSrc(self):
        return self._ContainerIsolateOperationSrc

    @ContainerIsolateOperationSrc.setter
    def ContainerIsolateOperationSrc(self, ContainerIsolateOperationSrc):
        self._ContainerIsolateOperationSrc = ContainerIsolateOperationSrc

    @property
    def ContainerStatus(self):
        return self._ContainerStatus

    @ContainerStatus.setter
    def ContainerStatus(self, ContainerStatus):
        self._ContainerStatus = ContainerStatus

    @property
    def NodeName(self):
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def PodName(self):
        return self._PodName

    @PodName.setter
    def PodName(self, PodName):
        self._PodName = PodName

    @property
    def PodIP(self):
        return self._PodIP

    @PodIP.setter
    def PodIP(self, PodIP):
        self._PodIP = PodIP

    @property
    def NodeType(self):
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def ClusterID(self):
        return self._ClusterID

    @ClusterID.setter
    def ClusterID(self, ClusterID):
        self._ClusterID = ClusterID

    @property
    def NodeUniqueID(self):
        return self._NodeUniqueID

    @NodeUniqueID.setter
    def NodeUniqueID(self, NodeUniqueID):
        self._NodeUniqueID = NodeUniqueID

    @property
    def PublicIP(self):
        return self._PublicIP

    @PublicIP.setter
    def PublicIP(self, PublicIP):
        self._PublicIP = PublicIP

    @property
    def NodeID(self):
        return self._NodeID

    @NodeID.setter
    def NodeID(self, NodeID):
        self._NodeID = NodeID

    @property
    def HostID(self):
        return self._HostID

    @HostID.setter
    def HostID(self, HostID):
        self._HostID = HostID

    @property
    def HostIP(self):
        return self._HostIP

    @HostIP.setter
    def HostIP(self, HostIP):
        self._HostIP = HostIP

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName


    def _deserialize(self, params):
        self._ProcessName = params.get("ProcessName")
        self._MatchRuleName = params.get("MatchRuleName")
        self._FoundTime = params.get("FoundTime")
        self._ContainerName = params.get("ContainerName")
        self._ImageName = params.get("ImageName")
        self._Behavior = params.get("Behavior")
        self._Status = params.get("Status")
        self._Id = params.get("Id")
        self._FileName = params.get("FileName")
        self._EventType = params.get("EventType")
        self._ImageId = params.get("ImageId")
        self._ContainerId = params.get("ContainerId")
        self._Solution = params.get("Solution")
        self._Description = params.get("Description")
        self._MatchRuleId = params.get("MatchRuleId")
        self._MatchAction = params.get("MatchAction")
        self._MatchProcessPath = params.get("MatchProcessPath")
        self._MatchFilePath = params.get("MatchFilePath")
        self._FilePath = params.get("FilePath")
        self._RuleExist = params.get("RuleExist")
        self._EventCount = params.get("EventCount")
        self._LatestFoundTime = params.get("LatestFoundTime")
        self._RuleId = params.get("RuleId")
        self._ContainerNetStatus = params.get("ContainerNetStatus")
        self._ContainerNetSubStatus = params.get("ContainerNetSubStatus")
        self._ContainerIsolateOperationSrc = params.get("ContainerIsolateOperationSrc")
        self._ContainerStatus = params.get("ContainerStatus")
        self._NodeName = params.get("NodeName")
        self._PodName = params.get("PodName")
        self._PodIP = params.get("PodIP")
        self._NodeType = params.get("NodeType")
        self._ClusterID = params.get("ClusterID")
        self._NodeUniqueID = params.get("NodeUniqueID")
        self._PublicIP = params.get("PublicIP")
        self._NodeID = params.get("NodeID")
        self._HostID = params.get("HostID")
        self._HostIP = params.get("HostIP")
        self._ClusterName = params.get("ClusterName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccessControlRuleInfo(AbstractModel):
    """容器运行时，访问控制策略信息

    """

    def __init__(self):
        r"""
        :param _IsEnable: 开关,true:开启，false:禁用
        :type IsEnable: bool
        :param _ImageIds: 生效镜像id，空数组代表全部镜像
        :type ImageIds: list of str
        :param _ChildRules: 用户策略的子策略数组
        :type ChildRules: list of AccessControlChildRuleInfo
        :param _RuleName: 策略名字
        :type RuleName: str
        :param _RuleId: 策略id
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleId: str
        :param _SystemChildRules: 系统策略的子策略数组
        :type SystemChildRules: list of AccessControlSystemChildRuleInfo
        :param _IsDefault: 是否是系统默认策略
        :type IsDefault: bool
        """
        self._IsEnable = None
        self._ImageIds = None
        self._ChildRules = None
        self._RuleName = None
        self._RuleId = None
        self._SystemChildRules = None
        self._IsDefault = None

    @property
    def IsEnable(self):
        return self._IsEnable

    @IsEnable.setter
    def IsEnable(self, IsEnable):
        self._IsEnable = IsEnable

    @property
    def ImageIds(self):
        return self._ImageIds

    @ImageIds.setter
    def ImageIds(self, ImageIds):
        self._ImageIds = ImageIds

    @property
    def ChildRules(self):
        return self._ChildRules

    @ChildRules.setter
    def ChildRules(self, ChildRules):
        self._ChildRules = ChildRules

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def SystemChildRules(self):
        return self._SystemChildRules

    @SystemChildRules.setter
    def SystemChildRules(self, SystemChildRules):
        self._SystemChildRules = SystemChildRules

    @property
    def IsDefault(self):
        return self._IsDefault

    @IsDefault.setter
    def IsDefault(self, IsDefault):
        self._IsDefault = IsDefault


    def _deserialize(self, params):
        self._IsEnable = params.get("IsEnable")
        self._ImageIds = params.get("ImageIds")
        if params.get("ChildRules") is not None:
            self._ChildRules = []
            for item in params.get("ChildRules"):
                obj = AccessControlChildRuleInfo()
                obj._deserialize(item)
                self._ChildRules.append(obj)
        self._RuleName = params.get("RuleName")
        self._RuleId = params.get("RuleId")
        if params.get("SystemChildRules") is not None:
            self._SystemChildRules = []
            for item in params.get("SystemChildRules"):
                obj = AccessControlSystemChildRuleInfo()
                obj._deserialize(item)
                self._SystemChildRules.append(obj)
        self._IsDefault = params.get("IsDefault")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccessControlSystemChildRuleInfo(AbstractModel):
    """容器运行时安全，访问控制系统策略的子策略信息

    """

    def __init__(self):
        r"""
        :param _RuleId: 子策略Id
        :type RuleId: str
        :param _RuleMode: 策略模式,  RULE_MODE_RELEASE: 放行
   RULE_MODE_ALERT: 告警
   RULE_MODE_HOLDUP:拦截
        :type RuleMode: str
        :param _IsEnable: 子策略状态，true为开启，false为关闭
        :type IsEnable: bool
        :param _RuleType: 子策略检测的入侵行为类型
CHANGE_CRONTAB：篡改计划任务
CHANGE_SYS_BIN：篡改系统程序
CHANGE_USRCFG：篡改用户配置
        :type RuleType: str
        """
        self._RuleId = None
        self._RuleMode = None
        self._IsEnable = None
        self._RuleType = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RuleMode(self):
        return self._RuleMode

    @RuleMode.setter
    def RuleMode(self, RuleMode):
        self._RuleMode = RuleMode

    @property
    def IsEnable(self):
        return self._IsEnable

    @IsEnable.setter
    def IsEnable(self, IsEnable):
        self._IsEnable = IsEnable

    @property
    def RuleType(self):
        return self._RuleType

    @RuleType.setter
    def RuleType(self, RuleType):
        self._RuleType = RuleType


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._RuleMode = params.get("RuleMode")
        self._IsEnable = params.get("IsEnable")
        self._RuleType = params.get("RuleType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddAndPublishNetworkFirewallPolicyDetailRequest(AbstractModel):
    """AddAndPublishNetworkFirewallPolicyDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群Id
        :type ClusterId: str
        :param _PolicyName: 策略名
        :type PolicyName: str
        :param _FromPolicyRule: 入站规则

全部允许：1

全部拒绝 ：2

自定义：3
        :type FromPolicyRule: int
        :param _ToPolicyRule: 出站规则

全部允许：1

全部拒绝 ：2

自定义：3
        :type ToPolicyRule: int
        :param _PodSelector: pod选择器
        :type PodSelector: str
        :param _Namespace: 命名空间
        :type Namespace: str
        :param _Description: 策略描述
        :type Description: str
        :param _CustomPolicy: 自定义规则
        :type CustomPolicy: list of NetworkCustomPolicy
        """
        self._ClusterId = None
        self._PolicyName = None
        self._FromPolicyRule = None
        self._ToPolicyRule = None
        self._PodSelector = None
        self._Namespace = None
        self._Description = None
        self._CustomPolicy = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def PolicyName(self):
        return self._PolicyName

    @PolicyName.setter
    def PolicyName(self, PolicyName):
        self._PolicyName = PolicyName

    @property
    def FromPolicyRule(self):
        return self._FromPolicyRule

    @FromPolicyRule.setter
    def FromPolicyRule(self, FromPolicyRule):
        self._FromPolicyRule = FromPolicyRule

    @property
    def ToPolicyRule(self):
        return self._ToPolicyRule

    @ToPolicyRule.setter
    def ToPolicyRule(self, ToPolicyRule):
        self._ToPolicyRule = ToPolicyRule

    @property
    def PodSelector(self):
        return self._PodSelector

    @PodSelector.setter
    def PodSelector(self, PodSelector):
        self._PodSelector = PodSelector

    @property
    def Namespace(self):
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CustomPolicy(self):
        return self._CustomPolicy

    @CustomPolicy.setter
    def CustomPolicy(self, CustomPolicy):
        self._CustomPolicy = CustomPolicy


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._PolicyName = params.get("PolicyName")
        self._FromPolicyRule = params.get("FromPolicyRule")
        self._ToPolicyRule = params.get("ToPolicyRule")
        self._PodSelector = params.get("PodSelector")
        self._Namespace = params.get("Namespace")
        self._Description = params.get("Description")
        if params.get("CustomPolicy") is not None:
            self._CustomPolicy = []
            for item in params.get("CustomPolicy"):
                obj = NetworkCustomPolicy()
                obj._deserialize(item)
                self._CustomPolicy.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddAndPublishNetworkFirewallPolicyDetailResponse(AbstractModel):
    """AddAndPublishNetworkFirewallPolicyDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 返回创建的任务的ID，为0表示创建失败。
        :type TaskId: int
        :param _Result: 创建任务的结果，"Succ"为成功，"Failed"为失败
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._Result = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class AddAndPublishNetworkFirewallPolicyYamlDetailRequest(AbstractModel):
    """AddAndPublishNetworkFirewallPolicyYamlDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群Id
        :type ClusterId: str
        :param _PolicyName: 策略名
        :type PolicyName: str
        :param _Yaml: base64编码的networkpolicy yaml字符串
        :type Yaml: str
        :param _Description: 策略描述
        :type Description: str
        """
        self._ClusterId = None
        self._PolicyName = None
        self._Yaml = None
        self._Description = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def PolicyName(self):
        return self._PolicyName

    @PolicyName.setter
    def PolicyName(self, PolicyName):
        self._PolicyName = PolicyName

    @property
    def Yaml(self):
        return self._Yaml

    @Yaml.setter
    def Yaml(self, Yaml):
        self._Yaml = Yaml

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._PolicyName = params.get("PolicyName")
        self._Yaml = params.get("Yaml")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddAndPublishNetworkFirewallPolicyYamlDetailResponse(AbstractModel):
    """AddAndPublishNetworkFirewallPolicyYamlDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 返回创建的任务的ID，为0表示创建失败。
        :type TaskId: int
        :param _Result: 创建任务的结果，"Succ"为成功，"Failed"为失败
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._Result = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class AddAssetImageRegistryRegistryDetailRequest(AbstractModel):
    """AddAssetImageRegistryRegistryDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 仓库名
        :type Name: str
        :param _Username: 用户名
        :type Username: str
        :param _Password: 密码
        :type Password: str
        :param _Url: 仓库url
        :type Url: str
        :param _RegistryType: 仓库类型，列表：harbor
        :type RegistryType: str
        :param _NetType: 网络类型，列表：public（公网）
        :type NetType: str
        :param _RegistryVersion: 仓库版本
        :type RegistryVersion: str
        :param _RegistryRegion: 区域，列表：default（默认）
        :type RegistryRegion: str
        :param _SpeedLimit: 限速
        :type SpeedLimit: int
        :param _Insecure: 安全模式（证书校验）：0（默认） 非安全模式（跳过证书校验）：1
        :type Insecure: int
        :param _ConnDetectConfig: 联通性检测的记录ID
        :type ConnDetectConfig: list of ConnDetectConfig
        :param _NeedScan: ”授权&扫描"开关
        :type NeedScan: bool
        """
        self._Name = None
        self._Username = None
        self._Password = None
        self._Url = None
        self._RegistryType = None
        self._NetType = None
        self._RegistryVersion = None
        self._RegistryRegion = None
        self._SpeedLimit = None
        self._Insecure = None
        self._ConnDetectConfig = None
        self._NeedScan = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Username(self):
        return self._Username

    @Username.setter
    def Username(self, Username):
        self._Username = Username

    @property
    def Password(self):
        return self._Password

    @Password.setter
    def Password(self, Password):
        self._Password = Password

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def RegistryType(self):
        return self._RegistryType

    @RegistryType.setter
    def RegistryType(self, RegistryType):
        self._RegistryType = RegistryType

    @property
    def NetType(self):
        return self._NetType

    @NetType.setter
    def NetType(self, NetType):
        self._NetType = NetType

    @property
    def RegistryVersion(self):
        return self._RegistryVersion

    @RegistryVersion.setter
    def RegistryVersion(self, RegistryVersion):
        self._RegistryVersion = RegistryVersion

    @property
    def RegistryRegion(self):
        return self._RegistryRegion

    @RegistryRegion.setter
    def RegistryRegion(self, RegistryRegion):
        self._RegistryRegion = RegistryRegion

    @property
    def SpeedLimit(self):
        return self._SpeedLimit

    @SpeedLimit.setter
    def SpeedLimit(self, SpeedLimit):
        self._SpeedLimit = SpeedLimit

    @property
    def Insecure(self):
        return self._Insecure

    @Insecure.setter
    def Insecure(self, Insecure):
        self._Insecure = Insecure

    @property
    def ConnDetectConfig(self):
        return self._ConnDetectConfig

    @ConnDetectConfig.setter
    def ConnDetectConfig(self, ConnDetectConfig):
        self._ConnDetectConfig = ConnDetectConfig

    @property
    def NeedScan(self):
        return self._NeedScan

    @NeedScan.setter
    def NeedScan(self, NeedScan):
        self._NeedScan = NeedScan


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Username = params.get("Username")
        self._Password = params.get("Password")
        self._Url = params.get("Url")
        self._RegistryType = params.get("RegistryType")
        self._NetType = params.get("NetType")
        self._RegistryVersion = params.get("RegistryVersion")
        self._RegistryRegion = params.get("RegistryRegion")
        self._SpeedLimit = params.get("SpeedLimit")
        self._Insecure = params.get("Insecure")
        if params.get("ConnDetectConfig") is not None:
            self._ConnDetectConfig = []
            for item in params.get("ConnDetectConfig"):
                obj = ConnDetectConfig()
                obj._deserialize(item)
                self._ConnDetectConfig.append(obj)
        self._NeedScan = params.get("NeedScan")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddAssetImageRegistryRegistryDetailResponse(AbstractModel):
    """AddAssetImageRegistryRegistryDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _HealthCheckErr: 连接错误信息
注意：此字段可能返回 null，表示取不到有效值。
        :type HealthCheckErr: str
        :param _NameRepeatErr: 名称错误信息
注意：此字段可能返回 null，表示取不到有效值。
        :type NameRepeatErr: str
        :param _RegistryId: 仓库唯一id
注意：此字段可能返回 null，表示取不到有效值。
        :type RegistryId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._HealthCheckErr = None
        self._NameRepeatErr = None
        self._RegistryId = None
        self._RequestId = None

    @property
    def HealthCheckErr(self):
        return self._HealthCheckErr

    @HealthCheckErr.setter
    def HealthCheckErr(self, HealthCheckErr):
        self._HealthCheckErr = HealthCheckErr

    @property
    def NameRepeatErr(self):
        return self._NameRepeatErr

    @NameRepeatErr.setter
    def NameRepeatErr(self, NameRepeatErr):
        self._NameRepeatErr = NameRepeatErr

    @property
    def RegistryId(self):
        return self._RegistryId

    @RegistryId.setter
    def RegistryId(self, RegistryId):
        self._RegistryId = RegistryId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._HealthCheckErr = params.get("HealthCheckErr")
        self._NameRepeatErr = params.get("NameRepeatErr")
        self._RegistryId = params.get("RegistryId")
        self._RequestId = params.get("RequestId")


class AddComplianceAssetPolicySetToWhitelistRequest(AbstractModel):
    """AddComplianceAssetPolicySetToWhitelist请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AssetPolicySetList: 资产ID+检查项IDs. 列表
        :type AssetPolicySetList: list of ComplianceAssetPolicySetItem
        """
        self._AssetPolicySetList = None

    @property
    def AssetPolicySetList(self):
        return self._AssetPolicySetList

    @AssetPolicySetList.setter
    def AssetPolicySetList(self, AssetPolicySetList):
        self._AssetPolicySetList = AssetPolicySetList


    def _deserialize(self, params):
        if params.get("AssetPolicySetList") is not None:
            self._AssetPolicySetList = []
            for item in params.get("AssetPolicySetList"):
                obj = ComplianceAssetPolicySetItem()
                obj._deserialize(item)
                self._AssetPolicySetList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddComplianceAssetPolicySetToWhitelistResponse(AbstractModel):
    """AddComplianceAssetPolicySetToWhitelist返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddCompliancePolicyAssetSetToWhitelistRequest(AbstractModel):
    """AddCompliancePolicyAssetSetToWhitelist请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CustomerPolicyItemId: 检查项ID
        :type CustomerPolicyItemId: int
        :param _CustomerAssetItemIdSet: 需要忽略指定检查项内的资产ID列表
        :type CustomerAssetItemIdSet: list of int non-negative
        """
        self._CustomerPolicyItemId = None
        self._CustomerAssetItemIdSet = None

    @property
    def CustomerPolicyItemId(self):
        return self._CustomerPolicyItemId

    @CustomerPolicyItemId.setter
    def CustomerPolicyItemId(self, CustomerPolicyItemId):
        self._CustomerPolicyItemId = CustomerPolicyItemId

    @property
    def CustomerAssetItemIdSet(self):
        return self._CustomerAssetItemIdSet

    @CustomerAssetItemIdSet.setter
    def CustomerAssetItemIdSet(self, CustomerAssetItemIdSet):
        self._CustomerAssetItemIdSet = CustomerAssetItemIdSet


    def _deserialize(self, params):
        self._CustomerPolicyItemId = params.get("CustomerPolicyItemId")
        self._CustomerAssetItemIdSet = params.get("CustomerAssetItemIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddCompliancePolicyAssetSetToWhitelistResponse(AbstractModel):
    """AddCompliancePolicyAssetSetToWhitelist返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddCompliancePolicyItemToWhitelistRequest(AbstractModel):
    """AddCompliancePolicyItemToWhitelist请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CustomerPolicyItemIdSet: 要忽略的检测项的ID的列表
        :type CustomerPolicyItemIdSet: list of int non-negative
        """
        self._CustomerPolicyItemIdSet = None

    @property
    def CustomerPolicyItemIdSet(self):
        return self._CustomerPolicyItemIdSet

    @CustomerPolicyItemIdSet.setter
    def CustomerPolicyItemIdSet(self, CustomerPolicyItemIdSet):
        self._CustomerPolicyItemIdSet = CustomerPolicyItemIdSet


    def _deserialize(self, params):
        self._CustomerPolicyItemIdSet = params.get("CustomerPolicyItemIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddCompliancePolicyItemToWhitelistResponse(AbstractModel):
    """AddCompliancePolicyItemToWhitelist返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddEditAbnormalProcessRuleRequest(AbstractModel):
    """AddEditAbnormalProcessRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleInfo: 增加策略信息，策略id为空，编辑策略是id不能为空
        :type RuleInfo: :class:`tencentcloud.tcss.v20201101.models.AbnormalProcessRuleInfo`
        :param _EventId: 仅在加白的时候带上
        :type EventId: str
        """
        self._RuleInfo = None
        self._EventId = None

    @property
    def RuleInfo(self):
        return self._RuleInfo

    @RuleInfo.setter
    def RuleInfo(self, RuleInfo):
        self._RuleInfo = RuleInfo

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId


    def _deserialize(self, params):
        if params.get("RuleInfo") is not None:
            self._RuleInfo = AbnormalProcessRuleInfo()
            self._RuleInfo._deserialize(params.get("RuleInfo"))
        self._EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddEditAbnormalProcessRuleResponse(AbstractModel):
    """AddEditAbnormalProcessRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddEditAccessControlRuleRequest(AbstractModel):
    """AddEditAccessControlRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleInfo: 增加策略信息，策略id为空，编辑策略是id不能为空
        :type RuleInfo: :class:`tencentcloud.tcss.v20201101.models.AccessControlRuleInfo`
        :param _EventId: 仅在白名单时候使用
        :type EventId: str
        """
        self._RuleInfo = None
        self._EventId = None

    @property
    def RuleInfo(self):
        return self._RuleInfo

    @RuleInfo.setter
    def RuleInfo(self, RuleInfo):
        self._RuleInfo = RuleInfo

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId


    def _deserialize(self, params):
        if params.get("RuleInfo") is not None:
            self._RuleInfo = AccessControlRuleInfo()
            self._RuleInfo._deserialize(params.get("RuleInfo"))
        self._EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddEditAccessControlRuleResponse(AbstractModel):
    """AddEditAccessControlRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddEditImageAutoAuthorizedRuleRequest(AbstractModel):
    """AddEditImageAutoAuthorizedRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RangeType: 授权范围类别，MANUAL:自选主机节点，ALL:全部镜像
        :type RangeType: str
        :param _MaxDailyCount: 每天最大的镜像授权数限制, 0表示无限制
        :type MaxDailyCount: int
        :param _IsEnabled: 规则是否生效，0:不生效，1:已生效
        :type IsEnabled: int
        :param _HostIdSet: 自选主机id，当授权范围为MANUAL:自选主机时且HostIdFilters为空时，必填
        :type HostIdSet: list of str
        :param _RuleId: 规则id，在编辑时，必填
        :type RuleId: int
        :param _HostIdFilters: 根据条件过滤，当授权范围为MANUAL:自选主机时且HostIdSet为空时，必填
        :type HostIdFilters: list of AssetFilters
        :param _ExcludeHostIdSet: 根据条件过滤而且排除指定主机id
        :type ExcludeHostIdSet: list of str
        :param _AutoScanEnabled: 自动扫描开关
        :type AutoScanEnabled: int
        :param _ScanType: 自动扫描范围
        :type ScanType: list of str
        """
        self._RangeType = None
        self._MaxDailyCount = None
        self._IsEnabled = None
        self._HostIdSet = None
        self._RuleId = None
        self._HostIdFilters = None
        self._ExcludeHostIdSet = None
        self._AutoScanEnabled = None
        self._ScanType = None

    @property
    def RangeType(self):
        return self._RangeType

    @RangeType.setter
    def RangeType(self, RangeType):
        self._RangeType = RangeType

    @property
    def MaxDailyCount(self):
        return self._MaxDailyCount

    @MaxDailyCount.setter
    def MaxDailyCount(self, MaxDailyCount):
        self._MaxDailyCount = MaxDailyCount

    @property
    def IsEnabled(self):
        return self._IsEnabled

    @IsEnabled.setter
    def IsEnabled(self, IsEnabled):
        self._IsEnabled = IsEnabled

    @property
    def HostIdSet(self):
        return self._HostIdSet

    @HostIdSet.setter
    def HostIdSet(self, HostIdSet):
        self._HostIdSet = HostIdSet

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def HostIdFilters(self):
        return self._HostIdFilters

    @HostIdFilters.setter
    def HostIdFilters(self, HostIdFilters):
        self._HostIdFilters = HostIdFilters

    @property
    def ExcludeHostIdSet(self):
        return self._ExcludeHostIdSet

    @ExcludeHostIdSet.setter
    def ExcludeHostIdSet(self, ExcludeHostIdSet):
        self._ExcludeHostIdSet = ExcludeHostIdSet

    @property
    def AutoScanEnabled(self):
        return self._AutoScanEnabled

    @AutoScanEnabled.setter
    def AutoScanEnabled(self, AutoScanEnabled):
        self._AutoScanEnabled = AutoScanEnabled

    @property
    def ScanType(self):
        return self._ScanType

    @ScanType.setter
    def ScanType(self, ScanType):
        self._ScanType = ScanType


    def _deserialize(self, params):
        self._RangeType = params.get("RangeType")
        self._MaxDailyCount = params.get("MaxDailyCount")
        self._IsEnabled = params.get("IsEnabled")
        self._HostIdSet = params.get("HostIdSet")
        self._RuleId = params.get("RuleId")
        if params.get("HostIdFilters") is not None:
            self._HostIdFilters = []
            for item in params.get("HostIdFilters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._HostIdFilters.append(obj)
        self._ExcludeHostIdSet = params.get("ExcludeHostIdSet")
        self._AutoScanEnabled = params.get("AutoScanEnabled")
        self._ScanType = params.get("ScanType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddEditImageAutoAuthorizedRuleResponse(AbstractModel):
    """AddEditImageAutoAuthorizedRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddEditReverseShellWhiteListRequest(AbstractModel):
    """AddEditReverseShellWhiteList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WhiteListInfo: 增加或编辑白名单信息。新增白名单时WhiteListInfo.id为空，编辑白名单WhiteListInfo.id不能为空。
        :type WhiteListInfo: :class:`tencentcloud.tcss.v20201101.models.ReverseShellWhiteListInfo`
        :param _EventId: 仅在添加事件白名单时候使用
        :type EventId: str
        """
        self._WhiteListInfo = None
        self._EventId = None

    @property
    def WhiteListInfo(self):
        return self._WhiteListInfo

    @WhiteListInfo.setter
    def WhiteListInfo(self, WhiteListInfo):
        self._WhiteListInfo = WhiteListInfo

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId


    def _deserialize(self, params):
        if params.get("WhiteListInfo") is not None:
            self._WhiteListInfo = ReverseShellWhiteListInfo()
            self._WhiteListInfo._deserialize(params.get("WhiteListInfo"))
        self._EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddEditReverseShellWhiteListResponse(AbstractModel):
    """AddEditReverseShellWhiteList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddEditRiskSyscallWhiteListRequest(AbstractModel):
    """AddEditRiskSyscallWhiteList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventId: 仅在添加事件白名单时候使用
        :type EventId: str
        :param _WhiteListInfo: 增加或编辑白名单信。新增白名单时WhiteListInfo.id为空，编辑白名单WhiteListInfo.id不能为空.
        :type WhiteListInfo: :class:`tencentcloud.tcss.v20201101.models.RiskSyscallWhiteListInfo`
        """
        self._EventId = None
        self._WhiteListInfo = None

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def WhiteListInfo(self):
        return self._WhiteListInfo

    @WhiteListInfo.setter
    def WhiteListInfo(self, WhiteListInfo):
        self._WhiteListInfo = WhiteListInfo


    def _deserialize(self, params):
        self._EventId = params.get("EventId")
        if params.get("WhiteListInfo") is not None:
            self._WhiteListInfo = RiskSyscallWhiteListInfo()
            self._WhiteListInfo._deserialize(params.get("WhiteListInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddEditRiskSyscallWhiteListResponse(AbstractModel):
    """AddEditRiskSyscallWhiteList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddEditWarningRulesRequest(AbstractModel):
    """AddEditWarningRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WarningRules: 告警开关策略
        :type WarningRules: list of WarningRule
        """
        self._WarningRules = None

    @property
    def WarningRules(self):
        return self._WarningRules

    @WarningRules.setter
    def WarningRules(self, WarningRules):
        self._WarningRules = WarningRules


    def _deserialize(self, params):
        if params.get("WarningRules") is not None:
            self._WarningRules = []
            for item in params.get("WarningRules"):
                obj = WarningRule()
                obj._deserialize(item)
                self._WarningRules.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddEditWarningRulesResponse(AbstractModel):
    """AddEditWarningRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddEscapeWhiteListRequest(AbstractModel):
    """AddEscapeWhiteList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventType: 加白名单事件类型
   ESCAPE_CGROUPS：利用cgroup机制逃逸
   ESCAPE_TAMPER_SENSITIVE_FILE：篡改敏感文件逃逸
   ESCAPE_DOCKER_API：访问Docker API接口逃逸
   ESCAPE_VUL_OCCURRED：逃逸漏洞利用
   MOUNT_SENSITIVE_PTAH：敏感路径挂载
   PRIVILEGE_CONTAINER_START：特权容器
   PRIVILEGE：程序提权逃逸
        :type EventType: list of str
        :param _ImageIDs: 加白名单镜像ID数组
        :type ImageIDs: list of str
        """
        self._EventType = None
        self._ImageIDs = None

    @property
    def EventType(self):
        return self._EventType

    @EventType.setter
    def EventType(self, EventType):
        self._EventType = EventType

    @property
    def ImageIDs(self):
        return self._ImageIDs

    @ImageIDs.setter
    def ImageIDs(self, ImageIDs):
        self._ImageIDs = ImageIDs


    def _deserialize(self, params):
        self._EventType = params.get("EventType")
        self._ImageIDs = params.get("ImageIDs")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddEscapeWhiteListResponse(AbstractModel):
    """AddEscapeWhiteList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddIgnoreVulRequest(AbstractModel):
    """AddIgnoreVul请求参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 漏洞PocID信息列表
        :type List: list of ModifyIgnoreVul
        """
        self._List = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ModifyIgnoreVul()
                obj._deserialize(item)
                self._List.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddIgnoreVulResponse(AbstractModel):
    """AddIgnoreVul返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddNetworkFirewallPolicyDetailRequest(AbstractModel):
    """AddNetworkFirewallPolicyDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群Id
        :type ClusterId: str
        :param _PolicyName: 策略名
        :type PolicyName: str
        :param _FromPolicyRule: 入站规则

全部允许：1

全部拒绝 ：2

自定义：3
        :type FromPolicyRule: int
        :param _ToPolicyRule: 出站规则

全部允许：1

全部拒绝 ：2

自定义：3
        :type ToPolicyRule: int
        :param _PodSelector: pod选择器
        :type PodSelector: str
        :param _Namespace: 命名空间
        :type Namespace: str
        :param _Description: 策略描述
        :type Description: str
        :param _CustomPolicy: 自定义规则
        :type CustomPolicy: list of NetworkCustomPolicy
        """
        self._ClusterId = None
        self._PolicyName = None
        self._FromPolicyRule = None
        self._ToPolicyRule = None
        self._PodSelector = None
        self._Namespace = None
        self._Description = None
        self._CustomPolicy = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def PolicyName(self):
        return self._PolicyName

    @PolicyName.setter
    def PolicyName(self, PolicyName):
        self._PolicyName = PolicyName

    @property
    def FromPolicyRule(self):
        return self._FromPolicyRule

    @FromPolicyRule.setter
    def FromPolicyRule(self, FromPolicyRule):
        self._FromPolicyRule = FromPolicyRule

    @property
    def ToPolicyRule(self):
        return self._ToPolicyRule

    @ToPolicyRule.setter
    def ToPolicyRule(self, ToPolicyRule):
        self._ToPolicyRule = ToPolicyRule

    @property
    def PodSelector(self):
        return self._PodSelector

    @PodSelector.setter
    def PodSelector(self, PodSelector):
        self._PodSelector = PodSelector

    @property
    def Namespace(self):
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CustomPolicy(self):
        return self._CustomPolicy

    @CustomPolicy.setter
    def CustomPolicy(self, CustomPolicy):
        self._CustomPolicy = CustomPolicy


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._PolicyName = params.get("PolicyName")
        self._FromPolicyRule = params.get("FromPolicyRule")
        self._ToPolicyRule = params.get("ToPolicyRule")
        self._PodSelector = params.get("PodSelector")
        self._Namespace = params.get("Namespace")
        self._Description = params.get("Description")
        if params.get("CustomPolicy") is not None:
            self._CustomPolicy = []
            for item in params.get("CustomPolicy"):
                obj = NetworkCustomPolicy()
                obj._deserialize(item)
                self._CustomPolicy.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddNetworkFirewallPolicyDetailResponse(AbstractModel):
    """AddNetworkFirewallPolicyDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 返回创建的任务的ID，为0表示创建失败。
        :type TaskId: int
        :param _Result: 创建任务的结果，"Succ"为成功，"Failed"为失败
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._Result = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class AddNetworkFirewallPolicyYamlDetailRequest(AbstractModel):
    """AddNetworkFirewallPolicyYamlDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群Id
        :type ClusterId: str
        :param _PolicyName: 策略名
        :type PolicyName: str
        :param _Yaml: base64编码的networkpolicy yaml字符串
        :type Yaml: str
        :param _Description: 策略描述
        :type Description: str
        """
        self._ClusterId = None
        self._PolicyName = None
        self._Yaml = None
        self._Description = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def PolicyName(self):
        return self._PolicyName

    @PolicyName.setter
    def PolicyName(self, PolicyName):
        self._PolicyName = PolicyName

    @property
    def Yaml(self):
        return self._Yaml

    @Yaml.setter
    def Yaml(self, Yaml):
        self._Yaml = Yaml

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._PolicyName = params.get("PolicyName")
        self._Yaml = params.get("Yaml")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddNetworkFirewallPolicyYamlDetailResponse(AbstractModel):
    """AddNetworkFirewallPolicyYamlDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 返回创建的任务的ID，为0表示创建失败。
        :type TaskId: int
        :param _Result: 创建任务的结果，"Succ"为成功，"Failed"为失败
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._Result = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class AffectedNodeItem(AbstractModel):
    """受影响的节点类型结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _ClusterName: 集群名字
        :type ClusterName: str
        :param _InstanceId: 实例id
        :type InstanceId: str
        :param _PrivateIpAddresses: 内网ip地址
        :type PrivateIpAddresses: str
        :param _InstanceRole: 节点的角色，Master、Work等
        :type InstanceRole: str
        :param _ClusterVersion: k8s版本
        :type ClusterVersion: str
        :param _ContainerRuntime: 运行时组件,docker或者containerd
        :type ContainerRuntime: str
        :param _Region: 区域
        :type Region: str
        :param _VerifyInfo: 检查结果的验证信息
        :type VerifyInfo: str
        :param _NodeName: 节点名称
        :type NodeName: str
        """
        self._ClusterId = None
        self._ClusterName = None
        self._InstanceId = None
        self._PrivateIpAddresses = None
        self._InstanceRole = None
        self._ClusterVersion = None
        self._ContainerRuntime = None
        self._Region = None
        self._VerifyInfo = None
        self._NodeName = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def PrivateIpAddresses(self):
        return self._PrivateIpAddresses

    @PrivateIpAddresses.setter
    def PrivateIpAddresses(self, PrivateIpAddresses):
        self._PrivateIpAddresses = PrivateIpAddresses

    @property
    def InstanceRole(self):
        return self._InstanceRole

    @InstanceRole.setter
    def InstanceRole(self, InstanceRole):
        self._InstanceRole = InstanceRole

    @property
    def ClusterVersion(self):
        return self._ClusterVersion

    @ClusterVersion.setter
    def ClusterVersion(self, ClusterVersion):
        self._ClusterVersion = ClusterVersion

    @property
    def ContainerRuntime(self):
        return self._ContainerRuntime

    @ContainerRuntime.setter
    def ContainerRuntime(self, ContainerRuntime):
        self._ContainerRuntime = ContainerRuntime

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def VerifyInfo(self):
        return self._VerifyInfo

    @VerifyInfo.setter
    def VerifyInfo(self, VerifyInfo):
        self._VerifyInfo = VerifyInfo

    @property
    def NodeName(self):
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._InstanceId = params.get("InstanceId")
        self._PrivateIpAddresses = params.get("PrivateIpAddresses")
        self._InstanceRole = params.get("InstanceRole")
        self._ClusterVersion = params.get("ClusterVersion")
        self._ContainerRuntime = params.get("ContainerRuntime")
        self._Region = params.get("Region")
        self._VerifyInfo = params.get("VerifyInfo")
        self._NodeName = params.get("NodeName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AffectedWorkloadItem(AbstractModel):
    """集群安全检查受影响的工作负载Item

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群Id
        :type ClusterId: str
        :param _ClusterName: 集群名字
        :type ClusterName: str
        :param _WorkloadName: 工作负载名称
        :type WorkloadName: str
        :param _WorkloadType: 工作负载类型
        :type WorkloadType: str
        :param _Region: 区域
        :type Region: str
        :param _VerifyInfo: 检测结果的验证信息
        :type VerifyInfo: str
        """
        self._ClusterId = None
        self._ClusterName = None
        self._WorkloadName = None
        self._WorkloadType = None
        self._Region = None
        self._VerifyInfo = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def WorkloadName(self):
        return self._WorkloadName

    @WorkloadName.setter
    def WorkloadName(self, WorkloadName):
        self._WorkloadName = WorkloadName

    @property
    def WorkloadType(self):
        return self._WorkloadType

    @WorkloadType.setter
    def WorkloadType(self, WorkloadType):
        self._WorkloadType = WorkloadType

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def VerifyInfo(self):
        return self._VerifyInfo

    @VerifyInfo.setter
    def VerifyInfo(self, VerifyInfo):
        self._VerifyInfo = VerifyInfo


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._WorkloadName = params.get("WorkloadName")
        self._WorkloadType = params.get("WorkloadType")
        self._Region = params.get("Region")
        self._VerifyInfo = params.get("VerifyInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetClusterListItem(AbstractModel):
    """集群列表Item

    """

    def __init__(self):
        r"""
        :param _ClusterID: 集群ID
        :type ClusterID: str
        :param _ClusterName: 集群名称
        :type ClusterName: str
        :param _Status: 集群状态
CSR_RUNNING: 运行中
CSR_EXCEPTION:异常
CSR_DEL:已经删除
        :type Status: str
        :param _BindRuleName: 绑定规则名称
        :type BindRuleName: str
        :param _ClusterType: 集群类型:
CT_TKE:TKE集群;
CT_USER_CREATE:用户自建集群;
CT_TKE_SERVERLESS:TKE Serverless集群;
        :type ClusterType: str
        :param _ClusterVersion: 集群版本
        :type ClusterVersion: str
        :param _MemLimit: 内存量
        :type MemLimit: int
        :param _CpuLimit: cpu
        :type CpuLimit: int
        """
        self._ClusterID = None
        self._ClusterName = None
        self._Status = None
        self._BindRuleName = None
        self._ClusterType = None
        self._ClusterVersion = None
        self._MemLimit = None
        self._CpuLimit = None

    @property
    def ClusterID(self):
        return self._ClusterID

    @ClusterID.setter
    def ClusterID(self, ClusterID):
        self._ClusterID = ClusterID

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def BindRuleName(self):
        return self._BindRuleName

    @BindRuleName.setter
    def BindRuleName(self, BindRuleName):
        self._BindRuleName = BindRuleName

    @property
    def ClusterType(self):
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def ClusterVersion(self):
        return self._ClusterVersion

    @ClusterVersion.setter
    def ClusterVersion(self, ClusterVersion):
        self._ClusterVersion = ClusterVersion

    @property
    def MemLimit(self):
        return self._MemLimit

    @MemLimit.setter
    def MemLimit(self, MemLimit):
        self._MemLimit = MemLimit

    @property
    def CpuLimit(self):
        return self._CpuLimit

    @CpuLimit.setter
    def CpuLimit(self, CpuLimit):
        self._CpuLimit = CpuLimit


    def _deserialize(self, params):
        self._ClusterID = params.get("ClusterID")
        self._ClusterName = params.get("ClusterName")
        self._Status = params.get("Status")
        self._BindRuleName = params.get("BindRuleName")
        self._ClusterType = params.get("ClusterType")
        self._ClusterVersion = params.get("ClusterVersion")
        self._MemLimit = params.get("MemLimit")
        self._CpuLimit = params.get("CpuLimit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetFilters(AbstractModel):
    """容器安全
    描述键值对过滤器，用于条件过滤查询。例如过滤ID、名称、状态等
    若存在多个Filter时，Filter间的关系为逻辑与（AND）关系。
    若同一个Filter存在多个Values，同一Filter下Values间的关系为逻辑或（OR）关系。

    """

    def __init__(self):
        r"""
        :param _Name: 过滤键的名称
        :type Name: str
        :param _Values: 一个或者多个过滤值。
        :type Values: list of str
        :param _ExactMatch: 是否模糊查询
        :type ExactMatch: bool
        """
        self._Name = None
        self._Values = None
        self._ExactMatch = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values

    @property
    def ExactMatch(self):
        return self._ExactMatch

    @ExactMatch.setter
    def ExactMatch(self, ExactMatch):
        self._ExactMatch = ExactMatch


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        self._ExactMatch = params.get("ExactMatch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetSimpleImageInfo(AbstractModel):
    """容器安全资产镜像简略信息

    """

    def __init__(self):
        r"""
        :param _ImageID: 镜像ID
        :type ImageID: str
        :param _ImageName: 镜像名称
        :type ImageName: str
        :param _ContainerCnt: 关联容器个数
        :type ContainerCnt: int
        :param _ScanTime: 最后扫描时间
        :type ScanTime: str
        :param _Size: 镜像大小
        :type Size: int
        """
        self._ImageID = None
        self._ImageName = None
        self._ContainerCnt = None
        self._ScanTime = None
        self._Size = None

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def ImageName(self):
        return self._ImageName

    @ImageName.setter
    def ImageName(self, ImageName):
        self._ImageName = ImageName

    @property
    def ContainerCnt(self):
        return self._ContainerCnt

    @ContainerCnt.setter
    def ContainerCnt(self, ContainerCnt):
        self._ContainerCnt = ContainerCnt

    @property
    def ScanTime(self):
        return self._ScanTime

    @ScanTime.setter
    def ScanTime(self, ScanTime):
        self._ScanTime = ScanTime

    @property
    def Size(self):
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size


    def _deserialize(self, params):
        self._ImageID = params.get("ImageID")
        self._ImageName = params.get("ImageName")
        self._ContainerCnt = params.get("ContainerCnt")
        self._ScanTime = params.get("ScanTime")
        self._Size = params.get("Size")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AutoAuthorizedImageInfo(AbstractModel):
    """镜像自动授权结果信息

    """

    def __init__(self):
        r"""
        :param _ImageId: 镜像id
        :type ImageId: str
        :param _ImageName: 镜像名称
        :type ImageName: str
        :param _AuthorizedTime: 授权时间
        :type AuthorizedTime: str
        :param _Status: 授权结果，SUCCESS:成功，REACH_LIMIT:达到授权上限，LICENSE_INSUFFICIENT:授权数不足'
        :type Status: str
        :param _IsAuthorized: 是否授权，1：是，0：否
        :type IsAuthorized: int
        """
        self._ImageId = None
        self._ImageName = None
        self._AuthorizedTime = None
        self._Status = None
        self._IsAuthorized = None

    @property
    def ImageId(self):
        return self._ImageId

    @ImageId.setter
    def ImageId(self, ImageId):
        self._ImageId = ImageId

    @property
    def ImageName(self):
        return self._ImageName

    @ImageName.setter
    def ImageName(self, ImageName):
        self._ImageName = ImageName

    @property
    def AuthorizedTime(self):
        return self._AuthorizedTime

    @AuthorizedTime.setter
    def AuthorizedTime(self, AuthorizedTime):
        self._AuthorizedTime = AuthorizedTime

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def IsAuthorized(self):
        return self._IsAuthorized

    @IsAuthorized.setter
    def IsAuthorized(self, IsAuthorized):
        self._IsAuthorized = IsAuthorized


    def _deserialize(self, params):
        self._ImageId = params.get("ImageId")
        self._ImageName = params.get("ImageName")
        self._AuthorizedTime = params.get("AuthorizedTime")
        self._Status = params.get("Status")
        self._IsAuthorized = params.get("IsAuthorized")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AutoAuthorizedRuleHostInfo(AbstractModel):
    """自动授权镜像规则授权范围主机列表

    """

    def __init__(self):
        r"""
        :param _HostID: 主机id
        :type HostID: str
        :param _HostIP: 主机ip即内网ip
        :type HostIP: str
        :param _HostName: 主机名称
        :type HostName: str
        :param _ImageCnt: 镜像个数
        :type ImageCnt: int
        :param _ContainerCnt: 容器个数
        :type ContainerCnt: int
        :param _PublicIp: 外网ip
        :type PublicIp: str
        :param _InstanceID: 主机实例ID
        :type InstanceID: str
        :param _MachineType: 主机来源：["CVM", "ECM", "LH", "BM"]  中的之一为腾讯云服务器；["Other"]之一非腾讯云服务器；
        :type MachineType: str
        :param _DockerVersion: docker 版本
        :type DockerVersion: str
        :param _Status: agent运行状态
        :type Status: str
        """
        self._HostID = None
        self._HostIP = None
        self._HostName = None
        self._ImageCnt = None
        self._ContainerCnt = None
        self._PublicIp = None
        self._InstanceID = None
        self._MachineType = None
        self._DockerVersion = None
        self._Status = None

    @property
    def HostID(self):
        return self._HostID

    @HostID.setter
    def HostID(self, HostID):
        self._HostID = HostID

    @property
    def HostIP(self):
        return self._HostIP

    @HostIP.setter
    def HostIP(self, HostIP):
        self._HostIP = HostIP

    @property
    def HostName(self):
        return self._HostName

    @HostName.setter
    def HostName(self, HostName):
        self._HostName = HostName

    @property
    def ImageCnt(self):
        return self._ImageCnt

    @ImageCnt.setter
    def ImageCnt(self, ImageCnt):
        self._ImageCnt = ImageCnt

    @property
    def ContainerCnt(self):
        return self._ContainerCnt

    @ContainerCnt.setter
    def ContainerCnt(self, ContainerCnt):
        self._ContainerCnt = ContainerCnt

    @property
    def PublicIp(self):
        return self._PublicIp

    @PublicIp.setter
    def PublicIp(self, PublicIp):
        self._PublicIp = PublicIp

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def MachineType(self):
        return self._MachineType

    @MachineType.setter
    def MachineType(self, MachineType):
        self._MachineType = MachineType

    @property
    def DockerVersion(self):
        return self._DockerVersion

    @DockerVersion.setter
    def DockerVersion(self, DockerVersion):
        self._DockerVersion = DockerVersion

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._HostID = params.get("HostID")
        self._HostIP = params.get("HostIP")
        self._HostName = params.get("HostName")
        self._ImageCnt = params.get("ImageCnt")
        self._ContainerCnt = params.get("ContainerCnt")
        self._PublicIp = params.get("PublicIp")
        self._InstanceID = params.get("InstanceID")
        self._MachineType = params.get("MachineType")
        self._DockerVersion = params.get("DockerVersion")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CKafkaInstanceInfo(AbstractModel):
    """安全日志kafka可选信息

    """

    def __init__(self):
        r"""
        :param _InstanceID: 实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceID: str
        :param _InstanceName: 实例名称
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceName: str
        :param _TopicList: 主题列表
注意：此字段可能返回 null，表示取不到有效值。
        :type TopicList: list of CKafkaTopicInfo
        :param _RouteList: 路由列表
注意：此字段可能返回 null，表示取不到有效值。
        :type RouteList: list of CkafkaRouteInfo
        :param _KafkaVersion: kafka版本号
注意：此字段可能返回 null，表示取不到有效值。
        :type KafkaVersion: str
        """
        self._InstanceID = None
        self._InstanceName = None
        self._TopicList = None
        self._RouteList = None
        self._KafkaVersion = None

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def InstanceName(self):
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def TopicList(self):
        return self._TopicList

    @TopicList.setter
    def TopicList(self, TopicList):
        self._TopicList = TopicList

    @property
    def RouteList(self):
        return self._RouteList

    @RouteList.setter
    def RouteList(self, RouteList):
        self._RouteList = RouteList

    @property
    def KafkaVersion(self):
        return self._KafkaVersion

    @KafkaVersion.setter
    def KafkaVersion(self, KafkaVersion):
        self._KafkaVersion = KafkaVersion


    def _deserialize(self, params):
        self._InstanceID = params.get("InstanceID")
        self._InstanceName = params.get("InstanceName")
        if params.get("TopicList") is not None:
            self._TopicList = []
            for item in params.get("TopicList"):
                obj = CKafkaTopicInfo()
                obj._deserialize(item)
                self._TopicList.append(obj)
        if params.get("RouteList") is not None:
            self._RouteList = []
            for item in params.get("RouteList"):
                obj = CkafkaRouteInfo()
                obj._deserialize(item)
                self._RouteList.append(obj)
        self._KafkaVersion = params.get("KafkaVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CKafkaTopicInfo(AbstractModel):
    """Ckafka topic信息

    """

    def __init__(self):
        r"""
        :param _TopicID: 主题ID
        :type TopicID: str
        :param _TopicName: 主题名称
        :type TopicName: str
        """
        self._TopicID = None
        self._TopicName = None

    @property
    def TopicID(self):
        return self._TopicID

    @TopicID.setter
    def TopicID(self, TopicID):
        self._TopicID = TopicID

    @property
    def TopicName(self):
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName


    def _deserialize(self, params):
        self._TopicID = params.get("TopicID")
        self._TopicName = params.get("TopicName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckNetworkFirewallPolicyYamlRequest(AbstractModel):
    """CheckNetworkFirewallPolicyYaml请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群Id
        :type ClusterId: str
        :param _PolicyName: 策略名
        :type PolicyName: str
        :param _Yaml: base64编码的networkpolicy yaml字符串
        :type Yaml: str
        :param _Description: 策略描述
        :type Description: str
        """
        self._ClusterId = None
        self._PolicyName = None
        self._Yaml = None
        self._Description = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def PolicyName(self):
        return self._PolicyName

    @PolicyName.setter
    def PolicyName(self, PolicyName):
        self._PolicyName = PolicyName

    @property
    def Yaml(self):
        return self._Yaml

    @Yaml.setter
    def Yaml(self, Yaml):
        self._Yaml = Yaml

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._PolicyName = params.get("PolicyName")
        self._Yaml = params.get("Yaml")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckNetworkFirewallPolicyYamlResponse(AbstractModel):
    """CheckNetworkFirewallPolicyYaml返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 返回创建的任务的ID，为0表示创建失败。
        :type TaskId: int
        :param _Result: 创建任务的结果，"Succ"为成功，"Failed"为失败
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._Result = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CheckRepeatAssetImageRegistryRequest(AbstractModel):
    """CheckRepeatAssetImageRegistry请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 仓库名
        :type Name: str
        """
        self._Name = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckRepeatAssetImageRegistryResponse(AbstractModel):
    """CheckRepeatAssetImageRegistry返回参数结构体

    """

    def __init__(self):
        r"""
        :param _IsRepeat: 是否重复
注意：此字段可能返回 null，表示取不到有效值。
        :type IsRepeat: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._IsRepeat = None
        self._RequestId = None

    @property
    def IsRepeat(self):
        return self._IsRepeat

    @IsRepeat.setter
    def IsRepeat(self, IsRepeat):
        self._IsRepeat = IsRepeat

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._IsRepeat = params.get("IsRepeat")
        self._RequestId = params.get("RequestId")


class CkafkaRouteInfo(AbstractModel):
    """ckafkal路由详情

    """

    def __init__(self):
        r"""
        :param _RouteID: 路由ID
注意：此字段可能返回 null，表示取不到有效值。
        :type RouteID: int
        :param _Domain: 域名名称
注意：此字段可能返回 null，表示取不到有效值。
        :type Domain: str
        :param _DomainPort: 域名端口
注意：此字段可能返回 null，表示取不到有效值。
        :type DomainPort: int
        :param _Vip: 虚拟ip
注意：此字段可能返回 null，表示取不到有效值。
        :type Vip: str
        :param _VipType: 虚拟ip类型
注意：此字段可能返回 null，表示取不到有效值。
        :type VipType: int
        :param _AccessType: 接入类型
// 0：PLAINTEXT (明文方式，没有带用户信息老版本及社区版本都支持)
	// 1：SASL_PLAINTEXT（明文方式，不过在数据开始时，会通过SASL方式登录鉴权，仅社区版本支持）
	// 2：SSL（SSL加密通信，没有带用户信息，老版本及社区版本都支持）
	// 3：SASL_SSL（SSL加密通信，在数据开始时，会通过SASL方式登录鉴权，仅社区版本支持）
注意：此字段可能返回 null，表示取不到有效值。
        :type AccessType: int
        """
        self._RouteID = None
        self._Domain = None
        self._DomainPort = None
        self._Vip = None
        self._VipType = None
        self._AccessType = None

    @property
    def RouteID(self):
        return self._RouteID

    @RouteID.setter
    def RouteID(self, RouteID):
        self._RouteID = RouteID

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainPort(self):
        return self._DomainPort

    @DomainPort.setter
    def DomainPort(self, DomainPort):
        self._DomainPort = DomainPort

    @property
    def Vip(self):
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip

    @property
    def VipType(self):
        return self._VipType

    @VipType.setter
    def VipType(self, VipType):
        self._VipType = VipType

    @property
    def AccessType(self):
        return self._AccessType

    @AccessType.setter
    def AccessType(self, AccessType):
        self._AccessType = AccessType


    def _deserialize(self, params):
        self._RouteID = params.get("RouteID")
        self._Domain = params.get("Domain")
        self._DomainPort = params.get("DomainPort")
        self._Vip = params.get("Vip")
        self._VipType = params.get("VipType")
        self._AccessType = params.get("AccessType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClsLogsetInfo(AbstractModel):
    """cls日志集信息

    """

    def __init__(self):
        r"""
        :param _LogsetID: 日志集ID
        :type LogsetID: str
        :param _LogsetName: 日志集名称
注意：此字段可能返回 null，表示取不到有效值。
        :type LogsetName: str
        :param _TopicList: cls主题列表
注意：此字段可能返回 null，表示取不到有效值。
        :type TopicList: list of ClsTopicInfo
        """
        self._LogsetID = None
        self._LogsetName = None
        self._TopicList = None

    @property
    def LogsetID(self):
        return self._LogsetID

    @LogsetID.setter
    def LogsetID(self, LogsetID):
        self._LogsetID = LogsetID

    @property
    def LogsetName(self):
        return self._LogsetName

    @LogsetName.setter
    def LogsetName(self, LogsetName):
        self._LogsetName = LogsetName

    @property
    def TopicList(self):
        return self._TopicList

    @TopicList.setter
    def TopicList(self, TopicList):
        self._TopicList = TopicList


    def _deserialize(self, params):
        self._LogsetID = params.get("LogsetID")
        self._LogsetName = params.get("LogsetName")
        if params.get("TopicList") is not None:
            self._TopicList = []
            for item in params.get("TopicList"):
                obj = ClsTopicInfo()
                obj._deserialize(item)
                self._TopicList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClsTopicInfo(AbstractModel):
    """cls主题信息

    """

    def __init__(self):
        r"""
        :param _TopicID: 主题ID
        :type TopicID: str
        :param _TopicName: 主题名称
        :type TopicName: str
        """
        self._TopicID = None
        self._TopicName = None

    @property
    def TopicID(self):
        return self._TopicID

    @TopicID.setter
    def TopicID(self, TopicID):
        self._TopicID = TopicID

    @property
    def TopicName(self):
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName


    def _deserialize(self, params):
        self._TopicID = params.get("TopicID")
        self._TopicName = params.get("TopicName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterCheckItem(AbstractModel):
    """表示一条集群安全检测项的详细信息

    """

    def __init__(self):
        r"""
        :param _CheckItemId: 唯一的检测项的ID
注意：此字段可能返回 null，表示取不到有效值。
        :type CheckItemId: int
        :param _Name: 风险项的名称
        :type Name: str
        :param _ItemDetail: 检测项详细描述。
注意：此字段可能返回 null，表示取不到有效值。
        :type ItemDetail: str
        :param _RiskLevel: 威胁等级。严重Serious,高危High,中危Middle,提示Hint
注意：此字段可能返回 null，表示取不到有效值。
        :type RiskLevel: str
        :param _RiskTarget: 检查对象、风险对象.Runc,Kubelet,Containerd,Pods
注意：此字段可能返回 null，表示取不到有效值。
        :type RiskTarget: str
        :param _RiskType: 风险类别,漏洞风险CVERisk,配置风险ConfigRisk
注意：此字段可能返回 null，表示取不到有效值。
        :type RiskType: str
        :param _RiskAttribute: 检测项所属的风险类型,权限提升:PrivilegePromotion,拒绝服务:RefuseService,目录穿越:DirectoryEscape,未授权访问:UnauthorizedAccess,权限许可和访问控制问题:PrivilegeAndAccessControl,敏感信息泄露:SensitiveInfoLeak
注意：此字段可能返回 null，表示取不到有效值。
        :type RiskAttribute: str
        :param _RiskProperty: 风险特征,Tag.存在EXP:ExistEXP,存在POD:ExistPOC,无需重启:NoNeedReboot, 服务重启:ServerRestart,远程信息泄露:RemoteInfoLeak,远程拒绝服务:RemoteRefuseService,远程利用:RemoteExploit,远程执行:RemoteExecute
注意：此字段可能返回 null，表示取不到有效值。
        :type RiskProperty: str
        :param _CVENumber: CVE编号
注意：此字段可能返回 null，表示取不到有效值。
        :type CVENumber: str
        :param _DiscoverTime: 披露时间
注意：此字段可能返回 null，表示取不到有效值。
        :type DiscoverTime: str
        :param _Solution: 解决方案
注意：此字段可能返回 null，表示取不到有效值。
        :type Solution: str
        :param _CVSS: CVSS信息,用于画图
注意：此字段可能返回 null，表示取不到有效值。
        :type CVSS: str
        :param _CVSSScore: CVSS分数
注意：此字段可能返回 null，表示取不到有效值。
        :type CVSSScore: str
        :param _RelateLink: 参考连接
注意：此字段可能返回 null，表示取不到有效值。
        :type RelateLink: str
        :param _AffectedType: 影响类型，为Node或者Workload
注意：此字段可能返回 null，表示取不到有效值。
        :type AffectedType: str
        :param _AffectedVersion: 受影响的版本信息
注意：此字段可能返回 null，表示取不到有效值。
        :type AffectedVersion: str
        :param _IgnoredAssetNum: 忽略的资产数量
注意：此字段可能返回 null，表示取不到有效值。
        :type IgnoredAssetNum: int
        :param _IsIgnored: 是否忽略该检测项
注意：此字段可能返回 null，表示取不到有效值。
        :type IsIgnored: bool
        :param _RiskAssessment: 受影响评估
注意：此字段可能返回 null，表示取不到有效值。
        :type RiskAssessment: str
        """
        self._CheckItemId = None
        self._Name = None
        self._ItemDetail = None
        self._RiskLevel = None
        self._RiskTarget = None
        self._RiskType = None
        self._RiskAttribute = None
        self._RiskProperty = None
        self._CVENumber = None
        self._DiscoverTime = None
        self._Solution = None
        self._CVSS = None
        self._CVSSScore = None
        self._RelateLink = None
        self._AffectedType = None
        self._AffectedVersion = None
        self._IgnoredAssetNum = None
        self._IsIgnored = None
        self._RiskAssessment = None

    @property
    def CheckItemId(self):
        return self._CheckItemId

    @CheckItemId.setter
    def CheckItemId(self, CheckItemId):
        self._CheckItemId = CheckItemId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ItemDetail(self):
        return self._ItemDetail

    @ItemDetail.setter
    def ItemDetail(self, ItemDetail):
        self._ItemDetail = ItemDetail

    @property
    def RiskLevel(self):
        return self._RiskLevel

    @RiskLevel.setter
    def RiskLevel(self, RiskLevel):
        self._RiskLevel = RiskLevel

    @property
    def RiskTarget(self):
        return self._RiskTarget

    @RiskTarget.setter
    def RiskTarget(self, RiskTarget):
        self._RiskTarget = RiskTarget

    @property
    def RiskType(self):
        return self._RiskType

    @RiskType.setter
    def RiskType(self, RiskType):
        self._RiskType = RiskType

    @property
    def RiskAttribute(self):
        return self._RiskAttribute

    @RiskAttribute.setter
    def RiskAttribute(self, RiskAttribute):
        self._RiskAttribute = RiskAttribute

    @property
    def RiskProperty(self):
        return self._RiskProperty

    @RiskProperty.setter
    def RiskProperty(self, RiskProperty):
        self._RiskProperty = RiskProperty

    @property
    def CVENumber(self):
        return self._CVENumber

    @CVENumber.setter
    def CVENumber(self, CVENumber):
        self._CVENumber = CVENumber

    @property
    def DiscoverTime(self):
        return self._DiscoverTime

    @DiscoverTime.setter
    def DiscoverTime(self, DiscoverTime):
        self._DiscoverTime = DiscoverTime

    @property
    def Solution(self):
        return self._Solution

    @Solution.setter
    def Solution(self, Solution):
        self._Solution = Solution

    @property
    def CVSS(self):
        return self._CVSS

    @CVSS.setter
    def CVSS(self, CVSS):
        self._CVSS = CVSS

    @property
    def CVSSScore(self):
        return self._CVSSScore

    @CVSSScore.setter
    def CVSSScore(self, CVSSScore):
        self._CVSSScore = CVSSScore

    @property
    def RelateLink(self):
        return self._RelateLink

    @RelateLink.setter
    def RelateLink(self, RelateLink):
        self._RelateLink = RelateLink

    @property
    def AffectedType(self):
        return self._AffectedType

    @AffectedType.setter
    def AffectedType(self, AffectedType):
        self._AffectedType = AffectedType

    @property
    def AffectedVersion(self):
        return self._AffectedVersion

    @AffectedVersion.setter
    def AffectedVersion(self, AffectedVersion):
        self._AffectedVersion = AffectedVersion

    @property
    def IgnoredAssetNum(self):
        return self._IgnoredAssetNum

    @IgnoredAssetNum.setter
    def IgnoredAssetNum(self, IgnoredAssetNum):
        self._IgnoredAssetNum = IgnoredAssetNum

    @property
    def IsIgnored(self):
        return self._IsIgnored

    @IsIgnored.setter
    def IsIgnored(self, IsIgnored):
        self._IsIgnored = IsIgnored

    @property
    def RiskAssessment(self):
        return self._RiskAssessment

    @RiskAssessment.setter
    def RiskAssessment(self, RiskAssessment):
        self._RiskAssessment = RiskAssessment


    def _deserialize(self, params):
        self._CheckItemId = params.get("CheckItemId")
        self._Name = params.get("Name")
        self._ItemDetail = params.get("ItemDetail")
        self._RiskLevel = params.get("RiskLevel")
        self._RiskTarget = params.get("RiskTarget")
        self._RiskType = params.get("RiskType")
        self._RiskAttribute = params.get("RiskAttribute")
        self._RiskProperty = params.get("RiskProperty")
        self._CVENumber = params.get("CVENumber")
        self._DiscoverTime = params.get("DiscoverTime")
        self._Solution = params.get("Solution")
        self._CVSS = params.get("CVSS")
        self._CVSSScore = params.get("CVSSScore")
        self._RelateLink = params.get("RelateLink")
        self._AffectedType = params.get("AffectedType")
        self._AffectedVersion = params.get("AffectedVersion")
        self._IgnoredAssetNum = params.get("IgnoredAssetNum")
        self._IsIgnored = params.get("IsIgnored")
        self._RiskAssessment = params.get("RiskAssessment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterCheckTaskItem(AbstractModel):
    """集群检查任务入参

    """

    def __init__(self):
        r"""
        :param _ClusterId: 指定要扫描的集群ID
        :type ClusterId: str
        :param _ClusterRegion: 集群所属地域
        :type ClusterRegion: str
        :param _NodeIp: 指定要扫描的节点IP
        :type NodeIp: str
        :param _WorkloadName: 按照要扫描的workload名字
        :type WorkloadName: str
        """
        self._ClusterId = None
        self._ClusterRegion = None
        self._NodeIp = None
        self._WorkloadName = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterRegion(self):
        return self._ClusterRegion

    @ClusterRegion.setter
    def ClusterRegion(self, ClusterRegion):
        self._ClusterRegion = ClusterRegion

    @property
    def NodeIp(self):
        return self._NodeIp

    @NodeIp.setter
    def NodeIp(self, NodeIp):
        self._NodeIp = NodeIp

    @property
    def WorkloadName(self):
        return self._WorkloadName

    @WorkloadName.setter
    def WorkloadName(self, WorkloadName):
        self._WorkloadName = WorkloadName


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterRegion = params.get("ClusterRegion")
        self._NodeIp = params.get("NodeIp")
        self._WorkloadName = params.get("WorkloadName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterCreateComponentItem(AbstractModel):
    """CreateCheckComponent的入口参数,用于批量安装防御容器

    """

    def __init__(self):
        r"""
        :param _ClusterId: 要安装组件的集群ID。
        :type ClusterId: str
        :param _ClusterRegion: 该集群对应的地域
        :type ClusterRegion: str
        """
        self._ClusterId = None
        self._ClusterRegion = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterRegion(self):
        return self._ClusterRegion

    @ClusterRegion.setter
    def ClusterRegion(self, ClusterRegion):
        self._ClusterRegion = ClusterRegion


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterRegion = params.get("ClusterRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterCustomParameters(AbstractModel):
    """集群自定义参数

    """

    def __init__(self):
        r"""
        :param _Name: 参数名
        :type Name: str
        :param _Values: 参数值
        :type Values: list of str
        """
        self._Name = None
        self._Values = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterInfoItem(AbstractModel):
    """集群资产返回的结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群id
        :type ClusterId: str
        :param _ClusterName: 集群名字
        :type ClusterName: str
        :param _ClusterVersion: 集群版本
        :type ClusterVersion: str
        :param _ClusterOs: 集群操作系统
        :type ClusterOs: str
        :param _ClusterType: 集群类型
        :type ClusterType: str
        :param _ClusterNodeNum: 集群节点数
        :type ClusterNodeNum: int
        :param _Region: 集群区域
        :type Region: str
        :param _DefenderStatus: 监控组件的状态，为Defender_Uninstall、Defender_Normal、Defender_Error、Defender_Installing
        :type DefenderStatus: str
        :param _ClusterStatus: 集群状态
        :type ClusterStatus: str
        :param _ClusterCheckMode: 集群的检测模式，为Cluster_Normal或者Cluster_Actived.
        :type ClusterCheckMode: str
        :param _ClusterAutoCheck: 是否自动定期检测
        :type ClusterAutoCheck: bool
        :param _DefenderErrorReason: 防护容器部署失败原因，为UserDaemonSetNotReady时,和UnreadyNodeNum转成"N个节点防御容器为就绪"，其他错误直接展示
        :type DefenderErrorReason: str
        :param _UnreadyNodeNum: 防御容器没有ready状态的节点数量
        :type UnreadyNodeNum: int
        :param _SeriousRiskCount: 严重风险检查项的数量
        :type SeriousRiskCount: int
        :param _HighRiskCount: 高风险检查项的数量
        :type HighRiskCount: int
        :param _MiddleRiskCount: 中风险检查项的数量
        :type MiddleRiskCount: int
        :param _HintRiskCount: 提示风险检查项的数量
        :type HintRiskCount: int
        :param _CheckFailReason: 检查失败原因
        :type CheckFailReason: str
        :param _CheckStatus: 检查状态,为Task_Running, NoRisk, HasRisk, Uncheck, Task_Error
        :type CheckStatus: str
        :param _TaskCreateTime: 任务创建时间,检查时间
        :type TaskCreateTime: str
        :param _AccessedStatus: 接入状态:
未接入: AccessedNone
已防护: AccessedDefended
未防护: AccessedInstalled
部分防护: AccessedPartialDefence
接入异常: AccessedException
卸载异常: AccessedUninstallException
接入中: AccessedInstalling
卸载中: AccessedUninstalling
注意：此字段可能返回 null，表示取不到有效值。
        :type AccessedStatus: str
        :param _AccessedSubStatus: 接入失败原因
注意：此字段可能返回 null，表示取不到有效值。
        :type AccessedSubStatus: str
        :param _NodeCount: 节点总数
注意：此字段可能返回 null，表示取不到有效值。
        :type NodeCount: int
        :param _OffLineNodeCount: 离线节点数
注意：此字段可能返回 null，表示取不到有效值。
        :type OffLineNodeCount: int
        :param _UnInstallAgentNodeCount: 未安装agent节点数
注意：此字段可能返回 null，表示取不到有效值。
        :type UnInstallAgentNodeCount: int
        :param _ChargeCoresCnt: 计费核数
注意：此字段可能返回 null，表示取不到有效值。
        :type ChargeCoresCnt: int
        """
        self._ClusterId = None
        self._ClusterName = None
        self._ClusterVersion = None
        self._ClusterOs = None
        self._ClusterType = None
        self._ClusterNodeNum = None
        self._Region = None
        self._DefenderStatus = None
        self._ClusterStatus = None
        self._ClusterCheckMode = None
        self._ClusterAutoCheck = None
        self._DefenderErrorReason = None
        self._UnreadyNodeNum = None
        self._SeriousRiskCount = None
        self._HighRiskCount = None
        self._MiddleRiskCount = None
        self._HintRiskCount = None
        self._CheckFailReason = None
        self._CheckStatus = None
        self._TaskCreateTime = None
        self._AccessedStatus = None
        self._AccessedSubStatus = None
        self._NodeCount = None
        self._OffLineNodeCount = None
        self._UnInstallAgentNodeCount = None
        self._ChargeCoresCnt = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def ClusterVersion(self):
        return self._ClusterVersion

    @ClusterVersion.setter
    def ClusterVersion(self, ClusterVersion):
        self._ClusterVersion = ClusterVersion

    @property
    def ClusterOs(self):
        return self._ClusterOs

    @ClusterOs.setter
    def ClusterOs(self, ClusterOs):
        self._ClusterOs = ClusterOs

    @property
    def ClusterType(self):
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def ClusterNodeNum(self):
        return self._ClusterNodeNum

    @ClusterNodeNum.setter
    def ClusterNodeNum(self, ClusterNodeNum):
        self._ClusterNodeNum = ClusterNodeNum

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def DefenderStatus(self):
        return self._DefenderStatus

    @DefenderStatus.setter
    def DefenderStatus(self, DefenderStatus):
        self._DefenderStatus = DefenderStatus

    @property
    def ClusterStatus(self):
        return self._ClusterStatus

    @ClusterStatus.setter
    def ClusterStatus(self, ClusterStatus):
        self._ClusterStatus = ClusterStatus

    @property
    def ClusterCheckMode(self):
        return self._ClusterCheckMode

    @ClusterCheckMode.setter
    def ClusterCheckMode(self, ClusterCheckMode):
        self._ClusterCheckMode = ClusterCheckMode

    @property
    def ClusterAutoCheck(self):
        return self._ClusterAutoCheck

    @ClusterAutoCheck.setter
    def ClusterAutoCheck(self, ClusterAutoCheck):
        self._ClusterAutoCheck = ClusterAutoCheck

    @property
    def DefenderErrorReason(self):
        return self._DefenderErrorReason

    @DefenderErrorReason.setter
    def DefenderErrorReason(self, DefenderErrorReason):
        self._DefenderErrorReason = DefenderErrorReason

    @property
    def UnreadyNodeNum(self):
        return self._UnreadyNodeNum

    @UnreadyNodeNum.setter
    def UnreadyNodeNum(self, UnreadyNodeNum):
        self._UnreadyNodeNum = UnreadyNodeNum

    @property
    def SeriousRiskCount(self):
        return self._SeriousRiskCount

    @SeriousRiskCount.setter
    def SeriousRiskCount(self, SeriousRiskCount):
        self._SeriousRiskCount = SeriousRiskCount

    @property
    def HighRiskCount(self):
        return self._HighRiskCount

    @HighRiskCount.setter
    def HighRiskCount(self, HighRiskCount):
        self._HighRiskCount = HighRiskCount

    @property
    def MiddleRiskCount(self):
        return self._MiddleRiskCount

    @MiddleRiskCount.setter
    def MiddleRiskCount(self, MiddleRiskCount):
        self._MiddleRiskCount = MiddleRiskCount

    @property
    def HintRiskCount(self):
        return self._HintRiskCount

    @HintRiskCount.setter
    def HintRiskCount(self, HintRiskCount):
        self._HintRiskCount = HintRiskCount

    @property
    def CheckFailReason(self):
        return self._CheckFailReason

    @CheckFailReason.setter
    def CheckFailReason(self, CheckFailReason):
        self._CheckFailReason = CheckFailReason

    @property
    def CheckStatus(self):
        return self._CheckStatus

    @CheckStatus.setter
    def CheckStatus(self, CheckStatus):
        self._CheckStatus = CheckStatus

    @property
    def TaskCreateTime(self):
        return self._TaskCreateTime

    @TaskCreateTime.setter
    def TaskCreateTime(self, TaskCreateTime):
        self._TaskCreateTime = TaskCreateTime

    @property
    def AccessedStatus(self):
        return self._AccessedStatus

    @AccessedStatus.setter
    def AccessedStatus(self, AccessedStatus):
        self._AccessedStatus = AccessedStatus

    @property
    def AccessedSubStatus(self):
        return self._AccessedSubStatus

    @AccessedSubStatus.setter
    def AccessedSubStatus(self, AccessedSubStatus):
        self._AccessedSubStatus = AccessedSubStatus

    @property
    def NodeCount(self):
        return self._NodeCount

    @NodeCount.setter
    def NodeCount(self, NodeCount):
        self._NodeCount = NodeCount

    @property
    def OffLineNodeCount(self):
        return self._OffLineNodeCount

    @OffLineNodeCount.setter
    def OffLineNodeCount(self, OffLineNodeCount):
        self._OffLineNodeCount = OffLineNodeCount

    @property
    def UnInstallAgentNodeCount(self):
        return self._UnInstallAgentNodeCount

    @UnInstallAgentNodeCount.setter
    def UnInstallAgentNodeCount(self, UnInstallAgentNodeCount):
        self._UnInstallAgentNodeCount = UnInstallAgentNodeCount

    @property
    def ChargeCoresCnt(self):
        return self._ChargeCoresCnt

    @ChargeCoresCnt.setter
    def ChargeCoresCnt(self, ChargeCoresCnt):
        self._ChargeCoresCnt = ChargeCoresCnt


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._ClusterVersion = params.get("ClusterVersion")
        self._ClusterOs = params.get("ClusterOs")
        self._ClusterType = params.get("ClusterType")
        self._ClusterNodeNum = params.get("ClusterNodeNum")
        self._Region = params.get("Region")
        self._DefenderStatus = params.get("DefenderStatus")
        self._ClusterStatus = params.get("ClusterStatus")
        self._ClusterCheckMode = params.get("ClusterCheckMode")
        self._ClusterAutoCheck = params.get("ClusterAutoCheck")
        self._DefenderErrorReason = params.get("DefenderErrorReason")
        self._UnreadyNodeNum = params.get("UnreadyNodeNum")
        self._SeriousRiskCount = params.get("SeriousRiskCount")
        self._HighRiskCount = params.get("HighRiskCount")
        self._MiddleRiskCount = params.get("MiddleRiskCount")
        self._HintRiskCount = params.get("HintRiskCount")
        self._CheckFailReason = params.get("CheckFailReason")
        self._CheckStatus = params.get("CheckStatus")
        self._TaskCreateTime = params.get("TaskCreateTime")
        self._AccessedStatus = params.get("AccessedStatus")
        self._AccessedSubStatus = params.get("AccessedSubStatus")
        self._NodeCount = params.get("NodeCount")
        self._OffLineNodeCount = params.get("OffLineNodeCount")
        self._UnInstallAgentNodeCount = params.get("UnInstallAgentNodeCount")
        self._ChargeCoresCnt = params.get("ChargeCoresCnt")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterNodeInfo(AbstractModel):
    """集群的节点信息

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例id
        :type InstanceId: str
        :param _PrivateIpAddresses: 内网ip地址
        :type PrivateIpAddresses: str
        :param _InstanceRole: 节点的角色，Master、Work等
        :type InstanceRole: str
        :param _InstanceState: 实例的状态（running 运行中，initializing 初始化中，failed 异常）
        :type InstanceState: str
        :param _NodeName: 节点名称
        :type NodeName: str
        :param _AgentStatus: agent安装状态
注意：此字段可能返回 null，表示取不到有效值。
        :type AgentStatus: str
        :param _PublicIP: 公网ip
注意：此字段可能返回 null，表示取不到有效值。
        :type PublicIP: str
        :param _HostID: 节点ID
注意：此字段可能返回 null，表示取不到有效值。
        :type HostID: str
        :param _MachineType: 主机类型(普通节点情况)
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineType: str
        :param _NodeType: 节点类型(
NORMAL: 普通节点
SUPER:超级节点
)
注意：此字段可能返回 null，表示取不到有效值。
        :type NodeType: str
        :param _UUID: uuid
注意：此字段可能返回 null，表示取不到有效值。
        :type UUID: str
        :param _ChargeCoresCnt: 计费核数
注意：此字段可能返回 null，表示取不到有效值。
        :type ChargeCoresCnt: int
        :param _DefendStatus: 防护状态:
已防护: Defended
未防护: UnDefended
注意：此字段可能返回 null，表示取不到有效值。
        :type DefendStatus: str
        """
        self._InstanceId = None
        self._PrivateIpAddresses = None
        self._InstanceRole = None
        self._InstanceState = None
        self._NodeName = None
        self._AgentStatus = None
        self._PublicIP = None
        self._HostID = None
        self._MachineType = None
        self._NodeType = None
        self._UUID = None
        self._ChargeCoresCnt = None
        self._DefendStatus = None

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def PrivateIpAddresses(self):
        return self._PrivateIpAddresses

    @PrivateIpAddresses.setter
    def PrivateIpAddresses(self, PrivateIpAddresses):
        self._PrivateIpAddresses = PrivateIpAddresses

    @property
    def InstanceRole(self):
        return self._InstanceRole

    @InstanceRole.setter
    def InstanceRole(self, InstanceRole):
        self._InstanceRole = InstanceRole

    @property
    def InstanceState(self):
        return self._InstanceState

    @InstanceState.setter
    def InstanceState(self, InstanceState):
        self._InstanceState = InstanceState

    @property
    def NodeName(self):
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def AgentStatus(self):
        return self._AgentStatus

    @AgentStatus.setter
    def AgentStatus(self, AgentStatus):
        self._AgentStatus = AgentStatus

    @property
    def PublicIP(self):
        return self._PublicIP

    @PublicIP.setter
    def PublicIP(self, PublicIP):
        self._PublicIP = PublicIP

    @property
    def HostID(self):
        return self._HostID

    @HostID.setter
    def HostID(self, HostID):
        self._HostID = HostID

    @property
    def MachineType(self):
        return self._MachineType

    @MachineType.setter
    def MachineType(self, MachineType):
        self._MachineType = MachineType

    @property
    def NodeType(self):
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def UUID(self):
        return self._UUID

    @UUID.setter
    def UUID(self, UUID):
        self._UUID = UUID

    @property
    def ChargeCoresCnt(self):
        return self._ChargeCoresCnt

    @ChargeCoresCnt.setter
    def ChargeCoresCnt(self, ChargeCoresCnt):
        self._ChargeCoresCnt = ChargeCoresCnt

    @property
    def DefendStatus(self):
        return self._DefendStatus

    @DefendStatus.setter
    def DefendStatus(self, DefendStatus):
        self._DefendStatus = DefendStatus


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._PrivateIpAddresses = params.get("PrivateIpAddresses")
        self._InstanceRole = params.get("InstanceRole")
        self._InstanceState = params.get("InstanceState")
        self._NodeName = params.get("NodeName")
        self._AgentStatus = params.get("AgentStatus")
        self._PublicIP = params.get("PublicIP")
        self._HostID = params.get("HostID")
        self._MachineType = params.get("MachineType")
        self._NodeType = params.get("NodeType")
        self._UUID = params.get("UUID")
        self._ChargeCoresCnt = params.get("ChargeCoresCnt")
        self._DefendStatus = params.get("DefendStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterPodInfo(AbstractModel):
    """集群的pod详细信息

    """

    def __init__(self):
        r"""
        :param _PodName: Pod名称.
        :type PodName: str
        :param _Status: Pod状态
        :type Status: str
        :param _PodIP: Pod IP
        :type PodIP: str
        :param _NodeLanIP: 节点内网Ip
        :type NodeLanIP: str
        :param _WorkloadName: 所属的工作负载名字
        :type WorkloadName: str
        :param _WorkloadKind: 所属工作负载类型
        :type WorkloadKind: str
        :param _ClusterName: 所属集群名字
        :type ClusterName: str
        :param _ClusterId: 所属集群ID
        :type ClusterId: str
        :param _Namespace: 所属命名空间
        :type Namespace: str
        :param _Region: 所属地域
        :type Region: str
        :param _Age: 运行时间
        :type Age: str
        :param _StartTime: 创建时间
        :type StartTime: str
        :param _Restarts: 重启次数
        :type Restarts: int
        :param _ServiceName: 关联的service名字
        :type ServiceName: str
        :param _ServiceCount: 关联的service数量
        :type ServiceCount: int
        :param _ContainerName: 关联的容器名字
        :type ContainerName: str
        :param _ContainerCount: 关联的容器数量
        :type ContainerCount: int
        :param _CPU: CPU占用率
        :type CPU: int
        :param _Memory: 内存占用量
        :type Memory: int
        :param _Labels: Pod标签
        :type Labels: str
        :param _ClusterStatus: 集群状态
        :type ClusterStatus: str
        :param _WorkloadLabels: 工作负载标签
        :type WorkloadLabels: str
        :param _ContainerId: 容器Id
        :type ContainerId: str
        :param _HostName: 主机名称
        :type HostName: str
        :param _HostId: 主机Id
        :type HostId: str
        :param _ClusterType: 集群类型
        :type ClusterType: str
        :param _NodeName: abc
        :type NodeName: str
        :param _NodeType: NORMAL：普通节点 SUPER：超级节点
        :type NodeType: str
        :param _ChargeCoresCnt: 计费核数
        :type ChargeCoresCnt: int
        """
        self._PodName = None
        self._Status = None
        self._PodIP = None
        self._NodeLanIP = None
        self._WorkloadName = None
        self._WorkloadKind = None
        self._ClusterName = None
        self._ClusterId = None
        self._Namespace = None
        self._Region = None
        self._Age = None
        self._StartTime = None
        self._Restarts = None
        self._ServiceName = None
        self._ServiceCount = None
        self._ContainerName = None
        self._ContainerCount = None
        self._CPU = None
        self._Memory = None
        self._Labels = None
        self._ClusterStatus = None
        self._WorkloadLabels = None
        self._ContainerId = None
        self._HostName = None
        self._HostId = None
        self._ClusterType = None
        self._NodeName = None
        self._NodeType = None
        self._ChargeCoresCnt = None

    @property
    def PodName(self):
        return self._PodName

    @PodName.setter
    def PodName(self, PodName):
        self._PodName = PodName

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def PodIP(self):
        return self._PodIP

    @PodIP.setter
    def PodIP(self, PodIP):
        self._PodIP = PodIP

    @property
    def NodeLanIP(self):
        return self._NodeLanIP

    @NodeLanIP.setter
    def NodeLanIP(self, NodeLanIP):
        self._NodeLanIP = NodeLanIP

    @property
    def WorkloadName(self):
        return self._WorkloadName

    @WorkloadName.setter
    def WorkloadName(self, WorkloadName):
        self._WorkloadName = WorkloadName

    @property
    def WorkloadKind(self):
        return self._WorkloadKind

    @WorkloadKind.setter
    def WorkloadKind(self, WorkloadKind):
        self._WorkloadKind = WorkloadKind

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Namespace(self):
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Age(self):
        return self._Age

    @Age.setter
    def Age(self, Age):
        self._Age = Age

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def Restarts(self):
        return self._Restarts

    @Restarts.setter
    def Restarts(self, Restarts):
        self._Restarts = Restarts

    @property
    def ServiceName(self):
        return self._ServiceName

    @ServiceName.setter
    def ServiceName(self, ServiceName):
        self._ServiceName = ServiceName

    @property
    def ServiceCount(self):
        return self._ServiceCount

    @ServiceCount.setter
    def ServiceCount(self, ServiceCount):
        self._ServiceCount = ServiceCount

    @property
    def ContainerName(self):
        return self._ContainerName

    @ContainerName.setter
    def ContainerName(self, ContainerName):
        self._ContainerName = ContainerName

    @property
    def ContainerCount(self):
        return self._ContainerCount

    @ContainerCount.setter
    def ContainerCount(self, ContainerCount):
        self._ContainerCount = ContainerCount

    @property
    def CPU(self):
        return self._CPU

    @CPU.setter
    def CPU(self, CPU):
        self._CPU = CPU

    @property
    def Memory(self):
        return self._Memory

    @Memory.setter
    def Memory(self, Memory):
        self._Memory = Memory

    @property
    def Labels(self):
        return self._Labels

    @Labels.setter
    def Labels(self, Labels):
        self._Labels = Labels

    @property
    def ClusterStatus(self):
        return self._ClusterStatus

    @ClusterStatus.setter
    def ClusterStatus(self, ClusterStatus):
        self._ClusterStatus = ClusterStatus

    @property
    def WorkloadLabels(self):
        return self._WorkloadLabels

    @WorkloadLabels.setter
    def WorkloadLabels(self, WorkloadLabels):
        self._WorkloadLabels = WorkloadLabels

    @property
    def ContainerId(self):
        return self._ContainerId

    @ContainerId.setter
    def ContainerId(self, ContainerId):
        self._ContainerId = ContainerId

    @property
    def HostName(self):
        return self._HostName

    @HostName.setter
    def HostName(self, HostName):
        self._HostName = HostName

    @property
    def HostId(self):
        return self._HostId

    @HostId.setter
    def HostId(self, HostId):
        self._HostId = HostId

    @property
    def ClusterType(self):
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def NodeName(self):
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def NodeType(self):
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def ChargeCoresCnt(self):
        return self._ChargeCoresCnt

    @ChargeCoresCnt.setter
    def ChargeCoresCnt(self, ChargeCoresCnt):
        self._ChargeCoresCnt = ChargeCoresCnt


    def _deserialize(self, params):
        self._PodName = params.get("PodName")
        self._Status = params.get("Status")
        self._PodIP = params.get("PodIP")
        self._NodeLanIP = params.get("NodeLanIP")
        self._WorkloadName = params.get("WorkloadName")
        self._WorkloadKind = params.get("WorkloadKind")
        self._ClusterName = params.get("ClusterName")
        self._ClusterId = params.get("ClusterId")
        self._Namespace = params.get("Namespace")
        self._Region = params.get("Region")
        self._Age = params.get("Age")
        self._StartTime = params.get("StartTime")
        self._Restarts = params.get("Restarts")
        self._ServiceName = params.get("ServiceName")
        self._ServiceCount = params.get("ServiceCount")
        self._ContainerName = params.get("ContainerName")
        self._ContainerCount = params.get("ContainerCount")
        self._CPU = params.get("CPU")
        self._Memory = params.get("Memory")
        self._Labels = params.get("Labels")
        self._ClusterStatus = params.get("ClusterStatus")
        self._WorkloadLabels = params.get("WorkloadLabels")
        self._ContainerId = params.get("ContainerId")
        self._HostName = params.get("HostName")
        self._HostId = params.get("HostId")
        self._ClusterType = params.get("ClusterType")
        self._NodeName = params.get("NodeName")
        self._NodeType = params.get("NodeType")
        self._ChargeCoresCnt = params.get("ChargeCoresCnt")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterRiskItem(AbstractModel):
    """风险项是检查完之后，有问题的检测项，并且加了一些检查结果信息。

    """

    def __init__(self):
        r"""
        :param _CheckItem: 检测项相关信息
        :type CheckItem: :class:`tencentcloud.tcss.v20201101.models.ClusterCheckItem`
        :param _VerifyInfo: 验证信息
        :type VerifyInfo: str
        :param _ErrorMessage: 事件描述,检查的错误信息
        :type ErrorMessage: str
        :param _AffectedClusterCount: 受影响的集群数量
        :type AffectedClusterCount: int
        :param _AffectedNodeCount: 受影响的节点数量
        :type AffectedNodeCount: int
        """
        self._CheckItem = None
        self._VerifyInfo = None
        self._ErrorMessage = None
        self._AffectedClusterCount = None
        self._AffectedNodeCount = None

    @property
    def CheckItem(self):
        return self._CheckItem

    @CheckItem.setter
    def CheckItem(self, CheckItem):
        self._CheckItem = CheckItem

    @property
    def VerifyInfo(self):
        return self._VerifyInfo

    @VerifyInfo.setter
    def VerifyInfo(self, VerifyInfo):
        self._VerifyInfo = VerifyInfo

    @property
    def ErrorMessage(self):
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def AffectedClusterCount(self):
        return self._AffectedClusterCount

    @AffectedClusterCount.setter
    def AffectedClusterCount(self, AffectedClusterCount):
        self._AffectedClusterCount = AffectedClusterCount

    @property
    def AffectedNodeCount(self):
        return self._AffectedNodeCount

    @AffectedNodeCount.setter
    def AffectedNodeCount(self, AffectedNodeCount):
        self._AffectedNodeCount = AffectedNodeCount


    def _deserialize(self, params):
        if params.get("CheckItem") is not None:
            self._CheckItem = ClusterCheckItem()
            self._CheckItem._deserialize(params.get("CheckItem"))
        self._VerifyInfo = params.get("VerifyInfo")
        self._ErrorMessage = params.get("ErrorMessage")
        self._AffectedClusterCount = params.get("AffectedClusterCount")
        self._AffectedNodeCount = params.get("AffectedNodeCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceAffectedAsset(AbstractModel):
    """表示检测项所影响的资产的信息。

    """

    def __init__(self):
        r"""
        :param _CustomerAssetId: 为客户分配的唯一的资产项的ID。
        :type CustomerAssetId: int
        :param _AssetName: 资产项的名称。
        :type AssetName: str
        :param _AssetType: 资产项的类型
        :type AssetType: str
        :param _CheckStatus: 检测状态

CHECK_INIT, 待检测

CHECK_RUNNING, 检测中

CHECK_FINISHED, 检测完成

CHECK_FAILED, 检测失败
        :type CheckStatus: str
        :param _NodeName: 节点名称。
        :type NodeName: str
        :param _LastCheckTime: 上次检测的时间，格式为”YYYY-MM-DD HH:m::SS“。

如果没有检测过，此处为”0000-00-00 00:00:00“。
        :type LastCheckTime: str
        :param _CheckResult: 检测结果。取值为：

RESULT_FAILED: 未通过

RESULT_PASSED: 通过
        :type CheckResult: str
        :param _HostIP: 主机IP
注意：此字段可能返回 null，表示取不到有效值。
        :type HostIP: str
        :param _ImageTag: 镜像的tag
注意：此字段可能返回 null，表示取不到有效值。
        :type ImageTag: str
        :param _VerifyInfo: 检查项验证信息
注意：此字段可能返回 null，表示取不到有效值。
        :type VerifyInfo: str
        :param _InstanceId: 主机实例id
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceId: str
        """
        self._CustomerAssetId = None
        self._AssetName = None
        self._AssetType = None
        self._CheckStatus = None
        self._NodeName = None
        self._LastCheckTime = None
        self._CheckResult = None
        self._HostIP = None
        self._ImageTag = None
        self._VerifyInfo = None
        self._InstanceId = None

    @property
    def CustomerAssetId(self):
        return self._CustomerAssetId

    @CustomerAssetId.setter
    def CustomerAssetId(self, CustomerAssetId):
        self._CustomerAssetId = CustomerAssetId

    @property
    def AssetName(self):
        return self._AssetName

    @AssetName.setter
    def AssetName(self, AssetName):
        self._AssetName = AssetName

    @property
    def AssetType(self):
        return self._AssetType

    @AssetType.setter
    def AssetType(self, AssetType):
        self._AssetType = AssetType

    @property
    def CheckStatus(self):
        return self._CheckStatus

    @CheckStatus.setter
    def CheckStatus(self, CheckStatus):
        self._CheckStatus = CheckStatus

    @property
    def NodeName(self):
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def LastCheckTime(self):
        return self._LastCheckTime

    @LastCheckTime.setter
    def LastCheckTime(self, LastCheckTime):
        self._LastCheckTime = LastCheckTime

    @property
    def CheckResult(self):
        return self._CheckResult

    @CheckResult.setter
    def CheckResult(self, CheckResult):
        self._CheckResult = CheckResult

    @property
    def HostIP(self):
        return self._HostIP

    @HostIP.setter
    def HostIP(self, HostIP):
        self._HostIP = HostIP

    @property
    def ImageTag(self):
        return self._ImageTag

    @ImageTag.setter
    def ImageTag(self, ImageTag):
        self._ImageTag = ImageTag

    @property
    def VerifyInfo(self):
        return self._VerifyInfo

    @VerifyInfo.setter
    def VerifyInfo(self, VerifyInfo):
        self._VerifyInfo = VerifyInfo

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._CustomerAssetId = params.get("CustomerAssetId")
        self._AssetName = params.get("AssetName")
        self._AssetType = params.get("AssetType")
        self._CheckStatus = params.get("CheckStatus")
        self._NodeName = params.get("NodeName")
        self._LastCheckTime = params.get("LastCheckTime")
        self._CheckResult = params.get("CheckResult")
        self._HostIP = params.get("HostIP")
        self._ImageTag = params.get("ImageTag")
        self._VerifyInfo = params.get("VerifyInfo")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceAssetDetailInfo(AbstractModel):
    """表示一项资产的详情。

    """

    def __init__(self):
        r"""
        :param _CustomerAssetId: 客户资产的ID。
        :type CustomerAssetId: int
        :param _AssetType: 资产类别。
        :type AssetType: str
        :param _AssetName: 资产的名称。
        :type AssetName: str
        :param _NodeName: 资产所属的节点的名称。
        :type NodeName: str
        :param _HostName: 资产所在的主机的名称。
        :type HostName: str
        :param _HostIP: 资产所在的主机的IP。
        :type HostIP: str
        :param _CheckStatus: 检测状态
CHECK_INIT, 待检测
CHECK_RUNNING, 检测中
CHECK_FINISHED, 检测完成
CHECK_FAILED, 检测失败
        :type CheckStatus: str
        :param _PassedPolicyItemCount: 此类资产通过的检测项的数目。
        :type PassedPolicyItemCount: int
        :param _FailedPolicyItemCount: 此类资产未通过的检测的数目。
        :type FailedPolicyItemCount: int
        :param _LastCheckTime: 上次检测的时间。
注意：此字段可能返回 null，表示取不到有效值。
        :type LastCheckTime: str
        :param _CheckResult: 检测结果：
RESULT_FAILED: 未通过。
RESULT_PASSED: 通过。
注意：此字段可能返回 null，表示取不到有效值。
        :type CheckResult: str
        :param _AssetStatus: 资产的运行状态。
        :type AssetStatus: str
        :param _AssetCreateTime: 创建资产的时间。
ASSET_NORMAL: 正常运行，
ASSET_PAUSED: 暂停运行，
ASSET_STOPPED: 停止运行，
ASSET_ABNORMAL: 异常
        :type AssetCreateTime: str
        """
        self._CustomerAssetId = None
        self._AssetType = None
        self._AssetName = None
        self._NodeName = None
        self._HostName = None
        self._HostIP = None
        self._CheckStatus = None
        self._PassedPolicyItemCount = None
        self._FailedPolicyItemCount = None
        self._LastCheckTime = None
        self._CheckResult = None
        self._AssetStatus = None
        self._AssetCreateTime = None

    @property
    def CustomerAssetId(self):
        return self._CustomerAssetId

    @CustomerAssetId.setter
    def CustomerAssetId(self, CustomerAssetId):
        self._CustomerAssetId = CustomerAssetId

    @property
    def AssetType(self):
        return self._AssetType

    @AssetType.setter
    def AssetType(self, AssetType):
        self._AssetType = AssetType

    @property
    def AssetName(self):
        return self._AssetName

    @AssetName.setter
    def AssetName(self, AssetName):
        self._AssetName = AssetName

    @property
    def NodeName(self):
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def HostName(self):
        return self._HostName

    @HostName.setter
    def HostName(self, HostName):
        self._HostName = HostName

    @property
    def HostIP(self):
        return self._HostIP

    @HostIP.setter
    def HostIP(self, HostIP):
        self._HostIP = HostIP

    @property
    def CheckStatus(self):
        return self._CheckStatus

    @CheckStatus.setter
    def CheckStatus(self, CheckStatus):
        self._CheckStatus = CheckStatus

    @property
    def PassedPolicyItemCount(self):
        return self._PassedPolicyItemCount

    @PassedPolicyItemCount.setter
    def PassedPolicyItemCount(self, PassedPolicyItemCount):
        self._PassedPolicyItemCount = PassedPolicyItemCount

    @property
    def FailedPolicyItemCount(self):
        return self._FailedPolicyItemCount

    @FailedPolicyItemCount.setter
    def FailedPolicyItemCount(self, FailedPolicyItemCount):
        self._FailedPolicyItemCount = FailedPolicyItemCount

    @property
    def LastCheckTime(self):
        return self._LastCheckTime

    @LastCheckTime.setter
    def LastCheckTime(self, LastCheckTime):
        self._LastCheckTime = LastCheckTime

    @property
    def CheckResult(self):
        return self._CheckResult

    @CheckResult.setter
    def CheckResult(self, CheckResult):
        self._CheckResult = CheckResult

    @property
    def AssetStatus(self):
        return self._AssetStatus

    @AssetStatus.setter
    def AssetStatus(self, AssetStatus):
        self._AssetStatus = AssetStatus

    @property
    def AssetCreateTime(self):
        return self._AssetCreateTime

    @AssetCreateTime.setter
    def AssetCreateTime(self, AssetCreateTime):
        self._AssetCreateTime = AssetCreateTime


    def _deserialize(self, params):
        self._CustomerAssetId = params.get("CustomerAssetId")
        self._AssetType = params.get("AssetType")
        self._AssetName = params.get("AssetName")
        self._NodeName = params.get("NodeName")
        self._HostName = params.get("HostName")
        self._HostIP = params.get("HostIP")
        self._CheckStatus = params.get("CheckStatus")
        self._PassedPolicyItemCount = params.get("PassedPolicyItemCount")
        self._FailedPolicyItemCount = params.get("FailedPolicyItemCount")
        self._LastCheckTime = params.get("LastCheckTime")
        self._CheckResult = params.get("CheckResult")
        self._AssetStatus = params.get("AssetStatus")
        self._AssetCreateTime = params.get("AssetCreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceAssetInfo(AbstractModel):
    """表示一项资产的信息。

    """

    def __init__(self):
        r"""
        :param _CustomerAssetId: 客户资产的ID。
        :type CustomerAssetId: int
        :param _AssetType: 资产类别。
        :type AssetType: str
        :param _AssetName: 资产的名称。
        :type AssetName: str
        :param _ImageTag: 当资产为镜像时，这个字段为镜像Tag。
注意：此字段可能返回 null，表示取不到有效值。
        :type ImageTag: str
        :param _HostIP: 资产所在的主机IP。
        :type HostIP: str
        :param _NodeName: 资产所属的节点的名称
        :type NodeName: str
        :param _CheckStatus: 检测状态

CHECK_INIT, 待检测

CHECK_RUNNING, 检测中

CHECK_FINISHED, 检测完成

CHECK_FAILED, 检测失败
        :type CheckStatus: str
        :param _PassedPolicyItemCount: 此类资产通过的检测项的数目。
注意：此字段可能返回 null，表示取不到有效值。
        :type PassedPolicyItemCount: int
        :param _FailedPolicyItemCount: 此类资产未通过的检测的数目。
注意：此字段可能返回 null，表示取不到有效值。
        :type FailedPolicyItemCount: int
        :param _LastCheckTime: 上次检测的时间。
注意：此字段可能返回 null，表示取不到有效值。
        :type LastCheckTime: str
        :param _CheckResult: 检测结果：
RESULT_FAILED: 未通过。
RESULT_PASSED: 通过。
注意：此字段可能返回 null，表示取不到有效值。
        :type CheckResult: str
        :param _InstanceId: 主机节点的实例id
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceId: str
        """
        self._CustomerAssetId = None
        self._AssetType = None
        self._AssetName = None
        self._ImageTag = None
        self._HostIP = None
        self._NodeName = None
        self._CheckStatus = None
        self._PassedPolicyItemCount = None
        self._FailedPolicyItemCount = None
        self._LastCheckTime = None
        self._CheckResult = None
        self._InstanceId = None

    @property
    def CustomerAssetId(self):
        return self._CustomerAssetId

    @CustomerAssetId.setter
    def CustomerAssetId(self, CustomerAssetId):
        self._CustomerAssetId = CustomerAssetId

    @property
    def AssetType(self):
        return self._AssetType

    @AssetType.setter
    def AssetType(self, AssetType):
        self._AssetType = AssetType

    @property
    def AssetName(self):
        return self._AssetName

    @AssetName.setter
    def AssetName(self, AssetName):
        self._AssetName = AssetName

    @property
    def ImageTag(self):
        return self._ImageTag

    @ImageTag.setter
    def ImageTag(self, ImageTag):
        self._ImageTag = ImageTag

    @property
    def HostIP(self):
        return self._HostIP

    @HostIP.setter
    def HostIP(self, HostIP):
        self._HostIP = HostIP

    @property
    def NodeName(self):
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def CheckStatus(self):
        return self._CheckStatus

    @CheckStatus.setter
    def CheckStatus(self, CheckStatus):
        self._CheckStatus = CheckStatus

    @property
    def PassedPolicyItemCount(self):
        return self._PassedPolicyItemCount

    @PassedPolicyItemCount.setter
    def PassedPolicyItemCount(self, PassedPolicyItemCount):
        self._PassedPolicyItemCount = PassedPolicyItemCount

    @property
    def FailedPolicyItemCount(self):
        return self._FailedPolicyItemCount

    @FailedPolicyItemCount.setter
    def FailedPolicyItemCount(self, FailedPolicyItemCount):
        self._FailedPolicyItemCount = FailedPolicyItemCount

    @property
    def LastCheckTime(self):
        return self._LastCheckTime

    @LastCheckTime.setter
    def LastCheckTime(self, LastCheckTime):
        self._LastCheckTime = LastCheckTime

    @property
    def CheckResult(self):
        return self._CheckResult

    @CheckResult.setter
    def CheckResult(self, CheckResult):
        self._CheckResult = CheckResult

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._CustomerAssetId = params.get("CustomerAssetId")
        self._AssetType = params.get("AssetType")
        self._AssetName = params.get("AssetName")
        self._ImageTag = params.get("ImageTag")
        self._HostIP = params.get("HostIP")
        self._NodeName = params.get("NodeName")
        self._CheckStatus = params.get("CheckStatus")
        self._PassedPolicyItemCount = params.get("PassedPolicyItemCount")
        self._FailedPolicyItemCount = params.get("FailedPolicyItemCount")
        self._LastCheckTime = params.get("LastCheckTime")
        self._CheckResult = params.get("CheckResult")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceAssetPolicyItem(AbstractModel):
    """表示一条检测项的信息。

    """

    def __init__(self):
        r"""
        :param _CustomerPolicyItemId: 为客户分配的唯一的检测项的ID。
        :type CustomerPolicyItemId: int
        :param _BasePolicyItemId: 检测项的原始ID
        :type BasePolicyItemId: int
        :param _Name: 检测项的名称。
        :type Name: str
        :param _Category: 检测项所属的类型的名称
        :type Category: str
        :param _BenchmarkStandardId: 所属的合规标准的ID
        :type BenchmarkStandardId: int
        :param _BenchmarkStandardName: 所属的合规标准的名称
        :type BenchmarkStandardName: str
        :param _RiskLevel: 威胁等级
        :type RiskLevel: str
        :param _CheckStatus: 检测状态
CHECK_INIT, 待检测
CHECK_RUNNING, 检测中
CHECK_FINISHED, 检测完成
CHECK_FAILED, 检测失败
        :type CheckStatus: str
        :param _CheckResult: 检测结果
RESULT_PASSED: 通过
RESULT_FAILED: 未通过
注意：此字段可能返回 null，表示取不到有效值。
        :type CheckResult: str
        :param _WhitelistId: 检测项对应的白名单项的ID。如果存在且非0，表示检测项被用户忽略。
注意：此字段可能返回 null，表示取不到有效值。
        :type WhitelistId: int
        :param _FixSuggestion: 处理建议。
        :type FixSuggestion: str
        :param _LastCheckTime: 最近检测的时间。
注意：此字段可能返回 null，表示取不到有效值。
        :type LastCheckTime: str
        :param _VerifyInfo: 验证信息
注意：此字段可能返回 null，表示取不到有效值。
        :type VerifyInfo: str
        """
        self._CustomerPolicyItemId = None
        self._BasePolicyItemId = None
        self._Name = None
        self._Category = None
        self._BenchmarkStandardId = None
        self._BenchmarkStandardName = None
        self._RiskLevel = None
        self._CheckStatus = None
        self._CheckResult = None
        self._WhitelistId = None
        self._FixSuggestion = None
        self._LastCheckTime = None
        self._VerifyInfo = None

    @property
    def CustomerPolicyItemId(self):
        return self._CustomerPolicyItemId

    @CustomerPolicyItemId.setter
    def CustomerPolicyItemId(self, CustomerPolicyItemId):
        self._CustomerPolicyItemId = CustomerPolicyItemId

    @property
    def BasePolicyItemId(self):
        return self._BasePolicyItemId

    @BasePolicyItemId.setter
    def BasePolicyItemId(self, BasePolicyItemId):
        self._BasePolicyItemId = BasePolicyItemId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Category(self):
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def BenchmarkStandardId(self):
        return self._BenchmarkStandardId

    @BenchmarkStandardId.setter
    def BenchmarkStandardId(self, BenchmarkStandardId):
        self._BenchmarkStandardId = BenchmarkStandardId

    @property
    def BenchmarkStandardName(self):
        return self._BenchmarkStandardName

    @BenchmarkStandardName.setter
    def BenchmarkStandardName(self, BenchmarkStandardName):
        self._BenchmarkStandardName = BenchmarkStandardName

    @property
    def RiskLevel(self):
        return self._RiskLevel

    @RiskLevel.setter
    def RiskLevel(self, RiskLevel):
        self._RiskLevel = RiskLevel

    @property
    def CheckStatus(self):
        return self._CheckStatus

    @CheckStatus.setter
    def CheckStatus(self, CheckStatus):
        self._CheckStatus = CheckStatus

    @property
    def CheckResult(self):
        return self._CheckResult

    @CheckResult.setter
    def CheckResult(self, CheckResult):
        self._CheckResult = CheckResult

    @property
    def WhitelistId(self):
        return self._WhitelistId

    @WhitelistId.setter
    def WhitelistId(self, WhitelistId):
        self._WhitelistId = WhitelistId

    @property
    def FixSuggestion(self):
        return self._FixSuggestion

    @FixSuggestion.setter
    def FixSuggestion(self, FixSuggestion):
        self._FixSuggestion = FixSuggestion

    @property
    def LastCheckTime(self):
        return self._LastCheckTime

    @LastCheckTime.setter
    def LastCheckTime(self, LastCheckTime):
        self._LastCheckTime = LastCheckTime

    @property
    def VerifyInfo(self):
        return self._VerifyInfo

    @VerifyInfo.setter
    def VerifyInfo(self, VerifyInfo):
        self._VerifyInfo = VerifyInfo


    def _deserialize(self, params):
        self._CustomerPolicyItemId = params.get("CustomerPolicyItemId")
        self._BasePolicyItemId = params.get("BasePolicyItemId")
        self._Name = params.get("Name")
        self._Category = params.get("Category")
        self._BenchmarkStandardId = params.get("BenchmarkStandardId")
        self._BenchmarkStandardName = params.get("BenchmarkStandardName")
        self._RiskLevel = params.get("RiskLevel")
        self._CheckStatus = params.get("CheckStatus")
        self._CheckResult = params.get("CheckResult")
        self._WhitelistId = params.get("WhitelistId")
        self._FixSuggestion = params.get("FixSuggestion")
        self._LastCheckTime = params.get("LastCheckTime")
        self._VerifyInfo = params.get("VerifyInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceAssetPolicySetItem(AbstractModel):
    """资产+检查项ids 集合单元

    """

    def __init__(self):
        r"""
        :param _CustomerAssetItemId: 资产ID
        :type CustomerAssetItemId: int
        :param _CustomerPolicyItemIdSet: 需要忽略指定资产内的检查项ID列表，为空表示所有
        :type CustomerPolicyItemIdSet: list of int non-negative
        """
        self._CustomerAssetItemId = None
        self._CustomerPolicyItemIdSet = None

    @property
    def CustomerAssetItemId(self):
        return self._CustomerAssetItemId

    @CustomerAssetItemId.setter
    def CustomerAssetItemId(self, CustomerAssetItemId):
        self._CustomerAssetItemId = CustomerAssetItemId

    @property
    def CustomerPolicyItemIdSet(self):
        return self._CustomerPolicyItemIdSet

    @CustomerPolicyItemIdSet.setter
    def CustomerPolicyItemIdSet(self, CustomerPolicyItemIdSet):
        self._CustomerPolicyItemIdSet = CustomerPolicyItemIdSet


    def _deserialize(self, params):
        self._CustomerAssetItemId = params.get("CustomerAssetItemId")
        self._CustomerPolicyItemIdSet = params.get("CustomerPolicyItemIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceAssetSummary(AbstractModel):
    """表示一类资产的总览信息。

    """

    def __init__(self):
        r"""
        :param _AssetType: 资产类别。
        :type AssetType: str
        :param _IsCustomerFirstCheck: 是否为客户的首次检测。与CheckStatus配合使用。
        :type IsCustomerFirstCheck: bool
        :param _CheckStatus: 检测状态

CHECK_UNINIT, 用户未启用此功能

CHECK_INIT, 待检测

CHECK_RUNNING, 检测中

CHECK_FINISHED, 检测完成

CHECK_FAILED, 检测失败
        :type CheckStatus: str
        :param _CheckProgress: 此类别的检测进度，为 0~100 的数。若未在检测中，无此字段。
注意：此字段可能返回 null，表示取不到有效值。
        :type CheckProgress: float
        :param _PassedPolicyItemCount: 此类资产通过的检测项的数目。
        :type PassedPolicyItemCount: int
        :param _FailedPolicyItemCount: 此类资产未通过的检测的数目。
        :type FailedPolicyItemCount: int
        :param _FailedCriticalPolicyItemCount: 此类资产下未通过的严重级别的检测项的数目。
        :type FailedCriticalPolicyItemCount: int
        :param _FailedHighRiskPolicyItemCount: 此类资产下未通过的高危检测项的数目。
        :type FailedHighRiskPolicyItemCount: int
        :param _FailedMediumRiskPolicyItemCount: 此类资产下未通过的中危检测项的数目。
        :type FailedMediumRiskPolicyItemCount: int
        :param _FailedLowRiskPolicyItemCount: 此类资产下未通过的低危检测项的数目。
        :type FailedLowRiskPolicyItemCount: int
        :param _NoticePolicyItemCount: 此类资产下提示级别的检测项的数目。
        :type NoticePolicyItemCount: int
        :param _PassedAssetCount: 通过检测的资产的数目。
        :type PassedAssetCount: int
        :param _FailedAssetCount: 未通过检测的资产的数目。
        :type FailedAssetCount: int
        :param _AssetPassedRate: 此类资产的合规率，0~100的数。
        :type AssetPassedRate: float
        :param _ScanFailedAssetCount: 检测失败的资产的数目。
        :type ScanFailedAssetCount: int
        :param _CheckCostTime: 上次检测的耗时，单位为秒。
注意：此字段可能返回 null，表示取不到有效值。
        :type CheckCostTime: float
        :param _LastCheckTime: 上次检测的时间。
注意：此字段可能返回 null，表示取不到有效值。
        :type LastCheckTime: str
        :param _PeriodRule: 定时检测规则。
        :type PeriodRule: :class:`tencentcloud.tcss.v20201101.models.CompliancePeriodTaskRule`
        :param _OpenPolicyItemCount: 已开启的检查项总数
注意：此字段可能返回 null，表示取不到有效值。
        :type OpenPolicyItemCount: int
        :param _IgnoredPolicyItemCount: 已忽略的检查项总数
注意：此字段可能返回 null，表示取不到有效值。
        :type IgnoredPolicyItemCount: int
        """
        self._AssetType = None
        self._IsCustomerFirstCheck = None
        self._CheckStatus = None
        self._CheckProgress = None
        self._PassedPolicyItemCount = None
        self._FailedPolicyItemCount = None
        self._FailedCriticalPolicyItemCount = None
        self._FailedHighRiskPolicyItemCount = None
        self._FailedMediumRiskPolicyItemCount = None
        self._FailedLowRiskPolicyItemCount = None
        self._NoticePolicyItemCount = None
        self._PassedAssetCount = None
        self._FailedAssetCount = None
        self._AssetPassedRate = None
        self._ScanFailedAssetCount = None
        self._CheckCostTime = None
        self._LastCheckTime = None
        self._PeriodRule = None
        self._OpenPolicyItemCount = None
        self._IgnoredPolicyItemCount = None

    @property
    def AssetType(self):
        return self._AssetType

    @AssetType.setter
    def AssetType(self, AssetType):
        self._AssetType = AssetType

    @property
    def IsCustomerFirstCheck(self):
        return self._IsCustomerFirstCheck

    @IsCustomerFirstCheck.setter
    def IsCustomerFirstCheck(self, IsCustomerFirstCheck):
        self._IsCustomerFirstCheck = IsCustomerFirstCheck

    @property
    def CheckStatus(self):
        return self._CheckStatus

    @CheckStatus.setter
    def CheckStatus(self, CheckStatus):
        self._CheckStatus = CheckStatus

    @property
    def CheckProgress(self):
        return self._CheckProgress

    @CheckProgress.setter
    def CheckProgress(self, CheckProgress):
        self._CheckProgress = CheckProgress

    @property
    def PassedPolicyItemCount(self):
        return self._PassedPolicyItemCount

    @PassedPolicyItemCount.setter
    def PassedPolicyItemCount(self, PassedPolicyItemCount):
        self._PassedPolicyItemCount = PassedPolicyItemCount

    @property
    def FailedPolicyItemCount(self):
        return self._FailedPolicyItemCount

    @FailedPolicyItemCount.setter
    def FailedPolicyItemCount(self, FailedPolicyItemCount):
        self._FailedPolicyItemCount = FailedPolicyItemCount

    @property
    def FailedCriticalPolicyItemCount(self):
        return self._FailedCriticalPolicyItemCount

    @FailedCriticalPolicyItemCount.setter
    def FailedCriticalPolicyItemCount(self, FailedCriticalPolicyItemCount):
        self._FailedCriticalPolicyItemCount = FailedCriticalPolicyItemCount

    @property
    def FailedHighRiskPolicyItemCount(self):
        return self._FailedHighRiskPolicyItemCount

    @FailedHighRiskPolicyItemCount.setter
    def FailedHighRiskPolicyItemCount(self, FailedHighRiskPolicyItemCount):
        self._FailedHighRiskPolicyItemCount = FailedHighRiskPolicyItemCount

    @property
    def FailedMediumRiskPolicyItemCount(self):
        return self._FailedMediumRiskPolicyItemCount

    @FailedMediumRiskPolicyItemCount.setter
    def FailedMediumRiskPolicyItemCount(self, FailedMediumRiskPolicyItemCount):
        self._FailedMediumRiskPolicyItemCount = FailedMediumRiskPolicyItemCount

    @property
    def FailedLowRiskPolicyItemCount(self):
        return self._FailedLowRiskPolicyItemCount

    @FailedLowRiskPolicyItemCount.setter
    def FailedLowRiskPolicyItemCount(self, FailedLowRiskPolicyItemCount):
        self._FailedLowRiskPolicyItemCount = FailedLowRiskPolicyItemCount

    @property
    def NoticePolicyItemCount(self):
        return self._NoticePolicyItemCount

    @NoticePolicyItemCount.setter
    def NoticePolicyItemCount(self, NoticePolicyItemCount):
        self._NoticePolicyItemCount = NoticePolicyItemCount

    @property
    def PassedAssetCount(self):
        return self._PassedAssetCount

    @PassedAssetCount.setter
    def PassedAssetCount(self, PassedAssetCount):
        self._PassedAssetCount = PassedAssetCount

    @property
    def FailedAssetCount(self):
        return self._FailedAssetCount

    @FailedAssetCount.setter
    def FailedAssetCount(self, FailedAssetCount):
        self._FailedAssetCount = FailedAssetCount

    @property
    def AssetPassedRate(self):
        return self._AssetPassedRate

    @AssetPassedRate.setter
    def AssetPassedRate(self, AssetPassedRate):
        self._AssetPassedRate = AssetPassedRate

    @property
    def ScanFailedAssetCount(self):
        return self._ScanFailedAssetCount

    @ScanFailedAssetCount.setter
    def ScanFailedAssetCount(self, ScanFailedAssetCount):
        self._ScanFailedAssetCount = ScanFailedAssetCount

    @property
    def CheckCostTime(self):
        return self._CheckCostTime

    @CheckCostTime.setter
    def CheckCostTime(self, CheckCostTime):
        self._CheckCostTime = CheckCostTime

    @property
    def LastCheckTime(self):
        return self._LastCheckTime

    @LastCheckTime.setter
    def LastCheckTime(self, LastCheckTime):
        self._LastCheckTime = LastCheckTime

    @property
    def PeriodRule(self):
        return self._PeriodRule

    @PeriodRule.setter
    def PeriodRule(self, PeriodRule):
        self._PeriodRule = PeriodRule

    @property
    def OpenPolicyItemCount(self):
        return self._OpenPolicyItemCount

    @OpenPolicyItemCount.setter
    def OpenPolicyItemCount(self, OpenPolicyItemCount):
        self._OpenPolicyItemCount = OpenPolicyItemCount

    @property
    def IgnoredPolicyItemCount(self):
        return self._IgnoredPolicyItemCount

    @IgnoredPolicyItemCount.setter
    def IgnoredPolicyItemCount(self, IgnoredPolicyItemCount):
        self._IgnoredPolicyItemCount = IgnoredPolicyItemCount


    def _deserialize(self, params):
        self._AssetType = params.get("AssetType")
        self._IsCustomerFirstCheck = params.get("IsCustomerFirstCheck")
        self._CheckStatus = params.get("CheckStatus")
        self._CheckProgress = params.get("CheckProgress")
        self._PassedPolicyItemCount = params.get("PassedPolicyItemCount")
        self._FailedPolicyItemCount = params.get("FailedPolicyItemCount")
        self._FailedCriticalPolicyItemCount = params.get("FailedCriticalPolicyItemCount")
        self._FailedHighRiskPolicyItemCount = params.get("FailedHighRiskPolicyItemCount")
        self._FailedMediumRiskPolicyItemCount = params.get("FailedMediumRiskPolicyItemCount")
        self._FailedLowRiskPolicyItemCount = params.get("FailedLowRiskPolicyItemCount")
        self._NoticePolicyItemCount = params.get("NoticePolicyItemCount")
        self._PassedAssetCount = params.get("PassedAssetCount")
        self._FailedAssetCount = params.get("FailedAssetCount")
        self._AssetPassedRate = params.get("AssetPassedRate")
        self._ScanFailedAssetCount = params.get("ScanFailedAssetCount")
        self._CheckCostTime = params.get("CheckCostTime")
        self._LastCheckTime = params.get("LastCheckTime")
        if params.get("PeriodRule") is not None:
            self._PeriodRule = CompliancePeriodTaskRule()
            self._PeriodRule._deserialize(params.get("PeriodRule"))
        self._OpenPolicyItemCount = params.get("OpenPolicyItemCount")
        self._IgnoredPolicyItemCount = params.get("IgnoredPolicyItemCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceBenchmarkStandard(AbstractModel):
    """表示一个合规标准的信息。

    """

    def __init__(self):
        r"""
        :param _StandardId: 合规标准的ID
        :type StandardId: int
        :param _Name: 合规标准的名称
        :type Name: str
        :param _PolicyItemCount: 合规标准包含的数目
        :type PolicyItemCount: int
        :param _Enabled: 是否启用此标准
        :type Enabled: bool
        :param _Description: 标准的描述
        :type Description: str
        """
        self._StandardId = None
        self._Name = None
        self._PolicyItemCount = None
        self._Enabled = None
        self._Description = None

    @property
    def StandardId(self):
        return self._StandardId

    @StandardId.setter
    def StandardId(self, StandardId):
        self._StandardId = StandardId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def PolicyItemCount(self):
        return self._PolicyItemCount

    @PolicyItemCount.setter
    def PolicyItemCount(self, PolicyItemCount):
        self._PolicyItemCount = PolicyItemCount

    @property
    def Enabled(self):
        return self._Enabled

    @Enabled.setter
    def Enabled(self, Enabled):
        self._Enabled = Enabled

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._StandardId = params.get("StandardId")
        self._Name = params.get("Name")
        self._PolicyItemCount = params.get("PolicyItemCount")
        self._Enabled = params.get("Enabled")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceBenchmarkStandardEnable(AbstractModel):
    """表示是否启用合规标准。

    """

    def __init__(self):
        r"""
        :param _StandardId: 合规标准的ID。
        :type StandardId: int
        :param _Enable: 是否启用合规标准
        :type Enable: bool
        """
        self._StandardId = None
        self._Enable = None

    @property
    def StandardId(self):
        return self._StandardId

    @StandardId.setter
    def StandardId(self, StandardId):
        self._StandardId = StandardId

    @property
    def Enable(self):
        return self._Enable

    @Enable.setter
    def Enable(self, Enable):
        self._Enable = Enable


    def _deserialize(self, params):
        self._StandardId = params.get("StandardId")
        self._Enable = params.get("Enable")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceContainerDetailInfo(AbstractModel):
    """表示容器资产专属的详情。

    """

    def __init__(self):
        r"""
        :param _ContainerId: 容器在主机上的ID。
        :type ContainerId: str
        :param _PodName: 容器所属的Pod的名称。
注意：此字段可能返回 null，表示取不到有效值。
        :type PodName: str
        """
        self._ContainerId = None
        self._PodName = None

    @property
    def ContainerId(self):
        return self._ContainerId

    @ContainerId.setter
    def ContainerId(self, ContainerId):
        self._ContainerId = ContainerId

    @property
    def PodName(self):
        return self._PodName

    @PodName.setter
    def PodName(self, PodName):
        self._PodName = PodName


    def _deserialize(self, params):
        self._ContainerId = params.get("ContainerId")
        self._PodName = params.get("PodName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceFilters(AbstractModel):
    """键值对过滤器，用于条件过滤查询。例如过滤ID、名称、状态等 若存在多个Filter时，Filter间的关系为逻辑与（AND）关系。 若同一个Filter存在多个Values，同一Filter下Values间的关系为逻辑或（OR）关系。

    """

    def __init__(self):
        r"""
        :param _Name: 过滤键的名称
        :type Name: str
        :param _Values: 一个或者多个过滤值。
        :type Values: list of str
        :param _ExactMatch: 是否模糊查询。默认为是。
        :type ExactMatch: bool
        """
        self._Name = None
        self._Values = None
        self._ExactMatch = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values

    @property
    def ExactMatch(self):
        return self._ExactMatch

    @ExactMatch.setter
    def ExactMatch(self, ExactMatch):
        self._ExactMatch = ExactMatch


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        self._ExactMatch = params.get("ExactMatch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceHostDetailInfo(AbstractModel):
    """表示主机资产专属的详情。

    """

    def __init__(self):
        r"""
        :param _DockerVersion: 主机上的Docker版本。
注意：此字段可能返回 null，表示取不到有效值。
        :type DockerVersion: str
        :param _K8SVersion: 主机上的K8S的版本。
注意：此字段可能返回 null，表示取不到有效值。
        :type K8SVersion: str
        :param _ContainerdVersion: 主机上Containerd版本
注意：此字段可能返回 null，表示取不到有效值。
        :type ContainerdVersion: str
        """
        self._DockerVersion = None
        self._K8SVersion = None
        self._ContainerdVersion = None

    @property
    def DockerVersion(self):
        return self._DockerVersion

    @DockerVersion.setter
    def DockerVersion(self, DockerVersion):
        self._DockerVersion = DockerVersion

    @property
    def K8SVersion(self):
        return self._K8SVersion

    @K8SVersion.setter
    def K8SVersion(self, K8SVersion):
        self._K8SVersion = K8SVersion

    @property
    def ContainerdVersion(self):
        return self._ContainerdVersion

    @ContainerdVersion.setter
    def ContainerdVersion(self, ContainerdVersion):
        self._ContainerdVersion = ContainerdVersion


    def _deserialize(self, params):
        self._DockerVersion = params.get("DockerVersion")
        self._K8SVersion = params.get("K8SVersion")
        self._ContainerdVersion = params.get("ContainerdVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceImageDetailInfo(AbstractModel):
    """表示镜像资产专属的详情。

    """

    def __init__(self):
        r"""
        :param _ImageId: 镜像在主机上的ID。
        :type ImageId: str
        :param _ImageName: 镜像的名称。
        :type ImageName: str
        :param _ImageTag: 镜像的Tag。
        :type ImageTag: str
        :param _Repository: 镜像所在远程仓库的路径。
注意：此字段可能返回 null，表示取不到有效值。
        :type Repository: str
        """
        self._ImageId = None
        self._ImageName = None
        self._ImageTag = None
        self._Repository = None

    @property
    def ImageId(self):
        return self._ImageId

    @ImageId.setter
    def ImageId(self, ImageId):
        self._ImageId = ImageId

    @property
    def ImageName(self):
        return self._ImageName

    @ImageName.setter
    def ImageName(self, ImageName):
        self._ImageName = ImageName

    @property
    def ImageTag(self):
        return self._ImageTag

    @ImageTag.setter
    def ImageTag(self, ImageTag):
        self._ImageTag = ImageTag

    @property
    def Repository(self):
        return self._Repository

    @Repository.setter
    def Repository(self, Repository):
        self._Repository = Repository


    def _deserialize(self, params):
        self._ImageId = params.get("ImageId")
        self._ImageName = params.get("ImageName")
        self._ImageTag = params.get("ImageTag")
        self._Repository = params.get("Repository")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceK8SDetailInfo(AbstractModel):
    """表示K8S资产专属的详情。

    """

    def __init__(self):
        r"""
        :param _ClusterName: K8S集群的名称。
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterName: str
        :param _ClusterVersion: K8S集群的版本。
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterVersion: str
        """
        self._ClusterName = None
        self._ClusterVersion = None

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def ClusterVersion(self):
        return self._ClusterVersion

    @ClusterVersion.setter
    def ClusterVersion(self, ClusterVersion):
        self._ClusterVersion = ClusterVersion


    def _deserialize(self, params):
        self._ClusterName = params.get("ClusterName")
        self._ClusterVersion = params.get("ClusterVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompliancePeriodTask(AbstractModel):
    """表示一个合规基线检测定时任务的信息。

    """

    def __init__(self):
        r"""
        :param _PeriodTaskId: 周期任务的ID
        :type PeriodTaskId: int
        :param _AssetType: 资产类型。
ASSET_CONTAINER, 容器
ASSET_IMAGE, 镜像
ASSET_HOST, 主机
ASSET_K8S, K8S资产
        :type AssetType: str
        :param _LastTriggerTime: 最近一次触发的时间
注意：此字段可能返回 null，表示取不到有效值。
        :type LastTriggerTime: str
        :param _TotalPolicyItemCount: 总的检查项数目
        :type TotalPolicyItemCount: int
        :param _PeriodRule: 周期设置
        :type PeriodRule: :class:`tencentcloud.tcss.v20201101.models.CompliancePeriodTaskRule`
        :param _BenchmarkStandardSet: 合规标准列表
        :type BenchmarkStandardSet: list of ComplianceBenchmarkStandard
        """
        self._PeriodTaskId = None
        self._AssetType = None
        self._LastTriggerTime = None
        self._TotalPolicyItemCount = None
        self._PeriodRule = None
        self._BenchmarkStandardSet = None

    @property
    def PeriodTaskId(self):
        return self._PeriodTaskId

    @PeriodTaskId.setter
    def PeriodTaskId(self, PeriodTaskId):
        self._PeriodTaskId = PeriodTaskId

    @property
    def AssetType(self):
        return self._AssetType

    @AssetType.setter
    def AssetType(self, AssetType):
        self._AssetType = AssetType

    @property
    def LastTriggerTime(self):
        return self._LastTriggerTime

    @LastTriggerTime.setter
    def LastTriggerTime(self, LastTriggerTime):
        self._LastTriggerTime = LastTriggerTime

    @property
    def TotalPolicyItemCount(self):
        return self._TotalPolicyItemCount

    @TotalPolicyItemCount.setter
    def TotalPolicyItemCount(self, TotalPolicyItemCount):
        self._TotalPolicyItemCount = TotalPolicyItemCount

    @property
    def PeriodRule(self):
        return self._PeriodRule

    @PeriodRule.setter
    def PeriodRule(self, PeriodRule):
        self._PeriodRule = PeriodRule

    @property
    def BenchmarkStandardSet(self):
        return self._BenchmarkStandardSet

    @BenchmarkStandardSet.setter
    def BenchmarkStandardSet(self, BenchmarkStandardSet):
        self._BenchmarkStandardSet = BenchmarkStandardSet


    def _deserialize(self, params):
        self._PeriodTaskId = params.get("PeriodTaskId")
        self._AssetType = params.get("AssetType")
        self._LastTriggerTime = params.get("LastTriggerTime")
        self._TotalPolicyItemCount = params.get("TotalPolicyItemCount")
        if params.get("PeriodRule") is not None:
            self._PeriodRule = CompliancePeriodTaskRule()
            self._PeriodRule._deserialize(params.get("PeriodRule"))
        if params.get("BenchmarkStandardSet") is not None:
            self._BenchmarkStandardSet = []
            for item in params.get("BenchmarkStandardSet"):
                obj = ComplianceBenchmarkStandard()
                obj._deserialize(item)
                self._BenchmarkStandardSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompliancePeriodTaskRule(AbstractModel):
    """表示一个定时任务的周期设置

    """

    def __init__(self):
        r"""
        :param _Frequency: 执行的频率（几天一次），取值为：1,3,7。
        :type Frequency: int
        :param _ExecutionTime: 在这天的什么时间执行，格式为：HH:mm:SS。
        :type ExecutionTime: str
        :param _Enable: 是否开启
注意：此字段可能返回 null，表示取不到有效值。
        :type Enable: bool
        """
        self._Frequency = None
        self._ExecutionTime = None
        self._Enable = None

    @property
    def Frequency(self):
        return self._Frequency

    @Frequency.setter
    def Frequency(self, Frequency):
        self._Frequency = Frequency

    @property
    def ExecutionTime(self):
        return self._ExecutionTime

    @ExecutionTime.setter
    def ExecutionTime(self, ExecutionTime):
        self._ExecutionTime = ExecutionTime

    @property
    def Enable(self):
        return self._Enable

    @Enable.setter
    def Enable(self, Enable):
        self._Enable = Enable


    def _deserialize(self, params):
        self._Frequency = params.get("Frequency")
        self._ExecutionTime = params.get("ExecutionTime")
        self._Enable = params.get("Enable")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompliancePolicyAssetSetItem(AbstractModel):
    """检查项+资产ids 的集合单元

    """

    def __init__(self):
        r"""
        :param _CustomerPolicyItemId: 检查项ID
        :type CustomerPolicyItemId: int
        :param _CustomerAssetItemIdSet: 需要忽略指定检查项内的资产ID列表，为空表示所有
        :type CustomerAssetItemIdSet: list of int non-negative
        """
        self._CustomerPolicyItemId = None
        self._CustomerAssetItemIdSet = None

    @property
    def CustomerPolicyItemId(self):
        return self._CustomerPolicyItemId

    @CustomerPolicyItemId.setter
    def CustomerPolicyItemId(self, CustomerPolicyItemId):
        self._CustomerPolicyItemId = CustomerPolicyItemId

    @property
    def CustomerAssetItemIdSet(self):
        return self._CustomerAssetItemIdSet

    @CustomerAssetItemIdSet.setter
    def CustomerAssetItemIdSet(self, CustomerAssetItemIdSet):
        self._CustomerAssetItemIdSet = CustomerAssetItemIdSet


    def _deserialize(self, params):
        self._CustomerPolicyItemId = params.get("CustomerPolicyItemId")
        self._CustomerAssetItemIdSet = params.get("CustomerAssetItemIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompliancePolicyItemSummary(AbstractModel):
    """表示一条检测项对应的汇总信息。

    """

    def __init__(self):
        r"""
        :param _CustomerPolicyItemId: 为客户分配的唯一的检测项的ID。
        :type CustomerPolicyItemId: int
        :param _BasePolicyItemId: 检测项的原始ID。
        :type BasePolicyItemId: int
        :param _Name: 检测项的名称。
        :type Name: str
        :param _Category: 检测项所属的类型，枚举字符串。
        :type Category: str
        :param _BenchmarkStandardName: 所属的合规标准
        :type BenchmarkStandardName: str
        :param _RiskLevel: 威胁等级。RISK_CRITICAL, RISK_HIGH, RISK_MEDIUM, RISK_LOW, RISK_NOTICE。
        :type RiskLevel: str
        :param _AssetType: 检测项所属的资产类型
        :type AssetType: str
        :param _LastCheckTime: 最近检测的时间
注意：此字段可能返回 null，表示取不到有效值。
        :type LastCheckTime: str
        :param _CheckStatus: 检测状态

CHECK_INIT, 待检测

CHECK_RUNNING, 检测中

CHECK_FINISHED, 检测完成

CHECK_FAILED, 检测失败
        :type CheckStatus: str
        :param _CheckResult: 检测结果。RESULT_PASSED: 通过

RESULT_FAILED: 未通过
注意：此字段可能返回 null，表示取不到有效值。
        :type CheckResult: str
        :param _PassedAssetCount: 通过检测的资产的数目
注意：此字段可能返回 null，表示取不到有效值。
        :type PassedAssetCount: int
        :param _FailedAssetCount: 未通过检测的资产的数目
注意：此字段可能返回 null，表示取不到有效值。
        :type FailedAssetCount: int
        :param _WhitelistId: 检测项对应的白名单项的ID。如果存在且非0，表示检测项被用户忽略。
注意：此字段可能返回 null，表示取不到有效值。
        :type WhitelistId: int
        :param _FixSuggestion: 处理建议。
        :type FixSuggestion: str
        :param _BenchmarkStandardId: 所属的合规标准的ID
        :type BenchmarkStandardId: int
        :param _ApplicableVersion: 检测项适用的版本
注意：此字段可能返回 null，表示取不到有效值。
        :type ApplicableVersion: str
        :param _Description: 检查项描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _AuditProcedure: 检查项审计方法
注意：此字段可能返回 null，表示取不到有效值。
        :type AuditProcedure: str
        """
        self._CustomerPolicyItemId = None
        self._BasePolicyItemId = None
        self._Name = None
        self._Category = None
        self._BenchmarkStandardName = None
        self._RiskLevel = None
        self._AssetType = None
        self._LastCheckTime = None
        self._CheckStatus = None
        self._CheckResult = None
        self._PassedAssetCount = None
        self._FailedAssetCount = None
        self._WhitelistId = None
        self._FixSuggestion = None
        self._BenchmarkStandardId = None
        self._ApplicableVersion = None
        self._Description = None
        self._AuditProcedure = None

    @property
    def CustomerPolicyItemId(self):
        return self._CustomerPolicyItemId

    @CustomerPolicyItemId.setter
    def CustomerPolicyItemId(self, CustomerPolicyItemId):
        self._CustomerPolicyItemId = CustomerPolicyItemId

    @property
    def BasePolicyItemId(self):
        return self._BasePolicyItemId

    @BasePolicyItemId.setter
    def BasePolicyItemId(self, BasePolicyItemId):
        self._BasePolicyItemId = BasePolicyItemId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Category(self):
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def BenchmarkStandardName(self):
        return self._BenchmarkStandardName

    @BenchmarkStandardName.setter
    def BenchmarkStandardName(self, BenchmarkStandardName):
        self._BenchmarkStandardName = BenchmarkStandardName

    @property
    def RiskLevel(self):
        return self._RiskLevel

    @RiskLevel.setter
    def RiskLevel(self, RiskLevel):
        self._RiskLevel = RiskLevel

    @property
    def AssetType(self):
        return self._AssetType

    @AssetType.setter
    def AssetType(self, AssetType):
        self._AssetType = AssetType

    @property
    def LastCheckTime(self):
        return self._LastCheckTime

    @LastCheckTime.setter
    def LastCheckTime(self, LastCheckTime):
        self._LastCheckTime = LastCheckTime

    @property
    def CheckStatus(self):
        return self._CheckStatus

    @CheckStatus.setter
    def CheckStatus(self, CheckStatus):
        self._CheckStatus = CheckStatus

    @property
    def CheckResult(self):
        return self._CheckResult

    @CheckResult.setter
    def CheckResult(self, CheckResult):
        self._CheckResult = CheckResult

    @property
    def PassedAssetCount(self):
        return self._PassedAssetCount

    @PassedAssetCount.setter
    def PassedAssetCount(self, PassedAssetCount):
        self._PassedAssetCount = PassedAssetCount

    @property
    def FailedAssetCount(self):
        return self._FailedAssetCount

    @FailedAssetCount.setter
    def FailedAssetCount(self, FailedAssetCount):
        self._FailedAssetCount = FailedAssetCount

    @property
    def WhitelistId(self):
        return self._WhitelistId

    @WhitelistId.setter
    def WhitelistId(self, WhitelistId):
        self._WhitelistId = WhitelistId

    @property
    def FixSuggestion(self):
        return self._FixSuggestion

    @FixSuggestion.setter
    def FixSuggestion(self, FixSuggestion):
        self._FixSuggestion = FixSuggestion

    @property
    def BenchmarkStandardId(self):
        return self._BenchmarkStandardId

    @BenchmarkStandardId.setter
    def BenchmarkStandardId(self, BenchmarkStandardId):
        self._BenchmarkStandardId = BenchmarkStandardId

    @property
    def ApplicableVersion(self):
        return self._ApplicableVersion

    @ApplicableVersion.setter
    def ApplicableVersion(self, ApplicableVersion):
        self._ApplicableVersion = ApplicableVersion

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def AuditProcedure(self):
        return self._AuditProcedure

    @AuditProcedure.setter
    def AuditProcedure(self, AuditProcedure):
        self._AuditProcedure = AuditProcedure


    def _deserialize(self, params):
        self._CustomerPolicyItemId = params.get("CustomerPolicyItemId")
        self._BasePolicyItemId = params.get("BasePolicyItemId")
        self._Name = params.get("Name")
        self._Category = params.get("Category")
        self._BenchmarkStandardName = params.get("BenchmarkStandardName")
        self._RiskLevel = params.get("RiskLevel")
        self._AssetType = params.get("AssetType")
        self._LastCheckTime = params.get("LastCheckTime")
        self._CheckStatus = params.get("CheckStatus")
        self._CheckResult = params.get("CheckResult")
        self._PassedAssetCount = params.get("PassedAssetCount")
        self._FailedAssetCount = params.get("FailedAssetCount")
        self._WhitelistId = params.get("WhitelistId")
        self._FixSuggestion = params.get("FixSuggestion")
        self._BenchmarkStandardId = params.get("BenchmarkStandardId")
        self._ApplicableVersion = params.get("ApplicableVersion")
        self._Description = params.get("Description")
        self._AuditProcedure = params.get("AuditProcedure")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceScanFailedAsset(AbstractModel):
    """表示检测失败的资产的信息。

    """

    def __init__(self):
        r"""
        :param _CustomerAssetId: 客户资产的ID。
        :type CustomerAssetId: int
        :param _AssetType: 资产类别。
        :type AssetType: str
        :param _CheckStatus: 检测状态
CHECK_INIT, 待检测
CHECK_RUNNING, 检测中
CHECK_FINISHED, 检测完成
CHECK_FAILED, 检测失败
        :type CheckStatus: str
        :param _AssetName: 资产的名称。
        :type AssetName: str
        :param _FailureReason: 资产检测失败的原因。
        :type FailureReason: str
        :param _Suggestion: 检测失败的处理建议。
        :type Suggestion: str
        :param _CheckTime: 检测的时间。
        :type CheckTime: str
        """
        self._CustomerAssetId = None
        self._AssetType = None
        self._CheckStatus = None
        self._AssetName = None
        self._FailureReason = None
        self._Suggestion = None
        self._CheckTime = None

    @property
    def CustomerAssetId(self):
        return self._CustomerAssetId

    @CustomerAssetId.setter
    def CustomerAssetId(self, CustomerAssetId):
        self._CustomerAssetId = CustomerAssetId

    @property
    def AssetType(self):
        return self._AssetType

    @AssetType.setter
    def AssetType(self, AssetType):
        self._AssetType = AssetType

    @property
    def CheckStatus(self):
        return self._CheckStatus

    @CheckStatus.setter
    def CheckStatus(self, CheckStatus):
        self._CheckStatus = CheckStatus

    @property
    def AssetName(self):
        return self._AssetName

    @AssetName.setter
    def AssetName(self, AssetName):
        self._AssetName = AssetName

    @property
    def FailureReason(self):
        return self._FailureReason

    @FailureReason.setter
    def FailureReason(self, FailureReason):
        self._FailureReason = FailureReason

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def CheckTime(self):
        return self._CheckTime

    @CheckTime.setter
    def CheckTime(self, CheckTime):
        self._CheckTime = CheckTime


    def _deserialize(self, params):
        self._CustomerAssetId = params.get("CustomerAssetId")
        self._AssetType = params.get("AssetType")
        self._CheckStatus = params.get("CheckStatus")
        self._AssetName = params.get("AssetName")
        self._FailureReason = params.get("FailureReason")
        self._Suggestion = params.get("Suggestion")
        self._CheckTime = params.get("CheckTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceWhitelistItem(AbstractModel):
    """表示一条白名单记录。

    """

    def __init__(self):
        r"""
        :param _WhitelistItemId: 白名单项的ID。
        :type WhitelistItemId: int
        :param _CustomerPolicyItemId: 客户检测项的ID。
        :type CustomerPolicyItemId: int
        :param _Name: 检测项的名称。
        :type Name: str
        :param _StandardName: 合规标准的名称。
        :type StandardName: str
        :param _StandardId: 合规标准的ID。
        :type StandardId: int
        :param _AffectedAssetCount: 检测项影响的资产的数目。
        :type AffectedAssetCount: int
        :param _LastUpdateTime: 最后更新的时间
        :type LastUpdateTime: str
        :param _InsertTime: 加入到白名单的时间
        :type InsertTime: str
        """
        self._WhitelistItemId = None
        self._CustomerPolicyItemId = None
        self._Name = None
        self._StandardName = None
        self._StandardId = None
        self._AffectedAssetCount = None
        self._LastUpdateTime = None
        self._InsertTime = None

    @property
    def WhitelistItemId(self):
        return self._WhitelistItemId

    @WhitelistItemId.setter
    def WhitelistItemId(self, WhitelistItemId):
        self._WhitelistItemId = WhitelistItemId

    @property
    def CustomerPolicyItemId(self):
        return self._CustomerPolicyItemId

    @CustomerPolicyItemId.setter
    def CustomerPolicyItemId(self, CustomerPolicyItemId):
        self._CustomerPolicyItemId = CustomerPolicyItemId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def StandardName(self):
        return self._StandardName

    @StandardName.setter
    def StandardName(self, StandardName):
        self._StandardName = StandardName

    @property
    def StandardId(self):
        return self._StandardId

    @StandardId.setter
    def StandardId(self, StandardId):
        self._StandardId = StandardId

    @property
    def AffectedAssetCount(self):
        return self._AffectedAssetCount

    @AffectedAssetCount.setter
    def AffectedAssetCount(self, AffectedAssetCount):
        self._AffectedAssetCount = AffectedAssetCount

    @property
    def LastUpdateTime(self):
        return self._LastUpdateTime

    @LastUpdateTime.setter
    def LastUpdateTime(self, LastUpdateTime):
        self._LastUpdateTime = LastUpdateTime

    @property
    def InsertTime(self):
        return self._InsertTime

    @InsertTime.setter
    def InsertTime(self, InsertTime):
        self._InsertTime = InsertTime


    def _deserialize(self, params):
        self._WhitelistItemId = params.get("WhitelistItemId")
        self._CustomerPolicyItemId = params.get("CustomerPolicyItemId")
        self._Name = params.get("Name")
        self._StandardName = params.get("StandardName")
        self._StandardId = params.get("StandardId")
        self._AffectedAssetCount = params.get("AffectedAssetCount")
        self._LastUpdateTime = params.get("LastUpdateTime")
        self._InsertTime = params.get("InsertTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComponentInfo(AbstractModel):
    """容器组件信息

    """

    def __init__(self):
        r"""
        :param _Name: 名称
        :type Name: str
        :param _Version: 版本
        :type Version: str
        """
        self._Name = None
        self._Version = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Version = params.get("Version")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComponentsInfo(AbstractModel):
    """组件信息

    """

    def __init__(self):
        r"""
        :param _Component: 组件名称
注意：此字段可能返回 null，表示取不到有效值。
        :type Component: str
        :param _Version: 组件版本信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Version: str
        :param _FixedVersion: 可修复版本
注意：此字段可能返回 null，表示取不到有效值。
        :type FixedVersion: str
        :param _Path: 路径
注意：此字段可能返回 null，表示取不到有效值。
        :type Path: str
        :param _Type: 类型
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        :param _Name: 组件名称
注意：此字段可能返回 null，表示取不到有效值。
        :type Name: str
        """
        self._Component = None
        self._Version = None
        self._FixedVersion = None
        self._Path = None
        self._Type = None
        self._Name = None

    @property
    def Component(self):
        warnings.warn("parameter `Component` is deprecated", DeprecationWarning) 

        return self._Component

    @Component.setter
    def Component(self, Component):
        warnings.warn("parameter `Component` is deprecated", DeprecationWarning) 

        self._Component = Component

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def FixedVersion(self):
        return self._FixedVersion

    @FixedVersion.setter
    def FixedVersion(self, FixedVersion):
        self._FixedVersion = FixedVersion

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Component = params.get("Component")
        self._Version = params.get("Version")
        self._FixedVersion = params.get("FixedVersion")
        self._Path = params.get("Path")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConfirmNetworkFirewallPolicyRequest(AbstractModel):
    """ConfirmNetworkFirewallPolicy请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群Id
        :type ClusterId: str
        :param _Id: 策略Id数组
        :type Id: list of int non-negative
        """
        self._ClusterId = None
        self._Id = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConfirmNetworkFirewallPolicyResponse(AbstractModel):
    """ConfirmNetworkFirewallPolicy返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 返回创建的任务的ID，为0表示创建失败。
        :type TaskId: int
        :param _Result: 创建确认任务的结果，"Succ"为成功，"Failed"为失败
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._Result = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class ConnDetectConfig(AbstractModel):
    """联通性检测配置

    """

    def __init__(self):
        r"""
        :param _Quuid: 主机quuid
        :type Quuid: str
        :param _Uuid: 主机uuid
        :type Uuid: str
        """
        self._Quuid = None
        self._Uuid = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContainerInfo(AbstractModel):
    """容器列表集合

    """

    def __init__(self):
        r"""
        :param _ContainerID: 容器id
        :type ContainerID: str
        :param _ContainerName: 容器名称
        :type ContainerName: str
        :param _Status: 容器运行状态
        :type Status: str
        :param _CreateTime: 创建时间
        :type CreateTime: str
        :param _RunAs: 运行用户
        :type RunAs: str
        :param _Cmd: 命令行
        :type Cmd: str
        :param _CPUUsage: CPU使用率 *1000
        :type CPUUsage: int
        :param _RamUsage: 内存使用 kb
        :type RamUsage: int
        :param _ImageName: 镜像名称
        :type ImageName: str
        :param _ImageID: 镜像id
        :type ImageID: str
        :param _POD: 镜像id
        :type POD: str
        :param _HostID: 主机id
        :type HostID: str
        :param _HostIP: 主机ip
        :type HostIP: str
        :param _UpdateTime: 更新时间
        :type UpdateTime: str
        :param _HostName: 主机名称
        :type HostName: str
        :param _PublicIp: 外网ip
        :type PublicIp: str
        :param _NetStatus: 网络状态
未隔离  	NORMAL
已隔离		ISOLATED
隔离中		ISOLATING
隔离失败	ISOLATE_FAILED
解除隔离中  RESTORING
解除隔离失败 RESTORE_FAILED
        :type NetStatus: str
        :param _NetSubStatus: 网络子状态
        :type NetSubStatus: str
        :param _IsolateSource: 隔离来源
注意：此字段可能返回 null，表示取不到有效值。
        :type IsolateSource: str
        :param _IsolateTime: 隔离时间
注意：此字段可能返回 null，表示取不到有效值。
        :type IsolateTime: str
        :param _NodeID: 超级节点id
        :type NodeID: str
        :param _PodIP: podip
        :type PodIP: str
        :param _PodName: pod名称
        :type PodName: str
        :param _NodeType: 节点类型:节点类型：NORMAL普通节点、SUPER超级节点
        :type NodeType: str
        :param _NodeUniqueID: 超级节点唯一id
        :type NodeUniqueID: str
        :param _PodCpu: 所属Pod的CPU
        :type PodCpu: int
        :param _PodMem: 所属Pod的内存
        :type PodMem: int
        :param _ClusterName: 集群名称
        :type ClusterName: str
        :param _ClusterID: 集群ID
        :type ClusterID: str
        :param _PodUid: pod uid
注意：此字段可能返回 null，表示取不到有效值。
        :type PodUid: str
        """
        self._ContainerID = None
        self._ContainerName = None
        self._Status = None
        self._CreateTime = None
        self._RunAs = None
        self._Cmd = None
        self._CPUUsage = None
        self._RamUsage = None
        self._ImageName = None
        self._ImageID = None
        self._POD = None
        self._HostID = None
        self._HostIP = None
        self._UpdateTime = None
        self._HostName = None
        self._PublicIp = None
        self._NetStatus = None
        self._NetSubStatus = None
        self._IsolateSource = None
        self._IsolateTime = None
        self._NodeID = None
        self._PodIP = None
        self._PodName = None
        self._NodeType = None
        self._NodeUniqueID = None
        self._PodCpu = None
        self._PodMem = None
        self._ClusterName = None
        self._ClusterID = None
        self._PodUid = None

    @property
    def ContainerID(self):
        return self._ContainerID

    @ContainerID.setter
    def ContainerID(self, ContainerID):
        self._ContainerID = ContainerID

    @property
    def ContainerName(self):
        return self._ContainerName

    @ContainerName.setter
    def ContainerName(self, ContainerName):
        self._ContainerName = ContainerName

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def RunAs(self):
        return self._RunAs

    @RunAs.setter
    def RunAs(self, RunAs):
        self._RunAs = RunAs

    @property
    def Cmd(self):
        return self._Cmd

    @Cmd.setter
    def Cmd(self, Cmd):
        self._Cmd = Cmd

    @property
    def CPUUsage(self):
        return self._CPUUsage

    @CPUUsage.setter
    def CPUUsage(self, CPUUsage):
        self._CPUUsage = CPUUsage

    @property
    def RamUsage(self):
        return self._RamUsage

    @RamUsage.setter
    def RamUsage(self, RamUsage):
        self._RamUsage = RamUsage

    @property
    def ImageName(self):
        return self._ImageName

    @ImageName.setter
    def ImageName(self, ImageName):
        self._ImageName = ImageName

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def POD(self):
        return self._POD

    @POD.setter
    def POD(self, POD):
        self._POD = POD

    @property
    def HostID(self):
        return self._HostID

    @HostID.setter
    def HostID(self, HostID):
        self._HostID = HostID

    @property
    def HostIP(self):
        return self._HostIP

    @HostIP.setter
    def HostIP(self, HostIP):
        self._HostIP = HostIP

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def HostName(self):
        return self._HostName

    @HostName.setter
    def HostName(self, HostName):
        self._HostName = HostName

    @property
    def PublicIp(self):
        return self._PublicIp

    @PublicIp.setter
    def PublicIp(self, PublicIp):
        self._PublicIp = PublicIp

    @property
    def NetStatus(self):
        return self._NetStatus

    @NetStatus.setter
    def NetStatus(self, NetStatus):
        self._NetStatus = NetStatus

    @property
    def NetSubStatus(self):
        return self._NetSubStatus

    @NetSubStatus.setter
    def NetSubStatus(self, NetSubStatus):
        self._NetSubStatus = NetSubStatus

    @property
    def IsolateSource(self):
        return self._IsolateSource

    @IsolateSource.setter
    def IsolateSource(self, IsolateSource):
        self._IsolateSource = IsolateSource

    @property
    def IsolateTime(self):
        return self._IsolateTime

    @IsolateTime.setter
    def IsolateTime(self, IsolateTime):
        self._IsolateTime = IsolateTime

    @property
    def NodeID(self):
        return self._NodeID

    @NodeID.setter
    def NodeID(self, NodeID):
        self._NodeID = NodeID

    @property
    def PodIP(self):
        return self._PodIP

    @PodIP.setter
    def PodIP(self, PodIP):
        self._PodIP = PodIP

    @property
    def PodName(self):
        return self._PodName

    @PodName.setter
    def PodName(self, PodName):
        self._PodName = PodName

    @property
    def NodeType(self):
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def NodeUniqueID(self):
        return self._NodeUniqueID

    @NodeUniqueID.setter
    def NodeUniqueID(self, NodeUniqueID):
        self._NodeUniqueID = NodeUniqueID

    @property
    def PodCpu(self):
        return self._PodCpu

    @PodCpu.setter
    def PodCpu(self, PodCpu):
        self._PodCpu = PodCpu

    @property
    def PodMem(self):
        return self._PodMem

    @PodMem.setter
    def PodMem(self, PodMem):
        self._PodMem = PodMem

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def ClusterID(self):
        return self._ClusterID

    @ClusterID.setter
    def ClusterID(self, ClusterID):
        self._ClusterID = ClusterID

    @property
    def PodUid(self):
        return self._PodUid

    @PodUid.setter
    def PodUid(self, PodUid):
        self._PodUid = PodUid


    def _deserialize(self, params):
        self._ContainerID = params.get("ContainerID")
        self._ContainerName = params.get("ContainerName")
        self._Status = params.get("Status")
        self._CreateTime = params.get("CreateTime")
        self._RunAs = params.get("RunAs")
        self._Cmd = params.get("Cmd")
        self._CPUUsage = params.get("CPUUsage")
        self._RamUsage = params.get("RamUsage")
        self._ImageName = params.get("ImageName")
        self._ImageID = params.get("ImageID")
        self._POD = params.get("POD")
        self._HostID = params.get("HostID")
        self._HostIP = params.get("HostIP")
        self._UpdateTime = params.get("UpdateTime")
        self._HostName = params.get("HostName")
        self._PublicIp = params.get("PublicIp")
        self._NetStatus = params.get("NetStatus")
        self._NetSubStatus = params.get("NetSubStatus")
        self._IsolateSource = params.get("IsolateSource")
        self._IsolateTime = params.get("IsolateTime")
        self._NodeID = params.get("NodeID")
        self._PodIP = params.get("PodIP")
        self._PodName = params.get("PodName")
        self._NodeType = params.get("NodeType")
        self._NodeUniqueID = params.get("NodeUniqueID")
        self._PodCpu = params.get("PodCpu")
        self._PodMem = params.get("PodMem")
        self._ClusterName = params.get("ClusterName")
        self._ClusterID = params.get("ClusterID")
        self._PodUid = params.get("PodUid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContainerMount(AbstractModel):
    """容器挂载信息

    """

    def __init__(self):
        r"""
        :param _Type: 挂载类型 bind
        :type Type: str
        :param _Source: 宿主机路径
        :type Source: str
        :param _Destination: 容器内路径
        :type Destination: str
        :param _Mode: 模式
        :type Mode: str
        :param _RW: 读写权限
        :type RW: bool
        :param _Propagation: 传播类型
        :type Propagation: str
        :param _Name: 名称
        :type Name: str
        :param _Driver: 驱动
        :type Driver: str
        """
        self._Type = None
        self._Source = None
        self._Destination = None
        self._Mode = None
        self._RW = None
        self._Propagation = None
        self._Name = None
        self._Driver = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Source(self):
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def Destination(self):
        return self._Destination

    @Destination.setter
    def Destination(self, Destination):
        self._Destination = Destination

    @property
    def Mode(self):
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def RW(self):
        return self._RW

    @RW.setter
    def RW(self, RW):
        self._RW = RW

    @property
    def Propagation(self):
        return self._Propagation

    @Propagation.setter
    def Propagation(self, Propagation):
        self._Propagation = Propagation

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Driver(self):
        return self._Driver

    @Driver.setter
    def Driver(self, Driver):
        self._Driver = Driver


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Source = params.get("Source")
        self._Destination = params.get("Destination")
        self._Mode = params.get("Mode")
        self._RW = params.get("RW")
        self._Propagation = params.get("Propagation")
        self._Name = params.get("Name")
        self._Driver = params.get("Driver")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContainerNetwork(AbstractModel):
    """容器网络信息

    """

    def __init__(self):
        r"""
        :param _EndpointID: endpoint id
        :type EndpointID: str
        :param _Mode: 模式:bridge
        :type Mode: str
        :param _Name: 网络名称
        :type Name: str
        :param _NetworkID: 网络ID
        :type NetworkID: str
        :param _Gateway: 网关
        :type Gateway: str
        :param _Ipv4: IPV4地址
        :type Ipv4: str
        :param _Ipv6: IPV6地址
        :type Ipv6: str
        :param _MAC: MAC 地址
        :type MAC: str
        """
        self._EndpointID = None
        self._Mode = None
        self._Name = None
        self._NetworkID = None
        self._Gateway = None
        self._Ipv4 = None
        self._Ipv6 = None
        self._MAC = None

    @property
    def EndpointID(self):
        return self._EndpointID

    @EndpointID.setter
    def EndpointID(self, EndpointID):
        self._EndpointID = EndpointID

    @property
    def Mode(self):
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def NetworkID(self):
        return self._NetworkID

    @NetworkID.setter
    def NetworkID(self, NetworkID):
        self._NetworkID = NetworkID

    @property
    def Gateway(self):
        return self._Gateway

    @Gateway.setter
    def Gateway(self, Gateway):
        self._Gateway = Gateway

    @property
    def Ipv4(self):
        return self._Ipv4

    @Ipv4.setter
    def Ipv4(self, Ipv4):
        self._Ipv4 = Ipv4

    @property
    def Ipv6(self):
        return self._Ipv6

    @Ipv6.setter
    def Ipv6(self, Ipv6):
        self._Ipv6 = Ipv6

    @property
    def MAC(self):
        return self._MAC

    @MAC.setter
    def MAC(self, MAC):
        self._MAC = MAC


    def _deserialize(self, params):
        self._EndpointID = params.get("EndpointID")
        self._Mode = params.get("Mode")
        self._Name = params.get("Name")
        self._NetworkID = params.get("NetworkID")
        self._Gateway = params.get("Gateway")
        self._Ipv4 = params.get("Ipv4")
        self._Ipv6 = params.get("Ipv6")
        self._MAC = params.get("MAC")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAbnormalProcessRulesExportJobRequest(AbstractModel):
    """CreateAbnormalProcessRulesExportJob请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li>RuleType - string  - 是否必填: 否 -规则类型</li>
<li>Status - string  - 是否必填: 否 -状态</li>
        :type Filters: list of RunTimeFilters
        :param _Order: 排序方式
        :type Order: str
        :param _By: 排序字段
        :type By: str
        :param _ExportField: 导出字段
        :type ExportField: list of str
        """
        self._Filters = None
        self._Order = None
        self._By = None
        self._ExportField = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        self._ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAbnormalProcessRulesExportJobResponse(AbstractModel):
    """CreateAbnormalProcessRulesExportJob返回参数结构体

    """

    def __init__(self):
        r"""
        :param _JobId: 导出任务ID，前端拿着任务ID查询任务进度
        :type JobId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateAccessControlsRuleExportJobRequest(AbstractModel):
    """CreateAccessControlsRuleExportJob请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li>RuleType - string  - 是否必填: 否 -规则类型</li>
<li>Status - string  - 是否必填: 否 -状态</li>
        :type Filters: list of RunTimeFilters
        :param _Order: 排序方式
        :type Order: str
        :param _By: 排序字段
        :type By: list of str
        :param _ExportField: 导出字段
        :type ExportField: list of str
        """
        self._Filters = None
        self._Order = None
        self._By = None
        self._ExportField = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        self._ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAccessControlsRuleExportJobResponse(AbstractModel):
    """CreateAccessControlsRuleExportJob返回参数结构体

    """

    def __init__(self):
        r"""
        :param _JobId: 导出任务ID，前端拿着任务ID查询任务进度
        :type JobId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateAssetImageRegistryScanTaskOneKeyRequest(AbstractModel):
    """CreateAssetImageRegistryScanTaskOneKey请求参数结构体

    """

    def __init__(self):
        r"""
        :param _All: 是否扫描全部镜像(废弃)
        :type All: bool
        :param _Images: 扫描的镜像列表
        :type Images: list of ImageInfo
        :param _ScanType: 扫描类型数组
        :type ScanType: list of str
        :param _Id: 扫描的镜像列表Id
        :type Id: list of int non-negative
        :param _IsLatest: 是否最新镜像
        :type IsLatest: bool
        :param _ScanScope: 扫描范围 0全部镜像，1自选镜像，2推荐扫描镜像
        :type ScanScope: int
        :param _RegistryType: 仓库类型
        :type RegistryType: list of str
        :param _Namespace: 命名空间
        :type Namespace: list of str
        :param _ContainerRunning: 是否存在运行中的容器
        :type ContainerRunning: bool
        :param _Timeout: 任务超时时长单位s
        :type Timeout: int
        """
        self._All = None
        self._Images = None
        self._ScanType = None
        self._Id = None
        self._IsLatest = None
        self._ScanScope = None
        self._RegistryType = None
        self._Namespace = None
        self._ContainerRunning = None
        self._Timeout = None

    @property
    def All(self):
        warnings.warn("parameter `All` is deprecated", DeprecationWarning) 

        return self._All

    @All.setter
    def All(self, All):
        warnings.warn("parameter `All` is deprecated", DeprecationWarning) 

        self._All = All

    @property
    def Images(self):
        return self._Images

    @Images.setter
    def Images(self, Images):
        self._Images = Images

    @property
    def ScanType(self):
        return self._ScanType

    @ScanType.setter
    def ScanType(self, ScanType):
        self._ScanType = ScanType

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def IsLatest(self):
        return self._IsLatest

    @IsLatest.setter
    def IsLatest(self, IsLatest):
        self._IsLatest = IsLatest

    @property
    def ScanScope(self):
        return self._ScanScope

    @ScanScope.setter
    def ScanScope(self, ScanScope):
        self._ScanScope = ScanScope

    @property
    def RegistryType(self):
        return self._RegistryType

    @RegistryType.setter
    def RegistryType(self, RegistryType):
        self._RegistryType = RegistryType

    @property
    def Namespace(self):
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace

    @property
    def ContainerRunning(self):
        return self._ContainerRunning

    @ContainerRunning.setter
    def ContainerRunning(self, ContainerRunning):
        self._ContainerRunning = ContainerRunning

    @property
    def Timeout(self):
        return self._Timeout

    @Timeout.setter
    def Timeout(self, Timeout):
        self._Timeout = Timeout


    def _deserialize(self, params):
        self._All = params.get("All")
        if params.get("Images") is not None:
            self._Images = []
            for item in params.get("Images"):
                obj = ImageInfo()
                obj._deserialize(item)
                self._Images.append(obj)
        self._ScanType = params.get("ScanType")
        self._Id = params.get("Id")
        self._IsLatest = params.get("IsLatest")
        self._ScanScope = params.get("ScanScope")
        self._RegistryType = params.get("RegistryType")
        self._Namespace = params.get("Namespace")
        self._ContainerRunning = params.get("ContainerRunning")
        self._Timeout = params.get("Timeout")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAssetImageRegistryScanTaskOneKeyResponse(AbstractModel):
    """CreateAssetImageRegistryScanTaskOneKey返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskID: 扫描任务id
        :type TaskID: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskID = None
        self._RequestId = None

    @property
    def TaskID(self):
        return self._TaskID

    @TaskID.setter
    def TaskID(self, TaskID):
        self._TaskID = TaskID

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskID = params.get("TaskID")
        self._RequestId = params.get("RequestId")


class CreateAssetImageRegistryScanTaskRequest(AbstractModel):
    """CreateAssetImageRegistryScanTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _All: 是否扫描全部镜像
        :type All: bool
        :param _Images: 扫描的镜像列表
        :type Images: list of ImageInfo
        :param _ScanType: 扫描类型数组
        :type ScanType: list of str
        :param _Id: 扫描的镜像列表
        :type Id: list of int non-negative
        :param _Filters: 过滤条件
        :type Filters: list of AssetFilters
        :param _ExcludeImageList: 不需要扫描的镜像列表, 与Filters配合使用
        :type ExcludeImageList: list of int non-negative
        :param _OnlyScanLatest: 是否仅扫描各repository最新版的镜像, 与Filters配合使用
        :type OnlyScanLatest: bool
        """
        self._All = None
        self._Images = None
        self._ScanType = None
        self._Id = None
        self._Filters = None
        self._ExcludeImageList = None
        self._OnlyScanLatest = None

    @property
    def All(self):
        return self._All

    @All.setter
    def All(self, All):
        self._All = All

    @property
    def Images(self):
        return self._Images

    @Images.setter
    def Images(self, Images):
        self._Images = Images

    @property
    def ScanType(self):
        return self._ScanType

    @ScanType.setter
    def ScanType(self, ScanType):
        self._ScanType = ScanType

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ExcludeImageList(self):
        return self._ExcludeImageList

    @ExcludeImageList.setter
    def ExcludeImageList(self, ExcludeImageList):
        self._ExcludeImageList = ExcludeImageList

    @property
    def OnlyScanLatest(self):
        return self._OnlyScanLatest

    @OnlyScanLatest.setter
    def OnlyScanLatest(self, OnlyScanLatest):
        self._OnlyScanLatest = OnlyScanLatest


    def _deserialize(self, params):
        self._All = params.get("All")
        if params.get("Images") is not None:
            self._Images = []
            for item in params.get("Images"):
                obj = ImageInfo()
                obj._deserialize(item)
                self._Images.append(obj)
        self._ScanType = params.get("ScanType")
        self._Id = params.get("Id")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._ExcludeImageList = params.get("ExcludeImageList")
        self._OnlyScanLatest = params.get("OnlyScanLatest")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAssetImageRegistryScanTaskResponse(AbstractModel):
    """CreateAssetImageRegistryScanTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskID: 返回的任务ID
        :type TaskID: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskID = None
        self._RequestId = None

    @property
    def TaskID(self):
        return self._TaskID

    @TaskID.setter
    def TaskID(self, TaskID):
        self._TaskID = TaskID

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskID = params.get("TaskID")
        self._RequestId = params.get("RequestId")


class CreateAssetImageScanSettingRequest(AbstractModel):
    """CreateAssetImageScanSetting请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Enable: 开关
        :type Enable: bool
        :param _ScanTime: 扫描开始时间
01:00 时分
        :type ScanTime: str
        :param _ScanPeriod: 扫描周期
        :type ScanPeriod: int
        :param _ScanVirus: 扫描木马
        :type ScanVirus: bool
        :param _ScanRisk: 扫描敏感信息
        :type ScanRisk: bool
        :param _ScanVul: 扫描漏洞
        :type ScanVul: bool
        :param _All: 全部镜像
        :type All: bool
        :param _Images: 自定义镜像
        :type Images: list of str
        :param _ContainerRunning: 镜像是否存在运行中的容器
        :type ContainerRunning: bool
        :param _ScanScope: 扫描范围 0 全部授权镜像，1自选镜像，2 推荐扫描
        :type ScanScope: int
        :param _ScanEndTime: 扫描结束时间
02:00 时分
        :type ScanEndTime: str
        """
        self._Enable = None
        self._ScanTime = None
        self._ScanPeriod = None
        self._ScanVirus = None
        self._ScanRisk = None
        self._ScanVul = None
        self._All = None
        self._Images = None
        self._ContainerRunning = None
        self._ScanScope = None
        self._ScanEndTime = None

    @property
    def Enable(self):
        return self._Enable

    @Enable.setter
    def Enable(self, Enable):
        self._Enable = Enable

    @property
    def ScanTime(self):
        return self._ScanTime

    @ScanTime.setter
    def ScanTime(self, ScanTime):
        self._ScanTime = ScanTime

    @property
    def ScanPeriod(self):
        return self._ScanPeriod

    @ScanPeriod.setter
    def ScanPeriod(self, ScanPeriod):
        self._ScanPeriod = ScanPeriod

    @property
    def ScanVirus(self):
        return self._ScanVirus

    @ScanVirus.setter
    def ScanVirus(self, ScanVirus):
        self._ScanVirus = ScanVirus

    @property
    def ScanRisk(self):
        return self._ScanRisk

    @ScanRisk.setter
    def ScanRisk(self, ScanRisk):
        self._ScanRisk = ScanRisk

    @property
    def ScanVul(self):
        return self._ScanVul

    @ScanVul.setter
    def ScanVul(self, ScanVul):
        self._ScanVul = ScanVul

    @property
    def All(self):
        warnings.warn("parameter `All` is deprecated", DeprecationWarning) 

        return self._All

    @All.setter
    def All(self, All):
        warnings.warn("parameter `All` is deprecated", DeprecationWarning) 

        self._All = All

    @property
    def Images(self):
        return self._Images

    @Images.setter
    def Images(self, Images):
        self._Images = Images

    @property
    def ContainerRunning(self):
        return self._ContainerRunning

    @ContainerRunning.setter
    def ContainerRunning(self, ContainerRunning):
        self._ContainerRunning = ContainerRunning

    @property
    def ScanScope(self):
        return self._ScanScope

    @ScanScope.setter
    def ScanScope(self, ScanScope):
        self._ScanScope = ScanScope

    @property
    def ScanEndTime(self):
        return self._ScanEndTime

    @ScanEndTime.setter
    def ScanEndTime(self, ScanEndTime):
        self._ScanEndTime = ScanEndTime


    def _deserialize(self, params):
        self._Enable = params.get("Enable")
        self._ScanTime = params.get("ScanTime")
        self._ScanPeriod = params.get("ScanPeriod")
        self._ScanVirus = params.get("ScanVirus")
        self._ScanRisk = params.get("ScanRisk")
        self._ScanVul = params.get("ScanVul")
        self._All = params.get("All")
        self._Images = params.get("Images")
        self._ContainerRunning = params.get("ContainerRunning")
        self._ScanScope = params.get("ScanScope")
        self._ScanEndTime = params.get("ScanEndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAssetImageScanSettingResponse(AbstractModel):
    """CreateAssetImageScanSetting返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateAssetImageScanTaskRequest(AbstractModel):
    """CreateAssetImageScanTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _All: 是否扫描全部镜像；全部镜像，镜像列表和根据过滤条件筛选三选一。
        :type All: bool
        :param _Images: 需要扫描的镜像列表；全部镜像，镜像列表和根据过滤条件筛选三选一。
        :type Images: list of str
        :param _ScanVul: 扫描漏洞；漏洞，木马和风险需选其一
        :type ScanVul: bool
        :param _ScanVirus: 扫描木马；漏洞，木马和风险需选其一
        :type ScanVirus: bool
        :param _ScanRisk: 扫描风险；漏洞，木马和风险需选其一
        :type ScanRisk: bool
        :param _Filters: 根据过滤条件筛选出镜像；全部镜像，镜像列表和根据过滤条件筛选三选一。
        :type Filters: list of AssetFilters
        :param _ExcludeImageIds: 根据过滤条件筛选出镜像，再排除个别镜像
        :type ExcludeImageIds: list of str
        :param _ContainerRunning: 镜像是否存在运行中的容器
        :type ContainerRunning: bool
        :param _ScanScope: 扫描范围 0 全部授权镜像，1自选镜像，2 推荐扫描
        :type ScanScope: int
        :param _Timeout: 任务超时时长单位秒，默认1小时
        :type Timeout: int
        """
        self._All = None
        self._Images = None
        self._ScanVul = None
        self._ScanVirus = None
        self._ScanRisk = None
        self._Filters = None
        self._ExcludeImageIds = None
        self._ContainerRunning = None
        self._ScanScope = None
        self._Timeout = None

    @property
    def All(self):
        warnings.warn("parameter `All` is deprecated", DeprecationWarning) 

        return self._All

    @All.setter
    def All(self, All):
        warnings.warn("parameter `All` is deprecated", DeprecationWarning) 

        self._All = All

    @property
    def Images(self):
        return self._Images

    @Images.setter
    def Images(self, Images):
        self._Images = Images

    @property
    def ScanVul(self):
        return self._ScanVul

    @ScanVul.setter
    def ScanVul(self, ScanVul):
        self._ScanVul = ScanVul

    @property
    def ScanVirus(self):
        return self._ScanVirus

    @ScanVirus.setter
    def ScanVirus(self, ScanVirus):
        self._ScanVirus = ScanVirus

    @property
    def ScanRisk(self):
        return self._ScanRisk

    @ScanRisk.setter
    def ScanRisk(self, ScanRisk):
        self._ScanRisk = ScanRisk

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ExcludeImageIds(self):
        return self._ExcludeImageIds

    @ExcludeImageIds.setter
    def ExcludeImageIds(self, ExcludeImageIds):
        self._ExcludeImageIds = ExcludeImageIds

    @property
    def ContainerRunning(self):
        return self._ContainerRunning

    @ContainerRunning.setter
    def ContainerRunning(self, ContainerRunning):
        self._ContainerRunning = ContainerRunning

    @property
    def ScanScope(self):
        return self._ScanScope

    @ScanScope.setter
    def ScanScope(self, ScanScope):
        self._ScanScope = ScanScope

    @property
    def Timeout(self):
        return self._Timeout

    @Timeout.setter
    def Timeout(self, Timeout):
        self._Timeout = Timeout


    def _deserialize(self, params):
        self._All = params.get("All")
        self._Images = params.get("Images")
        self._ScanVul = params.get("ScanVul")
        self._ScanVirus = params.get("ScanVirus")
        self._ScanRisk = params.get("ScanRisk")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._ExcludeImageIds = params.get("ExcludeImageIds")
        self._ContainerRunning = params.get("ContainerRunning")
        self._ScanScope = params.get("ScanScope")
        self._Timeout = params.get("Timeout")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAssetImageScanTaskResponse(AbstractModel):
    """CreateAssetImageScanTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskID: 任务id
        :type TaskID: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskID = None
        self._RequestId = None

    @property
    def TaskID(self):
        return self._TaskID

    @TaskID.setter
    def TaskID(self, TaskID):
        self._TaskID = TaskID

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskID = params.get("TaskID")
        self._RequestId = params.get("RequestId")


class CreateAssetImageVirusExportJobRequest(AbstractModel):
    """CreateAssetImageVirusExportJob请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ExportField: 导出字段
        :type ExportField: list of str
        :param _ImageID: 镜像id
        :type ImageID: str
        :param _Filters: 需要返回的数量，默认为10，最大值为10000
        :type Filters: list of AssetFilters
        :param _Limit: 偏移量，默认为0。
        :type Limit: int
        :param _Offset: 过滤参数,"Filters":[{"Name":"Status","Values":["2"]}]
        :type Offset: int
        :param _By: 排序字段
        :type By: str
        :param _Order: 升序降序,asc desc
        :type Order: str
        """
        self._ExportField = None
        self._ImageID = None
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._By = None
        self._Order = None

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._ExportField = params.get("ExportField")
        self._ImageID = params.get("ImageID")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAssetImageVirusExportJobResponse(AbstractModel):
    """CreateAssetImageVirusExportJob返回参数结构体

    """

    def __init__(self):
        r"""
        :param _JobId: 导出任务ID，前端拿着任务ID查询任务进度
        :type JobId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateCheckComponentRequest(AbstractModel):
    """CreateCheckComponent请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterInfoList: 要安装的集群列表信息
        :type ClusterInfoList: list of ClusterCreateComponentItem
        """
        self._ClusterInfoList = None

    @property
    def ClusterInfoList(self):
        return self._ClusterInfoList

    @ClusterInfoList.setter
    def ClusterInfoList(self, ClusterInfoList):
        self._ClusterInfoList = ClusterInfoList


    def _deserialize(self, params):
        if params.get("ClusterInfoList") is not None:
            self._ClusterInfoList = []
            for item in params.get("ClusterInfoList"):
                obj = ClusterCreateComponentItem()
                obj._deserialize(item)
                self._ClusterInfoList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCheckComponentResponse(AbstractModel):
    """CreateCheckComponent返回参数结构体

    """

    def __init__(self):
        r"""
        :param _InstallResult: "InstallSucc"表示安装成功，"InstallFailed"表示安装失败
        :type InstallResult: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._InstallResult = None
        self._RequestId = None

    @property
    def InstallResult(self):
        return self._InstallResult

    @InstallResult.setter
    def InstallResult(self, InstallResult):
        self._InstallResult = InstallResult

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._InstallResult = params.get("InstallResult")
        self._RequestId = params.get("RequestId")


class CreateClusterCheckTaskRequest(AbstractModel):
    """CreateClusterCheckTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterCheckTaskList: 指定要扫描的集群信息
        :type ClusterCheckTaskList: list of ClusterCheckTaskItem
        """
        self._ClusterCheckTaskList = None

    @property
    def ClusterCheckTaskList(self):
        return self._ClusterCheckTaskList

    @ClusterCheckTaskList.setter
    def ClusterCheckTaskList(self, ClusterCheckTaskList):
        self._ClusterCheckTaskList = ClusterCheckTaskList


    def _deserialize(self, params):
        if params.get("ClusterCheckTaskList") is not None:
            self._ClusterCheckTaskList = []
            for item in params.get("ClusterCheckTaskList"):
                obj = ClusterCheckTaskItem()
                obj._deserialize(item)
                self._ClusterCheckTaskList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateClusterCheckTaskResponse(AbstractModel):
    """CreateClusterCheckTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 返回创建的集群检查任务的ID，为0表示创建失败。
        :type TaskId: int
        :param _CreateResult: 创建检查任务的结果，"Succ"为成功，其他的为失败原因
        :type CreateResult: str
        :param _NewTaskID: 返回创建的集群新任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type NewTaskID: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._CreateResult = None
        self._NewTaskID = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CreateResult(self):
        return self._CreateResult

    @CreateResult.setter
    def CreateResult(self, CreateResult):
        self._CreateResult = CreateResult

    @property
    def NewTaskID(self):
        return self._NewTaskID

    @NewTaskID.setter
    def NewTaskID(self, NewTaskID):
        self._NewTaskID = NewTaskID

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CreateResult = params.get("CreateResult")
        self._NewTaskID = params.get("NewTaskID")
        self._RequestId = params.get("RequestId")


class CreateComplianceTaskRequest(AbstractModel):
    """CreateComplianceTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AssetTypeSet: 指定要扫描的资产类型列表。
ASSET_CONTAINER, 容器
ASSET_IMAGE, 镜像
ASSET_HOST, 主机
ASSET_K8S, K8S资产
AssetTypeSet, PolicySetId, PeriodTaskId三个参数，必须要给其中一个参数填写有效的值。
        :type AssetTypeSet: list of str
        :param _PolicySetId: 按照策略集ID指定的策略执行合规检查。
        :type PolicySetId: int
        :param _PeriodTaskId: 按照定时任务ID指定的策略执行合规检查。
        :type PeriodTaskId: int
        """
        self._AssetTypeSet = None
        self._PolicySetId = None
        self._PeriodTaskId = None

    @property
    def AssetTypeSet(self):
        return self._AssetTypeSet

    @AssetTypeSet.setter
    def AssetTypeSet(self, AssetTypeSet):
        self._AssetTypeSet = AssetTypeSet

    @property
    def PolicySetId(self):
        return self._PolicySetId

    @PolicySetId.setter
    def PolicySetId(self, PolicySetId):
        self._PolicySetId = PolicySetId

    @property
    def PeriodTaskId(self):
        return self._PeriodTaskId

    @PeriodTaskId.setter
    def PeriodTaskId(self, PeriodTaskId):
        self._PeriodTaskId = PeriodTaskId


    def _deserialize(self, params):
        self._AssetTypeSet = params.get("AssetTypeSet")
        self._PolicySetId = params.get("PolicySetId")
        self._PeriodTaskId = params.get("PeriodTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateComplianceTaskResponse(AbstractModel):
    """CreateComplianceTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 返回创建的合规检查任务的ID。
        :type TaskId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateComponentExportJobRequest(AbstractModel):
    """CreateComponentExportJob请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ImageID: 镜像ID
        :type ImageID: str
        :param _ExportField: 导出字段
        :type ExportField: list of str
        :param _Limit: 需要返回的数量，默认为10000，最大值为10000
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>ComponentName- String - 是否必填：否 - 镜像组件名称</li><li>ComponentVersion- String - 是否必填：否 - 镜像组件版本</li><li>ComponentType- String - 是否必填：否 - 镜像组件类型</li><li>VulLevel- String - 是否必填：否 - 漏洞威胁等级</li><li>HasVul- String - 是否必填：否 -是否有漏洞；true：是，false，否；不传或ALL ：全部</li>
        :type Filters: list of AssetFilters
        :param _By: 排序字段
        :type By: str
        :param _Order: 排序方式desc ，asc
        :type Order: str
        """
        self._ImageID = None
        self._ExportField = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._ImageID = params.get("ImageID")
        self._ExportField = params.get("ExportField")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateComponentExportJobResponse(AbstractModel):
    """CreateComponentExportJob返回参数结构体

    """

    def __init__(self):
        r"""
        :param _JobId: 导出任务ID，前端拿着任务ID查询任务进度
        :type JobId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateDefenceVulExportJobRequest(AbstractModel):
    """CreateDefenceVulExportJob请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10000，最大值为10000
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Level- String - 是否必填：否 - 威胁等级，CRITICAL:严重 HIGH:高/MIDDLE:中/LOW:低</li>
<li>CVEID- string - 是否必填：否 - CVE编号</li>
<li>Name- string -是否必填: 否 - 漏洞名称</li>
        :type Filters: list of RunTimeFilters
        :param _Order: 排序方式
        :type Order: str
        :param _By: 排序字段
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDefenceVulExportJobResponse(AbstractModel):
    """CreateDefenceVulExportJob返回参数结构体

    """

    def __init__(self):
        r"""
        :param _JobId: 导出任务ID，前端拿着任务ID查询任务进度
        :type JobId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateEmergencyVulExportJobRequest(AbstractModel):
    """CreateEmergencyVulExportJob请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为50000，最大值为50000
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Level- String - 是否必填：否 - 威胁等级，CRITICAL:严重 HIGH:高/MIDDLE:中/LOW:低</li>
<li>Tags- string - 是否必填：否 - 漏洞标签，POC，EXP。</li>
<li>CanBeFixed- string - 是否必填：否 - 是否可修复true,false。</li>
<li>CVEID- string - 是否必填：否 - CVE编号</li>
<li>ImageID- string - 是否必填：否 - 镜像ID</li>
<li>ImageName- String -是否必填: 否 - 镜像名称</li>
<li>ContainerID- string -是否必填: 否 - 容器ID</li>
<li>ContainerName- string -是否必填: 否 - 容器名称</li>
<li>ComponentName- string -是否必填: 否 - 组件名称</li>
<li>ComponentVersion- string -是否必填: 否 - 组件版本</li>
<li>Name- string -是否必填: 否 - 漏洞名称</li>
        :type Filters: list of RunTimeFilters
        :param _Order: 排序方式
        :type Order: str
        :param _By: 排序字段
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateEmergencyVulExportJobResponse(AbstractModel):
    """CreateEmergencyVulExportJob返回参数结构体

    """

    def __init__(self):
        r"""
        :param _JobId: 导出任务ID，前端拿着任务ID查询任务进度
        :type JobId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateEscapeEventsExportJobRequest(AbstractModel):
    """CreateEscapeEventsExportJob请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，最大值为10000
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤参数,Status：EVENT_UNDEAL:未处理，EVENT_DEALED:已处理，EVENT_INGNORE:忽略
        :type Filters: list of RunTimeFilters
        :param _Order: 升序降序,asc desc
        :type Order: str
        :param _By: 排序字段：latest_found_time
        :type By: str
        :param _ExportField: 导出字段
        :type ExportField: list of str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None
        self._ExportField = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        self._ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateEscapeEventsExportJobResponse(AbstractModel):
    """CreateEscapeEventsExportJob返回参数结构体

    """

    def __init__(self):
        r"""
        :param _JobId: 导出任务ID，前端拿着任务ID查询任务进度
        :type JobId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateEscapeWhiteListExportJobRequest(AbstractModel):
    """CreateEscapeWhiteListExportJob请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li>EventType- String - 是否必填：否 - 加白事件类型，ESCAPE_CGROUPS：利用cgroup机制逃逸，ESCAPE_TAMPER_SENSITIVE_FILE：篡改敏感文件逃逸， ESCAPE_DOCKER_API：访问Docker API接口逃逸，ESCAPE_VUL_OCCURRED：逃逸漏洞利用，MOUNT_SENSITIVE_PTAH：敏感路径挂载，PRIVILEGE_CONTAINER_START：特权容器， PRIVILEGE：程序提权逃逸</li>
<li>ImageName- string - 是否必填：否 - 镜像名称。</li>
<li>ImageID- string - 是否必填：否 - 镜像ID。</li>
        :type Filters: list of RunTimeFilters
        :param _Limit: 需要返回的数量，默认为10000，最大值为10000
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Order: 排序方式：asc/desc
        :type Order: str
        :param _By: 排序字段：主机数量：HostCount，容器数量：ContainerCount，更新时间：UpdateTime
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateEscapeWhiteListExportJobResponse(AbstractModel):
    """CreateEscapeWhiteListExportJob返回参数结构体

    """

    def __init__(self):
        r"""
        :param _JobId: 导出任务ID，前端拿着任务ID查询任务进度
        :type JobId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateExportComplianceStatusListJobRequest(AbstractModel):
    """CreateExportComplianceStatusListJob请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AssetType: 要导出信息的资产类型
        :type AssetType: str
        :param _ExportByAsset: 按照检测项导出，还是按照资产导出。true: 按照资产导出；false: 按照检测项导出。
        :type ExportByAsset: bool
        :param _ExportAll: true, 全部导出；false, 根据IdList来导出数据。
        :type ExportAll: bool
        :param _IdList: 要导出的资产ID列表或检测项ID列表，由ExportByAsset的取值决定。
        :type IdList: list of int non-negative
        """
        self._AssetType = None
        self._ExportByAsset = None
        self._ExportAll = None
        self._IdList = None

    @property
    def AssetType(self):
        return self._AssetType

    @AssetType.setter
    def AssetType(self, AssetType):
        self._AssetType = AssetType

    @property
    def ExportByAsset(self):
        return self._ExportByAsset

    @ExportByAsset.setter
    def ExportByAsset(self, ExportByAsset):
        self._ExportByAsset = ExportByAsset

    @property
    def ExportAll(self):
        return self._ExportAll

    @ExportAll.setter
    def ExportAll(self, ExportAll):
        self._ExportAll = ExportAll

    @property
    def IdList(self):
        return self._IdList

    @IdList.setter
    def IdList(self, IdList):
        self._IdList = IdList


    def _deserialize(self, params):
        self._AssetType = params.get("AssetType")
        self._ExportByAsset = params.get("ExportByAsset")
        self._ExportAll = params.get("ExportAll")
        self._IdList = params.get("IdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateExportComplianceStatusListJobResponse(AbstractModel):
    """CreateExportComplianceStatusListJob返回参数结构体

    """

    def __init__(self):
        r"""
        :param _JobId: 返回创建的导出任务的ID
注意：此字段可能返回 null，表示取不到有效值。
        :type JobId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateHostExportJobRequest(AbstractModel):
    """CreateHostExportJob请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li>Status - String - 是否必填：否 - agent状态筛选，"ALL":"全部"(或不传该字段),"UNINSTALL"："未安装","OFFLINE"："离线", "ONLINE"："防护中"</li>
<li>HostName - String - 是否必填：否 - 主机名筛选</li>
<li>Group- String - 是否必填：否 - 主机群组搜索</li>
<li>HostIP- string - 是否必填：否 - 主机ip搜索</li>
<li>HostID- string - 是否必填：否 - 主机id搜索</li>
<li>DockerVersion- string - 是否必填：否 - docker版本搜索</li>
<li>MachineType- string - 是否必填：否 - 主机来源MachineType搜索，"ALL":"全部"(或不传该字段),主机来源：["CVM", "ECM", "LH", "BM"]  中的之一为腾讯云服务器；["Other"]之一非腾讯云服务器；</li>
<li>DockerStatus- string - 是否必填：否 - docker安装状态，"ALL":"全部"(或不传该字段),"INSTALL":"已安装","UNINSTALL":"未安装"</li>
<li>ProjectID- string - 是否必填：否 - 所属项目id搜索</li>
<li>Tag:xxx(tag:key)- string- 是否必填：否 - 标签键值搜索 示例Filters":[{"Name":"tag:tke-kind","Values":["service"]}]</li>
        :type Filters: list of AssetFilters
        :param _Limit: 偏移量，默认为0。
        :type Limit: int
        :param _Offset: 需要返回的数量，默认为10，最大值为10000
        :type Offset: int
        :param _By: 排序字段
        :type By: str
        :param _Order: 升序降序,asc desc
        :type Order: str
        :param _ExportField: 导出字段
        :type ExportField: list of str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._By = None
        self._Order = None
        self._ExportField = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._By = params.get("By")
        self._Order = params.get("Order")
        self._ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateHostExportJobResponse(AbstractModel):
    """CreateHostExportJob返回参数结构体

    """

    def __init__(self):
        r"""
        :param _JobId: 导出任务ID，前端拿着任务ID查询任务进度
        :type JobId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateImageExportJobRequest(AbstractModel):
    """CreateImageExportJob请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li>ImageName- String - 是否必填：否 - 镜像名称筛选，</li>
<li>ScanStatus - String - 是否必填：否 - 镜像扫描状态notScan，scanning，scanned，scanErr</li>
<li>ImageID- String - 是否必填：否 - 镜像ID筛选，</li>
<li>SecurityRisk- String - 是否必填：否 - 安全风险，VulCnt 、VirusCnt、RiskCnt、IsTrustImage</li>
        :type Filters: list of RunTimeFilters
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _By: 排序字段
        :type By: str
        :param _Order: 排序方式 asc,desc
        :type Order: str
        :param _ExportField: 导出字段
        :type ExportField: list of str
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._By = None
        self._Order = None
        self._ExportField = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._By = params.get("By")
        self._Order = params.get("Order")
        self._ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateImageExportJobResponse(AbstractModel):
    """CreateImageExportJob返回参数结构体

    """

    def __init__(self):
        r"""
        :param _JobId: 导出任务ID，前端拿着任务ID查询任务进度
        :type JobId: str
        :param _DownloadUrl: excel文件下载地址
        :type DownloadUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._JobId = None
        self._DownloadUrl = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._DownloadUrl = params.get("DownloadUrl")
        self._RequestId = params.get("RequestId")


class CreateK8sApiAbnormalEventExportJobRequest(AbstractModel):
    """CreateK8sApiAbnormalEventExportJob请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li>TimeRange - string -是否必填: 否 - 时间范围筛选 ["2022-03-31 16:55:00", "2022-03-31 17:00:00"]</li>
<li>MatchRules - string  - 是否必填: 否 -命中规则筛选</li>
<li>RiskLevel - string  - 是否必填: 否 -威胁等级筛选</li>
<li>Status - string  - 是否必填: 否 -事件状态筛选</li>
<li>MatchRuleType - string  - 是否必填: 否 -命中规则类型筛选</li>
<li>ClusterRunningStatus - string  - 是否必填: 否 -集群运行状态</li>
<li>ClusterName - string  - 是否必填: 否 -集群名称</li>
<li>ClusterID - string  - 是否必填: 否 -集群ID</li>
        :type Filters: list of RunTimeFilters
        :param _Order: 排序方式
        :type Order: str
        :param _By: 排序字段
        :type By: str
        :param _ExportField: 导出字段
        :type ExportField: list of str
        """
        self._Filters = None
        self._Order = None
        self._By = None
        self._ExportField = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        self._ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateK8sApiAbnormalEventExportJobResponse(AbstractModel):
    """CreateK8sApiAbnormalEventExportJob返回参数结构体

    """

    def __init__(self):
        r"""
        :param _JobId: 导出任务ID，前端拿着任务ID查询任务进度
        :type JobId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateK8sApiAbnormalRuleExportJobRequest(AbstractModel):
    """CreateK8sApiAbnormalRuleExportJob请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li>RuleType - string  - 是否必填: 否 -规则类型</li>
<li>Status - string  - 是否必填: 否 -状态</li>
        :type Filters: list of RunTimeFilters
        :param _Order: 排序方式
        :type Order: str
        :param _By: 排序字段
        :type By: list of str
        :param _ExportField: 导出字段
        :type ExportField: list of str
        """
        self._Filters = None
        self._Order = None
        self._By = None
        self._ExportField = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        self._ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateK8sApiAbnormalRuleExportJobResponse(AbstractModel):
    """CreateK8sApiAbnormalRuleExportJob返回参数结构体

    """

    def __init__(self):
        r"""
        :param _JobId: 导出任务ID，前端拿着任务ID查询任务进度
        :type JobId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateK8sApiAbnormalRuleInfoRequest(AbstractModel):
    """CreateK8sApiAbnormalRuleInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleInfo: 规则详情
        :type RuleInfo: :class:`tencentcloud.tcss.v20201101.models.K8sApiAbnormalRuleInfo`
        :param _CopySrcRuleID: 拷贝规则ID(适用于复制规则场景)
        :type CopySrcRuleID: str
        :param _EventID: 事件ID(适用于事件加白场景)
        :type EventID: int
        """
        self._RuleInfo = None
        self._CopySrcRuleID = None
        self._EventID = None

    @property
    def RuleInfo(self):
        return self._RuleInfo

    @RuleInfo.setter
    def RuleInfo(self, RuleInfo):
        self._RuleInfo = RuleInfo

    @property
    def CopySrcRuleID(self):
        return self._CopySrcRuleID

    @CopySrcRuleID.setter
    def CopySrcRuleID(self, CopySrcRuleID):
        self._CopySrcRuleID = CopySrcRuleID

    @property
    def EventID(self):
        return self._EventID

    @EventID.setter
    def EventID(self, EventID):
        self._EventID = EventID


    def _deserialize(self, params):
        if params.get("RuleInfo") is not None:
            self._RuleInfo = K8sApiAbnormalRuleInfo()
            self._RuleInfo._deserialize(params.get("RuleInfo"))
        self._CopySrcRuleID = params.get("CopySrcRuleID")
        self._EventID = params.get("EventID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateK8sApiAbnormalRuleInfoResponse(AbstractModel):
    """CreateK8sApiAbnormalRuleInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleID: 规则ID
        :type RuleID: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RuleID = None
        self._RequestId = None

    @property
    def RuleID(self):
        return self._RuleID

    @RuleID.setter
    def RuleID(self, RuleID):
        self._RuleID = RuleID

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RuleID = params.get("RuleID")
        self._RequestId = params.get("RequestId")


class CreateNetworkFirewallClusterRefreshRequest(AbstractModel):
    """CreateNetworkFirewallClusterRefresh请求参数结构体

    """


class CreateNetworkFirewallClusterRefreshResponse(AbstractModel):
    """CreateNetworkFirewallClusterRefresh返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 返回创建的集群检查任务的ID，为0表示创建失败。
        :type TaskId: int
        :param _Result: 创建检查任务的结果，"Succ"为成功，"Failed"为失败
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._Result = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateNetworkFirewallPolicyDiscoverRequest(AbstractModel):
    """CreateNetworkFirewallPolicyDiscover请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群Id
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNetworkFirewallPolicyDiscoverResponse(AbstractModel):
    """CreateNetworkFirewallPolicyDiscover返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 返回创建的集群检查任务的ID，为0表示创建失败。
        :type TaskId: int
        :param _Result: 创建检查任务的结果，"Succ"为成功，"Failed"为失败
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._Result = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateNetworkFirewallPublishRequest(AbstractModel):
    """CreateNetworkFirewallPublish请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群Id
        :type ClusterId: str
        :param _Id: 策略Id数组
        :type Id: list of int non-negative
        """
        self._ClusterId = None
        self._Id = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNetworkFirewallPublishResponse(AbstractModel):
    """CreateNetworkFirewallPublish返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 返回创建的任务的ID，为0表示创建失败。
        :type TaskId: int
        :param _Result: 创建任务的结果，"Succ"为成功，"Failed"为失败
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._Result = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateNetworkFirewallUndoPublishRequest(AbstractModel):
    """CreateNetworkFirewallUndoPublish请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群Id
        :type ClusterId: str
        :param _Id: 策略Id数组
        :type Id: list of int non-negative
        """
        self._ClusterId = None
        self._Id = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNetworkFirewallUndoPublishResponse(AbstractModel):
    """CreateNetworkFirewallUndoPublish返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 返回创建的任务的ID，为0表示创建失败。
        :type TaskId: int
        :param _Result: 创建任务的结果，"Succ"为成功，"Failed"为失败
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._Result = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateOrModifyPostPayCoresRequest(AbstractModel):
    """CreateOrModifyPostPayCores请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CoresCnt: 弹性计费上限，最小值500
        :type CoresCnt: int
        """
        self._CoresCnt = None

    @property
    def CoresCnt(self):
        return self._CoresCnt

    @CoresCnt.setter
    def CoresCnt(self, CoresCnt):
        self._CoresCnt = CoresCnt


    def _deserialize(self, params):
        self._CoresCnt = params.get("CoresCnt")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOrModifyPostPayCoresResponse(AbstractModel):
    """CreateOrModifyPostPayCores返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateProcessEventsExportJobRequest(AbstractModel):
    """CreateProcessEventsExportJob请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，最大值为10000
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤参数,Status：EVENT_UNDEAL:未处理，EVENT_DEALED:已处理，EVENT_INGNORE:忽略
        :type Filters: list of AssetFilters
        :param _Order: 升序降序,asc desc
        :type Order: str
        :param _By: 排序字段：latest_found_time
        :type By: str
        :param _ExportField: 导出字段
        :type ExportField: list of str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None
        self._ExportField = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        self._ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateProcessEventsExportJobResponse(AbstractModel):
    """CreateProcessEventsExportJob返回参数结构体

    """

    def __init__(self):
        r"""
        :param _JobId: 导出任务ID，前端拿着任务ID查询任务进度
        :type JobId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateRefreshTaskRequest(AbstractModel):
    """CreateRefreshTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterIDs: 指定集群列表,若为空则标识同步所有集群
        :type ClusterIDs: list of str
        :param _IsSyncListOnly: 是否只同步列表
        :type IsSyncListOnly: bool
        """
        self._ClusterIDs = None
        self._IsSyncListOnly = None

    @property
    def ClusterIDs(self):
        return self._ClusterIDs

    @ClusterIDs.setter
    def ClusterIDs(self, ClusterIDs):
        self._ClusterIDs = ClusterIDs

    @property
    def IsSyncListOnly(self):
        return self._IsSyncListOnly

    @IsSyncListOnly.setter
    def IsSyncListOnly(self, IsSyncListOnly):
        self._IsSyncListOnly = IsSyncListOnly


    def _deserialize(self, params):
        self._ClusterIDs = params.get("ClusterIDs")
        self._IsSyncListOnly = params.get("IsSyncListOnly")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRefreshTaskResponse(AbstractModel):
    """CreateRefreshTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 返回创建的集群检查任务的ID，为0表示创建失败。
        :type TaskId: int
        :param _CreateResult: 创建检查任务的结果，"Succ"为成功，"Failed"为失败
        :type CreateResult: str
        :param _NewTaskID: 返回创建的新集群检查任务ID
        :type NewTaskID: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._CreateResult = None
        self._NewTaskID = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CreateResult(self):
        return self._CreateResult

    @CreateResult.setter
    def CreateResult(self, CreateResult):
        self._CreateResult = CreateResult

    @property
    def NewTaskID(self):
        return self._NewTaskID

    @NewTaskID.setter
    def NewTaskID(self, NewTaskID):
        self._NewTaskID = NewTaskID

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CreateResult = params.get("CreateResult")
        self._NewTaskID = params.get("NewTaskID")
        self._RequestId = params.get("RequestId")


class CreateRiskDnsEventExportJobRequest(AbstractModel):
    """CreateRiskDnsEventExportJob请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li>EventStatus- String - 是否必填：否 - 事件状态，待处理：EVENT_UNDEAL，EVENT_DEALED：已处理，已忽略：EVENT_IGNORE， EVENT_ADD_WHITE：已加白</li>
<li>ContainerStatus- String - 是否必填：否 - 容器运行状态筛选，已创建：CREATED,正常运行：RUNNING, 暂定运行：PAUSED, 停止运行：	STOPPED，重启中：RESTARTING, 迁移中：REMOVING, 销毁：DESTROYED </li>
<li>ContainerNetStatus- String -是否必填: 否 -  容器网络状态筛选 未隔离：NORMAL，已隔离：ISOLATED，隔离失败：ISOLATE_FAILED，解除隔离失败：RESTORE_FAILED，解除隔离中：RESTORING，隔离中：ISOLATING</li>
<li>EventType - String -是否必填: 否 -  事件类型，恶意域名请求：DOMAIN，恶意IP请求：IP</li>
<li>TimeRange- String -是否必填: 否 -  时间范围，第一个值表示开始时间，第二个值表示结束时间 </li>
<li>RiskDns- string - 是否必填：否 - 恶意域名。</li>
<li>RiskIP- string - 是否必填：否 - 恶意IP。</li>
<li>ContainerName- string - 是否必填：否 - 容器名称。</li>
<li>ContainerID- string - 是否必填：否 - 容器ID。</li>
<li>ImageName- string - 是否必填：否 - 镜像名称。</li>
<li>ImageID- string - 是否必填：否 - 镜像ID。</li>
<li>HostName- string - 是否必填：否 - 主机名称。</li>
<li>HostIP- string - 是否必填：否 - 内网IP。</li>
<li>PublicIP- string - 是否必填：否 - 外网IP。</li>
        :type Filters: list of RunTimeFilters
        :param _Limit: 需要返回的数量，最大值为100000
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Order: 排序方式：asc/desc
        :type Order: str
        :param _By: 排序字段：事件数量：EventCount
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRiskDnsEventExportJobResponse(AbstractModel):
    """CreateRiskDnsEventExportJob返回参数结构体

    """

    def __init__(self):
        r"""
        :param _JobId: 导出任务ID，前端拿着任务ID查询任务进度
        :type JobId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateSearchTemplateRequest(AbstractModel):
    """CreateSearchTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SearchTemplate: 搜索模板
        :type SearchTemplate: :class:`tencentcloud.tcss.v20201101.models.SearchTemplate`
        """
        self._SearchTemplate = None

    @property
    def SearchTemplate(self):
        return self._SearchTemplate

    @SearchTemplate.setter
    def SearchTemplate(self, SearchTemplate):
        self._SearchTemplate = SearchTemplate


    def _deserialize(self, params):
        if params.get("SearchTemplate") is not None:
            self._SearchTemplate = SearchTemplate()
            self._SearchTemplate._deserialize(params.get("SearchTemplate"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSearchTemplateResponse(AbstractModel):
    """CreateSearchTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateSystemVulExportJobRequest(AbstractModel):
    """CreateSystemVulExportJob请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为50000，最大值为50000
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>OnlyAffectedContainer- string - 是否必填：否 - 仅展示影响容器的漏洞true,false</li>
<li>OnlyAffectedNewestImage-string - 是否必填：否 - 仅展示影响最新版本镜像的漏洞true,false</li>
<li>Level- String - 是否必填：否 - 威胁等级，CRITICAL:严重 HIGH:高/MIDDLE:中/LOW:低</li>
<li>Tags- string - 是否必填：否 - 漏洞标签，POC，EXP。</li>
<li>CanBeFixed- string - 是否必填：否 - 是否可修复true,false。</li>
<li>CategoryType- string - 是否必填：否 - 漏洞子类型</li>
<li>CVEID- string - 是否必填：否 - CVE编号</li>
<li>ImageID- string - 是否必填：否 - 镜像ID</li>
<li>ImageName- String -是否必填: 否 - 镜像名称</li>
<li>ContainerID- string -是否必填: 否 - 容器ID</li>
<li>ContainerName- string -是否必填: 否 - 容器名称</li>
<li>ComponentName- string -是否必填: 否 - 组件名称</li>
<li>ComponentVersion- string -是否必填: 否 - 组件版本</li>
<li>Name- string -是否必填: 否 - 漏洞名称</li>
<li>FocusOnType - string - 是否必填：否 -关注紧急度类型 。ALL :全部，SERIOUS_LEVEL： 严重和高危 ，IS_SUGGEST： 重点关注，POC_EXP 有Poc或Exp ，NETWORK_EXP: 远程Exp</li>
        :type Filters: list of RunTimeFilters
        :param _Order: 排序方式
        :type Order: str
        :param _By: 排序字段
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSystemVulExportJobResponse(AbstractModel):
    """CreateSystemVulExportJob返回参数结构体

    """

    def __init__(self):
        r"""
        :param _JobId: 导出任务ID，前端拿着任务ID查询任务进度
        :type JobId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateVirusScanAgainRequest(AbstractModel):
    """CreateVirusScanAgain请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _ContainerIds: 需要扫描的容器id集合
        :type ContainerIds: list of str
        :param _TimeoutAll: 是否是扫描全部超时的
        :type TimeoutAll: bool
        :param _Timeout: 重新设置的超时时长
        :type Timeout: int
        """
        self._TaskId = None
        self._ContainerIds = None
        self._TimeoutAll = None
        self._Timeout = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ContainerIds(self):
        return self._ContainerIds

    @ContainerIds.setter
    def ContainerIds(self, ContainerIds):
        self._ContainerIds = ContainerIds

    @property
    def TimeoutAll(self):
        return self._TimeoutAll

    @TimeoutAll.setter
    def TimeoutAll(self, TimeoutAll):
        self._TimeoutAll = TimeoutAll

    @property
    def Timeout(self):
        return self._Timeout

    @Timeout.setter
    def Timeout(self, Timeout):
        self._Timeout = Timeout


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ContainerIds = params.get("ContainerIds")
        self._TimeoutAll = params.get("TimeoutAll")
        self._Timeout = params.get("Timeout")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVirusScanAgainResponse(AbstractModel):
    """CreateVirusScanAgain返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateVirusScanTaskRequest(AbstractModel):
    """CreateVirusScanTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ScanPathAll: 是否扫描所有路径
        :type ScanPathAll: bool
        :param _ScanRangeType: 扫描范围0容器1主机节点
        :type ScanRangeType: int
        :param _ScanRangeAll: true 全选，false 自选
        :type ScanRangeAll: bool
        :param _Timeout: 超时时长，单位小时
        :type Timeout: int
        :param _ScanPathType: 当ScanPathAll为false生效 0扫描以下路径 1、扫描除以下路径
        :type ScanPathType: int
        :param _ScanIds: 自选扫描范围的容器id或者主机id 根据ScanRangeType决定
        :type ScanIds: list of str
        :param _ScanPath: 自选排除或扫描的地址
        :type ScanPath: list of str
        :param _ScanPathMode: 扫描路径模式：
SCAN_PATH_ALL：全部路径
SCAN_PATH_DEFAULT：默认路径
SCAN_PATH_USER_DEFINE：用户自定义路径

        :type ScanPathMode: str
        """
        self._ScanPathAll = None
        self._ScanRangeType = None
        self._ScanRangeAll = None
        self._Timeout = None
        self._ScanPathType = None
        self._ScanIds = None
        self._ScanPath = None
        self._ScanPathMode = None

    @property
    def ScanPathAll(self):
        return self._ScanPathAll

    @ScanPathAll.setter
    def ScanPathAll(self, ScanPathAll):
        self._ScanPathAll = ScanPathAll

    @property
    def ScanRangeType(self):
        return self._ScanRangeType

    @ScanRangeType.setter
    def ScanRangeType(self, ScanRangeType):
        self._ScanRangeType = ScanRangeType

    @property
    def ScanRangeAll(self):
        return self._ScanRangeAll

    @ScanRangeAll.setter
    def ScanRangeAll(self, ScanRangeAll):
        self._ScanRangeAll = ScanRangeAll

    @property
    def Timeout(self):
        return self._Timeout

    @Timeout.setter
    def Timeout(self, Timeout):
        self._Timeout = Timeout

    @property
    def ScanPathType(self):
        return self._ScanPathType

    @ScanPathType.setter
    def ScanPathType(self, ScanPathType):
        self._ScanPathType = ScanPathType

    @property
    def ScanIds(self):
        return self._ScanIds

    @ScanIds.setter
    def ScanIds(self, ScanIds):
        self._ScanIds = ScanIds

    @property
    def ScanPath(self):
        return self._ScanPath

    @ScanPath.setter
    def ScanPath(self, ScanPath):
        self._ScanPath = ScanPath

    @property
    def ScanPathMode(self):
        return self._ScanPathMode

    @ScanPathMode.setter
    def ScanPathMode(self, ScanPathMode):
        self._ScanPathMode = ScanPathMode


    def _deserialize(self, params):
        self._ScanPathAll = params.get("ScanPathAll")
        self._ScanRangeType = params.get("ScanRangeType")
        self._ScanRangeAll = params.get("ScanRangeAll")
        self._Timeout = params.get("Timeout")
        self._ScanPathType = params.get("ScanPathType")
        self._ScanIds = params.get("ScanIds")
        self._ScanPath = params.get("ScanPath")
        self._ScanPathMode = params.get("ScanPathMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVirusScanTaskResponse(AbstractModel):
    """CreateVirusScanTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskID: 任务id
        :type TaskID: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskID = None
        self._RequestId = None

    @property
    def TaskID(self):
        return self._TaskID

    @TaskID.setter
    def TaskID(self, TaskID):
        self._TaskID = TaskID

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskID = params.get("TaskID")
        self._RequestId = params.get("RequestId")


class CreateVulContainerExportJobRequest(AbstractModel):
    """CreateVulContainerExportJob请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PocID: 漏洞PocID
        :type PocID: str
        :param _Limit: 需要返回的数量，默认为50000，最大值为50000
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>OnlyAffectedNewestImage- Bool- 是否必填：否 - 仅展示影响最新版本镜像的漏洞</li>
<li>ContainerID- string - 是否必填：否 - 容器ID</li>
<li>ContainerName- String -是否必填: 否 - 容器名称</li>
        :type Filters: list of RunTimeFilters
        """
        self._PocID = None
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def PocID(self):
        return self._PocID

    @PocID.setter
    def PocID(self, PocID):
        self._PocID = PocID

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._PocID = params.get("PocID")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVulContainerExportJobResponse(AbstractModel):
    """CreateVulContainerExportJob返回参数结构体

    """

    def __init__(self):
        r"""
        :param _JobId: 导出任务ID，前端拿着任务ID查询任务进度
        :type JobId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateVulDefenceEventExportJobRequest(AbstractModel):
    """CreateVulDefenceEventExportJob请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li>Status- String - 是否必填：否 - 插件状态，待处理：EVENT_UNDEAL，EVENT_DEALED：已处理，已忽略：EVENT_IGNORE， EVENT_DEFENDED：已防御</li>
<li>ContainerStatus- String - 是否必填：否 - 容器运行状态筛选，已创建：CREATED,正常运行：RUNNING, 暂定运行：PAUSED, 停止运行：	STOPPED，重启中：RESTARTING, 迁移中：REMOVING, 销毁：DESTROYED </li>
<li>ContainerNetStatus- String -是否必填: 否 -  容器网络状态筛选 未隔离：NORMAL，已隔离：ISOLATED，隔离失败：ISOLATE_FAILED，解除隔离失败：RESTORE_FAILED，解除隔离中：RESTORING，隔离中：ISOLATING</li>
<li>EventType - String -是否必填: 否 -  入侵状态，防御成功：EVENT_DEFENDED，尝试攻击：EVENT_ATTACK </li>
<li>TimeRange- String -是否必填: 否 -  时间范围，第一个值表示开始时间，第二个值表示结束时间 </li>
<li>VulName- string - 是否必填：否 - 漏洞名称。</li>
<li>CVEID- string - 是否必填：否 - CVE编号。</li>
<li>SourceIP- string - 是否必填：否 - 攻击源IP。</li>
<li>ContainerName- string - 是否必填：否 - 容器名称。</li>
<li>ContainerID- string - 是否必填：否 - 容器ID。</li>
<li>ImageName- string - 是否必填：否 - 镜像名称。</li>
<li>ImageID- string - 是否必填：否 - 镜像ID。</li>
<li>HostName- string - 是否必填：否 - 主机名称。</li>
<li>HostIP- string - 是否必填：否 - 内网IP。</li>
        :type Filters: list of RunTimeFilters
        :param _Limit: 需要返回的数量，最大值为100000
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Order: 排序方式：asc/desc
        :type Order: str
        :param _By: 排序字段：事件数量：EventCount
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVulDefenceEventExportJobResponse(AbstractModel):
    """CreateVulDefenceEventExportJob返回参数结构体

    """

    def __init__(self):
        r"""
        :param _JobId: 导出任务ID，前端拿着任务ID查询任务进度
        :type JobId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateVulDefenceHostExportJobRequest(AbstractModel):
    """CreateVulDefenceHostExportJob请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li>Status- String - 是否必填：否 - 插件状态，正常：SUCCESS，异常：FAIL， NO_DEFENCE:未防御</li>
<li>KeyWords- string - 是否必填：否 - 主机名称/IP。</li>
        :type Filters: list of RunTimeFilters
        :param _Limit: 需要返回的数量，最大值为100000
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Order: 排序方式：asc/desc
        :type Order: str
        :param _By: 排序字段：更新时间：ModifyTime/首次开启时间：CreateTime
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVulDefenceHostExportJobResponse(AbstractModel):
    """CreateVulDefenceHostExportJob返回参数结构体

    """

    def __init__(self):
        r"""
        :param _JobId: 导出任务ID，前端拿着任务ID查询任务进度
        :type JobId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateVulExportJobRequest(AbstractModel):
    """CreateVulExportJob请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ImageID: 镜像ID
        :type ImageID: str
        :param _ExportField: 导出字段
        :type ExportField: list of str
        :param _Limit: 需要返回的数量，默认为10000，最大值为10000
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>ComponentName- String - 是否必填：否 - 镜像组件名称</li><li>ComponentVersion- String - 是否必填：否 - 镜像组件版本</li><li>ComponentType- String - 是否必填：否 - 镜像组件类型</li><li>VulLevel- String - 是否必填：否 - 漏洞威胁等级</li><li>HasVul- String - 是否必填：否 -是否有漏洞；true：是，false，否；不传或ALL ：全部</li>
        :type Filters: list of AssetFilters
        :param _By: 排序字段
        :type By: str
        :param _Order: 排序方式desc ，asc
        :type Order: str
        """
        self._ImageID = None
        self._ExportField = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._ImageID = params.get("ImageID")
        self._ExportField = params.get("ExportField")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVulExportJobResponse(AbstractModel):
    """CreateVulExportJob返回参数结构体

    """

    def __init__(self):
        r"""
        :param _JobId: 导出任务ID，前端拿着任务ID查询任务进度
        :type JobId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateVulImageExportJobRequest(AbstractModel):
    """CreateVulImageExportJob请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PocID: 漏洞PocID
        :type PocID: str
        :param _Limit: 需要返回的数量，默认为50000，最大值为50000
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>OnlyAffectedNewestImage- Bool- 是否必填：否 - 仅展示影响最新版本镜像的漏洞</li>
<li>ImageID- string - 是否必填：否 - 镜像ID</li>
<li>ImageName- String -是否必填: 否 - 镜像名称</li>
<li>ClientIP- string -是否必填: 否 - 内网IP</li>
<li>PublicIP- string -是否必填: 否 - 外网IP</li>
<li>ComponentName- string -是否必填: 否 - 组件名称</li>
<li>ComponentVersion- string -是否必填: 否 - 组件版本</li>
<li>HostName- string -是否必填: 否 - 主机名称</li>
        :type Filters: list of RunTimeFilters
        :param _Order: 排序方式
        :type Order: str
        :param _By: 排序字段
        :type By: str
        """
        self._PocID = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def PocID(self):
        return self._PocID

    @PocID.setter
    def PocID(self, PocID):
        self._PocID = PocID

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._PocID = params.get("PocID")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVulImageExportJobResponse(AbstractModel):
    """CreateVulImageExportJob返回参数结构体

    """

    def __init__(self):
        r"""
        :param _JobId: 导出任务ID，前端拿着任务ID查询任务进度
        :type JobId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateVulScanTaskRequest(AbstractModel):
    """CreateVulScanTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _LocalImageScanType: 本地镜像扫描范围类型。ALL:全部本地镜像，NOT_SCAN：全部已授权未扫描本地镜像，IMAGEIDS:自选本地镜像ID
        :type LocalImageScanType: str
        :param _LocalImageIDs: 根据已授权的本地镜像IDs扫描，优先权高于根据满足条件的已授权的本地镜像。
        :type LocalImageIDs: list of str
        :param _RegistryImageScanType: 仓库镜像扫描范围类型。ALL:全部仓库镜像，NOT_SCAN：全部已授权未扫描仓库镜像，IMAGEIDS:自选仓库镜像ID
        :type RegistryImageScanType: str
        :param _RegistryImageIDs: 根据已授权的仓库镜像IDs扫描，优先权高于根据满足条件的已授权的仓库镜像。
        :type RegistryImageIDs: list of int non-negative
        :param _LocalTaskID: 本地镜像重新漏洞扫描时的任务ID
        :type LocalTaskID: int
        :param _RegistryTaskID: 仓库镜像重新漏洞扫描时的任务ID
        :type RegistryTaskID: int
        """
        self._LocalImageScanType = None
        self._LocalImageIDs = None
        self._RegistryImageScanType = None
        self._RegistryImageIDs = None
        self._LocalTaskID = None
        self._RegistryTaskID = None

    @property
    def LocalImageScanType(self):
        return self._LocalImageScanType

    @LocalImageScanType.setter
    def LocalImageScanType(self, LocalImageScanType):
        self._LocalImageScanType = LocalImageScanType

    @property
    def LocalImageIDs(self):
        return self._LocalImageIDs

    @LocalImageIDs.setter
    def LocalImageIDs(self, LocalImageIDs):
        self._LocalImageIDs = LocalImageIDs

    @property
    def RegistryImageScanType(self):
        return self._RegistryImageScanType

    @RegistryImageScanType.setter
    def RegistryImageScanType(self, RegistryImageScanType):
        self._RegistryImageScanType = RegistryImageScanType

    @property
    def RegistryImageIDs(self):
        return self._RegistryImageIDs

    @RegistryImageIDs.setter
    def RegistryImageIDs(self, RegistryImageIDs):
        self._RegistryImageIDs = RegistryImageIDs

    @property
    def LocalTaskID(self):
        return self._LocalTaskID

    @LocalTaskID.setter
    def LocalTaskID(self, LocalTaskID):
        self._LocalTaskID = LocalTaskID

    @property
    def RegistryTaskID(self):
        return self._RegistryTaskID

    @RegistryTaskID.setter
    def RegistryTaskID(self, RegistryTaskID):
        self._RegistryTaskID = RegistryTaskID


    def _deserialize(self, params):
        self._LocalImageScanType = params.get("LocalImageScanType")
        self._LocalImageIDs = params.get("LocalImageIDs")
        self._RegistryImageScanType = params.get("RegistryImageScanType")
        self._RegistryImageIDs = params.get("RegistryImageIDs")
        self._LocalTaskID = params.get("LocalTaskID")
        self._RegistryTaskID = params.get("RegistryTaskID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVulScanTaskResponse(AbstractModel):
    """CreateVulScanTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _LocalTaskID: 本地镜像重新漏洞扫描时的任务ID
        :type LocalTaskID: int
        :param _RegistryTaskID: 仓库镜像重新漏洞扫描时的任务ID
        :type RegistryTaskID: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._LocalTaskID = None
        self._RegistryTaskID = None
        self._RequestId = None

    @property
    def LocalTaskID(self):
        return self._LocalTaskID

    @LocalTaskID.setter
    def LocalTaskID(self, LocalTaskID):
        self._LocalTaskID = LocalTaskID

    @property
    def RegistryTaskID(self):
        return self._RegistryTaskID

    @RegistryTaskID.setter
    def RegistryTaskID(self, RegistryTaskID):
        self._RegistryTaskID = RegistryTaskID

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._LocalTaskID = params.get("LocalTaskID")
        self._RegistryTaskID = params.get("RegistryTaskID")
        self._RequestId = params.get("RequestId")


class CreateWebVulExportJobRequest(AbstractModel):
    """CreateWebVulExportJob请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为50000，最大值为50000
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>OnlyAffectedContainer- string - 是否必填：否 - 仅展示影响容器的漏洞true,false</li>
<li>OnlyAffectedNewestImage-string - 是否必填：否 - 仅展示影响最新版本镜像的漏洞true,false</li>
<li>Level- String - 是否必填：否 - 威胁等级，CRITICAL:严重 HIGH:高/MIDDLE:中/LOW:低</li>
<li>Tags- string - 是否必填：否 - 漏洞标签，POC，EXP。</li>
<li>CanBeFixed- string - 是否必填：否 - 是否可修复true,false。</li>
<li>CategoryType- string - 是否必填：否 - 漏洞子类型</li>
<li>CVEID- string - 是否必填：否 - CVE编号</li>
<li>ImageID- string - 是否必填：否 - 镜像ID</li>
<li>ImageName- String -是否必填: 否 - 镜像名称</li>
<li>ContainerID- string -是否必填: 否 - 容器ID</li>
<li>ContainerName- string -是否必填: 否 - 容器名称</li>
<li>ComponentName- string -是否必填: 否 - 组件名称</li>
<li>ComponentVersion- string -是否必填: 否 - 组件版本</li>
<li>Name- string -是否必填: 否 - 漏洞名称</li>
<li>FocusOnType - string - 是否必填：否 -关注紧急度类型 。ALL :全部，SERIOUS_LEVEL： 严重和高危 ，IS_SUGGEST： 重点关注，POC_EXP 有Poc或Exp ，NETWORK_EXP: 远程Exp</li>
        :type Filters: list of RunTimeFilters
        :param _Order: 排序方式
        :type Order: str
        :param _By: 排序字段
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWebVulExportJobResponse(AbstractModel):
    """CreateWebVulExportJob返回参数结构体

    """

    def __init__(self):
        r"""
        :param _JobId: 导出任务ID，前端拿着任务ID查询任务进度
        :type JobId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class DeleteAbnormalProcessRulesRequest(AbstractModel):
    """DeleteAbnormalProcessRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleIdSet: 策略的ids
        :type RuleIdSet: list of str
        """
        self._RuleIdSet = None

    @property
    def RuleIdSet(self):
        return self._RuleIdSet

    @RuleIdSet.setter
    def RuleIdSet(self, RuleIdSet):
        self._RuleIdSet = RuleIdSet


    def _deserialize(self, params):
        self._RuleIdSet = params.get("RuleIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAbnormalProcessRulesResponse(AbstractModel):
    """DeleteAbnormalProcessRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAccessControlRulesRequest(AbstractModel):
    """DeleteAccessControlRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleIdSet: 策略的ids
        :type RuleIdSet: list of str
        """
        self._RuleIdSet = None

    @property
    def RuleIdSet(self):
        return self._RuleIdSet

    @RuleIdSet.setter
    def RuleIdSet(self, RuleIdSet):
        self._RuleIdSet = RuleIdSet


    def _deserialize(self, params):
        self._RuleIdSet = params.get("RuleIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAccessControlRulesResponse(AbstractModel):
    """DeleteAccessControlRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteComplianceAssetPolicySetFromWhitelistRequest(AbstractModel):
    """DeleteComplianceAssetPolicySetFromWhitelist请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AssetItemId: 资产ID
        :type AssetItemId: int
        :param _CustomerPolicyItemIdSet: 需要忽略指定资产内的检查项ID列表
        :type CustomerPolicyItemIdSet: list of int non-negative
        """
        self._AssetItemId = None
        self._CustomerPolicyItemIdSet = None

    @property
    def AssetItemId(self):
        return self._AssetItemId

    @AssetItemId.setter
    def AssetItemId(self, AssetItemId):
        self._AssetItemId = AssetItemId

    @property
    def CustomerPolicyItemIdSet(self):
        return self._CustomerPolicyItemIdSet

    @CustomerPolicyItemIdSet.setter
    def CustomerPolicyItemIdSet(self, CustomerPolicyItemIdSet):
        self._CustomerPolicyItemIdSet = CustomerPolicyItemIdSet


    def _deserialize(self, params):
        self._AssetItemId = params.get("AssetItemId")
        self._CustomerPolicyItemIdSet = params.get("CustomerPolicyItemIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteComplianceAssetPolicySetFromWhitelistResponse(AbstractModel):
    """DeleteComplianceAssetPolicySetFromWhitelist返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteCompliancePolicyAssetSetFromWhitelistRequest(AbstractModel):
    """DeleteCompliancePolicyAssetSetFromWhitelist请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PolicyAssetSetList: （检查项ID+资产ID列表）的列表
        :type PolicyAssetSetList: list of CompliancePolicyAssetSetItem
        """
        self._PolicyAssetSetList = None

    @property
    def PolicyAssetSetList(self):
        return self._PolicyAssetSetList

    @PolicyAssetSetList.setter
    def PolicyAssetSetList(self, PolicyAssetSetList):
        self._PolicyAssetSetList = PolicyAssetSetList


    def _deserialize(self, params):
        if params.get("PolicyAssetSetList") is not None:
            self._PolicyAssetSetList = []
            for item in params.get("PolicyAssetSetList"):
                obj = CompliancePolicyAssetSetItem()
                obj._deserialize(item)
                self._PolicyAssetSetList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCompliancePolicyAssetSetFromWhitelistResponse(AbstractModel):
    """DeleteCompliancePolicyAssetSetFromWhitelist返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteCompliancePolicyItemFromWhitelistRequest(AbstractModel):
    """DeleteCompliancePolicyItemFromWhitelist请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WhitelistIdSet: 指定的白名单项的ID的列表
        :type WhitelistIdSet: list of int non-negative
        """
        self._WhitelistIdSet = None

    @property
    def WhitelistIdSet(self):
        return self._WhitelistIdSet

    @WhitelistIdSet.setter
    def WhitelistIdSet(self, WhitelistIdSet):
        self._WhitelistIdSet = WhitelistIdSet


    def _deserialize(self, params):
        self._WhitelistIdSet = params.get("WhitelistIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCompliancePolicyItemFromWhitelistResponse(AbstractModel):
    """DeleteCompliancePolicyItemFromWhitelist返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteEscapeWhiteListRequest(AbstractModel):
    """DeleteEscapeWhiteList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _IDSet: 白名单记录ID数组
        :type IDSet: list of int
        """
        self._IDSet = None

    @property
    def IDSet(self):
        return self._IDSet

    @IDSet.setter
    def IDSet(self, IDSet):
        self._IDSet = IDSet


    def _deserialize(self, params):
        self._IDSet = params.get("IDSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteEscapeWhiteListResponse(AbstractModel):
    """DeleteEscapeWhiteList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteIgnoreVulRequest(AbstractModel):
    """DeleteIgnoreVul请求参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 漏洞PocID 信息列表
        :type List: list of ModifyIgnoreVul
        """
        self._List = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ModifyIgnoreVul()
                obj._deserialize(item)
                self._List.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteIgnoreVulResponse(AbstractModel):
    """DeleteIgnoreVul返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteK8sApiAbnormalRuleRequest(AbstractModel):
    """DeleteK8sApiAbnormalRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleIDSet: 规则ID集合
        :type RuleIDSet: list of str
        """
        self._RuleIDSet = None

    @property
    def RuleIDSet(self):
        return self._RuleIDSet

    @RuleIDSet.setter
    def RuleIDSet(self, RuleIDSet):
        self._RuleIDSet = RuleIDSet


    def _deserialize(self, params):
        self._RuleIDSet = params.get("RuleIDSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteK8sApiAbnormalRuleResponse(AbstractModel):
    """DeleteK8sApiAbnormalRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteMachineRequest(AbstractModel):
    """DeleteMachine请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Uuid: 客户端Uuid
        :type Uuid: str
        """
        self._Uuid = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteMachineResponse(AbstractModel):
    """DeleteMachine返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNetworkFirewallPolicyDetailRequest(AbstractModel):
    """DeleteNetworkFirewallPolicyDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群Id
        :type ClusterId: str
        :param _Id: 策略Id数组
        :type Id: list of int non-negative
        """
        self._ClusterId = None
        self._Id = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNetworkFirewallPolicyDetailResponse(AbstractModel):
    """DeleteNetworkFirewallPolicyDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 返回创建的任务的ID，为0表示创建失败。
        :type TaskId: int
        :param _Result: 创建删除任务的结果，"Succ"为成功，"Failed"为失败
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._Result = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DeleteReverseShellEventsRequest(AbstractModel):
    """DeleteReverseShellEvents请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventIdSet: 事件ids
        :type EventIdSet: list of str
        """
        self._EventIdSet = None

    @property
    def EventIdSet(self):
        return self._EventIdSet

    @EventIdSet.setter
    def EventIdSet(self, EventIdSet):
        self._EventIdSet = EventIdSet


    def _deserialize(self, params):
        self._EventIdSet = params.get("EventIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteReverseShellEventsResponse(AbstractModel):
    """DeleteReverseShellEvents返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteReverseShellWhiteListsRequest(AbstractModel):
    """DeleteReverseShellWhiteLists请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WhiteListIdSet: 白名单ids
        :type WhiteListIdSet: list of str
        """
        self._WhiteListIdSet = None

    @property
    def WhiteListIdSet(self):
        return self._WhiteListIdSet

    @WhiteListIdSet.setter
    def WhiteListIdSet(self, WhiteListIdSet):
        self._WhiteListIdSet = WhiteListIdSet


    def _deserialize(self, params):
        self._WhiteListIdSet = params.get("WhiteListIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteReverseShellWhiteListsResponse(AbstractModel):
    """DeleteReverseShellWhiteLists返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRiskSyscallEventsRequest(AbstractModel):
    """DeleteRiskSyscallEvents请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventIdSet: 事件ids
        :type EventIdSet: list of str
        """
        self._EventIdSet = None

    @property
    def EventIdSet(self):
        return self._EventIdSet

    @EventIdSet.setter
    def EventIdSet(self, EventIdSet):
        self._EventIdSet = EventIdSet


    def _deserialize(self, params):
        self._EventIdSet = params.get("EventIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRiskSyscallEventsResponse(AbstractModel):
    """DeleteRiskSyscallEvents返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRiskSyscallWhiteListsRequest(AbstractModel):
    """DeleteRiskSyscallWhiteLists请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WhiteListIdSet: 白名单ids
        :type WhiteListIdSet: list of str
        """
        self._WhiteListIdSet = None

    @property
    def WhiteListIdSet(self):
        return self._WhiteListIdSet

    @WhiteListIdSet.setter
    def WhiteListIdSet(self, WhiteListIdSet):
        self._WhiteListIdSet = WhiteListIdSet


    def _deserialize(self, params):
        self._WhiteListIdSet = params.get("WhiteListIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRiskSyscallWhiteListsResponse(AbstractModel):
    """DeleteRiskSyscallWhiteLists返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSearchTemplateRequest(AbstractModel):
    """DeleteSearchTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 模板ID
        :type Id: int
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSearchTemplateResponse(AbstractModel):
    """DeleteSearchTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeABTestConfigRequest(AbstractModel):
    """DescribeABTestConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectName: 灰度项目名称
        :type ProjectName: str
        """
        self._ProjectName = None

    @property
    def ProjectName(self):
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName


    def _deserialize(self, params):
        self._ProjectName = params.get("ProjectName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeABTestConfigResponse(AbstractModel):
    """DescribeABTestConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Config: 灰度项目配置
        :type Config: list of ABTestConfig
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Config = None
        self._RequestId = None

    @property
    def Config(self):
        return self._Config

    @Config.setter
    def Config(self, Config):
        self._Config = Config

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Config") is not None:
            self._Config = []
            for item in params.get("Config"):
                obj = ABTestConfig()
                obj._deserialize(item)
                self._Config.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAbnormalProcessDetailRequest(AbstractModel):
    """DescribeAbnormalProcessDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventId: 事件唯一id
        :type EventId: str
        """
        self._EventId = None

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId


    def _deserialize(self, params):
        self._EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAbnormalProcessDetailResponse(AbstractModel):
    """DescribeAbnormalProcessDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _EventBaseInfo: 事件基本信息
        :type EventBaseInfo: :class:`tencentcloud.tcss.v20201101.models.RunTimeEventBaseInfo`
        :param _ProcessInfo: 进程信息
        :type ProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessDetailInfo`
        :param _ParentProcessInfo: 父进程信息
        :type ParentProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessDetailBaseInfo`
        :param _EventDetail: 事件描述
        :type EventDetail: :class:`tencentcloud.tcss.v20201101.models.AbnormalProcessEventDescription`
        :param _AncestorProcessInfo: 祖先进程信息
注意：此字段可能返回 null，表示取不到有效值。
        :type AncestorProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessBaseInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._EventBaseInfo = None
        self._ProcessInfo = None
        self._ParentProcessInfo = None
        self._EventDetail = None
        self._AncestorProcessInfo = None
        self._RequestId = None

    @property
    def EventBaseInfo(self):
        return self._EventBaseInfo

    @EventBaseInfo.setter
    def EventBaseInfo(self, EventBaseInfo):
        self._EventBaseInfo = EventBaseInfo

    @property
    def ProcessInfo(self):
        return self._ProcessInfo

    @ProcessInfo.setter
    def ProcessInfo(self, ProcessInfo):
        self._ProcessInfo = ProcessInfo

    @property
    def ParentProcessInfo(self):
        return self._ParentProcessInfo

    @ParentProcessInfo.setter
    def ParentProcessInfo(self, ParentProcessInfo):
        self._ParentProcessInfo = ParentProcessInfo

    @property
    def EventDetail(self):
        return self._EventDetail

    @EventDetail.setter
    def EventDetail(self, EventDetail):
        self._EventDetail = EventDetail

    @property
    def AncestorProcessInfo(self):
        return self._AncestorProcessInfo

    @AncestorProcessInfo.setter
    def AncestorProcessInfo(self, AncestorProcessInfo):
        self._AncestorProcessInfo = AncestorProcessInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EventBaseInfo") is not None:
            self._EventBaseInfo = RunTimeEventBaseInfo()
            self._EventBaseInfo._deserialize(params.get("EventBaseInfo"))
        if params.get("ProcessInfo") is not None:
            self._ProcessInfo = ProcessDetailInfo()
            self._ProcessInfo._deserialize(params.get("ProcessInfo"))
        if params.get("ParentProcessInfo") is not None:
            self._ParentProcessInfo = ProcessDetailBaseInfo()
            self._ParentProcessInfo._deserialize(params.get("ParentProcessInfo"))
        if params.get("EventDetail") is not None:
            self._EventDetail = AbnormalProcessEventDescription()
            self._EventDetail._deserialize(params.get("EventDetail"))
        if params.get("AncestorProcessInfo") is not None:
            self._AncestorProcessInfo = ProcessBaseInfo()
            self._AncestorProcessInfo._deserialize(params.get("AncestorProcessInfo"))
        self._RequestId = params.get("RequestId")


class DescribeAbnormalProcessEventTendencyRequest(AbstractModel):
    """DescribeAbnormalProcessEventTendency请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        """
        self._StartTime = None
        self._EndTime = None

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAbnormalProcessEventTendencyResponse(AbstractModel):
    """DescribeAbnormalProcessEventTendency返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 待处理异常进程事件趋势
        :type List: list of AbnormalProcessEventTendencyInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = AbnormalProcessEventTendencyInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAbnormalProcessEventsExportRequest(AbstractModel):
    """DescribeAbnormalProcessEventsExport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ExportField: 导出字段
        :type ExportField: list of str
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤参数,"Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param _Order: 升序降序,asc desc
        :type Order: str
        :param _By: 排序字段
        :type By: str
        """
        self._ExportField = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._ExportField = params.get("ExportField")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAbnormalProcessEventsExportResponse(AbstractModel):
    """DescribeAbnormalProcessEventsExport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: execle下载地址
注意：此字段可能返回 null，表示取不到有效值。
        :type DownloadUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._RequestId = params.get("RequestId")


class DescribeAbnormalProcessEventsRequest(AbstractModel):
    """DescribeAbnormalProcessEvents请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤参数,"Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param _Order: 升序降序,asc desc
        :type Order: str
        :param _By: 排序字段
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAbnormalProcessEventsResponse(AbstractModel):
    """DescribeAbnormalProcessEvents返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 事件总数量
        :type TotalCount: int
        :param _EventSet: 异常进程数组
        :type EventSet: list of AbnormalProcessEventInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._EventSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def EventSet(self):
        return self._EventSet

    @EventSet.setter
    def EventSet(self, EventSet):
        self._EventSet = EventSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("EventSet") is not None:
            self._EventSet = []
            for item in params.get("EventSet"):
                obj = AbnormalProcessEventInfo()
                obj._deserialize(item)
                self._EventSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAbnormalProcessLevelSummaryRequest(AbstractModel):
    """DescribeAbnormalProcessLevelSummary请求参数结构体

    """


class DescribeAbnormalProcessLevelSummaryResponse(AbstractModel):
    """DescribeAbnormalProcessLevelSummary返回参数结构体

    """

    def __init__(self):
        r"""
        :param _HighLevelEventCount: 异常进程高危待处理事件数
        :type HighLevelEventCount: int
        :param _MediumLevelEventCount: 异常进程中危待处理事件数
        :type MediumLevelEventCount: int
        :param _LowLevelEventCount: 异常进程低危待处理事件数
        :type LowLevelEventCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._HighLevelEventCount = None
        self._MediumLevelEventCount = None
        self._LowLevelEventCount = None
        self._RequestId = None

    @property
    def HighLevelEventCount(self):
        return self._HighLevelEventCount

    @HighLevelEventCount.setter
    def HighLevelEventCount(self, HighLevelEventCount):
        self._HighLevelEventCount = HighLevelEventCount

    @property
    def MediumLevelEventCount(self):
        return self._MediumLevelEventCount

    @MediumLevelEventCount.setter
    def MediumLevelEventCount(self, MediumLevelEventCount):
        self._MediumLevelEventCount = MediumLevelEventCount

    @property
    def LowLevelEventCount(self):
        return self._LowLevelEventCount

    @LowLevelEventCount.setter
    def LowLevelEventCount(self, LowLevelEventCount):
        self._LowLevelEventCount = LowLevelEventCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._HighLevelEventCount = params.get("HighLevelEventCount")
        self._MediumLevelEventCount = params.get("MediumLevelEventCount")
        self._LowLevelEventCount = params.get("LowLevelEventCount")
        self._RequestId = params.get("RequestId")


class DescribeAbnormalProcessRuleDetailRequest(AbstractModel):
    """DescribeAbnormalProcessRuleDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleId: 策略唯一id
        :type RuleId: str
        :param _ImageId: 镜像id, 在添加白名单的时候使用
        :type ImageId: str
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        """
        self._RuleId = None
        self._ImageId = None
        self._Limit = None
        self._Offset = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def ImageId(self):
        return self._ImageId

    @ImageId.setter
    def ImageId(self, ImageId):
        self._ImageId = ImageId

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._ImageId = params.get("ImageId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAbnormalProcessRuleDetailResponse(AbstractModel):
    """DescribeAbnormalProcessRuleDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleDetail: 异常进程策略详细信息
        :type RuleDetail: :class:`tencentcloud.tcss.v20201101.models.AbnormalProcessRuleInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RuleDetail = None
        self._RequestId = None

    @property
    def RuleDetail(self):
        return self._RuleDetail

    @RuleDetail.setter
    def RuleDetail(self, RuleDetail):
        self._RuleDetail = RuleDetail

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RuleDetail") is not None:
            self._RuleDetail = AbnormalProcessRuleInfo()
            self._RuleDetail._deserialize(params.get("RuleDetail"))
        self._RequestId = params.get("RequestId")


class DescribeAbnormalProcessRulesExportRequest(AbstractModel):
    """DescribeAbnormalProcessRulesExport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ExportField: 导出字段
        :type ExportField: list of str
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤参数,"Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param _Order: 升序降序,asc desc
        :type Order: str
        :param _By: 排序字段
        :type By: str
        """
        self._ExportField = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._ExportField = params.get("ExportField")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAbnormalProcessRulesExportResponse(AbstractModel):
    """DescribeAbnormalProcessRulesExport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: execle下载地址
注意：此字段可能返回 null，表示取不到有效值。
        :type DownloadUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._RequestId = params.get("RequestId")


class DescribeAbnormalProcessRulesRequest(AbstractModel):
    """DescribeAbnormalProcessRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤参数,"Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param _Order: 升序降序,asc desc
        :type Order: str
        :param _By: 排序字段
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAbnormalProcessRulesResponse(AbstractModel):
    """DescribeAbnormalProcessRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 事件总数量
        :type TotalCount: int
        :param _RuleSet: 异常进程策略信息列表
        :type RuleSet: list of RuleBaseInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._RuleSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RuleSet(self):
        return self._RuleSet

    @RuleSet.setter
    def RuleSet(self, RuleSet):
        self._RuleSet = RuleSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RuleSet") is not None:
            self._RuleSet = []
            for item in params.get("RuleSet"):
                obj = RuleBaseInfo()
                obj._deserialize(item)
                self._RuleSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAccessControlDetailRequest(AbstractModel):
    """DescribeAccessControlDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventId: 事件唯一id
        :type EventId: str
        """
        self._EventId = None

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId


    def _deserialize(self, params):
        self._EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAccessControlDetailResponse(AbstractModel):
    """DescribeAccessControlDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _EventBaseInfo: 事件基本信息
        :type EventBaseInfo: :class:`tencentcloud.tcss.v20201101.models.RunTimeEventBaseInfo`
        :param _ProcessInfo: 进程信息
        :type ProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessDetailInfo`
        :param _TamperedFileInfo: 被篡改信息
        :type TamperedFileInfo: :class:`tencentcloud.tcss.v20201101.models.FileAttributeInfo`
        :param _EventDetail: 事件描述
        :type EventDetail: :class:`tencentcloud.tcss.v20201101.models.AccessControlEventDescription`
        :param _ParentProcessInfo: 父进程信息
        :type ParentProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessBaseInfo`
        :param _AncestorProcessInfo: 祖先进程信息
注意：此字段可能返回 null，表示取不到有效值。
        :type AncestorProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessBaseInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._EventBaseInfo = None
        self._ProcessInfo = None
        self._TamperedFileInfo = None
        self._EventDetail = None
        self._ParentProcessInfo = None
        self._AncestorProcessInfo = None
        self._RequestId = None

    @property
    def EventBaseInfo(self):
        return self._EventBaseInfo

    @EventBaseInfo.setter
    def EventBaseInfo(self, EventBaseInfo):
        self._EventBaseInfo = EventBaseInfo

    @property
    def ProcessInfo(self):
        return self._ProcessInfo

    @ProcessInfo.setter
    def ProcessInfo(self, ProcessInfo):
        self._ProcessInfo = ProcessInfo

    @property
    def TamperedFileInfo(self):
        return self._TamperedFileInfo

    @TamperedFileInfo.setter
    def TamperedFileInfo(self, TamperedFileInfo):
        self._TamperedFileInfo = TamperedFileInfo

    @property
    def EventDetail(self):
        return self._EventDetail

    @EventDetail.setter
    def EventDetail(self, EventDetail):
        self._EventDetail = EventDetail

    @property
    def ParentProcessInfo(self):
        return self._ParentProcessInfo

    @ParentProcessInfo.setter
    def ParentProcessInfo(self, ParentProcessInfo):
        self._ParentProcessInfo = ParentProcessInfo

    @property
    def AncestorProcessInfo(self):
        return self._AncestorProcessInfo

    @AncestorProcessInfo.setter
    def AncestorProcessInfo(self, AncestorProcessInfo):
        self._AncestorProcessInfo = AncestorProcessInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EventBaseInfo") is not None:
            self._EventBaseInfo = RunTimeEventBaseInfo()
            self._EventBaseInfo._deserialize(params.get("EventBaseInfo"))
        if params.get("ProcessInfo") is not None:
            self._ProcessInfo = ProcessDetailInfo()
            self._ProcessInfo._deserialize(params.get("ProcessInfo"))
        if params.get("TamperedFileInfo") is not None:
            self._TamperedFileInfo = FileAttributeInfo()
            self._TamperedFileInfo._deserialize(params.get("TamperedFileInfo"))
        if params.get("EventDetail") is not None:
            self._EventDetail = AccessControlEventDescription()
            self._EventDetail._deserialize(params.get("EventDetail"))
        if params.get("ParentProcessInfo") is not None:
            self._ParentProcessInfo = ProcessBaseInfo()
            self._ParentProcessInfo._deserialize(params.get("ParentProcessInfo"))
        if params.get("AncestorProcessInfo") is not None:
            self._AncestorProcessInfo = ProcessBaseInfo()
            self._AncestorProcessInfo._deserialize(params.get("AncestorProcessInfo"))
        self._RequestId = params.get("RequestId")


class DescribeAccessControlEventsExportRequest(AbstractModel):
    """DescribeAccessControlEventsExport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤参数,"Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param _Order: 升序降序,asc desc
        :type Order: str
        :param _By: 排序字段
        :type By: str
        :param _ExportField: 导出字段
        :type ExportField: list of str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None
        self._ExportField = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        self._ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAccessControlEventsExportResponse(AbstractModel):
    """DescribeAccessControlEventsExport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: execle下载地址
注意：此字段可能返回 null，表示取不到有效值。
        :type DownloadUrl: str
        :param _JobId: 任务id
注意：此字段可能返回 null，表示取不到有效值。
        :type JobId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._JobId = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class DescribeAccessControlEventsRequest(AbstractModel):
    """DescribeAccessControlEvents请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤参数,"Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param _Order: 升序降序,asc desc
        :type Order: str
        :param _By: 排序字段
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAccessControlEventsResponse(AbstractModel):
    """DescribeAccessControlEvents返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 事件总数量
        :type TotalCount: int
        :param _EventSet: 访问控制事件数组
        :type EventSet: list of AccessControlEventInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._EventSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def EventSet(self):
        return self._EventSet

    @EventSet.setter
    def EventSet(self, EventSet):
        self._EventSet = EventSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("EventSet") is not None:
            self._EventSet = []
            for item in params.get("EventSet"):
                obj = AccessControlEventInfo()
                obj._deserialize(item)
                self._EventSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAccessControlRuleDetailRequest(AbstractModel):
    """DescribeAccessControlRuleDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleId: 策略唯一id
        :type RuleId: str
        :param _ImageId: 镜像id, 仅仅在事件加白的时候使用
        :type ImageId: str
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        """
        self._RuleId = None
        self._ImageId = None
        self._Limit = None
        self._Offset = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def ImageId(self):
        return self._ImageId

    @ImageId.setter
    def ImageId(self, ImageId):
        self._ImageId = ImageId

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._ImageId = params.get("ImageId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAccessControlRuleDetailResponse(AbstractModel):
    """DescribeAccessControlRuleDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleDetail: 运行时策略详细信息
        :type RuleDetail: :class:`tencentcloud.tcss.v20201101.models.AccessControlRuleInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RuleDetail = None
        self._RequestId = None

    @property
    def RuleDetail(self):
        return self._RuleDetail

    @RuleDetail.setter
    def RuleDetail(self, RuleDetail):
        self._RuleDetail = RuleDetail

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RuleDetail") is not None:
            self._RuleDetail = AccessControlRuleInfo()
            self._RuleDetail._deserialize(params.get("RuleDetail"))
        self._RequestId = params.get("RequestId")


class DescribeAccessControlRulesExportRequest(AbstractModel):
    """DescribeAccessControlRulesExport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ExportField: 导出字段
        :type ExportField: list of str
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤参数,"Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param _Order: 升序降序,asc desc
        :type Order: str
        :param _By: 排序字段
        :type By: str
        """
        self._ExportField = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._ExportField = params.get("ExportField")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAccessControlRulesExportResponse(AbstractModel):
    """DescribeAccessControlRulesExport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: execle下载地址
注意：此字段可能返回 null，表示取不到有效值。
        :type DownloadUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._RequestId = params.get("RequestId")


class DescribeAccessControlRulesRequest(AbstractModel):
    """DescribeAccessControlRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤参数,"Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param _Order: 升序降序,asc desc
        :type Order: str
        :param _By: 排序字段
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAccessControlRulesResponse(AbstractModel):
    """DescribeAccessControlRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 事件总数量
        :type TotalCount: int
        :param _RuleSet: 访问控制策略信息列表
        :type RuleSet: list of RuleBaseInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._RuleSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RuleSet(self):
        return self._RuleSet

    @RuleSet.setter
    def RuleSet(self, RuleSet):
        self._RuleSet = RuleSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RuleSet") is not None:
            self._RuleSet = []
            for item in params.get("RuleSet"):
                obj = RuleBaseInfo()
                obj._deserialize(item)
                self._RuleSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAffectedClusterCountRequest(AbstractModel):
    """DescribeAffectedClusterCount请求参数结构体

    """


class DescribeAffectedClusterCountResponse(AbstractModel):
    """DescribeAffectedClusterCount返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SeriousRiskClusterCount: 严重风险的集群数量
        :type SeriousRiskClusterCount: int
        :param _HighRiskClusterCount: 高危风险的集群数量
        :type HighRiskClusterCount: int
        :param _MiddleRiskClusterCount: 中危风险的集群数量
        :type MiddleRiskClusterCount: int
        :param _HintRiskClusterCount: 低危风险的集群数量
        :type HintRiskClusterCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SeriousRiskClusterCount = None
        self._HighRiskClusterCount = None
        self._MiddleRiskClusterCount = None
        self._HintRiskClusterCount = None
        self._RequestId = None

    @property
    def SeriousRiskClusterCount(self):
        return self._SeriousRiskClusterCount

    @SeriousRiskClusterCount.setter
    def SeriousRiskClusterCount(self, SeriousRiskClusterCount):
        self._SeriousRiskClusterCount = SeriousRiskClusterCount

    @property
    def HighRiskClusterCount(self):
        return self._HighRiskClusterCount

    @HighRiskClusterCount.setter
    def HighRiskClusterCount(self, HighRiskClusterCount):
        self._HighRiskClusterCount = HighRiskClusterCount

    @property
    def MiddleRiskClusterCount(self):
        return self._MiddleRiskClusterCount

    @MiddleRiskClusterCount.setter
    def MiddleRiskClusterCount(self, MiddleRiskClusterCount):
        self._MiddleRiskClusterCount = MiddleRiskClusterCount

    @property
    def HintRiskClusterCount(self):
        return self._HintRiskClusterCount

    @HintRiskClusterCount.setter
    def HintRiskClusterCount(self, HintRiskClusterCount):
        self._HintRiskClusterCount = HintRiskClusterCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SeriousRiskClusterCount = params.get("SeriousRiskClusterCount")
        self._HighRiskClusterCount = params.get("HighRiskClusterCount")
        self._MiddleRiskClusterCount = params.get("MiddleRiskClusterCount")
        self._HintRiskClusterCount = params.get("HintRiskClusterCount")
        self._RequestId = params.get("RequestId")


class DescribeAffectedNodeListRequest(AbstractModel):
    """DescribeAffectedNodeList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CheckItemId: 唯一的检测项的ID
        :type CheckItemId: int
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 每次查询的最大记录数量
        :type Limit: int
        :param _Filters: Name - String
Name 可取值：ClusterName, ClusterId,InstanceId,PrivateIpAddresses
        :type Filters: list of ComplianceFilters
        :param _By: 排序字段
        :type By: str
        :param _Order: 排序方式 asc,desc
        :type Order: str
        """
        self._CheckItemId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def CheckItemId(self):
        return self._CheckItemId

    @CheckItemId.setter
    def CheckItemId(self, CheckItemId):
        self._CheckItemId = CheckItemId

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._CheckItemId = params.get("CheckItemId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAffectedNodeListResponse(AbstractModel):
    """DescribeAffectedNodeList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 受影响的节点总数
        :type TotalCount: int
        :param _AffectedNodeList: 受影响的节点列表
        :type AffectedNodeList: list of AffectedNodeItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._AffectedNodeList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AffectedNodeList(self):
        return self._AffectedNodeList

    @AffectedNodeList.setter
    def AffectedNodeList(self, AffectedNodeList):
        self._AffectedNodeList = AffectedNodeList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AffectedNodeList") is not None:
            self._AffectedNodeList = []
            for item in params.get("AffectedNodeList"):
                obj = AffectedNodeItem()
                obj._deserialize(item)
                self._AffectedNodeList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAffectedWorkloadListRequest(AbstractModel):
    """DescribeAffectedWorkloadList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CheckItemId: 唯一的检测项的ID
        :type CheckItemId: int
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 每次查询的最大记录数量
        :type Limit: int
        :param _Filters: Name - String
Name 可取值：WorkloadType,ClusterId
        :type Filters: list of ComplianceFilters
        :param _By: 排序字段
        :type By: str
        :param _Order: 排序方式 asc,desc
        :type Order: str
        """
        self._CheckItemId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def CheckItemId(self):
        return self._CheckItemId

    @CheckItemId.setter
    def CheckItemId(self, CheckItemId):
        self._CheckItemId = CheckItemId

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._CheckItemId = params.get("CheckItemId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAffectedWorkloadListResponse(AbstractModel):
    """DescribeAffectedWorkloadList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 受影响的workload列表数量
        :type TotalCount: int
        :param _AffectedWorkloadList: 受影响的workload列表
        :type AffectedWorkloadList: list of AffectedWorkloadItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._AffectedWorkloadList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AffectedWorkloadList(self):
        return self._AffectedWorkloadList

    @AffectedWorkloadList.setter
    def AffectedWorkloadList(self, AffectedWorkloadList):
        self._AffectedWorkloadList = AffectedWorkloadList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AffectedWorkloadList") is not None:
            self._AffectedWorkloadList = []
            for item in params.get("AffectedWorkloadList"):
                obj = AffectedWorkloadItem()
                obj._deserialize(item)
                self._AffectedWorkloadList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAgentDaemonSetCmdRequest(AbstractModel):
    """DescribeAgentDaemonSetCmd请求参数结构体

    """

    def __init__(self):
        r"""
        :param _IsCloud: 是否是腾讯云
        :type IsCloud: bool
        :param _NetType: 网络类型：basic-基础网络，private-VPC, public-公网，direct-专线
        :type NetType: str
        :param _RegionCode: 地域标示, NetType=direct时必填
        :type RegionCode: str
        :param _VpcId: VpcId, NetType=direct时必填
        :type VpcId: str
        :param _ExpireDate: 命令有效期，非腾讯云时必填
        :type ExpireDate: str
        :param _ClusterCustomParameters: 集群自定义参数
        :type ClusterCustomParameters: list of ClusterCustomParameters
        """
        self._IsCloud = None
        self._NetType = None
        self._RegionCode = None
        self._VpcId = None
        self._ExpireDate = None
        self._ClusterCustomParameters = None

    @property
    def IsCloud(self):
        return self._IsCloud

    @IsCloud.setter
    def IsCloud(self, IsCloud):
        self._IsCloud = IsCloud

    @property
    def NetType(self):
        return self._NetType

    @NetType.setter
    def NetType(self, NetType):
        self._NetType = NetType

    @property
    def RegionCode(self):
        return self._RegionCode

    @RegionCode.setter
    def RegionCode(self, RegionCode):
        self._RegionCode = RegionCode

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def ExpireDate(self):
        return self._ExpireDate

    @ExpireDate.setter
    def ExpireDate(self, ExpireDate):
        self._ExpireDate = ExpireDate

    @property
    def ClusterCustomParameters(self):
        return self._ClusterCustomParameters

    @ClusterCustomParameters.setter
    def ClusterCustomParameters(self, ClusterCustomParameters):
        self._ClusterCustomParameters = ClusterCustomParameters


    def _deserialize(self, params):
        self._IsCloud = params.get("IsCloud")
        self._NetType = params.get("NetType")
        self._RegionCode = params.get("RegionCode")
        self._VpcId = params.get("VpcId")
        self._ExpireDate = params.get("ExpireDate")
        if params.get("ClusterCustomParameters") is not None:
            self._ClusterCustomParameters = []
            for item in params.get("ClusterCustomParameters"):
                obj = ClusterCustomParameters()
                obj._deserialize(item)
                self._ClusterCustomParameters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAgentDaemonSetCmdResponse(AbstractModel):
    """DescribeAgentDaemonSetCmd返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Command: 安装命令
        :type Command: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Command = None
        self._RequestId = None

    @property
    def Command(self):
        return self._Command

    @Command.setter
    def Command(self, Command):
        self._Command = Command

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Command = params.get("Command")
        self._RequestId = params.get("RequestId")


class DescribeAgentInstallCommandRequest(AbstractModel):
    """DescribeAgentInstallCommand请求参数结构体

    """

    def __init__(self):
        r"""
        :param _IsCloud: 是否是腾讯云
        :type IsCloud: bool
        :param _NetType: 网络类型：basic-基础网络，private-VPC, public-公网，direct-专线
        :type NetType: str
        :param _RegionCode: 地域标示, NetType=direct时必填
        :type RegionCode: str
        :param _VpcId: VpcId, NetType=direct时必填
        :type VpcId: str
        :param _ExpireDate: 命令有效期，非腾讯云时必填
        :type ExpireDate: str
        :param _TagIds: 标签ID列表，IsCloud=false时才会生效
        :type TagIds: list of int non-negative
        """
        self._IsCloud = None
        self._NetType = None
        self._RegionCode = None
        self._VpcId = None
        self._ExpireDate = None
        self._TagIds = None

    @property
    def IsCloud(self):
        return self._IsCloud

    @IsCloud.setter
    def IsCloud(self, IsCloud):
        self._IsCloud = IsCloud

    @property
    def NetType(self):
        return self._NetType

    @NetType.setter
    def NetType(self, NetType):
        self._NetType = NetType

    @property
    def RegionCode(self):
        return self._RegionCode

    @RegionCode.setter
    def RegionCode(self, RegionCode):
        self._RegionCode = RegionCode

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def ExpireDate(self):
        return self._ExpireDate

    @ExpireDate.setter
    def ExpireDate(self, ExpireDate):
        self._ExpireDate = ExpireDate

    @property
    def TagIds(self):
        return self._TagIds

    @TagIds.setter
    def TagIds(self, TagIds):
        self._TagIds = TagIds


    def _deserialize(self, params):
        self._IsCloud = params.get("IsCloud")
        self._NetType = params.get("NetType")
        self._RegionCode = params.get("RegionCode")
        self._VpcId = params.get("VpcId")
        self._ExpireDate = params.get("ExpireDate")
        self._TagIds = params.get("TagIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAgentInstallCommandResponse(AbstractModel):
    """DescribeAgentInstallCommand返回参数结构体

    """

    def __init__(self):
        r"""
        :param _LinuxCommand: linux系统安装命令
        :type LinuxCommand: str
        :param _WindowsCommand: windows系统安装命令（windows2008及以上）
        :type WindowsCommand: str
        :param _WindowsStepOne: windows系统安装命令第一步（windows2003）
        :type WindowsStepOne: str
        :param _WindowsStepTwo: windows系统安装命令第二步（windows2003）
        :type WindowsStepTwo: str
        :param _WindowsDownloadUrl: windows版agent下载链接
        :type WindowsDownloadUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._LinuxCommand = None
        self._WindowsCommand = None
        self._WindowsStepOne = None
        self._WindowsStepTwo = None
        self._WindowsDownloadUrl = None
        self._RequestId = None

    @property
    def LinuxCommand(self):
        return self._LinuxCommand

    @LinuxCommand.setter
    def LinuxCommand(self, LinuxCommand):
        self._LinuxCommand = LinuxCommand

    @property
    def WindowsCommand(self):
        return self._WindowsCommand

    @WindowsCommand.setter
    def WindowsCommand(self, WindowsCommand):
        self._WindowsCommand = WindowsCommand

    @property
    def WindowsStepOne(self):
        return self._WindowsStepOne

    @WindowsStepOne.setter
    def WindowsStepOne(self, WindowsStepOne):
        self._WindowsStepOne = WindowsStepOne

    @property
    def WindowsStepTwo(self):
        return self._WindowsStepTwo

    @WindowsStepTwo.setter
    def WindowsStepTwo(self, WindowsStepTwo):
        self._WindowsStepTwo = WindowsStepTwo

    @property
    def WindowsDownloadUrl(self):
        return self._WindowsDownloadUrl

    @WindowsDownloadUrl.setter
    def WindowsDownloadUrl(self, WindowsDownloadUrl):
        self._WindowsDownloadUrl = WindowsDownloadUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._LinuxCommand = params.get("LinuxCommand")
        self._WindowsCommand = params.get("WindowsCommand")
        self._WindowsStepOne = params.get("WindowsStepOne")
        self._WindowsStepTwo = params.get("WindowsStepTwo")
        self._WindowsDownloadUrl = params.get("WindowsDownloadUrl")
        self._RequestId = params.get("RequestId")


class DescribeAssetAppServiceListRequest(AbstractModel):
    """DescribeAssetAppServiceList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Keywords- String - 是否必填：否 - 模糊查询可选字段</li>
        :type Filters: list of AssetFilters
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetAppServiceListResponse(AbstractModel):
    """DescribeAssetAppServiceList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: db服务列表
        :type List: list of ServiceInfo
        :param _TotalCount: 总数量
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ServiceInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetClusterListRequest(AbstractModel):
    """DescribeAssetClusterList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li>ClusterID - string  - 是否必填: 否 -集群ID</li>
<li>ClusterName - string  - 是否必填: 否 -集群名称</li>
<li>Status - string  - 是否必填: 否 -集群状态</li>
        :type Filters: list of RunTimeFilters
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Order: 排序方式
        :type Order: str
        :param _By: 排序字段。
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetClusterListResponse(AbstractModel):
    """DescribeAssetClusterList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 集群列表
        :type List: list of AssetClusterListItem
        :param _TotalCount: 总数量
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = AssetClusterListItem()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetComponentListRequest(AbstractModel):
    """DescribeAssetComponentList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ContainerID: 容器id
        :type ContainerID: str
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件
        :type Filters: list of AssetFilters
        """
        self._ContainerID = None
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def ContainerID(self):
        return self._ContainerID

    @ContainerID.setter
    def ContainerID(self, ContainerID):
        self._ContainerID = ContainerID

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ContainerID = params.get("ContainerID")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetComponentListResponse(AbstractModel):
    """DescribeAssetComponentList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 组件列表
        :type List: list of ComponentInfo
        :param _TotalCount: 总数量
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ComponentInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetContainerDetailRequest(AbstractModel):
    """DescribeAssetContainerDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ContainerId: 容器id
        :type ContainerId: str
        """
        self._ContainerId = None

    @property
    def ContainerId(self):
        return self._ContainerId

    @ContainerId.setter
    def ContainerId(self, ContainerId):
        self._ContainerId = ContainerId


    def _deserialize(self, params):
        self._ContainerId = params.get("ContainerId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetContainerDetailResponse(AbstractModel):
    """DescribeAssetContainerDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _HostID: 主机id
        :type HostID: str
        :param _HostIP: 主机ip
        :type HostIP: str
        :param _ContainerName: 容器名称
        :type ContainerName: str
        :param _Status: 运行状态
        :type Status: str
        :param _RunAs: 运行账户
        :type RunAs: str
        :param _Cmd: 命令行
        :type Cmd: str
        :param _CPUUsage: CPU使用率 * 1000
        :type CPUUsage: int
        :param _RamUsage: 内存使用 KB
        :type RamUsage: int
        :param _ImageName: 镜像名
        :type ImageName: str
        :param _ImageID: 镜像ID
        :type ImageID: str
        :param _POD: 归属POD
        :type POD: str
        :param _K8sMaster: k8s 主节点
        :type K8sMaster: str
        :param _ProcessCnt: 容器内进程数
        :type ProcessCnt: int
        :param _PortCnt: 容器内端口数
        :type PortCnt: int
        :param _ComponentCnt: 组件数
        :type ComponentCnt: int
        :param _AppCnt: app数
        :type AppCnt: int
        :param _WebServiceCnt: websvc数
        :type WebServiceCnt: int
        :param _Mounts: 挂载
        :type Mounts: list of ContainerMount
        :param _Network: 容器网络信息
        :type Network: :class:`tencentcloud.tcss.v20201101.models.ContainerNetwork`
        :param _CreateTime: 创建时间
        :type CreateTime: str
        :param _ImageCreateTime: 镜像创建时间
        :type ImageCreateTime: str
        :param _ImageSize: 镜像大小
        :type ImageSize: int
        :param _HostStatus: 主机状态 offline,online,pause
        :type HostStatus: str
        :param _NetStatus: 网络状态
未隔离  	NORMAL
已隔离		ISOLATED
隔离中		ISOLATING
隔离失败	ISOLATE_FAILED
解除隔离中  RESTORING
解除隔离失败 RESTORE_FAILED
        :type NetStatus: str
        :param _NetSubStatus: 网络子状态
        :type NetSubStatus: str
        :param _IsolateSource: 隔离来源
注意：此字段可能返回 null，表示取不到有效值。
        :type IsolateSource: str
        :param _IsolateTime: 隔离时间
注意：此字段可能返回 null，表示取不到有效值。
        :type IsolateTime: str
        :param _NodeID: 节点ID
        :type NodeID: str
        :param _NodeName: 节点名称
        :type NodeName: str
        :param _NodeSubNetID: 节点子网ID
        :type NodeSubNetID: str
        :param _NodeSubNetName: 节点子网名称
        :type NodeSubNetName: str
        :param _NodeSubNetCIDR: 节点子网网段
        :type NodeSubNetCIDR: str
        :param _PodName: pod名称
        :type PodName: str
        :param _PodIP: pod ip
        :type PodIP: str
        :param _PodStatus: pod状态
        :type PodStatus: str
        :param _ClusterID: 集群ID
        :type ClusterID: str
        :param _ClusterName: 集群名称
        :type ClusterName: str
        :param _NodeType: 节点类型:NORMAL: 普通节点(默认值) SUPER: 超级节点
        :type NodeType: str
        :param _NodeUniqueID: 超级节点唯一id
        :type NodeUniqueID: str
        :param _PublicIP: 外网ip
        :type PublicIP: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._HostID = None
        self._HostIP = None
        self._ContainerName = None
        self._Status = None
        self._RunAs = None
        self._Cmd = None
        self._CPUUsage = None
        self._RamUsage = None
        self._ImageName = None
        self._ImageID = None
        self._POD = None
        self._K8sMaster = None
        self._ProcessCnt = None
        self._PortCnt = None
        self._ComponentCnt = None
        self._AppCnt = None
        self._WebServiceCnt = None
        self._Mounts = None
        self._Network = None
        self._CreateTime = None
        self._ImageCreateTime = None
        self._ImageSize = None
        self._HostStatus = None
        self._NetStatus = None
        self._NetSubStatus = None
        self._IsolateSource = None
        self._IsolateTime = None
        self._NodeID = None
        self._NodeName = None
        self._NodeSubNetID = None
        self._NodeSubNetName = None
        self._NodeSubNetCIDR = None
        self._PodName = None
        self._PodIP = None
        self._PodStatus = None
        self._ClusterID = None
        self._ClusterName = None
        self._NodeType = None
        self._NodeUniqueID = None
        self._PublicIP = None
        self._RequestId = None

    @property
    def HostID(self):
        return self._HostID

    @HostID.setter
    def HostID(self, HostID):
        self._HostID = HostID

    @property
    def HostIP(self):
        return self._HostIP

    @HostIP.setter
    def HostIP(self, HostIP):
        self._HostIP = HostIP

    @property
    def ContainerName(self):
        return self._ContainerName

    @ContainerName.setter
    def ContainerName(self, ContainerName):
        self._ContainerName = ContainerName

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RunAs(self):
        return self._RunAs

    @RunAs.setter
    def RunAs(self, RunAs):
        self._RunAs = RunAs

    @property
    def Cmd(self):
        return self._Cmd

    @Cmd.setter
    def Cmd(self, Cmd):
        self._Cmd = Cmd

    @property
    def CPUUsage(self):
        return self._CPUUsage

    @CPUUsage.setter
    def CPUUsage(self, CPUUsage):
        self._CPUUsage = CPUUsage

    @property
    def RamUsage(self):
        return self._RamUsage

    @RamUsage.setter
    def RamUsage(self, RamUsage):
        self._RamUsage = RamUsage

    @property
    def ImageName(self):
        return self._ImageName

    @ImageName.setter
    def ImageName(self, ImageName):
        self._ImageName = ImageName

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def POD(self):
        return self._POD

    @POD.setter
    def POD(self, POD):
        self._POD = POD

    @property
    def K8sMaster(self):
        return self._K8sMaster

    @K8sMaster.setter
    def K8sMaster(self, K8sMaster):
        self._K8sMaster = K8sMaster

    @property
    def ProcessCnt(self):
        return self._ProcessCnt

    @ProcessCnt.setter
    def ProcessCnt(self, ProcessCnt):
        self._ProcessCnt = ProcessCnt

    @property
    def PortCnt(self):
        return self._PortCnt

    @PortCnt.setter
    def PortCnt(self, PortCnt):
        self._PortCnt = PortCnt

    @property
    def ComponentCnt(self):
        return self._ComponentCnt

    @ComponentCnt.setter
    def ComponentCnt(self, ComponentCnt):
        self._ComponentCnt = ComponentCnt

    @property
    def AppCnt(self):
        return self._AppCnt

    @AppCnt.setter
    def AppCnt(self, AppCnt):
        self._AppCnt = AppCnt

    @property
    def WebServiceCnt(self):
        return self._WebServiceCnt

    @WebServiceCnt.setter
    def WebServiceCnt(self, WebServiceCnt):
        self._WebServiceCnt = WebServiceCnt

    @property
    def Mounts(self):
        return self._Mounts

    @Mounts.setter
    def Mounts(self, Mounts):
        self._Mounts = Mounts

    @property
    def Network(self):
        return self._Network

    @Network.setter
    def Network(self, Network):
        self._Network = Network

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ImageCreateTime(self):
        return self._ImageCreateTime

    @ImageCreateTime.setter
    def ImageCreateTime(self, ImageCreateTime):
        self._ImageCreateTime = ImageCreateTime

    @property
    def ImageSize(self):
        return self._ImageSize

    @ImageSize.setter
    def ImageSize(self, ImageSize):
        self._ImageSize = ImageSize

    @property
    def HostStatus(self):
        return self._HostStatus

    @HostStatus.setter
    def HostStatus(self, HostStatus):
        self._HostStatus = HostStatus

    @property
    def NetStatus(self):
        return self._NetStatus

    @NetStatus.setter
    def NetStatus(self, NetStatus):
        self._NetStatus = NetStatus

    @property
    def NetSubStatus(self):
        return self._NetSubStatus

    @NetSubStatus.setter
    def NetSubStatus(self, NetSubStatus):
        self._NetSubStatus = NetSubStatus

    @property
    def IsolateSource(self):
        return self._IsolateSource

    @IsolateSource.setter
    def IsolateSource(self, IsolateSource):
        self._IsolateSource = IsolateSource

    @property
    def IsolateTime(self):
        return self._IsolateTime

    @IsolateTime.setter
    def IsolateTime(self, IsolateTime):
        self._IsolateTime = IsolateTime

    @property
    def NodeID(self):
        return self._NodeID

    @NodeID.setter
    def NodeID(self, NodeID):
        self._NodeID = NodeID

    @property
    def NodeName(self):
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def NodeSubNetID(self):
        return self._NodeSubNetID

    @NodeSubNetID.setter
    def NodeSubNetID(self, NodeSubNetID):
        self._NodeSubNetID = NodeSubNetID

    @property
    def NodeSubNetName(self):
        return self._NodeSubNetName

    @NodeSubNetName.setter
    def NodeSubNetName(self, NodeSubNetName):
        self._NodeSubNetName = NodeSubNetName

    @property
    def NodeSubNetCIDR(self):
        return self._NodeSubNetCIDR

    @NodeSubNetCIDR.setter
    def NodeSubNetCIDR(self, NodeSubNetCIDR):
        self._NodeSubNetCIDR = NodeSubNetCIDR

    @property
    def PodName(self):
        return self._PodName

    @PodName.setter
    def PodName(self, PodName):
        self._PodName = PodName

    @property
    def PodIP(self):
        return self._PodIP

    @PodIP.setter
    def PodIP(self, PodIP):
        self._PodIP = PodIP

    @property
    def PodStatus(self):
        return self._PodStatus

    @PodStatus.setter
    def PodStatus(self, PodStatus):
        self._PodStatus = PodStatus

    @property
    def ClusterID(self):
        return self._ClusterID

    @ClusterID.setter
    def ClusterID(self, ClusterID):
        self._ClusterID = ClusterID

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def NodeType(self):
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def NodeUniqueID(self):
        return self._NodeUniqueID

    @NodeUniqueID.setter
    def NodeUniqueID(self, NodeUniqueID):
        self._NodeUniqueID = NodeUniqueID

    @property
    def PublicIP(self):
        return self._PublicIP

    @PublicIP.setter
    def PublicIP(self, PublicIP):
        self._PublicIP = PublicIP

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._HostID = params.get("HostID")
        self._HostIP = params.get("HostIP")
        self._ContainerName = params.get("ContainerName")
        self._Status = params.get("Status")
        self._RunAs = params.get("RunAs")
        self._Cmd = params.get("Cmd")
        self._CPUUsage = params.get("CPUUsage")
        self._RamUsage = params.get("RamUsage")
        self._ImageName = params.get("ImageName")
        self._ImageID = params.get("ImageID")
        self._POD = params.get("POD")
        self._K8sMaster = params.get("K8sMaster")
        self._ProcessCnt = params.get("ProcessCnt")
        self._PortCnt = params.get("PortCnt")
        self._ComponentCnt = params.get("ComponentCnt")
        self._AppCnt = params.get("AppCnt")
        self._WebServiceCnt = params.get("WebServiceCnt")
        if params.get("Mounts") is not None:
            self._Mounts = []
            for item in params.get("Mounts"):
                obj = ContainerMount()
                obj._deserialize(item)
                self._Mounts.append(obj)
        if params.get("Network") is not None:
            self._Network = ContainerNetwork()
            self._Network._deserialize(params.get("Network"))
        self._CreateTime = params.get("CreateTime")
        self._ImageCreateTime = params.get("ImageCreateTime")
        self._ImageSize = params.get("ImageSize")
        self._HostStatus = params.get("HostStatus")
        self._NetStatus = params.get("NetStatus")
        self._NetSubStatus = params.get("NetSubStatus")
        self._IsolateSource = params.get("IsolateSource")
        self._IsolateTime = params.get("IsolateTime")
        self._NodeID = params.get("NodeID")
        self._NodeName = params.get("NodeName")
        self._NodeSubNetID = params.get("NodeSubNetID")
        self._NodeSubNetName = params.get("NodeSubNetName")
        self._NodeSubNetCIDR = params.get("NodeSubNetCIDR")
        self._PodName = params.get("PodName")
        self._PodIP = params.get("PodIP")
        self._PodStatus = params.get("PodStatus")
        self._ClusterID = params.get("ClusterID")
        self._ClusterName = params.get("ClusterName")
        self._NodeType = params.get("NodeType")
        self._NodeUniqueID = params.get("NodeUniqueID")
        self._PublicIP = params.get("PublicIP")
        self._RequestId = params.get("RequestId")


class DescribeAssetContainerListRequest(AbstractModel):
    """DescribeAssetContainerList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>ContainerName - String - 是否必填：否 - 容器名称模糊搜索</li>
<li>Status - String - 是否必填：否 - 容器运行状态筛选，0："created",1："running", 2："paused", 3："restarting", 4："removing", 5："exited", 6："dead" </li>
<li>Runas - String - 是否必填：否 - 运行用户筛选</li>
<li>ImageName- String - 是否必填：否 - 镜像名称搜索</li>
<li>HostIP- string - 是否必填：否 - 主机ip搜索</li>
<li>OrderBy - String 是否必填：否 -排序字段，支持：cpu_usage, mem_usage的动态排序 ["cpu_usage","+"]  '+'升序、'-'降序</li>
<li>NetStatus - String -是否必填: 否 -  容器网络状态筛选 normal isolated isolating isolate_failed restoring restore_failed</li>
<li>PodID - String -是否必填: 否 - PodID筛选</li>
<li>NodeUniqueID - String -是否必填: 否 - SuperNode筛选</li>
<li>PodUid - String -是否必填: 否 - Pod筛选</li>
<li>PodIP - String -是否必填: 否 - PodIP筛选</li>
<li>NodeType - String -是否必填: 否 - 节点类型筛选:NORMAL:普通节点;SUPER:超级节点</li>
        :type Filters: list of AssetFilters
        :param _By: 排序字段
        :type By: str
        :param _Order: 排序方式 asc,desc
        :type Order: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetContainerListResponse(AbstractModel):
    """DescribeAssetContainerList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 容器列表
        :type List: list of ContainerInfo
        :param _TotalCount: 总数量
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ContainerInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetDBServiceListRequest(AbstractModel):
    """DescribeAssetDBServiceList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Keywords- String - 是否必填：否 - 模糊查询可选字段</li>
        :type Filters: list of AssetFilters
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetDBServiceListResponse(AbstractModel):
    """DescribeAssetDBServiceList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: db服务列表
        :type List: list of ServiceInfo
        :param _TotalCount: 总数量
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ServiceInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetHostDetailRequest(AbstractModel):
    """DescribeAssetHostDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _HostId: 主机id
        :type HostId: str
        """
        self._HostId = None

    @property
    def HostId(self):
        return self._HostId

    @HostId.setter
    def HostId(self, HostId):
        self._HostId = HostId


    def _deserialize(self, params):
        self._HostId = params.get("HostId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetHostDetailResponse(AbstractModel):
    """DescribeAssetHostDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _UUID: 容器安全uuid
        :type UUID: str
        :param _UpdateTime: 更新时间
        :type UpdateTime: str
        :param _HostName: 主机名
        :type HostName: str
        :param _Group: 主机分组
        :type Group: str
        :param _HostIP: 主机IP
        :type HostIP: str
        :param _OsName: 操作系统
        :type OsName: str
        :param _AgentVersion: agent版本
        :type AgentVersion: str
        :param _KernelVersion: 内核版本
        :type KernelVersion: str
        :param _DockerVersion: docker版本
        :type DockerVersion: str
        :param _DockerAPIVersion: docker api版本
        :type DockerAPIVersion: str
        :param _DockerGoVersion: docker go 版本
        :type DockerGoVersion: str
        :param _DockerFileSystemDriver: docker 文件系统类型
        :type DockerFileSystemDriver: str
        :param _DockerRootDir: docker root 目录
        :type DockerRootDir: str
        :param _ImageCnt: 镜像数
        :type ImageCnt: int
        :param _ContainerCnt: 容器数
        :type ContainerCnt: int
        :param _K8sMasterIP: k8s IP
        :type K8sMasterIP: str
        :param _K8sVersion: k8s version
        :type K8sVersion: str
        :param _KubeProxyVersion: kube proxy
        :type KubeProxyVersion: str
        :param _Status: "UNINSTALL"："未安装","OFFLINE"："离线", "ONLINE"："防护中
        :type Status: str
        :param _IsContainerd: 是否Containerd
        :type IsContainerd: bool
        :param _MachineType: 主机来源;"TENCENTCLOUD":"腾讯云服务器","OTHERCLOUD":"非腾讯云服务器"
        :type MachineType: str
        :param _PublicIp: 外网ip
        :type PublicIp: str
        :param _InstanceID: 主机实例ID
        :type InstanceID: str
        :param _RegionID: 地域ID
        :type RegionID: int
        :param _Project: 所属项目
        :type Project: :class:`tencentcloud.tcss.v20201101.models.ProjectInfo`
        :param _Tags: 标签
        :type Tags: list of TagInfo
        :param _ClusterID: 集群ID
        :type ClusterID: str
        :param _ClusterName: 集群名称
        :type ClusterName: str
        :param _ClusterAccessedStatus: 集群接入状态
        :type ClusterAccessedStatus: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._UUID = None
        self._UpdateTime = None
        self._HostName = None
        self._Group = None
        self._HostIP = None
        self._OsName = None
        self._AgentVersion = None
        self._KernelVersion = None
        self._DockerVersion = None
        self._DockerAPIVersion = None
        self._DockerGoVersion = None
        self._DockerFileSystemDriver = None
        self._DockerRootDir = None
        self._ImageCnt = None
        self._ContainerCnt = None
        self._K8sMasterIP = None
        self._K8sVersion = None
        self._KubeProxyVersion = None
        self._Status = None
        self._IsContainerd = None
        self._MachineType = None
        self._PublicIp = None
        self._InstanceID = None
        self._RegionID = None
        self._Project = None
        self._Tags = None
        self._ClusterID = None
        self._ClusterName = None
        self._ClusterAccessedStatus = None
        self._RequestId = None

    @property
    def UUID(self):
        return self._UUID

    @UUID.setter
    def UUID(self, UUID):
        self._UUID = UUID

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def HostName(self):
        return self._HostName

    @HostName.setter
    def HostName(self, HostName):
        self._HostName = HostName

    @property
    def Group(self):
        return self._Group

    @Group.setter
    def Group(self, Group):
        self._Group = Group

    @property
    def HostIP(self):
        return self._HostIP

    @HostIP.setter
    def HostIP(self, HostIP):
        self._HostIP = HostIP

    @property
    def OsName(self):
        return self._OsName

    @OsName.setter
    def OsName(self, OsName):
        self._OsName = OsName

    @property
    def AgentVersion(self):
        return self._AgentVersion

    @AgentVersion.setter
    def AgentVersion(self, AgentVersion):
        self._AgentVersion = AgentVersion

    @property
    def KernelVersion(self):
        return self._KernelVersion

    @KernelVersion.setter
    def KernelVersion(self, KernelVersion):
        self._KernelVersion = KernelVersion

    @property
    def DockerVersion(self):
        return self._DockerVersion

    @DockerVersion.setter
    def DockerVersion(self, DockerVersion):
        self._DockerVersion = DockerVersion

    @property
    def DockerAPIVersion(self):
        return self._DockerAPIVersion

    @DockerAPIVersion.setter
    def DockerAPIVersion(self, DockerAPIVersion):
        self._DockerAPIVersion = DockerAPIVersion

    @property
    def DockerGoVersion(self):
        return self._DockerGoVersion

    @DockerGoVersion.setter
    def DockerGoVersion(self, DockerGoVersion):
        self._DockerGoVersion = DockerGoVersion

    @property
    def DockerFileSystemDriver(self):
        return self._DockerFileSystemDriver

    @DockerFileSystemDriver.setter
    def DockerFileSystemDriver(self, DockerFileSystemDriver):
        self._DockerFileSystemDriver = DockerFileSystemDriver

    @property
    def DockerRootDir(self):
        return self._DockerRootDir

    @DockerRootDir.setter
    def DockerRootDir(self, DockerRootDir):
        self._DockerRootDir = DockerRootDir

    @property
    def ImageCnt(self):
        return self._ImageCnt

    @ImageCnt.setter
    def ImageCnt(self, ImageCnt):
        self._ImageCnt = ImageCnt

    @property
    def ContainerCnt(self):
        return self._ContainerCnt

    @ContainerCnt.setter
    def ContainerCnt(self, ContainerCnt):
        self._ContainerCnt = ContainerCnt

    @property
    def K8sMasterIP(self):
        return self._K8sMasterIP

    @K8sMasterIP.setter
    def K8sMasterIP(self, K8sMasterIP):
        self._K8sMasterIP = K8sMasterIP

    @property
    def K8sVersion(self):
        return self._K8sVersion

    @K8sVersion.setter
    def K8sVersion(self, K8sVersion):
        self._K8sVersion = K8sVersion

    @property
    def KubeProxyVersion(self):
        return self._KubeProxyVersion

    @KubeProxyVersion.setter
    def KubeProxyVersion(self, KubeProxyVersion):
        self._KubeProxyVersion = KubeProxyVersion

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def IsContainerd(self):
        return self._IsContainerd

    @IsContainerd.setter
    def IsContainerd(self, IsContainerd):
        self._IsContainerd = IsContainerd

    @property
    def MachineType(self):
        return self._MachineType

    @MachineType.setter
    def MachineType(self, MachineType):
        self._MachineType = MachineType

    @property
    def PublicIp(self):
        return self._PublicIp

    @PublicIp.setter
    def PublicIp(self, PublicIp):
        self._PublicIp = PublicIp

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def RegionID(self):
        return self._RegionID

    @RegionID.setter
    def RegionID(self, RegionID):
        self._RegionID = RegionID

    @property
    def Project(self):
        return self._Project

    @Project.setter
    def Project(self, Project):
        self._Project = Project

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def ClusterID(self):
        return self._ClusterID

    @ClusterID.setter
    def ClusterID(self, ClusterID):
        self._ClusterID = ClusterID

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def ClusterAccessedStatus(self):
        return self._ClusterAccessedStatus

    @ClusterAccessedStatus.setter
    def ClusterAccessedStatus(self, ClusterAccessedStatus):
        self._ClusterAccessedStatus = ClusterAccessedStatus

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._UUID = params.get("UUID")
        self._UpdateTime = params.get("UpdateTime")
        self._HostName = params.get("HostName")
        self._Group = params.get("Group")
        self._HostIP = params.get("HostIP")
        self._OsName = params.get("OsName")
        self._AgentVersion = params.get("AgentVersion")
        self._KernelVersion = params.get("KernelVersion")
        self._DockerVersion = params.get("DockerVersion")
        self._DockerAPIVersion = params.get("DockerAPIVersion")
        self._DockerGoVersion = params.get("DockerGoVersion")
        self._DockerFileSystemDriver = params.get("DockerFileSystemDriver")
        self._DockerRootDir = params.get("DockerRootDir")
        self._ImageCnt = params.get("ImageCnt")
        self._ContainerCnt = params.get("ContainerCnt")
        self._K8sMasterIP = params.get("K8sMasterIP")
        self._K8sVersion = params.get("K8sVersion")
        self._KubeProxyVersion = params.get("KubeProxyVersion")
        self._Status = params.get("Status")
        self._IsContainerd = params.get("IsContainerd")
        self._MachineType = params.get("MachineType")
        self._PublicIp = params.get("PublicIp")
        self._InstanceID = params.get("InstanceID")
        self._RegionID = params.get("RegionID")
        if params.get("Project") is not None:
            self._Project = ProjectInfo()
            self._Project._deserialize(params.get("Project"))
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = TagInfo()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._ClusterID = params.get("ClusterID")
        self._ClusterName = params.get("ClusterName")
        self._ClusterAccessedStatus = params.get("ClusterAccessedStatus")
        self._RequestId = params.get("RequestId")


class DescribeAssetHostListRequest(AbstractModel):
    """DescribeAssetHostList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Status - String - 是否必填：否 - agent状态筛选，"ALL":"全部"(或不传该字段),"UNINSTALL"："未安装","OFFLINE"："离线", "ONLINE"："防护中"</li>
<li>HostName - String - 是否必填：否 - 主机名筛选</li>
<li>Group- String - 是否必填：否 - 主机群组搜索</li>
<li>HostIP- string - 是否必填：否 - 主机ip搜索</li>
<li>HostID- string - 是否必填：否 - 主机id搜索</li>
<li>DockerVersion- string - 是否必填：否 - docker版本搜索</li>
<li>MachineType- string - 是否必填：否 - 主机来源MachineType搜索，"ALL":"全部"(或不传该字段),主机来源：["CVM", "ECM", "LH", "BM"]  中的之一为腾讯云服务器；["Other"]之一非腾讯云服务器；</li>
<li>DockerStatus- string - 是否必填：否 - docker安装状态，"ALL":"全部"(或不传该字段),"INSTALL":"已安装","UNINSTALL":"未安装"</li>
<li>ProjectID- string - 是否必填：否 - 所属项目id搜索</li>
<li>Tag:xxx(tag:key)- string- 是否必填：否 - 标签键值搜索 示例Filters":[{"Name":"tag:tke-kind","Values":["service"]}]</li>
        :type Filters: list of AssetFilters
        :param _By: 排序字段
        :type By: str
        :param _Order: 排序方式 asc,desc
        :type Order: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetHostListResponse(AbstractModel):
    """DescribeAssetHostList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 主机列表
        :type List: list of HostInfo
        :param _TotalCount: 总数量
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = HostInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageBindRuleInfoRequest(AbstractModel):
    """DescribeAssetImageBindRuleInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤参数,"Filters":[{"Name":"EventType","Values":[""]}]
EventType取值：
"FILE_ABNORMAL_READ" 访问控制
"MALICE_PROCESS_START" 恶意进程启动
        :type Filters: list of RunTimeFilters
        :param _Order: 升序降序,asc desc
        :type Order: str
        :param _By: 排序字段
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageBindRuleInfoResponse(AbstractModel):
    """DescribeAssetImageBindRuleInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 事件总数量
        :type TotalCount: int
        :param _ImageBindRuleSet: 镜像绑定规则列表
        :type ImageBindRuleSet: list of ImagesBindRuleInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ImageBindRuleSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ImageBindRuleSet(self):
        return self._ImageBindRuleSet

    @ImageBindRuleSet.setter
    def ImageBindRuleSet(self, ImageBindRuleSet):
        self._ImageBindRuleSet = ImageBindRuleSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ImageBindRuleSet") is not None:
            self._ImageBindRuleSet = []
            for item in params.get("ImageBindRuleSet"):
                obj = ImagesBindRuleInfo()
                obj._deserialize(item)
                self._ImageBindRuleSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetImageDetailRequest(AbstractModel):
    """DescribeAssetImageDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ImageID: 镜像id
        :type ImageID: str
        """
        self._ImageID = None

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID


    def _deserialize(self, params):
        self._ImageID = params.get("ImageID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageDetailResponse(AbstractModel):
    """DescribeAssetImageDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ImageID: 镜像ID
        :type ImageID: str
        :param _ImageName: 镜像名称
        :type ImageName: str
        :param _ImageDigest: 镜像摘要
        :type ImageDigest: str
        :param _CreateTime: 创建时间
        :type CreateTime: str
        :param _Size: 镜像大小
        :type Size: int
        :param _HostCnt: 关联主机个数
注意：此字段可能返回 null，表示取不到有效值。
        :type HostCnt: int
        :param _ContainerCnt: 关联容器个数
注意：此字段可能返回 null，表示取不到有效值。
        :type ContainerCnt: int
        :param _ScanTime: 最近扫描时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ScanTime: str
        :param _VulCnt: 漏洞个数
注意：此字段可能返回 null，表示取不到有效值。
        :type VulCnt: int
        :param _RiskCnt: 风险行为数
注意：此字段可能返回 null，表示取不到有效值。
        :type RiskCnt: int
        :param _SensitiveInfoCnt: 敏感信息数
注意：此字段可能返回 null，表示取不到有效值。
        :type SensitiveInfoCnt: int
        :param _IsTrustImage: 是否信任镜像
        :type IsTrustImage: bool
        :param _OsName: 镜像系统
        :type OsName: str
        :param _AgentError: agent镜像扫描错误
注意：此字段可能返回 null，表示取不到有效值。
        :type AgentError: str
        :param _ScanError: 后端镜像扫描错误
注意：此字段可能返回 null，表示取不到有效值。
        :type ScanError: str
        :param _Architecture: 系统架构
注意：此字段可能返回 null，表示取不到有效值。
        :type Architecture: str
        :param _Author: 作者
注意：此字段可能返回 null，表示取不到有效值。
        :type Author: str
        :param _BuildHistory: 构建历史
注意：此字段可能返回 null，表示取不到有效值。
        :type BuildHistory: str
        :param _ScanVirusProgress: 木马扫描进度
注意：此字段可能返回 null，表示取不到有效值。
        :type ScanVirusProgress: int
        :param _ScanVulProgress: 漏洞扫进度
注意：此字段可能返回 null，表示取不到有效值。
        :type ScanVulProgress: int
        :param _ScanRiskProgress: 敏感信息扫描进度
注意：此字段可能返回 null，表示取不到有效值。
        :type ScanRiskProgress: int
        :param _ScanVirusError: 木马扫描错误
注意：此字段可能返回 null，表示取不到有效值。
        :type ScanVirusError: str
        :param _ScanVulError: 漏洞扫描错误
注意：此字段可能返回 null，表示取不到有效值。
        :type ScanVulError: str
        :param _ScanRiskError: 敏感信息错误
注意：此字段可能返回 null，表示取不到有效值。
        :type ScanRiskError: str
        :param _ScanStatus: 镜像扫描状态
注意：此字段可能返回 null，表示取不到有效值。
        :type ScanStatus: str
        :param _VirusCnt: 木马病毒数
注意：此字段可能返回 null，表示取不到有效值。
        :type VirusCnt: int
        :param _Status: 镜像扫描状态
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: int
        :param _RemainScanTime: 剩余扫描时间
注意：此字段可能返回 null，表示取不到有效值。
        :type RemainScanTime: int
        :param _IsAuthorized: 授权为：1，未授权为：0
        :type IsAuthorized: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ImageID = None
        self._ImageName = None
        self._ImageDigest = None
        self._CreateTime = None
        self._Size = None
        self._HostCnt = None
        self._ContainerCnt = None
        self._ScanTime = None
        self._VulCnt = None
        self._RiskCnt = None
        self._SensitiveInfoCnt = None
        self._IsTrustImage = None
        self._OsName = None
        self._AgentError = None
        self._ScanError = None
        self._Architecture = None
        self._Author = None
        self._BuildHistory = None
        self._ScanVirusProgress = None
        self._ScanVulProgress = None
        self._ScanRiskProgress = None
        self._ScanVirusError = None
        self._ScanVulError = None
        self._ScanRiskError = None
        self._ScanStatus = None
        self._VirusCnt = None
        self._Status = None
        self._RemainScanTime = None
        self._IsAuthorized = None
        self._RequestId = None

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def ImageName(self):
        return self._ImageName

    @ImageName.setter
    def ImageName(self, ImageName):
        self._ImageName = ImageName

    @property
    def ImageDigest(self):
        return self._ImageDigest

    @ImageDigest.setter
    def ImageDigest(self, ImageDigest):
        self._ImageDigest = ImageDigest

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Size(self):
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def HostCnt(self):
        return self._HostCnt

    @HostCnt.setter
    def HostCnt(self, HostCnt):
        self._HostCnt = HostCnt

    @property
    def ContainerCnt(self):
        return self._ContainerCnt

    @ContainerCnt.setter
    def ContainerCnt(self, ContainerCnt):
        self._ContainerCnt = ContainerCnt

    @property
    def ScanTime(self):
        return self._ScanTime

    @ScanTime.setter
    def ScanTime(self, ScanTime):
        self._ScanTime = ScanTime

    @property
    def VulCnt(self):
        return self._VulCnt

    @VulCnt.setter
    def VulCnt(self, VulCnt):
        self._VulCnt = VulCnt

    @property
    def RiskCnt(self):
        return self._RiskCnt

    @RiskCnt.setter
    def RiskCnt(self, RiskCnt):
        self._RiskCnt = RiskCnt

    @property
    def SensitiveInfoCnt(self):
        return self._SensitiveInfoCnt

    @SensitiveInfoCnt.setter
    def SensitiveInfoCnt(self, SensitiveInfoCnt):
        self._SensitiveInfoCnt = SensitiveInfoCnt

    @property
    def IsTrustImage(self):
        return self._IsTrustImage

    @IsTrustImage.setter
    def IsTrustImage(self, IsTrustImage):
        self._IsTrustImage = IsTrustImage

    @property
    def OsName(self):
        return self._OsName

    @OsName.setter
    def OsName(self, OsName):
        self._OsName = OsName

    @property
    def AgentError(self):
        return self._AgentError

    @AgentError.setter
    def AgentError(self, AgentError):
        self._AgentError = AgentError

    @property
    def ScanError(self):
        return self._ScanError

    @ScanError.setter
    def ScanError(self, ScanError):
        self._ScanError = ScanError

    @property
    def Architecture(self):
        return self._Architecture

    @Architecture.setter
    def Architecture(self, Architecture):
        self._Architecture = Architecture

    @property
    def Author(self):
        return self._Author

    @Author.setter
    def Author(self, Author):
        self._Author = Author

    @property
    def BuildHistory(self):
        return self._BuildHistory

    @BuildHistory.setter
    def BuildHistory(self, BuildHistory):
        self._BuildHistory = BuildHistory

    @property
    def ScanVirusProgress(self):
        return self._ScanVirusProgress

    @ScanVirusProgress.setter
    def ScanVirusProgress(self, ScanVirusProgress):
        self._ScanVirusProgress = ScanVirusProgress

    @property
    def ScanVulProgress(self):
        return self._ScanVulProgress

    @ScanVulProgress.setter
    def ScanVulProgress(self, ScanVulProgress):
        self._ScanVulProgress = ScanVulProgress

    @property
    def ScanRiskProgress(self):
        return self._ScanRiskProgress

    @ScanRiskProgress.setter
    def ScanRiskProgress(self, ScanRiskProgress):
        self._ScanRiskProgress = ScanRiskProgress

    @property
    def ScanVirusError(self):
        return self._ScanVirusError

    @ScanVirusError.setter
    def ScanVirusError(self, ScanVirusError):
        self._ScanVirusError = ScanVirusError

    @property
    def ScanVulError(self):
        return self._ScanVulError

    @ScanVulError.setter
    def ScanVulError(self, ScanVulError):
        self._ScanVulError = ScanVulError

    @property
    def ScanRiskError(self):
        return self._ScanRiskError

    @ScanRiskError.setter
    def ScanRiskError(self, ScanRiskError):
        self._ScanRiskError = ScanRiskError

    @property
    def ScanStatus(self):
        return self._ScanStatus

    @ScanStatus.setter
    def ScanStatus(self, ScanStatus):
        self._ScanStatus = ScanStatus

    @property
    def VirusCnt(self):
        return self._VirusCnt

    @VirusCnt.setter
    def VirusCnt(self, VirusCnt):
        self._VirusCnt = VirusCnt

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RemainScanTime(self):
        return self._RemainScanTime

    @RemainScanTime.setter
    def RemainScanTime(self, RemainScanTime):
        self._RemainScanTime = RemainScanTime

    @property
    def IsAuthorized(self):
        return self._IsAuthorized

    @IsAuthorized.setter
    def IsAuthorized(self, IsAuthorized):
        self._IsAuthorized = IsAuthorized

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ImageID = params.get("ImageID")
        self._ImageName = params.get("ImageName")
        self._ImageDigest = params.get("ImageDigest")
        self._CreateTime = params.get("CreateTime")
        self._Size = params.get("Size")
        self._HostCnt = params.get("HostCnt")
        self._ContainerCnt = params.get("ContainerCnt")
        self._ScanTime = params.get("ScanTime")
        self._VulCnt = params.get("VulCnt")
        self._RiskCnt = params.get("RiskCnt")
        self._SensitiveInfoCnt = params.get("SensitiveInfoCnt")
        self._IsTrustImage = params.get("IsTrustImage")
        self._OsName = params.get("OsName")
        self._AgentError = params.get("AgentError")
        self._ScanError = params.get("ScanError")
        self._Architecture = params.get("Architecture")
        self._Author = params.get("Author")
        self._BuildHistory = params.get("BuildHistory")
        self._ScanVirusProgress = params.get("ScanVirusProgress")
        self._ScanVulProgress = params.get("ScanVulProgress")
        self._ScanRiskProgress = params.get("ScanRiskProgress")
        self._ScanVirusError = params.get("ScanVirusError")
        self._ScanVulError = params.get("ScanVulError")
        self._ScanRiskError = params.get("ScanRiskError")
        self._ScanStatus = params.get("ScanStatus")
        self._VirusCnt = params.get("VirusCnt")
        self._Status = params.get("Status")
        self._RemainScanTime = params.get("RemainScanTime")
        self._IsAuthorized = params.get("IsAuthorized")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageHostListRequest(AbstractModel):
    """DescribeAssetImageHostList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件 支持ImageID,HostID
        :type Filters: list of AssetFilters
        """
        self._Filters = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageHostListResponse(AbstractModel):
    """DescribeAssetImageHostList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 镜像列表
        :type List: list of ImageHost
        :param _TotalCount: 总数量
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ImageHost()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageListExportRequest(AbstractModel):
    """DescribeAssetImageListExport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ExportField: 导出字段
        :type ExportField: list of str
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>ImageName- String - 是否必填：否 - 镜像名称筛选，</li>
<li>ScanStatus - String - 是否必填：否 - 镜像扫描状态notScan，scanning，scanned，scanErr</li>
<li>ImageID- String - 是否必填：否 - 镜像ID筛选，</li>
<li>SecurityRisk- String - 是否必填：否 - 安全风险，VulCnt 、VirusCnt、RiskCnt、IsTrustImage</li>
        :type Filters: list of AssetFilters
        :param _By: 排序字段
        :type By: str
        :param _Order: 排序方式 asc,desc
        :type Order: str
        """
        self._ExportField = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._ExportField = params.get("ExportField")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageListExportResponse(AbstractModel):
    """DescribeAssetImageListExport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: excel文件下载地址
        :type DownloadUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageListRequest(AbstractModel):
    """DescribeAssetImageList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>ImageName- String - 是否必填：否 - 镜像名称筛选，</li>
<li>ScanStatus - String - 是否必填：否 - 镜像扫描状态notScan，scanning，scanned，scanErr</li>
<li>ImageID- String - 是否必填：否 - 镜像ID筛选，</li>
<li>SecurityRisk- String - 是否必填：否 - 安全风险，VulCnt 、VirusCnt、RiskCnt、IsTrustImage</li>
        :type Filters: list of AssetFilters
        :param _By: 排序字段
        :type By: str
        :param _Order: 排序方式 asc,desc
        :type Order: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageListResponse(AbstractModel):
    """DescribeAssetImageList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 镜像列表
        :type List: list of ImagesInfo
        :param _TotalCount: 总数量
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ImagesInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRegistryAssetStatusRequest(AbstractModel):
    """DescribeAssetImageRegistryAssetStatus请求参数结构体

    """


class DescribeAssetImageRegistryAssetStatusResponse(AbstractModel):
    """DescribeAssetImageRegistryAssetStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Status: 更新进度状态,doing更新中，success更新成功，failed失败
        :type Status: str
        :param _Err: 错误信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Err: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Status = None
        self._Err = None
        self._RequestId = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Err(self):
        return self._Err

    @Err.setter
    def Err(self, Err):
        self._Err = Err

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._Err = params.get("Err")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRegistryDetailRequest(AbstractModel):
    """DescribeAssetImageRegistryDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 仓库列表id
        :type Id: int
        :param _ImageId: 镜像ID
        :type ImageId: str
        """
        self._Id = None
        self._ImageId = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ImageId(self):
        return self._ImageId

    @ImageId.setter
    def ImageId(self, ImageId):
        self._ImageId = ImageId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ImageId = params.get("ImageId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryDetailResponse(AbstractModel):
    """DescribeAssetImageRegistryDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ImageDigest: 镜像Digest
注意：此字段可能返回 null，表示取不到有效值。
        :type ImageDigest: str
        :param _ImageRepoAddress: 镜像地址
注意：此字段可能返回 null，表示取不到有效值。
        :type ImageRepoAddress: str
        :param _RegistryType: 镜像类型
注意：此字段可能返回 null，表示取不到有效值。
        :type RegistryType: str
        :param _ImageName: 仓库名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ImageName: str
        :param _ImageTag: 镜像版本
注意：此字段可能返回 null，表示取不到有效值。
        :type ImageTag: str
        :param _ScanTime: 扫描时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ScanTime: str
        :param _ScanStatus: 扫描状态
注意：此字段可能返回 null，表示取不到有效值。
        :type ScanStatus: str
        :param _VulCnt: 安全漏洞数
注意：此字段可能返回 null，表示取不到有效值。
        :type VulCnt: int
        :param _VirusCnt: 木马病毒数
注意：此字段可能返回 null，表示取不到有效值。
        :type VirusCnt: int
        :param _RiskCnt: 风险行为数
注意：此字段可能返回 null，表示取不到有效值。
        :type RiskCnt: int
        :param _SentiveInfoCnt: 敏感信息数
注意：此字段可能返回 null，表示取不到有效值。
        :type SentiveInfoCnt: int
        :param _OsName: 镜像系统
注意：此字段可能返回 null，表示取不到有效值。
        :type OsName: str
        :param _ScanVirusError: 木马扫描错误
注意：此字段可能返回 null，表示取不到有效值。
        :type ScanVirusError: str
        :param _ScanVulError: 漏洞扫描错误
注意：此字段可能返回 null，表示取不到有效值。
        :type ScanVulError: str
        :param _LayerInfo: 层文件信息
注意：此字段可能返回 null，表示取不到有效值。
        :type LayerInfo: str
        :param _InstanceId: 实例id
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceId: str
        :param _InstanceName: 实例名称
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceName: str
        :param _Namespace: 命名空间
注意：此字段可能返回 null，表示取不到有效值。
        :type Namespace: str
        :param _ScanRiskError: 高危扫描错误
注意：此字段可能返回 null，表示取不到有效值。
        :type ScanRiskError: str
        :param _ScanVirusProgress: 木马信息扫描进度
注意：此字段可能返回 null，表示取不到有效值。
        :type ScanVirusProgress: int
        :param _ScanVulProgress: 漏洞扫描进度
注意：此字段可能返回 null，表示取不到有效值。
        :type ScanVulProgress: int
        :param _ScanRiskProgress: 敏感扫描进度
注意：此字段可能返回 null，表示取不到有效值。
        :type ScanRiskProgress: int
        :param _ScanRemainTime: 剩余扫描时间秒
注意：此字段可能返回 null，表示取不到有效值。
        :type ScanRemainTime: int
        :param _CveStatus: cve扫描状态
注意：此字段可能返回 null，表示取不到有效值。
        :type CveStatus: str
        :param _RiskStatus: 高危扫描状态
注意：此字段可能返回 null，表示取不到有效值。
        :type RiskStatus: str
        :param _VirusStatus: 木马扫描状态
注意：此字段可能返回 null，表示取不到有效值。
        :type VirusStatus: str
        :param _Progress: 总进度
注意：此字段可能返回 null，表示取不到有效值。
        :type Progress: int
        :param _IsAuthorized: 授权状态
注意：此字段可能返回 null，表示取不到有效值。
        :type IsAuthorized: int
        :param _ImageSize: 镜像大小
注意：此字段可能返回 null，表示取不到有效值。
        :type ImageSize: int
        :param _ImageId: 镜像Id
注意：此字段可能返回 null，表示取不到有效值。
        :type ImageId: str
        :param _RegistryRegion: 镜像区域
注意：此字段可能返回 null，表示取不到有效值。
        :type RegistryRegion: str
        :param _ImageCreateTime: 镜像创建的时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ImageCreateTime: str
        :param _SensitiveInfoCnt: 敏感信息数
注意：此字段可能返回 null，表示取不到有效值。
        :type SensitiveInfoCnt: int
        :param _Id: Id
        :type Id: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ImageDigest = None
        self._ImageRepoAddress = None
        self._RegistryType = None
        self._ImageName = None
        self._ImageTag = None
        self._ScanTime = None
        self._ScanStatus = None
        self._VulCnt = None
        self._VirusCnt = None
        self._RiskCnt = None
        self._SentiveInfoCnt = None
        self._OsName = None
        self._ScanVirusError = None
        self._ScanVulError = None
        self._LayerInfo = None
        self._InstanceId = None
        self._InstanceName = None
        self._Namespace = None
        self._ScanRiskError = None
        self._ScanVirusProgress = None
        self._ScanVulProgress = None
        self._ScanRiskProgress = None
        self._ScanRemainTime = None
        self._CveStatus = None
        self._RiskStatus = None
        self._VirusStatus = None
        self._Progress = None
        self._IsAuthorized = None
        self._ImageSize = None
        self._ImageId = None
        self._RegistryRegion = None
        self._ImageCreateTime = None
        self._SensitiveInfoCnt = None
        self._Id = None
        self._RequestId = None

    @property
    def ImageDigest(self):
        return self._ImageDigest

    @ImageDigest.setter
    def ImageDigest(self, ImageDigest):
        self._ImageDigest = ImageDigest

    @property
    def ImageRepoAddress(self):
        return self._ImageRepoAddress

    @ImageRepoAddress.setter
    def ImageRepoAddress(self, ImageRepoAddress):
        self._ImageRepoAddress = ImageRepoAddress

    @property
    def RegistryType(self):
        return self._RegistryType

    @RegistryType.setter
    def RegistryType(self, RegistryType):
        self._RegistryType = RegistryType

    @property
    def ImageName(self):
        return self._ImageName

    @ImageName.setter
    def ImageName(self, ImageName):
        self._ImageName = ImageName

    @property
    def ImageTag(self):
        return self._ImageTag

    @ImageTag.setter
    def ImageTag(self, ImageTag):
        self._ImageTag = ImageTag

    @property
    def ScanTime(self):
        return self._ScanTime

    @ScanTime.setter
    def ScanTime(self, ScanTime):
        self._ScanTime = ScanTime

    @property
    def ScanStatus(self):
        return self._ScanStatus

    @ScanStatus.setter
    def ScanStatus(self, ScanStatus):
        self._ScanStatus = ScanStatus

    @property
    def VulCnt(self):
        return self._VulCnt

    @VulCnt.setter
    def VulCnt(self, VulCnt):
        self._VulCnt = VulCnt

    @property
    def VirusCnt(self):
        return self._VirusCnt

    @VirusCnt.setter
    def VirusCnt(self, VirusCnt):
        self._VirusCnt = VirusCnt

    @property
    def RiskCnt(self):
        return self._RiskCnt

    @RiskCnt.setter
    def RiskCnt(self, RiskCnt):
        self._RiskCnt = RiskCnt

    @property
    def SentiveInfoCnt(self):
        warnings.warn("parameter `SentiveInfoCnt` is deprecated", DeprecationWarning) 

        return self._SentiveInfoCnt

    @SentiveInfoCnt.setter
    def SentiveInfoCnt(self, SentiveInfoCnt):
        warnings.warn("parameter `SentiveInfoCnt` is deprecated", DeprecationWarning) 

        self._SentiveInfoCnt = SentiveInfoCnt

    @property
    def OsName(self):
        return self._OsName

    @OsName.setter
    def OsName(self, OsName):
        self._OsName = OsName

    @property
    def ScanVirusError(self):
        return self._ScanVirusError

    @ScanVirusError.setter
    def ScanVirusError(self, ScanVirusError):
        self._ScanVirusError = ScanVirusError

    @property
    def ScanVulError(self):
        return self._ScanVulError

    @ScanVulError.setter
    def ScanVulError(self, ScanVulError):
        self._ScanVulError = ScanVulError

    @property
    def LayerInfo(self):
        return self._LayerInfo

    @LayerInfo.setter
    def LayerInfo(self, LayerInfo):
        self._LayerInfo = LayerInfo

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def Namespace(self):
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace

    @property
    def ScanRiskError(self):
        return self._ScanRiskError

    @ScanRiskError.setter
    def ScanRiskError(self, ScanRiskError):
        self._ScanRiskError = ScanRiskError

    @property
    def ScanVirusProgress(self):
        return self._ScanVirusProgress

    @ScanVirusProgress.setter
    def ScanVirusProgress(self, ScanVirusProgress):
        self._ScanVirusProgress = ScanVirusProgress

    @property
    def ScanVulProgress(self):
        return self._ScanVulProgress

    @ScanVulProgress.setter
    def ScanVulProgress(self, ScanVulProgress):
        self._ScanVulProgress = ScanVulProgress

    @property
    def ScanRiskProgress(self):
        return self._ScanRiskProgress

    @ScanRiskProgress.setter
    def ScanRiskProgress(self, ScanRiskProgress):
        self._ScanRiskProgress = ScanRiskProgress

    @property
    def ScanRemainTime(self):
        return self._ScanRemainTime

    @ScanRemainTime.setter
    def ScanRemainTime(self, ScanRemainTime):
        self._ScanRemainTime = ScanRemainTime

    @property
    def CveStatus(self):
        return self._CveStatus

    @CveStatus.setter
    def CveStatus(self, CveStatus):
        self._CveStatus = CveStatus

    @property
    def RiskStatus(self):
        return self._RiskStatus

    @RiskStatus.setter
    def RiskStatus(self, RiskStatus):
        self._RiskStatus = RiskStatus

    @property
    def VirusStatus(self):
        return self._VirusStatus

    @VirusStatus.setter
    def VirusStatus(self, VirusStatus):
        self._VirusStatus = VirusStatus

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def IsAuthorized(self):
        return self._IsAuthorized

    @IsAuthorized.setter
    def IsAuthorized(self, IsAuthorized):
        self._IsAuthorized = IsAuthorized

    @property
    def ImageSize(self):
        return self._ImageSize

    @ImageSize.setter
    def ImageSize(self, ImageSize):
        self._ImageSize = ImageSize

    @property
    def ImageId(self):
        return self._ImageId

    @ImageId.setter
    def ImageId(self, ImageId):
        self._ImageId = ImageId

    @property
    def RegistryRegion(self):
        return self._RegistryRegion

    @RegistryRegion.setter
    def RegistryRegion(self, RegistryRegion):
        self._RegistryRegion = RegistryRegion

    @property
    def ImageCreateTime(self):
        return self._ImageCreateTime

    @ImageCreateTime.setter
    def ImageCreateTime(self, ImageCreateTime):
        self._ImageCreateTime = ImageCreateTime

    @property
    def SensitiveInfoCnt(self):
        return self._SensitiveInfoCnt

    @SensitiveInfoCnt.setter
    def SensitiveInfoCnt(self, SensitiveInfoCnt):
        self._SensitiveInfoCnt = SensitiveInfoCnt

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ImageDigest = params.get("ImageDigest")
        self._ImageRepoAddress = params.get("ImageRepoAddress")
        self._RegistryType = params.get("RegistryType")
        self._ImageName = params.get("ImageName")
        self._ImageTag = params.get("ImageTag")
        self._ScanTime = params.get("ScanTime")
        self._ScanStatus = params.get("ScanStatus")
        self._VulCnt = params.get("VulCnt")
        self._VirusCnt = params.get("VirusCnt")
        self._RiskCnt = params.get("RiskCnt")
        self._SentiveInfoCnt = params.get("SentiveInfoCnt")
        self._OsName = params.get("OsName")
        self._ScanVirusError = params.get("ScanVirusError")
        self._ScanVulError = params.get("ScanVulError")
        self._LayerInfo = params.get("LayerInfo")
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._Namespace = params.get("Namespace")
        self._ScanRiskError = params.get("ScanRiskError")
        self._ScanVirusProgress = params.get("ScanVirusProgress")
        self._ScanVulProgress = params.get("ScanVulProgress")
        self._ScanRiskProgress = params.get("ScanRiskProgress")
        self._ScanRemainTime = params.get("ScanRemainTime")
        self._CveStatus = params.get("CveStatus")
        self._RiskStatus = params.get("RiskStatus")
        self._VirusStatus = params.get("VirusStatus")
        self._Progress = params.get("Progress")
        self._IsAuthorized = params.get("IsAuthorized")
        self._ImageSize = params.get("ImageSize")
        self._ImageId = params.get("ImageId")
        self._RegistryRegion = params.get("RegistryRegion")
        self._ImageCreateTime = params.get("ImageCreateTime")
        self._SensitiveInfoCnt = params.get("SensitiveInfoCnt")
        self._Id = params.get("Id")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRegistryListExportRequest(AbstractModel):
    """DescribeAssetImageRegistryListExport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ExportField: 导出字段
        :type ExportField: list of str
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0
        :type Offset: int
        :param _Filters: 排序字段
        :type Filters: list of AssetFilters
        :param _By: 排序字段
        :type By: str
        :param _Order: 排序方式，asc，desc
        :type Order: str
        :param _OnlyShowLatest: 是否仅展示repository版本最新的镜像，默认为false
        :type OnlyShowLatest: bool
        """
        self._ExportField = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None
        self._OnlyShowLatest = None

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def OnlyShowLatest(self):
        return self._OnlyShowLatest

    @OnlyShowLatest.setter
    def OnlyShowLatest(self, OnlyShowLatest):
        self._OnlyShowLatest = OnlyShowLatest


    def _deserialize(self, params):
        self._ExportField = params.get("ExportField")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        self._OnlyShowLatest = params.get("OnlyShowLatest")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryListExportResponse(AbstractModel):
    """DescribeAssetImageRegistryListExport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: excel文件下载地址
注意：此字段可能返回 null，表示取不到有效值。
        :type DownloadUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRegistryListRequest(AbstractModel):
    """DescribeAssetImageRegistryList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0
        :type Offset: int
        :param _Filters: 过滤字段
IsAuthorized是否授权，取值全部all，未授权0，已授权1
        :type Filters: list of AssetFilters
        :param _By: 排序字段
        :type By: str
        :param _Order: 排序方式，asc，desc
        :type Order: str
        :param _OnlyShowLatest: 是否仅展示各repository最新的镜像, 默认为false
        :type OnlyShowLatest: bool
        :param _IsRunning: 是否仅展示运行中容器镜像
        :type IsRunning: bool
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None
        self._OnlyShowLatest = None
        self._IsRunning = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def OnlyShowLatest(self):
        return self._OnlyShowLatest

    @OnlyShowLatest.setter
    def OnlyShowLatest(self, OnlyShowLatest):
        self._OnlyShowLatest = OnlyShowLatest

    @property
    def IsRunning(self):
        return self._IsRunning

    @IsRunning.setter
    def IsRunning(self, IsRunning):
        self._IsRunning = IsRunning


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        self._OnlyShowLatest = params.get("OnlyShowLatest")
        self._IsRunning = params.get("IsRunning")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryListResponse(AbstractModel):
    """DescribeAssetImageRegistryList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 镜像仓库列表
注意：此字段可能返回 null，表示取不到有效值。
        :type List: list of ImageRepoInfo
        :param _TotalCount: 总数量
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ImageRepoInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRegistryRegistryDetailRequest(AbstractModel):
    """DescribeAssetImageRegistryRegistryDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RegistryId: 仓库唯一id
        :type RegistryId: int
        """
        self._RegistryId = None

    @property
    def RegistryId(self):
        return self._RegistryId

    @RegistryId.setter
    def RegistryId(self, RegistryId):
        self._RegistryId = RegistryId


    def _deserialize(self, params):
        self._RegistryId = params.get("RegistryId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryRegistryDetailResponse(AbstractModel):
    """DescribeAssetImageRegistryRegistryDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 仓库名
        :type Name: str
        :param _Username: 用户名
        :type Username: str
        :param _Password: 密码
        :type Password: str
        :param _Url: 仓库url
        :type Url: str
        :param _RegistryType: 仓库类型，列表：harbor
        :type RegistryType: str
        :param _RegistryVersion: 仓库版本
注意：此字段可能返回 null，表示取不到有效值。
        :type RegistryVersion: str
        :param _NetType: 网络类型，列表：public（公网）,private（私网）
        :type NetType: str
        :param _RegistryRegion: 区域，列表:default（默认）
注意：此字段可能返回 null，表示取不到有效值。
        :type RegistryRegion: str
        :param _SpeedLimit: 限速
注意：此字段可能返回 null，表示取不到有效值。
        :type SpeedLimit: int
        :param _Insecure: 安全模式（证书校验）：0（默认） 非安全模式（跳过证书校验）：1
注意：此字段可能返回 null，表示取不到有效值。
        :type Insecure: int
        :param _ConnDetectDetail: 联通性检测结果详情
        :type ConnDetectDetail: list of RegistryConnDetectResult
        :param _InstanceID: tcr情况下instance_id
        :type InstanceID: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Name = None
        self._Username = None
        self._Password = None
        self._Url = None
        self._RegistryType = None
        self._RegistryVersion = None
        self._NetType = None
        self._RegistryRegion = None
        self._SpeedLimit = None
        self._Insecure = None
        self._ConnDetectDetail = None
        self._InstanceID = None
        self._RequestId = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Username(self):
        return self._Username

    @Username.setter
    def Username(self, Username):
        self._Username = Username

    @property
    def Password(self):
        return self._Password

    @Password.setter
    def Password(self, Password):
        self._Password = Password

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def RegistryType(self):
        return self._RegistryType

    @RegistryType.setter
    def RegistryType(self, RegistryType):
        self._RegistryType = RegistryType

    @property
    def RegistryVersion(self):
        return self._RegistryVersion

    @RegistryVersion.setter
    def RegistryVersion(self, RegistryVersion):
        self._RegistryVersion = RegistryVersion

    @property
    def NetType(self):
        return self._NetType

    @NetType.setter
    def NetType(self, NetType):
        self._NetType = NetType

    @property
    def RegistryRegion(self):
        return self._RegistryRegion

    @RegistryRegion.setter
    def RegistryRegion(self, RegistryRegion):
        self._RegistryRegion = RegistryRegion

    @property
    def SpeedLimit(self):
        return self._SpeedLimit

    @SpeedLimit.setter
    def SpeedLimit(self, SpeedLimit):
        self._SpeedLimit = SpeedLimit

    @property
    def Insecure(self):
        return self._Insecure

    @Insecure.setter
    def Insecure(self, Insecure):
        self._Insecure = Insecure

    @property
    def ConnDetectDetail(self):
        return self._ConnDetectDetail

    @ConnDetectDetail.setter
    def ConnDetectDetail(self, ConnDetectDetail):
        self._ConnDetectDetail = ConnDetectDetail

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Username = params.get("Username")
        self._Password = params.get("Password")
        self._Url = params.get("Url")
        self._RegistryType = params.get("RegistryType")
        self._RegistryVersion = params.get("RegistryVersion")
        self._NetType = params.get("NetType")
        self._RegistryRegion = params.get("RegistryRegion")
        self._SpeedLimit = params.get("SpeedLimit")
        self._Insecure = params.get("Insecure")
        if params.get("ConnDetectDetail") is not None:
            self._ConnDetectDetail = []
            for item in params.get("ConnDetectDetail"):
                obj = RegistryConnDetectResult()
                obj._deserialize(item)
                self._ConnDetectDetail.append(obj)
        self._InstanceID = params.get("InstanceID")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRegistryRegistryListRequest(AbstractModel):
    """DescribeAssetImageRegistryRegistryList请求参数结构体

    """


class DescribeAssetImageRegistryRegistryListResponse(AbstractModel):
    """DescribeAssetImageRegistryRegistryList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRegistryRiskInfoListRequest(AbstractModel):
    """DescribeAssetImageRegistryRiskInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Level- String - 是否必填：否 - 漏洞级别筛选，</li>
<li>Name - String - 是否必填：否 - 漏洞名称</li>
        :type Filters: list of AssetFilters
        :param _ImageInfo: 镜像id
        :type ImageInfo: :class:`tencentcloud.tcss.v20201101.models.ImageInfo`
        :param _By: 排序字段（Level）
        :type By: str
        :param _Order: 排序方式 + -
        :type Order: str
        :param _Id: 镜像标识Id
        :type Id: int
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._ImageInfo = None
        self._By = None
        self._Order = None
        self._Id = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ImageInfo(self):
        return self._ImageInfo

    @ImageInfo.setter
    def ImageInfo(self, ImageInfo):
        self._ImageInfo = ImageInfo

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("ImageInfo") is not None:
            self._ImageInfo = ImageInfo()
            self._ImageInfo._deserialize(params.get("ImageInfo"))
        self._By = params.get("By")
        self._Order = params.get("Order")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryRiskInfoListResponse(AbstractModel):
    """DescribeAssetImageRegistryRiskInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 镜像漏洞列表
注意：此字段可能返回 null，表示取不到有效值。
        :type List: list of ImageRisk
        :param _TotalCount: 总数量
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ImageRisk()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRegistryRiskListExportRequest(AbstractModel):
    """DescribeAssetImageRegistryRiskListExport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ExportField: 导出字段
        :type ExportField: list of str
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Level- String - 是否必填：否 - 漏洞级别筛选，</li>
<li>Name - String - 是否必填：否 - 漏洞名称</li>
        :type Filters: list of AssetFilters
        :param _ImageInfo: 镜像信息
        :type ImageInfo: :class:`tencentcloud.tcss.v20201101.models.ImageInfo`
        :param _Id: 镜像标识Id
        :type Id: int
        """
        self._ExportField = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._ImageInfo = None
        self._Id = None

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ImageInfo(self):
        return self._ImageInfo

    @ImageInfo.setter
    def ImageInfo(self, ImageInfo):
        self._ImageInfo = ImageInfo

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._ExportField = params.get("ExportField")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("ImageInfo") is not None:
            self._ImageInfo = ImageInfo()
            self._ImageInfo._deserialize(params.get("ImageInfo"))
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryRiskListExportResponse(AbstractModel):
    """DescribeAssetImageRegistryRiskListExport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: excel文件下载地址
注意：此字段可能返回 null，表示取不到有效值。
        :type DownloadUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRegistryScanStatusOneKeyRequest(AbstractModel):
    """DescribeAssetImageRegistryScanStatusOneKey请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Images: 需要获取进度的镜像列表
        :type Images: list of ImageInfo
        :param _All: 是否获取全部镜像
        :type All: bool
        :param _Id: 需要获取进度的镜像列表Id
        :type Id: list of int non-negative
        :param _TaskID: 获取进度的任务ID
        :type TaskID: int
        """
        self._Images = None
        self._All = None
        self._Id = None
        self._TaskID = None

    @property
    def Images(self):
        return self._Images

    @Images.setter
    def Images(self, Images):
        self._Images = Images

    @property
    def All(self):
        return self._All

    @All.setter
    def All(self, All):
        self._All = All

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def TaskID(self):
        return self._TaskID

    @TaskID.setter
    def TaskID(self, TaskID):
        self._TaskID = TaskID


    def _deserialize(self, params):
        if params.get("Images") is not None:
            self._Images = []
            for item in params.get("Images"):
                obj = ImageInfo()
                obj._deserialize(item)
                self._Images.append(obj)
        self._All = params.get("All")
        self._Id = params.get("Id")
        self._TaskID = params.get("TaskID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryScanStatusOneKeyResponse(AbstractModel):
    """DescribeAssetImageRegistryScanStatusOneKey返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ImageTotal: 镜像个数
        :type ImageTotal: int
        :param _ImageScanCnt: 扫描镜像个数
        :type ImageScanCnt: int
        :param _ImageStatus: 扫描进度列表
注意：此字段可能返回 null，表示取不到有效值。
        :type ImageStatus: list of ImageProgress
        :param _SuccessCount: 安全个数
        :type SuccessCount: int
        :param _RiskCount: 风险个数
        :type RiskCount: int
        :param _Schedule: 总的扫描进度
        :type Schedule: int
        :param _Status: 总的扫描状态
        :type Status: str
        :param _ScanRemainTime: 扫描剩余时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ScanRemainTime: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ImageTotal = None
        self._ImageScanCnt = None
        self._ImageStatus = None
        self._SuccessCount = None
        self._RiskCount = None
        self._Schedule = None
        self._Status = None
        self._ScanRemainTime = None
        self._RequestId = None

    @property
    def ImageTotal(self):
        return self._ImageTotal

    @ImageTotal.setter
    def ImageTotal(self, ImageTotal):
        self._ImageTotal = ImageTotal

    @property
    def ImageScanCnt(self):
        return self._ImageScanCnt

    @ImageScanCnt.setter
    def ImageScanCnt(self, ImageScanCnt):
        self._ImageScanCnt = ImageScanCnt

    @property
    def ImageStatus(self):
        return self._ImageStatus

    @ImageStatus.setter
    def ImageStatus(self, ImageStatus):
        self._ImageStatus = ImageStatus

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def RiskCount(self):
        return self._RiskCount

    @RiskCount.setter
    def RiskCount(self, RiskCount):
        self._RiskCount = RiskCount

    @property
    def Schedule(self):
        return self._Schedule

    @Schedule.setter
    def Schedule(self, Schedule):
        self._Schedule = Schedule

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ScanRemainTime(self):
        return self._ScanRemainTime

    @ScanRemainTime.setter
    def ScanRemainTime(self, ScanRemainTime):
        self._ScanRemainTime = ScanRemainTime

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ImageTotal = params.get("ImageTotal")
        self._ImageScanCnt = params.get("ImageScanCnt")
        if params.get("ImageStatus") is not None:
            self._ImageStatus = []
            for item in params.get("ImageStatus"):
                obj = ImageProgress()
                obj._deserialize(item)
                self._ImageStatus.append(obj)
        self._SuccessCount = params.get("SuccessCount")
        self._RiskCount = params.get("RiskCount")
        self._Schedule = params.get("Schedule")
        self._Status = params.get("Status")
        self._ScanRemainTime = params.get("ScanRemainTime")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRegistrySummaryRequest(AbstractModel):
    """DescribeAssetImageRegistrySummary请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤字段
        :type Filters: list of AssetFilters
        """
        self._Filters = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistrySummaryResponse(AbstractModel):
    """DescribeAssetImageRegistrySummary返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRegistryVirusListExportRequest(AbstractModel):
    """DescribeAssetImageRegistryVirusListExport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ExportField: 导出字段
        :type ExportField: list of str
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Level- String - 是否必填：否 - 漏洞级别筛选，</li>
<li>Name - String - 是否必填：否 - 漏洞名称</li>
        :type Filters: list of AssetFilters
        :param _ImageInfo: 镜像信息
        :type ImageInfo: :class:`tencentcloud.tcss.v20201101.models.ImageInfo`
        :param _Id: 镜像标识Id
        :type Id: int
        """
        self._ExportField = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._ImageInfo = None
        self._Id = None

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ImageInfo(self):
        return self._ImageInfo

    @ImageInfo.setter
    def ImageInfo(self, ImageInfo):
        self._ImageInfo = ImageInfo

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._ExportField = params.get("ExportField")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("ImageInfo") is not None:
            self._ImageInfo = ImageInfo()
            self._ImageInfo._deserialize(params.get("ImageInfo"))
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryVirusListExportResponse(AbstractModel):
    """DescribeAssetImageRegistryVirusListExport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: excel文件下载地址
注意：此字段可能返回 null，表示取不到有效值。
        :type DownloadUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRegistryVirusListRequest(AbstractModel):
    """DescribeAssetImageRegistryVirusList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Level- String - 是否必填：否 - 漏洞级别筛选，</li>
<li>Name - String - 是否必填：否 - 漏洞名称</li>
        :type Filters: list of AssetFilters
        :param _ImageInfo: 镜像信息
        :type ImageInfo: :class:`tencentcloud.tcss.v20201101.models.ImageInfo`
        :param _Id: 镜像标识Id
        :type Id: int
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._ImageInfo = None
        self._Id = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ImageInfo(self):
        return self._ImageInfo

    @ImageInfo.setter
    def ImageInfo(self, ImageInfo):
        self._ImageInfo = ImageInfo

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("ImageInfo") is not None:
            self._ImageInfo = ImageInfo()
            self._ImageInfo._deserialize(params.get("ImageInfo"))
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryVirusListResponse(AbstractModel):
    """DescribeAssetImageRegistryVirusList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 镜像漏洞列表
注意：此字段可能返回 null，表示取不到有效值。
        :type List: list of ImageVirus
        :param _TotalCount: 总数量
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ImageVirus()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRegistryVulListExportRequest(AbstractModel):
    """DescribeAssetImageRegistryVulListExport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ExportField: 导出字段
        :type ExportField: list of str
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Level- String - 是否必填：否 - 漏洞级别筛选，</li>
<li>Name - String - 是否必填：否 - 漏洞名称</li>
        :type Filters: list of AssetFilters
        :param _ImageInfo: 镜像信息
        :type ImageInfo: :class:`tencentcloud.tcss.v20201101.models.ImageInfo`
        :param _Id: 镜像标识Id
        :type Id: int
        """
        self._ExportField = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._ImageInfo = None
        self._Id = None

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ImageInfo(self):
        return self._ImageInfo

    @ImageInfo.setter
    def ImageInfo(self, ImageInfo):
        self._ImageInfo = ImageInfo

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._ExportField = params.get("ExportField")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("ImageInfo") is not None:
            self._ImageInfo = ImageInfo()
            self._ImageInfo._deserialize(params.get("ImageInfo"))
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryVulListExportResponse(AbstractModel):
    """DescribeAssetImageRegistryVulListExport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: excel文件下载地址
注意：此字段可能返回 null，表示取不到有效值。
        :type DownloadUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRegistryVulListRequest(AbstractModel):
    """DescribeAssetImageRegistryVulList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Level- String - 是否必填：否 - 漏洞级别筛选，</li>
<li>Name - String - 是否必填：否 - 漏洞名称</li>
        :type Filters: list of AssetFilters
        :param _ImageInfo: 镜像信息
        :type ImageInfo: :class:`tencentcloud.tcss.v20201101.models.ImageInfo`
        :param _Id: 镜像标识Id
        :type Id: int
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._ImageInfo = None
        self._Id = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ImageInfo(self):
        return self._ImageInfo

    @ImageInfo.setter
    def ImageInfo(self, ImageInfo):
        self._ImageInfo = ImageInfo

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("ImageInfo") is not None:
            self._ImageInfo = ImageInfo()
            self._ImageInfo._deserialize(params.get("ImageInfo"))
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryVulListResponse(AbstractModel):
    """DescribeAssetImageRegistryVulList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 镜像漏洞列表
注意：此字段可能返回 null，表示取不到有效值。
        :type List: list of ImageVul
        :param _TotalCount: 总数量
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ImageVul()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRiskListExportRequest(AbstractModel):
    """DescribeAssetImageRiskListExport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ExportField: 导出字段
        :type ExportField: list of str
        :param _ImageID: 镜像id
        :type ImageID: str
        :param _Filters: 过滤条件。
<li>Level- String - 是否必填：否 - 风险级别 1,2,3,4，</li>
<li>Behavior - String - 是否必填：否 - 风险行为 1,2,3,4</li>
<li>Type - String - 是否必填：否 - 风险类型  1,2,</li>
        :type Filters: list of AssetFilters
        """
        self._ExportField = None
        self._ImageID = None
        self._Filters = None

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ExportField = params.get("ExportField")
        self._ImageID = params.get("ImageID")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRiskListExportResponse(AbstractModel):
    """DescribeAssetImageRiskListExport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: excel文件下载地址
        :type DownloadUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRiskListRequest(AbstractModel):
    """DescribeAssetImageRiskList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ImageID: 镜像id
        :type ImageID: str
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Level- String - 是否必填：否 - 风险级别 1,2,3,4，</li>
<li>Behavior - String - 是否必填：否 - 风险行为 1,2,3,4</li>
<li>Type - String - 是否必填：否 - 风险类型  1,2,</li>
        :type Filters: list of AssetFilters
        :param _By: 排序字段
        :type By: str
        :param _Order: 排序方式
        :type Order: str
        """
        self._ImageID = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._ImageID = params.get("ImageID")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRiskListResponse(AbstractModel):
    """DescribeAssetImageRiskList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 镜像病毒列表
        :type List: list of ImageRiskInfo
        :param _TotalCount: 总数量
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ImageRiskInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageScanSettingRequest(AbstractModel):
    """DescribeAssetImageScanSetting请求参数结构体

    """


class DescribeAssetImageScanSettingResponse(AbstractModel):
    """DescribeAssetImageScanSetting返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Enable: 开关
        :type Enable: bool
        :param _ScanTime: 扫描时刻(完整时间;后端按0时区解析时分秒)
        :type ScanTime: str
        :param _ScanPeriod: 扫描间隔
        :type ScanPeriod: int
        :param _ScanVirus: 扫描木马
        :type ScanVirus: bool
        :param _ScanRisk: 扫描敏感信息
        :type ScanRisk: bool
        :param _ScanVul: 扫描漏洞
        :type ScanVul: bool
        :param _All: 扫描全部镜像
        :type All: bool
        :param _Images: 自定义扫描镜像
        :type Images: list of str
        :param _ContainerRunning: 镜像是否存在运行中的容器
        :type ContainerRunning: bool
        :param _ScanScope: 扫描范围 0 全部授权镜像，1自选镜像，2 推荐扫描
        :type ScanScope: int
        :param _ScanEndTime: 扫描结束时间 02:00 时分
        :type ScanEndTime: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Enable = None
        self._ScanTime = None
        self._ScanPeriod = None
        self._ScanVirus = None
        self._ScanRisk = None
        self._ScanVul = None
        self._All = None
        self._Images = None
        self._ContainerRunning = None
        self._ScanScope = None
        self._ScanEndTime = None
        self._RequestId = None

    @property
    def Enable(self):
        return self._Enable

    @Enable.setter
    def Enable(self, Enable):
        self._Enable = Enable

    @property
    def ScanTime(self):
        return self._ScanTime

    @ScanTime.setter
    def ScanTime(self, ScanTime):
        self._ScanTime = ScanTime

    @property
    def ScanPeriod(self):
        return self._ScanPeriod

    @ScanPeriod.setter
    def ScanPeriod(self, ScanPeriod):
        self._ScanPeriod = ScanPeriod

    @property
    def ScanVirus(self):
        return self._ScanVirus

    @ScanVirus.setter
    def ScanVirus(self, ScanVirus):
        self._ScanVirus = ScanVirus

    @property
    def ScanRisk(self):
        return self._ScanRisk

    @ScanRisk.setter
    def ScanRisk(self, ScanRisk):
        self._ScanRisk = ScanRisk

    @property
    def ScanVul(self):
        return self._ScanVul

    @ScanVul.setter
    def ScanVul(self, ScanVul):
        self._ScanVul = ScanVul

    @property
    def All(self):
        warnings.warn("parameter `All` is deprecated", DeprecationWarning) 

        return self._All

    @All.setter
    def All(self, All):
        warnings.warn("parameter `All` is deprecated", DeprecationWarning) 

        self._All = All

    @property
    def Images(self):
        return self._Images

    @Images.setter
    def Images(self, Images):
        self._Images = Images

    @property
    def ContainerRunning(self):
        return self._ContainerRunning

    @ContainerRunning.setter
    def ContainerRunning(self, ContainerRunning):
        self._ContainerRunning = ContainerRunning

    @property
    def ScanScope(self):
        return self._ScanScope

    @ScanScope.setter
    def ScanScope(self, ScanScope):
        self._ScanScope = ScanScope

    @property
    def ScanEndTime(self):
        return self._ScanEndTime

    @ScanEndTime.setter
    def ScanEndTime(self, ScanEndTime):
        self._ScanEndTime = ScanEndTime

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Enable = params.get("Enable")
        self._ScanTime = params.get("ScanTime")
        self._ScanPeriod = params.get("ScanPeriod")
        self._ScanVirus = params.get("ScanVirus")
        self._ScanRisk = params.get("ScanRisk")
        self._ScanVul = params.get("ScanVul")
        self._All = params.get("All")
        self._Images = params.get("Images")
        self._ContainerRunning = params.get("ContainerRunning")
        self._ScanScope = params.get("ScanScope")
        self._ScanEndTime = params.get("ScanEndTime")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageScanStatusRequest(AbstractModel):
    """DescribeAssetImageScanStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskID: 任务id
        :type TaskID: str
        """
        self._TaskID = None

    @property
    def TaskID(self):
        return self._TaskID

    @TaskID.setter
    def TaskID(self, TaskID):
        self._TaskID = TaskID


    def _deserialize(self, params):
        self._TaskID = params.get("TaskID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageScanStatusResponse(AbstractModel):
    """DescribeAssetImageScanStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ImageTotal: 镜像个数
        :type ImageTotal: int
        :param _ImageScanCnt: 扫描镜像个数
        :type ImageScanCnt: int
        :param _Status: 扫描状态
        :type Status: str
        :param _Schedule: 扫描进度 ImageScanCnt/ImageTotal *100
        :type Schedule: int
        :param _SuccessCount: 安全个数
        :type SuccessCount: int
        :param _RiskCount: 风险个数
        :type RiskCount: int
        :param _LeftSeconds: 剩余扫描时间
        :type LeftSeconds: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ImageTotal = None
        self._ImageScanCnt = None
        self._Status = None
        self._Schedule = None
        self._SuccessCount = None
        self._RiskCount = None
        self._LeftSeconds = None
        self._RequestId = None

    @property
    def ImageTotal(self):
        return self._ImageTotal

    @ImageTotal.setter
    def ImageTotal(self, ImageTotal):
        self._ImageTotal = ImageTotal

    @property
    def ImageScanCnt(self):
        return self._ImageScanCnt

    @ImageScanCnt.setter
    def ImageScanCnt(self, ImageScanCnt):
        self._ImageScanCnt = ImageScanCnt

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Schedule(self):
        return self._Schedule

    @Schedule.setter
    def Schedule(self, Schedule):
        self._Schedule = Schedule

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def RiskCount(self):
        return self._RiskCount

    @RiskCount.setter
    def RiskCount(self, RiskCount):
        self._RiskCount = RiskCount

    @property
    def LeftSeconds(self):
        return self._LeftSeconds

    @LeftSeconds.setter
    def LeftSeconds(self, LeftSeconds):
        self._LeftSeconds = LeftSeconds

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ImageTotal = params.get("ImageTotal")
        self._ImageScanCnt = params.get("ImageScanCnt")
        self._Status = params.get("Status")
        self._Schedule = params.get("Schedule")
        self._SuccessCount = params.get("SuccessCount")
        self._RiskCount = params.get("RiskCount")
        self._LeftSeconds = params.get("LeftSeconds")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageScanTaskRequest(AbstractModel):
    """DescribeAssetImageScanTask请求参数结构体

    """


class DescribeAssetImageScanTaskResponse(AbstractModel):
    """DescribeAssetImageScanTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskID: 任务id
        :type TaskID: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskID = None
        self._RequestId = None

    @property
    def TaskID(self):
        return self._TaskID

    @TaskID.setter
    def TaskID(self, TaskID):
        self._TaskID = TaskID

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskID = params.get("TaskID")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageSimpleListRequest(AbstractModel):
    """DescribeAssetImageSimpleList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Keywords- String - 是否必填：否 - 镜像名、镜像id 称筛选，</li>
        :type Filters: list of AssetFilters
        :param _By: 排序字段
        :type By: str
        :param _Order: 排序方式 asc,desc
        :type Order: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageSimpleListResponse(AbstractModel):
    """DescribeAssetImageSimpleList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 镜像列表
        :type List: list of AssetSimpleImageInfo
        :param _TotalCount: 总数量
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = AssetSimpleImageInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageVirusListExportRequest(AbstractModel):
    """DescribeAssetImageVirusListExport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ExportField: 列表支持字段
        :type ExportField: list of str
        :param _ImageID: 镜像id
        :type ImageID: str
        :param _Filters: 过滤条件。
<li>Name- String - 是否必填：否 - 镜像名称筛选，</li>
<li>RiskLevel - String - 是否必填：否 - 风险等级  1,2,3,4</li>
        :type Filters: list of AssetFilters
        """
        self._ExportField = None
        self._ImageID = None
        self._Filters = None

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ExportField = params.get("ExportField")
        self._ImageID = params.get("ImageID")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageVirusListExportResponse(AbstractModel):
    """DescribeAssetImageVirusListExport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: excel文件下载地址
        :type DownloadUrl: str
        :param _JobId: 任务ID
        :type JobId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._JobId = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageVirusListRequest(AbstractModel):
    """DescribeAssetImageVirusList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ImageID: 镜像id
        :type ImageID: str
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Name- String - 是否必填：否 - 镜像名称筛选，</li>
<li>RiskLevel - String - 是否必填：否 - 风险等级  1,2,3,4</li>
        :type Filters: list of AssetFilters
        :param _Order: 排序 asc desc
        :type Order: str
        :param _By: 排序字段
        :type By: str
        """
        self._ImageID = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._ImageID = params.get("ImageID")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageVirusListResponse(AbstractModel):
    """DescribeAssetImageVirusList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 镜像病毒列表
        :type List: list of ImageVirusInfo
        :param _TotalCount: 总数量
        :type TotalCount: int
        :param _VirusScanStatus: 病毒扫描状态
0:未扫描
1:扫描中
2:扫描完成
3:扫描出错
4:扫描取消
        :type VirusScanStatus: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._VirusScanStatus = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def VirusScanStatus(self):
        return self._VirusScanStatus

    @VirusScanStatus.setter
    def VirusScanStatus(self, VirusScanStatus):
        self._VirusScanStatus = VirusScanStatus

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ImageVirusInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._VirusScanStatus = params.get("VirusScanStatus")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageVulListExportRequest(AbstractModel):
    """DescribeAssetImageVulListExport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ExportField: 导出字段
        :type ExportField: list of str
        :param _ImageID: 镜像id
        :type ImageID: str
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Name- String - 是否必填：否 - 漏洞名称名称筛选，</li>
<li>Level - String - 是否必填：否 - 风险等级  1,2,3,4</li>
        :type Filters: list of AssetFilters
        """
        self._ExportField = None
        self._ImageID = None
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ExportField = params.get("ExportField")
        self._ImageID = params.get("ImageID")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageVulListExportResponse(AbstractModel):
    """DescribeAssetImageVulListExport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: excel文件下载地址
        :type DownloadUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageVulListRequest(AbstractModel):
    """DescribeAssetImageVulList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ImageID: 镜像id
        :type ImageID: str
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Name- String - 是否必填：否 - 漏洞名称名称筛选，</li>
<li>Level - String - 是否必填：否 - 风险等级  1,2,3,4</li>
        :type Filters: list of AssetFilters
        :param _By: 排序字段（Level）
        :type By: str
        :param _Order: 排序方式 + -
        :type Order: str
        """
        self._ImageID = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._ImageID = params.get("ImageID")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageVulListResponse(AbstractModel):
    """DescribeAssetImageVulList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 镜像漏洞列表
        :type List: list of ImagesVul
        :param _TotalCount: 总数量
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ImagesVul()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetPortListRequest(AbstractModel):
    """DescribeAssetPortList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>All - String - 是否必填：否 - 模糊查询可选字段</li>
<li>RunAs - String - 是否必填：否 - 运行用户筛选，</li>
<li>ContainerID - String - 是否必填：否 - 容器id</li>
<li>HostID- String - 是否必填：是 - 主机id</li>
<li>HostIP- string - 是否必填：否 - 主机ip搜索</li>
<li>ProcessName- string - 是否必填：否 - 进程名搜索</li>
        :type Filters: list of AssetFilters
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetPortListResponse(AbstractModel):
    """DescribeAssetPortList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 端口列表
        :type List: list of PortInfo
        :param _TotalCount: 总数量
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = PortInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetProcessListRequest(AbstractModel):
    """DescribeAssetProcessList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>RunAs - String - 是否必填：否 - 运行用户筛选，</li>
<li>ContainerID - String - 是否必填：否 - 容器id</li>
<li>HostID- String - 是否必填：是 - 主机id</li>
<li>HostIP- string - 是否必填：否 - 主机ip搜索</li>
<li>ProcessName- string - 是否必填：否 - 进程名搜索</li>
<li>Pid- string - 是否必填：否 - 进程id搜索(关联进程)</li>
        :type Filters: list of AssetFilters
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetProcessListResponse(AbstractModel):
    """DescribeAssetProcessList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 端口列表
        :type List: list of ProcessInfo
        :param _TotalCount: 总数量
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ProcessInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetSummaryRequest(AbstractModel):
    """DescribeAssetSummary请求参数结构体

    """


class DescribeAssetSummaryResponse(AbstractModel):
    """DescribeAssetSummary返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AppCnt: 应用个数
        :type AppCnt: int
        :param _ContainerCnt: 容器个数
        :type ContainerCnt: int
        :param _ContainerPause: 暂停的容器个数
        :type ContainerPause: int
        :param _ContainerRunning: 运行的容器个数
        :type ContainerRunning: int
        :param _ContainerStop: 停止运行的容器个数
        :type ContainerStop: int
        :param _CreateTime: 创建时间
        :type CreateTime: str
        :param _DbCnt: 数据库个数
        :type DbCnt: int
        :param _ImageCnt: 镜像个数
        :type ImageCnt: int
        :param _HostOnline: 主机在线个数
        :type HostOnline: int
        :param _HostCnt: 主机个数
        :type HostCnt: int
        :param _ImageHasRiskInfoCnt: 有风险的镜像个数
        :type ImageHasRiskInfoCnt: int
        :param _ImageHasVirusCnt: 有病毒的镜像个数
        :type ImageHasVirusCnt: int
        :param _ImageHasVulsCnt: 有漏洞的镜像个数
        :type ImageHasVulsCnt: int
        :param _ImageUntrustCnt: 不受信任的镜像个数
        :type ImageUntrustCnt: int
        :param _ListenPortCnt: 监听的端口个数
        :type ListenPortCnt: int
        :param _ProcessCnt: 进程个数
        :type ProcessCnt: int
        :param _WebServiceCnt: web服务个数
        :type WebServiceCnt: int
        :param _LatestImageScanTime: 最近镜像扫描时间
        :type LatestImageScanTime: str
        :param _ImageUnsafeCnt: 风险镜像个数
        :type ImageUnsafeCnt: int
        :param _HostUnInstallCnt: 主机未安装agent数量
        :type HostUnInstallCnt: int
        :param _SuperNodeCnt: 超级节点个数
        :type SuperNodeCnt: int
        :param _SuperNodeRunningCnt: 超级节点运行个数
        :type SuperNodeRunningCnt: int
        :param _TodayNewImageCnt: 今日新增镜像个数
        :type TodayNewImageCnt: int
        :param _TodayUnsafeImageCnt: 今日新增风险镜像个数
        :type TodayUnsafeImageCnt: int
        :param _RecommendedFixImageCnt: 推荐处置镜像个数
        :type RecommendedFixImageCnt: int
        :param _ScannedImageCnt: 已扫描镜像个数
        :type ScannedImageCnt: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AppCnt = None
        self._ContainerCnt = None
        self._ContainerPause = None
        self._ContainerRunning = None
        self._ContainerStop = None
        self._CreateTime = None
        self._DbCnt = None
        self._ImageCnt = None
        self._HostOnline = None
        self._HostCnt = None
        self._ImageHasRiskInfoCnt = None
        self._ImageHasVirusCnt = None
        self._ImageHasVulsCnt = None
        self._ImageUntrustCnt = None
        self._ListenPortCnt = None
        self._ProcessCnt = None
        self._WebServiceCnt = None
        self._LatestImageScanTime = None
        self._ImageUnsafeCnt = None
        self._HostUnInstallCnt = None
        self._SuperNodeCnt = None
        self._SuperNodeRunningCnt = None
        self._TodayNewImageCnt = None
        self._TodayUnsafeImageCnt = None
        self._RecommendedFixImageCnt = None
        self._ScannedImageCnt = None
        self._RequestId = None

    @property
    def AppCnt(self):
        return self._AppCnt

    @AppCnt.setter
    def AppCnt(self, AppCnt):
        self._AppCnt = AppCnt

    @property
    def ContainerCnt(self):
        return self._ContainerCnt

    @ContainerCnt.setter
    def ContainerCnt(self, ContainerCnt):
        self._ContainerCnt = ContainerCnt

    @property
    def ContainerPause(self):
        return self._ContainerPause

    @ContainerPause.setter
    def ContainerPause(self, ContainerPause):
        self._ContainerPause = ContainerPause

    @property
    def ContainerRunning(self):
        return self._ContainerRunning

    @ContainerRunning.setter
    def ContainerRunning(self, ContainerRunning):
        self._ContainerRunning = ContainerRunning

    @property
    def ContainerStop(self):
        return self._ContainerStop

    @ContainerStop.setter
    def ContainerStop(self, ContainerStop):
        self._ContainerStop = ContainerStop

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def DbCnt(self):
        return self._DbCnt

    @DbCnt.setter
    def DbCnt(self, DbCnt):
        self._DbCnt = DbCnt

    @property
    def ImageCnt(self):
        return self._ImageCnt

    @ImageCnt.setter
    def ImageCnt(self, ImageCnt):
        self._ImageCnt = ImageCnt

    @property
    def HostOnline(self):
        return self._HostOnline

    @HostOnline.setter
    def HostOnline(self, HostOnline):
        self._HostOnline = HostOnline

    @property
    def HostCnt(self):
        return self._HostCnt

    @HostCnt.setter
    def HostCnt(self, HostCnt):
        self._HostCnt = HostCnt

    @property
    def ImageHasRiskInfoCnt(self):
        return self._ImageHasRiskInfoCnt

    @ImageHasRiskInfoCnt.setter
    def ImageHasRiskInfoCnt(self, ImageHasRiskInfoCnt):
        self._ImageHasRiskInfoCnt = ImageHasRiskInfoCnt

    @property
    def ImageHasVirusCnt(self):
        return self._ImageHasVirusCnt

    @ImageHasVirusCnt.setter
    def ImageHasVirusCnt(self, ImageHasVirusCnt):
        self._ImageHasVirusCnt = ImageHasVirusCnt

    @property
    def ImageHasVulsCnt(self):
        return self._ImageHasVulsCnt

    @ImageHasVulsCnt.setter
    def ImageHasVulsCnt(self, ImageHasVulsCnt):
        self._ImageHasVulsCnt = ImageHasVulsCnt

    @property
    def ImageUntrustCnt(self):
        return self._ImageUntrustCnt

    @ImageUntrustCnt.setter
    def ImageUntrustCnt(self, ImageUntrustCnt):
        self._ImageUntrustCnt = ImageUntrustCnt

    @property
    def ListenPortCnt(self):
        return self._ListenPortCnt

    @ListenPortCnt.setter
    def ListenPortCnt(self, ListenPortCnt):
        self._ListenPortCnt = ListenPortCnt

    @property
    def ProcessCnt(self):
        return self._ProcessCnt

    @ProcessCnt.setter
    def ProcessCnt(self, ProcessCnt):
        self._ProcessCnt = ProcessCnt

    @property
    def WebServiceCnt(self):
        return self._WebServiceCnt

    @WebServiceCnt.setter
    def WebServiceCnt(self, WebServiceCnt):
        self._WebServiceCnt = WebServiceCnt

    @property
    def LatestImageScanTime(self):
        return self._LatestImageScanTime

    @LatestImageScanTime.setter
    def LatestImageScanTime(self, LatestImageScanTime):
        self._LatestImageScanTime = LatestImageScanTime

    @property
    def ImageUnsafeCnt(self):
        return self._ImageUnsafeCnt

    @ImageUnsafeCnt.setter
    def ImageUnsafeCnt(self, ImageUnsafeCnt):
        self._ImageUnsafeCnt = ImageUnsafeCnt

    @property
    def HostUnInstallCnt(self):
        return self._HostUnInstallCnt

    @HostUnInstallCnt.setter
    def HostUnInstallCnt(self, HostUnInstallCnt):
        self._HostUnInstallCnt = HostUnInstallCnt

    @property
    def SuperNodeCnt(self):
        return self._SuperNodeCnt

    @SuperNodeCnt.setter
    def SuperNodeCnt(self, SuperNodeCnt):
        self._SuperNodeCnt = SuperNodeCnt

    @property
    def SuperNodeRunningCnt(self):
        return self._SuperNodeRunningCnt

    @SuperNodeRunningCnt.setter
    def SuperNodeRunningCnt(self, SuperNodeRunningCnt):
        self._SuperNodeRunningCnt = SuperNodeRunningCnt

    @property
    def TodayNewImageCnt(self):
        return self._TodayNewImageCnt

    @TodayNewImageCnt.setter
    def TodayNewImageCnt(self, TodayNewImageCnt):
        self._TodayNewImageCnt = TodayNewImageCnt

    @property
    def TodayUnsafeImageCnt(self):
        return self._TodayUnsafeImageCnt

    @TodayUnsafeImageCnt.setter
    def TodayUnsafeImageCnt(self, TodayUnsafeImageCnt):
        self._TodayUnsafeImageCnt = TodayUnsafeImageCnt

    @property
    def RecommendedFixImageCnt(self):
        return self._RecommendedFixImageCnt

    @RecommendedFixImageCnt.setter
    def RecommendedFixImageCnt(self, RecommendedFixImageCnt):
        self._RecommendedFixImageCnt = RecommendedFixImageCnt

    @property
    def ScannedImageCnt(self):
        return self._ScannedImageCnt

    @ScannedImageCnt.setter
    def ScannedImageCnt(self, ScannedImageCnt):
        self._ScannedImageCnt = ScannedImageCnt

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AppCnt = params.get("AppCnt")
        self._ContainerCnt = params.get("ContainerCnt")
        self._ContainerPause = params.get("ContainerPause")
        self._ContainerRunning = params.get("ContainerRunning")
        self._ContainerStop = params.get("ContainerStop")
        self._CreateTime = params.get("CreateTime")
        self._DbCnt = params.get("DbCnt")
        self._ImageCnt = params.get("ImageCnt")
        self._HostOnline = params.get("HostOnline")
        self._HostCnt = params.get("HostCnt")
        self._ImageHasRiskInfoCnt = params.get("ImageHasRiskInfoCnt")
        self._ImageHasVirusCnt = params.get("ImageHasVirusCnt")
        self._ImageHasVulsCnt = params.get("ImageHasVulsCnt")
        self._ImageUntrustCnt = params.get("ImageUntrustCnt")
        self._ListenPortCnt = params.get("ListenPortCnt")
        self._ProcessCnt = params.get("ProcessCnt")
        self._WebServiceCnt = params.get("WebServiceCnt")
        self._LatestImageScanTime = params.get("LatestImageScanTime")
        self._ImageUnsafeCnt = params.get("ImageUnsafeCnt")
        self._HostUnInstallCnt = params.get("HostUnInstallCnt")
        self._SuperNodeCnt = params.get("SuperNodeCnt")
        self._SuperNodeRunningCnt = params.get("SuperNodeRunningCnt")
        self._TodayNewImageCnt = params.get("TodayNewImageCnt")
        self._TodayUnsafeImageCnt = params.get("TodayUnsafeImageCnt")
        self._RecommendedFixImageCnt = params.get("RecommendedFixImageCnt")
        self._ScannedImageCnt = params.get("ScannedImageCnt")
        self._RequestId = params.get("RequestId")


class DescribeAssetSuperNodeListRequest(AbstractModel):
    """DescribeAssetSuperNodeList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li>NodeID- String - 是否必填：否 - ID </li>
<li>NodeName- String - 是否必填：否 - 超级节点名称 </li>
<li>SubnetName- String - 是否必填：否 - VPC子网 </li>
<li>AgentStatus- String - 是否必填：否 - 安装状态UNINSTALL:未安装;INSTALLED:已安装;INSTALLING:安装中; </li>
        :type Filters: list of RunTimeFilters
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _By: 排序字段
        :type By: str
        :param _Order: 排序方式 asc,desc
        :type Order: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._By = None
        self._Order = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetSuperNodeListResponse(AbstractModel):
    """DescribeAssetSuperNodeList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 超级节点列表
        :type List: list of SuperNodeListItem
        :param _TotalCount: 总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = SuperNodeListItem()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetSyncLastTimeRequest(AbstractModel):
    """DescribeAssetSyncLastTime请求参数结构体

    """


class DescribeAssetSyncLastTimeResponse(AbstractModel):
    """DescribeAssetSyncLastTime返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AssetSyncLastTime: 资产最近同步时间
        :type AssetSyncLastTime: str
        :param _TaskStatus: 任务状态
PENDING:待处理
PROCESSING:处理中
PROCESSED:已完成
        :type TaskStatus: str
        :param _TaskProcess: 任务进度(百分比)
        :type TaskProcess: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AssetSyncLastTime = None
        self._TaskStatus = None
        self._TaskProcess = None
        self._RequestId = None

    @property
    def AssetSyncLastTime(self):
        return self._AssetSyncLastTime

    @AssetSyncLastTime.setter
    def AssetSyncLastTime(self, AssetSyncLastTime):
        self._AssetSyncLastTime = AssetSyncLastTime

    @property
    def TaskStatus(self):
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus

    @property
    def TaskProcess(self):
        return self._TaskProcess

    @TaskProcess.setter
    def TaskProcess(self, TaskProcess):
        self._TaskProcess = TaskProcess

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AssetSyncLastTime = params.get("AssetSyncLastTime")
        self._TaskStatus = params.get("TaskStatus")
        self._TaskProcess = params.get("TaskProcess")
        self._RequestId = params.get("RequestId")


class DescribeAssetWebServiceListRequest(AbstractModel):
    """DescribeAssetWebServiceList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Keywords- String - 是否必填：否 - 模糊查询可选字段</li>
<li>Type- String - 是否必填：否 - 主机运行状态筛选，"Apache"
"Jboss"
"lighttpd"
"Nginx"
"Tomcat"</li>
        :type Filters: list of AssetFilters
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetWebServiceListResponse(AbstractModel):
    """DescribeAssetWebServiceList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 主机列表
        :type List: list of ServiceInfo
        :param _TotalCount: 总数量
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ServiceInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAutoAuthorizedRuleHostRequest(AbstractModel):
    """DescribeAutoAuthorizedRuleHost请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleId: 规则id
        :type RuleId: int
        :param _Limit: 需要返回的数量，默认为全部；
        :type Limit: int
        :param _Offset: 偏移量，默认为0
        :type Offset: int
        :param _Order: 排序字段
        :type Order: str
        :param _By: 排序方式，asc，desc
        :type By: str
        """
        self._RuleId = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoAuthorizedRuleHostResponse(AbstractModel):
    """DescribeAutoAuthorizedRuleHost返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 镜像自动授权规则授权范围主机列表
        :type List: list of AutoAuthorizedRuleHostInfo
        :param _TotalCount: 总数量
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = AutoAuthorizedRuleHostInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeCheckItemListRequest(AbstractModel):
    """DescribeCheckItemList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 每次查询的最大记录数量
        :type Limit: int
        :param _Filters: Name 可取值：
Name: 检查项名称
RiskType: 风险类别
RiskLevel: 风险等级
RiskTarget: 检查对象
RiskAttribute: 检测项所属分型线类型
Enable: 检查项是否开启(0:关闭 1:开启)
        :type Filters: list of ComplianceFilters
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCheckItemListResponse(AbstractModel):
    """DescribeCheckItemList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterCheckItems: 检查项详情数组
        :type ClusterCheckItems: list of ClusterCheckItem
        :param _TotalCount: 检查项总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ClusterCheckItems = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def ClusterCheckItems(self):
        return self._ClusterCheckItems

    @ClusterCheckItems.setter
    def ClusterCheckItems(self, ClusterCheckItems):
        self._ClusterCheckItems = ClusterCheckItems

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ClusterCheckItems") is not None:
            self._ClusterCheckItems = []
            for item in params.get("ClusterCheckItems"):
                obj = ClusterCheckItem()
                obj._deserialize(item)
                self._ClusterCheckItems.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeClusterDetailRequest(AbstractModel):
    """DescribeClusterDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群id
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterDetailResponse(AbstractModel):
    """DescribeClusterDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群id
        :type ClusterId: str
        :param _ClusterName: 集群名字
        :type ClusterName: str
        :param _ScanTaskProgress: 当前集群扫描任务的进度，100表示扫描完成.
        :type ScanTaskProgress: int
        :param _ClusterVersion: 集群版本
        :type ClusterVersion: str
        :param _ContainerRuntime: 运行时组件
        :type ContainerRuntime: str
        :param _ClusterNodeNum: 集群节点数
        :type ClusterNodeNum: int
        :param _ClusterStatus: 集群状态 (Running 运行中 Creating 创建中 Abnormal 异常 )
        :type ClusterStatus: str
        :param _ClusterType: 集群类型：为托管集群MANAGED_CLUSTER、独立集群INDEPENDENT_CLUSTER
        :type ClusterType: str
        :param _Region: 集群区域
        :type Region: str
        :param _SeriousRiskCount: 严重风险检查项的数量
        :type SeriousRiskCount: int
        :param _HighRiskCount: 高风险检查项的数量
        :type HighRiskCount: int
        :param _MiddleRiskCount: 中风险检查项的数量
        :type MiddleRiskCount: int
        :param _HintRiskCount: 提示风险检查项的数量
        :type HintRiskCount: int
        :param _CheckStatus: 检查任务的状态
        :type CheckStatus: str
        :param _DefenderStatus: 防御容器状态
        :type DefenderStatus: str
        :param _TaskCreateTime: 扫描任务创建时间
        :type TaskCreateTime: str
        :param _NetworkType: 网络类型.PublicNetwork为公网类型,VPCNetwork为VPC网络
        :type NetworkType: str
        :param _ApiServerAddress: API Server地址
        :type ApiServerAddress: str
        :param _NodeCount: 节点数
        :type NodeCount: int
        :param _NamespaceCount: 命名空间数
        :type NamespaceCount: int
        :param _WorkloadCount: 工作负载数
        :type WorkloadCount: int
        :param _PodCount: Pod数量
        :type PodCount: int
        :param _ServiceCount: Service数量
        :type ServiceCount: int
        :param _IngressCount: Ingress数量
        :type IngressCount: int
        :param _MasterIps: 主节点的ip列表
        :type MasterIps: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ClusterId = None
        self._ClusterName = None
        self._ScanTaskProgress = None
        self._ClusterVersion = None
        self._ContainerRuntime = None
        self._ClusterNodeNum = None
        self._ClusterStatus = None
        self._ClusterType = None
        self._Region = None
        self._SeriousRiskCount = None
        self._HighRiskCount = None
        self._MiddleRiskCount = None
        self._HintRiskCount = None
        self._CheckStatus = None
        self._DefenderStatus = None
        self._TaskCreateTime = None
        self._NetworkType = None
        self._ApiServerAddress = None
        self._NodeCount = None
        self._NamespaceCount = None
        self._WorkloadCount = None
        self._PodCount = None
        self._ServiceCount = None
        self._IngressCount = None
        self._MasterIps = None
        self._RequestId = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def ScanTaskProgress(self):
        return self._ScanTaskProgress

    @ScanTaskProgress.setter
    def ScanTaskProgress(self, ScanTaskProgress):
        self._ScanTaskProgress = ScanTaskProgress

    @property
    def ClusterVersion(self):
        return self._ClusterVersion

    @ClusterVersion.setter
    def ClusterVersion(self, ClusterVersion):
        self._ClusterVersion = ClusterVersion

    @property
    def ContainerRuntime(self):
        return self._ContainerRuntime

    @ContainerRuntime.setter
    def ContainerRuntime(self, ContainerRuntime):
        self._ContainerRuntime = ContainerRuntime

    @property
    def ClusterNodeNum(self):
        return self._ClusterNodeNum

    @ClusterNodeNum.setter
    def ClusterNodeNum(self, ClusterNodeNum):
        self._ClusterNodeNum = ClusterNodeNum

    @property
    def ClusterStatus(self):
        return self._ClusterStatus

    @ClusterStatus.setter
    def ClusterStatus(self, ClusterStatus):
        self._ClusterStatus = ClusterStatus

    @property
    def ClusterType(self):
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def SeriousRiskCount(self):
        return self._SeriousRiskCount

    @SeriousRiskCount.setter
    def SeriousRiskCount(self, SeriousRiskCount):
        self._SeriousRiskCount = SeriousRiskCount

    @property
    def HighRiskCount(self):
        return self._HighRiskCount

    @HighRiskCount.setter
    def HighRiskCount(self, HighRiskCount):
        self._HighRiskCount = HighRiskCount

    @property
    def MiddleRiskCount(self):
        return self._MiddleRiskCount

    @MiddleRiskCount.setter
    def MiddleRiskCount(self, MiddleRiskCount):
        self._MiddleRiskCount = MiddleRiskCount

    @property
    def HintRiskCount(self):
        return self._HintRiskCount

    @HintRiskCount.setter
    def HintRiskCount(self, HintRiskCount):
        self._HintRiskCount = HintRiskCount

    @property
    def CheckStatus(self):
        return self._CheckStatus

    @CheckStatus.setter
    def CheckStatus(self, CheckStatus):
        self._CheckStatus = CheckStatus

    @property
    def DefenderStatus(self):
        return self._DefenderStatus

    @DefenderStatus.setter
    def DefenderStatus(self, DefenderStatus):
        self._DefenderStatus = DefenderStatus

    @property
    def TaskCreateTime(self):
        return self._TaskCreateTime

    @TaskCreateTime.setter
    def TaskCreateTime(self, TaskCreateTime):
        self._TaskCreateTime = TaskCreateTime

    @property
    def NetworkType(self):
        return self._NetworkType

    @NetworkType.setter
    def NetworkType(self, NetworkType):
        self._NetworkType = NetworkType

    @property
    def ApiServerAddress(self):
        return self._ApiServerAddress

    @ApiServerAddress.setter
    def ApiServerAddress(self, ApiServerAddress):
        self._ApiServerAddress = ApiServerAddress

    @property
    def NodeCount(self):
        return self._NodeCount

    @NodeCount.setter
    def NodeCount(self, NodeCount):
        self._NodeCount = NodeCount

    @property
    def NamespaceCount(self):
        return self._NamespaceCount

    @NamespaceCount.setter
    def NamespaceCount(self, NamespaceCount):
        self._NamespaceCount = NamespaceCount

    @property
    def WorkloadCount(self):
        return self._WorkloadCount

    @WorkloadCount.setter
    def WorkloadCount(self, WorkloadCount):
        self._WorkloadCount = WorkloadCount

    @property
    def PodCount(self):
        return self._PodCount

    @PodCount.setter
    def PodCount(self, PodCount):
        self._PodCount = PodCount

    @property
    def ServiceCount(self):
        return self._ServiceCount

    @ServiceCount.setter
    def ServiceCount(self, ServiceCount):
        self._ServiceCount = ServiceCount

    @property
    def IngressCount(self):
        return self._IngressCount

    @IngressCount.setter
    def IngressCount(self, IngressCount):
        self._IngressCount = IngressCount

    @property
    def MasterIps(self):
        return self._MasterIps

    @MasterIps.setter
    def MasterIps(self, MasterIps):
        self._MasterIps = MasterIps

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._ScanTaskProgress = params.get("ScanTaskProgress")
        self._ClusterVersion = params.get("ClusterVersion")
        self._ContainerRuntime = params.get("ContainerRuntime")
        self._ClusterNodeNum = params.get("ClusterNodeNum")
        self._ClusterStatus = params.get("ClusterStatus")
        self._ClusterType = params.get("ClusterType")
        self._Region = params.get("Region")
        self._SeriousRiskCount = params.get("SeriousRiskCount")
        self._HighRiskCount = params.get("HighRiskCount")
        self._MiddleRiskCount = params.get("MiddleRiskCount")
        self._HintRiskCount = params.get("HintRiskCount")
        self._CheckStatus = params.get("CheckStatus")
        self._DefenderStatus = params.get("DefenderStatus")
        self._TaskCreateTime = params.get("TaskCreateTime")
        self._NetworkType = params.get("NetworkType")
        self._ApiServerAddress = params.get("ApiServerAddress")
        self._NodeCount = params.get("NodeCount")
        self._NamespaceCount = params.get("NamespaceCount")
        self._WorkloadCount = params.get("WorkloadCount")
        self._PodCount = params.get("PodCount")
        self._ServiceCount = params.get("ServiceCount")
        self._IngressCount = params.get("IngressCount")
        self._MasterIps = params.get("MasterIps")
        self._RequestId = params.get("RequestId")


class DescribeClusterNodesRequest(AbstractModel):
    """DescribeClusterNodes请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群Id,不输入表示查询所有
        :type ClusterId: str
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 每次查询的最大记录数量
        :type Limit: int
        :param _Filters: Name 可取值：
DefendStatus（防护状态）:
	Defended 已防护
	UnDefended 未防护
AgentStatus (容器agent状态):
 	OFFLINE 离线
 	ONLINE 在线
 	UNINSTALL 未安装
InstanceState (节点状态):
  	Running 运行中
  	Ready 准备
  	Notready 未准备好
  	Initializing 初始化
  	Failed 失败
  	Error 错误
InstanceRole (节点角色)
    WORKER 工作节点
    MASTER_ETCD 主节点
    SUPER 超级节点
        :type Filters: list of ComplianceFilters
        :param _By: 排序字段
        :type By: str
        :param _Order: 排序方式 asc,desc
        :type Order: str
        """
        self._ClusterId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterNodesResponse(AbstractModel):
    """DescribeClusterNodes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数
        :type TotalCount: int
        :param _ClusterNodeList: 节点列表
        :type ClusterNodeList: list of ClusterNodeInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ClusterNodeList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ClusterNodeList(self):
        return self._ClusterNodeList

    @ClusterNodeList.setter
    def ClusterNodeList(self, ClusterNodeList):
        self._ClusterNodeList = ClusterNodeList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ClusterNodeList") is not None:
            self._ClusterNodeList = []
            for item in params.get("ClusterNodeList"):
                obj = ClusterNodeInfo()
                obj._deserialize(item)
                self._ClusterNodeList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClusterSummaryRequest(AbstractModel):
    """DescribeClusterSummary请求参数结构体

    """


class DescribeClusterSummaryResponse(AbstractModel):
    """DescribeClusterSummary返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 集群总数
        :type TotalCount: int
        :param _RiskClusterCount: 有风险的集群数量
        :type RiskClusterCount: int
        :param _UncheckClusterCount: 未检查的集群数量
        :type UncheckClusterCount: int
        :param _ManagedClusterCount: 托管集群数量
        :type ManagedClusterCount: int
        :param _IndependentClusterCount: 独立集群数量
        :type IndependentClusterCount: int
        :param _NoRiskClusterCount: 无风险的集群数量
        :type NoRiskClusterCount: int
        :param _CheckedClusterCount: 已经检查集群数
        :type CheckedClusterCount: int
        :param _AutoCheckClusterCount: 自动检查集群数
        :type AutoCheckClusterCount: int
        :param _ManualCheckClusterCount: 手动检查集群数
        :type ManualCheckClusterCount: int
        :param _FailedClusterCount: 检查失败集群数
        :type FailedClusterCount: int
        :param _NotImportedClusterCount: 未导入的集群数量
        :type NotImportedClusterCount: int
        :param _ServerlessClusterCount: eks集群数量
        :type ServerlessClusterCount: int
        :param _TkeClusterCount: TKE集群数量
注意：此字段可能返回 null，表示取不到有效值。
        :type TkeClusterCount: int
        :param _UserCreateTencentClusterCount: 用户自建腾讯云集群数量
注意：此字段可能返回 null，表示取不到有效值。
        :type UserCreateTencentClusterCount: int
        :param _UserCreateHybridClusterCount: 用户自建集群混合云数量
注意：此字段可能返回 null，表示取不到有效值。
        :type UserCreateHybridClusterCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._RiskClusterCount = None
        self._UncheckClusterCount = None
        self._ManagedClusterCount = None
        self._IndependentClusterCount = None
        self._NoRiskClusterCount = None
        self._CheckedClusterCount = None
        self._AutoCheckClusterCount = None
        self._ManualCheckClusterCount = None
        self._FailedClusterCount = None
        self._NotImportedClusterCount = None
        self._ServerlessClusterCount = None
        self._TkeClusterCount = None
        self._UserCreateTencentClusterCount = None
        self._UserCreateHybridClusterCount = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RiskClusterCount(self):
        return self._RiskClusterCount

    @RiskClusterCount.setter
    def RiskClusterCount(self, RiskClusterCount):
        self._RiskClusterCount = RiskClusterCount

    @property
    def UncheckClusterCount(self):
        return self._UncheckClusterCount

    @UncheckClusterCount.setter
    def UncheckClusterCount(self, UncheckClusterCount):
        self._UncheckClusterCount = UncheckClusterCount

    @property
    def ManagedClusterCount(self):
        return self._ManagedClusterCount

    @ManagedClusterCount.setter
    def ManagedClusterCount(self, ManagedClusterCount):
        self._ManagedClusterCount = ManagedClusterCount

    @property
    def IndependentClusterCount(self):
        return self._IndependentClusterCount

    @IndependentClusterCount.setter
    def IndependentClusterCount(self, IndependentClusterCount):
        self._IndependentClusterCount = IndependentClusterCount

    @property
    def NoRiskClusterCount(self):
        return self._NoRiskClusterCount

    @NoRiskClusterCount.setter
    def NoRiskClusterCount(self, NoRiskClusterCount):
        self._NoRiskClusterCount = NoRiskClusterCount

    @property
    def CheckedClusterCount(self):
        return self._CheckedClusterCount

    @CheckedClusterCount.setter
    def CheckedClusterCount(self, CheckedClusterCount):
        self._CheckedClusterCount = CheckedClusterCount

    @property
    def AutoCheckClusterCount(self):
        return self._AutoCheckClusterCount

    @AutoCheckClusterCount.setter
    def AutoCheckClusterCount(self, AutoCheckClusterCount):
        self._AutoCheckClusterCount = AutoCheckClusterCount

    @property
    def ManualCheckClusterCount(self):
        return self._ManualCheckClusterCount

    @ManualCheckClusterCount.setter
    def ManualCheckClusterCount(self, ManualCheckClusterCount):
        self._ManualCheckClusterCount = ManualCheckClusterCount

    @property
    def FailedClusterCount(self):
        return self._FailedClusterCount

    @FailedClusterCount.setter
    def FailedClusterCount(self, FailedClusterCount):
        self._FailedClusterCount = FailedClusterCount

    @property
    def NotImportedClusterCount(self):
        return self._NotImportedClusterCount

    @NotImportedClusterCount.setter
    def NotImportedClusterCount(self, NotImportedClusterCount):
        self._NotImportedClusterCount = NotImportedClusterCount

    @property
    def ServerlessClusterCount(self):
        return self._ServerlessClusterCount

    @ServerlessClusterCount.setter
    def ServerlessClusterCount(self, ServerlessClusterCount):
        self._ServerlessClusterCount = ServerlessClusterCount

    @property
    def TkeClusterCount(self):
        return self._TkeClusterCount

    @TkeClusterCount.setter
    def TkeClusterCount(self, TkeClusterCount):
        self._TkeClusterCount = TkeClusterCount

    @property
    def UserCreateTencentClusterCount(self):
        return self._UserCreateTencentClusterCount

    @UserCreateTencentClusterCount.setter
    def UserCreateTencentClusterCount(self, UserCreateTencentClusterCount):
        self._UserCreateTencentClusterCount = UserCreateTencentClusterCount

    @property
    def UserCreateHybridClusterCount(self):
        return self._UserCreateHybridClusterCount

    @UserCreateHybridClusterCount.setter
    def UserCreateHybridClusterCount(self, UserCreateHybridClusterCount):
        self._UserCreateHybridClusterCount = UserCreateHybridClusterCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._RiskClusterCount = params.get("RiskClusterCount")
        self._UncheckClusterCount = params.get("UncheckClusterCount")
        self._ManagedClusterCount = params.get("ManagedClusterCount")
        self._IndependentClusterCount = params.get("IndependentClusterCount")
        self._NoRiskClusterCount = params.get("NoRiskClusterCount")
        self._CheckedClusterCount = params.get("CheckedClusterCount")
        self._AutoCheckClusterCount = params.get("AutoCheckClusterCount")
        self._ManualCheckClusterCount = params.get("ManualCheckClusterCount")
        self._FailedClusterCount = params.get("FailedClusterCount")
        self._NotImportedClusterCount = params.get("NotImportedClusterCount")
        self._ServerlessClusterCount = params.get("ServerlessClusterCount")
        self._TkeClusterCount = params.get("TkeClusterCount")
        self._UserCreateTencentClusterCount = params.get("UserCreateTencentClusterCount")
        self._UserCreateHybridClusterCount = params.get("UserCreateHybridClusterCount")
        self._RequestId = params.get("RequestId")


class DescribeComplianceAssetDetailInfoRequest(AbstractModel):
    """DescribeComplianceAssetDetailInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CustomerAssetId: 客户资产ID。
        :type CustomerAssetId: int
        """
        self._CustomerAssetId = None

    @property
    def CustomerAssetId(self):
        return self._CustomerAssetId

    @CustomerAssetId.setter
    def CustomerAssetId(self, CustomerAssetId):
        self._CustomerAssetId = CustomerAssetId


    def _deserialize(self, params):
        self._CustomerAssetId = params.get("CustomerAssetId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeComplianceAssetDetailInfoResponse(AbstractModel):
    """DescribeComplianceAssetDetailInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AssetDetailInfo: 某资产的详情。
        :type AssetDetailInfo: :class:`tencentcloud.tcss.v20201101.models.ComplianceAssetDetailInfo`
        :param _ContainerDetailInfo: 当资产为容器时，返回此字段。
注意：此字段可能返回 null，表示取不到有效值。
        :type ContainerDetailInfo: :class:`tencentcloud.tcss.v20201101.models.ComplianceContainerDetailInfo`
        :param _ImageDetailInfo: 当资产为镜像时，返回此字段。
注意：此字段可能返回 null，表示取不到有效值。
        :type ImageDetailInfo: :class:`tencentcloud.tcss.v20201101.models.ComplianceImageDetailInfo`
        :param _HostDetailInfo: 当资产为主机时，返回此字段。
注意：此字段可能返回 null，表示取不到有效值。
        :type HostDetailInfo: :class:`tencentcloud.tcss.v20201101.models.ComplianceHostDetailInfo`
        :param _K8SDetailInfo: 当资产为K8S时，返回此字段。
注意：此字段可能返回 null，表示取不到有效值。
        :type K8SDetailInfo: :class:`tencentcloud.tcss.v20201101.models.ComplianceK8SDetailInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AssetDetailInfo = None
        self._ContainerDetailInfo = None
        self._ImageDetailInfo = None
        self._HostDetailInfo = None
        self._K8SDetailInfo = None
        self._RequestId = None

    @property
    def AssetDetailInfo(self):
        return self._AssetDetailInfo

    @AssetDetailInfo.setter
    def AssetDetailInfo(self, AssetDetailInfo):
        self._AssetDetailInfo = AssetDetailInfo

    @property
    def ContainerDetailInfo(self):
        return self._ContainerDetailInfo

    @ContainerDetailInfo.setter
    def ContainerDetailInfo(self, ContainerDetailInfo):
        self._ContainerDetailInfo = ContainerDetailInfo

    @property
    def ImageDetailInfo(self):
        return self._ImageDetailInfo

    @ImageDetailInfo.setter
    def ImageDetailInfo(self, ImageDetailInfo):
        self._ImageDetailInfo = ImageDetailInfo

    @property
    def HostDetailInfo(self):
        return self._HostDetailInfo

    @HostDetailInfo.setter
    def HostDetailInfo(self, HostDetailInfo):
        self._HostDetailInfo = HostDetailInfo

    @property
    def K8SDetailInfo(self):
        return self._K8SDetailInfo

    @K8SDetailInfo.setter
    def K8SDetailInfo(self, K8SDetailInfo):
        self._K8SDetailInfo = K8SDetailInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AssetDetailInfo") is not None:
            self._AssetDetailInfo = ComplianceAssetDetailInfo()
            self._AssetDetailInfo._deserialize(params.get("AssetDetailInfo"))
        if params.get("ContainerDetailInfo") is not None:
            self._ContainerDetailInfo = ComplianceContainerDetailInfo()
            self._ContainerDetailInfo._deserialize(params.get("ContainerDetailInfo"))
        if params.get("ImageDetailInfo") is not None:
            self._ImageDetailInfo = ComplianceImageDetailInfo()
            self._ImageDetailInfo._deserialize(params.get("ImageDetailInfo"))
        if params.get("HostDetailInfo") is not None:
            self._HostDetailInfo = ComplianceHostDetailInfo()
            self._HostDetailInfo._deserialize(params.get("HostDetailInfo"))
        if params.get("K8SDetailInfo") is not None:
            self._K8SDetailInfo = ComplianceK8SDetailInfo()
            self._K8SDetailInfo._deserialize(params.get("K8SDetailInfo"))
        self._RequestId = params.get("RequestId")


class DescribeComplianceAssetListRequest(AbstractModel):
    """DescribeComplianceAssetList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AssetTypeSet: 资产类型列表。
        :type AssetTypeSet: list of str
        :param _Offset: 起始偏移量，默认为0。
        :type Offset: int
        :param _Limit: 返回的数据量，默认为10，最大为100。
        :type Limit: int
        :param _Filters: 查询过滤器
        :type Filters: list of ComplianceFilters
        """
        self._AssetTypeSet = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def AssetTypeSet(self):
        return self._AssetTypeSet

    @AssetTypeSet.setter
    def AssetTypeSet(self, AssetTypeSet):
        self._AssetTypeSet = AssetTypeSet

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._AssetTypeSet = params.get("AssetTypeSet")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeComplianceAssetListResponse(AbstractModel):
    """DescribeComplianceAssetList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 返回资产的总数。
        :type TotalCount: int
        :param _AssetInfoList: 返回各类资产的列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type AssetInfoList: list of ComplianceAssetInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._AssetInfoList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AssetInfoList(self):
        return self._AssetInfoList

    @AssetInfoList.setter
    def AssetInfoList(self, AssetInfoList):
        self._AssetInfoList = AssetInfoList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AssetInfoList") is not None:
            self._AssetInfoList = []
            for item in params.get("AssetInfoList"):
                obj = ComplianceAssetInfo()
                obj._deserialize(item)
                self._AssetInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeComplianceAssetPolicyItemListRequest(AbstractModel):
    """DescribeComplianceAssetPolicyItemList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CustomerAssetId: 客户资产的ID。
        :type CustomerAssetId: int
        :param _Offset: 起始偏移量，默认为0。
        :type Offset: int
        :param _Limit: 要获取的数据量，默认为10，最大为100。
        :type Limit: int
        :param _Filters: 过滤器列表。Name字段支持
RiskLevel
        :type Filters: list of ComplianceFilters
        """
        self._CustomerAssetId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def CustomerAssetId(self):
        return self._CustomerAssetId

    @CustomerAssetId.setter
    def CustomerAssetId(self, CustomerAssetId):
        self._CustomerAssetId = CustomerAssetId

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._CustomerAssetId = params.get("CustomerAssetId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeComplianceAssetPolicyItemListResponse(AbstractModel):
    """DescribeComplianceAssetPolicyItemList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 返回检测项的总数。如果用户未启用基线检查，此处返回0。
        :type TotalCount: int
        :param _AssetPolicyItemList: 返回某个资产下的检测项的列表。
        :type AssetPolicyItemList: list of ComplianceAssetPolicyItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._AssetPolicyItemList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AssetPolicyItemList(self):
        return self._AssetPolicyItemList

    @AssetPolicyItemList.setter
    def AssetPolicyItemList(self, AssetPolicyItemList):
        self._AssetPolicyItemList = AssetPolicyItemList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AssetPolicyItemList") is not None:
            self._AssetPolicyItemList = []
            for item in params.get("AssetPolicyItemList"):
                obj = ComplianceAssetPolicyItem()
                obj._deserialize(item)
                self._AssetPolicyItemList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCompliancePeriodTaskListRequest(AbstractModel):
    """DescribeCompliancePeriodTaskList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AssetType: 资产的类型，取值为：
ASSET_CONTAINER, 容器
ASSET_IMAGE, 镜像
ASSET_HOST, 主机
ASSET_K8S, K8S资产
        :type AssetType: str
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 需要返回的数量，默认为10，最大值为100。
        :type Limit: int
        """
        self._AssetType = None
        self._Offset = None
        self._Limit = None

    @property
    def AssetType(self):
        return self._AssetType

    @AssetType.setter
    def AssetType(self, AssetType):
        self._AssetType = AssetType

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._AssetType = params.get("AssetType")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCompliancePeriodTaskListResponse(AbstractModel):
    """DescribeCompliancePeriodTaskList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 定时任务的总量。
        :type TotalCount: int
        :param _PeriodTaskSet: 定时任务信息的列表
        :type PeriodTaskSet: list of CompliancePeriodTask
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._PeriodTaskSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PeriodTaskSet(self):
        return self._PeriodTaskSet

    @PeriodTaskSet.setter
    def PeriodTaskSet(self, PeriodTaskSet):
        self._PeriodTaskSet = PeriodTaskSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("PeriodTaskSet") is not None:
            self._PeriodTaskSet = []
            for item in params.get("PeriodTaskSet"):
                obj = CompliancePeriodTask()
                obj._deserialize(item)
                self._PeriodTaskSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCompliancePolicyItemAffectedAssetListRequest(AbstractModel):
    """DescribeCompliancePolicyItemAffectedAssetList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CustomerPolicyItemId: DescribeComplianceTaskPolicyItemSummaryList返回的CustomerPolicyItemId，表示检测项的ID。
        :type CustomerPolicyItemId: int
        :param _Offset: 起始偏移量，默认为0。
        :type Offset: int
        :param _Limit: 需要返回的数量，默认为10，最大值为100。
        :type Limit: int
        :param _Filters: 过滤条件。
Name - String
Name 可取值：NodeName, CheckResult
        :type Filters: list of ComplianceFilters
        """
        self._CustomerPolicyItemId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def CustomerPolicyItemId(self):
        return self._CustomerPolicyItemId

    @CustomerPolicyItemId.setter
    def CustomerPolicyItemId(self, CustomerPolicyItemId):
        self._CustomerPolicyItemId = CustomerPolicyItemId

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._CustomerPolicyItemId = params.get("CustomerPolicyItemId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCompliancePolicyItemAffectedAssetListResponse(AbstractModel):
    """DescribeCompliancePolicyItemAffectedAssetList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AffectedAssetList: 返回各检测项所影响的资产的列表。
        :type AffectedAssetList: list of ComplianceAffectedAsset
        :param _TotalCount: 检测项影响的资产的总数。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AffectedAssetList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def AffectedAssetList(self):
        return self._AffectedAssetList

    @AffectedAssetList.setter
    def AffectedAssetList(self, AffectedAssetList):
        self._AffectedAssetList = AffectedAssetList

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AffectedAssetList") is not None:
            self._AffectedAssetList = []
            for item in params.get("AffectedAssetList"):
                obj = ComplianceAffectedAsset()
                obj._deserialize(item)
                self._AffectedAssetList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeCompliancePolicyItemAffectedSummaryRequest(AbstractModel):
    """DescribeCompliancePolicyItemAffectedSummary请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CustomerPolicyItemId: DescribeComplianceTaskPolicyItemSummaryList返回的CustomerPolicyItemId，表示检测项的ID。
        :type CustomerPolicyItemId: int
        """
        self._CustomerPolicyItemId = None

    @property
    def CustomerPolicyItemId(self):
        return self._CustomerPolicyItemId

    @CustomerPolicyItemId.setter
    def CustomerPolicyItemId(self, CustomerPolicyItemId):
        self._CustomerPolicyItemId = CustomerPolicyItemId


    def _deserialize(self, params):
        self._CustomerPolicyItemId = params.get("CustomerPolicyItemId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCompliancePolicyItemAffectedSummaryResponse(AbstractModel):
    """DescribeCompliancePolicyItemAffectedSummary返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PolicyItemSummary: 返回各检测项影响的资产的汇总信息。
        :type PolicyItemSummary: :class:`tencentcloud.tcss.v20201101.models.CompliancePolicyItemSummary`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PolicyItemSummary = None
        self._RequestId = None

    @property
    def PolicyItemSummary(self):
        return self._PolicyItemSummary

    @PolicyItemSummary.setter
    def PolicyItemSummary(self, PolicyItemSummary):
        self._PolicyItemSummary = PolicyItemSummary

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("PolicyItemSummary") is not None:
            self._PolicyItemSummary = CompliancePolicyItemSummary()
            self._PolicyItemSummary._deserialize(params.get("PolicyItemSummary"))
        self._RequestId = params.get("RequestId")


class DescribeComplianceScanFailedAssetListRequest(AbstractModel):
    """DescribeComplianceScanFailedAssetList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AssetTypeSet: 资产类型列表。
ASSET_CONTAINER, 容器
ASSET_IMAGE, 镜像
ASSET_HOST, 主机
ASSET_K8S, K8S资产
        :type AssetTypeSet: list of str
        :param _Offset: 起始偏移量，默认为0。
        :type Offset: int
        :param _Limit: 返回的数据量，默认为10，最大为100。
        :type Limit: int
        :param _Filters: 查询过滤器
        :type Filters: list of ComplianceFilters
        """
        self._AssetTypeSet = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def AssetTypeSet(self):
        return self._AssetTypeSet

    @AssetTypeSet.setter
    def AssetTypeSet(self, AssetTypeSet):
        self._AssetTypeSet = AssetTypeSet

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._AssetTypeSet = params.get("AssetTypeSet")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeComplianceScanFailedAssetListResponse(AbstractModel):
    """DescribeComplianceScanFailedAssetList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 返回检测失败的资产的总数。
        :type TotalCount: int
        :param _ScanFailedAssetList: 返回各类检测失败的资产的汇总信息的列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type ScanFailedAssetList: list of ComplianceScanFailedAsset
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ScanFailedAssetList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ScanFailedAssetList(self):
        return self._ScanFailedAssetList

    @ScanFailedAssetList.setter
    def ScanFailedAssetList(self, ScanFailedAssetList):
        self._ScanFailedAssetList = ScanFailedAssetList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ScanFailedAssetList") is not None:
            self._ScanFailedAssetList = []
            for item in params.get("ScanFailedAssetList"):
                obj = ComplianceScanFailedAsset()
                obj._deserialize(item)
                self._ScanFailedAssetList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeComplianceTaskAssetSummaryRequest(AbstractModel):
    """DescribeComplianceTaskAssetSummary请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AssetTypeSet: 资产类型列表。
ASSET_CONTAINER, 容器
ASSET_IMAGE, 镜像
ASSET_HOST, 主机
ASSET_K8S, K8S资产
        :type AssetTypeSet: list of str
        """
        self._AssetTypeSet = None

    @property
    def AssetTypeSet(self):
        return self._AssetTypeSet

    @AssetTypeSet.setter
    def AssetTypeSet(self, AssetTypeSet):
        self._AssetTypeSet = AssetTypeSet


    def _deserialize(self, params):
        self._AssetTypeSet = params.get("AssetTypeSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeComplianceTaskAssetSummaryResponse(AbstractModel):
    """DescribeComplianceTaskAssetSummary返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Status: 返回用户的状态，

USER_UNINIT: 用户未初始化。
USER_INITIALIZING，表示用户正在初始化环境。
USER_NORMAL: 正常状态。
        :type Status: str
        :param _AssetSummaryList: 返回各类资产的汇总信息的列表。
        :type AssetSummaryList: list of ComplianceAssetSummary
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Status = None
        self._AssetSummaryList = None
        self._RequestId = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def AssetSummaryList(self):
        return self._AssetSummaryList

    @AssetSummaryList.setter
    def AssetSummaryList(self, AssetSummaryList):
        self._AssetSummaryList = AssetSummaryList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        if params.get("AssetSummaryList") is not None:
            self._AssetSummaryList = []
            for item in params.get("AssetSummaryList"):
                obj = ComplianceAssetSummary()
                obj._deserialize(item)
                self._AssetSummaryList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeComplianceTaskPolicyItemSummaryListRequest(AbstractModel):
    """DescribeComplianceTaskPolicyItemSummaryList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AssetType: 资产类型。仅查询与指定资产类型相关的检测项。

ASSET_CONTAINER, 容器

ASSET_IMAGE, 镜像

ASSET_HOST, 主机

ASSET_K8S, K8S资产
        :type AssetType: str
        :param _Offset: 起始偏移量，默认为0。
        :type Offset: int
        :param _Limit: 需要返回的数量，默认为10，最大值为100。
        :type Limit: int
        :param _Filters: 过滤条件。
Name - String
Name 可取值：ItemType, StandardId,  RiskLevel。
当为K8S资产时，还可取ClusterName。
        :type Filters: list of ComplianceFilters
        """
        self._AssetType = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def AssetType(self):
        return self._AssetType

    @AssetType.setter
    def AssetType(self, AssetType):
        self._AssetType = AssetType

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._AssetType = params.get("AssetType")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeComplianceTaskPolicyItemSummaryListResponse(AbstractModel):
    """DescribeComplianceTaskPolicyItemSummaryList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 返回最近一次合规检查任务的ID。这个任务为本次所展示数据的来源。
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: int
        :param _TotalCount: 返回检测项的总数。
        :type TotalCount: int
        :param _PolicyItemSummaryList: 返回各检测项对应的汇总信息的列表。
        :type PolicyItemSummaryList: list of CompliancePolicyItemSummary
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._TotalCount = None
        self._PolicyItemSummaryList = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PolicyItemSummaryList(self):
        return self._PolicyItemSummaryList

    @PolicyItemSummaryList.setter
    def PolicyItemSummaryList(self, PolicyItemSummaryList):
        self._PolicyItemSummaryList = PolicyItemSummaryList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TotalCount = params.get("TotalCount")
        if params.get("PolicyItemSummaryList") is not None:
            self._PolicyItemSummaryList = []
            for item in params.get("PolicyItemSummaryList"):
                obj = CompliancePolicyItemSummary()
                obj._deserialize(item)
                self._PolicyItemSummaryList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeComplianceWhitelistItemListRequest(AbstractModel):
    """DescribeComplianceWhitelistItemList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Offset: 起始偏移量，默认为0。
        :type Offset: int
        :param _Limit: 要获取的数量，默认为10，最大为100。
        :type Limit: int
        :param _AssetTypeSet: 资产类型列表。
        :type AssetTypeSet: list of str
        :param _Filters: 查询过滤器
        :type Filters: list of ComplianceFilters
        :param _By: 排序字段
        :type By: str
        :param _Order: 排序方式 desc asc
        :type Order: str
        """
        self._Offset = None
        self._Limit = None
        self._AssetTypeSet = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def AssetTypeSet(self):
        return self._AssetTypeSet

    @AssetTypeSet.setter
    def AssetTypeSet(self, AssetTypeSet):
        self._AssetTypeSet = AssetTypeSet

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._AssetTypeSet = params.get("AssetTypeSet")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeComplianceWhitelistItemListResponse(AbstractModel):
    """DescribeComplianceWhitelistItemList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _WhitelistItemSet: 白名单项的列表。
        :type WhitelistItemSet: list of ComplianceWhitelistItem
        :param _TotalCount: 白名单项的总数。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._WhitelistItemSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def WhitelistItemSet(self):
        return self._WhitelistItemSet

    @WhitelistItemSet.setter
    def WhitelistItemSet(self, WhitelistItemSet):
        self._WhitelistItemSet = WhitelistItemSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("WhitelistItemSet") is not None:
            self._WhitelistItemSet = []
            for item in params.get("WhitelistItemSet"):
                obj = ComplianceWhitelistItem()
                obj._deserialize(item)
                self._WhitelistItemSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeContainerAssetSummaryRequest(AbstractModel):
    """DescribeContainerAssetSummary请求参数结构体

    """


class DescribeContainerAssetSummaryResponse(AbstractModel):
    """DescribeContainerAssetSummary返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ContainerTotalCnt: 容器总数
        :type ContainerTotalCnt: int
        :param _ContainerRunningCnt: 正在运行容器数量
        :type ContainerRunningCnt: int
        :param _ContainerPauseCnt: 暂停运行容器数量
        :type ContainerPauseCnt: int
        :param _ContainerStopped: 停止运行容器数量
        :type ContainerStopped: int
        :param _ImageCnt: 本地镜像数量
        :type ImageCnt: int
        :param _HostCnt: 主机节点数量
        :type HostCnt: int
        :param _HostRunningCnt: 主机正在运行节点数量
        :type HostRunningCnt: int
        :param _HostOfflineCnt: 主机离线节点数量
        :type HostOfflineCnt: int
        :param _ImageRegistryCnt: 镜像仓库数量
        :type ImageRegistryCnt: int
        :param _ImageTotalCnt: 镜像总数
        :type ImageTotalCnt: int
        :param _HostUnInstallCnt: 主机未安装agent数量
        :type HostUnInstallCnt: int
        :param _HostSuperNodeCnt: 超级节点个数
        :type HostSuperNodeCnt: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ContainerTotalCnt = None
        self._ContainerRunningCnt = None
        self._ContainerPauseCnt = None
        self._ContainerStopped = None
        self._ImageCnt = None
        self._HostCnt = None
        self._HostRunningCnt = None
        self._HostOfflineCnt = None
        self._ImageRegistryCnt = None
        self._ImageTotalCnt = None
        self._HostUnInstallCnt = None
        self._HostSuperNodeCnt = None
        self._RequestId = None

    @property
    def ContainerTotalCnt(self):
        return self._ContainerTotalCnt

    @ContainerTotalCnt.setter
    def ContainerTotalCnt(self, ContainerTotalCnt):
        self._ContainerTotalCnt = ContainerTotalCnt

    @property
    def ContainerRunningCnt(self):
        return self._ContainerRunningCnt

    @ContainerRunningCnt.setter
    def ContainerRunningCnt(self, ContainerRunningCnt):
        self._ContainerRunningCnt = ContainerRunningCnt

    @property
    def ContainerPauseCnt(self):
        return self._ContainerPauseCnt

    @ContainerPauseCnt.setter
    def ContainerPauseCnt(self, ContainerPauseCnt):
        self._ContainerPauseCnt = ContainerPauseCnt

    @property
    def ContainerStopped(self):
        return self._ContainerStopped

    @ContainerStopped.setter
    def ContainerStopped(self, ContainerStopped):
        self._ContainerStopped = ContainerStopped

    @property
    def ImageCnt(self):
        return self._ImageCnt

    @ImageCnt.setter
    def ImageCnt(self, ImageCnt):
        self._ImageCnt = ImageCnt

    @property
    def HostCnt(self):
        return self._HostCnt

    @HostCnt.setter
    def HostCnt(self, HostCnt):
        self._HostCnt = HostCnt

    @property
    def HostRunningCnt(self):
        return self._HostRunningCnt

    @HostRunningCnt.setter
    def HostRunningCnt(self, HostRunningCnt):
        self._HostRunningCnt = HostRunningCnt

    @property
    def HostOfflineCnt(self):
        return self._HostOfflineCnt

    @HostOfflineCnt.setter
    def HostOfflineCnt(self, HostOfflineCnt):
        self._HostOfflineCnt = HostOfflineCnt

    @property
    def ImageRegistryCnt(self):
        return self._ImageRegistryCnt

    @ImageRegistryCnt.setter
    def ImageRegistryCnt(self, ImageRegistryCnt):
        self._ImageRegistryCnt = ImageRegistryCnt

    @property
    def ImageTotalCnt(self):
        return self._ImageTotalCnt

    @ImageTotalCnt.setter
    def ImageTotalCnt(self, ImageTotalCnt):
        self._ImageTotalCnt = ImageTotalCnt

    @property
    def HostUnInstallCnt(self):
        return self._HostUnInstallCnt

    @HostUnInstallCnt.setter
    def HostUnInstallCnt(self, HostUnInstallCnt):
        self._HostUnInstallCnt = HostUnInstallCnt

    @property
    def HostSuperNodeCnt(self):
        return self._HostSuperNodeCnt

    @HostSuperNodeCnt.setter
    def HostSuperNodeCnt(self, HostSuperNodeCnt):
        self._HostSuperNodeCnt = HostSuperNodeCnt

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ContainerTotalCnt = params.get("ContainerTotalCnt")
        self._ContainerRunningCnt = params.get("ContainerRunningCnt")
        self._ContainerPauseCnt = params.get("ContainerPauseCnt")
        self._ContainerStopped = params.get("ContainerStopped")
        self._ImageCnt = params.get("ImageCnt")
        self._HostCnt = params.get("HostCnt")
        self._HostRunningCnt = params.get("HostRunningCnt")
        self._HostOfflineCnt = params.get("HostOfflineCnt")
        self._ImageRegistryCnt = params.get("ImageRegistryCnt")
        self._ImageTotalCnt = params.get("ImageTotalCnt")
        self._HostUnInstallCnt = params.get("HostUnInstallCnt")
        self._HostSuperNodeCnt = params.get("HostSuperNodeCnt")
        self._RequestId = params.get("RequestId")


class DescribeContainerSecEventSummaryRequest(AbstractModel):
    """DescribeContainerSecEventSummary请求参数结构体

    """


class DescribeContainerSecEventSummaryResponse(AbstractModel):
    """DescribeContainerSecEventSummary返回参数结构体

    """

    def __init__(self):
        r"""
        :param _UnhandledEscapeCnt: 未处理逃逸事件
        :type UnhandledEscapeCnt: int
        :param _UnhandledReverseShellCnt: 未处理反弹shell事件
        :type UnhandledReverseShellCnt: int
        :param _UnhandledRiskSyscallCnt: 未处理高危系统调用
        :type UnhandledRiskSyscallCnt: int
        :param _UnhandledAbnormalProcessCnt: 未处理异常进程
        :type UnhandledAbnormalProcessCnt: int
        :param _UnhandledFileCnt: 未处理文件篡改
        :type UnhandledFileCnt: int
        :param _UnhandledVirusEventCnt: 未处理木马事件
        :type UnhandledVirusEventCnt: int
        :param _UnhandledMaliciousConnectionEventCnt: 未处理恶意外连事件
        :type UnhandledMaliciousConnectionEventCnt: int
        :param _UnhandledK8sApiEventCnt: 未处理k8sApi事件
注意：此字段可能返回 null，表示取不到有效值。
        :type UnhandledK8sApiEventCnt: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._UnhandledEscapeCnt = None
        self._UnhandledReverseShellCnt = None
        self._UnhandledRiskSyscallCnt = None
        self._UnhandledAbnormalProcessCnt = None
        self._UnhandledFileCnt = None
        self._UnhandledVirusEventCnt = None
        self._UnhandledMaliciousConnectionEventCnt = None
        self._UnhandledK8sApiEventCnt = None
        self._RequestId = None

    @property
    def UnhandledEscapeCnt(self):
        return self._UnhandledEscapeCnt

    @UnhandledEscapeCnt.setter
    def UnhandledEscapeCnt(self, UnhandledEscapeCnt):
        self._UnhandledEscapeCnt = UnhandledEscapeCnt

    @property
    def UnhandledReverseShellCnt(self):
        return self._UnhandledReverseShellCnt

    @UnhandledReverseShellCnt.setter
    def UnhandledReverseShellCnt(self, UnhandledReverseShellCnt):
        self._UnhandledReverseShellCnt = UnhandledReverseShellCnt

    @property
    def UnhandledRiskSyscallCnt(self):
        return self._UnhandledRiskSyscallCnt

    @UnhandledRiskSyscallCnt.setter
    def UnhandledRiskSyscallCnt(self, UnhandledRiskSyscallCnt):
        self._UnhandledRiskSyscallCnt = UnhandledRiskSyscallCnt

    @property
    def UnhandledAbnormalProcessCnt(self):
        return self._UnhandledAbnormalProcessCnt

    @UnhandledAbnormalProcessCnt.setter
    def UnhandledAbnormalProcessCnt(self, UnhandledAbnormalProcessCnt):
        self._UnhandledAbnormalProcessCnt = UnhandledAbnormalProcessCnt

    @property
    def UnhandledFileCnt(self):
        return self._UnhandledFileCnt

    @UnhandledFileCnt.setter
    def UnhandledFileCnt(self, UnhandledFileCnt):
        self._UnhandledFileCnt = UnhandledFileCnt

    @property
    def UnhandledVirusEventCnt(self):
        return self._UnhandledVirusEventCnt

    @UnhandledVirusEventCnt.setter
    def UnhandledVirusEventCnt(self, UnhandledVirusEventCnt):
        self._UnhandledVirusEventCnt = UnhandledVirusEventCnt

    @property
    def UnhandledMaliciousConnectionEventCnt(self):
        return self._UnhandledMaliciousConnectionEventCnt

    @UnhandledMaliciousConnectionEventCnt.setter
    def UnhandledMaliciousConnectionEventCnt(self, UnhandledMaliciousConnectionEventCnt):
        self._UnhandledMaliciousConnectionEventCnt = UnhandledMaliciousConnectionEventCnt

    @property
    def UnhandledK8sApiEventCnt(self):
        return self._UnhandledK8sApiEventCnt

    @UnhandledK8sApiEventCnt.setter
    def UnhandledK8sApiEventCnt(self, UnhandledK8sApiEventCnt):
        self._UnhandledK8sApiEventCnt = UnhandledK8sApiEventCnt

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._UnhandledEscapeCnt = params.get("UnhandledEscapeCnt")
        self._UnhandledReverseShellCnt = params.get("UnhandledReverseShellCnt")
        self._UnhandledRiskSyscallCnt = params.get("UnhandledRiskSyscallCnt")
        self._UnhandledAbnormalProcessCnt = params.get("UnhandledAbnormalProcessCnt")
        self._UnhandledFileCnt = params.get("UnhandledFileCnt")
        self._UnhandledVirusEventCnt = params.get("UnhandledVirusEventCnt")
        self._UnhandledMaliciousConnectionEventCnt = params.get("UnhandledMaliciousConnectionEventCnt")
        self._UnhandledK8sApiEventCnt = params.get("UnhandledK8sApiEventCnt")
        self._RequestId = params.get("RequestId")


class DescribeESAggregationsRequest(AbstractModel):
    """DescribeESAggregations请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Query: ES聚合条件JSON
        :type Query: str
        """
        self._Query = None

    @property
    def Query(self):
        return self._Query

    @Query.setter
    def Query(self, Query):
        self._Query = Query


    def _deserialize(self, params):
        self._Query = params.get("Query")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeESAggregationsResponse(AbstractModel):
    """DescribeESAggregations返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: ES聚合结果JSON
        :type Data: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeESHitsRequest(AbstractModel):
    """DescribeESHits请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Query: ES查询条件JSON
        :type Query: str
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 返回数量，最大值为100。
        :type Limit: int
        """
        self._Query = None
        self._Offset = None
        self._Limit = None

    @property
    def Query(self):
        return self._Query

    @Query.setter
    def Query(self, Query):
        self._Query = Query

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Query = params.get("Query")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeESHitsResponse(AbstractModel):
    """DescribeESHits返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: ES查询结果JSON
        :type Data: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeEmergencyVulListRequest(AbstractModel):
    """DescribeEmergencyVulList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Level- String - 是否必填：否 - 威胁等级，CRITICAL:严重 HIGH:高/MIDDLE:中/LOW:低</li>
<li>Tags- string - 是否必填：否 - 漏洞标签，POC，EXP。</li>
<li>CanBeFixed- string - 是否必填：否 - 是否可修复true,false。</li>
<li>CVEID- string - 是否必填：否 - CVE编号</li>
<li>ImageID- string - 是否必填：否 - 镜像ID</li>
<li>ImageName- String -是否必填: 否 - 镜像名称</li>
<li>ContainerID- string -是否必填: 否 - 容器ID</li>
<li>ContainerName- string -是否必填: 否 - 容器名称</li>
<li>ComponentName- string -是否必填: 否 - 组件名称</li>
<li>ComponentVersion- string -是否必填: 否 - 组件版本</li>
<li>Name- string -是否必填: 否 - 漏洞名称</li>
        :type Filters: list of RunTimeFilters
        :param _Order: 排序方式
        :type Order: str
        :param _By: 排序字段
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEmergencyVulListResponse(AbstractModel):
    """DescribeEmergencyVulList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 漏洞总数
        :type TotalCount: int
        :param _List: 漏洞列表
        :type List: list of EmergencyVulInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = EmergencyVulInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeEscapeEventDetailRequest(AbstractModel):
    """DescribeEscapeEventDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventId: 事件唯一id
        :type EventId: str
        :param _EventType: 事件类型
        :type EventType: str
        """
        self._EventId = None
        self._EventType = None

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def EventType(self):
        return self._EventType

    @EventType.setter
    def EventType(self, EventType):
        self._EventType = EventType


    def _deserialize(self, params):
        self._EventId = params.get("EventId")
        self._EventType = params.get("EventType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEscapeEventDetailResponse(AbstractModel):
    """DescribeEscapeEventDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _EventBaseInfo: 事件基本信息
        :type EventBaseInfo: :class:`tencentcloud.tcss.v20201101.models.RunTimeEventBaseInfo`
        :param _ProcessInfo: 进程信息
        :type ProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessDetailInfo`
        :param _EventDetail: 事件描述
        :type EventDetail: :class:`tencentcloud.tcss.v20201101.models.EscapeEventDescription`
        :param _ParentProcessInfo: 父进程信息
        :type ParentProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessBaseInfo`
        :param _AncestorProcessInfo: 祖先进程信息
注意：此字段可能返回 null，表示取不到有效值。
        :type AncestorProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessBaseInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._EventBaseInfo = None
        self._ProcessInfo = None
        self._EventDetail = None
        self._ParentProcessInfo = None
        self._AncestorProcessInfo = None
        self._RequestId = None

    @property
    def EventBaseInfo(self):
        return self._EventBaseInfo

    @EventBaseInfo.setter
    def EventBaseInfo(self, EventBaseInfo):
        self._EventBaseInfo = EventBaseInfo

    @property
    def ProcessInfo(self):
        return self._ProcessInfo

    @ProcessInfo.setter
    def ProcessInfo(self, ProcessInfo):
        self._ProcessInfo = ProcessInfo

    @property
    def EventDetail(self):
        return self._EventDetail

    @EventDetail.setter
    def EventDetail(self, EventDetail):
        self._EventDetail = EventDetail

    @property
    def ParentProcessInfo(self):
        return self._ParentProcessInfo

    @ParentProcessInfo.setter
    def ParentProcessInfo(self, ParentProcessInfo):
        self._ParentProcessInfo = ParentProcessInfo

    @property
    def AncestorProcessInfo(self):
        return self._AncestorProcessInfo

    @AncestorProcessInfo.setter
    def AncestorProcessInfo(self, AncestorProcessInfo):
        self._AncestorProcessInfo = AncestorProcessInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EventBaseInfo") is not None:
            self._EventBaseInfo = RunTimeEventBaseInfo()
            self._EventBaseInfo._deserialize(params.get("EventBaseInfo"))
        if params.get("ProcessInfo") is not None:
            self._ProcessInfo = ProcessDetailInfo()
            self._ProcessInfo._deserialize(params.get("ProcessInfo"))
        if params.get("EventDetail") is not None:
            self._EventDetail = EscapeEventDescription()
            self._EventDetail._deserialize(params.get("EventDetail"))
        if params.get("ParentProcessInfo") is not None:
            self._ParentProcessInfo = ProcessBaseInfo()
            self._ParentProcessInfo._deserialize(params.get("ParentProcessInfo"))
        if params.get("AncestorProcessInfo") is not None:
            self._AncestorProcessInfo = ProcessBaseInfo()
            self._AncestorProcessInfo._deserialize(params.get("AncestorProcessInfo"))
        self._RequestId = params.get("RequestId")


class DescribeEscapeEventInfoRequest(AbstractModel):
    """DescribeEscapeEventInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤参数,
Status：状态(EVENT_UNDEAL:未处理，EVENT_DEALED:已处理，EVENT_INGNORE:忽略)
EventType: 事件类型(MOUNT_SENSITIVE_PTAH:敏感路径挂载 PRIVILEGE_CONTAINER_START:特权容器 PRIVILEGE:提权事件 
    ESCAPE_VUL_OCCURRED:逃逸漏洞利用 ESCAPE_DOCKER_API:访问Docker API接口逃逸 ESCAPE_TAMPER_SENSITIVE_FILE:篡改敏感文件逃逸 ESCAPE_CGROUPS:利用cgroup机制逃逸)
ContainerNetStatus: 容器隔离状态 (NORMAL:正常 ISOLATED:已隔离 ISOLATE_FAILED:隔离失败 ISOLATE_FAILED:解除隔离失败 RESTORING:解除隔离中 ISOLATING:隔离中)
ContainerStatus: 容器状态(CREATED:已创建 RUNNING:正常运行 PAUSED:暂停运行 STOPPED:停止运行 RESTARTING:重启中 REMOVING:迁移中 DEAD:DEAD UNKNOWN：未知 DESTROYED:已销毁)
ForeignUniqueKey:镜像ID及事件类型唯一值
        :type Filters: list of RunTimeFilters
        :param _Order: 升序降序,asc desc
        :type Order: str
        :param _By: 排序字段
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEscapeEventInfoResponse(AbstractModel):
    """DescribeEscapeEventInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _EventSet: 逃逸事件数组
        :type EventSet: list of EscapeEventInfo
        :param _TotalCount: 事件总数量
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._EventSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def EventSet(self):
        return self._EventSet

    @EventSet.setter
    def EventSet(self, EventSet):
        self._EventSet = EventSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EventSet") is not None:
            self._EventSet = []
            for item in params.get("EventSet"):
                obj = EscapeEventInfo()
                obj._deserialize(item)
                self._EventSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeEscapeEventTendencyRequest(AbstractModel):
    """DescribeEscapeEventTendency请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _StartTime: 开始时间
        :type StartTime: str
        """
        self._EndTime = None
        self._StartTime = None

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime


    def _deserialize(self, params):
        self._EndTime = params.get("EndTime")
        self._StartTime = params.get("StartTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEscapeEventTendencyResponse(AbstractModel):
    """DescribeEscapeEventTendency返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 待处理逃逸事件趋势
        :type List: list of EscapeEventTendencyInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = EscapeEventTendencyInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeEscapeEventTypeSummaryRequest(AbstractModel):
    """DescribeEscapeEventTypeSummary请求参数结构体

    """


class DescribeEscapeEventTypeSummaryResponse(AbstractModel):
    """DescribeEscapeEventTypeSummary返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ContainerEscapeEventCount: 容器逃逸事件数
        :type ContainerEscapeEventCount: int
        :param _ProcessPrivilegeEventCount: 程序提权事件数
        :type ProcessPrivilegeEventCount: int
        :param _RiskContainerEventCount: 风险容器事件数
        :type RiskContainerEventCount: int
        :param _PendingEscapeEventCount: 逃逸事件待处理数
        :type PendingEscapeEventCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ContainerEscapeEventCount = None
        self._ProcessPrivilegeEventCount = None
        self._RiskContainerEventCount = None
        self._PendingEscapeEventCount = None
        self._RequestId = None

    @property
    def ContainerEscapeEventCount(self):
        return self._ContainerEscapeEventCount

    @ContainerEscapeEventCount.setter
    def ContainerEscapeEventCount(self, ContainerEscapeEventCount):
        self._ContainerEscapeEventCount = ContainerEscapeEventCount

    @property
    def ProcessPrivilegeEventCount(self):
        return self._ProcessPrivilegeEventCount

    @ProcessPrivilegeEventCount.setter
    def ProcessPrivilegeEventCount(self, ProcessPrivilegeEventCount):
        self._ProcessPrivilegeEventCount = ProcessPrivilegeEventCount

    @property
    def RiskContainerEventCount(self):
        return self._RiskContainerEventCount

    @RiskContainerEventCount.setter
    def RiskContainerEventCount(self, RiskContainerEventCount):
        self._RiskContainerEventCount = RiskContainerEventCount

    @property
    def PendingEscapeEventCount(self):
        return self._PendingEscapeEventCount

    @PendingEscapeEventCount.setter
    def PendingEscapeEventCount(self, PendingEscapeEventCount):
        self._PendingEscapeEventCount = PendingEscapeEventCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ContainerEscapeEventCount = params.get("ContainerEscapeEventCount")
        self._ProcessPrivilegeEventCount = params.get("ProcessPrivilegeEventCount")
        self._RiskContainerEventCount = params.get("RiskContainerEventCount")
        self._PendingEscapeEventCount = params.get("PendingEscapeEventCount")
        self._RequestId = params.get("RequestId")


class DescribeEscapeEventsExportRequest(AbstractModel):
    """DescribeEscapeEventsExport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ExportField: 导出字段
        :type ExportField: list of str
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤参数,"Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param _Order: 升序降序,asc desc
        :type Order: str
        :param _By: 排序字段
        :type By: str
        """
        self._ExportField = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._ExportField = params.get("ExportField")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEscapeEventsExportResponse(AbstractModel):
    """DescribeEscapeEventsExport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: execle下载地址
注意：此字段可能返回 null，表示取不到有效值。
        :type DownloadUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._RequestId = params.get("RequestId")


class DescribeEscapeRuleInfoRequest(AbstractModel):
    """DescribeEscapeRuleInfo请求参数结构体

    """


class DescribeEscapeRuleInfoResponse(AbstractModel):
    """DescribeEscapeRuleInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleSet: 规则信息
        :type RuleSet: list of EscapeRule
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RuleSet = None
        self._RequestId = None

    @property
    def RuleSet(self):
        return self._RuleSet

    @RuleSet.setter
    def RuleSet(self, RuleSet):
        self._RuleSet = RuleSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RuleSet") is not None:
            self._RuleSet = []
            for item in params.get("RuleSet"):
                obj = EscapeRule()
                obj._deserialize(item)
                self._RuleSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeEscapeSafeStateRequest(AbstractModel):
    """DescribeEscapeSafeState请求参数结构体

    """


class DescribeEscapeSafeStateResponse(AbstractModel):
    """DescribeEscapeSafeState返回参数结构体

    """

    def __init__(self):
        r"""
        :param _IsSafe: Unsafe：存在风险，Safe：暂无风险,UnKnown:未知风险
        :type IsSafe: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._IsSafe = None
        self._RequestId = None

    @property
    def IsSafe(self):
        return self._IsSafe

    @IsSafe.setter
    def IsSafe(self, IsSafe):
        self._IsSafe = IsSafe

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._IsSafe = params.get("IsSafe")
        self._RequestId = params.get("RequestId")


class DescribeEscapeWhiteListRequest(AbstractModel):
    """DescribeEscapeWhiteList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li>EventType- String - 是否必填：否 - 加白事件类型，ESCAPE_CGROUPS：利用cgroup机制逃逸，ESCAPE_TAMPER_SENSITIVE_FILE：篡改敏感文件逃逸， ESCAPE_DOCKER_API：访问Docker API接口逃逸，ESCAPE_VUL_OCCURRED：逃逸漏洞利用，MOUNT_SENSITIVE_PTAH：敏感路径挂载，PRIVILEGE_CONTAINER_START：特权容器， PRIVILEGE：程序提权逃逸</li>
<li>ImageName- string - 是否必填：否 - 镜像名称。</li>
<li>ImageID- string - 是否必填：否 - 镜像ID。</li>
        :type Filters: list of RunTimeFilters
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Order: 排序方式：asc/desc
        :type Order: str
        :param _By: 排序字段：主机数量：HostCount，容器数量：ContainerCount，更新时间：UpdateTime
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEscapeWhiteListResponse(AbstractModel):
    """DescribeEscapeWhiteList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数量
        :type TotalCount: int
        :param _List: 逃逸白名单列表
        :type List: list of EscapeWhiteListInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = EscapeWhiteListInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeExportJobDownloadURLRequest(AbstractModel):
    """DescribeExportJobDownloadURL请求参数结构体

    """

    def __init__(self):
        r"""
        :param _JobID: 任务ID
        :type JobID: str
        """
        self._JobID = None

    @property
    def JobID(self):
        return self._JobID

    @JobID.setter
    def JobID(self, JobID):
        self._JobID = JobID


    def _deserialize(self, params):
        self._JobID = params.get("JobID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeExportJobDownloadURLResponse(AbstractModel):
    """DescribeExportJobDownloadURL返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadURL: 下载链接
        :type DownloadURL: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadURL = None
        self._RequestId = None

    @property
    def DownloadURL(self):
        return self._DownloadURL

    @DownloadURL.setter
    def DownloadURL(self, DownloadURL):
        self._DownloadURL = DownloadURL

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadURL = params.get("DownloadURL")
        self._RequestId = params.get("RequestId")


class DescribeExportJobManageListRequest(AbstractModel):
    """DescribeExportJobManageList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li>ExportStatus- string -是否必填: 否 - 导出状态 RUNNING: 导出中 SUCCESS:导出完成 FAILURE:失败
</li>
<li>ExportSource- string -是否必填: 否 - 导出来源 LocalImage: 本地镜像 RegistryImage: 仓库镜像
</li>
        :type Filters: list of RunTimeFilters
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Order: 排序方式
        :type Order: str
        :param _By: 排序字段
InsertTime: 创建时间
        :type By: str
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeExportJobManageListResponse(AbstractModel):
    """DescribeExportJobManageList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数
        :type TotalCount: int
        :param _List: 任务列表
        :type List: list of ExportJobInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ExportJobInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeExportJobResultRequest(AbstractModel):
    """DescribeExportJobResult请求参数结构体

    """

    def __init__(self):
        r"""
        :param _JobId: CreateExportComplianceStatusListJob返回的JobId字段的值
        :type JobId: str
        """
        self._JobId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeExportJobResultResponse(AbstractModel):
    """DescribeExportJobResult返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ExportStatus: 导出的状态。取值为, SUCCESS:成功、FAILURE:失败，RUNNING: 进行中。
        :type ExportStatus: str
        :param _DownloadURL: 返回下载URL
注意：此字段可能返回 null，表示取不到有效值。
        :type DownloadURL: str
        :param _ExportProgress: 当ExportStatus为RUNNING时，返回导出进度。0~100范围的浮点数。
注意：此字段可能返回 null，表示取不到有效值。
        :type ExportProgress: float
        :param _FailureMsg: 失败原因
注意：此字段可能返回 null，表示取不到有效值。
        :type FailureMsg: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ExportStatus = None
        self._DownloadURL = None
        self._ExportProgress = None
        self._FailureMsg = None
        self._RequestId = None

    @property
    def ExportStatus(self):
        return self._ExportStatus

    @ExportStatus.setter
    def ExportStatus(self, ExportStatus):
        self._ExportStatus = ExportStatus

    @property
    def DownloadURL(self):
        return self._DownloadURL

    @DownloadURL.setter
    def DownloadURL(self, DownloadURL):
        self._DownloadURL = DownloadURL

    @property
    def ExportProgress(self):
        return self._ExportProgress

    @ExportProgress.setter
    def ExportProgress(self, ExportProgress):
        self._ExportProgress = ExportProgress

    @property
    def FailureMsg(self):
        return self._FailureMsg

    @FailureMsg.setter
    def FailureMsg(self, FailureMsg):
        self._FailureMsg = FailureMsg

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ExportStatus = params.get("ExportStatus")
        self._DownloadURL = params.get("DownloadURL")
        self._ExportProgress = params.get("ExportProgress")
        self._FailureMsg = params.get("FailureMsg")
        self._RequestId = params.get("RequestId")


class DescribeImageAuthorizedInfoRequest(AbstractModel):
    """DescribeImageAuthorizedInfo请求参数结构体

    """


class DescribeImageAuthorizedInfoResponse(AbstractModel):
    """DescribeImageAuthorizedInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalAuthorizedCnt: 总共有效的镜像授权数
        :type TotalAuthorizedCnt: int
        :param _UsedAuthorizedCnt: 已使用镜像授权数
        :type UsedAuthorizedCnt: int
        :param _ScannedImageCnt: 已开启扫描镜像数
        :type ScannedImageCnt: int
        :param _NotScannedImageCnt: 未开启扫描镜像数
        :type NotScannedImageCnt: int
        :param _NotScannedLocalImageCnt: 本地未开启扫描镜像数
        :type NotScannedLocalImageCnt: int
        :param _TrialAuthorizedCnt: 试用镜像授权数
        :type TrialAuthorizedCnt: int
        :param _UsedTrialAuthorizedCnt: 已使用试用镜像授权数
        :type UsedTrialAuthorizedCnt: int
        :param _PurchasedAuthorizedCnt: 已购镜像授权数
        :type PurchasedAuthorizedCnt: int
        :param _UsedPurchasedAuthorizedCnt: 已使用已购镜像授权数
        :type UsedPurchasedAuthorizedCnt: int
        :param _CanApplyFreeImageAuthorize: 是否可免费领取镜像授权数
        :type CanApplyFreeImageAuthorize: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalAuthorizedCnt = None
        self._UsedAuthorizedCnt = None
        self._ScannedImageCnt = None
        self._NotScannedImageCnt = None
        self._NotScannedLocalImageCnt = None
        self._TrialAuthorizedCnt = None
        self._UsedTrialAuthorizedCnt = None
        self._PurchasedAuthorizedCnt = None
        self._UsedPurchasedAuthorizedCnt = None
        self._CanApplyFreeImageAuthorize = None
        self._RequestId = None

    @property
    def TotalAuthorizedCnt(self):
        return self._TotalAuthorizedCnt

    @TotalAuthorizedCnt.setter
    def TotalAuthorizedCnt(self, TotalAuthorizedCnt):
        self._TotalAuthorizedCnt = TotalAuthorizedCnt

    @property
    def UsedAuthorizedCnt(self):
        return self._UsedAuthorizedCnt

    @UsedAuthorizedCnt.setter
    def UsedAuthorizedCnt(self, UsedAuthorizedCnt):
        self._UsedAuthorizedCnt = UsedAuthorizedCnt

    @property
    def ScannedImageCnt(self):
        return self._ScannedImageCnt

    @ScannedImageCnt.setter
    def ScannedImageCnt(self, ScannedImageCnt):
        self._ScannedImageCnt = ScannedImageCnt

    @property
    def NotScannedImageCnt(self):
        return self._NotScannedImageCnt

    @NotScannedImageCnt.setter
    def NotScannedImageCnt(self, NotScannedImageCnt):
        self._NotScannedImageCnt = NotScannedImageCnt

    @property
    def NotScannedLocalImageCnt(self):
        return self._NotScannedLocalImageCnt

    @NotScannedLocalImageCnt.setter
    def NotScannedLocalImageCnt(self, NotScannedLocalImageCnt):
        self._NotScannedLocalImageCnt = NotScannedLocalImageCnt

    @property
    def TrialAuthorizedCnt(self):
        return self._TrialAuthorizedCnt

    @TrialAuthorizedCnt.setter
    def TrialAuthorizedCnt(self, TrialAuthorizedCnt):
        self._TrialAuthorizedCnt = TrialAuthorizedCnt

    @property
    def UsedTrialAuthorizedCnt(self):
        return self._UsedTrialAuthorizedCnt

    @UsedTrialAuthorizedCnt.setter
    def UsedTrialAuthorizedCnt(self, UsedTrialAuthorizedCnt):
        self._UsedTrialAuthorizedCnt = UsedTrialAuthorizedCnt

    @property
    def PurchasedAuthorizedCnt(self):
        return self._PurchasedAuthorizedCnt

    @PurchasedAuthorizedCnt.setter
    def PurchasedAuthorizedCnt(self, PurchasedAuthorizedCnt):
        self._PurchasedAuthorizedCnt = PurchasedAuthorizedCnt

    @property
    def UsedPurchasedAuthorizedCnt(self):
        return self._UsedPurchasedAuthorizedCnt

    @UsedPurchasedAuthorizedCnt.setter
    def UsedPurchasedAuthorizedCnt(self, UsedPurchasedAuthorizedCnt):
        self._UsedPurchasedAuthorizedCnt = UsedPurchasedAuthorizedCnt

    @property
    def CanApplyFreeImageAuthorize(self):
        return self._CanApplyFreeImageAuthorize

    @CanApplyFreeImageAuthorize.setter
    def CanApplyFreeImageAuthorize(self, CanApplyFreeImageAuthorize):
        self._CanApplyFreeImageAuthorize = CanApplyFreeImageAuthorize

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalAuthorizedCnt = params.get("TotalAuthorizedCnt")
        self._UsedAuthorizedCnt = params.get("UsedAuthorizedCnt")
        self._ScannedImageCnt = params.get("ScannedImageCnt")
        self._NotScannedImageCnt = params.get("NotScannedImageCnt")
        self._NotScannedLocalImageCnt = params.get("NotScannedLocalImageCnt")
        self._TrialAuthorizedCnt = params.get("TrialAuthorizedCnt")
        self._UsedTrialAuthorizedCnt = params.get("UsedTrialAuthorizedCnt")
        self._PurchasedAuthorizedCnt = params.get("PurchasedAuthorizedCnt")
        self._UsedPurchasedAuthorizedCnt = params.get("UsedPurchasedAuthorizedCnt")
        self._CanApplyFreeImageAuthorize = params.get("CanApplyFreeImageAuthorize")
        self._RequestId = params.get("RequestId")


class DescribeImageAutoAuthorizedLogListRequest(AbstractModel):
    """DescribeImageAutoAuthorizedLogList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 自动授权任务Id
        :type TaskId: int
        :param _Filters: Status授权结果，SUCCESS:成功，REACH_LIMIT:达到授权上限，LICENSE_INSUFFICIENT:授权数不足
        :type Filters: list of AssetFilters
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0
        :type Offset: int
        :param _By: 排序字段：AuthorizedTime
        :type By: str
        :param _Order: 排序方式，asc，desc
        :type Order: str
        """
        self._TaskId = None
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._By = None
        self._Order = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageAutoAuthorizedLogListResponse(AbstractModel):
    """DescribeImageAutoAuthorizedLogList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数量
        :type TotalCount: int
        :param _List: 自动授权结果镜像列表
        :type List: list of AutoAuthorizedImageInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = AutoAuthorizedImageInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeImageAutoAuthorizedRuleRequest(AbstractModel):
    """DescribeImageAutoAuthorizedRule请求参数结构体

    """


class DescribeImageAutoAuthorizedRuleResponse(AbstractModel):
    """DescribeImageAutoAuthorizedRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _IsEnabled: 规则是否生效，0:不生效，1:已生效
        :type IsEnabled: int
        :param _RangeType: 授权范围类别，MANUAL:自选主机节点，ALL:全部镜像
注意：此字段可能返回 null，表示取不到有效值。
        :type RangeType: str
        :param _HostCount: 授权范围是自选主机时的主机数量
注意：此字段可能返回 null，表示取不到有效值。
        :type HostCount: int
        :param _MaxDailyCount: 每天最大的镜像授权数限制, 0表示无限制
注意：此字段可能返回 null，表示取不到有效值。
        :type MaxDailyCount: int
        :param _RuleId: 规则id，用未设置时为0
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleId: int
        :param _AutoScanEnabled: 自动扫描开关，0：关闭，1：开启
        :type AutoScanEnabled: int
        :param _ScanType: 自动扫描范围
        :type ScanType: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._IsEnabled = None
        self._RangeType = None
        self._HostCount = None
        self._MaxDailyCount = None
        self._RuleId = None
        self._AutoScanEnabled = None
        self._ScanType = None
        self._RequestId = None

    @property
    def IsEnabled(self):
        return self._IsEnabled

    @IsEnabled.setter
    def IsEnabled(self, IsEnabled):
        self._IsEnabled = IsEnabled

    @property
    def RangeType(self):
        return self._RangeType

    @RangeType.setter
    def RangeType(self, RangeType):
        self._RangeType = RangeType

    @property
    def HostCount(self):
        return self._HostCount

    @HostCount.setter
    def HostCount(self, HostCount):
        self._HostCount = HostCount

    @property
    def MaxDailyCount(self):
        return self._MaxDailyCount

    @MaxDailyCount.setter
    def MaxDailyCount(self, MaxDailyCount):
        self._MaxDailyCount = MaxDailyCount

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def AutoScanEnabled(self):
        return self._AutoScanEnabled

    @AutoScanEnabled.setter
    def AutoScanEnabled(self, AutoScanEnabled):
        self._AutoScanEnabled = AutoScanEnabled

    @property
    def ScanType(self):
        return self._ScanType

    @ScanType.setter
    def ScanType(self, ScanType):
        self._ScanType = ScanType

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._IsEnabled = params.get("IsEnabled")
        self._RangeType = params.get("RangeType")
        self._HostCount = params.get("HostCount")
        self._MaxDailyCount = params.get("MaxDailyCount")
        self._RuleId = params.get("RuleId")
        self._AutoScanEnabled = params.get("AutoScanEnabled")
        self._ScanType = params.get("ScanType")
        self._RequestId = params.get("RequestId")


class DescribeImageAutoAuthorizedTaskListRequest(AbstractModel):
    """DescribeImageAutoAuthorizedTaskList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _Filters: 过滤字段
Status授权结果，全部授权成功：ALLSUCCSESS，部分授权失败：PARTIALFAIL,全部授权失败：ALLFAIL
Type授权方式，AUTO:自动授权，MANUAL:手动授权
Source 镜像来源，LOCAL:本地镜像，REGISTRY:仓库镜像
        :type Filters: list of AssetFilters
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0
        :type Offset: int
        """
        self._StartTime = None
        self._EndTime = None
        self._Filters = None
        self._Limit = None
        self._Offset = None

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageAutoAuthorizedTaskListResponse(AbstractModel):
    """DescribeImageAutoAuthorizedTaskList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 自动授权任务列表
        :type List: list of ImageAutoAuthorizedTask
        :param _TotalCount: 总数量
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ImageAutoAuthorizedTask()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeImageComponentListRequest(AbstractModel):
    """DescribeImageComponentList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ImageID: 镜像ID
        :type ImageID: str
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>ComponentName- String - 是否必填：否 - 镜像组件名称</li><li>ComponentVersion- String - 是否必填：否 - 镜像组件版本</li><li>ComponentType- String - 是否必填：否 - 镜像组件类型</li><li>VulLevel- String - 是否必填：否 - 漏洞威胁等级</li><li>HasVul- String - 是否必填：否 -是否有漏洞；true：是，false，否；不传或ALL ：全部</li>
        :type Filters: list of AssetFilters
        :param _By: 排序字段
        :type By: str
        :param _Order: 排序方式desc ，asc
        :type Order: str
        """
        self._ImageID = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._ImageID = params.get("ImageID")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageComponentListResponse(AbstractModel):
    """DescribeImageComponentList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数量
        :type TotalCount: int
        :param _List: 镜像组件列表
        :type List: list of ImageComponent
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ImageComponent()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeImageRegistryNamespaceListRequest(AbstractModel):
    """DescribeImageRegistryNamespaceList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Offset: 本次查询的起始偏移量，默认为0。
        :type Offset: int
        :param _Limit: 本次查询的数据量，默认为10，最大值为100。
        :type Limit: int
        :param _Filters: 查询的过滤条件。Name字段可取值"Namespace"。
        :type Filters: list of AssetFilters
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageRegistryNamespaceListResponse(AbstractModel):
    """DescribeImageRegistryNamespaceList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 可返回的命令空间的总量。
        :type TotalCount: int
        :param _NamespaceList: 返回的命令空间列表
        :type NamespaceList: list of str
        :param _NamespaceDetail: 返回的命令空间详细信息列表
        :type NamespaceDetail: list of NamespaceInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._NamespaceList = None
        self._NamespaceDetail = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def NamespaceList(self):
        return self._NamespaceList

    @NamespaceList.setter
    def NamespaceList(self, NamespaceList):
        self._NamespaceList = NamespaceList

    @property
    def NamespaceDetail(self):
        return self._NamespaceDetail

    @NamespaceDetail.setter
    def NamespaceDetail(self, NamespaceDetail):
        self._NamespaceDetail = NamespaceDetail

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._NamespaceList = params.get("NamespaceList")
        if params.get("NamespaceDetail") is not None:
            self._NamespaceDetail = []
            for item in params.get("NamespaceDetail"):
                obj = NamespaceInfo()
                obj._deserialize(item)
                self._NamespaceDetail.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeImageRegistryTimingScanTaskRequest(AbstractModel):
    """DescribeImageRegistryTimingScanTask请求参数结构体

    """


class DescribeImageRegistryTimingScanTaskResponse(AbstractModel):
    """DescribeImageRegistryTimingScanTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Enable: 定时扫描开关
注意：此字段可能返回 null，表示取不到有效值。
        :type Enable: bool
        :param _ScanTime: 定时任务扫描时间
        :type ScanTime: str
        :param _ScanPeriod: 定时扫描间隔
        :type ScanPeriod: int
        :param _ScanType: 扫描类型数组
注意：此字段可能返回 null，表示取不到有效值。
        :type ScanType: list of str
        :param _All: 扫描全部镜像
        :type All: bool
        :param _Images: 自定义扫描镜像
注意：此字段可能返回 null，表示取不到有效值。
        :type Images: list of ImageInfo
        :param _Id: 自动以扫描镜像Id
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: list of int non-negative
        :param _Latest: 是否扫描最新版本镜像
注意：此字段可能返回 null，表示取不到有效值。
        :type Latest: bool
        :param _ScanEndTime: 扫描结束时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ScanEndTime: str
        :param _RegistryType: 仓库类型 tcr,ccr,harbor	
        :type RegistryType: list of str
        :param _ContainerRunning: 是否存在运行中的容器	
        :type ContainerRunning: bool
        :param _ScanScope: 扫描范围 0全部镜像，1自选镜像，2推荐扫描镜像
        :type ScanScope: int
        :param _Namespace: 命名空间
        :type Namespace: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Enable = None
        self._ScanTime = None
        self._ScanPeriod = None
        self._ScanType = None
        self._All = None
        self._Images = None
        self._Id = None
        self._Latest = None
        self._ScanEndTime = None
        self._RegistryType = None
        self._ContainerRunning = None
        self._ScanScope = None
        self._Namespace = None
        self._RequestId = None

    @property
    def Enable(self):
        return self._Enable

    @Enable.setter
    def Enable(self, Enable):
        self._Enable = Enable

    @property
    def ScanTime(self):
        return self._ScanTime

    @ScanTime.setter
    def ScanTime(self, ScanTime):
        self._ScanTime = ScanTime

    @property
    def ScanPeriod(self):
        return self._ScanPeriod

    @ScanPeriod.setter
    def ScanPeriod(self, ScanPeriod):
        self._ScanPeriod = ScanPeriod

    @property
    def ScanType(self):
        return self._ScanType

    @ScanType.setter
    def ScanType(self, ScanType):
        self._ScanType = ScanType

    @property
    def All(self):
        warnings.warn("parameter `All` is deprecated", DeprecationWarning) 

        return self._All

    @All.setter
    def All(self, All):
        warnings.warn("parameter `All` is deprecated", DeprecationWarning) 

        self._All = All

    @property
    def Images(self):
        return self._Images

    @Images.setter
    def Images(self, Images):
        self._Images = Images

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Latest(self):
        return self._Latest

    @Latest.setter
    def Latest(self, Latest):
        self._Latest = Latest

    @property
    def ScanEndTime(self):
        return self._ScanEndTime

    @ScanEndTime.setter
    def ScanEndTime(self, ScanEndTime):
        self._ScanEndTime = ScanEndTime

    @property
    def RegistryType(self):
        return self._RegistryType

    @RegistryType.setter
    def RegistryType(self, RegistryType):
        self._RegistryType = RegistryType

    @property
    def ContainerRunning(self):
        return self._ContainerRunning

    @ContainerRunning.setter
    def ContainerRunning(self, ContainerRunning):
        self._ContainerRunning = ContainerRunning

    @property
    def ScanScope(self):
        return self._ScanScope

    @ScanScope.setter
    def ScanScope(self, ScanScope):
        self._ScanScope = ScanScope

    @property
    def Namespace(self):
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Enable = params.get("Enable")
        self._ScanTime = params.get("ScanTime")
        self._ScanPeriod = params.get("ScanPeriod")
        self._ScanType = params.get("ScanType")
        self._All = params.get("All")
        if params.get("Images") is not None:
            self._Images = []
            for item in params.get("Images"):
                obj = ImageInfo()
                obj._deserialize(item)
                self._Images.append(obj)
        self._Id = params.get("Id")
        self._Latest = params.get("Latest")
        self._ScanEndTime = params.get("ScanEndTime")
        self._RegistryType = params.get("RegistryType")
        self._ContainerRunning = params.get("ContainerRunning")
        self._ScanScope = params.get("ScanScope")
        self._Namespace = params.get("Namespace")
        self._RequestId = params.get("RequestId")


class DescribeImageRiskSummaryRequest(AbstractModel):
    """DescribeImageRiskSummary请求参数结构体

    """


class DescribeImageRiskSummaryResponse(AbstractModel):
    """DescribeImageRiskSummary返回参数结构体

    """

    def __init__(self):
        r"""
        :param _VulnerabilityCnt: 安全漏洞
        :type VulnerabilityCnt: list of RunTimeRiskInfo
        :param _MalwareVirusCnt: 木马病毒
        :type MalwareVirusCnt: list of RunTimeRiskInfo
        :param _RiskCnt: 敏感信息
        :type RiskCnt: list of RunTimeRiskInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._VulnerabilityCnt = None
        self._MalwareVirusCnt = None
        self._RiskCnt = None
        self._RequestId = None

    @property
    def VulnerabilityCnt(self):
        return self._VulnerabilityCnt

    @VulnerabilityCnt.setter
    def VulnerabilityCnt(self, VulnerabilityCnt):
        self._VulnerabilityCnt = VulnerabilityCnt

    @property
    def MalwareVirusCnt(self):
        return self._MalwareVirusCnt

    @MalwareVirusCnt.setter
    def MalwareVirusCnt(self, MalwareVirusCnt):
        self._MalwareVirusCnt = MalwareVirusCnt

    @property
    def RiskCnt(self):
        return self._RiskCnt

    @RiskCnt.setter
    def RiskCnt(self, RiskCnt):
        self._RiskCnt = RiskCnt

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("VulnerabilityCnt") is not None:
            self._VulnerabilityCnt = []
            for item in params.get("VulnerabilityCnt"):
                obj = RunTimeRiskInfo()
                obj._deserialize(item)
                self._VulnerabilityCnt.append(obj)
        if params.get("MalwareVirusCnt") is not None:
            self._MalwareVirusCnt = []
            for item in params.get("MalwareVirusCnt"):
                obj = RunTimeRiskInfo()
                obj._deserialize(item)
                self._MalwareVirusCnt.append(obj)
        if params.get("RiskCnt") is not None:
            self._RiskCnt = []
            for item in params.get("RiskCnt"):
                obj = RunTimeRiskInfo()
                obj._deserialize(item)
                self._RiskCnt.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeImageRiskTendencyRequest(AbstractModel):
    """DescribeImageRiskTendency请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        """
        self._StartTime = None
        self._EndTime = None

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageRiskTendencyResponse(AbstractModel):
    """DescribeImageRiskTendency返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ImageRiskTendencySet: 本地镜像新增风险趋势信息列表
        :type ImageRiskTendencySet: list of ImageRiskTendencyInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ImageRiskTendencySet = None
        self._RequestId = None

    @property
    def ImageRiskTendencySet(self):
        return self._ImageRiskTendencySet

    @ImageRiskTendencySet.setter
    def ImageRiskTendencySet(self, ImageRiskTendencySet):
        self._ImageRiskTendencySet = ImageRiskTendencySet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ImageRiskTendencySet") is not None:
            self._ImageRiskTendencySet = []
            for item in params.get("ImageRiskTendencySet"):
                obj = ImageRiskTendencyInfo()
                obj._deserialize(item)
                self._ImageRiskTendencySet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeImageSimpleListRequest(AbstractModel):
    """DescribeImageSimpleList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: IsAuthorized 是否已经授权, 0:否 1:是 无:全部
        :type Filters: list of RunTimeFilters
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Order: 排序方式
        :type Order: str
        :param _By: 排序字段
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageSimpleListResponse(AbstractModel):
    """DescribeImageSimpleList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ImageList: 镜像列表
        :type ImageList: list of ImageSimpleInfo
        :param _ImageCnt: 镜像数
        :type ImageCnt: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ImageList = None
        self._ImageCnt = None
        self._RequestId = None

    @property
    def ImageList(self):
        return self._ImageList

    @ImageList.setter
    def ImageList(self, ImageList):
        self._ImageList = ImageList

    @property
    def ImageCnt(self):
        return self._ImageCnt

    @ImageCnt.setter
    def ImageCnt(self, ImageCnt):
        self._ImageCnt = ImageCnt

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ImageList") is not None:
            self._ImageList = []
            for item in params.get("ImageList"):
                obj = ImageSimpleInfo()
                obj._deserialize(item)
                self._ImageList.append(obj)
        self._ImageCnt = params.get("ImageCnt")
        self._RequestId = params.get("RequestId")


class DescribeIndexListRequest(AbstractModel):
    """DescribeIndexList请求参数结构体

    """


class DescribeIndexListResponse(AbstractModel):
    """DescribeIndexList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: ES 索引信息
        :type Data: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeInspectionReportRequest(AbstractModel):
    """DescribeInspectionReport请求参数结构体

    """


class DescribeInspectionReportResponse(AbstractModel):
    """DescribeInspectionReport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ReportName: 报告名称
        :type ReportName: str
        :param _ReportUrl: 下载链接
        :type ReportUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ReportName = None
        self._ReportUrl = None
        self._RequestId = None

    @property
    def ReportName(self):
        return self._ReportName

    @ReportName.setter
    def ReportName(self, ReportName):
        self._ReportName = ReportName

    @property
    def ReportUrl(self):
        return self._ReportUrl

    @ReportUrl.setter
    def ReportUrl(self, ReportUrl):
        self._ReportUrl = ReportUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ReportName = params.get("ReportName")
        self._ReportUrl = params.get("ReportUrl")
        self._RequestId = params.get("RequestId")


class DescribeK8sApiAbnormalEventInfoRequest(AbstractModel):
    """DescribeK8sApiAbnormalEventInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ID: 事件ID
        :type ID: int
        """
        self._ID = None

    @property
    def ID(self):
        return self._ID

    @ID.setter
    def ID(self, ID):
        self._ID = ID


    def _deserialize(self, params):
        self._ID = params.get("ID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeK8sApiAbnormalEventInfoResponse(AbstractModel):
    """DescribeK8sApiAbnormalEventInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Info: 事件详情
        :type Info: :class:`tencentcloud.tcss.v20201101.models.K8sApiAbnormalEventInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Info = None
        self._RequestId = None

    @property
    def Info(self):
        return self._Info

    @Info.setter
    def Info(self, Info):
        self._Info = Info

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Info") is not None:
            self._Info = K8sApiAbnormalEventInfo()
            self._Info._deserialize(params.get("Info"))
        self._RequestId = params.get("RequestId")


class DescribeK8sApiAbnormalEventListRequest(AbstractModel):
    """DescribeK8sApiAbnormalEventList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li>TimeRange - string -是否必填: 否 - 时间范围筛选 ["2022-03-31 16:55:00", "2022-03-31 17:00:00"]</li>
<li>MatchRules - string  - 是否必填: 否 -命中规则筛选</li>
<li>RiskLevel - string  - 是否必填: 否 -威胁等级筛选</li>
<li>Status - string  - 是否必填: 否 -事件状态筛选</li>
<li>MatchRuleType - string  - 是否必填: 否 -命中规则类型筛选</li>
<li>ClusterRunningStatus - string  - 是否必填: 否 -集群运行状态</li>
<li>ClusterName - string  - 是否必填: 否 -集群名称</li>
<li>ClusterID - string  - 是否必填: 否 -集群ID</li>
        :type Filters: list of RunTimeFilters
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Order: 排序方式
        :type Order: str
        :param _By: 排序字段
LatestFoundTime: 最近生成时间
AlarmCount: 告警数量
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeK8sApiAbnormalEventListResponse(AbstractModel):
    """DescribeK8sApiAbnormalEventList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 事件列表
        :type List: list of K8sApiAbnormalEventListItem
        :param _TotalCount: 总数量
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = K8sApiAbnormalEventListItem()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeK8sApiAbnormalRuleInfoRequest(AbstractModel):
    """DescribeK8sApiAbnormalRuleInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleID: 规则ID
        :type RuleID: str
        """
        self._RuleID = None

    @property
    def RuleID(self):
        return self._RuleID

    @RuleID.setter
    def RuleID(self, RuleID):
        self._RuleID = RuleID


    def _deserialize(self, params):
        self._RuleID = params.get("RuleID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeK8sApiAbnormalRuleInfoResponse(AbstractModel):
    """DescribeK8sApiAbnormalRuleInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Info: 规则详情
        :type Info: :class:`tencentcloud.tcss.v20201101.models.K8sApiAbnormalRuleInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Info = None
        self._RequestId = None

    @property
    def Info(self):
        return self._Info

    @Info.setter
    def Info(self, Info):
        self._Info = Info

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Info") is not None:
            self._Info = K8sApiAbnormalRuleInfo()
            self._Info._deserialize(params.get("Info"))
        self._RequestId = params.get("RequestId")


class DescribeK8sApiAbnormalRuleListRequest(AbstractModel):
    """DescribeK8sApiAbnormalRuleList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li>RuleType - string  - 是否必填: 否 -规则类型</li>
<li>Status - string  - 是否必填: 否 -状态</li>
        :type Filters: list of RunTimeFilters
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Order: 排序方式
        :type Order: str
        :param _By: 排序字段。
<li>UpdateTime - string  - 是否必填: 否 -最后更新时间</li>
<li>EffectClusterCount - string  - 是否必填: 否 -影响集群数</li>
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeK8sApiAbnormalRuleListResponse(AbstractModel):
    """DescribeK8sApiAbnormalRuleList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 规则列表
        :type List: list of K8sApiAbnormalRuleListItem
        :param _TotalCount: 总数量
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = K8sApiAbnormalRuleListItem()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeK8sApiAbnormalRuleScopeListRequest(AbstractModel):
    """DescribeK8sApiAbnormalRuleScopeList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleID: 规则ID
        :type RuleID: str
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Filters: 过滤条件。
<li>Action - string -是否必填: 否 - 执行动作</li>
<li>RiskLevel - string  - 是否必填: 否 -威胁等级筛选</li>
        :type Filters: list of RunTimeFilters
        """
        self._RuleID = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def RuleID(self):
        return self._RuleID

    @RuleID.setter
    def RuleID(self, RuleID):
        self._RuleID = RuleID

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._RuleID = params.get("RuleID")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeK8sApiAbnormalRuleScopeListResponse(AbstractModel):
    """DescribeK8sApiAbnormalRuleScopeList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数
        :type TotalCount: int
        :param _List: 列表
        :type List: list of K8sApiAbnormalRuleScopeInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = K8sApiAbnormalRuleScopeInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeK8sApiAbnormalSummaryRequest(AbstractModel):
    """DescribeK8sApiAbnormalSummary请求参数结构体

    """


class DescribeK8sApiAbnormalSummaryResponse(AbstractModel):
    """DescribeK8sApiAbnormalSummary返回参数结构体

    """

    def __init__(self):
        r"""
        :param _UnhandleEventCount: 待处理事件个数
        :type UnhandleEventCount: int
        :param _UnhandleHighLevelEventCount: 待处理高危事件个数
        :type UnhandleHighLevelEventCount: int
        :param _UnhandleMediumLevelEventCount: 待处理中危事件个数
        :type UnhandleMediumLevelEventCount: int
        :param _UnhandleLowLevelEventCount: 待处理低危事件个数
        :type UnhandleLowLevelEventCount: int
        :param _UnhandleNoticeLevelEventCount: 待处理提示级别事件个数
        :type UnhandleNoticeLevelEventCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._UnhandleEventCount = None
        self._UnhandleHighLevelEventCount = None
        self._UnhandleMediumLevelEventCount = None
        self._UnhandleLowLevelEventCount = None
        self._UnhandleNoticeLevelEventCount = None
        self._RequestId = None

    @property
    def UnhandleEventCount(self):
        return self._UnhandleEventCount

    @UnhandleEventCount.setter
    def UnhandleEventCount(self, UnhandleEventCount):
        self._UnhandleEventCount = UnhandleEventCount

    @property
    def UnhandleHighLevelEventCount(self):
        return self._UnhandleHighLevelEventCount

    @UnhandleHighLevelEventCount.setter
    def UnhandleHighLevelEventCount(self, UnhandleHighLevelEventCount):
        self._UnhandleHighLevelEventCount = UnhandleHighLevelEventCount

    @property
    def UnhandleMediumLevelEventCount(self):
        return self._UnhandleMediumLevelEventCount

    @UnhandleMediumLevelEventCount.setter
    def UnhandleMediumLevelEventCount(self, UnhandleMediumLevelEventCount):
        self._UnhandleMediumLevelEventCount = UnhandleMediumLevelEventCount

    @property
    def UnhandleLowLevelEventCount(self):
        return self._UnhandleLowLevelEventCount

    @UnhandleLowLevelEventCount.setter
    def UnhandleLowLevelEventCount(self, UnhandleLowLevelEventCount):
        self._UnhandleLowLevelEventCount = UnhandleLowLevelEventCount

    @property
    def UnhandleNoticeLevelEventCount(self):
        return self._UnhandleNoticeLevelEventCount

    @UnhandleNoticeLevelEventCount.setter
    def UnhandleNoticeLevelEventCount(self, UnhandleNoticeLevelEventCount):
        self._UnhandleNoticeLevelEventCount = UnhandleNoticeLevelEventCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._UnhandleEventCount = params.get("UnhandleEventCount")
        self._UnhandleHighLevelEventCount = params.get("UnhandleHighLevelEventCount")
        self._UnhandleMediumLevelEventCount = params.get("UnhandleMediumLevelEventCount")
        self._UnhandleLowLevelEventCount = params.get("UnhandleLowLevelEventCount")
        self._UnhandleNoticeLevelEventCount = params.get("UnhandleNoticeLevelEventCount")
        self._RequestId = params.get("RequestId")


class DescribeK8sApiAbnormalTendencyRequest(AbstractModel):
    """DescribeK8sApiAbnormalTendency请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TendencyPeriod: 趋势周期(默认为7天)
        :type TendencyPeriod: int
        """
        self._TendencyPeriod = None

    @property
    def TendencyPeriod(self):
        return self._TendencyPeriod

    @TendencyPeriod.setter
    def TendencyPeriod(self, TendencyPeriod):
        self._TendencyPeriod = TendencyPeriod


    def _deserialize(self, params):
        self._TendencyPeriod = params.get("TendencyPeriod")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeK8sApiAbnormalTendencyResponse(AbstractModel):
    """DescribeK8sApiAbnormalTendency返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 趋势列表
        :type List: list of K8sApiAbnormalTendencyItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = K8sApiAbnormalTendencyItem()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLogStorageStatisticRequest(AbstractModel):
    """DescribeLogStorageStatistic请求参数结构体

    """


class DescribeLogStorageStatisticResponse(AbstractModel):
    """DescribeLogStorageStatistic返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalSize: 总容量（单位：B）
        :type TotalSize: int
        :param _UsedSize: 已使用容量（单位：B）
        :type UsedSize: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalSize = None
        self._UsedSize = None
        self._RequestId = None

    @property
    def TotalSize(self):
        return self._TotalSize

    @TotalSize.setter
    def TotalSize(self, TotalSize):
        self._TotalSize = TotalSize

    @property
    def UsedSize(self):
        return self._UsedSize

    @UsedSize.setter
    def UsedSize(self, UsedSize):
        self._UsedSize = UsedSize

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalSize = params.get("TotalSize")
        self._UsedSize = params.get("UsedSize")
        self._RequestId = params.get("RequestId")


class DescribeNetworkFirewallAuditRecordRequest(AbstractModel):
    """DescribeNetworkFirewallAuditRecord请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 每次查询的最大记录数量
        :type Limit: int
        :param _Filters: Name - Action
Name 可取值：publish，unpublish，confirm，add，update，delete
        :type Filters: list of ComplianceFilters
        :param _By: 排序字段
        :type By: str
        :param _Order: 排序方式 asc,desc
        :type Order: str
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallAuditRecordResponse(AbstractModel):
    """DescribeNetworkFirewallAuditRecord返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 集群审计总数
        :type TotalCount: int
        :param _AuditList: 集群的审计详细信息
        :type AuditList: list of NetworkAuditRecord
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._AuditList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AuditList(self):
        return self._AuditList

    @AuditList.setter
    def AuditList(self, AuditList):
        self._AuditList = AuditList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AuditList") is not None:
            self._AuditList = []
            for item in params.get("AuditList"):
                obj = NetworkAuditRecord()
                obj._deserialize(item)
                self._AuditList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeNetworkFirewallClusterListRequest(AbstractModel):
    """DescribeNetworkFirewallClusterList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 每次查询的最大记录数量
        :type Limit: int
        :param _Filters: Name - String
Name 可取值：ClusterName,ClusterId,ClusterType,Region,ClusterCheckMode,ClusterAutoCheck
        :type Filters: list of ComplianceFilters
        :param _By: 排序字段
        :type By: str
        :param _Order: 排序方式 asc,desc
        :type Order: str
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallClusterListResponse(AbstractModel):
    """DescribeNetworkFirewallClusterList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 集群总数
        :type TotalCount: int
        :param _ClusterInfoList: 集群的详细信息
        :type ClusterInfoList: list of NetworkClusterInfoItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ClusterInfoList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ClusterInfoList(self):
        return self._ClusterInfoList

    @ClusterInfoList.setter
    def ClusterInfoList(self, ClusterInfoList):
        self._ClusterInfoList = ClusterInfoList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ClusterInfoList") is not None:
            self._ClusterInfoList = []
            for item in params.get("ClusterInfoList"):
                obj = NetworkClusterInfoItem()
                obj._deserialize(item)
                self._ClusterInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeNetworkFirewallClusterRefreshStatusRequest(AbstractModel):
    """DescribeNetworkFirewallClusterRefreshStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
        :type TaskId: int
        """
        self._TaskId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallClusterRefreshStatusResponse(AbstractModel):
    """DescribeNetworkFirewallClusterRefreshStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskStatus: 任务状态，可能为：Task_Running,Task_Succ,Task_Error,Task_NoExist
        :type TaskStatus: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskStatus = None
        self._RequestId = None

    @property
    def TaskStatus(self):
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskStatus = params.get("TaskStatus")
        self._RequestId = params.get("RequestId")


class DescribeNetworkFirewallNamespaceLabelListRequest(AbstractModel):
    """DescribeNetworkFirewallNamespaceLabelList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群id
        :type ClusterId: str
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 每次查询的最大记录数量
        :type Limit: int
        :param _Filters: Name - String
Name 可取值：ClusterName,ClusterId,ClusterType,Region,ClusterCheckMode,ClusterAutoCheck
        :type Filters: list of ComplianceFilters
        :param _By: 排序字段
        :type By: str
        :param _Order: 排序方式 asc,desc
        :type Order: str
        """
        self._ClusterId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallNamespaceLabelListResponse(AbstractModel):
    """DescribeNetworkFirewallNamespaceLabelList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 集群总数
        :type TotalCount: int
        :param _ClusterNamespaceLabelList: 集群空间标签详细信息
        :type ClusterNamespaceLabelList: list of NetworkClusterNamespaceLabelInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ClusterNamespaceLabelList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ClusterNamespaceLabelList(self):
        return self._ClusterNamespaceLabelList

    @ClusterNamespaceLabelList.setter
    def ClusterNamespaceLabelList(self, ClusterNamespaceLabelList):
        self._ClusterNamespaceLabelList = ClusterNamespaceLabelList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ClusterNamespaceLabelList") is not None:
            self._ClusterNamespaceLabelList = []
            for item in params.get("ClusterNamespaceLabelList"):
                obj = NetworkClusterNamespaceLabelInfo()
                obj._deserialize(item)
                self._ClusterNamespaceLabelList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeNetworkFirewallNamespaceListRequest(AbstractModel):
    """DescribeNetworkFirewallNamespaceList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群id
        :type ClusterId: str
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 每次查询的最大记录数量
        :type Limit: int
        :param _Filters: Name - String
Name 可取值：ClusterName,ClusterId,ClusterType,Region,ClusterCheckMode,ClusterAutoCheck
        :type Filters: list of ComplianceFilters
        :param _By: 排序字段
        :type By: str
        :param _Order: 排序方式 asc,desc
        :type Order: str
        """
        self._ClusterId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallNamespaceListResponse(AbstractModel):
    """DescribeNetworkFirewallNamespaceList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 集群总数
        :type TotalCount: int
        :param _ClusterNamespaceList: 集群的详细信息
        :type ClusterNamespaceList: list of NetworkClusterNamespaceInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ClusterNamespaceList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ClusterNamespaceList(self):
        return self._ClusterNamespaceList

    @ClusterNamespaceList.setter
    def ClusterNamespaceList(self, ClusterNamespaceList):
        self._ClusterNamespaceList = ClusterNamespaceList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ClusterNamespaceList") is not None:
            self._ClusterNamespaceList = []
            for item in params.get("ClusterNamespaceList"):
                obj = NetworkClusterNamespaceInfo()
                obj._deserialize(item)
                self._ClusterNamespaceList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeNetworkFirewallPodLabelsListRequest(AbstractModel):
    """DescribeNetworkFirewallPodLabelsList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群id
        :type ClusterId: str
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 每次查询的最大记录数量
        :type Limit: int
        :param _Filters: Name - String
Name 可取值：ClusterName,ClusterId,ClusterType,Region,ClusterCheckMode,ClusterAutoCheck
        :type Filters: list of ComplianceFilters
        :param _By: 排序字段
        :type By: str
        :param _Order: 排序方式 asc,desc
        :type Order: str
        """
        self._ClusterId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallPodLabelsListResponse(AbstractModel):
    """DescribeNetworkFirewallPodLabelsList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 集群pod总数
        :type TotalCount: int
        :param _PodList: 集群pod详细信息
注意：此字段可能返回 null，表示取不到有效值。
        :type PodList: list of NetworkClusterPodInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._PodList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PodList(self):
        return self._PodList

    @PodList.setter
    def PodList(self, PodList):
        self._PodList = PodList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("PodList") is not None:
            self._PodList = []
            for item in params.get("PodList"):
                obj = NetworkClusterPodInfo()
                obj._deserialize(item)
                self._PodList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeNetworkFirewallPolicyDetailRequest(AbstractModel):
    """DescribeNetworkFirewallPolicyDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 策略Id
        :type Id: int
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallPolicyDetailResponse(AbstractModel):
    """DescribeNetworkFirewallPolicyDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群Id
        :type ClusterId: str
        :param _PolicyName: 策略名
        :type PolicyName: str
        :param _Namespace: 命名空间
注意：此字段可能返回 null，表示取不到有效值。
        :type Namespace: str
        :param _FromPolicyRule: 入站类型
        :type FromPolicyRule: int
        :param _ToPolicyRule: 出站类型
        :type ToPolicyRule: int
        :param _CustomPolicy: 自定义规则
注意：此字段可能返回 null，表示取不到有效值。
        :type CustomPolicy: list of NetworkCustomPolicy
        :param _PodSelector: pod选择器
        :type PodSelector: str
        :param _Description: 策略描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _PolicyCreateTime: 策略创建时间
        :type PolicyCreateTime: str
        :param _PolicySourceType: 策略源类型，分为System和Manual，分别代表手动和系统添加
        :type PolicySourceType: str
        :param _NetworkPolicyPlugin: 网络策略对应的网络插件
注意：此字段可能返回 null，表示取不到有效值。
        :type NetworkPolicyPlugin: str
        :param _PublishStatus: 网络策略状态
        :type PublishStatus: str
        :param _PublishResult: 网络发布结果
注意：此字段可能返回 null，表示取不到有效值。
        :type PublishResult: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ClusterId = None
        self._PolicyName = None
        self._Namespace = None
        self._FromPolicyRule = None
        self._ToPolicyRule = None
        self._CustomPolicy = None
        self._PodSelector = None
        self._Description = None
        self._PolicyCreateTime = None
        self._PolicySourceType = None
        self._NetworkPolicyPlugin = None
        self._PublishStatus = None
        self._PublishResult = None
        self._RequestId = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def PolicyName(self):
        return self._PolicyName

    @PolicyName.setter
    def PolicyName(self, PolicyName):
        self._PolicyName = PolicyName

    @property
    def Namespace(self):
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace

    @property
    def FromPolicyRule(self):
        return self._FromPolicyRule

    @FromPolicyRule.setter
    def FromPolicyRule(self, FromPolicyRule):
        self._FromPolicyRule = FromPolicyRule

    @property
    def ToPolicyRule(self):
        return self._ToPolicyRule

    @ToPolicyRule.setter
    def ToPolicyRule(self, ToPolicyRule):
        self._ToPolicyRule = ToPolicyRule

    @property
    def CustomPolicy(self):
        return self._CustomPolicy

    @CustomPolicy.setter
    def CustomPolicy(self, CustomPolicy):
        self._CustomPolicy = CustomPolicy

    @property
    def PodSelector(self):
        return self._PodSelector

    @PodSelector.setter
    def PodSelector(self, PodSelector):
        self._PodSelector = PodSelector

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def PolicyCreateTime(self):
        return self._PolicyCreateTime

    @PolicyCreateTime.setter
    def PolicyCreateTime(self, PolicyCreateTime):
        self._PolicyCreateTime = PolicyCreateTime

    @property
    def PolicySourceType(self):
        return self._PolicySourceType

    @PolicySourceType.setter
    def PolicySourceType(self, PolicySourceType):
        self._PolicySourceType = PolicySourceType

    @property
    def NetworkPolicyPlugin(self):
        return self._NetworkPolicyPlugin

    @NetworkPolicyPlugin.setter
    def NetworkPolicyPlugin(self, NetworkPolicyPlugin):
        self._NetworkPolicyPlugin = NetworkPolicyPlugin

    @property
    def PublishStatus(self):
        return self._PublishStatus

    @PublishStatus.setter
    def PublishStatus(self, PublishStatus):
        self._PublishStatus = PublishStatus

    @property
    def PublishResult(self):
        return self._PublishResult

    @PublishResult.setter
    def PublishResult(self, PublishResult):
        self._PublishResult = PublishResult

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._PolicyName = params.get("PolicyName")
        self._Namespace = params.get("Namespace")
        self._FromPolicyRule = params.get("FromPolicyRule")
        self._ToPolicyRule = params.get("ToPolicyRule")
        if params.get("CustomPolicy") is not None:
            self._CustomPolicy = []
            for item in params.get("CustomPolicy"):
                obj = NetworkCustomPolicy()
                obj._deserialize(item)
                self._CustomPolicy.append(obj)
        self._PodSelector = params.get("PodSelector")
        self._Description = params.get("Description")
        self._PolicyCreateTime = params.get("PolicyCreateTime")
        self._PolicySourceType = params.get("PolicySourceType")
        self._NetworkPolicyPlugin = params.get("NetworkPolicyPlugin")
        self._PublishStatus = params.get("PublishStatus")
        self._PublishResult = params.get("PublishResult")
        self._RequestId = params.get("RequestId")


class DescribeNetworkFirewallPolicyDiscoverRequest(AbstractModel):
    """DescribeNetworkFirewallPolicyDiscover请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
        :type TaskId: int
        """
        self._TaskId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallPolicyDiscoverResponse(AbstractModel):
    """DescribeNetworkFirewallPolicyDiscover返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskStatus: 任务状态，可能为：Task_Running,Task_Succ,Task_Error,Task_NoExist
        :type TaskStatus: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskStatus = None
        self._RequestId = None

    @property
    def TaskStatus(self):
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskStatus = params.get("TaskStatus")
        self._RequestId = params.get("RequestId")


class DescribeNetworkFirewallPolicyListRequest(AbstractModel):
    """DescribeNetworkFirewallPolicyList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群id
        :type ClusterId: str
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 每次查询的最大记录数量
        :type Limit: int
        :param _Filters: Name - String
Name 可取值：ClusterName,ClusterId,ClusterType,Region,ClusterCheckMode,ClusterAutoCheck
        :type Filters: list of ComplianceFilters
        :param _By: 排序字段
        :type By: str
        :param _Order: 排序方式 asc,desc
        :type Order: str
        """
        self._ClusterId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallPolicyListResponse(AbstractModel):
    """DescribeNetworkFirewallPolicyList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 集群总数
        :type TotalCount: int
        :param _NetPolicy: 集群的详细信息
        :type NetPolicy: list of NetworkPolicyInfoItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._NetPolicy = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def NetPolicy(self):
        return self._NetPolicy

    @NetPolicy.setter
    def NetPolicy(self, NetPolicy):
        self._NetPolicy = NetPolicy

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("NetPolicy") is not None:
            self._NetPolicy = []
            for item in params.get("NetPolicy"):
                obj = NetworkPolicyInfoItem()
                obj._deserialize(item)
                self._NetPolicy.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeNetworkFirewallPolicyStatusRequest(AbstractModel):
    """DescribeNetworkFirewallPolicyStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
        :type TaskId: int
        """
        self._TaskId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallPolicyStatusResponse(AbstractModel):
    """DescribeNetworkFirewallPolicyStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskStatus: 任务状态，可能为：Task_Running,Task_Succ,Task_Error,Task_NoExist
        :type TaskStatus: str
        :param _TaskResult: NameRepeat,K8sRuleIngressPortError等
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskResult: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskStatus = None
        self._TaskResult = None
        self._RequestId = None

    @property
    def TaskStatus(self):
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus

    @property
    def TaskResult(self):
        return self._TaskResult

    @TaskResult.setter
    def TaskResult(self, TaskResult):
        self._TaskResult = TaskResult

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskStatus = params.get("TaskStatus")
        self._TaskResult = params.get("TaskResult")
        self._RequestId = params.get("RequestId")


class DescribeNetworkFirewallPolicyYamlDetailRequest(AbstractModel):
    """DescribeNetworkFirewallPolicyYamlDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 策略Id
        :type Id: int
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallPolicyYamlDetailResponse(AbstractModel):
    """DescribeNetworkFirewallPolicyYamlDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群Id
        :type ClusterId: str
        :param _PolicyName: 策略名
        :type PolicyName: str
        :param _Yaml: base64编码的yaml字符串
注意：此字段可能返回 null，表示取不到有效值。
        :type Yaml: str
        :param _Description: 策略描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _PolicyCreateTime: 策略创建时间
        :type PolicyCreateTime: str
        :param _PolicySourceType: 策略源类型，分为System和Manual，分别代表手动和系统添加
        :type PolicySourceType: str
        :param _NetworkPolicyPlugin: 网络策略对应的网络插件
注意：此字段可能返回 null，表示取不到有效值。
        :type NetworkPolicyPlugin: str
        :param _PublishStatus: 网络策略状态
        :type PublishStatus: str
        :param _PublishResult: 网络发布结果
注意：此字段可能返回 null，表示取不到有效值。
        :type PublishResult: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ClusterId = None
        self._PolicyName = None
        self._Yaml = None
        self._Description = None
        self._PolicyCreateTime = None
        self._PolicySourceType = None
        self._NetworkPolicyPlugin = None
        self._PublishStatus = None
        self._PublishResult = None
        self._RequestId = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def PolicyName(self):
        return self._PolicyName

    @PolicyName.setter
    def PolicyName(self, PolicyName):
        self._PolicyName = PolicyName

    @property
    def Yaml(self):
        return self._Yaml

    @Yaml.setter
    def Yaml(self, Yaml):
        self._Yaml = Yaml

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def PolicyCreateTime(self):
        return self._PolicyCreateTime

    @PolicyCreateTime.setter
    def PolicyCreateTime(self, PolicyCreateTime):
        self._PolicyCreateTime = PolicyCreateTime

    @property
    def PolicySourceType(self):
        return self._PolicySourceType

    @PolicySourceType.setter
    def PolicySourceType(self, PolicySourceType):
        self._PolicySourceType = PolicySourceType

    @property
    def NetworkPolicyPlugin(self):
        return self._NetworkPolicyPlugin

    @NetworkPolicyPlugin.setter
    def NetworkPolicyPlugin(self, NetworkPolicyPlugin):
        self._NetworkPolicyPlugin = NetworkPolicyPlugin

    @property
    def PublishStatus(self):
        return self._PublishStatus

    @PublishStatus.setter
    def PublishStatus(self, PublishStatus):
        self._PublishStatus = PublishStatus

    @property
    def PublishResult(self):
        return self._PublishResult

    @PublishResult.setter
    def PublishResult(self, PublishResult):
        self._PublishResult = PublishResult

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._PolicyName = params.get("PolicyName")
        self._Yaml = params.get("Yaml")
        self._Description = params.get("Description")
        self._PolicyCreateTime = params.get("PolicyCreateTime")
        self._PolicySourceType = params.get("PolicySourceType")
        self._NetworkPolicyPlugin = params.get("NetworkPolicyPlugin")
        self._PublishStatus = params.get("PublishStatus")
        self._PublishResult = params.get("PublishResult")
        self._RequestId = params.get("RequestId")


class DescribeNewestVulRequest(AbstractModel):
    """DescribeNewestVul请求参数结构体

    """


class DescribeNewestVulResponse(AbstractModel):
    """DescribeNewestVul返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PocID: 漏洞PocID
        :type PocID: str
        :param _VulName: 漏洞名称
        :type VulName: str
        :param _SubmitTime: 披露时间
        :type SubmitTime: str
        :param _Status: 应急漏洞风险情况：NOT_SCAN：未扫描，SCANNING：扫描中，SCANNED：已扫描
        :type Status: str
        :param _CVEID: 漏洞CVEID
        :type CVEID: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PocID = None
        self._VulName = None
        self._SubmitTime = None
        self._Status = None
        self._CVEID = None
        self._RequestId = None

    @property
    def PocID(self):
        return self._PocID

    @PocID.setter
    def PocID(self, PocID):
        self._PocID = PocID

    @property
    def VulName(self):
        return self._VulName

    @VulName.setter
    def VulName(self, VulName):
        self._VulName = VulName

    @property
    def SubmitTime(self):
        return self._SubmitTime

    @SubmitTime.setter
    def SubmitTime(self, SubmitTime):
        self._SubmitTime = SubmitTime

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CVEID(self):
        return self._CVEID

    @CVEID.setter
    def CVEID(self, CVEID):
        self._CVEID = CVEID

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._PocID = params.get("PocID")
        self._VulName = params.get("VulName")
        self._SubmitTime = params.get("SubmitTime")
        self._Status = params.get("Status")
        self._CVEID = params.get("CVEID")
        self._RequestId = params.get("RequestId")


class DescribePostPayDetailRequest(AbstractModel):
    """DescribePostPayDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        """
        self._Limit = None
        self._Offset = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePostPayDetailResponse(AbstractModel):
    """DescribePostPayDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SoftQuotaDayDetail: 弹性计费扣费详情
注意：此字段可能返回 null，表示取不到有效值。
        :type SoftQuotaDayDetail: list of SoftQuotaDayInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SoftQuotaDayDetail = None
        self._RequestId = None

    @property
    def SoftQuotaDayDetail(self):
        return self._SoftQuotaDayDetail

    @SoftQuotaDayDetail.setter
    def SoftQuotaDayDetail(self, SoftQuotaDayDetail):
        self._SoftQuotaDayDetail = SoftQuotaDayDetail

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SoftQuotaDayDetail") is not None:
            self._SoftQuotaDayDetail = []
            for item in params.get("SoftQuotaDayDetail"):
                obj = SoftQuotaDayInfo()
                obj._deserialize(item)
                self._SoftQuotaDayDetail.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeProVersionInfoRequest(AbstractModel):
    """DescribeProVersionInfo请求参数结构体

    """


class DescribeProVersionInfoResponse(AbstractModel):
    """DescribeProVersionInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 专业版开始时间，补充购买时才不为空
注意：此字段可能返回 null，表示取不到有效值。
        :type StartTime: str
        :param _EndTime: 专业版结束时间，补充购买时才不为空
注意：此字段可能返回 null，表示取不到有效值。
        :type EndTime: str
        :param _CoresCnt: 需购买的机器核数
        :type CoresCnt: int
        :param _MaxPostPayCoresCnt: 弹性计费上限
        :type MaxPostPayCoresCnt: int
        :param _ResourceId: 资源ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ResourceId: str
        :param _BuyStatus: 购买状态
待购: Pending
已购: Normal
隔离: Isolate
        :type BuyStatus: str
        :param _IsPurchased: 是否曾经购买过(false:未曾 true:曾经购买过)
        :type IsPurchased: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._StartTime = None
        self._EndTime = None
        self._CoresCnt = None
        self._MaxPostPayCoresCnt = None
        self._ResourceId = None
        self._BuyStatus = None
        self._IsPurchased = None
        self._RequestId = None

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def CoresCnt(self):
        return self._CoresCnt

    @CoresCnt.setter
    def CoresCnt(self, CoresCnt):
        self._CoresCnt = CoresCnt

    @property
    def MaxPostPayCoresCnt(self):
        return self._MaxPostPayCoresCnt

    @MaxPostPayCoresCnt.setter
    def MaxPostPayCoresCnt(self, MaxPostPayCoresCnt):
        self._MaxPostPayCoresCnt = MaxPostPayCoresCnt

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def BuyStatus(self):
        return self._BuyStatus

    @BuyStatus.setter
    def BuyStatus(self, BuyStatus):
        self._BuyStatus = BuyStatus

    @property
    def IsPurchased(self):
        return self._IsPurchased

    @IsPurchased.setter
    def IsPurchased(self, IsPurchased):
        self._IsPurchased = IsPurchased

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._CoresCnt = params.get("CoresCnt")
        self._MaxPostPayCoresCnt = params.get("MaxPostPayCoresCnt")
        self._ResourceId = params.get("ResourceId")
        self._BuyStatus = params.get("BuyStatus")
        self._IsPurchased = params.get("IsPurchased")
        self._RequestId = params.get("RequestId")


class DescribePromotionActivityRequest(AbstractModel):
    """DescribePromotionActivity请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ActiveID: 活动ID
        :type ActiveID: int
        """
        self._ActiveID = None

    @property
    def ActiveID(self):
        return self._ActiveID

    @ActiveID.setter
    def ActiveID(self, ActiveID):
        self._ActiveID = ActiveID


    def _deserialize(self, params):
        self._ActiveID = params.get("ActiveID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePromotionActivityResponse(AbstractModel):
    """DescribePromotionActivity返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 促销活动内容
        :type List: list of PromotionActivityContent
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = PromotionActivityContent()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePublicKeyRequest(AbstractModel):
    """DescribePublicKey请求参数结构体

    """


class DescribePublicKeyResponse(AbstractModel):
    """DescribePublicKey返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PublicKey: 公钥
        :type PublicKey: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PublicKey = None
        self._RequestId = None

    @property
    def PublicKey(self):
        return self._PublicKey

    @PublicKey.setter
    def PublicKey(self, PublicKey):
        self._PublicKey = PublicKey

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._PublicKey = params.get("PublicKey")
        self._RequestId = params.get("RequestId")


class DescribePurchaseStateInfoRequest(AbstractModel):
    """DescribePurchaseStateInfo请求参数结构体

    """


class DescribePurchaseStateInfoResponse(AbstractModel):
    """DescribePurchaseStateInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _State: 0：可申请试用可购买；1：只可购买(含试用审核不通过和试用过期)；2：试用生效中；3：专业版生效中；4：专业版过期
        :type State: int
        :param _CoresCnt: 总核数
注意：此字段可能返回 null，表示取不到有效值。
        :type CoresCnt: int
        :param _AuthorizedCoresCnt: 已购买核数
注意：此字段可能返回 null，表示取不到有效值。
        :type AuthorizedCoresCnt: int
        :param _ImageCnt: 镜像数
注意：此字段可能返回 null，表示取不到有效值。
        :type ImageCnt: int
        :param _AuthorizedImageCnt: 已授权镜像数
注意：此字段可能返回 null，表示取不到有效值。
        :type AuthorizedImageCnt: int
        :param _PurchasedAuthorizedCnt: 已购买镜像授权数
注意：此字段可能返回 null，表示取不到有效值。
        :type PurchasedAuthorizedCnt: int
        :param _ExpirationTime: 过期时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ExpirationTime: str
        :param _AutomaticRenewal: 0表示默认状态(用户未设置，即初始状态)， 1表示自动续费，2表示明确不自动续费(用户设置)
注意：此字段可能返回 null，表示取不到有效值。
        :type AutomaticRenewal: int
        :param _GivenAuthorizedCnt: 试用期间赠送镜像授权数，可能会过期
注意：此字段可能返回 null，表示取不到有效值。
        :type GivenAuthorizedCnt: int
        :param _BeginTime: 起始时间
注意：此字段可能返回 null，表示取不到有效值。
        :type BeginTime: str
        :param _SubState: 子状态(具体意义依据State字段而定)
State为4时，有效值为: ISOLATE(隔离) DESTROED(已销毁)
注意：此字段可能返回 null，表示取不到有效值。
        :type SubState: str
        :param _InquireKey: 计费key
注意：此字段可能返回 null，表示取不到有效值。
        :type InquireKey: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._State = None
        self._CoresCnt = None
        self._AuthorizedCoresCnt = None
        self._ImageCnt = None
        self._AuthorizedImageCnt = None
        self._PurchasedAuthorizedCnt = None
        self._ExpirationTime = None
        self._AutomaticRenewal = None
        self._GivenAuthorizedCnt = None
        self._BeginTime = None
        self._SubState = None
        self._InquireKey = None
        self._RequestId = None

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def CoresCnt(self):
        return self._CoresCnt

    @CoresCnt.setter
    def CoresCnt(self, CoresCnt):
        self._CoresCnt = CoresCnt

    @property
    def AuthorizedCoresCnt(self):
        return self._AuthorizedCoresCnt

    @AuthorizedCoresCnt.setter
    def AuthorizedCoresCnt(self, AuthorizedCoresCnt):
        self._AuthorizedCoresCnt = AuthorizedCoresCnt

    @property
    def ImageCnt(self):
        return self._ImageCnt

    @ImageCnt.setter
    def ImageCnt(self, ImageCnt):
        self._ImageCnt = ImageCnt

    @property
    def AuthorizedImageCnt(self):
        return self._AuthorizedImageCnt

    @AuthorizedImageCnt.setter
    def AuthorizedImageCnt(self, AuthorizedImageCnt):
        self._AuthorizedImageCnt = AuthorizedImageCnt

    @property
    def PurchasedAuthorizedCnt(self):
        return self._PurchasedAuthorizedCnt

    @PurchasedAuthorizedCnt.setter
    def PurchasedAuthorizedCnt(self, PurchasedAuthorizedCnt):
        self._PurchasedAuthorizedCnt = PurchasedAuthorizedCnt

    @property
    def ExpirationTime(self):
        return self._ExpirationTime

    @ExpirationTime.setter
    def ExpirationTime(self, ExpirationTime):
        self._ExpirationTime = ExpirationTime

    @property
    def AutomaticRenewal(self):
        return self._AutomaticRenewal

    @AutomaticRenewal.setter
    def AutomaticRenewal(self, AutomaticRenewal):
        self._AutomaticRenewal = AutomaticRenewal

    @property
    def GivenAuthorizedCnt(self):
        return self._GivenAuthorizedCnt

    @GivenAuthorizedCnt.setter
    def GivenAuthorizedCnt(self, GivenAuthorizedCnt):
        self._GivenAuthorizedCnt = GivenAuthorizedCnt

    @property
    def BeginTime(self):
        return self._BeginTime

    @BeginTime.setter
    def BeginTime(self, BeginTime):
        self._BeginTime = BeginTime

    @property
    def SubState(self):
        return self._SubState

    @SubState.setter
    def SubState(self, SubState):
        self._SubState = SubState

    @property
    def InquireKey(self):
        return self._InquireKey

    @InquireKey.setter
    def InquireKey(self, InquireKey):
        self._InquireKey = InquireKey

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._State = params.get("State")
        self._CoresCnt = params.get("CoresCnt")
        self._AuthorizedCoresCnt = params.get("AuthorizedCoresCnt")
        self._ImageCnt = params.get("ImageCnt")
        self._AuthorizedImageCnt = params.get("AuthorizedImageCnt")
        self._PurchasedAuthorizedCnt = params.get("PurchasedAuthorizedCnt")
        self._ExpirationTime = params.get("ExpirationTime")
        self._AutomaticRenewal = params.get("AutomaticRenewal")
        self._GivenAuthorizedCnt = params.get("GivenAuthorizedCnt")
        self._BeginTime = params.get("BeginTime")
        self._SubState = params.get("SubState")
        self._InquireKey = params.get("InquireKey")
        self._RequestId = params.get("RequestId")


class DescribeRefreshTaskRequest(AbstractModel):
    """DescribeRefreshTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
        :type TaskId: int
        :param _NewTaskID: 新任务ID
        :type NewTaskID: str
        """
        self._TaskId = None
        self._NewTaskID = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def NewTaskID(self):
        return self._NewTaskID

    @NewTaskID.setter
    def NewTaskID(self, NewTaskID):
        self._NewTaskID = NewTaskID


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._NewTaskID = params.get("NewTaskID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRefreshTaskResponse(AbstractModel):
    """DescribeRefreshTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskStatus: 刷新任务状态，可能为：Task_New,Task_Running,Task_Finish,Task_Error,Task_NoExist
        :type TaskStatus: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskStatus = None
        self._RequestId = None

    @property
    def TaskStatus(self):
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskStatus = params.get("TaskStatus")
        self._RequestId = params.get("RequestId")


class DescribeReverseShellDetailRequest(AbstractModel):
    """DescribeReverseShellDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventId: 事件唯一id
        :type EventId: str
        """
        self._EventId = None

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId


    def _deserialize(self, params):
        self._EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReverseShellDetailResponse(AbstractModel):
    """DescribeReverseShellDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _EventBaseInfo: 事件基本信息
        :type EventBaseInfo: :class:`tencentcloud.tcss.v20201101.models.RunTimeEventBaseInfo`
        :param _ProcessInfo: 进程信息
        :type ProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessDetailInfo`
        :param _ParentProcessInfo: 父进程信息
        :type ParentProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessDetailBaseInfo`
        :param _EventDetail: 事件描述
        :type EventDetail: :class:`tencentcloud.tcss.v20201101.models.ReverseShellEventDescription`
        :param _AncestorProcessInfo: 祖先进程信息
注意：此字段可能返回 null，表示取不到有效值。
        :type AncestorProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessBaseInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._EventBaseInfo = None
        self._ProcessInfo = None
        self._ParentProcessInfo = None
        self._EventDetail = None
        self._AncestorProcessInfo = None
        self._RequestId = None

    @property
    def EventBaseInfo(self):
        return self._EventBaseInfo

    @EventBaseInfo.setter
    def EventBaseInfo(self, EventBaseInfo):
        self._EventBaseInfo = EventBaseInfo

    @property
    def ProcessInfo(self):
        return self._ProcessInfo

    @ProcessInfo.setter
    def ProcessInfo(self, ProcessInfo):
        self._ProcessInfo = ProcessInfo

    @property
    def ParentProcessInfo(self):
        return self._ParentProcessInfo

    @ParentProcessInfo.setter
    def ParentProcessInfo(self, ParentProcessInfo):
        self._ParentProcessInfo = ParentProcessInfo

    @property
    def EventDetail(self):
        return self._EventDetail

    @EventDetail.setter
    def EventDetail(self, EventDetail):
        self._EventDetail = EventDetail

    @property
    def AncestorProcessInfo(self):
        return self._AncestorProcessInfo

    @AncestorProcessInfo.setter
    def AncestorProcessInfo(self, AncestorProcessInfo):
        self._AncestorProcessInfo = AncestorProcessInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EventBaseInfo") is not None:
            self._EventBaseInfo = RunTimeEventBaseInfo()
            self._EventBaseInfo._deserialize(params.get("EventBaseInfo"))
        if params.get("ProcessInfo") is not None:
            self._ProcessInfo = ProcessDetailInfo()
            self._ProcessInfo._deserialize(params.get("ProcessInfo"))
        if params.get("ParentProcessInfo") is not None:
            self._ParentProcessInfo = ProcessDetailBaseInfo()
            self._ParentProcessInfo._deserialize(params.get("ParentProcessInfo"))
        if params.get("EventDetail") is not None:
            self._EventDetail = ReverseShellEventDescription()
            self._EventDetail._deserialize(params.get("EventDetail"))
        if params.get("AncestorProcessInfo") is not None:
            self._AncestorProcessInfo = ProcessBaseInfo()
            self._AncestorProcessInfo._deserialize(params.get("AncestorProcessInfo"))
        self._RequestId = params.get("RequestId")


class DescribeReverseShellEventsExportRequest(AbstractModel):
    """DescribeReverseShellEventsExport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤参数,"Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param _Order: 升序降序,asc desc
        :type Order: str
        :param _By: 排序字段
        :type By: str
        :param _ExportField: 导出字段
        :type ExportField: list of str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None
        self._ExportField = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        self._ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReverseShellEventsExportResponse(AbstractModel):
    """DescribeReverseShellEventsExport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: execle下载地址
注意：此字段可能返回 null，表示取不到有效值。
        :type DownloadUrl: str
        :param _JobId: 任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type JobId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._JobId = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class DescribeReverseShellEventsRequest(AbstractModel):
    """DescribeReverseShellEvents请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤参数
InnerNetAlarmShow- int - 是否必填：1 - 内网告警展示 0 - 不展示
        :type Filters: list of RunTimeFilters
        :param _Order: 升序降序,asc desc
        :type Order: str
        :param _By: 排序字段
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReverseShellEventsResponse(AbstractModel):
    """DescribeReverseShellEvents返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 事件总数量
        :type TotalCount: int
        :param _EventSet: 反弹shell数组
        :type EventSet: list of ReverseShellEventInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._EventSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def EventSet(self):
        return self._EventSet

    @EventSet.setter
    def EventSet(self, EventSet):
        self._EventSet = EventSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("EventSet") is not None:
            self._EventSet = []
            for item in params.get("EventSet"):
                obj = ReverseShellEventInfo()
                obj._deserialize(item)
                self._EventSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeReverseShellWhiteListDetailRequest(AbstractModel):
    """DescribeReverseShellWhiteListDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WhiteListId: 白名单id
        :type WhiteListId: str
        """
        self._WhiteListId = None

    @property
    def WhiteListId(self):
        return self._WhiteListId

    @WhiteListId.setter
    def WhiteListId(self, WhiteListId):
        self._WhiteListId = WhiteListId


    def _deserialize(self, params):
        self._WhiteListId = params.get("WhiteListId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReverseShellWhiteListDetailResponse(AbstractModel):
    """DescribeReverseShellWhiteListDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _WhiteListDetailInfo: 事件基本信息
        :type WhiteListDetailInfo: :class:`tencentcloud.tcss.v20201101.models.ReverseShellWhiteListInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._WhiteListDetailInfo = None
        self._RequestId = None

    @property
    def WhiteListDetailInfo(self):
        return self._WhiteListDetailInfo

    @WhiteListDetailInfo.setter
    def WhiteListDetailInfo(self, WhiteListDetailInfo):
        self._WhiteListDetailInfo = WhiteListDetailInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("WhiteListDetailInfo") is not None:
            self._WhiteListDetailInfo = ReverseShellWhiteListInfo()
            self._WhiteListDetailInfo._deserialize(params.get("WhiteListDetailInfo"))
        self._RequestId = params.get("RequestId")


class DescribeReverseShellWhiteListsRequest(AbstractModel):
    """DescribeReverseShellWhiteLists请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤参数,"Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param _Order: 升序降序,asc desc
        :type Order: str
        :param _By: 排序字段
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReverseShellWhiteListsResponse(AbstractModel):
    """DescribeReverseShellWhiteLists返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 事件总数量
        :type TotalCount: int
        :param _WhiteListSet: 白名单信息列表
        :type WhiteListSet: list of ReverseShellWhiteListBaseInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._WhiteListSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def WhiteListSet(self):
        return self._WhiteListSet

    @WhiteListSet.setter
    def WhiteListSet(self, WhiteListSet):
        self._WhiteListSet = WhiteListSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("WhiteListSet") is not None:
            self._WhiteListSet = []
            for item in params.get("WhiteListSet"):
                obj = ReverseShellWhiteListBaseInfo()
                obj._deserialize(item)
                self._WhiteListSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRiskDnsEventDetailRequest(AbstractModel):
    """DescribeRiskDnsEventDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventID: 事件ID
        :type EventID: int
        """
        self._EventID = None

    @property
    def EventID(self):
        return self._EventID

    @EventID.setter
    def EventID(self, EventID):
        self._EventID = EventID


    def _deserialize(self, params):
        self._EventID = params.get("EventID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRiskDnsEventDetailResponse(AbstractModel):
    """DescribeRiskDnsEventDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _EventID: 事件ID
        :type EventID: int
        :param _EventType: 事件类型，恶意域名请求：DOMAIN，恶意IP请求：IP
        :type EventType: str
        :param _EventCount: 恶意请求次数
        :type EventCount: int
        :param _FoundTime: 首次发现时间
        :type FoundTime: str
        :param _LatestFoundTime: 最近生成时间
        :type LatestFoundTime: str
        :param _ContainerID: 容器ID
        :type ContainerID: str
        :param _ContainerName: 容器名称
        :type ContainerName: str
        :param _ContainerNetStatus: 隔离状态
未隔离  	NORMAL
已隔离		ISOLATED
隔离中		ISOLATING
隔离失败	ISOLATE_FAILED
解除隔离中  RESTORING
解除隔离失败 RESTORE_FAILED
        :type ContainerNetStatus: str
        :param _ContainerStatus: 容器状态
正在运行: RUNNING
暂停: PAUSED
停止: STOPPED
已经创建: CREATED
已经销毁: DESTROYED
正在重启中: RESTARTING
迁移中: REMOVING
        :type ContainerStatus: str
        :param _ContainerNetSubStatus: 容器子状态
"AGENT_OFFLINE"       //Agent离线
"NODE_DESTROYED"      //节点已销毁
"CONTAINER_EXITED"    //容器已退出
"CONTAINER_DESTROYED" //容器已销毁
"SHARED_HOST"         // 容器与主机共享网络
"RESOURCE_LIMIT"      //隔离操作资源超限
"UNKNOW"              // 原因未知
        :type ContainerNetSubStatus: str
        :param _ContainerIsolateOperationSrc: 容器隔离操作来源
        :type ContainerIsolateOperationSrc: str
        :param _ImageID: 镜像ID
        :type ImageID: str
        :param _ImageName: 镜像名称
        :type ImageName: str
        :param _HostName: 主机名称
        :type HostName: str
        :param _HostIP: 内网IP
        :type HostIP: str
        :param _PublicIP: 外网IP
        :type PublicIP: str
        :param _PodName: 节点名称
        :type PodName: str
        :param _Description: 事件描述
        :type Description: str
        :param _Solution: 解决方案
        :type Solution: str
        :param _Reference: 参考链接
        :type Reference: list of str
        :param _Address: 恶意域名或IP
注意：此字段可能返回 null，表示取不到有效值。
        :type Address: str
        :param _City: 恶意IP所属城市
注意：此字段可能返回 null，表示取不到有效值。
        :type City: str
        :param _MatchRuleType: 命中规则类型
SYSTEM：系统规则
 USER：用户自定义
        :type MatchRuleType: str
        :param _FeatureLabel: 标签特征
        :type FeatureLabel: str
        :param _ProcessAuthority: 进程权限
        :type ProcessAuthority: str
        :param _ProcessMd5: 进程md5
        :type ProcessMd5: str
        :param _ProcessStartUser: 进程启动用户
        :type ProcessStartUser: str
        :param _ProcessUserGroup: 进程用户组
        :type ProcessUserGroup: str
        :param _ProcessPath: 进程路径
        :type ProcessPath: str
        :param _ProcessTree: 进程树
        :type ProcessTree: str
        :param _ProcessParam: 进程命令行参数
        :type ProcessParam: str
        :param _ParentProcessStartUser: 父进程启动用户
        :type ParentProcessStartUser: str
        :param _ParentProcessUserGroup: 父进程用户组
        :type ParentProcessUserGroup: str
        :param _ParentProcessPath: 父进程路径
        :type ParentProcessPath: str
        :param _ParentProcessParam: 父进程命令行参数
        :type ParentProcessParam: str
        :param _AncestorProcessStartUser: 祖先进程启动用户
        :type AncestorProcessStartUser: str
        :param _AncestorProcessUserGroup: 祖先进程用户组
        :type AncestorProcessUserGroup: str
        :param _AncestorProcessPath: 祖先进程路径
        :type AncestorProcessPath: str
        :param _AncestorProcessParam: 祖先进程命令行参数
        :type AncestorProcessParam: str
        :param _HostID: 主机ID
        :type HostID: str
        :param _EventStatus: 事件状态
EVENT_UNDEAL： 待处理
EVENT_DEALED：已处理
EVENT_IGNORE： 已忽略
EVENT_ADD_WHITE：已加白
        :type EventStatus: str
        :param _OperationTime: 操作时间
注意：此字段可能返回 null，表示取不到有效值。
        :type OperationTime: str
        :param _Remark: 备注
        :type Remark: str
        :param _NodeType: 节点类型
        :type NodeType: str
        :param _NodeName: 节点名称
        :type NodeName: str
        :param _NodeSubNetID: 节点子网ID
        :type NodeSubNetID: str
        :param _NodeSubNetName: 节点子网名称
        :type NodeSubNetName: str
        :param _NodeSubNetCIDR: 节点子网网段
        :type NodeSubNetCIDR: str
        :param _ClusterID: 集群ID
        :type ClusterID: str
        :param _PodIP: podip
        :type PodIP: str
        :param _PodStatus: pod状态
        :type PodStatus: str
        :param _NodeUniqueID: 节点唯一id
        :type NodeUniqueID: str
        :param _NodeID: 节点ID名称
        :type NodeID: str
        :param _ClusterName: 集群名称
        :type ClusterName: str
        :param _Namespace: Namespace
        :type Namespace: str
        :param _WorkloadType: 工作负载类型
        :type WorkloadType: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._EventID = None
        self._EventType = None
        self._EventCount = None
        self._FoundTime = None
        self._LatestFoundTime = None
        self._ContainerID = None
        self._ContainerName = None
        self._ContainerNetStatus = None
        self._ContainerStatus = None
        self._ContainerNetSubStatus = None
        self._ContainerIsolateOperationSrc = None
        self._ImageID = None
        self._ImageName = None
        self._HostName = None
        self._HostIP = None
        self._PublicIP = None
        self._PodName = None
        self._Description = None
        self._Solution = None
        self._Reference = None
        self._Address = None
        self._City = None
        self._MatchRuleType = None
        self._FeatureLabel = None
        self._ProcessAuthority = None
        self._ProcessMd5 = None
        self._ProcessStartUser = None
        self._ProcessUserGroup = None
        self._ProcessPath = None
        self._ProcessTree = None
        self._ProcessParam = None
        self._ParentProcessStartUser = None
        self._ParentProcessUserGroup = None
        self._ParentProcessPath = None
        self._ParentProcessParam = None
        self._AncestorProcessStartUser = None
        self._AncestorProcessUserGroup = None
        self._AncestorProcessPath = None
        self._AncestorProcessParam = None
        self._HostID = None
        self._EventStatus = None
        self._OperationTime = None
        self._Remark = None
        self._NodeType = None
        self._NodeName = None
        self._NodeSubNetID = None
        self._NodeSubNetName = None
        self._NodeSubNetCIDR = None
        self._ClusterID = None
        self._PodIP = None
        self._PodStatus = None
        self._NodeUniqueID = None
        self._NodeID = None
        self._ClusterName = None
        self._Namespace = None
        self._WorkloadType = None
        self._RequestId = None

    @property
    def EventID(self):
        return self._EventID

    @EventID.setter
    def EventID(self, EventID):
        self._EventID = EventID

    @property
    def EventType(self):
        return self._EventType

    @EventType.setter
    def EventType(self, EventType):
        self._EventType = EventType

    @property
    def EventCount(self):
        return self._EventCount

    @EventCount.setter
    def EventCount(self, EventCount):
        self._EventCount = EventCount

    @property
    def FoundTime(self):
        return self._FoundTime

    @FoundTime.setter
    def FoundTime(self, FoundTime):
        self._FoundTime = FoundTime

    @property
    def LatestFoundTime(self):
        return self._LatestFoundTime

    @LatestFoundTime.setter
    def LatestFoundTime(self, LatestFoundTime):
        self._LatestFoundTime = LatestFoundTime

    @property
    def ContainerID(self):
        return self._ContainerID

    @ContainerID.setter
    def ContainerID(self, ContainerID):
        self._ContainerID = ContainerID

    @property
    def ContainerName(self):
        return self._ContainerName

    @ContainerName.setter
    def ContainerName(self, ContainerName):
        self._ContainerName = ContainerName

    @property
    def ContainerNetStatus(self):
        return self._ContainerNetStatus

    @ContainerNetStatus.setter
    def ContainerNetStatus(self, ContainerNetStatus):
        self._ContainerNetStatus = ContainerNetStatus

    @property
    def ContainerStatus(self):
        return self._ContainerStatus

    @ContainerStatus.setter
    def ContainerStatus(self, ContainerStatus):
        self._ContainerStatus = ContainerStatus

    @property
    def ContainerNetSubStatus(self):
        return self._ContainerNetSubStatus

    @ContainerNetSubStatus.setter
    def ContainerNetSubStatus(self, ContainerNetSubStatus):
        self._ContainerNetSubStatus = ContainerNetSubStatus

    @property
    def ContainerIsolateOperationSrc(self):
        return self._ContainerIsolateOperationSrc

    @ContainerIsolateOperationSrc.setter
    def ContainerIsolateOperationSrc(self, ContainerIsolateOperationSrc):
        self._ContainerIsolateOperationSrc = ContainerIsolateOperationSrc

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def ImageName(self):
        return self._ImageName

    @ImageName.setter
    def ImageName(self, ImageName):
        self._ImageName = ImageName

    @property
    def HostName(self):
        return self._HostName

    @HostName.setter
    def HostName(self, HostName):
        self._HostName = HostName

    @property
    def HostIP(self):
        return self._HostIP

    @HostIP.setter
    def HostIP(self, HostIP):
        self._HostIP = HostIP

    @property
    def PublicIP(self):
        return self._PublicIP

    @PublicIP.setter
    def PublicIP(self, PublicIP):
        self._PublicIP = PublicIP

    @property
    def PodName(self):
        return self._PodName

    @PodName.setter
    def PodName(self, PodName):
        self._PodName = PodName

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Solution(self):
        return self._Solution

    @Solution.setter
    def Solution(self, Solution):
        self._Solution = Solution

    @property
    def Reference(self):
        return self._Reference

    @Reference.setter
    def Reference(self, Reference):
        self._Reference = Reference

    @property
    def Address(self):
        return self._Address

    @Address.setter
    def Address(self, Address):
        self._Address = Address

    @property
    def City(self):
        return self._City

    @City.setter
    def City(self, City):
        self._City = City

    @property
    def MatchRuleType(self):
        return self._MatchRuleType

    @MatchRuleType.setter
    def MatchRuleType(self, MatchRuleType):
        self._MatchRuleType = MatchRuleType

    @property
    def FeatureLabel(self):
        return self._FeatureLabel

    @FeatureLabel.setter
    def FeatureLabel(self, FeatureLabel):
        self._FeatureLabel = FeatureLabel

    @property
    def ProcessAuthority(self):
        return self._ProcessAuthority

    @ProcessAuthority.setter
    def ProcessAuthority(self, ProcessAuthority):
        self._ProcessAuthority = ProcessAuthority

    @property
    def ProcessMd5(self):
        return self._ProcessMd5

    @ProcessMd5.setter
    def ProcessMd5(self, ProcessMd5):
        self._ProcessMd5 = ProcessMd5

    @property
    def ProcessStartUser(self):
        return self._ProcessStartUser

    @ProcessStartUser.setter
    def ProcessStartUser(self, ProcessStartUser):
        self._ProcessStartUser = ProcessStartUser

    @property
    def ProcessUserGroup(self):
        return self._ProcessUserGroup

    @ProcessUserGroup.setter
    def ProcessUserGroup(self, ProcessUserGroup):
        self._ProcessUserGroup = ProcessUserGroup

    @property
    def ProcessPath(self):
        return self._ProcessPath

    @ProcessPath.setter
    def ProcessPath(self, ProcessPath):
        self._ProcessPath = ProcessPath

    @property
    def ProcessTree(self):
        return self._ProcessTree

    @ProcessTree.setter
    def ProcessTree(self, ProcessTree):
        self._ProcessTree = ProcessTree

    @property
    def ProcessParam(self):
        return self._ProcessParam

    @ProcessParam.setter
    def ProcessParam(self, ProcessParam):
        self._ProcessParam = ProcessParam

    @property
    def ParentProcessStartUser(self):
        return self._ParentProcessStartUser

    @ParentProcessStartUser.setter
    def ParentProcessStartUser(self, ParentProcessStartUser):
        self._ParentProcessStartUser = ParentProcessStartUser

    @property
    def ParentProcessUserGroup(self):
        return self._ParentProcessUserGroup

    @ParentProcessUserGroup.setter
    def ParentProcessUserGroup(self, ParentProcessUserGroup):
        self._ParentProcessUserGroup = ParentProcessUserGroup

    @property
    def ParentProcessPath(self):
        return self._ParentProcessPath

    @ParentProcessPath.setter
    def ParentProcessPath(self, ParentProcessPath):
        self._ParentProcessPath = ParentProcessPath

    @property
    def ParentProcessParam(self):
        return self._ParentProcessParam

    @ParentProcessParam.setter
    def ParentProcessParam(self, ParentProcessParam):
        self._ParentProcessParam = ParentProcessParam

    @property
    def AncestorProcessStartUser(self):
        return self._AncestorProcessStartUser

    @AncestorProcessStartUser.setter
    def AncestorProcessStartUser(self, AncestorProcessStartUser):
        self._AncestorProcessStartUser = AncestorProcessStartUser

    @property
    def AncestorProcessUserGroup(self):
        return self._AncestorProcessUserGroup

    @AncestorProcessUserGroup.setter
    def AncestorProcessUserGroup(self, AncestorProcessUserGroup):
        self._AncestorProcessUserGroup = AncestorProcessUserGroup

    @property
    def AncestorProcessPath(self):
        return self._AncestorProcessPath

    @AncestorProcessPath.setter
    def AncestorProcessPath(self, AncestorProcessPath):
        self._AncestorProcessPath = AncestorProcessPath

    @property
    def AncestorProcessParam(self):
        return self._AncestorProcessParam

    @AncestorProcessParam.setter
    def AncestorProcessParam(self, AncestorProcessParam):
        self._AncestorProcessParam = AncestorProcessParam

    @property
    def HostID(self):
        return self._HostID

    @HostID.setter
    def HostID(self, HostID):
        self._HostID = HostID

    @property
    def EventStatus(self):
        return self._EventStatus

    @EventStatus.setter
    def EventStatus(self, EventStatus):
        self._EventStatus = EventStatus

    @property
    def OperationTime(self):
        return self._OperationTime

    @OperationTime.setter
    def OperationTime(self, OperationTime):
        self._OperationTime = OperationTime

    @property
    def Remark(self):
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def NodeType(self):
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def NodeName(self):
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def NodeSubNetID(self):
        return self._NodeSubNetID

    @NodeSubNetID.setter
    def NodeSubNetID(self, NodeSubNetID):
        self._NodeSubNetID = NodeSubNetID

    @property
    def NodeSubNetName(self):
        return self._NodeSubNetName

    @NodeSubNetName.setter
    def NodeSubNetName(self, NodeSubNetName):
        self._NodeSubNetName = NodeSubNetName

    @property
    def NodeSubNetCIDR(self):
        return self._NodeSubNetCIDR

    @NodeSubNetCIDR.setter
    def NodeSubNetCIDR(self, NodeSubNetCIDR):
        self._NodeSubNetCIDR = NodeSubNetCIDR

    @property
    def ClusterID(self):
        return self._ClusterID

    @ClusterID.setter
    def ClusterID(self, ClusterID):
        self._ClusterID = ClusterID

    @property
    def PodIP(self):
        return self._PodIP

    @PodIP.setter
    def PodIP(self, PodIP):
        self._PodIP = PodIP

    @property
    def PodStatus(self):
        return self._PodStatus

    @PodStatus.setter
    def PodStatus(self, PodStatus):
        self._PodStatus = PodStatus

    @property
    def NodeUniqueID(self):
        return self._NodeUniqueID

    @NodeUniqueID.setter
    def NodeUniqueID(self, NodeUniqueID):
        self._NodeUniqueID = NodeUniqueID

    @property
    def NodeID(self):
        return self._NodeID

    @NodeID.setter
    def NodeID(self, NodeID):
        self._NodeID = NodeID

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def Namespace(self):
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace

    @property
    def WorkloadType(self):
        return self._WorkloadType

    @WorkloadType.setter
    def WorkloadType(self, WorkloadType):
        self._WorkloadType = WorkloadType

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._EventID = params.get("EventID")
        self._EventType = params.get("EventType")
        self._EventCount = params.get("EventCount")
        self._FoundTime = params.get("FoundTime")
        self._LatestFoundTime = params.get("LatestFoundTime")
        self._ContainerID = params.get("ContainerID")
        self._ContainerName = params.get("ContainerName")
        self._ContainerNetStatus = params.get("ContainerNetStatus")
        self._ContainerStatus = params.get("ContainerStatus")
        self._ContainerNetSubStatus = params.get("ContainerNetSubStatus")
        self._ContainerIsolateOperationSrc = params.get("ContainerIsolateOperationSrc")
        self._ImageID = params.get("ImageID")
        self._ImageName = params.get("ImageName")
        self._HostName = params.get("HostName")
        self._HostIP = params.get("HostIP")
        self._PublicIP = params.get("PublicIP")
        self._PodName = params.get("PodName")
        self._Description = params.get("Description")
        self._Solution = params.get("Solution")
        self._Reference = params.get("Reference")
        self._Address = params.get("Address")
        self._City = params.get("City")
        self._MatchRuleType = params.get("MatchRuleType")
        self._FeatureLabel = params.get("FeatureLabel")
        self._ProcessAuthority = params.get("ProcessAuthority")
        self._ProcessMd5 = params.get("ProcessMd5")
        self._ProcessStartUser = params.get("ProcessStartUser")
        self._ProcessUserGroup = params.get("ProcessUserGroup")
        self._ProcessPath = params.get("ProcessPath")
        self._ProcessTree = params.get("ProcessTree")
        self._ProcessParam = params.get("ProcessParam")
        self._ParentProcessStartUser = params.get("ParentProcessStartUser")
        self._ParentProcessUserGroup = params.get("ParentProcessUserGroup")
        self._ParentProcessPath = params.get("ParentProcessPath")
        self._ParentProcessParam = params.get("ParentProcessParam")
        self._AncestorProcessStartUser = params.get("AncestorProcessStartUser")
        self._AncestorProcessUserGroup = params.get("AncestorProcessUserGroup")
        self._AncestorProcessPath = params.get("AncestorProcessPath")
        self._AncestorProcessParam = params.get("AncestorProcessParam")
        self._HostID = params.get("HostID")
        self._EventStatus = params.get("EventStatus")
        self._OperationTime = params.get("OperationTime")
        self._Remark = params.get("Remark")
        self._NodeType = params.get("NodeType")
        self._NodeName = params.get("NodeName")
        self._NodeSubNetID = params.get("NodeSubNetID")
        self._NodeSubNetName = params.get("NodeSubNetName")
        self._NodeSubNetCIDR = params.get("NodeSubNetCIDR")
        self._ClusterID = params.get("ClusterID")
        self._PodIP = params.get("PodIP")
        self._PodStatus = params.get("PodStatus")
        self._NodeUniqueID = params.get("NodeUniqueID")
        self._NodeID = params.get("NodeID")
        self._ClusterName = params.get("ClusterName")
        self._Namespace = params.get("Namespace")
        self._WorkloadType = params.get("WorkloadType")
        self._RequestId = params.get("RequestId")


class DescribeRiskDnsListRequest(AbstractModel):
    """DescribeRiskDnsList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>EventStatus- String - 是否必填：否 - 事件状态，待处理：EVENT_UNDEAL，EVENT_DEALED：已处理，已忽略：EVENT_IGNORE， EVENT_ADD_WHITE：已加白</li>
<li>ContainerStatus- String - 是否必填：否 - 容器运行状态筛选，已创建：CREATED,正常运行：RUNNING, 暂定运行：PAUSED, 停止运行：	STOPPED，重启中：RESTARTING, 迁移中：REMOVING, 销毁：DESTROYED </li>
<li>ContainerNetStatus- String -是否必填: 否 -  容器网络状态筛选 未隔离：NORMAL，已隔离：ISOLATED，隔离失败：ISOLATE_FAILED，解除隔离失败：RESTORE_FAILED，解除隔离中：RESTORING，隔离中：ISOLATING</li>
<li>EventType - String -是否必填: 否 -  事件类型，恶意域名请求：DOMAIN，恶意IP请求：IP</li>
<li>TimeRange- String -是否必填: 否 -  时间范围，第一个值表示开始时间，第二个值表示结束时间 </li>
<li>RiskDns- string - 是否必填：否 - 恶意域名。</li>
<li>RiskIP- string - 是否必填：否 - 恶意IP。</li>
<li>ContainerName- string - 是否必填：否 - 容器名称。</li>
<li>ContainerID- string - 是否必填：否 - 容器ID。</li>
<li>ImageName- string - 是否必填：否 - 镜像名称。</li>
<li>ImageID- string - 是否必填：否 - 镜像ID。</li>
<li>HostName- string - 是否必填：否 - 主机名称。</li>
<li>HostIP- string - 是否必填：否 - 内网IP。</li>
<li>PublicIP- string - 是否必填：否 - 外网IP。</li>
        :type Filters: list of RunTimeFilters
        :param _Order: 排序方式：asc/desc
        :type Order: str
        :param _By: 排序字段：告警数量：EventCount，最近生成时间：LatestFoundTime
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRiskDnsListResponse(AbstractModel):
    """DescribeRiskDnsList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 恶意请求事件列表
        :type List: list of RiskDnsEventInfo
        :param _TotalCount: 总数量
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = RiskDnsEventInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeRiskListRequest(AbstractModel):
    """DescribeRiskList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 要查询的集群ID，如果不指定，则查询用户所有的风险项
        :type ClusterId: str
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 每次查询的最大记录数量
        :type Limit: int
        :param _Filters: Name - String
Name 可取值：RiskLevel风险等级, RiskTarget检查对象，风险对象,RiskType风险类别,RiskAttribute检测项所属的风险类型,Name
        :type Filters: list of ComplianceFilters
        :param _By: 排序字段
        :type By: str
        :param _Order: 排序方式 asc,desc
        :type Order: str
        """
        self._ClusterId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRiskListResponse(AbstractModel):
    """DescribeRiskList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterRiskItems: 风险详情数组
        :type ClusterRiskItems: list of ClusterRiskItem
        :param _TotalCount: 风险项的总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ClusterRiskItems = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def ClusterRiskItems(self):
        return self._ClusterRiskItems

    @ClusterRiskItems.setter
    def ClusterRiskItems(self, ClusterRiskItems):
        self._ClusterRiskItems = ClusterRiskItems

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ClusterRiskItems") is not None:
            self._ClusterRiskItems = []
            for item in params.get("ClusterRiskItems"):
                obj = ClusterRiskItem()
                obj._deserialize(item)
                self._ClusterRiskItems.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeRiskSyscallDetailRequest(AbstractModel):
    """DescribeRiskSyscallDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventId: 事件唯一id
        :type EventId: str
        """
        self._EventId = None

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId


    def _deserialize(self, params):
        self._EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRiskSyscallDetailResponse(AbstractModel):
    """DescribeRiskSyscallDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _EventBaseInfo: 事件基本信息
        :type EventBaseInfo: :class:`tencentcloud.tcss.v20201101.models.RunTimeEventBaseInfo`
        :param _ProcessInfo: 进程信息
        :type ProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessDetailInfo`
        :param _ParentProcessInfo: 父进程信息
        :type ParentProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessDetailBaseInfo`
        :param _EventDetail: 事件描述
        :type EventDetail: :class:`tencentcloud.tcss.v20201101.models.RiskSyscallEventDescription`
        :param _AncestorProcessInfo: 祖先进程信息
注意：此字段可能返回 null，表示取不到有效值。
        :type AncestorProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessBaseInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._EventBaseInfo = None
        self._ProcessInfo = None
        self._ParentProcessInfo = None
        self._EventDetail = None
        self._AncestorProcessInfo = None
        self._RequestId = None

    @property
    def EventBaseInfo(self):
        return self._EventBaseInfo

    @EventBaseInfo.setter
    def EventBaseInfo(self, EventBaseInfo):
        self._EventBaseInfo = EventBaseInfo

    @property
    def ProcessInfo(self):
        return self._ProcessInfo

    @ProcessInfo.setter
    def ProcessInfo(self, ProcessInfo):
        self._ProcessInfo = ProcessInfo

    @property
    def ParentProcessInfo(self):
        return self._ParentProcessInfo

    @ParentProcessInfo.setter
    def ParentProcessInfo(self, ParentProcessInfo):
        self._ParentProcessInfo = ParentProcessInfo

    @property
    def EventDetail(self):
        return self._EventDetail

    @EventDetail.setter
    def EventDetail(self, EventDetail):
        self._EventDetail = EventDetail

    @property
    def AncestorProcessInfo(self):
        return self._AncestorProcessInfo

    @AncestorProcessInfo.setter
    def AncestorProcessInfo(self, AncestorProcessInfo):
        self._AncestorProcessInfo = AncestorProcessInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EventBaseInfo") is not None:
            self._EventBaseInfo = RunTimeEventBaseInfo()
            self._EventBaseInfo._deserialize(params.get("EventBaseInfo"))
        if params.get("ProcessInfo") is not None:
            self._ProcessInfo = ProcessDetailInfo()
            self._ProcessInfo._deserialize(params.get("ProcessInfo"))
        if params.get("ParentProcessInfo") is not None:
            self._ParentProcessInfo = ProcessDetailBaseInfo()
            self._ParentProcessInfo._deserialize(params.get("ParentProcessInfo"))
        if params.get("EventDetail") is not None:
            self._EventDetail = RiskSyscallEventDescription()
            self._EventDetail._deserialize(params.get("EventDetail"))
        if params.get("AncestorProcessInfo") is not None:
            self._AncestorProcessInfo = ProcessBaseInfo()
            self._AncestorProcessInfo._deserialize(params.get("AncestorProcessInfo"))
        self._RequestId = params.get("RequestId")


class DescribeRiskSyscallEventsExportRequest(AbstractModel):
    """DescribeRiskSyscallEventsExport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤参数,"Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param _Order: 升序降序,asc desc
        :type Order: str
        :param _By: 排序字段
        :type By: str
        :param _ExportField: 导出字段
        :type ExportField: list of str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None
        self._ExportField = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        self._ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRiskSyscallEventsExportResponse(AbstractModel):
    """DescribeRiskSyscallEventsExport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: Excel下载地址
注意：此字段可能返回 null，表示取不到有效值。
        :type DownloadUrl: str
        :param _JobId: 任务Id
注意：此字段可能返回 null，表示取不到有效值。
        :type JobId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._JobId = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class DescribeRiskSyscallEventsRequest(AbstractModel):
    """DescribeRiskSyscallEvents请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤参数,"Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param _Order: 升序降序,asc desc
        :type Order: str
        :param _By: 排序字段
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRiskSyscallEventsResponse(AbstractModel):
    """DescribeRiskSyscallEvents返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 事件总数量
        :type TotalCount: int
        :param _EventSet: 高危系统调用数组
        :type EventSet: list of RiskSyscallEventInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._EventSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def EventSet(self):
        return self._EventSet

    @EventSet.setter
    def EventSet(self, EventSet):
        self._EventSet = EventSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("EventSet") is not None:
            self._EventSet = []
            for item in params.get("EventSet"):
                obj = RiskSyscallEventInfo()
                obj._deserialize(item)
                self._EventSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRiskSyscallNamesRequest(AbstractModel):
    """DescribeRiskSyscallNames请求参数结构体

    """


class DescribeRiskSyscallNamesResponse(AbstractModel):
    """DescribeRiskSyscallNames返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 事件总数量
        :type TotalCount: int
        :param _SyscallNames: 系统调用名称列表
        :type SyscallNames: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._SyscallNames = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SyscallNames(self):
        return self._SyscallNames

    @SyscallNames.setter
    def SyscallNames(self, SyscallNames):
        self._SyscallNames = SyscallNames

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._SyscallNames = params.get("SyscallNames")
        self._RequestId = params.get("RequestId")


class DescribeRiskSyscallWhiteListDetailRequest(AbstractModel):
    """DescribeRiskSyscallWhiteListDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WhiteListId: 白名单id
        :type WhiteListId: str
        """
        self._WhiteListId = None

    @property
    def WhiteListId(self):
        return self._WhiteListId

    @WhiteListId.setter
    def WhiteListId(self, WhiteListId):
        self._WhiteListId = WhiteListId


    def _deserialize(self, params):
        self._WhiteListId = params.get("WhiteListId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRiskSyscallWhiteListDetailResponse(AbstractModel):
    """DescribeRiskSyscallWhiteListDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _WhiteListDetailInfo: 白名单基本信息
        :type WhiteListDetailInfo: :class:`tencentcloud.tcss.v20201101.models.RiskSyscallWhiteListInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._WhiteListDetailInfo = None
        self._RequestId = None

    @property
    def WhiteListDetailInfo(self):
        return self._WhiteListDetailInfo

    @WhiteListDetailInfo.setter
    def WhiteListDetailInfo(self, WhiteListDetailInfo):
        self._WhiteListDetailInfo = WhiteListDetailInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("WhiteListDetailInfo") is not None:
            self._WhiteListDetailInfo = RiskSyscallWhiteListInfo()
            self._WhiteListDetailInfo._deserialize(params.get("WhiteListDetailInfo"))
        self._RequestId = params.get("RequestId")


class DescribeRiskSyscallWhiteListsRequest(AbstractModel):
    """DescribeRiskSyscallWhiteLists请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤参数,"Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param _Order: 升序降序,asc desc
        :type Order: str
        :param _By: 排序字段
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRiskSyscallWhiteListsResponse(AbstractModel):
    """DescribeRiskSyscallWhiteLists返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 事件总数量
        :type TotalCount: int
        :param _WhiteListSet: 白名单信息列表
        :type WhiteListSet: list of RiskSyscallWhiteListBaseInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._WhiteListSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def WhiteListSet(self):
        return self._WhiteListSet

    @WhiteListSet.setter
    def WhiteListSet(self, WhiteListSet):
        self._WhiteListSet = WhiteListSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("WhiteListSet") is not None:
            self._WhiteListSet = []
            for item in params.get("WhiteListSet"):
                obj = RiskSyscallWhiteListBaseInfo()
                obj._deserialize(item)
                self._WhiteListSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeScanIgnoreVulListRequest(AbstractModel):
    """DescribeScanIgnoreVulList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>CVEID- string - 是否必填：否 - CVE编号</li>
<li>VulName- string - 是否必填：否 - 漏洞名称</li>
        :type Filters: list of RunTimeFilters
        :param _Order: 排序方式:DESC,ACS
        :type Order: str
        :param _By: 排序字段 UpdateTime
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeScanIgnoreVulListResponse(AbstractModel):
    """DescribeScanIgnoreVulList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总是
        :type TotalCount: int
        :param _List: 漏洞列表
        :type List: list of ScanIgnoreVul
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ScanIgnoreVul()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSearchExportListRequest(AbstractModel):
    """DescribeSearchExportList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Query: ES查询条件JSON
        :type Query: str
        """
        self._Query = None

    @property
    def Query(self):
        return self._Query

    @Query.setter
    def Query(self, Query):
        self._Query = Query


    def _deserialize(self, params):
        self._Query = params.get("Query")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSearchExportListResponse(AbstractModel):
    """DescribeSearchExportList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _JobId: 导出任务ID，前端拿着任务ID查询任务进度
        :type JobId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class DescribeSearchLogsRequest(AbstractModel):
    """DescribeSearchLogs请求参数结构体

    """


class DescribeSearchLogsResponse(AbstractModel):
    """DescribeSearchLogs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 历史搜索记录 保留最新的10条
        :type Data: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeSearchTemplatesRequest(AbstractModel):
    """DescribeSearchTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 返回数量，默认为10，最大值为100。
        :type Limit: int
        """
        self._Offset = None
        self._Limit = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSearchTemplatesResponse(AbstractModel):
    """DescribeSearchTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数
        :type TotalCount: int
        :param _List: 模板列表
        :type List: list of SearchTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = SearchTemplate()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSecEventsTendencyRequest(AbstractModel):
    """DescribeSecEventsTendency请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        """
        self._StartTime = None
        self._EndTime = None

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecEventsTendencyResponse(AbstractModel):
    """DescribeSecEventsTendency返回参数结构体

    """

    def __init__(self):
        r"""
        :param _EventTendencySet: 运行时安全事件趋势信息列表
        :type EventTendencySet: list of SecTendencyEventInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._EventTendencySet = None
        self._RequestId = None

    @property
    def EventTendencySet(self):
        return self._EventTendencySet

    @EventTendencySet.setter
    def EventTendencySet(self, EventTendencySet):
        self._EventTendencySet = EventTendencySet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EventTendencySet") is not None:
            self._EventTendencySet = []
            for item in params.get("EventTendencySet"):
                obj = SecTendencyEventInfo()
                obj._deserialize(item)
                self._EventTendencySet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSecLogAlertMsgRequest(AbstractModel):
    """DescribeSecLogAlertMsg请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 告警类型
日志储量告警: log_reserve_full
日志存储时间告警: log_save_day_limit
kafka实例/公网域名不可用: kafka_instance_domain_unavailable
kafka 用户名密码错误: kafka_user_passwd_wrong
kafka后台报错字段: kafka_field_wrong
        :type Type: list of str
        """
        self._Type = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecLogAlertMsgResponse(AbstractModel):
    """DescribeSecLogAlertMsg返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 告警消息队列
        :type List: list of SecLogAlertMsgInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = SecLogAlertMsgInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSecLogCleanSettingInfoRequest(AbstractModel):
    """DescribeSecLogCleanSettingInfo请求参数结构体

    """


class DescribeSecLogCleanSettingInfoResponse(AbstractModel):
    """DescribeSecLogCleanSettingInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ReservesLimit: 触发清理的储量底线
        :type ReservesLimit: int
        :param _ReservesDeadline: 清理停止时的储量截至线
        :type ReservesDeadline: int
        :param _DayLimit: 触发清理的存储天数
        :type DayLimit: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ReservesLimit = None
        self._ReservesDeadline = None
        self._DayLimit = None
        self._RequestId = None

    @property
    def ReservesLimit(self):
        return self._ReservesLimit

    @ReservesLimit.setter
    def ReservesLimit(self, ReservesLimit):
        self._ReservesLimit = ReservesLimit

    @property
    def ReservesDeadline(self):
        return self._ReservesDeadline

    @ReservesDeadline.setter
    def ReservesDeadline(self, ReservesDeadline):
        self._ReservesDeadline = ReservesDeadline

    @property
    def DayLimit(self):
        return self._DayLimit

    @DayLimit.setter
    def DayLimit(self, DayLimit):
        self._DayLimit = DayLimit

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ReservesLimit = params.get("ReservesLimit")
        self._ReservesDeadline = params.get("ReservesDeadline")
        self._DayLimit = params.get("DayLimit")
        self._RequestId = params.get("RequestId")


class DescribeSecLogDeliveryClsOptionsRequest(AbstractModel):
    """DescribeSecLogDeliveryClsOptions请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClsRegion: 地域
        :type ClsRegion: str
        """
        self._ClsRegion = None

    @property
    def ClsRegion(self):
        return self._ClsRegion

    @ClsRegion.setter
    def ClsRegion(self, ClsRegion):
        self._ClsRegion = ClsRegion


    def _deserialize(self, params):
        self._ClsRegion = params.get("ClsRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecLogDeliveryClsOptionsResponse(AbstractModel):
    """DescribeSecLogDeliveryClsOptions返回参数结构体

    """

    def __init__(self):
        r"""
        :param _LogSetList: cls可选日志集合列表(仅当入参ClsRegion不为空时返回)
        :type LogSetList: list of ClsLogsetInfo
        :param _RegionList: 可选地域列表(仅当入参ClsRegion为空时返回)
        :type RegionList: list of RegionInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._LogSetList = None
        self._RegionList = None
        self._RequestId = None

    @property
    def LogSetList(self):
        return self._LogSetList

    @LogSetList.setter
    def LogSetList(self, LogSetList):
        self._LogSetList = LogSetList

    @property
    def RegionList(self):
        return self._RegionList

    @RegionList.setter
    def RegionList(self, RegionList):
        self._RegionList = RegionList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("LogSetList") is not None:
            self._LogSetList = []
            for item in params.get("LogSetList"):
                obj = ClsLogsetInfo()
                obj._deserialize(item)
                self._LogSetList.append(obj)
        if params.get("RegionList") is not None:
            self._RegionList = []
            for item in params.get("RegionList"):
                obj = RegionInfo()
                obj._deserialize(item)
                self._RegionList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSecLogDeliveryClsSettingRequest(AbstractModel):
    """DescribeSecLogDeliveryClsSetting请求参数结构体

    """


class DescribeSecLogDeliveryClsSettingResponse(AbstractModel):
    """DescribeSecLogDeliveryClsSetting返回参数结构体

    """

    def __init__(self):
        r"""
        :param _LogTypeList: 日志类型列表
        :type LogTypeList: list of SecLogDeliveryClsSettingInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._LogTypeList = None
        self._RequestId = None

    @property
    def LogTypeList(self):
        return self._LogTypeList

    @LogTypeList.setter
    def LogTypeList(self, LogTypeList):
        self._LogTypeList = LogTypeList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("LogTypeList") is not None:
            self._LogTypeList = []
            for item in params.get("LogTypeList"):
                obj = SecLogDeliveryClsSettingInfo()
                obj._deserialize(item)
                self._LogTypeList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSecLogDeliveryKafkaOptionsRequest(AbstractModel):
    """DescribeSecLogDeliveryKafkaOptions请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RegionID: 地域，若为空则返回所有可选地域
        :type RegionID: str
        """
        self._RegionID = None

    @property
    def RegionID(self):
        return self._RegionID

    @RegionID.setter
    def RegionID(self, RegionID):
        self._RegionID = RegionID


    def _deserialize(self, params):
        self._RegionID = params.get("RegionID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecLogDeliveryKafkaOptionsResponse(AbstractModel):
    """DescribeSecLogDeliveryKafkaOptions返回参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceList: 实例列表
        :type InstanceList: list of CKafkaInstanceInfo
        :param _RegionList: 地域列表
        :type RegionList: list of RegionInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._InstanceList = None
        self._RegionList = None
        self._RequestId = None

    @property
    def InstanceList(self):
        return self._InstanceList

    @InstanceList.setter
    def InstanceList(self, InstanceList):
        self._InstanceList = InstanceList

    @property
    def RegionList(self):
        return self._RegionList

    @RegionList.setter
    def RegionList(self, RegionList):
        self._RegionList = RegionList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("InstanceList") is not None:
            self._InstanceList = []
            for item in params.get("InstanceList"):
                obj = CKafkaInstanceInfo()
                obj._deserialize(item)
                self._InstanceList.append(obj)
        if params.get("RegionList") is not None:
            self._RegionList = []
            for item in params.get("RegionList"):
                obj = RegionInfo()
                obj._deserialize(item)
                self._RegionList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSecLogDeliveryKafkaSettingRequest(AbstractModel):
    """DescribeSecLogDeliveryKafkaSetting请求参数结构体

    """


class DescribeSecLogDeliveryKafkaSettingResponse(AbstractModel):
    """DescribeSecLogDeliveryKafkaSetting返回参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceID: 消息队列实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceID: str
        :param _InstanceName: 消息队列实例名称
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceName: str
        :param _Domain: 域名
注意：此字段可能返回 null，表示取不到有效值。
        :type Domain: str
        :param _LogTypeList: 日志类型队列
注意：此字段可能返回 null，表示取不到有效值。
        :type LogTypeList: list of SecLogDeliveryKafkaSettingInfo
        :param _User: 用户名
注意：此字段可能返回 null，表示取不到有效值。
        :type User: str
        :param _RegionID: 地域ID
注意：此字段可能返回 null，表示取不到有效值。
        :type RegionID: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._InstanceID = None
        self._InstanceName = None
        self._Domain = None
        self._LogTypeList = None
        self._User = None
        self._RegionID = None
        self._RequestId = None

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def InstanceName(self):
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def LogTypeList(self):
        return self._LogTypeList

    @LogTypeList.setter
    def LogTypeList(self, LogTypeList):
        self._LogTypeList = LogTypeList

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def RegionID(self):
        return self._RegionID

    @RegionID.setter
    def RegionID(self, RegionID):
        self._RegionID = RegionID

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._InstanceID = params.get("InstanceID")
        self._InstanceName = params.get("InstanceName")
        self._Domain = params.get("Domain")
        if params.get("LogTypeList") is not None:
            self._LogTypeList = []
            for item in params.get("LogTypeList"):
                obj = SecLogDeliveryKafkaSettingInfo()
                obj._deserialize(item)
                self._LogTypeList.append(obj)
        self._User = params.get("User")
        self._RegionID = params.get("RegionID")
        self._RequestId = params.get("RequestId")


class DescribeSecLogJoinObjectListRequest(AbstractModel):
    """DescribeSecLogJoinObjectList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _LogType: 日志类型
bash: "container_bash",
启动: "container_launch",
"k8s": "k8s_api"
        :type LogType: str
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Status- String - 是否必填：否 - 主机状态 </li>
<li>HostIP- String - 是否必填：否 - 主机内网IP </li>
<li>PublicIP- String - 是否必填：否 - 主机外网IP </li>
<li>HostName- String - 是否必填：否 - 主机名称 </li>
        :type Filters: list of RunTimeFilters
        :param _By: 排序字段
        :type By: str
        :param _Order: 排序方式
        :type Order: str
        """
        self._LogType = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def LogType(self):
        return self._LogType

    @LogType.setter
    def LogType(self, LogType):
        self._LogType = LogType

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._LogType = params.get("LogType")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecLogJoinObjectListResponse(AbstractModel):
    """DescribeSecLogJoinObjectList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数
        :type TotalCount: int
        :param _List: 接入对象列表
        :type List: list of SecLogJoinObjectInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = SecLogJoinObjectInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSecLogJoinTypeListRequest(AbstractModel):
    """DescribeSecLogJoinTypeList请求参数结构体

    """


class DescribeSecLogJoinTypeListResponse(AbstractModel):
    """DescribeSecLogJoinTypeList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 接入日志列表
        :type List: list of SecLogJoinInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = SecLogJoinInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSecLogKafkaUINRequest(AbstractModel):
    """DescribeSecLogKafkaUIN请求参数结构体

    """


class DescribeSecLogKafkaUINResponse(AbstractModel):
    """DescribeSecLogKafkaUIN返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DstUIN: 目标UIN
注意：此字段可能返回 null，表示取不到有效值。
        :type DstUIN: str
        :param _Status: 授权状态
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DstUIN = None
        self._Status = None
        self._RequestId = None

    @property
    def DstUIN(self):
        return self._DstUIN

    @DstUIN.setter
    def DstUIN(self, DstUIN):
        self._DstUIN = DstUIN

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DstUIN = params.get("DstUIN")
        self._Status = params.get("Status")
        self._RequestId = params.get("RequestId")


class DescribeSecLogVasInfoRequest(AbstractModel):
    """DescribeSecLogVasInfo请求参数结构体

    """


class DescribeSecLogVasInfoResponse(AbstractModel):
    """DescribeSecLogVasInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _BuyStatus: 购买状态
待购: Pending
已购: Normal
隔离: Isolate
        :type BuyStatus: str
        :param _LogSaveMonth: 存储时长(月)
        :type LogSaveMonth: int
        :param _StartTime: 起始时间
        :type StartTime: str
        :param _EndTime: 截止时间
        :type EndTime: str
        :param _LogCapacity: 存储容量(GB)
        :type LogCapacity: int
        :param _ResourceID: 资源ID
        :type ResourceID: str
        :param _IsPurchased: 是否曾经购买过(false:未曾 true:曾经购买过)
        :type IsPurchased: bool
        :param _TrialCapacity: 试用存储容量(GB)
        :type TrialCapacity: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._BuyStatus = None
        self._LogSaveMonth = None
        self._StartTime = None
        self._EndTime = None
        self._LogCapacity = None
        self._ResourceID = None
        self._IsPurchased = None
        self._TrialCapacity = None
        self._RequestId = None

    @property
    def BuyStatus(self):
        return self._BuyStatus

    @BuyStatus.setter
    def BuyStatus(self, BuyStatus):
        self._BuyStatus = BuyStatus

    @property
    def LogSaveMonth(self):
        return self._LogSaveMonth

    @LogSaveMonth.setter
    def LogSaveMonth(self, LogSaveMonth):
        self._LogSaveMonth = LogSaveMonth

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def LogCapacity(self):
        return self._LogCapacity

    @LogCapacity.setter
    def LogCapacity(self, LogCapacity):
        self._LogCapacity = LogCapacity

    @property
    def ResourceID(self):
        return self._ResourceID

    @ResourceID.setter
    def ResourceID(self, ResourceID):
        self._ResourceID = ResourceID

    @property
    def IsPurchased(self):
        return self._IsPurchased

    @IsPurchased.setter
    def IsPurchased(self, IsPurchased):
        self._IsPurchased = IsPurchased

    @property
    def TrialCapacity(self):
        return self._TrialCapacity

    @TrialCapacity.setter
    def TrialCapacity(self, TrialCapacity):
        self._TrialCapacity = TrialCapacity

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._BuyStatus = params.get("BuyStatus")
        self._LogSaveMonth = params.get("LogSaveMonth")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._LogCapacity = params.get("LogCapacity")
        self._ResourceID = params.get("ResourceID")
        self._IsPurchased = params.get("IsPurchased")
        self._TrialCapacity = params.get("TrialCapacity")
        self._RequestId = params.get("RequestId")


class DescribeSuperNodePodListRequest(AbstractModel):
    """DescribeSuperNodePodList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li>NodeUniqueID- String - 是否必填：否 - 节点唯一id </li>
<li>PodName- String - 是否必填：否 - Pod示例名称 </li>
<li>PodIP- String - 是否必填：否 - POD IP </li>
<li>Namespace- String - 是否必填：否 - 命名空间 </li>
<li>Deployment- String - 是否必填：否 - 所属工作负载 </li>
<li>Status- String - 是否必填：否 - 状态 </li>

        :type Filters: list of RunTimeFilters
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _By: 排序字段
        :type By: str
        :param _Order: 排序方式 asc,desc
        :type Order: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._By = None
        self._Order = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSuperNodePodListResponse(AbstractModel):
    """DescribeSuperNodePodList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 列表
        :type List: list of SuperNodePodListItem
        :param _TotalCount: 总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = SuperNodePodListItem()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeSupportDefenceVulReq