from typing import Dict, List, Optional

from nebu import V1ResourceMeta, V1ResourceMetaRequest
from pydantic import BaseModel, Field


class V1LoraParams(BaseModel):
    """LoRA configuration parameters."""

    lora_rank: int = 8
    lora_alpha: int = 16
    lora_dropout: float = 0.1
    lora_target_modules: List[str] = Field(default_factory=list)


class V1AdapterRequest(BaseModel):
    """Request payload for creating an adapter."""

    metadata: V1ResourceMetaRequest
    uri: str
    base_model: str
    lora: Optional[V1LoraParams] = Field(default_factory=V1LoraParams)
    learning_rate: Optional[float] = None


class V1AdapterUpdateRequest(BaseModel):
    """Request payload for updating an adapter."""

    uri: Optional[str] = None
    epochs_trained: Optional[int] = None
    examples_trained: Optional[int] = None
    last_trained: Optional[int] = None
    labels: Optional[Dict[str, str]] = None
    learning_rate: Optional[float] = None
    lora: Optional[V1LoraParams] = None


class V1Adapter(BaseModel):
    """Response payload representing an adapter."""

    metadata: V1ResourceMeta
    uri: str
    base_model: str
    epochs_trained: int
    examples_trained: int
    last_trained: int
    lora: Optional[V1LoraParams] = None
    learning_rate: Optional[float] = None


class V1Adapters(BaseModel):
    """Response payload for a list of adapters."""

    adapters: List[V1Adapter]
