"""Type stubs for postal.utils.enum module."""

from typing import Any, Dict, Iterator, Optional, Union

class EnumValue:
    value: Any
    name: Optional[str]
    
    def __init__(self, value: Any, name: Optional[str] = None) -> None: ...
    def __hash__(self) -> int: ...
    def __lt__(self, other: Any) -> bool: ...
    def __gt__(self, other: Any) -> bool: ...  
    def __le__(self, other: Any) -> bool: ...
    def __ge__(self, other: Any) -> bool: ...
    def __ne__(self, other: Any) -> bool: ...
    def __eq__(self, other: Any) -> bool: ...
    def __unicode__(self) -> str: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...

class EnumMeta(type):
    registry: Dict[Any, EnumValue]
    name_registry: Dict[str, EnumValue]
    
    def __iter__(self) -> Iterator[EnumValue]: ...
    def __getitem__(self, key: Any) -> EnumValue: ...

class Enum(metaclass=EnumMeta):
    registry: Dict[Any, EnumValue]
    name_registry: Dict[str, EnumValue]
    
    @classmethod
    def from_id(cls, value: Any) -> EnumValue: ...
    
    @classmethod
    def from_string(cls, name: str) -> EnumValue: ...