# Guides

This section provides in-depth guides for working with Haiway's core concepts and patterns.

## Core Concepts

### [State Management](state.md)
Learn how to work with Haiway's immutable state system, including:
- Defining state classes with type validation
- Working with immutability and updates
- Using generic state types
- Path-based updates for nested structures
- Performance considerations

### [Functionalities](functionalities.md)
Understand Haiway's functional programming approach:
- Protocol-based function interfaces
- Dependency injection through context
- Factory patterns for implementations
- Organizing business logic functionally
- Complete example: Notes management system

### [Packages](packages.md)
Structure larger applications effectively:
- Module organization patterns
- Package boundaries and interfaces
- Composing functionalities
- Managing dependencies between packages

## Learning Path

1. **Start with State** - Understanding immutable state is fundamental to using Haiway effectively
2. **Learn Functionalities** - See how to organize business logic using functional patterns
3. **Scale with Packages** - Apply these concepts to structure larger applications
