# model settings
model = dict(type='ImageClassifier',
             backbone=dict(type='TNT',
                           arch='s',
                           img_size=224,
                           patch_size=16,
                           in_channels=3,
                           ffn_ratio=4,
                           qkv_bias=False,
                           drop_rate=0.,
                           attn_drop_rate=0.,
                           drop_path_rate=0.1,
                           first_stride=4,
                           num_fcs=2,
                           init_cfg=[
                               dict(type='TruncNormal',
                                    layer='Linear',
                                    std=.02),
                               dict(type='Constant',
                                    layer='LayerNorm',
                                    val=1.,
                                    bias=0.)
                           ]),
             neck=None,
             head=dict(type='LinearClsHead',
                       num_classes=1000,
                       in_channels=384,
                       loss=dict(type='LabelSmoothLoss',
                                 label_smooth_val=0.1,
                                 mode='original'),
                       topk=(1, 5),
                       init_cfg=dict(type='TruncNormal',
                                     layer='Linear',
                                     std=.02)))
