# VGG

> [Very Deep Convolutional Networks for Large-Scale Image Recognition](https://arxiv.org/abs/1409.1556)

<!-- [ALGORITHM] -->

## Abstract

In this work we investigate the effect of the convolutional network depth on its accuracy in the large-scale image recognition setting. Our main contribution is a thorough evaluation of networks of increasing depth using an architecture with very small (3x3) convolution filters, which shows that a significant improvement on the prior-art configurations can be achieved by pushing the depth to 16-19 weight layers. These findings were the basis of our ImageNet Challenge 2014 submission, where our team secured the first and the second places in the localisation and classification tracks respectively. We also show that our representations generalise well to other datasets, where they achieve state-of-the-art results. We have made our two best-performing ConvNet models publicly available to facilitate further research on the use of deep visual representations in computer vision.

<div align=center>
<img src="https://user-images.githubusercontent.com/26739999/142578905-9be586ec-f6fd-4bfb-bbba-432f599d3b9b.png" width="60%"/>
</div>

## How to use it?

<!-- [TABS-BEGIN] -->

**Predict image**

```python
from mmpretrain import inference_model

predict = inference_model('vgg11_8xb32_in1k', 'demo/bird.JPEG')
print(predict['pred_class'])
print(predict['pred_score'])
```

**Use the model**

```python
import torch
from mmpretrain import get_model

model = get_model('vgg11_8xb32_in1k', pretrained=True)
inputs = torch.rand(1, 3, 224, 224)
out = model(inputs)
print(type(out))
# To extract features.
feats = model.extract_feat(inputs)
print(type(feats))
```

**Train/Test Command**

Prepare your dataset according to the [docs](https://onedl-mmpretrain.readthedocs.io/en/latest/user_guides/dataset_prepare.html#prepare-dataset).

Train:

```shell
python tools/train.py configs/vgg/vgg11_8xb32_in1k.py
```

Test:

```shell
python tools/test.py configs/vgg/vgg11_8xb32_in1k.py https://mmassets.onedl.ai/mmclassification/v0/vgg/vgg11_batch256_imagenet_20210208-4271cd6c.pth
```

<!-- [TABS-END] -->

## Models and results

### Image Classification on ImageNet-1k

| Model                |   Pretrain   | Params (M) | Flops (G) | Top-1 (%) | Top-5 (%) |             Config              |                                               Download                                               |
| :------------------- | :----------: | :--------: | :-------: | :-------: | :-------: | :-----------------------------: | :--------------------------------------------------------------------------------------------------: |
| `vgg11_8xb32_in1k`   | From scratch |   132.86   |   7.63    |   68.75   |   88.87   |  [config](vgg11_8xb32_in1k.py)  | [model](https://mmassets.onedl.ai/mmclassification/v0/vgg/vgg11_batch256_imagenet_20210208-4271cd6c.pth) \| [log](https://mmassets.onedl.ai/mmclassification/v0/vgg/vgg11_batch256_imagenet_20210208-4271cd6c.json) |
| `vgg13_8xb32_in1k`   | From scratch |   133.05   |   11.34   |   70.02   |   89.46   |  [config](vgg13_8xb32_in1k.py)  | [model](https://mmassets.onedl.ai/mmclassification/v0/vgg/vgg13_batch256_imagenet_20210208-4d1d6080.pth) \| [log](https://mmassets.onedl.ai/mmclassification/v0/vgg/vgg13_batch256_imagenet_20210208-4d1d6080.json) |
| `vgg16_8xb32_in1k`   | From scratch |   138.36   |   15.50   |   71.62   |   90.49   |  [config](vgg16_8xb32_in1k.py)  | [model](https://mmassets.onedl.ai/mmclassification/v0/vgg/vgg16_batch256_imagenet_20210208-db26f1a5.pth) \| [log](https://mmassets.onedl.ai/mmclassification/v0/vgg/vgg16_batch256_imagenet_20210208-db26f1a5.json) |
| `vgg19_8xb32_in1k`   | From scratch |   143.67   |   19.67   |   72.41   |   90.80   |  [config](vgg19_8xb32_in1k.py)  | [model](https://mmassets.onedl.ai/mmclassification/v0/vgg/vgg19_batch256_imagenet_20210208-e6920e4a.pth) \| [log](https://mmassets.onedl.ai/mmclassification/v0/vgg/vgg19_batch256_imagenet_20210208-e6920e4a.json) |
| `vgg11bn_8xb32_in1k` | From scratch |   132.87   |   7.64    |   70.67   |   90.16   | [config](vgg11bn_8xb32_in1k.py) | [model](https://mmassets.onedl.ai/mmclassification/v0/vgg/vgg11_bn_batch256_imagenet_20210207-f244902c.pth) \| [log](https://mmassets.onedl.ai/mmclassification/v0/vgg/vgg11_bn_batch256_imagenet_20210207-f244902c.json) |
| `vgg13bn_8xb32_in1k` | From scratch |   133.05   |   11.36   |   72.12   |   90.66   | [config](vgg13bn_8xb32_in1k.py) | [model](https://mmassets.onedl.ai/mmclassification/v0/vgg/vgg13_bn_batch256_imagenet_20210207-1a8b7864.pth) \| [log](https://mmassets.onedl.ai/mmclassification/v0/vgg/vgg13_bn_batch256_imagenet_20210207-1a8b7864.json) |
| `vgg16bn_8xb32_in1k` | From scratch |   138.37   |   15.53   |   73.74   |   91.66   | [config](vgg16bn_8xb32_in1k.py) | [model](https://mmassets.onedl.ai/mmclassification/v0/vgg/vgg16_bn_batch256_imagenet_20210208-7e55cd29.pth) \| [log](https://mmassets.onedl.ai/mmclassification/v0/vgg/vgg16_bn_batch256_imagenet_20210208-7e55cd29.json) |
| `vgg19bn_8xb32_in1k` | From scratch |   143.68   |   19.70   |   74.68   |   92.27   | [config](vgg19bn_8xb32_in1k.py) | [model](https://mmassets.onedl.ai/mmclassification/v0/vgg/vgg19_bn_batch256_imagenet_20210208-da620c4f.pth) \| [log](https://mmassets.onedl.ai/mmclassification/v0/vgg/vgg19_bn_batch256_imagenet_20210208-da620c4f.json) |

## Citation

```bibtex
@article{simonyan2014very,
  title={Very deep convolutional networks for large-scale image recognition},
  author={Simonyan, Karen and Zisserman, Andrew},
  journal={arXiv preprint arXiv:1409.1556},
  year={2014}
}
```
