# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AddressGroupArgs', 'AddressGroup']

@pulumi.input_type
class AddressGroupArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic: Optional[pulumi.Input['AddressGroupDynamicArgs']] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 statics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a AddressGroup resource.
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input['AddressGroupDynamicArgs'] dynamic: Dynamic
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: The name of the address group
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] statics: Static
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags for address group object
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if dynamic is not None:
            pulumi.set(__self__, "dynamic", dynamic)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if statics is not None:
            pulumi.set(__self__, "statics", statics)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def dynamic(self) -> Optional[pulumi.Input['AddressGroupDynamicArgs']]:
        """
        Dynamic
        """
        return pulumi.get(self, "dynamic")

    @dynamic.setter
    def dynamic(self, value: Optional[pulumi.Input['AddressGroupDynamicArgs']]):
        pulumi.set(self, "dynamic", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the address group
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def statics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Static
        """
        return pulumi.get(self, "statics")

    @statics.setter
    def statics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "statics", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags for address group object
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AddressGroupState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic: Optional[pulumi.Input['AddressGroupDynamicArgs']] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 statics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AddressGroup resources.
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input['AddressGroupDynamicArgs'] dynamic: Dynamic
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: The name of the address group
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] statics: Static
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags for address group object
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if dynamic is not None:
            pulumi.set(__self__, "dynamic", dynamic)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if statics is not None:
            pulumi.set(__self__, "statics", statics)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def dynamic(self) -> Optional[pulumi.Input['AddressGroupDynamicArgs']]:
        """
        Dynamic
        """
        return pulumi.get(self, "dynamic")

    @dynamic.setter
    def dynamic(self, value: Optional[pulumi.Input['AddressGroupDynamicArgs']]):
        pulumi.set(self, "dynamic", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the address group
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def statics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Static
        """
        return pulumi.get(self, "statics")

    @statics.setter
    def statics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "statics", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags for address group object
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)


@pulumi.type_token("scm:index/addressGroup:AddressGroup")
class AddressGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic: Optional[pulumi.Input[Union['AddressGroupDynamicArgs', 'AddressGroupDynamicArgsDict']]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 statics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        AddressGroup resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        # This file is embedded using go:embed
        # First, create some addresses that will be used in the address group
        scm_address_ag1 = scm.Address("scm_address_ag_1",
            folder="Shared",
            name="scm_address_ag_1",
            description="First test address",
            ip_netmask="192.168.1.1/32")
        scm_address_ag2 = scm.Address("scm_address_ag_2",
            folder="Shared",
            name="scm_address_ag_2",
            description="Second test address",
            ip_netmask="192.168.1.2/32")
        # Create the address group that references the addresses above
        scm_address_group1 = scm.AddressGroup("scm_address_group_1",
            folder="Shared",
            name="scm_address_group_1",
            description="Sample address group created with Terraform",
            statics=[
                scm_address_ag1.name,
                scm_address_ag2.name,
            ])
        # Create tags to be used for dynamic address group
        scm_addressgroup_tag1 = scm.Tag("scm_addressgroup_tag_1",
            folder="All",
            name="scm_addressgroup_tag_1",
            comments="Managed by Pulumi",
            color="Orange")
        scm_addressgroup_tag2 = scm.Tag("scm_addressgroup_tag_2",
            folder="All",
            name="scm_addressgroup_tag_2",
            comments="Managed by Pulumi",
            color="Blue")
        # Create a dynamic addressgroup that matches both tags
        scm_addressgroup_dynamic = scm.AddressGroup("scm_addressgroup_dynamic",
            folder="Shared",
            name="scm_addressgroup_dynamic",
            description="Managed by Pulumi",
            dynamic={
                "filter": "scm_addressgroup_tag_1 and scm_addressgroup_tag_2",
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[Union['AddressGroupDynamicArgs', 'AddressGroupDynamicArgsDict']] dynamic: Dynamic
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: The name of the address group
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] statics: Static
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags for address group object
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AddressGroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        AddressGroup resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        # This file is embedded using go:embed
        # First, create some addresses that will be used in the address group
        scm_address_ag1 = scm.Address("scm_address_ag_1",
            folder="Shared",
            name="scm_address_ag_1",
            description="First test address",
            ip_netmask="192.168.1.1/32")
        scm_address_ag2 = scm.Address("scm_address_ag_2",
            folder="Shared",
            name="scm_address_ag_2",
            description="Second test address",
            ip_netmask="192.168.1.2/32")
        # Create the address group that references the addresses above
        scm_address_group1 = scm.AddressGroup("scm_address_group_1",
            folder="Shared",
            name="scm_address_group_1",
            description="Sample address group created with Terraform",
            statics=[
                scm_address_ag1.name,
                scm_address_ag2.name,
            ])
        # Create tags to be used for dynamic address group
        scm_addressgroup_tag1 = scm.Tag("scm_addressgroup_tag_1",
            folder="All",
            name="scm_addressgroup_tag_1",
            comments="Managed by Pulumi",
            color="Orange")
        scm_addressgroup_tag2 = scm.Tag("scm_addressgroup_tag_2",
            folder="All",
            name="scm_addressgroup_tag_2",
            comments="Managed by Pulumi",
            color="Blue")
        # Create a dynamic addressgroup that matches both tags
        scm_addressgroup_dynamic = scm.AddressGroup("scm_addressgroup_dynamic",
            folder="Shared",
            name="scm_addressgroup_dynamic",
            description="Managed by Pulumi",
            dynamic={
                "filter": "scm_addressgroup_tag_1 and scm_addressgroup_tag_2",
            })
        ```

        :param str resource_name: The name of the resource.
        :param AddressGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AddressGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic: Optional[pulumi.Input[Union['AddressGroupDynamicArgs', 'AddressGroupDynamicArgsDict']]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 statics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AddressGroupArgs.__new__(AddressGroupArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["device"] = device
            __props__.__dict__["dynamic"] = dynamic
            __props__.__dict__["folder"] = folder
            __props__.__dict__["name"] = name
            __props__.__dict__["snippet"] = snippet
            __props__.__dict__["statics"] = statics
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tfid"] = None
        super(AddressGroup, __self__).__init__(
            'scm:index/addressGroup:AddressGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            dynamic: Optional[pulumi.Input[Union['AddressGroupDynamicArgs', 'AddressGroupDynamicArgsDict']]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            statics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None) -> 'AddressGroup':
        """
        Get an existing AddressGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[Union['AddressGroupDynamicArgs', 'AddressGroupDynamicArgsDict']] dynamic: Dynamic
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: The name of the address group
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] statics: Static
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags for address group object
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AddressGroupState.__new__(_AddressGroupState)

        __props__.__dict__["description"] = description
        __props__.__dict__["device"] = device
        __props__.__dict__["dynamic"] = dynamic
        __props__.__dict__["folder"] = folder
        __props__.__dict__["name"] = name
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["statics"] = statics
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tfid"] = tfid
        return AddressGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def dynamic(self) -> pulumi.Output[Optional['outputs.AddressGroupDynamic']]:
        """
        Dynamic
        """
        return pulumi.get(self, "dynamic")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the address group
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def statics(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Static
        """
        return pulumi.get(self, "statics")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags for address group object
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

