# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DecryptionProfileArgs', 'DecryptionProfile']

@pulumi.input_type
class DecryptionProfileArgs:
    def __init__(__self__, *,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_forward_proxy: Optional[pulumi.Input['DecryptionProfileSslForwardProxyArgs']] = None,
                 ssl_inbound_proxy: Optional[pulumi.Input['DecryptionProfileSslInboundProxyArgs']] = None,
                 ssl_no_proxy: Optional[pulumi.Input['DecryptionProfileSslNoProxyArgs']] = None,
                 ssl_protocol_settings: Optional[pulumi.Input['DecryptionProfileSslProtocolSettingsArgs']] = None):
        """
        The set of arguments for constructing a DecryptionProfile resource.
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: Must start with alphanumeric char and should contain only alphanemeric, underscore, hyphen, dot or space
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input['DecryptionProfileSslForwardProxyArgs'] ssl_forward_proxy: Ssl forward proxy
        :param pulumi.Input['DecryptionProfileSslInboundProxyArgs'] ssl_inbound_proxy: Ssl inbound proxy
        :param pulumi.Input['DecryptionProfileSslNoProxyArgs'] ssl_no_proxy: Ssl no proxy
        :param pulumi.Input['DecryptionProfileSslProtocolSettingsArgs'] ssl_protocol_settings: Ssl protocol settings
        """
        if device is not None:
            pulumi.set(__self__, "device", device)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if ssl_forward_proxy is not None:
            pulumi.set(__self__, "ssl_forward_proxy", ssl_forward_proxy)
        if ssl_inbound_proxy is not None:
            pulumi.set(__self__, "ssl_inbound_proxy", ssl_inbound_proxy)
        if ssl_no_proxy is not None:
            pulumi.set(__self__, "ssl_no_proxy", ssl_no_proxy)
        if ssl_protocol_settings is not None:
            pulumi.set(__self__, "ssl_protocol_settings", ssl_protocol_settings)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Must start with alphanumeric char and should contain only alphanemeric, underscore, hyphen, dot or space
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter(name="sslForwardProxy")
    def ssl_forward_proxy(self) -> Optional[pulumi.Input['DecryptionProfileSslForwardProxyArgs']]:
        """
        Ssl forward proxy
        """
        return pulumi.get(self, "ssl_forward_proxy")

    @ssl_forward_proxy.setter
    def ssl_forward_proxy(self, value: Optional[pulumi.Input['DecryptionProfileSslForwardProxyArgs']]):
        pulumi.set(self, "ssl_forward_proxy", value)

    @_builtins.property
    @pulumi.getter(name="sslInboundProxy")
    def ssl_inbound_proxy(self) -> Optional[pulumi.Input['DecryptionProfileSslInboundProxyArgs']]:
        """
        Ssl inbound proxy
        """
        return pulumi.get(self, "ssl_inbound_proxy")

    @ssl_inbound_proxy.setter
    def ssl_inbound_proxy(self, value: Optional[pulumi.Input['DecryptionProfileSslInboundProxyArgs']]):
        pulumi.set(self, "ssl_inbound_proxy", value)

    @_builtins.property
    @pulumi.getter(name="sslNoProxy")
    def ssl_no_proxy(self) -> Optional[pulumi.Input['DecryptionProfileSslNoProxyArgs']]:
        """
        Ssl no proxy
        """
        return pulumi.get(self, "ssl_no_proxy")

    @ssl_no_proxy.setter
    def ssl_no_proxy(self, value: Optional[pulumi.Input['DecryptionProfileSslNoProxyArgs']]):
        pulumi.set(self, "ssl_no_proxy", value)

    @_builtins.property
    @pulumi.getter(name="sslProtocolSettings")
    def ssl_protocol_settings(self) -> Optional[pulumi.Input['DecryptionProfileSslProtocolSettingsArgs']]:
        """
        Ssl protocol settings
        """
        return pulumi.get(self, "ssl_protocol_settings")

    @ssl_protocol_settings.setter
    def ssl_protocol_settings(self, value: Optional[pulumi.Input['DecryptionProfileSslProtocolSettingsArgs']]):
        pulumi.set(self, "ssl_protocol_settings", value)


@pulumi.input_type
class _DecryptionProfileState:
    def __init__(__self__, *,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_forward_proxy: Optional[pulumi.Input['DecryptionProfileSslForwardProxyArgs']] = None,
                 ssl_inbound_proxy: Optional[pulumi.Input['DecryptionProfileSslInboundProxyArgs']] = None,
                 ssl_no_proxy: Optional[pulumi.Input['DecryptionProfileSslNoProxyArgs']] = None,
                 ssl_protocol_settings: Optional[pulumi.Input['DecryptionProfileSslProtocolSettingsArgs']] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DecryptionProfile resources.
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: Must start with alphanumeric char and should contain only alphanemeric, underscore, hyphen, dot or space
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input['DecryptionProfileSslForwardProxyArgs'] ssl_forward_proxy: Ssl forward proxy
        :param pulumi.Input['DecryptionProfileSslInboundProxyArgs'] ssl_inbound_proxy: Ssl inbound proxy
        :param pulumi.Input['DecryptionProfileSslNoProxyArgs'] ssl_no_proxy: Ssl no proxy
        :param pulumi.Input['DecryptionProfileSslProtocolSettingsArgs'] ssl_protocol_settings: Ssl protocol settings
        """
        if device is not None:
            pulumi.set(__self__, "device", device)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if ssl_forward_proxy is not None:
            pulumi.set(__self__, "ssl_forward_proxy", ssl_forward_proxy)
        if ssl_inbound_proxy is not None:
            pulumi.set(__self__, "ssl_inbound_proxy", ssl_inbound_proxy)
        if ssl_no_proxy is not None:
            pulumi.set(__self__, "ssl_no_proxy", ssl_no_proxy)
        if ssl_protocol_settings is not None:
            pulumi.set(__self__, "ssl_protocol_settings", ssl_protocol_settings)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Must start with alphanumeric char and should contain only alphanemeric, underscore, hyphen, dot or space
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter(name="sslForwardProxy")
    def ssl_forward_proxy(self) -> Optional[pulumi.Input['DecryptionProfileSslForwardProxyArgs']]:
        """
        Ssl forward proxy
        """
        return pulumi.get(self, "ssl_forward_proxy")

    @ssl_forward_proxy.setter
    def ssl_forward_proxy(self, value: Optional[pulumi.Input['DecryptionProfileSslForwardProxyArgs']]):
        pulumi.set(self, "ssl_forward_proxy", value)

    @_builtins.property
    @pulumi.getter(name="sslInboundProxy")
    def ssl_inbound_proxy(self) -> Optional[pulumi.Input['DecryptionProfileSslInboundProxyArgs']]:
        """
        Ssl inbound proxy
        """
        return pulumi.get(self, "ssl_inbound_proxy")

    @ssl_inbound_proxy.setter
    def ssl_inbound_proxy(self, value: Optional[pulumi.Input['DecryptionProfileSslInboundProxyArgs']]):
        pulumi.set(self, "ssl_inbound_proxy", value)

    @_builtins.property
    @pulumi.getter(name="sslNoProxy")
    def ssl_no_proxy(self) -> Optional[pulumi.Input['DecryptionProfileSslNoProxyArgs']]:
        """
        Ssl no proxy
        """
        return pulumi.get(self, "ssl_no_proxy")

    @ssl_no_proxy.setter
    def ssl_no_proxy(self, value: Optional[pulumi.Input['DecryptionProfileSslNoProxyArgs']]):
        pulumi.set(self, "ssl_no_proxy", value)

    @_builtins.property
    @pulumi.getter(name="sslProtocolSettings")
    def ssl_protocol_settings(self) -> Optional[pulumi.Input['DecryptionProfileSslProtocolSettingsArgs']]:
        """
        Ssl protocol settings
        """
        return pulumi.get(self, "ssl_protocol_settings")

    @ssl_protocol_settings.setter
    def ssl_protocol_settings(self, value: Optional[pulumi.Input['DecryptionProfileSslProtocolSettingsArgs']]):
        pulumi.set(self, "ssl_protocol_settings", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)


@pulumi.type_token("scm:index/decryptionProfile:DecryptionProfile")
class DecryptionProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_forward_proxy: Optional[pulumi.Input[Union['DecryptionProfileSslForwardProxyArgs', 'DecryptionProfileSslForwardProxyArgsDict']]] = None,
                 ssl_inbound_proxy: Optional[pulumi.Input[Union['DecryptionProfileSslInboundProxyArgs', 'DecryptionProfileSslInboundProxyArgsDict']]] = None,
                 ssl_no_proxy: Optional[pulumi.Input[Union['DecryptionProfileSslNoProxyArgs', 'DecryptionProfileSslNoProxyArgsDict']]] = None,
                 ssl_protocol_settings: Optional[pulumi.Input[Union['DecryptionProfileSslProtocolSettingsArgs', 'DecryptionProfileSslProtocolSettingsArgsDict']]] = None,
                 __props__=None):
        """
        DecryptionProfile resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        scm_decryption_profile_base = scm.DecryptionProfile("scm_decryption_profile_base",
            folder="ngfw-shared",
            name="dp_base")
        scm_decryption_profile_forward_proxy = scm.DecryptionProfile("scm_decryption_profile_forward_proxy",
            folder="ngfw-shared",
            name="dp_forward_proxy",
            ssl_forward_proxy={
                "auto_include_altname": False,
                "block_client_cert": True,
                "block_expired_certificate": True,
                "block_timeout_cert": True,
                "block_tls13_downgrade_no_resource": False,
                "block_unknown_cert": False,
                "block_unsupported_cipher": True,
                "block_unsupported_version": True,
                "block_untrusted_issuer": True,
                "restrict_cert_exts": False,
                "strip_alpn": True,
            })
        scm_decryption_profile_inbound_proxy = scm.DecryptionProfile("scm_decryption_profile_inbound_proxy",
            folder="ngfw-shared",
            name="dp_inbound_proxy",
            ssl_inbound_proxy={
                "block_if_hsm_unavailable": True,
                "block_if_no_resource": True,
                "block_unsupported_cipher": False,
                "block_unsupported_version": True,
            })
        scm_decryption_profile_no_proxy = scm.DecryptionProfile("scm_decryption_profile_no_proxy",
            folder="ngfw-shared",
            name="dp_no_proxy",
            ssl_no_proxy={
                "block_expired_certificate": True,
                "block_untrusted_issuer": False,
            })
        scm_decryption_profile_protocol_settings = scm.DecryptionProfile("scm_decryption_profile_protocol_settings",
            folder="ngfw-shared",
            name="dp_protocol_settings",
            ssl_protocol_settings={
                "auth_algo_md5": True,
                "auth_algo_sha1": True,
                "auth_algo_sha256": True,
                "auth_algo_sha384": False,
                "enc_algo3des": False,
                "enc_algo_aes128_cbc": False,
                "enc_algo_aes128_gcm": True,
                "enc_algo_aes256_cbc": False,
                "enc_algo_aes256_gcm": True,
                "enc_algo_chacha20_poly1305": False,
                "enc_algo_rc4": False,
                "keyxchg_algo_dhe": True,
                "keyxchg_algo_ecdhe": True,
                "keyxchg_algo_rsa": False,
                "max_version": "max",
                "min_version": "tls1-2",
            })
        mixed_decryption_profile = scm.DecryptionProfile("mixed_decryption_profile",
            folder="ngfw-shared",
            name="mixed_dp",
            ssl_forward_proxy={
                "auto_include_altname": True,
                "block_client_cert": True,
                "block_expired_certificate": False,
                "restrict_cert_exts": False,
                "strip_alpn": True,
            },
            ssl_inbound_proxy={
                "block_if_hsm_unavailable": True,
                "block_if_no_resource": True,
                "block_unsupported_cipher": True,
                "block_unsupported_version": True,
            },
            ssl_protocol_settings={
                "auth_algo_md5": True,
                "auth_algo_sha1": True,
                "auth_algo_sha256": False,
                "auth_algo_sha384": True,
                "enc_algo3des": True,
                "enc_algo_rc4": True,
                "keyxchg_algo_dhe": False,
                "keyxchg_algo_ecdhe": False,
                "max_version": "tls1-3",
                "min_version": "tls1-1",
            })
        full_mixed_decryption_profile = scm.DecryptionProfile("full_mixed_decryption_profile",
            folder="ngfw-shared",
            name="full_mixed_dp",
            ssl_forward_proxy={
                "auto_include_altname": True,
                "block_client_cert": True,
                "block_expired_certificate": False,
                "block_timeout_cert": True,
                "block_unknown_cert": False,
                "block_unsupported_cipher": True,
                "block_untrusted_issuer": False,
                "restrict_cert_exts": False,
                "strip_alpn": True,
            },
            ssl_inbound_proxy={
                "block_if_hsm_unavailable": True,
                "block_if_no_resource": False,
                "block_unsupported_cipher": True,
                "block_unsupported_version": False,
            },
            ssl_no_proxy={
                "block_expired_certificate": False,
                "block_untrusted_issuer": True,
            },
            ssl_protocol_settings={
                "auth_algo_md5": False,
                "auth_algo_sha1": True,
                "auth_algo_sha256": False,
                "auth_algo_sha384": True,
                "enc_algo3des": False,
                "enc_algo_aes128_gcm": True,
                "enc_algo_aes256_cbc": False,
                "enc_algo_aes256_gcm": True,
                "enc_algo_rc4": True,
                "keyxchg_algo_dhe": False,
                "keyxchg_algo_ecdhe": True,
                "keyxchg_algo_rsa": False,
                "max_version": "tls1-0",
                "min_version": "sslv3",
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: Must start with alphanumeric char and should contain only alphanemeric, underscore, hyphen, dot or space
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Union['DecryptionProfileSslForwardProxyArgs', 'DecryptionProfileSslForwardProxyArgsDict']] ssl_forward_proxy: Ssl forward proxy
        :param pulumi.Input[Union['DecryptionProfileSslInboundProxyArgs', 'DecryptionProfileSslInboundProxyArgsDict']] ssl_inbound_proxy: Ssl inbound proxy
        :param pulumi.Input[Union['DecryptionProfileSslNoProxyArgs', 'DecryptionProfileSslNoProxyArgsDict']] ssl_no_proxy: Ssl no proxy
        :param pulumi.Input[Union['DecryptionProfileSslProtocolSettingsArgs', 'DecryptionProfileSslProtocolSettingsArgsDict']] ssl_protocol_settings: Ssl protocol settings
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DecryptionProfileArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        DecryptionProfile resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        scm_decryption_profile_base = scm.DecryptionProfile("scm_decryption_profile_base",
            folder="ngfw-shared",
            name="dp_base")
        scm_decryption_profile_forward_proxy = scm.DecryptionProfile("scm_decryption_profile_forward_proxy",
            folder="ngfw-shared",
            name="dp_forward_proxy",
            ssl_forward_proxy={
                "auto_include_altname": False,
                "block_client_cert": True,
                "block_expired_certificate": True,
                "block_timeout_cert": True,
                "block_tls13_downgrade_no_resource": False,
                "block_unknown_cert": False,
                "block_unsupported_cipher": True,
                "block_unsupported_version": True,
                "block_untrusted_issuer": True,
                "restrict_cert_exts": False,
                "strip_alpn": True,
            })
        scm_decryption_profile_inbound_proxy = scm.DecryptionProfile("scm_decryption_profile_inbound_proxy",
            folder="ngfw-shared",
            name="dp_inbound_proxy",
            ssl_inbound_proxy={
                "block_if_hsm_unavailable": True,
                "block_if_no_resource": True,
                "block_unsupported_cipher": False,
                "block_unsupported_version": True,
            })
        scm_decryption_profile_no_proxy = scm.DecryptionProfile("scm_decryption_profile_no_proxy",
            folder="ngfw-shared",
            name="dp_no_proxy",
            ssl_no_proxy={
                "block_expired_certificate": True,
                "block_untrusted_issuer": False,
            })
        scm_decryption_profile_protocol_settings = scm.DecryptionProfile("scm_decryption_profile_protocol_settings",
            folder="ngfw-shared",
            name="dp_protocol_settings",
            ssl_protocol_settings={
                "auth_algo_md5": True,
                "auth_algo_sha1": True,
                "auth_algo_sha256": True,
                "auth_algo_sha384": False,
                "enc_algo3des": False,
                "enc_algo_aes128_cbc": False,
                "enc_algo_aes128_gcm": True,
                "enc_algo_aes256_cbc": False,
                "enc_algo_aes256_gcm": True,
                "enc_algo_chacha20_poly1305": False,
                "enc_algo_rc4": False,
                "keyxchg_algo_dhe": True,
                "keyxchg_algo_ecdhe": True,
                "keyxchg_algo_rsa": False,
                "max_version": "max",
                "min_version": "tls1-2",
            })
        mixed_decryption_profile = scm.DecryptionProfile("mixed_decryption_profile",
            folder="ngfw-shared",
            name="mixed_dp",
            ssl_forward_proxy={
                "auto_include_altname": True,
                "block_client_cert": True,
                "block_expired_certificate": False,
                "restrict_cert_exts": False,
                "strip_alpn": True,
            },
            ssl_inbound_proxy={
                "block_if_hsm_unavailable": True,
                "block_if_no_resource": True,
                "block_unsupported_cipher": True,
                "block_unsupported_version": True,
            },
            ssl_protocol_settings={
                "auth_algo_md5": True,
                "auth_algo_sha1": True,
                "auth_algo_sha256": False,
                "auth_algo_sha384": True,
                "enc_algo3des": True,
                "enc_algo_rc4": True,
                "keyxchg_algo_dhe": False,
                "keyxchg_algo_ecdhe": False,
                "max_version": "tls1-3",
                "min_version": "tls1-1",
            })
        full_mixed_decryption_profile = scm.DecryptionProfile("full_mixed_decryption_profile",
            folder="ngfw-shared",
            name="full_mixed_dp",
            ssl_forward_proxy={
                "auto_include_altname": True,
                "block_client_cert": True,
                "block_expired_certificate": False,
                "block_timeout_cert": True,
                "block_unknown_cert": False,
                "block_unsupported_cipher": True,
                "block_untrusted_issuer": False,
                "restrict_cert_exts": False,
                "strip_alpn": True,
            },
            ssl_inbound_proxy={
                "block_if_hsm_unavailable": True,
                "block_if_no_resource": False,
                "block_unsupported_cipher": True,
                "block_unsupported_version": False,
            },
            ssl_no_proxy={
                "block_expired_certificate": False,
                "block_untrusted_issuer": True,
            },
            ssl_protocol_settings={
                "auth_algo_md5": False,
                "auth_algo_sha1": True,
                "auth_algo_sha256": False,
                "auth_algo_sha384": True,
                "enc_algo3des": False,
                "enc_algo_aes128_gcm": True,
                "enc_algo_aes256_cbc": False,
                "enc_algo_aes256_gcm": True,
                "enc_algo_rc4": True,
                "keyxchg_algo_dhe": False,
                "keyxchg_algo_ecdhe": True,
                "keyxchg_algo_rsa": False,
                "max_version": "tls1-0",
                "min_version": "sslv3",
            })
        ```

        :param str resource_name: The name of the resource.
        :param DecryptionProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DecryptionProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_forward_proxy: Optional[pulumi.Input[Union['DecryptionProfileSslForwardProxyArgs', 'DecryptionProfileSslForwardProxyArgsDict']]] = None,
                 ssl_inbound_proxy: Optional[pulumi.Input[Union['DecryptionProfileSslInboundProxyArgs', 'DecryptionProfileSslInboundProxyArgsDict']]] = None,
                 ssl_no_proxy: Optional[pulumi.Input[Union['DecryptionProfileSslNoProxyArgs', 'DecryptionProfileSslNoProxyArgsDict']]] = None,
                 ssl_protocol_settings: Optional[pulumi.Input[Union['DecryptionProfileSslProtocolSettingsArgs', 'DecryptionProfileSslProtocolSettingsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DecryptionProfileArgs.__new__(DecryptionProfileArgs)

            __props__.__dict__["device"] = device
            __props__.__dict__["folder"] = folder
            __props__.__dict__["name"] = name
            __props__.__dict__["snippet"] = snippet
            __props__.__dict__["ssl_forward_proxy"] = ssl_forward_proxy
            __props__.__dict__["ssl_inbound_proxy"] = ssl_inbound_proxy
            __props__.__dict__["ssl_no_proxy"] = ssl_no_proxy
            __props__.__dict__["ssl_protocol_settings"] = ssl_protocol_settings
            __props__.__dict__["tfid"] = None
        super(DecryptionProfile, __self__).__init__(
            'scm:index/decryptionProfile:DecryptionProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_forward_proxy: Optional[pulumi.Input[Union['DecryptionProfileSslForwardProxyArgs', 'DecryptionProfileSslForwardProxyArgsDict']]] = None,
            ssl_inbound_proxy: Optional[pulumi.Input[Union['DecryptionProfileSslInboundProxyArgs', 'DecryptionProfileSslInboundProxyArgsDict']]] = None,
            ssl_no_proxy: Optional[pulumi.Input[Union['DecryptionProfileSslNoProxyArgs', 'DecryptionProfileSslNoProxyArgsDict']]] = None,
            ssl_protocol_settings: Optional[pulumi.Input[Union['DecryptionProfileSslProtocolSettingsArgs', 'DecryptionProfileSslProtocolSettingsArgsDict']]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None) -> 'DecryptionProfile':
        """
        Get an existing DecryptionProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: Must start with alphanumeric char and should contain only alphanemeric, underscore, hyphen, dot or space
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Union['DecryptionProfileSslForwardProxyArgs', 'DecryptionProfileSslForwardProxyArgsDict']] ssl_forward_proxy: Ssl forward proxy
        :param pulumi.Input[Union['DecryptionProfileSslInboundProxyArgs', 'DecryptionProfileSslInboundProxyArgsDict']] ssl_inbound_proxy: Ssl inbound proxy
        :param pulumi.Input[Union['DecryptionProfileSslNoProxyArgs', 'DecryptionProfileSslNoProxyArgsDict']] ssl_no_proxy: Ssl no proxy
        :param pulumi.Input[Union['DecryptionProfileSslProtocolSettingsArgs', 'DecryptionProfileSslProtocolSettingsArgsDict']] ssl_protocol_settings: Ssl protocol settings
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DecryptionProfileState.__new__(_DecryptionProfileState)

        __props__.__dict__["device"] = device
        __props__.__dict__["folder"] = folder
        __props__.__dict__["name"] = name
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["ssl_forward_proxy"] = ssl_forward_proxy
        __props__.__dict__["ssl_inbound_proxy"] = ssl_inbound_proxy
        __props__.__dict__["ssl_no_proxy"] = ssl_no_proxy
        __props__.__dict__["ssl_protocol_settings"] = ssl_protocol_settings
        __props__.__dict__["tfid"] = tfid
        return DecryptionProfile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Must start with alphanumeric char and should contain only alphanemeric, underscore, hyphen, dot or space
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter(name="sslForwardProxy")
    def ssl_forward_proxy(self) -> pulumi.Output['outputs.DecryptionProfileSslForwardProxy']:
        """
        Ssl forward proxy
        """
        return pulumi.get(self, "ssl_forward_proxy")

    @_builtins.property
    @pulumi.getter(name="sslInboundProxy")
    def ssl_inbound_proxy(self) -> pulumi.Output['outputs.DecryptionProfileSslInboundProxy']:
        """
        Ssl inbound proxy
        """
        return pulumi.get(self, "ssl_inbound_proxy")

    @_builtins.property
    @pulumi.getter(name="sslNoProxy")
    def ssl_no_proxy(self) -> pulumi.Output['outputs.DecryptionProfileSslNoProxy']:
        """
        Ssl no proxy
        """
        return pulumi.get(self, "ssl_no_proxy")

    @_builtins.property
    @pulumi.getter(name="sslProtocolSettings")
    def ssl_protocol_settings(self) -> pulumi.Output['outputs.DecryptionProfileSslProtocolSettings']:
        """
        Ssl protocol settings
        """
        return pulumi.get(self, "ssl_protocol_settings")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

