# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DecryptionRuleArgs', 'DecryptionRule']

@pulumi.input_type
class DecryptionRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 categories: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 destinations: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 froms: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 services: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 source_users: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 sources: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 tos: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_hips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 log_fail: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_setting: Optional[pulumi.Input[_builtins.str]] = None,
                 log_success: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 negate_destination: Optional[pulumi.Input[_builtins.bool]] = None,
                 negate_source: Optional[pulumi.Input[_builtins.bool]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 relative_position: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 source_hips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_rule: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input['DecryptionRuleTypeArgs']] = None):
        """
        The set of arguments for constructing a DecryptionRule resource.
        :param pulumi.Input[_builtins.str] action: The action to be taken
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] categories: The destination URL category
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destinations: The destination addresses
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] froms: The source security zone
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: The destination services and/or service groups
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_users: List of source users and/or groups.  Reserved words include `any`, `pre-login`, `known-user`, and `unknown`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sources: The source addresses
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tos: The destination security zone
        :param pulumi.Input[_builtins.str] description: The description of the decryption rule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destination_hips: The Host Integrity Profile of the destination host
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.bool] disabled: Is the rule disabled?
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.bool] log_fail: Log failed decryption events?
        :param pulumi.Input[_builtins.str] log_setting: The log settings of the decryption rule
        :param pulumi.Input[_builtins.bool] log_success: Log successful decryption events?
        :param pulumi.Input[_builtins.str] name: The name of the decryption rule
        :param pulumi.Input[_builtins.bool] negate_destination: Negate the destination addresses?
        :param pulumi.Input[_builtins.bool] negate_source: Negate the source addresses?
        :param pulumi.Input[_builtins.str] position: The position of a security rule
        :param pulumi.Input[_builtins.str] profile: The decryption profile associated with the decryption rule
        :param pulumi.Input[_builtins.str] relative_position: Relative positioning rule. String must be one of these: `"before"`, `"after"`, `"top"`, `"bottom"`. If not specified, rule is created at the bottom of the ruleset.
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_hips: Source hip
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags associated with the decryption rule
        :param pulumi.Input[_builtins.str] target_rule: The name or UUID of the rule to position this rule relative to. Required when `relative_position` is `"before"` or `"after"`.
        :param pulumi.Input['DecryptionRuleTypeArgs'] type: The type of decryption
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "categories", categories)
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "froms", froms)
        pulumi.set(__self__, "services", services)
        pulumi.set(__self__, "source_users", source_users)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "tos", tos)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_hips is not None:
            pulumi.set(__self__, "destination_hips", destination_hips)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if log_fail is not None:
            pulumi.set(__self__, "log_fail", log_fail)
        if log_setting is not None:
            pulumi.set(__self__, "log_setting", log_setting)
        if log_success is not None:
            pulumi.set(__self__, "log_success", log_success)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if negate_destination is not None:
            pulumi.set(__self__, "negate_destination", negate_destination)
        if negate_source is not None:
            pulumi.set(__self__, "negate_source", negate_source)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if relative_position is not None:
            pulumi.set(__self__, "relative_position", relative_position)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if source_hips is not None:
            pulumi.set(__self__, "source_hips", source_hips)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_rule is not None:
            pulumi.set(__self__, "target_rule", target_rule)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        The action to be taken
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The destination URL category
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The destination addresses
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "destinations", value)

    @_builtins.property
    @pulumi.getter
    def froms(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The source security zone
        """
        return pulumi.get(self, "froms")

    @froms.setter
    def froms(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "froms", value)

    @_builtins.property
    @pulumi.getter
    def services(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The destination services and/or service groups
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "services", value)

    @_builtins.property
    @pulumi.getter(name="sourceUsers")
    def source_users(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of source users and/or groups.  Reserved words include `any`, `pre-login`, `known-user`, and `unknown`.
        """
        return pulumi.get(self, "source_users")

    @source_users.setter
    def source_users(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "source_users", value)

    @_builtins.property
    @pulumi.getter
    def sources(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The source addresses
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "sources", value)

    @_builtins.property
    @pulumi.getter
    def tos(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The destination security zone
        """
        return pulumi.get(self, "tos")

    @tos.setter
    def tos(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "tos", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the decryption rule
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationHips")
    def destination_hips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The Host Integrity Profile of the destination host
        """
        return pulumi.get(self, "destination_hips")

    @destination_hips.setter
    def destination_hips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "destination_hips", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the rule disabled?
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="logFail")
    def log_fail(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Log failed decryption events?
        """
        return pulumi.get(self, "log_fail")

    @log_fail.setter
    def log_fail(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "log_fail", value)

    @_builtins.property
    @pulumi.getter(name="logSetting")
    def log_setting(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The log settings of the decryption rule
        """
        return pulumi.get(self, "log_setting")

    @log_setting.setter
    def log_setting(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_setting", value)

    @_builtins.property
    @pulumi.getter(name="logSuccess")
    def log_success(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Log successful decryption events?
        """
        return pulumi.get(self, "log_success")

    @log_success.setter
    def log_success(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "log_success", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the decryption rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="negateDestination")
    def negate_destination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Negate the destination addresses?
        """
        return pulumi.get(self, "negate_destination")

    @negate_destination.setter
    def negate_destination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "negate_destination", value)

    @_builtins.property
    @pulumi.getter(name="negateSource")
    def negate_source(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Negate the source addresses?
        """
        return pulumi.get(self, "negate_source")

    @negate_source.setter
    def negate_source(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "negate_source", value)

    @_builtins.property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The position of a security rule
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "position", value)

    @_builtins.property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The decryption profile associated with the decryption rule
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile", value)

    @_builtins.property
    @pulumi.getter(name="relativePosition")
    def relative_position(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Relative positioning rule. String must be one of these: `"before"`, `"after"`, `"top"`, `"bottom"`. If not specified, rule is created at the bottom of the ruleset.
        """
        return pulumi.get(self, "relative_position")

    @relative_position.setter
    def relative_position(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "relative_position", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter(name="sourceHips")
    def source_hips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Source hip
        """
        return pulumi.get(self, "source_hips")

    @source_hips.setter
    def source_hips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "source_hips", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The tags associated with the decryption rule
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="targetRule")
    def target_rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name or UUID of the rule to position this rule relative to. Required when `relative_position` is `"before"` or `"after"`.
        """
        return pulumi.get(self, "target_rule")

    @target_rule.setter
    def target_rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_rule", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['DecryptionRuleTypeArgs']]:
        """
        The type of decryption
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['DecryptionRuleTypeArgs']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _DecryptionRuleState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_hips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 froms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_fail: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_setting: Optional[pulumi.Input[_builtins.str]] = None,
                 log_success: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 negate_destination: Optional[pulumi.Input[_builtins.bool]] = None,
                 negate_source: Optional[pulumi.Input[_builtins.bool]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 relative_position: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 source_hips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_rule: Optional[pulumi.Input[_builtins.str]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None,
                 tos: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input['DecryptionRuleTypeArgs']] = None):
        """
        Input properties used for looking up and filtering DecryptionRule resources.
        :param pulumi.Input[_builtins.str] action: The action to be taken
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] categories: The destination URL category
        :param pulumi.Input[_builtins.str] description: The description of the decryption rule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destination_hips: The Host Integrity Profile of the destination host
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destinations: The destination addresses
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.bool] disabled: Is the rule disabled?
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] froms: The source security zone
        :param pulumi.Input[_builtins.bool] log_fail: Log failed decryption events?
        :param pulumi.Input[_builtins.str] log_setting: The log settings of the decryption rule
        :param pulumi.Input[_builtins.bool] log_success: Log successful decryption events?
        :param pulumi.Input[_builtins.str] name: The name of the decryption rule
        :param pulumi.Input[_builtins.bool] negate_destination: Negate the destination addresses?
        :param pulumi.Input[_builtins.bool] negate_source: Negate the source addresses?
        :param pulumi.Input[_builtins.str] position: The position of a security rule
        :param pulumi.Input[_builtins.str] profile: The decryption profile associated with the decryption rule
        :param pulumi.Input[_builtins.str] relative_position: Relative positioning rule. String must be one of these: `"before"`, `"after"`, `"top"`, `"bottom"`. If not specified, rule is created at the bottom of the ruleset.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: The destination services and/or service groups
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_hips: Source hip
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_users: List of source users and/or groups.  Reserved words include `any`, `pre-login`, `known-user`, and `unknown`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sources: The source addresses
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags associated with the decryption rule
        :param pulumi.Input[_builtins.str] target_rule: The name or UUID of the rule to position this rule relative to. Required when `relative_position` is `"before"` or `"after"`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tos: The destination security zone
        :param pulumi.Input['DecryptionRuleTypeArgs'] type: The type of decryption
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_hips is not None:
            pulumi.set(__self__, "destination_hips", destination_hips)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if froms is not None:
            pulumi.set(__self__, "froms", froms)
        if log_fail is not None:
            pulumi.set(__self__, "log_fail", log_fail)
        if log_setting is not None:
            pulumi.set(__self__, "log_setting", log_setting)
        if log_success is not None:
            pulumi.set(__self__, "log_success", log_success)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if negate_destination is not None:
            pulumi.set(__self__, "negate_destination", negate_destination)
        if negate_source is not None:
            pulumi.set(__self__, "negate_source", negate_source)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if relative_position is not None:
            pulumi.set(__self__, "relative_position", relative_position)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if source_hips is not None:
            pulumi.set(__self__, "source_hips", source_hips)
        if source_users is not None:
            pulumi.set(__self__, "source_users", source_users)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_rule is not None:
            pulumi.set(__self__, "target_rule", target_rule)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)
        if tos is not None:
            pulumi.set(__self__, "tos", tos)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The action to be taken
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The destination URL category
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the decryption rule
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationHips")
    def destination_hips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The Host Integrity Profile of the destination host
        """
        return pulumi.get(self, "destination_hips")

    @destination_hips.setter
    def destination_hips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "destination_hips", value)

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The destination addresses
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "destinations", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the rule disabled?
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def froms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The source security zone
        """
        return pulumi.get(self, "froms")

    @froms.setter
    def froms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "froms", value)

    @_builtins.property
    @pulumi.getter(name="logFail")
    def log_fail(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Log failed decryption events?
        """
        return pulumi.get(self, "log_fail")

    @log_fail.setter
    def log_fail(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "log_fail", value)

    @_builtins.property
    @pulumi.getter(name="logSetting")
    def log_setting(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The log settings of the decryption rule
        """
        return pulumi.get(self, "log_setting")

    @log_setting.setter
    def log_setting(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_setting", value)

    @_builtins.property
    @pulumi.getter(name="logSuccess")
    def log_success(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Log successful decryption events?
        """
        return pulumi.get(self, "log_success")

    @log_success.setter
    def log_success(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "log_success", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the decryption rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="negateDestination")
    def negate_destination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Negate the destination addresses?
        """
        return pulumi.get(self, "negate_destination")

    @negate_destination.setter
    def negate_destination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "negate_destination", value)

    @_builtins.property
    @pulumi.getter(name="negateSource")
    def negate_source(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Negate the source addresses?
        """
        return pulumi.get(self, "negate_source")

    @negate_source.setter
    def negate_source(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "negate_source", value)

    @_builtins.property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The position of a security rule
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "position", value)

    @_builtins.property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The decryption profile associated with the decryption rule
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile", value)

    @_builtins.property
    @pulumi.getter(name="relativePosition")
    def relative_position(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Relative positioning rule. String must be one of these: `"before"`, `"after"`, `"top"`, `"bottom"`. If not specified, rule is created at the bottom of the ruleset.
        """
        return pulumi.get(self, "relative_position")

    @relative_position.setter
    def relative_position(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "relative_position", value)

    @_builtins.property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The destination services and/or service groups
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "services", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter(name="sourceHips")
    def source_hips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Source hip
        """
        return pulumi.get(self, "source_hips")

    @source_hips.setter
    def source_hips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "source_hips", value)

    @_builtins.property
    @pulumi.getter(name="sourceUsers")
    def source_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of source users and/or groups.  Reserved words include `any`, `pre-login`, `known-user`, and `unknown`.
        """
        return pulumi.get(self, "source_users")

    @source_users.setter
    def source_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "source_users", value)

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The source addresses
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sources", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The tags associated with the decryption rule
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="targetRule")
    def target_rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name or UUID of the rule to position this rule relative to. Required when `relative_position` is `"before"` or `"after"`.
        """
        return pulumi.get(self, "target_rule")

    @target_rule.setter
    def target_rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_rule", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)

    @_builtins.property
    @pulumi.getter
    def tos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The destination security zone
        """
        return pulumi.get(self, "tos")

    @tos.setter
    def tos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tos", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['DecryptionRuleTypeArgs']]:
        """
        The type of decryption
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['DecryptionRuleTypeArgs']]):
        pulumi.set(self, "type", value)


@pulumi.type_token("scm:index/decryptionRule:DecryptionRule")
class DecryptionRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_hips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 froms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_fail: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_setting: Optional[pulumi.Input[_builtins.str]] = None,
                 log_success: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 negate_destination: Optional[pulumi.Input[_builtins.bool]] = None,
                 negate_source: Optional[pulumi.Input[_builtins.bool]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 relative_position: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 source_hips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_rule: Optional[pulumi.Input[_builtins.str]] = None,
                 tos: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[Union['DecryptionRuleTypeArgs', 'DecryptionRuleTypeArgsDict']]] = None,
                 __props__=None):
        """
        DecryptionRule resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        # --- 1. TAG Resource ---
        decryption_position_tag = scm.Tag("decryption_position_tag",
            name="decryption-position-tag",
            folder="All",
            color="Purple")
        # --- 2. ANCHOR DECRYPTION RULE (Used for relative positioning) ---
        anchor_decryption_rule = scm.DecryptionRule("anchor_decryption_rule",
            name="anchor-decryption-rule",
            description="Base rule for testing 'before' and 'after' positioning.",
            folder="All",
            position="pre",
            action="decrypt",
            froms=["trust"],
            tos=["untrust"],
            sources=["any"],
            destinations=["any"],
            services=["service-https"],
            categories=["high-risk"],
            source_users=["any"],
            type={
                "ssl_forward_proxy": {},
            },
            destination_hips=["any"],
            tags=[decryption_position_tag.name],
            log_success=True,
            log_fail=True,
            disabled=False,
            negate_source=False,
            negate_destination=False)
        # --- 3. ABSOLUTE POSITIONING Examples ("top" and "bottom") ---
        rule_top_decryption_rule = scm.DecryptionRule("rule_top_decryption_rule",
            name="top-absolute-decryption-rule",
            description="Placed at the very TOP of the Decryption rulebase.",
            folder="All",
            position="pre",
            action="no-decrypt",
            relative_position="top",
            froms=["any"],
            tos=["any"],
            sources=["any"],
            destinations=["any"],
            services=["service-https"],
            categories=["high-risk"],
            source_users=["any"],
            type={
                "ssl_forward_proxy": {},
            })
        rule_bottom_decryption_rule = scm.DecryptionRule("rule_bottom_decryption_rule",
            name="bottom-absolute-decryption-rule",
            description="Placed at the very BOTTOM of the Decryption rulebase.",
            folder="All",
            position="pre",
            action="decrypt",
            relative_position="bottom",
            froms=["any"],
            tos=["any"],
            sources=["any"],
            destinations=["any"],
            services=["service-https"],
            categories=["high-risk"],
            source_users=["any"],
            type={
                "ssl_forward_proxy": {},
            })
        # --- 4. RELATIVE POSITIONING Examples ("before" and "after") ---
        rule_before_anchor_decryption = scm.DecryptionRule("rule_before_anchor_decryption",
            name="before-anchor-decryption-rule",
            description="Positioned immediately BEFORE the anchor-decryption-rule. Updating",
            folder="All",
            position="pre",
            action="decrypt",
            relative_position="before",
            target_rule=anchor_decryption_rule.id,
            froms=["trust"],
            tos=["untrust"],
            sources=["10.1.1.0/24"],
            destinations=["any"],
            services=["service-https"],
            categories=["high-risk"],
            source_users=["any"],
            type={
                "ssl_forward_proxy": {},
            })
        rule_after_anchor_decryption = scm.DecryptionRule("rule_after_anchor_decryption",
            name="after-anchor-decryption-rule_123",
            description="Positioned immediately AFTER the anchor-decryption-rule.",
            folder="All",
            position="pre",
            action="decrypt",
            relative_position="after",
            target_rule=anchor_decryption_rule.id,
            froms=["any"],
            tos=["untrust"],
            sources=["any"],
            destinations=["192.168.1.10"],
            services=["service-https"],
            categories=["any"],
            source_users=["any"],
            type={
                "ssl_forward_proxy": {},
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: The action to be taken
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] categories: The destination URL category
        :param pulumi.Input[_builtins.str] description: The description of the decryption rule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destination_hips: The Host Integrity Profile of the destination host
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destinations: The destination addresses
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.bool] disabled: Is the rule disabled?
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] froms: The source security zone
        :param pulumi.Input[_builtins.bool] log_fail: Log failed decryption events?
        :param pulumi.Input[_builtins.str] log_setting: The log settings of the decryption rule
        :param pulumi.Input[_builtins.bool] log_success: Log successful decryption events?
        :param pulumi.Input[_builtins.str] name: The name of the decryption rule
        :param pulumi.Input[_builtins.bool] negate_destination: Negate the destination addresses?
        :param pulumi.Input[_builtins.bool] negate_source: Negate the source addresses?
        :param pulumi.Input[_builtins.str] position: The position of a security rule
        :param pulumi.Input[_builtins.str] profile: The decryption profile associated with the decryption rule
        :param pulumi.Input[_builtins.str] relative_position: Relative positioning rule. String must be one of these: `"before"`, `"after"`, `"top"`, `"bottom"`. If not specified, rule is created at the bottom of the ruleset.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: The destination services and/or service groups
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_hips: Source hip
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_users: List of source users and/or groups.  Reserved words include `any`, `pre-login`, `known-user`, and `unknown`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sources: The source addresses
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags associated with the decryption rule
        :param pulumi.Input[_builtins.str] target_rule: The name or UUID of the rule to position this rule relative to. Required when `relative_position` is `"before"` or `"after"`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tos: The destination security zone
        :param pulumi.Input[Union['DecryptionRuleTypeArgs', 'DecryptionRuleTypeArgsDict']] type: The type of decryption
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DecryptionRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        DecryptionRule resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        # --- 1. TAG Resource ---
        decryption_position_tag = scm.Tag("decryption_position_tag",
            name="decryption-position-tag",
            folder="All",
            color="Purple")
        # --- 2. ANCHOR DECRYPTION RULE (Used for relative positioning) ---
        anchor_decryption_rule = scm.DecryptionRule("anchor_decryption_rule",
            name="anchor-decryption-rule",
            description="Base rule for testing 'before' and 'after' positioning.",
            folder="All",
            position="pre",
            action="decrypt",
            froms=["trust"],
            tos=["untrust"],
            sources=["any"],
            destinations=["any"],
            services=["service-https"],
            categories=["high-risk"],
            source_users=["any"],
            type={
                "ssl_forward_proxy": {},
            },
            destination_hips=["any"],
            tags=[decryption_position_tag.name],
            log_success=True,
            log_fail=True,
            disabled=False,
            negate_source=False,
            negate_destination=False)
        # --- 3. ABSOLUTE POSITIONING Examples ("top" and "bottom") ---
        rule_top_decryption_rule = scm.DecryptionRule("rule_top_decryption_rule",
            name="top-absolute-decryption-rule",
            description="Placed at the very TOP of the Decryption rulebase.",
            folder="All",
            position="pre",
            action="no-decrypt",
            relative_position="top",
            froms=["any"],
            tos=["any"],
            sources=["any"],
            destinations=["any"],
            services=["service-https"],
            categories=["high-risk"],
            source_users=["any"],
            type={
                "ssl_forward_proxy": {},
            })
        rule_bottom_decryption_rule = scm.DecryptionRule("rule_bottom_decryption_rule",
            name="bottom-absolute-decryption-rule",
            description="Placed at the very BOTTOM of the Decryption rulebase.",
            folder="All",
            position="pre",
            action="decrypt",
            relative_position="bottom",
            froms=["any"],
            tos=["any"],
            sources=["any"],
            destinations=["any"],
            services=["service-https"],
            categories=["high-risk"],
            source_users=["any"],
            type={
                "ssl_forward_proxy": {},
            })
        # --- 4. RELATIVE POSITIONING Examples ("before" and "after") ---
        rule_before_anchor_decryption = scm.DecryptionRule("rule_before_anchor_decryption",
            name="before-anchor-decryption-rule",
            description="Positioned immediately BEFORE the anchor-decryption-rule. Updating",
            folder="All",
            position="pre",
            action="decrypt",
            relative_position="before",
            target_rule=anchor_decryption_rule.id,
            froms=["trust"],
            tos=["untrust"],
            sources=["10.1.1.0/24"],
            destinations=["any"],
            services=["service-https"],
            categories=["high-risk"],
            source_users=["any"],
            type={
                "ssl_forward_proxy": {},
            })
        rule_after_anchor_decryption = scm.DecryptionRule("rule_after_anchor_decryption",
            name="after-anchor-decryption-rule_123",
            description="Positioned immediately AFTER the anchor-decryption-rule.",
            folder="All",
            position="pre",
            action="decrypt",
            relative_position="after",
            target_rule=anchor_decryption_rule.id,
            froms=["any"],
            tos=["untrust"],
            sources=["any"],
            destinations=["192.168.1.10"],
            services=["service-https"],
            categories=["any"],
            source_users=["any"],
            type={
                "ssl_forward_proxy": {},
            })
        ```

        :param str resource_name: The name of the resource.
        :param DecryptionRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DecryptionRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_hips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 froms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_fail: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_setting: Optional[pulumi.Input[_builtins.str]] = None,
                 log_success: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 negate_destination: Optional[pulumi.Input[_builtins.bool]] = None,
                 negate_source: Optional[pulumi.Input[_builtins.bool]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 relative_position: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 source_hips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_rule: Optional[pulumi.Input[_builtins.str]] = None,
                 tos: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[Union['DecryptionRuleTypeArgs', 'DecryptionRuleTypeArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DecryptionRuleArgs.__new__(DecryptionRuleArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            if categories is None and not opts.urn:
                raise TypeError("Missing required property 'categories'")
            __props__.__dict__["categories"] = categories
            __props__.__dict__["description"] = description
            __props__.__dict__["destination_hips"] = destination_hips
            if destinations is None and not opts.urn:
                raise TypeError("Missing required property 'destinations'")
            __props__.__dict__["destinations"] = destinations
            __props__.__dict__["device"] = device
            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["folder"] = folder
            if froms is None and not opts.urn:
                raise TypeError("Missing required property 'froms'")
            __props__.__dict__["froms"] = froms
            __props__.__dict__["log_fail"] = log_fail
            __props__.__dict__["log_setting"] = log_setting
            __props__.__dict__["log_success"] = log_success
            __props__.__dict__["name"] = name
            __props__.__dict__["negate_destination"] = negate_destination
            __props__.__dict__["negate_source"] = negate_source
            __props__.__dict__["position"] = position
            __props__.__dict__["profile"] = profile
            __props__.__dict__["relative_position"] = relative_position
            if services is None and not opts.urn:
                raise TypeError("Missing required property 'services'")
            __props__.__dict__["services"] = services
            __props__.__dict__["snippet"] = snippet
            __props__.__dict__["source_hips"] = source_hips
            if source_users is None and not opts.urn:
                raise TypeError("Missing required property 'source_users'")
            __props__.__dict__["source_users"] = source_users
            if sources is None and not opts.urn:
                raise TypeError("Missing required property 'sources'")
            __props__.__dict__["sources"] = sources
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target_rule"] = target_rule
            if tos is None and not opts.urn:
                raise TypeError("Missing required property 'tos'")
            __props__.__dict__["tos"] = tos
            __props__.__dict__["type"] = type
            __props__.__dict__["tfid"] = None
        super(DecryptionRule, __self__).__init__(
            'scm:index/decryptionRule:DecryptionRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[_builtins.str]] = None,
            categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destination_hips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            froms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            log_fail: Optional[pulumi.Input[_builtins.bool]] = None,
            log_setting: Optional[pulumi.Input[_builtins.str]] = None,
            log_success: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            negate_destination: Optional[pulumi.Input[_builtins.bool]] = None,
            negate_source: Optional[pulumi.Input[_builtins.bool]] = None,
            position: Optional[pulumi.Input[_builtins.str]] = None,
            profile: Optional[pulumi.Input[_builtins.str]] = None,
            relative_position: Optional[pulumi.Input[_builtins.str]] = None,
            services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            source_hips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            source_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            target_rule: Optional[pulumi.Input[_builtins.str]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None,
            tos: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[Union['DecryptionRuleTypeArgs', 'DecryptionRuleTypeArgsDict']]] = None) -> 'DecryptionRule':
        """
        Get an existing DecryptionRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: The action to be taken
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] categories: The destination URL category
        :param pulumi.Input[_builtins.str] description: The description of the decryption rule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destination_hips: The Host Integrity Profile of the destination host
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destinations: The destination addresses
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.bool] disabled: Is the rule disabled?
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] froms: The source security zone
        :param pulumi.Input[_builtins.bool] log_fail: Log failed decryption events?
        :param pulumi.Input[_builtins.str] log_setting: The log settings of the decryption rule
        :param pulumi.Input[_builtins.bool] log_success: Log successful decryption events?
        :param pulumi.Input[_builtins.str] name: The name of the decryption rule
        :param pulumi.Input[_builtins.bool] negate_destination: Negate the destination addresses?
        :param pulumi.Input[_builtins.bool] negate_source: Negate the source addresses?
        :param pulumi.Input[_builtins.str] position: The position of a security rule
        :param pulumi.Input[_builtins.str] profile: The decryption profile associated with the decryption rule
        :param pulumi.Input[_builtins.str] relative_position: Relative positioning rule. String must be one of these: `"before"`, `"after"`, `"top"`, `"bottom"`. If not specified, rule is created at the bottom of the ruleset.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: The destination services and/or service groups
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_hips: Source hip
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_users: List of source users and/or groups.  Reserved words include `any`, `pre-login`, `known-user`, and `unknown`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sources: The source addresses
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags associated with the decryption rule
        :param pulumi.Input[_builtins.str] target_rule: The name or UUID of the rule to position this rule relative to. Required when `relative_position` is `"before"` or `"after"`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tos: The destination security zone
        :param pulumi.Input[Union['DecryptionRuleTypeArgs', 'DecryptionRuleTypeArgsDict']] type: The type of decryption
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DecryptionRuleState.__new__(_DecryptionRuleState)

        __props__.__dict__["action"] = action
        __props__.__dict__["categories"] = categories
        __props__.__dict__["description"] = description
        __props__.__dict__["destination_hips"] = destination_hips
        __props__.__dict__["destinations"] = destinations
        __props__.__dict__["device"] = device
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["folder"] = folder
        __props__.__dict__["froms"] = froms
        __props__.__dict__["log_fail"] = log_fail
        __props__.__dict__["log_setting"] = log_setting
        __props__.__dict__["log_success"] = log_success
        __props__.__dict__["name"] = name
        __props__.__dict__["negate_destination"] = negate_destination
        __props__.__dict__["negate_source"] = negate_source
        __props__.__dict__["position"] = position
        __props__.__dict__["profile"] = profile
        __props__.__dict__["relative_position"] = relative_position
        __props__.__dict__["services"] = services
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["source_hips"] = source_hips
        __props__.__dict__["source_users"] = source_users
        __props__.__dict__["sources"] = sources
        __props__.__dict__["tags"] = tags
        __props__.__dict__["target_rule"] = target_rule
        __props__.__dict__["tfid"] = tfid
        __props__.__dict__["tos"] = tos
        __props__.__dict__["type"] = type
        return DecryptionRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[_builtins.str]:
        """
        The action to be taken
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The destination URL category
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the decryption rule
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationHips")
    def destination_hips(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The Host Integrity Profile of the destination host
        """
        return pulumi.get(self, "destination_hips")

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The destination addresses
        """
        return pulumi.get(self, "destinations")

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is the rule disabled?
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def froms(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The source security zone
        """
        return pulumi.get(self, "froms")

    @_builtins.property
    @pulumi.getter(name="logFail")
    def log_fail(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Log failed decryption events?
        """
        return pulumi.get(self, "log_fail")

    @_builtins.property
    @pulumi.getter(name="logSetting")
    def log_setting(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The log settings of the decryption rule
        """
        return pulumi.get(self, "log_setting")

    @_builtins.property
    @pulumi.getter(name="logSuccess")
    def log_success(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Log successful decryption events?
        """
        return pulumi.get(self, "log_success")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the decryption rule
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="negateDestination")
    def negate_destination(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Negate the destination addresses?
        """
        return pulumi.get(self, "negate_destination")

    @_builtins.property
    @pulumi.getter(name="negateSource")
    def negate_source(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Negate the source addresses?
        """
        return pulumi.get(self, "negate_source")

    @_builtins.property
    @pulumi.getter
    def position(self) -> pulumi.Output[_builtins.str]:
        """
        The position of a security rule
        """
        return pulumi.get(self, "position")

    @_builtins.property
    @pulumi.getter
    def profile(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The decryption profile associated with the decryption rule
        """
        return pulumi.get(self, "profile")

    @_builtins.property
    @pulumi.getter(name="relativePosition")
    def relative_position(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Relative positioning rule. String must be one of these: `"before"`, `"after"`, `"top"`, `"bottom"`. If not specified, rule is created at the bottom of the ruleset.
        """
        return pulumi.get(self, "relative_position")

    @_builtins.property
    @pulumi.getter
    def services(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The destination services and/or service groups
        """
        return pulumi.get(self, "services")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter(name="sourceHips")
    def source_hips(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Source hip
        """
        return pulumi.get(self, "source_hips")

    @_builtins.property
    @pulumi.getter(name="sourceUsers")
    def source_users(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of source users and/or groups.  Reserved words include `any`, `pre-login`, `known-user`, and `unknown`.
        """
        return pulumi.get(self, "source_users")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The source addresses
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The tags associated with the decryption rule
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="targetRule")
    def target_rule(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name or UUID of the rule to position this rule relative to. Required when `relative_position` is `"before"` or `"after"`.
        """
        return pulumi.get(self, "target_rule")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter
    def tos(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The destination security zone
        """
        return pulumi.get(self, "tos")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional['outputs.DecryptionRuleType']]:
        """
        The type of decryption
        """
        return pulumi.get(self, "type")

