# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EthernetInterfaceArgs', 'EthernetInterface']

@pulumi.input_type
class EthernetInterfaceArgs:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 default_value: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 layer2: Optional[pulumi.Input['EthernetInterfaceLayer2Args']] = None,
                 layer3: Optional[pulumi.Input['EthernetInterfaceLayer3Args']] = None,
                 link_duplex: Optional[pulumi.Input[_builtins.str]] = None,
                 link_speed: Optional[pulumi.Input[_builtins.str]] = None,
                 link_state: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 poe: Optional[pulumi.Input['EthernetInterfacePoeArgs']] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 tap: Optional[pulumi.Input['EthernetInterfaceTapArgs']] = None):
        """
        The set of arguments for constructing a EthernetInterface resource.
        :param pulumi.Input[_builtins.str] comment: Interface description
        :param pulumi.Input[_builtins.str] default_value: Default interface assignment
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input['EthernetInterfaceLayer2Args'] layer2: Layer2
        :param pulumi.Input['EthernetInterfaceLayer3Args'] layer3: Ethernet Interface Layer 3 configuration
        :param pulumi.Input[_builtins.str] link_duplex: Link duplex
        :param pulumi.Input[_builtins.str] link_speed: Link speed
        :param pulumi.Input[_builtins.str] link_state: Link state
        :param pulumi.Input[_builtins.str] name: Interface name
        :param pulumi.Input['EthernetInterfacePoeArgs'] poe: Poe
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input['EthernetInterfaceTapArgs'] tap: Tap
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if layer2 is not None:
            pulumi.set(__self__, "layer2", layer2)
        if layer3 is not None:
            pulumi.set(__self__, "layer3", layer3)
        if link_duplex is not None:
            pulumi.set(__self__, "link_duplex", link_duplex)
        if link_speed is not None:
            pulumi.set(__self__, "link_speed", link_speed)
        if link_state is not None:
            pulumi.set(__self__, "link_state", link_state)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if poe is not None:
            pulumi.set(__self__, "poe", poe)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if tap is not None:
            pulumi.set(__self__, "tap", tap)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Interface description
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default interface assignment
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_value", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def layer2(self) -> Optional[pulumi.Input['EthernetInterfaceLayer2Args']]:
        """
        Layer2
        """
        return pulumi.get(self, "layer2")

    @layer2.setter
    def layer2(self, value: Optional[pulumi.Input['EthernetInterfaceLayer2Args']]):
        pulumi.set(self, "layer2", value)

    @_builtins.property
    @pulumi.getter
    def layer3(self) -> Optional[pulumi.Input['EthernetInterfaceLayer3Args']]:
        """
        Ethernet Interface Layer 3 configuration
        """
        return pulumi.get(self, "layer3")

    @layer3.setter
    def layer3(self, value: Optional[pulumi.Input['EthernetInterfaceLayer3Args']]):
        pulumi.set(self, "layer3", value)

    @_builtins.property
    @pulumi.getter(name="linkDuplex")
    def link_duplex(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Link duplex
        """
        return pulumi.get(self, "link_duplex")

    @link_duplex.setter
    def link_duplex(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "link_duplex", value)

    @_builtins.property
    @pulumi.getter(name="linkSpeed")
    def link_speed(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Link speed
        """
        return pulumi.get(self, "link_speed")

    @link_speed.setter
    def link_speed(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "link_speed", value)

    @_builtins.property
    @pulumi.getter(name="linkState")
    def link_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Link state
        """
        return pulumi.get(self, "link_state")

    @link_state.setter
    def link_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "link_state", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Interface name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def poe(self) -> Optional[pulumi.Input['EthernetInterfacePoeArgs']]:
        """
        Poe
        """
        return pulumi.get(self, "poe")

    @poe.setter
    def poe(self, value: Optional[pulumi.Input['EthernetInterfacePoeArgs']]):
        pulumi.set(self, "poe", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def tap(self) -> Optional[pulumi.Input['EthernetInterfaceTapArgs']]:
        """
        Tap
        """
        return pulumi.get(self, "tap")

    @tap.setter
    def tap(self, value: Optional[pulumi.Input['EthernetInterfaceTapArgs']]):
        pulumi.set(self, "tap", value)


@pulumi.input_type
class _EthernetInterfaceState:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 default_value: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypted_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 layer2: Optional[pulumi.Input['EthernetInterfaceLayer2Args']] = None,
                 layer3: Optional[pulumi.Input['EthernetInterfaceLayer3Args']] = None,
                 link_duplex: Optional[pulumi.Input[_builtins.str]] = None,
                 link_speed: Optional[pulumi.Input[_builtins.str]] = None,
                 link_state: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 poe: Optional[pulumi.Input['EthernetInterfacePoeArgs']] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 tap: Optional[pulumi.Input['EthernetInterfaceTapArgs']] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EthernetInterface resources.
        :param pulumi.Input[_builtins.str] comment: Interface description
        :param pulumi.Input[_builtins.str] default_value: Default interface assignment
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] encrypted_values: Map of sensitive values returned from the API.
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input['EthernetInterfaceLayer2Args'] layer2: Layer2
        :param pulumi.Input['EthernetInterfaceLayer3Args'] layer3: Ethernet Interface Layer 3 configuration
        :param pulumi.Input[_builtins.str] link_duplex: Link duplex
        :param pulumi.Input[_builtins.str] link_speed: Link speed
        :param pulumi.Input[_builtins.str] link_state: Link state
        :param pulumi.Input[_builtins.str] name: Interface name
        :param pulumi.Input['EthernetInterfacePoeArgs'] poe: Poe
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input['EthernetInterfaceTapArgs'] tap: Tap
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if encrypted_values is not None:
            pulumi.set(__self__, "encrypted_values", encrypted_values)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if layer2 is not None:
            pulumi.set(__self__, "layer2", layer2)
        if layer3 is not None:
            pulumi.set(__self__, "layer3", layer3)
        if link_duplex is not None:
            pulumi.set(__self__, "link_duplex", link_duplex)
        if link_speed is not None:
            pulumi.set(__self__, "link_speed", link_speed)
        if link_state is not None:
            pulumi.set(__self__, "link_state", link_state)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if poe is not None:
            pulumi.set(__self__, "poe", poe)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if tap is not None:
            pulumi.set(__self__, "tap", tap)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Interface description
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default interface assignment
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_value", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter(name="encryptedValues")
    def encrypted_values(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of sensitive values returned from the API.
        """
        return pulumi.get(self, "encrypted_values")

    @encrypted_values.setter
    def encrypted_values(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "encrypted_values", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def layer2(self) -> Optional[pulumi.Input['EthernetInterfaceLayer2Args']]:
        """
        Layer2
        """
        return pulumi.get(self, "layer2")

    @layer2.setter
    def layer2(self, value: Optional[pulumi.Input['EthernetInterfaceLayer2Args']]):
        pulumi.set(self, "layer2", value)

    @_builtins.property
    @pulumi.getter
    def layer3(self) -> Optional[pulumi.Input['EthernetInterfaceLayer3Args']]:
        """
        Ethernet Interface Layer 3 configuration
        """
        return pulumi.get(self, "layer3")

    @layer3.setter
    def layer3(self, value: Optional[pulumi.Input['EthernetInterfaceLayer3Args']]):
        pulumi.set(self, "layer3", value)

    @_builtins.property
    @pulumi.getter(name="linkDuplex")
    def link_duplex(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Link duplex
        """
        return pulumi.get(self, "link_duplex")

    @link_duplex.setter
    def link_duplex(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "link_duplex", value)

    @_builtins.property
    @pulumi.getter(name="linkSpeed")
    def link_speed(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Link speed
        """
        return pulumi.get(self, "link_speed")

    @link_speed.setter
    def link_speed(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "link_speed", value)

    @_builtins.property
    @pulumi.getter(name="linkState")
    def link_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Link state
        """
        return pulumi.get(self, "link_state")

    @link_state.setter
    def link_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "link_state", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Interface name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def poe(self) -> Optional[pulumi.Input['EthernetInterfacePoeArgs']]:
        """
        Poe
        """
        return pulumi.get(self, "poe")

    @poe.setter
    def poe(self, value: Optional[pulumi.Input['EthernetInterfacePoeArgs']]):
        pulumi.set(self, "poe", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def tap(self) -> Optional[pulumi.Input['EthernetInterfaceTapArgs']]:
        """
        Tap
        """
        return pulumi.get(self, "tap")

    @tap.setter
    def tap(self, value: Optional[pulumi.Input['EthernetInterfaceTapArgs']]):
        pulumi.set(self, "tap", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)


@pulumi.type_token("scm:index/ethernetInterface:EthernetInterface")
class EthernetInterface(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 default_value: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 layer2: Optional[pulumi.Input[Union['EthernetInterfaceLayer2Args', 'EthernetInterfaceLayer2ArgsDict']]] = None,
                 layer3: Optional[pulumi.Input[Union['EthernetInterfaceLayer3Args', 'EthernetInterfaceLayer3ArgsDict']]] = None,
                 link_duplex: Optional[pulumi.Input[_builtins.str]] = None,
                 link_speed: Optional[pulumi.Input[_builtins.str]] = None,
                 link_state: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 poe: Optional[pulumi.Input[Union['EthernetInterfacePoeArgs', 'EthernetInterfacePoeArgsDict']]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 tap: Optional[pulumi.Input[Union['EthernetInterfaceTapArgs', 'EthernetInterfaceTapArgsDict']]] = None,
                 __props__=None):
        """
        EthernetInterface resource

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Interface description
        :param pulumi.Input[_builtins.str] default_value: Default interface assignment
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[Union['EthernetInterfaceLayer2Args', 'EthernetInterfaceLayer2ArgsDict']] layer2: Layer2
        :param pulumi.Input[Union['EthernetInterfaceLayer3Args', 'EthernetInterfaceLayer3ArgsDict']] layer3: Ethernet Interface Layer 3 configuration
        :param pulumi.Input[_builtins.str] link_duplex: Link duplex
        :param pulumi.Input[_builtins.str] link_speed: Link speed
        :param pulumi.Input[_builtins.str] link_state: Link state
        :param pulumi.Input[_builtins.str] name: Interface name
        :param pulumi.Input[Union['EthernetInterfacePoeArgs', 'EthernetInterfacePoeArgsDict']] poe: Poe
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Union['EthernetInterfaceTapArgs', 'EthernetInterfaceTapArgsDict']] tap: Tap
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[EthernetInterfaceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        EthernetInterface resource

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param EthernetInterfaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EthernetInterfaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 default_value: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 layer2: Optional[pulumi.Input[Union['EthernetInterfaceLayer2Args', 'EthernetInterfaceLayer2ArgsDict']]] = None,
                 layer3: Optional[pulumi.Input[Union['EthernetInterfaceLayer3Args', 'EthernetInterfaceLayer3ArgsDict']]] = None,
                 link_duplex: Optional[pulumi.Input[_builtins.str]] = None,
                 link_speed: Optional[pulumi.Input[_builtins.str]] = None,
                 link_state: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 poe: Optional[pulumi.Input[Union['EthernetInterfacePoeArgs', 'EthernetInterfacePoeArgsDict']]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 tap: Optional[pulumi.Input[Union['EthernetInterfaceTapArgs', 'EthernetInterfaceTapArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EthernetInterfaceArgs.__new__(EthernetInterfaceArgs)

            __props__.__dict__["comment"] = comment
            __props__.__dict__["default_value"] = default_value
            __props__.__dict__["device"] = device
            __props__.__dict__["folder"] = folder
            __props__.__dict__["layer2"] = layer2
            __props__.__dict__["layer3"] = layer3
            __props__.__dict__["link_duplex"] = link_duplex
            __props__.__dict__["link_speed"] = link_speed
            __props__.__dict__["link_state"] = link_state
            __props__.__dict__["name"] = name
            __props__.__dict__["poe"] = poe
            __props__.__dict__["snippet"] = snippet
            __props__.__dict__["tap"] = tap
            __props__.__dict__["encrypted_values"] = None
            __props__.__dict__["tfid"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["encryptedValues"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(EthernetInterface, __self__).__init__(
            'scm:index/ethernetInterface:EthernetInterface',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            default_value: Optional[pulumi.Input[_builtins.str]] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            encrypted_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            layer2: Optional[pulumi.Input[Union['EthernetInterfaceLayer2Args', 'EthernetInterfaceLayer2ArgsDict']]] = None,
            layer3: Optional[pulumi.Input[Union['EthernetInterfaceLayer3Args', 'EthernetInterfaceLayer3ArgsDict']]] = None,
            link_duplex: Optional[pulumi.Input[_builtins.str]] = None,
            link_speed: Optional[pulumi.Input[_builtins.str]] = None,
            link_state: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            poe: Optional[pulumi.Input[Union['EthernetInterfacePoeArgs', 'EthernetInterfacePoeArgsDict']]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            tap: Optional[pulumi.Input[Union['EthernetInterfaceTapArgs', 'EthernetInterfaceTapArgsDict']]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None) -> 'EthernetInterface':
        """
        Get an existing EthernetInterface resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Interface description
        :param pulumi.Input[_builtins.str] default_value: Default interface assignment
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] encrypted_values: Map of sensitive values returned from the API.
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[Union['EthernetInterfaceLayer2Args', 'EthernetInterfaceLayer2ArgsDict']] layer2: Layer2
        :param pulumi.Input[Union['EthernetInterfaceLayer3Args', 'EthernetInterfaceLayer3ArgsDict']] layer3: Ethernet Interface Layer 3 configuration
        :param pulumi.Input[_builtins.str] link_duplex: Link duplex
        :param pulumi.Input[_builtins.str] link_speed: Link speed
        :param pulumi.Input[_builtins.str] link_state: Link state
        :param pulumi.Input[_builtins.str] name: Interface name
        :param pulumi.Input[Union['EthernetInterfacePoeArgs', 'EthernetInterfacePoeArgsDict']] poe: Poe
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Union['EthernetInterfaceTapArgs', 'EthernetInterfaceTapArgsDict']] tap: Tap
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EthernetInterfaceState.__new__(_EthernetInterfaceState)

        __props__.__dict__["comment"] = comment
        __props__.__dict__["default_value"] = default_value
        __props__.__dict__["device"] = device
        __props__.__dict__["encrypted_values"] = encrypted_values
        __props__.__dict__["folder"] = folder
        __props__.__dict__["layer2"] = layer2
        __props__.__dict__["layer3"] = layer3
        __props__.__dict__["link_duplex"] = link_duplex
        __props__.__dict__["link_speed"] = link_speed
        __props__.__dict__["link_state"] = link_state
        __props__.__dict__["name"] = name
        __props__.__dict__["poe"] = poe
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["tap"] = tap
        __props__.__dict__["tfid"] = tfid
        return EthernetInterface(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Interface description
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Default interface assignment
        """
        return pulumi.get(self, "default_value")

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter(name="encryptedValues")
    def encrypted_values(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of sensitive values returned from the API.
        """
        return pulumi.get(self, "encrypted_values")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def layer2(self) -> pulumi.Output[Optional['outputs.EthernetInterfaceLayer2']]:
        """
        Layer2
        """
        return pulumi.get(self, "layer2")

    @_builtins.property
    @pulumi.getter
    def layer3(self) -> pulumi.Output['outputs.EthernetInterfaceLayer3']:
        """
        Ethernet Interface Layer 3 configuration
        """
        return pulumi.get(self, "layer3")

    @_builtins.property
    @pulumi.getter(name="linkDuplex")
    def link_duplex(self) -> pulumi.Output[_builtins.str]:
        """
        Link duplex
        """
        return pulumi.get(self, "link_duplex")

    @_builtins.property
    @pulumi.getter(name="linkSpeed")
    def link_speed(self) -> pulumi.Output[_builtins.str]:
        """
        Link speed
        """
        return pulumi.get(self, "link_speed")

    @_builtins.property
    @pulumi.getter(name="linkState")
    def link_state(self) -> pulumi.Output[_builtins.str]:
        """
        Link state
        """
        return pulumi.get(self, "link_state")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Interface name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def poe(self) -> pulumi.Output['outputs.EthernetInterfacePoe']:
        """
        Poe
        """
        return pulumi.get(self, "poe")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tap(self) -> pulumi.Output[Optional['outputs.EthernetInterfaceTap']]:
        """
        Tap
        """
        return pulumi.get(self, "tap")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

