# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExternalDynamicListArgs', 'ExternalDynamicList']

@pulumi.input_type
class ExternalDynamicListArgs:
    def __init__(__self__, *,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input['ExternalDynamicListTypeArgs']] = None):
        """
        The set of arguments for constructing a ExternalDynamicList resource.
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: The name of the external dynamic list
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input['ExternalDynamicListTypeArgs'] type: Type
        """
        if device is not None:
            pulumi.set(__self__, "device", device)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the external dynamic list
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ExternalDynamicListTypeArgs']]:
        """
        Type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ExternalDynamicListTypeArgs']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _ExternalDynamicListState:
    def __init__(__self__, *,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypted_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input['ExternalDynamicListTypeArgs']] = None):
        """
        Input properties used for looking up and filtering ExternalDynamicList resources.
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] encrypted_values: Map of sensitive values returned from the API.
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: The name of the external dynamic list
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input['ExternalDynamicListTypeArgs'] type: Type
        """
        if device is not None:
            pulumi.set(__self__, "device", device)
        if encrypted_values is not None:
            pulumi.set(__self__, "encrypted_values", encrypted_values)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter(name="encryptedValues")
    def encrypted_values(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of sensitive values returned from the API.
        """
        return pulumi.get(self, "encrypted_values")

    @encrypted_values.setter
    def encrypted_values(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "encrypted_values", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the external dynamic list
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ExternalDynamicListTypeArgs']]:
        """
        Type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ExternalDynamicListTypeArgs']]):
        pulumi.set(self, "type", value)


@pulumi.type_token("scm:index/externalDynamicList:ExternalDynamicList")
class ExternalDynamicList(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[Union['ExternalDynamicListTypeArgs', 'ExternalDynamicListTypeArgsDict']]] = None,
                 __props__=None):
        """
        ExternalDynamicList resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        # This resource creates a domain-based External Dynamic List (EDL).
        # The EDL will fetch a list of domains from the specified URL daily.
        scm_edl1 = scm.ExternalDynamicList("scm_edl_1",
            folder="All",
            name="scm_edl_1",
            type={
                "domain": {
                    "description": "List of malicious domains to block, updated daily.",
                    "url": "http://some-threat-feed.com/domains.txt",
                    "recurring": {
                        "daily": {
                            "at": "03",
                        },
                    },
                },
            })
        scm_edl2 = scm.ExternalDynamicList("scm_edl_2",
            folder="All",
            name="scm_edl_2",
            type={
                "ip": {
                    "description": "IP threat feed with basic auth, updated hourly.",
                    "url": "https://threats.example.com/ips.txt",
                    "recurring": {
                        "hourly": {},
                    },
                },
            })
        scm_edl3 = scm.ExternalDynamicList("scm_edl_3",
            folder="All",
            name="scm_edl_3",
            type={
                "url": {
                    "description": "List of phishing URLs, updated every Monday at 2 AM.",
                    "url": "https://phish-block.example.com/urls.txt",
                    "recurring": {
                        "weekly": {
                            "day_of_week": "monday",
                            "at": "02",
                        },
                    },
                },
            })
        scm_edl4 = scm.ExternalDynamicList("scm_edl_4",
            folder="All",
            name="scm_edl_4",
            type={
                "predefined_ip": {
                    "description": "Palo Alto Networks-provided list of high-risk IP addresses.",
                    "url": "panw-highrisk-ip-list",
                },
            })
        scm_edl5 = scm.ExternalDynamicList("scm_edl_5",
            folder="All",
            name="scm_edl_5",
            type={
                "ip": {
                    "description": "IP threat feed that requires authentication.",
                    "url": "https://secure-feed.example.com/ips.txt",
                    "certificate_profile": "test-cert-list-qekwys",
                    "auth": {
                        "username": "my-api-user",
                        "password": "a-very-secret-password-123!",
                    },
                    "recurring": {
                        "five_minute": {},
                    },
                },
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: The name of the external dynamic list
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Union['ExternalDynamicListTypeArgs', 'ExternalDynamicListTypeArgsDict']] type: Type
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ExternalDynamicListArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ExternalDynamicList resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        # This resource creates a domain-based External Dynamic List (EDL).
        # The EDL will fetch a list of domains from the specified URL daily.
        scm_edl1 = scm.ExternalDynamicList("scm_edl_1",
            folder="All",
            name="scm_edl_1",
            type={
                "domain": {
                    "description": "List of malicious domains to block, updated daily.",
                    "url": "http://some-threat-feed.com/domains.txt",
                    "recurring": {
                        "daily": {
                            "at": "03",
                        },
                    },
                },
            })
        scm_edl2 = scm.ExternalDynamicList("scm_edl_2",
            folder="All",
            name="scm_edl_2",
            type={
                "ip": {
                    "description": "IP threat feed with basic auth, updated hourly.",
                    "url": "https://threats.example.com/ips.txt",
                    "recurring": {
                        "hourly": {},
                    },
                },
            })
        scm_edl3 = scm.ExternalDynamicList("scm_edl_3",
            folder="All",
            name="scm_edl_3",
            type={
                "url": {
                    "description": "List of phishing URLs, updated every Monday at 2 AM.",
                    "url": "https://phish-block.example.com/urls.txt",
                    "recurring": {
                        "weekly": {
                            "day_of_week": "monday",
                            "at": "02",
                        },
                    },
                },
            })
        scm_edl4 = scm.ExternalDynamicList("scm_edl_4",
            folder="All",
            name="scm_edl_4",
            type={
                "predefined_ip": {
                    "description": "Palo Alto Networks-provided list of high-risk IP addresses.",
                    "url": "panw-highrisk-ip-list",
                },
            })
        scm_edl5 = scm.ExternalDynamicList("scm_edl_5",
            folder="All",
            name="scm_edl_5",
            type={
                "ip": {
                    "description": "IP threat feed that requires authentication.",
                    "url": "https://secure-feed.example.com/ips.txt",
                    "certificate_profile": "test-cert-list-qekwys",
                    "auth": {
                        "username": "my-api-user",
                        "password": "a-very-secret-password-123!",
                    },
                    "recurring": {
                        "five_minute": {},
                    },
                },
            })
        ```

        :param str resource_name: The name of the resource.
        :param ExternalDynamicListArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExternalDynamicListArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[Union['ExternalDynamicListTypeArgs', 'ExternalDynamicListTypeArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExternalDynamicListArgs.__new__(ExternalDynamicListArgs)

            __props__.__dict__["device"] = device
            __props__.__dict__["folder"] = folder
            __props__.__dict__["name"] = name
            __props__.__dict__["snippet"] = snippet
            __props__.__dict__["type"] = type
            __props__.__dict__["encrypted_values"] = None
            __props__.__dict__["tfid"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["encryptedValues"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ExternalDynamicList, __self__).__init__(
            'scm:index/externalDynamicList:ExternalDynamicList',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            encrypted_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[Union['ExternalDynamicListTypeArgs', 'ExternalDynamicListTypeArgsDict']]] = None) -> 'ExternalDynamicList':
        """
        Get an existing ExternalDynamicList resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] encrypted_values: Map of sensitive values returned from the API.
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: The name of the external dynamic list
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Union['ExternalDynamicListTypeArgs', 'ExternalDynamicListTypeArgsDict']] type: Type
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExternalDynamicListState.__new__(_ExternalDynamicListState)

        __props__.__dict__["device"] = device
        __props__.__dict__["encrypted_values"] = encrypted_values
        __props__.__dict__["folder"] = folder
        __props__.__dict__["name"] = name
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["tfid"] = tfid
        __props__.__dict__["type"] = type
        return ExternalDynamicList(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter(name="encryptedValues")
    def encrypted_values(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of sensitive values returned from the API.
        """
        return pulumi.get(self, "encrypted_values")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the external dynamic list
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output['outputs.ExternalDynamicListType']:
        """
        Type
        """
        return pulumi.get(self, "type")

