# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetInterfaceManagementProfileResult',
    'AwaitableGetInterfaceManagementProfileResult',
    'get_interface_management_profile',
    'get_interface_management_profile_output',
]

@pulumi.output_type
class GetInterfaceManagementProfileResult:
    """
    A collection of values returned by getInterfaceManagementProfile.
    """
    def __init__(__self__, device=None, folder=None, http=None, http_ocsp=None, https=None, id=None, name=None, permitted_ips=None, ping=None, response_pages=None, snippet=None, ssh=None, telnet=None, tfid=None, userid_service=None, userid_syslog_listener_ssl=None, userid_syslog_listener_udp=None):
        if device and not isinstance(device, str):
            raise TypeError("Expected argument 'device' to be a str")
        pulumi.set(__self__, "device", device)
        if folder and not isinstance(folder, str):
            raise TypeError("Expected argument 'folder' to be a str")
        pulumi.set(__self__, "folder", folder)
        if http and not isinstance(http, bool):
            raise TypeError("Expected argument 'http' to be a bool")
        pulumi.set(__self__, "http", http)
        if http_ocsp and not isinstance(http_ocsp, bool):
            raise TypeError("Expected argument 'http_ocsp' to be a bool")
        pulumi.set(__self__, "http_ocsp", http_ocsp)
        if https and not isinstance(https, bool):
            raise TypeError("Expected argument 'https' to be a bool")
        pulumi.set(__self__, "https", https)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if permitted_ips and not isinstance(permitted_ips, list):
            raise TypeError("Expected argument 'permitted_ips' to be a list")
        pulumi.set(__self__, "permitted_ips", permitted_ips)
        if ping and not isinstance(ping, bool):
            raise TypeError("Expected argument 'ping' to be a bool")
        pulumi.set(__self__, "ping", ping)
        if response_pages and not isinstance(response_pages, bool):
            raise TypeError("Expected argument 'response_pages' to be a bool")
        pulumi.set(__self__, "response_pages", response_pages)
        if snippet and not isinstance(snippet, str):
            raise TypeError("Expected argument 'snippet' to be a str")
        pulumi.set(__self__, "snippet", snippet)
        if ssh and not isinstance(ssh, bool):
            raise TypeError("Expected argument 'ssh' to be a bool")
        pulumi.set(__self__, "ssh", ssh)
        if telnet and not isinstance(telnet, bool):
            raise TypeError("Expected argument 'telnet' to be a bool")
        pulumi.set(__self__, "telnet", telnet)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)
        if userid_service and not isinstance(userid_service, bool):
            raise TypeError("Expected argument 'userid_service' to be a bool")
        pulumi.set(__self__, "userid_service", userid_service)
        if userid_syslog_listener_ssl and not isinstance(userid_syslog_listener_ssl, bool):
            raise TypeError("Expected argument 'userid_syslog_listener_ssl' to be a bool")
        pulumi.set(__self__, "userid_syslog_listener_ssl", userid_syslog_listener_ssl)
        if userid_syslog_listener_udp and not isinstance(userid_syslog_listener_udp, bool):
            raise TypeError("Expected argument 'userid_syslog_listener_udp' to be a bool")
        pulumi.set(__self__, "userid_syslog_listener_udp", userid_syslog_listener_udp)

    @_builtins.property
    @pulumi.getter
    def device(self) -> _builtins.str:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> _builtins.str:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def http(self) -> _builtins.bool:
        """
        Allow HTTP?
        """
        return pulumi.get(self, "http")

    @_builtins.property
    @pulumi.getter(name="httpOcsp")
    def http_ocsp(self) -> _builtins.bool:
        """
        Allow HTTP OCSP?
        """
        return pulumi.get(self, "http_ocsp")

    @_builtins.property
    @pulumi.getter
    def https(self) -> _builtins.bool:
        """
        Allow HTTPS?
        """
        return pulumi.get(self, "https")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        UUID of the resource
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="permittedIps")
    def permitted_ips(self) -> Sequence['outputs.GetInterfaceManagementProfilePermittedIpResult']:
        """
        Allowed IP address(es)
        """
        return pulumi.get(self, "permitted_ips")

    @_builtins.property
    @pulumi.getter
    def ping(self) -> _builtins.bool:
        """
        Allow ping?
        """
        return pulumi.get(self, "ping")

    @_builtins.property
    @pulumi.getter(name="responsePages")
    def response_pages(self) -> _builtins.bool:
        """
        Allow response pages?
        """
        return pulumi.get(self, "response_pages")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> _builtins.str:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def ssh(self) -> _builtins.bool:
        """
        Allow SSH?
        """
        return pulumi.get(self, "ssh")

    @_builtins.property
    @pulumi.getter
    def telnet(self) -> _builtins.bool:
        """
        Allow telnet? Seriously, why would you do this?!?
        """
        return pulumi.get(self, "telnet")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter(name="useridService")
    def userid_service(self) -> _builtins.bool:
        """
        Allow User-ID?
        """
        return pulumi.get(self, "userid_service")

    @_builtins.property
    @pulumi.getter(name="useridSyslogListenerSsl")
    def userid_syslog_listener_ssl(self) -> _builtins.bool:
        """
        Allow User-ID syslog listener (SSL)?
        """
        return pulumi.get(self, "userid_syslog_listener_ssl")

    @_builtins.property
    @pulumi.getter(name="useridSyslogListenerUdp")
    def userid_syslog_listener_udp(self) -> _builtins.bool:
        """
        Allow User-ID syslog listener (UDP)?
        """
        return pulumi.get(self, "userid_syslog_listener_udp")


class AwaitableGetInterfaceManagementProfileResult(GetInterfaceManagementProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInterfaceManagementProfileResult(
            device=self.device,
            folder=self.folder,
            http=self.http,
            http_ocsp=self.http_ocsp,
            https=self.https,
            id=self.id,
            name=self.name,
            permitted_ips=self.permitted_ips,
            ping=self.ping,
            response_pages=self.response_pages,
            snippet=self.snippet,
            ssh=self.ssh,
            telnet=self.telnet,
            tfid=self.tfid,
            userid_service=self.userid_service,
            userid_syslog_listener_ssl=self.userid_syslog_listener_ssl,
            userid_syslog_listener_udp=self.userid_syslog_listener_udp)


def get_interface_management_profile(id: Optional[_builtins.str] = None,
                                     name: Optional[_builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInterfaceManagementProfileResult:
    """
    InterfaceManagementProfile data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # 1. Resource: Create the Interface Management Profile
    # This block creates the profile with your specified configuration.
    test_inf_mgmt_profile = scm.InterfaceManagementProfile("test_inf_mgmt_profile",
        name="test_inf_mgmt_profile_ds_1",
        folder="All",
        permitted_ips=[
            {
                "name": "10.0.0.0/24",
            },
            {
                "name": "10.0.0.0/32",
            },
        ],
        http=True,
        https=False,
        telnet=False,
        ssh=True,
        ping=False,
        http_ocsp=True,
        userid_service=True,
        userid_syslog_listener_ssl=True,
        userid_syslog_listener_udp=True,
        response_pages=False)
    # --------------------------------------------------------------------------------
    # 2. Data Source: Retrieve the Interface Management Profile by ID
    # We use the resource's generated 'id' attribute to fetch the profile.
    single_profile_by_id = scm.get_interface_management_profile_output(id=test_inf_mgmt_profile.id)
    pulumi.export("fetchedProfileName", single_profile_by_id.name)
    pulumi.export("fetchedProfile", single_profile_by_id)
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: Name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getInterfaceManagementProfile:getInterfaceManagementProfile', __args__, opts=opts, typ=GetInterfaceManagementProfileResult).value

    return AwaitableGetInterfaceManagementProfileResult(
        device=pulumi.get(__ret__, 'device'),
        folder=pulumi.get(__ret__, 'folder'),
        http=pulumi.get(__ret__, 'http'),
        http_ocsp=pulumi.get(__ret__, 'http_ocsp'),
        https=pulumi.get(__ret__, 'https'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        permitted_ips=pulumi.get(__ret__, 'permitted_ips'),
        ping=pulumi.get(__ret__, 'ping'),
        response_pages=pulumi.get(__ret__, 'response_pages'),
        snippet=pulumi.get(__ret__, 'snippet'),
        ssh=pulumi.get(__ret__, 'ssh'),
        telnet=pulumi.get(__ret__, 'telnet'),
        tfid=pulumi.get(__ret__, 'tfid'),
        userid_service=pulumi.get(__ret__, 'userid_service'),
        userid_syslog_listener_ssl=pulumi.get(__ret__, 'userid_syslog_listener_ssl'),
        userid_syslog_listener_udp=pulumi.get(__ret__, 'userid_syslog_listener_udp'))
def get_interface_management_profile_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                            name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInterfaceManagementProfileResult]:
    """
    InterfaceManagementProfile data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # 1. Resource: Create the Interface Management Profile
    # This block creates the profile with your specified configuration.
    test_inf_mgmt_profile = scm.InterfaceManagementProfile("test_inf_mgmt_profile",
        name="test_inf_mgmt_profile_ds_1",
        folder="All",
        permitted_ips=[
            {
                "name": "10.0.0.0/24",
            },
            {
                "name": "10.0.0.0/32",
            },
        ],
        http=True,
        https=False,
        telnet=False,
        ssh=True,
        ping=False,
        http_ocsp=True,
        userid_service=True,
        userid_syslog_listener_ssl=True,
        userid_syslog_listener_udp=True,
        response_pages=False)
    # --------------------------------------------------------------------------------
    # 2. Data Source: Retrieve the Interface Management Profile by ID
    # We use the resource's generated 'id' attribute to fetch the profile.
    single_profile_by_id = scm.get_interface_management_profile_output(id=test_inf_mgmt_profile.id)
    pulumi.export("fetchedProfileName", single_profile_by_id.name)
    pulumi.export("fetchedProfile", single_profile_by_id)
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: Name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getInterfaceManagementProfile:getInterfaceManagementProfile', __args__, opts=opts, typ=GetInterfaceManagementProfileResult)
    return __ret__.apply(lambda __response__: GetInterfaceManagementProfileResult(
        device=pulumi.get(__response__, 'device'),
        folder=pulumi.get(__response__, 'folder'),
        http=pulumi.get(__response__, 'http'),
        http_ocsp=pulumi.get(__response__, 'http_ocsp'),
        https=pulumi.get(__response__, 'https'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        permitted_ips=pulumi.get(__response__, 'permitted_ips'),
        ping=pulumi.get(__response__, 'ping'),
        response_pages=pulumi.get(__response__, 'response_pages'),
        snippet=pulumi.get(__response__, 'snippet'),
        ssh=pulumi.get(__response__, 'ssh'),
        telnet=pulumi.get(__response__, 'telnet'),
        tfid=pulumi.get(__response__, 'tfid'),
        userid_service=pulumi.get(__response__, 'userid_service'),
        userid_syslog_listener_ssl=pulumi.get(__response__, 'userid_syslog_listener_ssl'),
        userid_syslog_listener_udp=pulumi.get(__response__, 'userid_syslog_listener_udp')))
