# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetLogicalRouterResult',
    'AwaitableGetLogicalRouterResult',
    'get_logical_router',
    'get_logical_router_output',
]

@pulumi.output_type
class GetLogicalRouterResult:
    """
    A collection of values returned by getLogicalRouter.
    """
    def __init__(__self__, device=None, folder=None, id=None, name=None, routing_stack=None, snippet=None, tfid=None, vrves=None):
        if device and not isinstance(device, str):
            raise TypeError("Expected argument 'device' to be a str")
        pulumi.set(__self__, "device", device)
        if folder and not isinstance(folder, str):
            raise TypeError("Expected argument 'folder' to be a str")
        pulumi.set(__self__, "folder", folder)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if routing_stack and not isinstance(routing_stack, str):
            raise TypeError("Expected argument 'routing_stack' to be a str")
        pulumi.set(__self__, "routing_stack", routing_stack)
        if snippet and not isinstance(snippet, str):
            raise TypeError("Expected argument 'snippet' to be a str")
        pulumi.set(__self__, "snippet", snippet)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)
        if vrves and not isinstance(vrves, list):
            raise TypeError("Expected argument 'vrves' to be a list")
        pulumi.set(__self__, "vrves", vrves)

    @_builtins.property
    @pulumi.getter
    def device(self) -> _builtins.str:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> _builtins.str:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        UUID of the resource
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="routingStack")
    def routing_stack(self) -> _builtins.str:
        """
        Routing stack
        """
        return pulumi.get(self, "routing_stack")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> _builtins.str:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter
    def vrves(self) -> Sequence['outputs.GetLogicalRouterVrfResult']:
        """
        Vrf
        """
        return pulumi.get(self, "vrves")


class AwaitableGetLogicalRouterResult(GetLogicalRouterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogicalRouterResult(
            device=self.device,
            folder=self.folder,
            id=self.id,
            name=self.name,
            routing_stack=self.routing_stack,
            snippet=self.snippet,
            tfid=self.tfid,
            vrves=self.vrves)


def get_logical_router(id: Optional[_builtins.str] = None,
                       name: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogicalRouterResult:
    """
    LogicalRouter data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # Look up the logical router by its ID.
    scm_logical_router_ds = scm.get_logical_router(id="b7c6f00b-b20e-4073-af1c-1f42863a5983")
    pulumi.export("scmLogicalRouterDataSourceOutput", {
        "id": scm_logical_router_ds.id,
        "name": scm_logical_router_ds.name,
        "routingStack": scm_logical_router_ds.routing_stack,
        "vrf": scm_logical_router_ds.vrves,
        "folder": scm_logical_router_ds.folder,
    })
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: Name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getLogicalRouter:getLogicalRouter', __args__, opts=opts, typ=GetLogicalRouterResult).value

    return AwaitableGetLogicalRouterResult(
        device=pulumi.get(__ret__, 'device'),
        folder=pulumi.get(__ret__, 'folder'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        routing_stack=pulumi.get(__ret__, 'routing_stack'),
        snippet=pulumi.get(__ret__, 'snippet'),
        tfid=pulumi.get(__ret__, 'tfid'),
        vrves=pulumi.get(__ret__, 'vrves'))
def get_logical_router_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                              name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLogicalRouterResult]:
    """
    LogicalRouter data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # Look up the logical router by its ID.
    scm_logical_router_ds = scm.get_logical_router(id="b7c6f00b-b20e-4073-af1c-1f42863a5983")
    pulumi.export("scmLogicalRouterDataSourceOutput", {
        "id": scm_logical_router_ds.id,
        "name": scm_logical_router_ds.name,
        "routingStack": scm_logical_router_ds.routing_stack,
        "vrf": scm_logical_router_ds.vrves,
        "folder": scm_logical_router_ds.folder,
    })
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: Name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getLogicalRouter:getLogicalRouter', __args__, opts=opts, typ=GetLogicalRouterResult)
    return __ret__.apply(lambda __response__: GetLogicalRouterResult(
        device=pulumi.get(__response__, 'device'),
        folder=pulumi.get(__response__, 'folder'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        routing_stack=pulumi.get(__response__, 'routing_stack'),
        snippet=pulumi.get(__response__, 'snippet'),
        tfid=pulumi.get(__response__, 'tfid'),
        vrves=pulumi.get(__response__, 'vrves')))
