# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetSecurityRuleResult',
    'AwaitableGetSecurityRuleResult',
    'get_security_rule',
    'get_security_rule_output',
]

@pulumi.output_type
class GetSecurityRuleResult:
    """
    A collection of values returned by getSecurityRule.
    """
    def __init__(__self__, action=None, allow_url_categories=None, allow_web_applications=None, applications=None, block_url_categories=None, block_web_applications=None, categories=None, default_profile_settings=None, description=None, destination_hips=None, destinations=None, device=None, devices=None, disabled=None, folder=None, froms=None, id=None, log_end=None, log_setting=None, log_settings=None, log_start=None, name=None, negate_destination=None, negate_source=None, negate_user=None, policy_type=None, position=None, profile_setting=None, relative_position=None, schedule=None, security_settings=None, services=None, snippet=None, source_hips=None, source_users=None, sources=None, tags=None, target_rule=None, tenant_restrictions=None, tfid=None, tos=None):
        if action and not isinstance(action, str):
            raise TypeError("Expected argument 'action' to be a str")
        pulumi.set(__self__, "action", action)
        if allow_url_categories and not isinstance(allow_url_categories, list):
            raise TypeError("Expected argument 'allow_url_categories' to be a list")
        pulumi.set(__self__, "allow_url_categories", allow_url_categories)
        if allow_web_applications and not isinstance(allow_web_applications, list):
            raise TypeError("Expected argument 'allow_web_applications' to be a list")
        pulumi.set(__self__, "allow_web_applications", allow_web_applications)
        if applications and not isinstance(applications, list):
            raise TypeError("Expected argument 'applications' to be a list")
        pulumi.set(__self__, "applications", applications)
        if block_url_categories and not isinstance(block_url_categories, list):
            raise TypeError("Expected argument 'block_url_categories' to be a list")
        pulumi.set(__self__, "block_url_categories", block_url_categories)
        if block_web_applications and not isinstance(block_web_applications, list):
            raise TypeError("Expected argument 'block_web_applications' to be a list")
        pulumi.set(__self__, "block_web_applications", block_web_applications)
        if categories and not isinstance(categories, list):
            raise TypeError("Expected argument 'categories' to be a list")
        pulumi.set(__self__, "categories", categories)
        if default_profile_settings and not isinstance(default_profile_settings, dict):
            raise TypeError("Expected argument 'default_profile_settings' to be a dict")
        pulumi.set(__self__, "default_profile_settings", default_profile_settings)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if destination_hips and not isinstance(destination_hips, list):
            raise TypeError("Expected argument 'destination_hips' to be a list")
        pulumi.set(__self__, "destination_hips", destination_hips)
        if destinations and not isinstance(destinations, list):
            raise TypeError("Expected argument 'destinations' to be a list")
        pulumi.set(__self__, "destinations", destinations)
        if device and not isinstance(device, str):
            raise TypeError("Expected argument 'device' to be a str")
        pulumi.set(__self__, "device", device)
        if devices and not isinstance(devices, list):
            raise TypeError("Expected argument 'devices' to be a list")
        pulumi.set(__self__, "devices", devices)
        if disabled and not isinstance(disabled, bool):
            raise TypeError("Expected argument 'disabled' to be a bool")
        pulumi.set(__self__, "disabled", disabled)
        if folder and not isinstance(folder, str):
            raise TypeError("Expected argument 'folder' to be a str")
        pulumi.set(__self__, "folder", folder)
        if froms and not isinstance(froms, list):
            raise TypeError("Expected argument 'froms' to be a list")
        pulumi.set(__self__, "froms", froms)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if log_end and not isinstance(log_end, bool):
            raise TypeError("Expected argument 'log_end' to be a bool")
        pulumi.set(__self__, "log_end", log_end)
        if log_setting and not isinstance(log_setting, str):
            raise TypeError("Expected argument 'log_setting' to be a str")
        pulumi.set(__self__, "log_setting", log_setting)
        if log_settings and not isinstance(log_settings, dict):
            raise TypeError("Expected argument 'log_settings' to be a dict")
        pulumi.set(__self__, "log_settings", log_settings)
        if log_start and not isinstance(log_start, bool):
            raise TypeError("Expected argument 'log_start' to be a bool")
        pulumi.set(__self__, "log_start", log_start)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if negate_destination and not isinstance(negate_destination, bool):
            raise TypeError("Expected argument 'negate_destination' to be a bool")
        pulumi.set(__self__, "negate_destination", negate_destination)
        if negate_source and not isinstance(negate_source, bool):
            raise TypeError("Expected argument 'negate_source' to be a bool")
        pulumi.set(__self__, "negate_source", negate_source)
        if negate_user and not isinstance(negate_user, bool):
            raise TypeError("Expected argument 'negate_user' to be a bool")
        pulumi.set(__self__, "negate_user", negate_user)
        if policy_type and not isinstance(policy_type, str):
            raise TypeError("Expected argument 'policy_type' to be a str")
        pulumi.set(__self__, "policy_type", policy_type)
        if position and not isinstance(position, str):
            raise TypeError("Expected argument 'position' to be a str")
        pulumi.set(__self__, "position", position)
        if profile_setting and not isinstance(profile_setting, dict):
            raise TypeError("Expected argument 'profile_setting' to be a dict")
        pulumi.set(__self__, "profile_setting", profile_setting)
        if relative_position and not isinstance(relative_position, str):
            raise TypeError("Expected argument 'relative_position' to be a str")
        pulumi.set(__self__, "relative_position", relative_position)
        if schedule and not isinstance(schedule, str):
            raise TypeError("Expected argument 'schedule' to be a str")
        pulumi.set(__self__, "schedule", schedule)
        if security_settings and not isinstance(security_settings, dict):
            raise TypeError("Expected argument 'security_settings' to be a dict")
        pulumi.set(__self__, "security_settings", security_settings)
        if services and not isinstance(services, list):
            raise TypeError("Expected argument 'services' to be a list")
        pulumi.set(__self__, "services", services)
        if snippet and not isinstance(snippet, str):
            raise TypeError("Expected argument 'snippet' to be a str")
        pulumi.set(__self__, "snippet", snippet)
        if source_hips and not isinstance(source_hips, list):
            raise TypeError("Expected argument 'source_hips' to be a list")
        pulumi.set(__self__, "source_hips", source_hips)
        if source_users and not isinstance(source_users, list):
            raise TypeError("Expected argument 'source_users' to be a list")
        pulumi.set(__self__, "source_users", source_users)
        if sources and not isinstance(sources, list):
            raise TypeError("Expected argument 'sources' to be a list")
        pulumi.set(__self__, "sources", sources)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if target_rule and not isinstance(target_rule, str):
            raise TypeError("Expected argument 'target_rule' to be a str")
        pulumi.set(__self__, "target_rule", target_rule)
        if tenant_restrictions and not isinstance(tenant_restrictions, list):
            raise TypeError("Expected argument 'tenant_restrictions' to be a list")
        pulumi.set(__self__, "tenant_restrictions", tenant_restrictions)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)
        if tos and not isinstance(tos, list):
            raise TypeError("Expected argument 'tos' to be a list")
        pulumi.set(__self__, "tos", tos)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The action to be taken when the rule is matched
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="allowUrlCategories")
    def allow_url_categories(self) -> Sequence['outputs.GetSecurityRuleAllowUrlCategoryResult']:
        """
        Allow url category
        """
        return pulumi.get(self, "allow_url_categories")

    @_builtins.property
    @pulumi.getter(name="allowWebApplications")
    def allow_web_applications(self) -> Sequence['outputs.GetSecurityRuleAllowWebApplicationResult']:
        """
        Allow web application
        """
        return pulumi.get(self, "allow_web_applications")

    @_builtins.property
    @pulumi.getter
    def applications(self) -> Sequence[_builtins.str]:
        """
        The application(s) being accessed
        """
        return pulumi.get(self, "applications")

    @_builtins.property
    @pulumi.getter(name="blockUrlCategories")
    def block_url_categories(self) -> Sequence[_builtins.str]:
        """
        Block url category
        """
        return pulumi.get(self, "block_url_categories")

    @_builtins.property
    @pulumi.getter(name="blockWebApplications")
    def block_web_applications(self) -> Sequence[_builtins.str]:
        """
        Block web application
        """
        return pulumi.get(self, "block_web_applications")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Sequence[_builtins.str]:
        """
        The URL categories being accessed
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter(name="defaultProfileSettings")
    def default_profile_settings(self) -> 'outputs.GetSecurityRuleDefaultProfileSettingsResult':
        """
        Default profile settings
        """
        return pulumi.get(self, "default_profile_settings")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the security rule
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationHips")
    def destination_hips(self) -> Sequence[_builtins.str]:
        """
        The destination Host Integrity Profile(s)
        """
        return pulumi.get(self, "destination_hips")

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> Sequence[_builtins.str]:
        """
        The destination address(es)
        """
        return pulumi.get(self, "destinations")

    @_builtins.property
    @pulumi.getter
    def device(self) -> _builtins.str:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def devices(self) -> Sequence[_builtins.str]:
        """
        Devices
        """
        return pulumi.get(self, "devices")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> _builtins.bool:
        """
        Is the security rule disabled?
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> _builtins.str:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def froms(self) -> Sequence[_builtins.str]:
        """
        The source security zone(s)
        """
        return pulumi.get(self, "froms")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The UUID of the security rule
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="logEnd")
    def log_end(self) -> _builtins.bool:
        """
        Log at session end?
        """
        return pulumi.get(self, "log_end")

    @_builtins.property
    @pulumi.getter(name="logSetting")
    def log_setting(self) -> _builtins.str:
        """
        The external log forwarding profile
        """
        return pulumi.get(self, "log_setting")

    @_builtins.property
    @pulumi.getter(name="logSettings")
    def log_settings(self) -> 'outputs.GetSecurityRuleLogSettingsResult':
        """
        Log settings
        """
        return pulumi.get(self, "log_settings")

    @_builtins.property
    @pulumi.getter(name="logStart")
    def log_start(self) -> _builtins.bool:
        """
        Log at session start?
        """
        return pulumi.get(self, "log_start")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the security rule
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="negateDestination")
    def negate_destination(self) -> _builtins.bool:
        """
        Negate the destination addresses(es)?
        """
        return pulumi.get(self, "negate_destination")

    @_builtins.property
    @pulumi.getter(name="negateSource")
    def negate_source(self) -> _builtins.bool:
        """
        Negate the source address(es)?
        """
        return pulumi.get(self, "negate_source")

    @_builtins.property
    @pulumi.getter(name="negateUser")
    def negate_user(self) -> _builtins.bool:
        """
        Negate user
        """
        return pulumi.get(self, "negate_user")

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> _builtins.str:
        """
        Policy type
        """
        return pulumi.get(self, "policy_type")

    @_builtins.property
    @pulumi.getter
    def position(self) -> _builtins.str:
        """
        The position of a security rule
        """
        return pulumi.get(self, "position")

    @_builtins.property
    @pulumi.getter(name="profileSetting")
    def profile_setting(self) -> 'outputs.GetSecurityRuleProfileSettingResult':
        """
        The security profile object
        """
        return pulumi.get(self, "profile_setting")

    @_builtins.property
    @pulumi.getter(name="relativePosition")
    def relative_position(self) -> _builtins.str:
        """
        Relative positioning rule. String must be one of these: `"before"`, `"after"`, `"top"`, `"bottom"`. If not specified, rule is created at the bottom of the ruleset.
        """
        return pulumi.get(self, "relative_position")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> _builtins.str:
        """
        Schedule in which this rule will be applied
        """
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> 'outputs.GetSecurityRuleSecuritySettingsResult':
        """
        Security settings
        """
        return pulumi.get(self, "security_settings")

    @_builtins.property
    @pulumi.getter
    def services(self) -> Sequence[_builtins.str]:
        """
        The service(s) being accessed
        """
        return pulumi.get(self, "services")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> _builtins.str:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter(name="sourceHips")
    def source_hips(self) -> Sequence[_builtins.str]:
        """
        The source Host Integrity Profile(s)
        """
        return pulumi.get(self, "source_hips")

    @_builtins.property
    @pulumi.getter(name="sourceUsers")
    def source_users(self) -> Sequence[_builtins.str]:
        """
        List of source users and/or groups.  Reserved words include `any`, `pre-login`, `known-user`, and `unknown`.
        """
        return pulumi.get(self, "source_users")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Sequence[_builtins.str]:
        """
        The source addresses(es)
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        The tags associated with the security rule
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="targetRule")
    def target_rule(self) -> _builtins.str:
        """
        The name or UUID of the rule to position this rule relative to. Required when `relative_position` is `"before"` or `"after"`.
        """
        return pulumi.get(self, "target_rule")

    @_builtins.property
    @pulumi.getter(name="tenantRestrictions")
    def tenant_restrictions(self) -> Sequence[_builtins.str]:
        """
        Tenant restrictions
        """
        return pulumi.get(self, "tenant_restrictions")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter
    def tos(self) -> Sequence[_builtins.str]:
        """
        The destination security zone(s)
        """
        return pulumi.get(self, "tos")


class AwaitableGetSecurityRuleResult(GetSecurityRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityRuleResult(
            action=self.action,
            allow_url_categories=self.allow_url_categories,
            allow_web_applications=self.allow_web_applications,
            applications=self.applications,
            block_url_categories=self.block_url_categories,
            block_web_applications=self.block_web_applications,
            categories=self.categories,
            default_profile_settings=self.default_profile_settings,
            description=self.description,
            destination_hips=self.destination_hips,
            destinations=self.destinations,
            device=self.device,
            devices=self.devices,
            disabled=self.disabled,
            folder=self.folder,
            froms=self.froms,
            id=self.id,
            log_end=self.log_end,
            log_setting=self.log_setting,
            log_settings=self.log_settings,
            log_start=self.log_start,
            name=self.name,
            negate_destination=self.negate_destination,
            negate_source=self.negate_source,
            negate_user=self.negate_user,
            policy_type=self.policy_type,
            position=self.position,
            profile_setting=self.profile_setting,
            relative_position=self.relative_position,
            schedule=self.schedule,
            security_settings=self.security_settings,
            services=self.services,
            snippet=self.snippet,
            source_hips=self.source_hips,
            source_users=self.source_users,
            sources=self.sources,
            tags=self.tags,
            target_rule=self.target_rule,
            tenant_restrictions=self.tenant_restrictions,
            tfid=self.tfid,
            tos=self.tos)


def get_security_rule(id: Optional[_builtins.str] = None,
                      name: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityRuleResult:
    """
    SecurityRule data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    standard_web_access = scm.SecurityRule("standard_web_access",
        folder="All",
        name="Allow Standard Web Access DS1",
        description="Allow outbound web traffic to any destination...",
        position="pre",
        action="allow",
        categories=["any"],
        applications=[
            "web-browsing",
            "ssl",
        ],
        services=[
            "service-http",
            "service-https",
        ],
        froms=[
            "untrust",
            "trust",
        ],
        tos=["trust"],
        sources=["any"],
        destinations=["any"],
        negate_source=False,
        negate_destination=False,
        source_users=["any"],
        source_hips=["any"],
        destination_hips=["any"],
        log_start=True,
        log_end=True,
        disabled=False)
    # --- Data Source Calls to Fetch Existing Rules ---
    # 1. Fetch by ID (Best for direct lookup)
    standard_web_access_by_id = scm.get_security_rule_output(id=standard_web_access.id)
    pulumi.export("fetchedStandardWebId", standard_web_access_by_id.id)
    pulumi.export("fetchedStandardWebName", standard_web_access_by_id.name)
    pulumi.export("fetchedStandardWebDescription", standard_web_access_by_id.description)
    ```


    :param _builtins.str id: The UUID of the security rule
    :param _builtins.str name: The name of the security rule
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getSecurityRule:getSecurityRule', __args__, opts=opts, typ=GetSecurityRuleResult).value

    return AwaitableGetSecurityRuleResult(
        action=pulumi.get(__ret__, 'action'),
        allow_url_categories=pulumi.get(__ret__, 'allow_url_categories'),
        allow_web_applications=pulumi.get(__ret__, 'allow_web_applications'),
        applications=pulumi.get(__ret__, 'applications'),
        block_url_categories=pulumi.get(__ret__, 'block_url_categories'),
        block_web_applications=pulumi.get(__ret__, 'block_web_applications'),
        categories=pulumi.get(__ret__, 'categories'),
        default_profile_settings=pulumi.get(__ret__, 'default_profile_settings'),
        description=pulumi.get(__ret__, 'description'),
        destination_hips=pulumi.get(__ret__, 'destination_hips'),
        destinations=pulumi.get(__ret__, 'destinations'),
        device=pulumi.get(__ret__, 'device'),
        devices=pulumi.get(__ret__, 'devices'),
        disabled=pulumi.get(__ret__, 'disabled'),
        folder=pulumi.get(__ret__, 'folder'),
        froms=pulumi.get(__ret__, 'froms'),
        id=pulumi.get(__ret__, 'id'),
        log_end=pulumi.get(__ret__, 'log_end'),
        log_setting=pulumi.get(__ret__, 'log_setting'),
        log_settings=pulumi.get(__ret__, 'log_settings'),
        log_start=pulumi.get(__ret__, 'log_start'),
        name=pulumi.get(__ret__, 'name'),
        negate_destination=pulumi.get(__ret__, 'negate_destination'),
        negate_source=pulumi.get(__ret__, 'negate_source'),
        negate_user=pulumi.get(__ret__, 'negate_user'),
        policy_type=pulumi.get(__ret__, 'policy_type'),
        position=pulumi.get(__ret__, 'position'),
        profile_setting=pulumi.get(__ret__, 'profile_setting'),
        relative_position=pulumi.get(__ret__, 'relative_position'),
        schedule=pulumi.get(__ret__, 'schedule'),
        security_settings=pulumi.get(__ret__, 'security_settings'),
        services=pulumi.get(__ret__, 'services'),
        snippet=pulumi.get(__ret__, 'snippet'),
        source_hips=pulumi.get(__ret__, 'source_hips'),
        source_users=pulumi.get(__ret__, 'source_users'),
        sources=pulumi.get(__ret__, 'sources'),
        tags=pulumi.get(__ret__, 'tags'),
        target_rule=pulumi.get(__ret__, 'target_rule'),
        tenant_restrictions=pulumi.get(__ret__, 'tenant_restrictions'),
        tfid=pulumi.get(__ret__, 'tfid'),
        tos=pulumi.get(__ret__, 'tos'))
def get_security_rule_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                             name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityRuleResult]:
    """
    SecurityRule data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    standard_web_access = scm.SecurityRule("standard_web_access",
        folder="All",
        name="Allow Standard Web Access DS1",
        description="Allow outbound web traffic to any destination...",
        position="pre",
        action="allow",
        categories=["any"],
        applications=[
            "web-browsing",
            "ssl",
        ],
        services=[
            "service-http",
            "service-https",
        ],
        froms=[
            "untrust",
            "trust",
        ],
        tos=["trust"],
        sources=["any"],
        destinations=["any"],
        negate_source=False,
        negate_destination=False,
        source_users=["any"],
        source_hips=["any"],
        destination_hips=["any"],
        log_start=True,
        log_end=True,
        disabled=False)
    # --- Data Source Calls to Fetch Existing Rules ---
    # 1. Fetch by ID (Best for direct lookup)
    standard_web_access_by_id = scm.get_security_rule_output(id=standard_web_access.id)
    pulumi.export("fetchedStandardWebId", standard_web_access_by_id.id)
    pulumi.export("fetchedStandardWebName", standard_web_access_by_id.name)
    pulumi.export("fetchedStandardWebDescription", standard_web_access_by_id.description)
    ```


    :param _builtins.str id: The UUID of the security rule
    :param _builtins.str name: The name of the security rule
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getSecurityRule:getSecurityRule', __args__, opts=opts, typ=GetSecurityRuleResult)
    return __ret__.apply(lambda __response__: GetSecurityRuleResult(
        action=pulumi.get(__response__, 'action'),
        allow_url_categories=pulumi.get(__response__, 'allow_url_categories'),
        allow_web_applications=pulumi.get(__response__, 'allow_web_applications'),
        applications=pulumi.get(__response__, 'applications'),
        block_url_categories=pulumi.get(__response__, 'block_url_categories'),
        block_web_applications=pulumi.get(__response__, 'block_web_applications'),
        categories=pulumi.get(__response__, 'categories'),
        default_profile_settings=pulumi.get(__response__, 'default_profile_settings'),
        description=pulumi.get(__response__, 'description'),
        destination_hips=pulumi.get(__response__, 'destination_hips'),
        destinations=pulumi.get(__response__, 'destinations'),
        device=pulumi.get(__response__, 'device'),
        devices=pulumi.get(__response__, 'devices'),
        disabled=pulumi.get(__response__, 'disabled'),
        folder=pulumi.get(__response__, 'folder'),
        froms=pulumi.get(__response__, 'froms'),
        id=pulumi.get(__response__, 'id'),
        log_end=pulumi.get(__response__, 'log_end'),
        log_setting=pulumi.get(__response__, 'log_setting'),
        log_settings=pulumi.get(__response__, 'log_settings'),
        log_start=pulumi.get(__response__, 'log_start'),
        name=pulumi.get(__response__, 'name'),
        negate_destination=pulumi.get(__response__, 'negate_destination'),
        negate_source=pulumi.get(__response__, 'negate_source'),
        negate_user=pulumi.get(__response__, 'negate_user'),
        policy_type=pulumi.get(__response__, 'policy_type'),
        position=pulumi.get(__response__, 'position'),
        profile_setting=pulumi.get(__response__, 'profile_setting'),
        relative_position=pulumi.get(__response__, 'relative_position'),
        schedule=pulumi.get(__response__, 'schedule'),
        security_settings=pulumi.get(__response__, 'security_settings'),
        services=pulumi.get(__response__, 'services'),
        snippet=pulumi.get(__response__, 'snippet'),
        source_hips=pulumi.get(__response__, 'source_hips'),
        source_users=pulumi.get(__response__, 'source_users'),
        sources=pulumi.get(__response__, 'sources'),
        tags=pulumi.get(__response__, 'tags'),
        target_rule=pulumi.get(__response__, 'target_rule'),
        tenant_restrictions=pulumi.get(__response__, 'tenant_restrictions'),
        tfid=pulumi.get(__response__, 'tfid'),
        tos=pulumi.get(__response__, 'tos')))
