# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetServiceConnectionGroupResult',
    'AwaitableGetServiceConnectionGroupResult',
    'get_service_connection_group',
    'get_service_connection_group_output',
]

@pulumi.output_type
class GetServiceConnectionGroupResult:
    """
    A collection of values returned by getServiceConnectionGroup.
    """
    def __init__(__self__, disable_snat=None, id=None, name=None, pbf_only=None, targets=None, tfid=None):
        if disable_snat and not isinstance(disable_snat, bool):
            raise TypeError("Expected argument 'disable_snat' to be a bool")
        pulumi.set(__self__, "disable_snat", disable_snat)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if pbf_only and not isinstance(pbf_only, bool):
            raise TypeError("Expected argument 'pbf_only' to be a bool")
        pulumi.set(__self__, "pbf_only", pbf_only)
        if targets and not isinstance(targets, list):
            raise TypeError("Expected argument 'targets' to be a list")
        pulumi.set(__self__, "targets", targets)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter(name="disableSnat")
    def disable_snat(self) -> _builtins.bool:
        """
        Disable snat
        """
        return pulumi.get(self, "disable_snat")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The UUID of the service connection group
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pbfOnly")
    def pbf_only(self) -> _builtins.bool:
        """
        Pbf only
        """
        return pulumi.get(self, "pbf_only")

    @_builtins.property
    @pulumi.getter
    def targets(self) -> Sequence[_builtins.str]:
        """
        Target
        """
        return pulumi.get(self, "targets")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")


class AwaitableGetServiceConnectionGroupResult(GetServiceConnectionGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceConnectionGroupResult(
            disable_snat=self.disable_snat,
            id=self.id,
            name=self.name,
            pbf_only=self.pbf_only,
            targets=self.targets,
            tfid=self.tfid)


def get_service_connection_group(id: Optional[_builtins.str] = None,
                                 name: Optional[_builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceConnectionGroupResult:
    """
    ServiceConnectionGroup data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    config = pulumi.Config()
    # The folder scope for the SCM resource (e.g., 'Shared', 'Predefined', or a specific folder name).
    folder_scope = config.get("folderScope")
    if folder_scope is None:
        folder_scope = "Service Connections"
    ## 1. IKE Crypto Profile (IKE Phase 1)
    example = scm.IkeCryptoProfile("example",
        name="example-ike-crypto_sc_grp",
        folder=folder_scope,
        hashes=["sha256"],
        dh_groups=["group14"],
        encryptions=["aes-256-cbc"])
    ## 2. IPsec Crypto Profile (IKE Phase 2)
    example_ipsec_crypto_profile = scm.IpsecCryptoProfile("example",
        name="panw-IPSec-Crypto_sc_grp",
        folder=folder_scope,
        esp={
            "encryptions": ["aes-256-gcm"],
            "authentications": ["sha256"],
        },
        dh_group="group14",
        lifetime={
            "hours": 8,
        })
    ## 3. IKE Gateway
    example_ike_gateway = scm.IkeGateway("example",
        name="example-gateway_sc_grp",
        folder=folder_scope,
        peer_address={
            "ip": "1.1.1.1",
        },
        authentication={
            "pre_shared_key": {
                "key": "secret",
            },
        },
        protocol={
            "ikev1": {
                "ike_crypto_profile": example.name,
            },
        })
    ## 4. IPsec Tunnel
    example_ipsec_tunnel = scm.IpsecTunnel("example",
        name="example-tunnel_sc_grp",
        folder=folder_scope,
        tunnel_interface="tunnel",
        anti_replay=True,
        copy_tos=False,
        enable_gre_encapsulation=False,
        auto_key={
            "ike_gateways": [{
                "name": example_ike_gateway.name,
            }],
            "ipsec_crypto_profile": example_ipsec_crypto_profile.name,
        },
        opts = pulumi.ResourceOptions(depends_on=[example_ike_gateway]))
    ## 5. Service Connection (The target for the group)
    site_a_vpn_sc = scm.ServiceConnection("site_a_vpn_sc",
        name="creating_a_service_connection_sc_grp",
        region="us-west-1a",
        ipsec_tunnel=example_ipsec_tunnel.name,
        subnets=[
            "10.1.0.0/16",
            "172.16.0.0/24",
        ],
        source_nat=False)
    ## 5. Service Connection (The target for the group)
    site_a_vpn_sc2 = scm.ServiceConnection("site_a_vpn_sc_2",
        name="creating_a_service_connection_sc_grp_2",
        region="us-west-1a",
        ipsec_tunnel=example_ipsec_tunnel.name,
        subnets=[
            "10.1.0.0/16",
            "172.16.0.0/24",
        ],
        source_nat=False)
    ## 6. Service Connection Group (Groups the Service Connection created above)
    example_group = scm.ServiceConnectionGroup("example_group",
        name="service-connection-group-app_sc_grp",
        targets=[
            site_a_vpn_sc.name,
            site_a_vpn_sc2.name,
        ],
        disable_snat=False,
        pbf_only=True)
    # ------------------------------------------------------------------
    # Data Source: SCM Service Connection Group (Single Lookup)
    # ------------------------------------------------------------------
    group_lookup = scm.get_service_connection_group_output(id=example_group.id)
    pulumi.export("lookedUpServiceConnectionGroupDetails", group_lookup)
    ```


    :param _builtins.str id: The UUID of the service connection group
    :param _builtins.str name: Name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getServiceConnectionGroup:getServiceConnectionGroup', __args__, opts=opts, typ=GetServiceConnectionGroupResult).value

    return AwaitableGetServiceConnectionGroupResult(
        disable_snat=pulumi.get(__ret__, 'disable_snat'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        pbf_only=pulumi.get(__ret__, 'pbf_only'),
        targets=pulumi.get(__ret__, 'targets'),
        tfid=pulumi.get(__ret__, 'tfid'))
def get_service_connection_group_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                        name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceConnectionGroupResult]:
    """
    ServiceConnectionGroup data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    config = pulumi.Config()
    # The folder scope for the SCM resource (e.g., 'Shared', 'Predefined', or a specific folder name).
    folder_scope = config.get("folderScope")
    if folder_scope is None:
        folder_scope = "Service Connections"
    ## 1. IKE Crypto Profile (IKE Phase 1)
    example = scm.IkeCryptoProfile("example",
        name="example-ike-crypto_sc_grp",
        folder=folder_scope,
        hashes=["sha256"],
        dh_groups=["group14"],
        encryptions=["aes-256-cbc"])
    ## 2. IPsec Crypto Profile (IKE Phase 2)
    example_ipsec_crypto_profile = scm.IpsecCryptoProfile("example",
        name="panw-IPSec-Crypto_sc_grp",
        folder=folder_scope,
        esp={
            "encryptions": ["aes-256-gcm"],
            "authentications": ["sha256"],
        },
        dh_group="group14",
        lifetime={
            "hours": 8,
        })
    ## 3. IKE Gateway
    example_ike_gateway = scm.IkeGateway("example",
        name="example-gateway_sc_grp",
        folder=folder_scope,
        peer_address={
            "ip": "1.1.1.1",
        },
        authentication={
            "pre_shared_key": {
                "key": "secret",
            },
        },
        protocol={
            "ikev1": {
                "ike_crypto_profile": example.name,
            },
        })
    ## 4. IPsec Tunnel
    example_ipsec_tunnel = scm.IpsecTunnel("example",
        name="example-tunnel_sc_grp",
        folder=folder_scope,
        tunnel_interface="tunnel",
        anti_replay=True,
        copy_tos=False,
        enable_gre_encapsulation=False,
        auto_key={
            "ike_gateways": [{
                "name": example_ike_gateway.name,
            }],
            "ipsec_crypto_profile": example_ipsec_crypto_profile.name,
        },
        opts = pulumi.ResourceOptions(depends_on=[example_ike_gateway]))
    ## 5. Service Connection (The target for the group)
    site_a_vpn_sc = scm.ServiceConnection("site_a_vpn_sc",
        name="creating_a_service_connection_sc_grp",
        region="us-west-1a",
        ipsec_tunnel=example_ipsec_tunnel.name,
        subnets=[
            "10.1.0.0/16",
            "172.16.0.0/24",
        ],
        source_nat=False)
    ## 5. Service Connection (The target for the group)
    site_a_vpn_sc2 = scm.ServiceConnection("site_a_vpn_sc_2",
        name="creating_a_service_connection_sc_grp_2",
        region="us-west-1a",
        ipsec_tunnel=example_ipsec_tunnel.name,
        subnets=[
            "10.1.0.0/16",
            "172.16.0.0/24",
        ],
        source_nat=False)
    ## 6. Service Connection Group (Groups the Service Connection created above)
    example_group = scm.ServiceConnectionGroup("example_group",
        name="service-connection-group-app_sc_grp",
        targets=[
            site_a_vpn_sc.name,
            site_a_vpn_sc2.name,
        ],
        disable_snat=False,
        pbf_only=True)
    # ------------------------------------------------------------------
    # Data Source: SCM Service Connection Group (Single Lookup)
    # ------------------------------------------------------------------
    group_lookup = scm.get_service_connection_group_output(id=example_group.id)
    pulumi.export("lookedUpServiceConnectionGroupDetails", group_lookup)
    ```


    :param _builtins.str id: The UUID of the service connection group
    :param _builtins.str name: Name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getServiceConnectionGroup:getServiceConnectionGroup', __args__, opts=opts, typ=GetServiceConnectionGroupResult)
    return __ret__.apply(lambda __response__: GetServiceConnectionGroupResult(
        disable_snat=pulumi.get(__response__, 'disable_snat'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        pbf_only=pulumi.get(__response__, 'pbf_only'),
        targets=pulumi.get(__response__, 'targets'),
        tfid=pulumi.get(__response__, 'tfid')))
