# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetVlanInterfaceResult',
    'AwaitableGetVlanInterfaceResult',
    'get_vlan_interface',
    'get_vlan_interface_output',
]

@pulumi.output_type
class GetVlanInterfaceResult:
    """
    A collection of values returned by getVlanInterface.
    """
    def __init__(__self__, arps=None, comment=None, ddns_config=None, default_value=None, device=None, dhcp_client=None, folder=None, id=None, interface_management_profile=None, ips=None, mtu=None, name=None, snippet=None, tfid=None, vlan_tag=None):
        if arps and not isinstance(arps, list):
            raise TypeError("Expected argument 'arps' to be a list")
        pulumi.set(__self__, "arps", arps)
        if comment and not isinstance(comment, str):
            raise TypeError("Expected argument 'comment' to be a str")
        pulumi.set(__self__, "comment", comment)
        if ddns_config and not isinstance(ddns_config, dict):
            raise TypeError("Expected argument 'ddns_config' to be a dict")
        pulumi.set(__self__, "ddns_config", ddns_config)
        if default_value and not isinstance(default_value, str):
            raise TypeError("Expected argument 'default_value' to be a str")
        pulumi.set(__self__, "default_value", default_value)
        if device and not isinstance(device, str):
            raise TypeError("Expected argument 'device' to be a str")
        pulumi.set(__self__, "device", device)
        if dhcp_client and not isinstance(dhcp_client, dict):
            raise TypeError("Expected argument 'dhcp_client' to be a dict")
        pulumi.set(__self__, "dhcp_client", dhcp_client)
        if folder and not isinstance(folder, str):
            raise TypeError("Expected argument 'folder' to be a str")
        pulumi.set(__self__, "folder", folder)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if interface_management_profile and not isinstance(interface_management_profile, str):
            raise TypeError("Expected argument 'interface_management_profile' to be a str")
        pulumi.set(__self__, "interface_management_profile", interface_management_profile)
        if ips and not isinstance(ips, list):
            raise TypeError("Expected argument 'ips' to be a list")
        pulumi.set(__self__, "ips", ips)
        if mtu and not isinstance(mtu, int):
            raise TypeError("Expected argument 'mtu' to be a int")
        pulumi.set(__self__, "mtu", mtu)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if snippet and not isinstance(snippet, str):
            raise TypeError("Expected argument 'snippet' to be a str")
        pulumi.set(__self__, "snippet", snippet)
        if tfid and not isinstance(tfid, str):
            raise TypeError("Expected argument 'tfid' to be a str")
        pulumi.set(__self__, "tfid", tfid)
        if vlan_tag and not isinstance(vlan_tag, str):
            raise TypeError("Expected argument 'vlan_tag' to be a str")
        pulumi.set(__self__, "vlan_tag", vlan_tag)

    @_builtins.property
    @pulumi.getter
    def arps(self) -> Sequence['outputs.GetVlanInterfaceArpResult']:
        """
        ARP configuration
        """
        return pulumi.get(self, "arps")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> _builtins.str:
        """
        Description
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="ddnsConfig")
    def ddns_config(self) -> 'outputs.GetVlanInterfaceDdnsConfigResult':
        """
        Dynamic DNS configuration specific to the Vlan Interfaces.
        """
        return pulumi.get(self, "ddns_config")

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> _builtins.str:
        """
        Default interface assignment
        """
        return pulumi.get(self, "default_value")

    @_builtins.property
    @pulumi.getter
    def device(self) -> _builtins.str:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter(name="dhcpClient")
    def dhcp_client(self) -> 'outputs.GetVlanInterfaceDhcpClientResult':
        """
        Vlan interfaces DHCP Client Object
        """
        return pulumi.get(self, "dhcp_client")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> _builtins.str:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        UUID of the resource
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="interfaceManagementProfile")
    def interface_management_profile(self) -> _builtins.str:
        """
        Interface management profile
        """
        return pulumi.get(self, "interface_management_profile")

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Sequence['outputs.GetVlanInterfaceIpResult']:
        """
        VLAN Interface IP Parent
        """
        return pulumi.get(self, "ips")

    @_builtins.property
    @pulumi.getter
    def mtu(self) -> _builtins.int:
        """
        MTU
        """
        return pulumi.get(self, "mtu")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        L3 sub-interface name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> _builtins.str:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> _builtins.str:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter(name="vlanTag")
    def vlan_tag(self) -> _builtins.str:
        """
        VLAN tag
        """
        return pulumi.get(self, "vlan_tag")


class AwaitableGetVlanInterfaceResult(GetVlanInterfaceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVlanInterfaceResult(
            arps=self.arps,
            comment=self.comment,
            ddns_config=self.ddns_config,
            default_value=self.default_value,
            device=self.device,
            dhcp_client=self.dhcp_client,
            folder=self.folder,
            id=self.id,
            interface_management_profile=self.interface_management_profile,
            ips=self.ips,
            mtu=self.mtu,
            name=self.name,
            snippet=self.snippet,
            tfid=self.tfid,
            vlan_tag=self.vlan_tag)


def get_vlan_interface(id: Optional[_builtins.str] = None,
                       name: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVlanInterfaceResult:
    """
    VlanInterface data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # Look up vlan interface by its ID.
    scm_vlan_interface_ds = scm.get_vlan_interface(id="3f9382a3-5c93-46d9-ae06-a632c2d9ce0c")
    pulumi.export("vlanInterfaceDataSourceResults", {
        "id": scm_vlan_interface_ds.id,
        "name": scm_vlan_interface_ds.name,
        "comment": scm_vlan_interface_ds.comment,
        "vlanTag": scm_vlan_interface_ds.vlan_tag,
        "ip": scm_vlan_interface_ds.ips,
        "folder": scm_vlan_interface_ds.folder,
    })
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: L3 sub-interface name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scm:index/getVlanInterface:getVlanInterface', __args__, opts=opts, typ=GetVlanInterfaceResult).value

    return AwaitableGetVlanInterfaceResult(
        arps=pulumi.get(__ret__, 'arps'),
        comment=pulumi.get(__ret__, 'comment'),
        ddns_config=pulumi.get(__ret__, 'ddns_config'),
        default_value=pulumi.get(__ret__, 'default_value'),
        device=pulumi.get(__ret__, 'device'),
        dhcp_client=pulumi.get(__ret__, 'dhcp_client'),
        folder=pulumi.get(__ret__, 'folder'),
        id=pulumi.get(__ret__, 'id'),
        interface_management_profile=pulumi.get(__ret__, 'interface_management_profile'),
        ips=pulumi.get(__ret__, 'ips'),
        mtu=pulumi.get(__ret__, 'mtu'),
        name=pulumi.get(__ret__, 'name'),
        snippet=pulumi.get(__ret__, 'snippet'),
        tfid=pulumi.get(__ret__, 'tfid'),
        vlan_tag=pulumi.get(__ret__, 'vlan_tag'))
def get_vlan_interface_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                              name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVlanInterfaceResult]:
    """
    VlanInterface data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scm as scm

    # Look up vlan interface by its ID.
    scm_vlan_interface_ds = scm.get_vlan_interface(id="3f9382a3-5c93-46d9-ae06-a632c2d9ce0c")
    pulumi.export("vlanInterfaceDataSourceResults", {
        "id": scm_vlan_interface_ds.id,
        "name": scm_vlan_interface_ds.name,
        "comment": scm_vlan_interface_ds.comment,
        "vlanTag": scm_vlan_interface_ds.vlan_tag,
        "ip": scm_vlan_interface_ds.ips,
        "folder": scm_vlan_interface_ds.folder,
    })
    ```


    :param _builtins.str id: UUID of the resource
    :param _builtins.str name: L3 sub-interface name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scm:index/getVlanInterface:getVlanInterface', __args__, opts=opts, typ=GetVlanInterfaceResult)
    return __ret__.apply(lambda __response__: GetVlanInterfaceResult(
        arps=pulumi.get(__response__, 'arps'),
        comment=pulumi.get(__response__, 'comment'),
        ddns_config=pulumi.get(__response__, 'ddns_config'),
        default_value=pulumi.get(__response__, 'default_value'),
        device=pulumi.get(__response__, 'device'),
        dhcp_client=pulumi.get(__response__, 'dhcp_client'),
        folder=pulumi.get(__response__, 'folder'),
        id=pulumi.get(__response__, 'id'),
        interface_management_profile=pulumi.get(__response__, 'interface_management_profile'),
        ips=pulumi.get(__response__, 'ips'),
        mtu=pulumi.get(__response__, 'mtu'),
        name=pulumi.get(__response__, 'name'),
        snippet=pulumi.get(__response__, 'snippet'),
        tfid=pulumi.get(__response__, 'tfid'),
        vlan_tag=pulumi.get(__response__, 'vlan_tag')))
