# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['Layer3SubinterfaceArgs', 'Layer3Subinterface']

@pulumi.input_type
class Layer3SubinterfaceArgs:
    def __init__(__self__, *,
                 arps: Optional[pulumi.Input[Sequence[pulumi.Input['Layer3SubinterfaceArpArgs']]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 ddns_config: Optional[pulumi.Input['Layer3SubinterfaceDdnsConfigArgs']] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcp_client: Optional[pulumi.Input['Layer3SubinterfaceDhcpClientArgs']] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_management_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input['Layer3SubinterfaceIpArgs']]]] = None,
                 mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 tag: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Layer3Subinterface resource.
        :param pulumi.Input[Sequence[pulumi.Input['Layer3SubinterfaceArpArgs']]] arps: Layer 3 sub Interfaces ARP configuration
        :param pulumi.Input[_builtins.str] comment: Description
        :param pulumi.Input['Layer3SubinterfaceDdnsConfigArgs'] ddns_config: Dynamic DNS configuration specific to the Layer 3 sub Interfaces.
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input['Layer3SubinterfaceDhcpClientArgs'] dhcp_client: Layer3 sub interfaces DHCP Client Object
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] interface_management_profile: Interface management profile
        :param pulumi.Input[Sequence[pulumi.Input['Layer3SubinterfaceIpArgs']]] ips: L3 sub-interface IP Parent
        :param pulumi.Input[_builtins.int] mtu: MTU
        :param pulumi.Input[_builtins.str] name: L3 sub-interface name
        :param pulumi.Input[_builtins.str] parent_interface: Parent interface
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.int] tag: VLAN tag
        """
        if arps is not None:
            pulumi.set(__self__, "arps", arps)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if ddns_config is not None:
            pulumi.set(__self__, "ddns_config", ddns_config)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if dhcp_client is not None:
            pulumi.set(__self__, "dhcp_client", dhcp_client)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if interface_management_profile is not None:
            pulumi.set(__self__, "interface_management_profile", interface_management_profile)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_interface is not None:
            pulumi.set(__self__, "parent_interface", parent_interface)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @_builtins.property
    @pulumi.getter
    def arps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['Layer3SubinterfaceArpArgs']]]]:
        """
        Layer 3 sub Interfaces ARP configuration
        """
        return pulumi.get(self, "arps")

    @arps.setter
    def arps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['Layer3SubinterfaceArpArgs']]]]):
        pulumi.set(self, "arps", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="ddnsConfig")
    def ddns_config(self) -> Optional[pulumi.Input['Layer3SubinterfaceDdnsConfigArgs']]:
        """
        Dynamic DNS configuration specific to the Layer 3 sub Interfaces.
        """
        return pulumi.get(self, "ddns_config")

    @ddns_config.setter
    def ddns_config(self, value: Optional[pulumi.Input['Layer3SubinterfaceDdnsConfigArgs']]):
        pulumi.set(self, "ddns_config", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter(name="dhcpClient")
    def dhcp_client(self) -> Optional[pulumi.Input['Layer3SubinterfaceDhcpClientArgs']]:
        """
        Layer3 sub interfaces DHCP Client Object
        """
        return pulumi.get(self, "dhcp_client")

    @dhcp_client.setter
    def dhcp_client(self, value: Optional[pulumi.Input['Layer3SubinterfaceDhcpClientArgs']]):
        pulumi.set(self, "dhcp_client", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="interfaceManagementProfile")
    def interface_management_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Interface management profile
        """
        return pulumi.get(self, "interface_management_profile")

    @interface_management_profile.setter
    def interface_management_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interface_management_profile", value)

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['Layer3SubinterfaceIpArgs']]]]:
        """
        L3 sub-interface IP Parent
        """
        return pulumi.get(self, "ips")

    @ips.setter
    def ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['Layer3SubinterfaceIpArgs']]]]):
        pulumi.set(self, "ips", value)

    @_builtins.property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        MTU
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mtu", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        L3 sub-interface name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="parentInterface")
    def parent_interface(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Parent interface
        """
        return pulumi.get(self, "parent_interface")

    @parent_interface.setter
    def parent_interface(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_interface", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        VLAN tag
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tag", value)


@pulumi.input_type
class _Layer3SubinterfaceState:
    def __init__(__self__, *,
                 arps: Optional[pulumi.Input[Sequence[pulumi.Input['Layer3SubinterfaceArpArgs']]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 ddns_config: Optional[pulumi.Input['Layer3SubinterfaceDdnsConfigArgs']] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcp_client: Optional[pulumi.Input['Layer3SubinterfaceDhcpClientArgs']] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_management_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input['Layer3SubinterfaceIpArgs']]]] = None,
                 mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 tag: Optional[pulumi.Input[_builtins.int]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Layer3Subinterface resources.
        :param pulumi.Input[Sequence[pulumi.Input['Layer3SubinterfaceArpArgs']]] arps: Layer 3 sub Interfaces ARP configuration
        :param pulumi.Input[_builtins.str] comment: Description
        :param pulumi.Input['Layer3SubinterfaceDdnsConfigArgs'] ddns_config: Dynamic DNS configuration specific to the Layer 3 sub Interfaces.
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input['Layer3SubinterfaceDhcpClientArgs'] dhcp_client: Layer3 sub interfaces DHCP Client Object
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] interface_management_profile: Interface management profile
        :param pulumi.Input[Sequence[pulumi.Input['Layer3SubinterfaceIpArgs']]] ips: L3 sub-interface IP Parent
        :param pulumi.Input[_builtins.int] mtu: MTU
        :param pulumi.Input[_builtins.str] name: L3 sub-interface name
        :param pulumi.Input[_builtins.str] parent_interface: Parent interface
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.int] tag: VLAN tag
        """
        if arps is not None:
            pulumi.set(__self__, "arps", arps)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if ddns_config is not None:
            pulumi.set(__self__, "ddns_config", ddns_config)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if dhcp_client is not None:
            pulumi.set(__self__, "dhcp_client", dhcp_client)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if interface_management_profile is not None:
            pulumi.set(__self__, "interface_management_profile", interface_management_profile)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_interface is not None:
            pulumi.set(__self__, "parent_interface", parent_interface)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter
    def arps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['Layer3SubinterfaceArpArgs']]]]:
        """
        Layer 3 sub Interfaces ARP configuration
        """
        return pulumi.get(self, "arps")

    @arps.setter
    def arps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['Layer3SubinterfaceArpArgs']]]]):
        pulumi.set(self, "arps", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="ddnsConfig")
    def ddns_config(self) -> Optional[pulumi.Input['Layer3SubinterfaceDdnsConfigArgs']]:
        """
        Dynamic DNS configuration specific to the Layer 3 sub Interfaces.
        """
        return pulumi.get(self, "ddns_config")

    @ddns_config.setter
    def ddns_config(self, value: Optional[pulumi.Input['Layer3SubinterfaceDdnsConfigArgs']]):
        pulumi.set(self, "ddns_config", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter(name="dhcpClient")
    def dhcp_client(self) -> Optional[pulumi.Input['Layer3SubinterfaceDhcpClientArgs']]:
        """
        Layer3 sub interfaces DHCP Client Object
        """
        return pulumi.get(self, "dhcp_client")

    @dhcp_client.setter
    def dhcp_client(self, value: Optional[pulumi.Input['Layer3SubinterfaceDhcpClientArgs']]):
        pulumi.set(self, "dhcp_client", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="interfaceManagementProfile")
    def interface_management_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Interface management profile
        """
        return pulumi.get(self, "interface_management_profile")

    @interface_management_profile.setter
    def interface_management_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interface_management_profile", value)

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['Layer3SubinterfaceIpArgs']]]]:
        """
        L3 sub-interface IP Parent
        """
        return pulumi.get(self, "ips")

    @ips.setter
    def ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['Layer3SubinterfaceIpArgs']]]]):
        pulumi.set(self, "ips", value)

    @_builtins.property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        MTU
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mtu", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        L3 sub-interface name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="parentInterface")
    def parent_interface(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Parent interface
        """
        return pulumi.get(self, "parent_interface")

    @parent_interface.setter
    def parent_interface(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_interface", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        VLAN tag
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tag", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)


@pulumi.type_token("scm:index/layer3Subinterface:Layer3Subinterface")
class Layer3Subinterface(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['Layer3SubinterfaceArpArgs', 'Layer3SubinterfaceArpArgsDict']]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 ddns_config: Optional[pulumi.Input[Union['Layer3SubinterfaceDdnsConfigArgs', 'Layer3SubinterfaceDdnsConfigArgsDict']]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcp_client: Optional[pulumi.Input[Union['Layer3SubinterfaceDhcpClientArgs', 'Layer3SubinterfaceDhcpClientArgsDict']]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_management_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['Layer3SubinterfaceIpArgs', 'Layer3SubinterfaceIpArgsDict']]]]] = None,
                 mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 tag: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Layer3Subinterface resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        #
        # Creates a ethernet interface used as parent-interface for subsequent examples
        #
        scm_parent_interface = scm.EthernetInterface("scm_parent_interface",
            name="$scm_parent_interface",
            comment="Managed by Pulumi",
            folder="ngfw-shared",
            layer3={})
        #
        # Creates a layer3 sub-interface with static ip address
        #
        scm_l3_subinterface = scm.Layer3Subinterface("scm_l3_subinterface",
            name="$scm_parent_interface.100",
            comment="Managed by Pulumi",
            folder="ngfw-shared",
            tag=100,
            parent_interface="$scm_parent_interface",
            ips=[{
                "name": "198.18.1.1/32",
            }],
            opts = pulumi.ResourceOptions(depends_on=[scm_parent_interface]))
        scm_parent_dhcp_interface = scm.EthernetInterface("scm_parent_dhcp_interface",
            name="$scm_parent_dhcp_interface",
            comment="Managed by Pulumi",
            folder="All",
            layer3={})
        #
        # Creates a layer3 sub-interface with dhcp
        #
        scm_l3_dhcp_subinterface = scm.Layer3Subinterface("scm_l3_dhcp_subinterface",
            name="$scm_parent_dhcp_interface.100",
            comment="Managed by Pulumi",
            folder="All",
            tag=100,
            parent_interface="$scm_parent_dhcp_interface",
            dhcp_client={
                "enable": True,
                "create_default_route": True,
                "default_route_metric": 20,
                "send_hostname": {
                    "enable": True,
                    "hostname": "client-vlan50-host",
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[scm_parent_dhcp_interface]))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['Layer3SubinterfaceArpArgs', 'Layer3SubinterfaceArpArgsDict']]]] arps: Layer 3 sub Interfaces ARP configuration
        :param pulumi.Input[_builtins.str] comment: Description
        :param pulumi.Input[Union['Layer3SubinterfaceDdnsConfigArgs', 'Layer3SubinterfaceDdnsConfigArgsDict']] ddns_config: Dynamic DNS configuration specific to the Layer 3 sub Interfaces.
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[Union['Layer3SubinterfaceDhcpClientArgs', 'Layer3SubinterfaceDhcpClientArgsDict']] dhcp_client: Layer3 sub interfaces DHCP Client Object
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] interface_management_profile: Interface management profile
        :param pulumi.Input[Sequence[pulumi.Input[Union['Layer3SubinterfaceIpArgs', 'Layer3SubinterfaceIpArgsDict']]]] ips: L3 sub-interface IP Parent
        :param pulumi.Input[_builtins.int] mtu: MTU
        :param pulumi.Input[_builtins.str] name: L3 sub-interface name
        :param pulumi.Input[_builtins.str] parent_interface: Parent interface
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.int] tag: VLAN tag
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[Layer3SubinterfaceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Layer3Subinterface resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        #
        # Creates a ethernet interface used as parent-interface for subsequent examples
        #
        scm_parent_interface = scm.EthernetInterface("scm_parent_interface",
            name="$scm_parent_interface",
            comment="Managed by Pulumi",
            folder="ngfw-shared",
            layer3={})
        #
        # Creates a layer3 sub-interface with static ip address
        #
        scm_l3_subinterface = scm.Layer3Subinterface("scm_l3_subinterface",
            name="$scm_parent_interface.100",
            comment="Managed by Pulumi",
            folder="ngfw-shared",
            tag=100,
            parent_interface="$scm_parent_interface",
            ips=[{
                "name": "198.18.1.1/32",
            }],
            opts = pulumi.ResourceOptions(depends_on=[scm_parent_interface]))
        scm_parent_dhcp_interface = scm.EthernetInterface("scm_parent_dhcp_interface",
            name="$scm_parent_dhcp_interface",
            comment="Managed by Pulumi",
            folder="All",
            layer3={})
        #
        # Creates a layer3 sub-interface with dhcp
        #
        scm_l3_dhcp_subinterface = scm.Layer3Subinterface("scm_l3_dhcp_subinterface",
            name="$scm_parent_dhcp_interface.100",
            comment="Managed by Pulumi",
            folder="All",
            tag=100,
            parent_interface="$scm_parent_dhcp_interface",
            dhcp_client={
                "enable": True,
                "create_default_route": True,
                "default_route_metric": 20,
                "send_hostname": {
                    "enable": True,
                    "hostname": "client-vlan50-host",
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[scm_parent_dhcp_interface]))
        ```

        :param str resource_name: The name of the resource.
        :param Layer3SubinterfaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(Layer3SubinterfaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['Layer3SubinterfaceArpArgs', 'Layer3SubinterfaceArpArgsDict']]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 ddns_config: Optional[pulumi.Input[Union['Layer3SubinterfaceDdnsConfigArgs', 'Layer3SubinterfaceDdnsConfigArgsDict']]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcp_client: Optional[pulumi.Input[Union['Layer3SubinterfaceDhcpClientArgs', 'Layer3SubinterfaceDhcpClientArgsDict']]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_management_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['Layer3SubinterfaceIpArgs', 'Layer3SubinterfaceIpArgsDict']]]]] = None,
                 mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 tag: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = Layer3SubinterfaceArgs.__new__(Layer3SubinterfaceArgs)

            __props__.__dict__["arps"] = arps
            __props__.__dict__["comment"] = comment
            __props__.__dict__["ddns_config"] = ddns_config
            __props__.__dict__["device"] = device
            __props__.__dict__["dhcp_client"] = dhcp_client
            __props__.__dict__["folder"] = folder
            __props__.__dict__["interface_management_profile"] = interface_management_profile
            __props__.__dict__["ips"] = ips
            __props__.__dict__["mtu"] = mtu
            __props__.__dict__["name"] = name
            __props__.__dict__["parent_interface"] = parent_interface
            __props__.__dict__["snippet"] = snippet
            __props__.__dict__["tag"] = tag
            __props__.__dict__["tfid"] = None
        super(Layer3Subinterface, __self__).__init__(
            'scm:index/layer3Subinterface:Layer3Subinterface',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['Layer3SubinterfaceArpArgs', 'Layer3SubinterfaceArpArgsDict']]]]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            ddns_config: Optional[pulumi.Input[Union['Layer3SubinterfaceDdnsConfigArgs', 'Layer3SubinterfaceDdnsConfigArgsDict']]] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            dhcp_client: Optional[pulumi.Input[Union['Layer3SubinterfaceDhcpClientArgs', 'Layer3SubinterfaceDhcpClientArgsDict']]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            interface_management_profile: Optional[pulumi.Input[_builtins.str]] = None,
            ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['Layer3SubinterfaceIpArgs', 'Layer3SubinterfaceIpArgsDict']]]]] = None,
            mtu: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parent_interface: Optional[pulumi.Input[_builtins.str]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            tag: Optional[pulumi.Input[_builtins.int]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None) -> 'Layer3Subinterface':
        """
        Get an existing Layer3Subinterface resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['Layer3SubinterfaceArpArgs', 'Layer3SubinterfaceArpArgsDict']]]] arps: Layer 3 sub Interfaces ARP configuration
        :param pulumi.Input[_builtins.str] comment: Description
        :param pulumi.Input[Union['Layer3SubinterfaceDdnsConfigArgs', 'Layer3SubinterfaceDdnsConfigArgsDict']] ddns_config: Dynamic DNS configuration specific to the Layer 3 sub Interfaces.
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[Union['Layer3SubinterfaceDhcpClientArgs', 'Layer3SubinterfaceDhcpClientArgsDict']] dhcp_client: Layer3 sub interfaces DHCP Client Object
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] interface_management_profile: Interface management profile
        :param pulumi.Input[Sequence[pulumi.Input[Union['Layer3SubinterfaceIpArgs', 'Layer3SubinterfaceIpArgsDict']]]] ips: L3 sub-interface IP Parent
        :param pulumi.Input[_builtins.int] mtu: MTU
        :param pulumi.Input[_builtins.str] name: L3 sub-interface name
        :param pulumi.Input[_builtins.str] parent_interface: Parent interface
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.int] tag: VLAN tag
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _Layer3SubinterfaceState.__new__(_Layer3SubinterfaceState)

        __props__.__dict__["arps"] = arps
        __props__.__dict__["comment"] = comment
        __props__.__dict__["ddns_config"] = ddns_config
        __props__.__dict__["device"] = device
        __props__.__dict__["dhcp_client"] = dhcp_client
        __props__.__dict__["folder"] = folder
        __props__.__dict__["interface_management_profile"] = interface_management_profile
        __props__.__dict__["ips"] = ips
        __props__.__dict__["mtu"] = mtu
        __props__.__dict__["name"] = name
        __props__.__dict__["parent_interface"] = parent_interface
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["tag"] = tag
        __props__.__dict__["tfid"] = tfid
        return Layer3Subinterface(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arps(self) -> pulumi.Output[Optional[Sequence['outputs.Layer3SubinterfaceArp']]]:
        """
        Layer 3 sub Interfaces ARP configuration
        """
        return pulumi.get(self, "arps")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="ddnsConfig")
    def ddns_config(self) -> pulumi.Output['outputs.Layer3SubinterfaceDdnsConfig']:
        """
        Dynamic DNS configuration specific to the Layer 3 sub Interfaces.
        """
        return pulumi.get(self, "ddns_config")

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter(name="dhcpClient")
    def dhcp_client(self) -> pulumi.Output['outputs.Layer3SubinterfaceDhcpClient']:
        """
        Layer3 sub interfaces DHCP Client Object
        """
        return pulumi.get(self, "dhcp_client")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter(name="interfaceManagementProfile")
    def interface_management_profile(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Interface management profile
        """
        return pulumi.get(self, "interface_management_profile")

    @_builtins.property
    @pulumi.getter
    def ips(self) -> pulumi.Output[Optional[Sequence['outputs.Layer3SubinterfaceIp']]]:
        """
        L3 sub-interface IP Parent
        """
        return pulumi.get(self, "ips")

    @_builtins.property
    @pulumi.getter
    def mtu(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        MTU
        """
        return pulumi.get(self, "mtu")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        L3 sub-interface name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="parentInterface")
    def parent_interface(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Parent interface
        """
        return pulumi.get(self, "parent_interface")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        VLAN tag
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

