# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NatRuleArgs', 'NatRule']

@pulumi.input_type
class NatRuleArgs:
    def __init__(__self__, *,
                 destinations: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 froms: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 service: pulumi.Input[_builtins.str],
                 sources: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 tos: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 active_active_device_binding: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_translation: Optional[pulumi.Input['NatRuleDestinationTranslationArgs']] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dynamic_destination_translation: Optional[pulumi.Input['NatRuleDynamicDestinationTranslationArgs']] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_type: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 source_translation: Optional[pulumi.Input['NatRuleSourceTranslationArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 to_interface: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NatRule resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destinations: Destination address(es) of the original packet
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] froms: Source zone(s) of the original packet
        :param pulumi.Input[_builtins.str] service: The service of the original packet
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sources: Source address(es) of the original packet
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tos: Destination zone of the original packet
        :param pulumi.Input[_builtins.str] active_active_device_binding: Active active device binding
        :param pulumi.Input[_builtins.str] description: NAT rule description
        :param pulumi.Input['NatRuleDestinationTranslationArgs'] destination_translation: Destination translation
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.bool] disabled: Disable NAT rule?
        :param pulumi.Input['NatRuleDynamicDestinationTranslationArgs'] dynamic_destination_translation: Dynamic destination translation
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: NAT rule name
        :param pulumi.Input[_builtins.str] nat_type: NAT type
        :param pulumi.Input[_builtins.str] position: The relative position of the rule
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input['NatRuleSourceTranslationArgs'] source_translation: Source translation
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: NAT rule tags
        :param pulumi.Input[_builtins.str] to_interface: Destination interface of the original packet
        """
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "froms", froms)
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "tos", tos)
        if active_active_device_binding is not None:
            pulumi.set(__self__, "active_active_device_binding", active_active_device_binding)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_translation is not None:
            pulumi.set(__self__, "destination_translation", destination_translation)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if dynamic_destination_translation is not None:
            pulumi.set(__self__, "dynamic_destination_translation", dynamic_destination_translation)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat_type is not None:
            pulumi.set(__self__, "nat_type", nat_type)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if source_translation is not None:
            pulumi.set(__self__, "source_translation", source_translation)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if to_interface is not None:
            pulumi.set(__self__, "to_interface", to_interface)

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Destination address(es) of the original packet
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "destinations", value)

    @_builtins.property
    @pulumi.getter
    def froms(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Source zone(s) of the original packet
        """
        return pulumi.get(self, "froms")

    @froms.setter
    def froms(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "froms", value)

    @_builtins.property
    @pulumi.getter
    def service(self) -> pulumi.Input[_builtins.str]:
        """
        The service of the original packet
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service", value)

    @_builtins.property
    @pulumi.getter
    def sources(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Source address(es) of the original packet
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "sources", value)

    @_builtins.property
    @pulumi.getter
    def tos(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Destination zone of the original packet
        """
        return pulumi.get(self, "tos")

    @tos.setter
    def tos(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "tos", value)

    @_builtins.property
    @pulumi.getter(name="activeActiveDeviceBinding")
    def active_active_device_binding(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Active active device binding
        """
        return pulumi.get(self, "active_active_device_binding")

    @active_active_device_binding.setter
    def active_active_device_binding(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "active_active_device_binding", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        NAT rule description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationTranslation")
    def destination_translation(self) -> Optional[pulumi.Input['NatRuleDestinationTranslationArgs']]:
        """
        Destination translation
        """
        return pulumi.get(self, "destination_translation")

    @destination_translation.setter
    def destination_translation(self, value: Optional[pulumi.Input['NatRuleDestinationTranslationArgs']]):
        pulumi.set(self, "destination_translation", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disable NAT rule?
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter(name="dynamicDestinationTranslation")
    def dynamic_destination_translation(self) -> Optional[pulumi.Input['NatRuleDynamicDestinationTranslationArgs']]:
        """
        Dynamic destination translation
        """
        return pulumi.get(self, "dynamic_destination_translation")

    @dynamic_destination_translation.setter
    def dynamic_destination_translation(self, value: Optional[pulumi.Input['NatRuleDynamicDestinationTranslationArgs']]):
        pulumi.set(self, "dynamic_destination_translation", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        NAT rule name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="natType")
    def nat_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        NAT type
        """
        return pulumi.get(self, "nat_type")

    @nat_type.setter
    def nat_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nat_type", value)

    @_builtins.property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The relative position of the rule
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "position", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter(name="sourceTranslation")
    def source_translation(self) -> Optional[pulumi.Input['NatRuleSourceTranslationArgs']]:
        """
        Source translation
        """
        return pulumi.get(self, "source_translation")

    @source_translation.setter
    def source_translation(self, value: Optional[pulumi.Input['NatRuleSourceTranslationArgs']]):
        pulumi.set(self, "source_translation", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        NAT rule tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="toInterface")
    def to_interface(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Destination interface of the original packet
        """
        return pulumi.get(self, "to_interface")

    @to_interface.setter
    def to_interface(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "to_interface", value)


@pulumi.input_type
class _NatRuleState:
    def __init__(__self__, *,
                 active_active_device_binding: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_translation: Optional[pulumi.Input['NatRuleDestinationTranslationArgs']] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dynamic_destination_translation: Optional[pulumi.Input['NatRuleDynamicDestinationTranslationArgs']] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 froms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_type: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 source_translation: Optional[pulumi.Input['NatRuleSourceTranslationArgs']] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None,
                 to_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 tos: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering NatRule resources.
        :param pulumi.Input[_builtins.str] active_active_device_binding: Active active device binding
        :param pulumi.Input[_builtins.str] description: NAT rule description
        :param pulumi.Input['NatRuleDestinationTranslationArgs'] destination_translation: Destination translation
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destinations: Destination address(es) of the original packet
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.bool] disabled: Disable NAT rule?
        :param pulumi.Input['NatRuleDynamicDestinationTranslationArgs'] dynamic_destination_translation: Dynamic destination translation
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] froms: Source zone(s) of the original packet
        :param pulumi.Input[_builtins.str] name: NAT rule name
        :param pulumi.Input[_builtins.str] nat_type: NAT type
        :param pulumi.Input[_builtins.str] position: The relative position of the rule
        :param pulumi.Input[_builtins.str] service: The service of the original packet
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input['NatRuleSourceTranslationArgs'] source_translation: Source translation
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sources: Source address(es) of the original packet
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: NAT rule tags
        :param pulumi.Input[_builtins.str] to_interface: Destination interface of the original packet
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tos: Destination zone of the original packet
        """
        if active_active_device_binding is not None:
            pulumi.set(__self__, "active_active_device_binding", active_active_device_binding)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_translation is not None:
            pulumi.set(__self__, "destination_translation", destination_translation)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if dynamic_destination_translation is not None:
            pulumi.set(__self__, "dynamic_destination_translation", dynamic_destination_translation)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if froms is not None:
            pulumi.set(__self__, "froms", froms)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat_type is not None:
            pulumi.set(__self__, "nat_type", nat_type)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if source_translation is not None:
            pulumi.set(__self__, "source_translation", source_translation)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)
        if to_interface is not None:
            pulumi.set(__self__, "to_interface", to_interface)
        if tos is not None:
            pulumi.set(__self__, "tos", tos)

    @_builtins.property
    @pulumi.getter(name="activeActiveDeviceBinding")
    def active_active_device_binding(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Active active device binding
        """
        return pulumi.get(self, "active_active_device_binding")

    @active_active_device_binding.setter
    def active_active_device_binding(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "active_active_device_binding", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        NAT rule description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationTranslation")
    def destination_translation(self) -> Optional[pulumi.Input['NatRuleDestinationTranslationArgs']]:
        """
        Destination translation
        """
        return pulumi.get(self, "destination_translation")

    @destination_translation.setter
    def destination_translation(self, value: Optional[pulumi.Input['NatRuleDestinationTranslationArgs']]):
        pulumi.set(self, "destination_translation", value)

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Destination address(es) of the original packet
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "destinations", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disable NAT rule?
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter(name="dynamicDestinationTranslation")
    def dynamic_destination_translation(self) -> Optional[pulumi.Input['NatRuleDynamicDestinationTranslationArgs']]:
        """
        Dynamic destination translation
        """
        return pulumi.get(self, "dynamic_destination_translation")

    @dynamic_destination_translation.setter
    def dynamic_destination_translation(self, value: Optional[pulumi.Input['NatRuleDynamicDestinationTranslationArgs']]):
        pulumi.set(self, "dynamic_destination_translation", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def froms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Source zone(s) of the original packet
        """
        return pulumi.get(self, "froms")

    @froms.setter
    def froms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "froms", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        NAT rule name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="natType")
    def nat_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        NAT type
        """
        return pulumi.get(self, "nat_type")

    @nat_type.setter
    def nat_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nat_type", value)

    @_builtins.property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The relative position of the rule
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "position", value)

    @_builtins.property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service of the original packet
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter(name="sourceTranslation")
    def source_translation(self) -> Optional[pulumi.Input['NatRuleSourceTranslationArgs']]:
        """
        Source translation
        """
        return pulumi.get(self, "source_translation")

    @source_translation.setter
    def source_translation(self, value: Optional[pulumi.Input['NatRuleSourceTranslationArgs']]):
        pulumi.set(self, "source_translation", value)

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Source address(es) of the original packet
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sources", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        NAT rule tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)

    @_builtins.property
    @pulumi.getter(name="toInterface")
    def to_interface(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Destination interface of the original packet
        """
        return pulumi.get(self, "to_interface")

    @to_interface.setter
    def to_interface(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "to_interface", value)

    @_builtins.property
    @pulumi.getter
    def tos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Destination zone of the original packet
        """
        return pulumi.get(self, "tos")

    @tos.setter
    def tos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tos", value)


@pulumi.type_token("scm:index/natRule:NatRule")
class NatRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_active_device_binding: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_translation: Optional[pulumi.Input[Union['NatRuleDestinationTranslationArgs', 'NatRuleDestinationTranslationArgsDict']]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dynamic_destination_translation: Optional[pulumi.Input[Union['NatRuleDynamicDestinationTranslationArgs', 'NatRuleDynamicDestinationTranslationArgsDict']]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 froms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_type: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 source_translation: Optional[pulumi.Input[Union['NatRuleSourceTranslationArgs', 'NatRuleSourceTranslationArgsDict']]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 to_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 tos: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        NatRule resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        example_tag = scm.Tag("example_tag",
            folder="All",
            name="example-tag",
            color="Red")
        #Source Translation (SNAT) - Dynamic IP and Port
        example_nat_rule = scm.NatRule("example_nat_rule",
            name="snat-to-internet-1",
            froms=["any"],
            tos=["untrust"],
            sources=["any"],
            destinations=["any"],
            service="service-https",
            description="Dynamic SNAT for internal traffic accessing the internet. Updating",
            disabled=False,
            nat_type="ipv4",
            folder="All",
            tags=[example_tag.name],
            source_translation={
                "dynamic_ip_and_port": {
                    "translated_addresses": [
                        "1.1.1.1",
                        "1.1.1.5",
                    ],
                },
            },
            destination_translation={
                "translated_address": "192.168.1.10",
                "translated_port": 8080,
            },
            active_active_device_binding="1")
        #Source Translation (SNAT) - Static IP - Bidirectional - no
        example_nat_static_rule = scm.NatRule("example_nat_static_rule",
            name="snat-to-bid-1",
            froms=["any"],
            tos=["untrust"],
            sources=["any"],
            destinations=["any"],
            service="service-https",
            description="Dynamic SNAT for internal traffic accessing the internet. Updating",
            disabled=False,
            nat_type="ipv4",
            folder="All",
            tags=[example_tag.name],
            source_translation={
                "static_ip": {
                    "translated_address": "1.1.1.5",
                    "bi_directional": "no",
                },
            },
            destination_translation={
                "translated_address": "192.168.1.10",
                "translated_port": 8080,
            },
            active_active_device_binding="1")
        #Source Translation (SNAT) - Static IP - Bidirectional - yes
        example_nat_static_rule2 = scm.NatRule("example_nat_static_rule_2",
            name="snat-to-bid-yes-1",
            froms=["any"],
            tos=["untrust"],
            sources=["any"],
            destinations=["any"],
            service="service-https",
            description="Dynamic SNAT for internal traffic accessing the internet. Updating",
            disabled=False,
            nat_type="ipv4",
            folder="All",
            tags=[example_tag.name],
            source_translation={
                "static_ip": {
                    "translated_address": "1.1.1.5",
                    "bi_directional": "yes",
                },
            },
            active_active_device_binding="1")
        #Source Translation (SNAT) - Dynamic IP 
        example_nat_dynamic_rule = scm.NatRule("example_nat_dynamic_rule",
            name="snat-to-dyanamic-1",
            froms=["any"],
            tos=["untrust"],
            sources=["any"],
            destinations=["any"],
            service="service-https",
            description="Dynamic SNAT for internal traffic accessing the internet. Updating",
            disabled=False,
            nat_type="ipv4",
            folder="All",
            tags=[example_tag.name],
            source_translation={
                "dynamic_ip": {
                    "translated_addresses": ["1.1.1.0/24"],
                    "fallback": {
                        "translated_addresses": ["1.1.1.0"],
                        "interface_address": {
                            "interface": "ethernet1/1",
                            "ip": "1.1.1.5",
                        },
                    },
                },
            },
            destination_translation={
                "translated_address": "192.168.1.10",
                "translated_port": 8080,
            },
            active_active_device_binding="1")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] active_active_device_binding: Active active device binding
        :param pulumi.Input[_builtins.str] description: NAT rule description
        :param pulumi.Input[Union['NatRuleDestinationTranslationArgs', 'NatRuleDestinationTranslationArgsDict']] destination_translation: Destination translation
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destinations: Destination address(es) of the original packet
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.bool] disabled: Disable NAT rule?
        :param pulumi.Input[Union['NatRuleDynamicDestinationTranslationArgs', 'NatRuleDynamicDestinationTranslationArgsDict']] dynamic_destination_translation: Dynamic destination translation
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] froms: Source zone(s) of the original packet
        :param pulumi.Input[_builtins.str] name: NAT rule name
        :param pulumi.Input[_builtins.str] nat_type: NAT type
        :param pulumi.Input[_builtins.str] position: The relative position of the rule
        :param pulumi.Input[_builtins.str] service: The service of the original packet
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Union['NatRuleSourceTranslationArgs', 'NatRuleSourceTranslationArgsDict']] source_translation: Source translation
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sources: Source address(es) of the original packet
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: NAT rule tags
        :param pulumi.Input[_builtins.str] to_interface: Destination interface of the original packet
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tos: Destination zone of the original packet
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NatRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        NatRule resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        example_tag = scm.Tag("example_tag",
            folder="All",
            name="example-tag",
            color="Red")
        #Source Translation (SNAT) - Dynamic IP and Port
        example_nat_rule = scm.NatRule("example_nat_rule",
            name="snat-to-internet-1",
            froms=["any"],
            tos=["untrust"],
            sources=["any"],
            destinations=["any"],
            service="service-https",
            description="Dynamic SNAT for internal traffic accessing the internet. Updating",
            disabled=False,
            nat_type="ipv4",
            folder="All",
            tags=[example_tag.name],
            source_translation={
                "dynamic_ip_and_port": {
                    "translated_addresses": [
                        "1.1.1.1",
                        "1.1.1.5",
                    ],
                },
            },
            destination_translation={
                "translated_address": "192.168.1.10",
                "translated_port": 8080,
            },
            active_active_device_binding="1")
        #Source Translation (SNAT) - Static IP - Bidirectional - no
        example_nat_static_rule = scm.NatRule("example_nat_static_rule",
            name="snat-to-bid-1",
            froms=["any"],
            tos=["untrust"],
            sources=["any"],
            destinations=["any"],
            service="service-https",
            description="Dynamic SNAT for internal traffic accessing the internet. Updating",
            disabled=False,
            nat_type="ipv4",
            folder="All",
            tags=[example_tag.name],
            source_translation={
                "static_ip": {
                    "translated_address": "1.1.1.5",
                    "bi_directional": "no",
                },
            },
            destination_translation={
                "translated_address": "192.168.1.10",
                "translated_port": 8080,
            },
            active_active_device_binding="1")
        #Source Translation (SNAT) - Static IP - Bidirectional - yes
        example_nat_static_rule2 = scm.NatRule("example_nat_static_rule_2",
            name="snat-to-bid-yes-1",
            froms=["any"],
            tos=["untrust"],
            sources=["any"],
            destinations=["any"],
            service="service-https",
            description="Dynamic SNAT for internal traffic accessing the internet. Updating",
            disabled=False,
            nat_type="ipv4",
            folder="All",
            tags=[example_tag.name],
            source_translation={
                "static_ip": {
                    "translated_address": "1.1.1.5",
                    "bi_directional": "yes",
                },
            },
            active_active_device_binding="1")
        #Source Translation (SNAT) - Dynamic IP 
        example_nat_dynamic_rule = scm.NatRule("example_nat_dynamic_rule",
            name="snat-to-dyanamic-1",
            froms=["any"],
            tos=["untrust"],
            sources=["any"],
            destinations=["any"],
            service="service-https",
            description="Dynamic SNAT for internal traffic accessing the internet. Updating",
            disabled=False,
            nat_type="ipv4",
            folder="All",
            tags=[example_tag.name],
            source_translation={
                "dynamic_ip": {
                    "translated_addresses": ["1.1.1.0/24"],
                    "fallback": {
                        "translated_addresses": ["1.1.1.0"],
                        "interface_address": {
                            "interface": "ethernet1/1",
                            "ip": "1.1.1.5",
                        },
                    },
                },
            },
            destination_translation={
                "translated_address": "192.168.1.10",
                "translated_port": 8080,
            },
            active_active_device_binding="1")
        ```

        :param str resource_name: The name of the resource.
        :param NatRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NatRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_active_device_binding: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_translation: Optional[pulumi.Input[Union['NatRuleDestinationTranslationArgs', 'NatRuleDestinationTranslationArgsDict']]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dynamic_destination_translation: Optional[pulumi.Input[Union['NatRuleDynamicDestinationTranslationArgs', 'NatRuleDynamicDestinationTranslationArgsDict']]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 froms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_type: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 source_translation: Optional[pulumi.Input[Union['NatRuleSourceTranslationArgs', 'NatRuleSourceTranslationArgsDict']]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 to_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 tos: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NatRuleArgs.__new__(NatRuleArgs)

            __props__.__dict__["active_active_device_binding"] = active_active_device_binding
            __props__.__dict__["description"] = description
            __props__.__dict__["destination_translation"] = destination_translation
            if destinations is None and not opts.urn:
                raise TypeError("Missing required property 'destinations'")
            __props__.__dict__["destinations"] = destinations
            __props__.__dict__["device"] = device
            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["dynamic_destination_translation"] = dynamic_destination_translation
            __props__.__dict__["folder"] = folder
            if froms is None and not opts.urn:
                raise TypeError("Missing required property 'froms'")
            __props__.__dict__["froms"] = froms
            __props__.__dict__["name"] = name
            __props__.__dict__["nat_type"] = nat_type
            __props__.__dict__["position"] = position
            if service is None and not opts.urn:
                raise TypeError("Missing required property 'service'")
            __props__.__dict__["service"] = service
            __props__.__dict__["snippet"] = snippet
            __props__.__dict__["source_translation"] = source_translation
            if sources is None and not opts.urn:
                raise TypeError("Missing required property 'sources'")
            __props__.__dict__["sources"] = sources
            __props__.__dict__["tags"] = tags
            __props__.__dict__["to_interface"] = to_interface
            if tos is None and not opts.urn:
                raise TypeError("Missing required property 'tos'")
            __props__.__dict__["tos"] = tos
            __props__.__dict__["tfid"] = None
        super(NatRule, __self__).__init__(
            'scm:index/natRule:NatRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active_active_device_binding: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destination_translation: Optional[pulumi.Input[Union['NatRuleDestinationTranslationArgs', 'NatRuleDestinationTranslationArgsDict']]] = None,
            destinations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            dynamic_destination_translation: Optional[pulumi.Input[Union['NatRuleDynamicDestinationTranslationArgs', 'NatRuleDynamicDestinationTranslationArgsDict']]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            froms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nat_type: Optional[pulumi.Input[_builtins.str]] = None,
            position: Optional[pulumi.Input[_builtins.str]] = None,
            service: Optional[pulumi.Input[_builtins.str]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            source_translation: Optional[pulumi.Input[Union['NatRuleSourceTranslationArgs', 'NatRuleSourceTranslationArgsDict']]] = None,
            sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None,
            to_interface: Optional[pulumi.Input[_builtins.str]] = None,
            tos: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'NatRule':
        """
        Get an existing NatRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] active_active_device_binding: Active active device binding
        :param pulumi.Input[_builtins.str] description: NAT rule description
        :param pulumi.Input[Union['NatRuleDestinationTranslationArgs', 'NatRuleDestinationTranslationArgsDict']] destination_translation: Destination translation
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destinations: Destination address(es) of the original packet
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[_builtins.bool] disabled: Disable NAT rule?
        :param pulumi.Input[Union['NatRuleDynamicDestinationTranslationArgs', 'NatRuleDynamicDestinationTranslationArgsDict']] dynamic_destination_translation: Dynamic destination translation
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] froms: Source zone(s) of the original packet
        :param pulumi.Input[_builtins.str] name: NAT rule name
        :param pulumi.Input[_builtins.str] nat_type: NAT type
        :param pulumi.Input[_builtins.str] position: The relative position of the rule
        :param pulumi.Input[_builtins.str] service: The service of the original packet
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[Union['NatRuleSourceTranslationArgs', 'NatRuleSourceTranslationArgsDict']] source_translation: Source translation
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sources: Source address(es) of the original packet
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: NAT rule tags
        :param pulumi.Input[_builtins.str] to_interface: Destination interface of the original packet
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tos: Destination zone of the original packet
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NatRuleState.__new__(_NatRuleState)

        __props__.__dict__["active_active_device_binding"] = active_active_device_binding
        __props__.__dict__["description"] = description
        __props__.__dict__["destination_translation"] = destination_translation
        __props__.__dict__["destinations"] = destinations
        __props__.__dict__["device"] = device
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["dynamic_destination_translation"] = dynamic_destination_translation
        __props__.__dict__["folder"] = folder
        __props__.__dict__["froms"] = froms
        __props__.__dict__["name"] = name
        __props__.__dict__["nat_type"] = nat_type
        __props__.__dict__["position"] = position
        __props__.__dict__["service"] = service
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["source_translation"] = source_translation
        __props__.__dict__["sources"] = sources
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tfid"] = tfid
        __props__.__dict__["to_interface"] = to_interface
        __props__.__dict__["tos"] = tos
        return NatRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="activeActiveDeviceBinding")
    def active_active_device_binding(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Active active device binding
        """
        return pulumi.get(self, "active_active_device_binding")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        NAT rule description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationTranslation")
    def destination_translation(self) -> pulumi.Output[Optional['outputs.NatRuleDestinationTranslation']]:
        """
        Destination translation
        """
        return pulumi.get(self, "destination_translation")

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Destination address(es) of the original packet
        """
        return pulumi.get(self, "destinations")

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Disable NAT rule?
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter(name="dynamicDestinationTranslation")
    def dynamic_destination_translation(self) -> pulumi.Output[Optional['outputs.NatRuleDynamicDestinationTranslation']]:
        """
        Dynamic destination translation
        """
        return pulumi.get(self, "dynamic_destination_translation")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def froms(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Source zone(s) of the original packet
        """
        return pulumi.get(self, "froms")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        NAT rule name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="natType")
    def nat_type(self) -> pulumi.Output[_builtins.str]:
        """
        NAT type
        """
        return pulumi.get(self, "nat_type")

    @_builtins.property
    @pulumi.getter
    def position(self) -> pulumi.Output[_builtins.str]:
        """
        The relative position of the rule
        """
        return pulumi.get(self, "position")

    @_builtins.property
    @pulumi.getter
    def service(self) -> pulumi.Output[_builtins.str]:
        """
        The service of the original packet
        """
        return pulumi.get(self, "service")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter(name="sourceTranslation")
    def source_translation(self) -> pulumi.Output[Optional['outputs.NatRuleSourceTranslation']]:
        """
        Source translation
        """
        return pulumi.get(self, "source_translation")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Source address(es) of the original packet
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        NAT rule tags
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter(name="toInterface")
    def to_interface(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Destination interface of the original packet
        """
        return pulumi.get(self, "to_interface")

    @_builtins.property
    @pulumi.getter
    def tos(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Destination zone of the original packet
        """
        return pulumi.get(self, "tos")

