# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['QosPolicyRuleArgs', 'QosPolicyRule']

@pulumi.input_type
class QosPolicyRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input['QosPolicyRuleActionArgs'],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 dscp_tos: Optional[pulumi.Input['QosPolicyRuleDscpTosArgs']] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 relative_position: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 target_rule: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a QosPolicyRule resource.
        :param pulumi.Input['QosPolicyRuleActionArgs'] action: Action
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input['QosPolicyRuleDscpTosArgs'] dscp_tos: Dscp tos
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: Name
        :param pulumi.Input[_builtins.str] position: The relative position of the rule
        :param pulumi.Input[_builtins.str] relative_position: Relative positioning rule. String must be one of these: `"before"`, `"after"`, `"top"`, `"bottom"`. If not specified, rule is created at the bottom of the ruleset.
        :param pulumi.Input[_builtins.str] schedule: Schedule
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.str] target_rule: The name or UUID of the rule to position this rule relative to. Required when `relative_position` is `"before"` or `"after"`.
        """
        pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if dscp_tos is not None:
            pulumi.set(__self__, "dscp_tos", dscp_tos)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if relative_position is not None:
            pulumi.set(__self__, "relative_position", relative_position)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if target_rule is not None:
            pulumi.set(__self__, "target_rule", target_rule)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input['QosPolicyRuleActionArgs']:
        """
        Action
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input['QosPolicyRuleActionArgs']):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter(name="dscpTos")
    def dscp_tos(self) -> Optional[pulumi.Input['QosPolicyRuleDscpTosArgs']]:
        """
        Dscp tos
        """
        return pulumi.get(self, "dscp_tos")

    @dscp_tos.setter
    def dscp_tos(self, value: Optional[pulumi.Input['QosPolicyRuleDscpTosArgs']]):
        pulumi.set(self, "dscp_tos", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The relative position of the rule
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "position", value)

    @_builtins.property
    @pulumi.getter(name="relativePosition")
    def relative_position(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Relative positioning rule. String must be one of these: `"before"`, `"after"`, `"top"`, `"bottom"`. If not specified, rule is created at the bottom of the ruleset.
        """
        return pulumi.get(self, "relative_position")

    @relative_position.setter
    def relative_position(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "relative_position", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Schedule
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter(name="targetRule")
    def target_rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name or UUID of the rule to position this rule relative to. Required when `relative_position` is `"before"` or `"after"`.
        """
        return pulumi.get(self, "target_rule")

    @target_rule.setter
    def target_rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_rule", value)


@pulumi.input_type
class _QosPolicyRuleState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input['QosPolicyRuleActionArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 dscp_tos: Optional[pulumi.Input['QosPolicyRuleDscpTosArgs']] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 relative_position: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 target_rule: Optional[pulumi.Input[_builtins.str]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering QosPolicyRule resources.
        :param pulumi.Input['QosPolicyRuleActionArgs'] action: Action
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input['QosPolicyRuleDscpTosArgs'] dscp_tos: Dscp tos
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: Name
        :param pulumi.Input[_builtins.str] position: The relative position of the rule
        :param pulumi.Input[_builtins.str] relative_position: Relative positioning rule. String must be one of these: `"before"`, `"after"`, `"top"`, `"bottom"`. If not specified, rule is created at the bottom of the ruleset.
        :param pulumi.Input[_builtins.str] schedule: Schedule
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.str] target_rule: The name or UUID of the rule to position this rule relative to. Required when `relative_position` is `"before"` or `"after"`.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if dscp_tos is not None:
            pulumi.set(__self__, "dscp_tos", dscp_tos)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if relative_position is not None:
            pulumi.set(__self__, "relative_position", relative_position)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if target_rule is not None:
            pulumi.set(__self__, "target_rule", target_rule)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['QosPolicyRuleActionArgs']]:
        """
        Action
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['QosPolicyRuleActionArgs']]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter(name="dscpTos")
    def dscp_tos(self) -> Optional[pulumi.Input['QosPolicyRuleDscpTosArgs']]:
        """
        Dscp tos
        """
        return pulumi.get(self, "dscp_tos")

    @dscp_tos.setter
    def dscp_tos(self, value: Optional[pulumi.Input['QosPolicyRuleDscpTosArgs']]):
        pulumi.set(self, "dscp_tos", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The relative position of the rule
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "position", value)

    @_builtins.property
    @pulumi.getter(name="relativePosition")
    def relative_position(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Relative positioning rule. String must be one of these: `"before"`, `"after"`, `"top"`, `"bottom"`. If not specified, rule is created at the bottom of the ruleset.
        """
        return pulumi.get(self, "relative_position")

    @relative_position.setter
    def relative_position(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "relative_position", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Schedule
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter(name="targetRule")
    def target_rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name or UUID of the rule to position this rule relative to. Required when `relative_position` is `"before"` or `"after"`.
        """
        return pulumi.get(self, "target_rule")

    @target_rule.setter
    def target_rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_rule", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)


@pulumi.type_token("scm:index/qosPolicyRule:QosPolicyRule")
class QosPolicyRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Union['QosPolicyRuleActionArgs', 'QosPolicyRuleActionArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 dscp_tos: Optional[pulumi.Input[Union['QosPolicyRuleDscpTosArgs', 'QosPolicyRuleDscpTosArgsDict']]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 relative_position: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 target_rule: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        QosPolicyRule resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        # --- 2. ANCHOR QOS POLICY RULE (Used for relative positioning) ---
        anchor_qos_rule = scm.QosPolicyRule("anchor_qos_rule",
            name="anchor-qos-rule",
            description="Base rule for testing 'before' and 'after' positioning.",
            folder="All",
            position="pre",
            action={
                "class_": "2",
            },
            schedule="non-work-hours",
            dscp_tos={
                "codepoints": [{
                    "name": "Set-EF",
                    "type": {
                        "ef": {},
                    },
                }],
            })
        # --- 3. ABSOLUTE POSITIONING Examples ("top" and "bottom") ---
        rule_top_qos_rule = scm.QosPolicyRule("rule_top_qos_rule",
            name="top-absolute-qos-rule",
            description="Placed at the very TOP of the QoS rulebase (Highest Priority).",
            folder="All",
            position="pre",
            relative_position="top",
            action={
                "class_": "2",
            })
        rule_bottom_qos_rule = scm.QosPolicyRule("rule_bottom_qos_rule",
            name="bottom-absolute-qos-rule",
            description="Placed at the very BOTTOM of the QoS rulebase (Lowest Priority)",
            folder="All",
            position="pre",
            relative_position="bottom",
            action={
                "class_": "3",
            })
        # --- 4. RELATIVE POSITIONING Examples ("before" and "after") ---
        rule_before_anchor_qos = scm.QosPolicyRule("rule_before_anchor_qos",
            name="before-anchor-qos-rule",
            description="Positioned immediately BEFORE the anchor-qos-rule.",
            folder="All",
            position="pre",
            relative_position="before",
            target_rule=anchor_qos_rule.id,
            action={
                "class_": "5",
            })
        rule_after_anchor_qos = scm.QosPolicyRule("rule_after_anchor_qos",
            name="after-anchor-qos-rule",
            description="Positioned immediately AFTER the anchor-qos-rule.",
            folder="All",
            position="pre",
            relative_position="after",
            target_rule=anchor_qos_rule.id,
            action={
                "class_": "4",
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['QosPolicyRuleActionArgs', 'QosPolicyRuleActionArgsDict']] action: Action
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[Union['QosPolicyRuleDscpTosArgs', 'QosPolicyRuleDscpTosArgsDict']] dscp_tos: Dscp tos
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: Name
        :param pulumi.Input[_builtins.str] position: The relative position of the rule
        :param pulumi.Input[_builtins.str] relative_position: Relative positioning rule. String must be one of these: `"before"`, `"after"`, `"top"`, `"bottom"`. If not specified, rule is created at the bottom of the ruleset.
        :param pulumi.Input[_builtins.str] schedule: Schedule
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.str] target_rule: The name or UUID of the rule to position this rule relative to. Required when `relative_position` is `"before"` or `"after"`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QosPolicyRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        QosPolicyRule resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        # --- 2. ANCHOR QOS POLICY RULE (Used for relative positioning) ---
        anchor_qos_rule = scm.QosPolicyRule("anchor_qos_rule",
            name="anchor-qos-rule",
            description="Base rule for testing 'before' and 'after' positioning.",
            folder="All",
            position="pre",
            action={
                "class_": "2",
            },
            schedule="non-work-hours",
            dscp_tos={
                "codepoints": [{
                    "name": "Set-EF",
                    "type": {
                        "ef": {},
                    },
                }],
            })
        # --- 3. ABSOLUTE POSITIONING Examples ("top" and "bottom") ---
        rule_top_qos_rule = scm.QosPolicyRule("rule_top_qos_rule",
            name="top-absolute-qos-rule",
            description="Placed at the very TOP of the QoS rulebase (Highest Priority).",
            folder="All",
            position="pre",
            relative_position="top",
            action={
                "class_": "2",
            })
        rule_bottom_qos_rule = scm.QosPolicyRule("rule_bottom_qos_rule",
            name="bottom-absolute-qos-rule",
            description="Placed at the very BOTTOM of the QoS rulebase (Lowest Priority)",
            folder="All",
            position="pre",
            relative_position="bottom",
            action={
                "class_": "3",
            })
        # --- 4. RELATIVE POSITIONING Examples ("before" and "after") ---
        rule_before_anchor_qos = scm.QosPolicyRule("rule_before_anchor_qos",
            name="before-anchor-qos-rule",
            description="Positioned immediately BEFORE the anchor-qos-rule.",
            folder="All",
            position="pre",
            relative_position="before",
            target_rule=anchor_qos_rule.id,
            action={
                "class_": "5",
            })
        rule_after_anchor_qos = scm.QosPolicyRule("rule_after_anchor_qos",
            name="after-anchor-qos-rule",
            description="Positioned immediately AFTER the anchor-qos-rule.",
            folder="All",
            position="pre",
            relative_position="after",
            target_rule=anchor_qos_rule.id,
            action={
                "class_": "4",
            })
        ```

        :param str resource_name: The name of the resource.
        :param QosPolicyRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QosPolicyRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Union['QosPolicyRuleActionArgs', 'QosPolicyRuleActionArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 dscp_tos: Optional[pulumi.Input[Union['QosPolicyRuleDscpTosArgs', 'QosPolicyRuleDscpTosArgsDict']]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[_builtins.str]] = None,
                 relative_position: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 target_rule: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QosPolicyRuleArgs.__new__(QosPolicyRuleArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            __props__.__dict__["description"] = description
            __props__.__dict__["device"] = device
            __props__.__dict__["dscp_tos"] = dscp_tos
            __props__.__dict__["folder"] = folder
            __props__.__dict__["name"] = name
            __props__.__dict__["position"] = position
            __props__.__dict__["relative_position"] = relative_position
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["snippet"] = snippet
            __props__.__dict__["target_rule"] = target_rule
            __props__.__dict__["tfid"] = None
        super(QosPolicyRule, __self__).__init__(
            'scm:index/qosPolicyRule:QosPolicyRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[Union['QosPolicyRuleActionArgs', 'QosPolicyRuleActionArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            dscp_tos: Optional[pulumi.Input[Union['QosPolicyRuleDscpTosArgs', 'QosPolicyRuleDscpTosArgsDict']]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            position: Optional[pulumi.Input[_builtins.str]] = None,
            relative_position: Optional[pulumi.Input[_builtins.str]] = None,
            schedule: Optional[pulumi.Input[_builtins.str]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            target_rule: Optional[pulumi.Input[_builtins.str]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None) -> 'QosPolicyRule':
        """
        Get an existing QosPolicyRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['QosPolicyRuleActionArgs', 'QosPolicyRuleActionArgsDict']] action: Action
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[Union['QosPolicyRuleDscpTosArgs', 'QosPolicyRuleDscpTosArgsDict']] dscp_tos: Dscp tos
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] name: Name
        :param pulumi.Input[_builtins.str] position: The relative position of the rule
        :param pulumi.Input[_builtins.str] relative_position: Relative positioning rule. String must be one of these: `"before"`, `"after"`, `"top"`, `"bottom"`. If not specified, rule is created at the bottom of the ruleset.
        :param pulumi.Input[_builtins.str] schedule: Schedule
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.str] target_rule: The name or UUID of the rule to position this rule relative to. Required when `relative_position` is `"before"` or `"after"`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QosPolicyRuleState.__new__(_QosPolicyRuleState)

        __props__.__dict__["action"] = action
        __props__.__dict__["description"] = description
        __props__.__dict__["device"] = device
        __props__.__dict__["dscp_tos"] = dscp_tos
        __props__.__dict__["folder"] = folder
        __props__.__dict__["name"] = name
        __props__.__dict__["position"] = position
        __props__.__dict__["relative_position"] = relative_position
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["target_rule"] = target_rule
        __props__.__dict__["tfid"] = tfid
        return QosPolicyRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output['outputs.QosPolicyRuleAction']:
        """
        Action
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter(name="dscpTos")
    def dscp_tos(self) -> pulumi.Output[Optional['outputs.QosPolicyRuleDscpTos']]:
        """
        Dscp tos
        """
        return pulumi.get(self, "dscp_tos")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def position(self) -> pulumi.Output[_builtins.str]:
        """
        The relative position of the rule
        """
        return pulumi.get(self, "position")

    @_builtins.property
    @pulumi.getter(name="relativePosition")
    def relative_position(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Relative positioning rule. String must be one of these: `"before"`, `"after"`, `"top"`, `"bottom"`. If not specified, rule is created at the bottom of the ruleset.
        """
        return pulumi.get(self, "relative_position")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Schedule
        """
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter(name="targetRule")
    def target_rule(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name or UUID of the rule to position this rule relative to. Required when `relative_position` is `"before"` or `"after"`.
        """
        return pulumi.get(self, "target_rule")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

