# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceConnectionArgs', 'ServiceConnection']

@pulumi.input_type
class ServiceConnectionArgs:
    def __init__(__self__, *,
                 ipsec_tunnel: pulumi.Input[_builtins.str],
                 region: pulumi.Input[_builtins.str],
                 backup_sc: Optional[pulumi.Input[_builtins.str]] = None,
                 bgp_peer: Optional[pulumi.Input['ServiceConnectionBgpPeerArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 no_export_community: Optional[pulumi.Input[_builtins.str]] = None,
                 onboarding_type: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input['ServiceConnectionProtocolArgs']] = None,
                 qos: Optional[pulumi.Input['ServiceConnectionQosArgs']] = None,
                 secondary_ipsec_tunnel: Optional[pulumi.Input[_builtins.str]] = None,
                 source_nat: Optional[pulumi.Input[_builtins.bool]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ServiceConnection resource.
        :param pulumi.Input[_builtins.str] ipsec_tunnel: Ipsec tunnel
        :param pulumi.Input[_builtins.str] region: Region
        :param pulumi.Input[_builtins.str] backup_sc: Backup s c
        :param pulumi.Input['ServiceConnectionBgpPeerArgs'] bgp_peer: Bgp peer
        :param pulumi.Input[_builtins.str] name: The name of the service connection
        :param pulumi.Input[_builtins.str] nat_pool: Nat pool
        :param pulumi.Input[_builtins.str] no_export_community: No export community
        :param pulumi.Input[_builtins.str] onboarding_type: Onboarding type
        :param pulumi.Input['ServiceConnectionProtocolArgs'] protocol: Protocol
        :param pulumi.Input['ServiceConnectionQosArgs'] qos: Qos
        :param pulumi.Input[_builtins.str] secondary_ipsec_tunnel: Secondary ipsec tunnel
        :param pulumi.Input[_builtins.bool] source_nat: Source nat
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnets: Subnets
        """
        pulumi.set(__self__, "ipsec_tunnel", ipsec_tunnel)
        pulumi.set(__self__, "region", region)
        if backup_sc is not None:
            pulumi.set(__self__, "backup_sc", backup_sc)
        if bgp_peer is not None:
            pulumi.set(__self__, "bgp_peer", bgp_peer)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat_pool is not None:
            pulumi.set(__self__, "nat_pool", nat_pool)
        if no_export_community is not None:
            pulumi.set(__self__, "no_export_community", no_export_community)
        if onboarding_type is not None:
            pulumi.set(__self__, "onboarding_type", onboarding_type)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if qos is not None:
            pulumi.set(__self__, "qos", qos)
        if secondary_ipsec_tunnel is not None:
            pulumi.set(__self__, "secondary_ipsec_tunnel", secondary_ipsec_tunnel)
        if source_nat is not None:
            pulumi.set(__self__, "source_nat", source_nat)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)

    @_builtins.property
    @pulumi.getter(name="ipsecTunnel")
    def ipsec_tunnel(self) -> pulumi.Input[_builtins.str]:
        """
        Ipsec tunnel
        """
        return pulumi.get(self, "ipsec_tunnel")

    @ipsec_tunnel.setter
    def ipsec_tunnel(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ipsec_tunnel", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        Region
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="backupSc")
    def backup_sc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backup s c
        """
        return pulumi.get(self, "backup_sc")

    @backup_sc.setter
    def backup_sc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_sc", value)

    @_builtins.property
    @pulumi.getter(name="bgpPeer")
    def bgp_peer(self) -> Optional[pulumi.Input['ServiceConnectionBgpPeerArgs']]:
        """
        Bgp peer
        """
        return pulumi.get(self, "bgp_peer")

    @bgp_peer.setter
    def bgp_peer(self, value: Optional[pulumi.Input['ServiceConnectionBgpPeerArgs']]):
        pulumi.set(self, "bgp_peer", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service connection
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="natPool")
    def nat_pool(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Nat pool
        """
        return pulumi.get(self, "nat_pool")

    @nat_pool.setter
    def nat_pool(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nat_pool", value)

    @_builtins.property
    @pulumi.getter(name="noExportCommunity")
    def no_export_community(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        No export community
        """
        return pulumi.get(self, "no_export_community")

    @no_export_community.setter
    def no_export_community(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "no_export_community", value)

    @_builtins.property
    @pulumi.getter(name="onboardingType")
    def onboarding_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Onboarding type
        """
        return pulumi.get(self, "onboarding_type")

    @onboarding_type.setter
    def onboarding_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "onboarding_type", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input['ServiceConnectionProtocolArgs']]:
        """
        Protocol
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input['ServiceConnectionProtocolArgs']]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def qos(self) -> Optional[pulumi.Input['ServiceConnectionQosArgs']]:
        """
        Qos
        """
        return pulumi.get(self, "qos")

    @qos.setter
    def qos(self, value: Optional[pulumi.Input['ServiceConnectionQosArgs']]):
        pulumi.set(self, "qos", value)

    @_builtins.property
    @pulumi.getter(name="secondaryIpsecTunnel")
    def secondary_ipsec_tunnel(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Secondary ipsec tunnel
        """
        return pulumi.get(self, "secondary_ipsec_tunnel")

    @secondary_ipsec_tunnel.setter
    def secondary_ipsec_tunnel(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_ipsec_tunnel", value)

    @_builtins.property
    @pulumi.getter(name="sourceNat")
    def source_nat(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Source nat
        """
        return pulumi.get(self, "source_nat")

    @source_nat.setter
    def source_nat(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "source_nat", value)

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Subnets
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "subnets", value)


@pulumi.input_type
class _ServiceConnectionState:
    def __init__(__self__, *,
                 backup_sc: Optional[pulumi.Input[_builtins.str]] = None,
                 bgp_peer: Optional[pulumi.Input['ServiceConnectionBgpPeerArgs']] = None,
                 encrypted_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ipsec_tunnel: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 no_export_community: Optional[pulumi.Input[_builtins.str]] = None,
                 onboarding_type: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input['ServiceConnectionProtocolArgs']] = None,
                 qos: Optional[pulumi.Input['ServiceConnectionQosArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_ipsec_tunnel: Optional[pulumi.Input[_builtins.str]] = None,
                 source_nat: Optional[pulumi.Input[_builtins.bool]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceConnection resources.
        :param pulumi.Input[_builtins.str] backup_sc: Backup s c
        :param pulumi.Input['ServiceConnectionBgpPeerArgs'] bgp_peer: Bgp peer
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] encrypted_values: Map of sensitive values returned from the API.
        :param pulumi.Input[_builtins.str] ipsec_tunnel: Ipsec tunnel
        :param pulumi.Input[_builtins.str] name: The name of the service connection
        :param pulumi.Input[_builtins.str] nat_pool: Nat pool
        :param pulumi.Input[_builtins.str] no_export_community: No export community
        :param pulumi.Input[_builtins.str] onboarding_type: Onboarding type
        :param pulumi.Input['ServiceConnectionProtocolArgs'] protocol: Protocol
        :param pulumi.Input['ServiceConnectionQosArgs'] qos: Qos
        :param pulumi.Input[_builtins.str] region: Region
        :param pulumi.Input[_builtins.str] secondary_ipsec_tunnel: Secondary ipsec tunnel
        :param pulumi.Input[_builtins.bool] source_nat: Source nat
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnets: Subnets
        """
        if backup_sc is not None:
            pulumi.set(__self__, "backup_sc", backup_sc)
        if bgp_peer is not None:
            pulumi.set(__self__, "bgp_peer", bgp_peer)
        if encrypted_values is not None:
            pulumi.set(__self__, "encrypted_values", encrypted_values)
        if ipsec_tunnel is not None:
            pulumi.set(__self__, "ipsec_tunnel", ipsec_tunnel)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat_pool is not None:
            pulumi.set(__self__, "nat_pool", nat_pool)
        if no_export_community is not None:
            pulumi.set(__self__, "no_export_community", no_export_community)
        if onboarding_type is not None:
            pulumi.set(__self__, "onboarding_type", onboarding_type)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if qos is not None:
            pulumi.set(__self__, "qos", qos)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secondary_ipsec_tunnel is not None:
            pulumi.set(__self__, "secondary_ipsec_tunnel", secondary_ipsec_tunnel)
        if source_nat is not None:
            pulumi.set(__self__, "source_nat", source_nat)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)

    @_builtins.property
    @pulumi.getter(name="backupSc")
    def backup_sc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backup s c
        """
        return pulumi.get(self, "backup_sc")

    @backup_sc.setter
    def backup_sc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_sc", value)

    @_builtins.property
    @pulumi.getter(name="bgpPeer")
    def bgp_peer(self) -> Optional[pulumi.Input['ServiceConnectionBgpPeerArgs']]:
        """
        Bgp peer
        """
        return pulumi.get(self, "bgp_peer")

    @bgp_peer.setter
    def bgp_peer(self, value: Optional[pulumi.Input['ServiceConnectionBgpPeerArgs']]):
        pulumi.set(self, "bgp_peer", value)

    @_builtins.property
    @pulumi.getter(name="encryptedValues")
    def encrypted_values(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of sensitive values returned from the API.
        """
        return pulumi.get(self, "encrypted_values")

    @encrypted_values.setter
    def encrypted_values(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "encrypted_values", value)

    @_builtins.property
    @pulumi.getter(name="ipsecTunnel")
    def ipsec_tunnel(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Ipsec tunnel
        """
        return pulumi.get(self, "ipsec_tunnel")

    @ipsec_tunnel.setter
    def ipsec_tunnel(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipsec_tunnel", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service connection
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="natPool")
    def nat_pool(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Nat pool
        """
        return pulumi.get(self, "nat_pool")

    @nat_pool.setter
    def nat_pool(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nat_pool", value)

    @_builtins.property
    @pulumi.getter(name="noExportCommunity")
    def no_export_community(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        No export community
        """
        return pulumi.get(self, "no_export_community")

    @no_export_community.setter
    def no_export_community(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "no_export_community", value)

    @_builtins.property
    @pulumi.getter(name="onboardingType")
    def onboarding_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Onboarding type
        """
        return pulumi.get(self, "onboarding_type")

    @onboarding_type.setter
    def onboarding_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "onboarding_type", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input['ServiceConnectionProtocolArgs']]:
        """
        Protocol
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input['ServiceConnectionProtocolArgs']]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def qos(self) -> Optional[pulumi.Input['ServiceConnectionQosArgs']]:
        """
        Qos
        """
        return pulumi.get(self, "qos")

    @qos.setter
    def qos(self, value: Optional[pulumi.Input['ServiceConnectionQosArgs']]):
        pulumi.set(self, "qos", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="secondaryIpsecTunnel")
    def secondary_ipsec_tunnel(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Secondary ipsec tunnel
        """
        return pulumi.get(self, "secondary_ipsec_tunnel")

    @secondary_ipsec_tunnel.setter
    def secondary_ipsec_tunnel(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_ipsec_tunnel", value)

    @_builtins.property
    @pulumi.getter(name="sourceNat")
    def source_nat(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Source nat
        """
        return pulumi.get(self, "source_nat")

    @source_nat.setter
    def source_nat(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "source_nat", value)

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Subnets
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "subnets", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)


@pulumi.type_token("scm:index/serviceConnection:ServiceConnection")
class ServiceConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_sc: Optional[pulumi.Input[_builtins.str]] = None,
                 bgp_peer: Optional[pulumi.Input[Union['ServiceConnectionBgpPeerArgs', 'ServiceConnectionBgpPeerArgsDict']]] = None,
                 ipsec_tunnel: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 no_export_community: Optional[pulumi.Input[_builtins.str]] = None,
                 onboarding_type: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[Union['ServiceConnectionProtocolArgs', 'ServiceConnectionProtocolArgsDict']]] = None,
                 qos: Optional[pulumi.Input[Union['ServiceConnectionQosArgs', 'ServiceConnectionQosArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_ipsec_tunnel: Optional[pulumi.Input[_builtins.str]] = None,
                 source_nat: Optional[pulumi.Input[_builtins.bool]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ServiceConnection resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        config = pulumi.Config()
        # The folder scope for the SCM resource (e.g., 'Shared', 'Predefined', or a specific folder name).
        folder_scope = config.get("folderScope")
        if folder_scope is None:
            folder_scope = "Service Connections"
        ## 1. Define the IKE Crypto Profile (IKE Phase 1)
        # Note: The resource name is plural: "scm_ike_crypto_profile"
        example = scm.IkeCryptoProfile("example",
            name="example-ike-crypto",
            folder=folder_scope,
            hashes=["sha256"],
            dh_groups=["group14"],
            encryptions=["aes-256-cbc"])
        ## 2. Define the IPsec Crypto Profile (IKE Phase 2)
        # Note: The resource name is plural and nested blocks now use an equals sign (=).
        example_ipsec_crypto_profile = scm.IpsecCryptoProfile("example",
            name="panw-IPSec-Crypto",
            folder=folder_scope,
            esp={
                "encryptions": ["aes-256-gcm"],
                "authentications": ["sha256"],
            },
            dh_group="group14",
            lifetime={
                "hours": 8,
            })
        ## 3. Define the IKE Gateway
        # Note: The resource name is plural and nested blocks now use an equals sign (=).
        example_ike_gateway = scm.IkeGateway("example",
            name="example-gateway",
            folder=folder_scope,
            peer_address={
                "ip": "1.1.1.1",
            },
            authentication={
                "pre_shared_key": {
                    "key": "secret",
                },
            },
            protocol={
                "ikev1": {
                    "ike_crypto_profile": example.name,
                },
            })
        ## 4. Define the IPsec Tunnel
        # Note: Nested 'auto_key' block uses an equals sign (=).
        example_ipsec_tunnel = scm.IpsecTunnel("example",
            name="example-tunnel",
            folder=folder_scope,
            tunnel_interface="tunnel",
            anti_replay=True,
            copy_tos=False,
            enable_gre_encapsulation=False,
            auto_key={
                "ike_gateways": [{
                    "name": example_ike_gateway.name,
                }],
                "ipsec_crypto_profile": example_ipsec_crypto_profile.name,
            },
            opts = pulumi.ResourceOptions(depends_on=[example_ike_gateway]))
        site_a_vpn_sc = scm.ServiceConnection("site_a_vpn_sc",
            name="creating_a_service_connection",
            region="us-west-1",
            ipsec_tunnel=example_ipsec_tunnel.name,
            subnets=[
                "10.1.0.0/16",
                "172.16.0.0/24",
            ],
            source_nat=True)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_sc: Backup s c
        :param pulumi.Input[Union['ServiceConnectionBgpPeerArgs', 'ServiceConnectionBgpPeerArgsDict']] bgp_peer: Bgp peer
        :param pulumi.Input[_builtins.str] ipsec_tunnel: Ipsec tunnel
        :param pulumi.Input[_builtins.str] name: The name of the service connection
        :param pulumi.Input[_builtins.str] nat_pool: Nat pool
        :param pulumi.Input[_builtins.str] no_export_community: No export community
        :param pulumi.Input[_builtins.str] onboarding_type: Onboarding type
        :param pulumi.Input[Union['ServiceConnectionProtocolArgs', 'ServiceConnectionProtocolArgsDict']] protocol: Protocol
        :param pulumi.Input[Union['ServiceConnectionQosArgs', 'ServiceConnectionQosArgsDict']] qos: Qos
        :param pulumi.Input[_builtins.str] region: Region
        :param pulumi.Input[_builtins.str] secondary_ipsec_tunnel: Secondary ipsec tunnel
        :param pulumi.Input[_builtins.bool] source_nat: Source nat
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnets: Subnets
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ServiceConnection resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        config = pulumi.Config()
        # The folder scope for the SCM resource (e.g., 'Shared', 'Predefined', or a specific folder name).
        folder_scope = config.get("folderScope")
        if folder_scope is None:
            folder_scope = "Service Connections"
        ## 1. Define the IKE Crypto Profile (IKE Phase 1)
        # Note: The resource name is plural: "scm_ike_crypto_profile"
        example = scm.IkeCryptoProfile("example",
            name="example-ike-crypto",
            folder=folder_scope,
            hashes=["sha256"],
            dh_groups=["group14"],
            encryptions=["aes-256-cbc"])
        ## 2. Define the IPsec Crypto Profile (IKE Phase 2)
        # Note: The resource name is plural and nested blocks now use an equals sign (=).
        example_ipsec_crypto_profile = scm.IpsecCryptoProfile("example",
            name="panw-IPSec-Crypto",
            folder=folder_scope,
            esp={
                "encryptions": ["aes-256-gcm"],
                "authentications": ["sha256"],
            },
            dh_group="group14",
            lifetime={
                "hours": 8,
            })
        ## 3. Define the IKE Gateway
        # Note: The resource name is plural and nested blocks now use an equals sign (=).
        example_ike_gateway = scm.IkeGateway("example",
            name="example-gateway",
            folder=folder_scope,
            peer_address={
                "ip": "1.1.1.1",
            },
            authentication={
                "pre_shared_key": {
                    "key": "secret",
                },
            },
            protocol={
                "ikev1": {
                    "ike_crypto_profile": example.name,
                },
            })
        ## 4. Define the IPsec Tunnel
        # Note: Nested 'auto_key' block uses an equals sign (=).
        example_ipsec_tunnel = scm.IpsecTunnel("example",
            name="example-tunnel",
            folder=folder_scope,
            tunnel_interface="tunnel",
            anti_replay=True,
            copy_tos=False,
            enable_gre_encapsulation=False,
            auto_key={
                "ike_gateways": [{
                    "name": example_ike_gateway.name,
                }],
                "ipsec_crypto_profile": example_ipsec_crypto_profile.name,
            },
            opts = pulumi.ResourceOptions(depends_on=[example_ike_gateway]))
        site_a_vpn_sc = scm.ServiceConnection("site_a_vpn_sc",
            name="creating_a_service_connection",
            region="us-west-1",
            ipsec_tunnel=example_ipsec_tunnel.name,
            subnets=[
                "10.1.0.0/16",
                "172.16.0.0/24",
            ],
            source_nat=True)
        ```

        :param str resource_name: The name of the resource.
        :param ServiceConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_sc: Optional[pulumi.Input[_builtins.str]] = None,
                 bgp_peer: Optional[pulumi.Input[Union['ServiceConnectionBgpPeerArgs', 'ServiceConnectionBgpPeerArgsDict']]] = None,
                 ipsec_tunnel: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 no_export_community: Optional[pulumi.Input[_builtins.str]] = None,
                 onboarding_type: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[Union['ServiceConnectionProtocolArgs', 'ServiceConnectionProtocolArgsDict']]] = None,
                 qos: Optional[pulumi.Input[Union['ServiceConnectionQosArgs', 'ServiceConnectionQosArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_ipsec_tunnel: Optional[pulumi.Input[_builtins.str]] = None,
                 source_nat: Optional[pulumi.Input[_builtins.bool]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceConnectionArgs.__new__(ServiceConnectionArgs)

            __props__.__dict__["backup_sc"] = backup_sc
            __props__.__dict__["bgp_peer"] = bgp_peer
            if ipsec_tunnel is None and not opts.urn:
                raise TypeError("Missing required property 'ipsec_tunnel'")
            __props__.__dict__["ipsec_tunnel"] = ipsec_tunnel
            __props__.__dict__["name"] = name
            __props__.__dict__["nat_pool"] = nat_pool
            __props__.__dict__["no_export_community"] = no_export_community
            __props__.__dict__["onboarding_type"] = onboarding_type
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["qos"] = qos
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["secondary_ipsec_tunnel"] = secondary_ipsec_tunnel
            __props__.__dict__["source_nat"] = source_nat
            __props__.__dict__["subnets"] = subnets
            __props__.__dict__["encrypted_values"] = None
            __props__.__dict__["tfid"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["encryptedValues"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ServiceConnection, __self__).__init__(
            'scm:index/serviceConnection:ServiceConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_sc: Optional[pulumi.Input[_builtins.str]] = None,
            bgp_peer: Optional[pulumi.Input[Union['ServiceConnectionBgpPeerArgs', 'ServiceConnectionBgpPeerArgsDict']]] = None,
            encrypted_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            ipsec_tunnel: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nat_pool: Optional[pulumi.Input[_builtins.str]] = None,
            no_export_community: Optional[pulumi.Input[_builtins.str]] = None,
            onboarding_type: Optional[pulumi.Input[_builtins.str]] = None,
            protocol: Optional[pulumi.Input[Union['ServiceConnectionProtocolArgs', 'ServiceConnectionProtocolArgsDict']]] = None,
            qos: Optional[pulumi.Input[Union['ServiceConnectionQosArgs', 'ServiceConnectionQosArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_ipsec_tunnel: Optional[pulumi.Input[_builtins.str]] = None,
            source_nat: Optional[pulumi.Input[_builtins.bool]] = None,
            subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServiceConnection':
        """
        Get an existing ServiceConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_sc: Backup s c
        :param pulumi.Input[Union['ServiceConnectionBgpPeerArgs', 'ServiceConnectionBgpPeerArgsDict']] bgp_peer: Bgp peer
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] encrypted_values: Map of sensitive values returned from the API.
        :param pulumi.Input[_builtins.str] ipsec_tunnel: Ipsec tunnel
        :param pulumi.Input[_builtins.str] name: The name of the service connection
        :param pulumi.Input[_builtins.str] nat_pool: Nat pool
        :param pulumi.Input[_builtins.str] no_export_community: No export community
        :param pulumi.Input[_builtins.str] onboarding_type: Onboarding type
        :param pulumi.Input[Union['ServiceConnectionProtocolArgs', 'ServiceConnectionProtocolArgsDict']] protocol: Protocol
        :param pulumi.Input[Union['ServiceConnectionQosArgs', 'ServiceConnectionQosArgsDict']] qos: Qos
        :param pulumi.Input[_builtins.str] region: Region
        :param pulumi.Input[_builtins.str] secondary_ipsec_tunnel: Secondary ipsec tunnel
        :param pulumi.Input[_builtins.bool] source_nat: Source nat
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnets: Subnets
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceConnectionState.__new__(_ServiceConnectionState)

        __props__.__dict__["backup_sc"] = backup_sc
        __props__.__dict__["bgp_peer"] = bgp_peer
        __props__.__dict__["encrypted_values"] = encrypted_values
        __props__.__dict__["ipsec_tunnel"] = ipsec_tunnel
        __props__.__dict__["name"] = name
        __props__.__dict__["nat_pool"] = nat_pool
        __props__.__dict__["no_export_community"] = no_export_community
        __props__.__dict__["onboarding_type"] = onboarding_type
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["qos"] = qos
        __props__.__dict__["region"] = region
        __props__.__dict__["secondary_ipsec_tunnel"] = secondary_ipsec_tunnel
        __props__.__dict__["source_nat"] = source_nat
        __props__.__dict__["subnets"] = subnets
        __props__.__dict__["tfid"] = tfid
        return ServiceConnection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupSc")
    def backup_sc(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Backup s c
        """
        return pulumi.get(self, "backup_sc")

    @_builtins.property
    @pulumi.getter(name="bgpPeer")
    def bgp_peer(self) -> pulumi.Output[Optional['outputs.ServiceConnectionBgpPeer']]:
        """
        Bgp peer
        """
        return pulumi.get(self, "bgp_peer")

    @_builtins.property
    @pulumi.getter(name="encryptedValues")
    def encrypted_values(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of sensitive values returned from the API.
        """
        return pulumi.get(self, "encrypted_values")

    @_builtins.property
    @pulumi.getter(name="ipsecTunnel")
    def ipsec_tunnel(self) -> pulumi.Output[_builtins.str]:
        """
        Ipsec tunnel
        """
        return pulumi.get(self, "ipsec_tunnel")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the service connection
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="natPool")
    def nat_pool(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Nat pool
        """
        return pulumi.get(self, "nat_pool")

    @_builtins.property
    @pulumi.getter(name="noExportCommunity")
    def no_export_community(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        No export community
        """
        return pulumi.get(self, "no_export_community")

    @_builtins.property
    @pulumi.getter(name="onboardingType")
    def onboarding_type(self) -> pulumi.Output[_builtins.str]:
        """
        Onboarding type
        """
        return pulumi.get(self, "onboarding_type")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional['outputs.ServiceConnectionProtocol']]:
        """
        Protocol
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def qos(self) -> pulumi.Output[Optional['outputs.ServiceConnectionQos']]:
        """
        Qos
        """
        return pulumi.get(self, "qos")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secondaryIpsecTunnel")
    def secondary_ipsec_tunnel(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Secondary ipsec tunnel
        """
        return pulumi.get(self, "secondary_ipsec_tunnel")

    @_builtins.property
    @pulumi.getter(name="sourceNat")
    def source_nat(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Source nat
        """
        return pulumi.get(self, "source_nat")

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Subnets
        """
        return pulumi.get(self, "subnets")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

