# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VlanInterfaceArgs', 'VlanInterface']

@pulumi.input_type
class VlanInterfaceArgs:
    def __init__(__self__, *,
                 arps: Optional[pulumi.Input[Sequence[pulumi.Input['VlanInterfaceArpArgs']]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 ddns_config: Optional[pulumi.Input['VlanInterfaceDdnsConfigArgs']] = None,
                 default_value: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcp_client: Optional[pulumi.Input['VlanInterfaceDhcpClientArgs']] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_management_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input['VlanInterfaceIpArgs']]]] = None,
                 mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_tag: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VlanInterface resource.
        :param pulumi.Input[Sequence[pulumi.Input['VlanInterfaceArpArgs']]] arps: ARP configuration
        :param pulumi.Input[_builtins.str] comment: Description
        :param pulumi.Input['VlanInterfaceDdnsConfigArgs'] ddns_config: Dynamic DNS configuration specific to the Vlan Interfaces.
        :param pulumi.Input[_builtins.str] default_value: Default interface assignment
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input['VlanInterfaceDhcpClientArgs'] dhcp_client: Vlan interfaces DHCP Client Object
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] interface_management_profile: Interface management profile
        :param pulumi.Input[Sequence[pulumi.Input['VlanInterfaceIpArgs']]] ips: VLAN Interface IP Parent
        :param pulumi.Input[_builtins.int] mtu: MTU
        :param pulumi.Input[_builtins.str] name: L3 sub-interface name
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.str] vlan_tag: VLAN tag
        """
        if arps is not None:
            pulumi.set(__self__, "arps", arps)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if ddns_config is not None:
            pulumi.set(__self__, "ddns_config", ddns_config)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if dhcp_client is not None:
            pulumi.set(__self__, "dhcp_client", dhcp_client)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if interface_management_profile is not None:
            pulumi.set(__self__, "interface_management_profile", interface_management_profile)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if vlan_tag is not None:
            pulumi.set(__self__, "vlan_tag", vlan_tag)

    @_builtins.property
    @pulumi.getter
    def arps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VlanInterfaceArpArgs']]]]:
        """
        ARP configuration
        """
        return pulumi.get(self, "arps")

    @arps.setter
    def arps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VlanInterfaceArpArgs']]]]):
        pulumi.set(self, "arps", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="ddnsConfig")
    def ddns_config(self) -> Optional[pulumi.Input['VlanInterfaceDdnsConfigArgs']]:
        """
        Dynamic DNS configuration specific to the Vlan Interfaces.
        """
        return pulumi.get(self, "ddns_config")

    @ddns_config.setter
    def ddns_config(self, value: Optional[pulumi.Input['VlanInterfaceDdnsConfigArgs']]):
        pulumi.set(self, "ddns_config", value)

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default interface assignment
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_value", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter(name="dhcpClient")
    def dhcp_client(self) -> Optional[pulumi.Input['VlanInterfaceDhcpClientArgs']]:
        """
        Vlan interfaces DHCP Client Object
        """
        return pulumi.get(self, "dhcp_client")

    @dhcp_client.setter
    def dhcp_client(self, value: Optional[pulumi.Input['VlanInterfaceDhcpClientArgs']]):
        pulumi.set(self, "dhcp_client", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="interfaceManagementProfile")
    def interface_management_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Interface management profile
        """
        return pulumi.get(self, "interface_management_profile")

    @interface_management_profile.setter
    def interface_management_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interface_management_profile", value)

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VlanInterfaceIpArgs']]]]:
        """
        VLAN Interface IP Parent
        """
        return pulumi.get(self, "ips")

    @ips.setter
    def ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VlanInterfaceIpArgs']]]]):
        pulumi.set(self, "ips", value)

    @_builtins.property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        MTU
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mtu", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        L3 sub-interface name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter(name="vlanTag")
    def vlan_tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VLAN tag
        """
        return pulumi.get(self, "vlan_tag")

    @vlan_tag.setter
    def vlan_tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vlan_tag", value)


@pulumi.input_type
class _VlanInterfaceState:
    def __init__(__self__, *,
                 arps: Optional[pulumi.Input[Sequence[pulumi.Input['VlanInterfaceArpArgs']]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 ddns_config: Optional[pulumi.Input['VlanInterfaceDdnsConfigArgs']] = None,
                 default_value: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcp_client: Optional[pulumi.Input['VlanInterfaceDhcpClientArgs']] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_management_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input['VlanInterfaceIpArgs']]]] = None,
                 mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 tfid: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_tag: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VlanInterface resources.
        :param pulumi.Input[Sequence[pulumi.Input['VlanInterfaceArpArgs']]] arps: ARP configuration
        :param pulumi.Input[_builtins.str] comment: Description
        :param pulumi.Input['VlanInterfaceDdnsConfigArgs'] ddns_config: Dynamic DNS configuration specific to the Vlan Interfaces.
        :param pulumi.Input[_builtins.str] default_value: Default interface assignment
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input['VlanInterfaceDhcpClientArgs'] dhcp_client: Vlan interfaces DHCP Client Object
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] interface_management_profile: Interface management profile
        :param pulumi.Input[Sequence[pulumi.Input['VlanInterfaceIpArgs']]] ips: VLAN Interface IP Parent
        :param pulumi.Input[_builtins.int] mtu: MTU
        :param pulumi.Input[_builtins.str] name: L3 sub-interface name
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.str] vlan_tag: VLAN tag
        """
        if arps is not None:
            pulumi.set(__self__, "arps", arps)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if ddns_config is not None:
            pulumi.set(__self__, "ddns_config", ddns_config)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if dhcp_client is not None:
            pulumi.set(__self__, "dhcp_client", dhcp_client)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if interface_management_profile is not None:
            pulumi.set(__self__, "interface_management_profile", interface_management_profile)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snippet is not None:
            pulumi.set(__self__, "snippet", snippet)
        if tfid is not None:
            pulumi.set(__self__, "tfid", tfid)
        if vlan_tag is not None:
            pulumi.set(__self__, "vlan_tag", vlan_tag)

    @_builtins.property
    @pulumi.getter
    def arps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VlanInterfaceArpArgs']]]]:
        """
        ARP configuration
        """
        return pulumi.get(self, "arps")

    @arps.setter
    def arps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VlanInterfaceArpArgs']]]]):
        pulumi.set(self, "arps", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="ddnsConfig")
    def ddns_config(self) -> Optional[pulumi.Input['VlanInterfaceDdnsConfigArgs']]:
        """
        Dynamic DNS configuration specific to the Vlan Interfaces.
        """
        return pulumi.get(self, "ddns_config")

    @ddns_config.setter
    def ddns_config(self, value: Optional[pulumi.Input['VlanInterfaceDdnsConfigArgs']]):
        pulumi.set(self, "ddns_config", value)

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default interface assignment
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_value", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter(name="dhcpClient")
    def dhcp_client(self) -> Optional[pulumi.Input['VlanInterfaceDhcpClientArgs']]:
        """
        Vlan interfaces DHCP Client Object
        """
        return pulumi.get(self, "dhcp_client")

    @dhcp_client.setter
    def dhcp_client(self, value: Optional[pulumi.Input['VlanInterfaceDhcpClientArgs']]):
        pulumi.set(self, "dhcp_client", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="interfaceManagementProfile")
    def interface_management_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Interface management profile
        """
        return pulumi.get(self, "interface_management_profile")

    @interface_management_profile.setter
    def interface_management_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interface_management_profile", value)

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VlanInterfaceIpArgs']]]]:
        """
        VLAN Interface IP Parent
        """
        return pulumi.get(self, "ips")

    @ips.setter
    def ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VlanInterfaceIpArgs']]]]):
        pulumi.set(self, "ips", value)

    @_builtins.property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        MTU
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mtu", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        L3 sub-interface name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @snippet.setter
    def snippet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snippet", value)

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tfid")

    @tfid.setter
    def tfid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tfid", value)

    @_builtins.property
    @pulumi.getter(name="vlanTag")
    def vlan_tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VLAN tag
        """
        return pulumi.get(self, "vlan_tag")

    @vlan_tag.setter
    def vlan_tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vlan_tag", value)


@pulumi.type_token("scm:index/vlanInterface:VlanInterface")
class VlanInterface(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VlanInterfaceArpArgs', 'VlanInterfaceArpArgsDict']]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 ddns_config: Optional[pulumi.Input[Union['VlanInterfaceDdnsConfigArgs', 'VlanInterfaceDdnsConfigArgsDict']]] = None,
                 default_value: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcp_client: Optional[pulumi.Input[Union['VlanInterfaceDhcpClientArgs', 'VlanInterfaceDhcpClientArgsDict']]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_management_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VlanInterfaceIpArgs', 'VlanInterfaceIpArgsDict']]]]] = None,
                 mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        VlanInterface resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        #
        # Creates a vlan interface used as parent-interface for subsequent examples
        #
        scm_vlan_interface_ipv4 = scm.VlanInterface("scm_vlan_interface_ipv4",
            name="$scm_vlan_interface_ipv4",
            comment="Managed by Pulumi",
            folder="ngfw-shared",
            vlan_tag="1234",
            ips=[{
                "name": "198.18.1.1/24",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VlanInterfaceArpArgs', 'VlanInterfaceArpArgsDict']]]] arps: ARP configuration
        :param pulumi.Input[_builtins.str] comment: Description
        :param pulumi.Input[Union['VlanInterfaceDdnsConfigArgs', 'VlanInterfaceDdnsConfigArgsDict']] ddns_config: Dynamic DNS configuration specific to the Vlan Interfaces.
        :param pulumi.Input[_builtins.str] default_value: Default interface assignment
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[Union['VlanInterfaceDhcpClientArgs', 'VlanInterfaceDhcpClientArgsDict']] dhcp_client: Vlan interfaces DHCP Client Object
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] interface_management_profile: Interface management profile
        :param pulumi.Input[Sequence[pulumi.Input[Union['VlanInterfaceIpArgs', 'VlanInterfaceIpArgsDict']]]] ips: VLAN Interface IP Parent
        :param pulumi.Input[_builtins.int] mtu: MTU
        :param pulumi.Input[_builtins.str] name: L3 sub-interface name
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.str] vlan_tag: VLAN tag
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[VlanInterfaceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        VlanInterface resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scm as scm

        #
        # Creates a vlan interface used as parent-interface for subsequent examples
        #
        scm_vlan_interface_ipv4 = scm.VlanInterface("scm_vlan_interface_ipv4",
            name="$scm_vlan_interface_ipv4",
            comment="Managed by Pulumi",
            folder="ngfw-shared",
            vlan_tag="1234",
            ips=[{
                "name": "198.18.1.1/24",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param VlanInterfaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VlanInterfaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VlanInterfaceArpArgs', 'VlanInterfaceArpArgsDict']]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 ddns_config: Optional[pulumi.Input[Union['VlanInterfaceDdnsConfigArgs', 'VlanInterfaceDdnsConfigArgsDict']]] = None,
                 default_value: Optional[pulumi.Input[_builtins.str]] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcp_client: Optional[pulumi.Input[Union['VlanInterfaceDhcpClientArgs', 'VlanInterfaceDhcpClientArgsDict']]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_management_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VlanInterfaceIpArgs', 'VlanInterfaceIpArgsDict']]]]] = None,
                 mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snippet: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VlanInterfaceArgs.__new__(VlanInterfaceArgs)

            __props__.__dict__["arps"] = arps
            __props__.__dict__["comment"] = comment
            __props__.__dict__["ddns_config"] = ddns_config
            __props__.__dict__["default_value"] = default_value
            __props__.__dict__["device"] = device
            __props__.__dict__["dhcp_client"] = dhcp_client
            __props__.__dict__["folder"] = folder
            __props__.__dict__["interface_management_profile"] = interface_management_profile
            __props__.__dict__["ips"] = ips
            __props__.__dict__["mtu"] = mtu
            __props__.__dict__["name"] = name
            __props__.__dict__["snippet"] = snippet
            __props__.__dict__["vlan_tag"] = vlan_tag
            __props__.__dict__["tfid"] = None
        super(VlanInterface, __self__).__init__(
            'scm:index/vlanInterface:VlanInterface',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VlanInterfaceArpArgs', 'VlanInterfaceArpArgsDict']]]]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            ddns_config: Optional[pulumi.Input[Union['VlanInterfaceDdnsConfigArgs', 'VlanInterfaceDdnsConfigArgsDict']]] = None,
            default_value: Optional[pulumi.Input[_builtins.str]] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            dhcp_client: Optional[pulumi.Input[Union['VlanInterfaceDhcpClientArgs', 'VlanInterfaceDhcpClientArgsDict']]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            interface_management_profile: Optional[pulumi.Input[_builtins.str]] = None,
            ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VlanInterfaceIpArgs', 'VlanInterfaceIpArgsDict']]]]] = None,
            mtu: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            snippet: Optional[pulumi.Input[_builtins.str]] = None,
            tfid: Optional[pulumi.Input[_builtins.str]] = None,
            vlan_tag: Optional[pulumi.Input[_builtins.str]] = None) -> 'VlanInterface':
        """
        Get an existing VlanInterface resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VlanInterfaceArpArgs', 'VlanInterfaceArpArgsDict']]]] arps: ARP configuration
        :param pulumi.Input[_builtins.str] comment: Description
        :param pulumi.Input[Union['VlanInterfaceDdnsConfigArgs', 'VlanInterfaceDdnsConfigArgsDict']] ddns_config: Dynamic DNS configuration specific to the Vlan Interfaces.
        :param pulumi.Input[_builtins.str] default_value: Default interface assignment
        :param pulumi.Input[_builtins.str] device: The device in which the resource is defined
        :param pulumi.Input[Union['VlanInterfaceDhcpClientArgs', 'VlanInterfaceDhcpClientArgsDict']] dhcp_client: Vlan interfaces DHCP Client Object
        :param pulumi.Input[_builtins.str] folder: The folder in which the resource is defined
        :param pulumi.Input[_builtins.str] interface_management_profile: Interface management profile
        :param pulumi.Input[Sequence[pulumi.Input[Union['VlanInterfaceIpArgs', 'VlanInterfaceIpArgsDict']]]] ips: VLAN Interface IP Parent
        :param pulumi.Input[_builtins.int] mtu: MTU
        :param pulumi.Input[_builtins.str] name: L3 sub-interface name
        :param pulumi.Input[_builtins.str] snippet: The snippet in which the resource is defined
        :param pulumi.Input[_builtins.str] vlan_tag: VLAN tag
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VlanInterfaceState.__new__(_VlanInterfaceState)

        __props__.__dict__["arps"] = arps
        __props__.__dict__["comment"] = comment
        __props__.__dict__["ddns_config"] = ddns_config
        __props__.__dict__["default_value"] = default_value
        __props__.__dict__["device"] = device
        __props__.__dict__["dhcp_client"] = dhcp_client
        __props__.__dict__["folder"] = folder
        __props__.__dict__["interface_management_profile"] = interface_management_profile
        __props__.__dict__["ips"] = ips
        __props__.__dict__["mtu"] = mtu
        __props__.__dict__["name"] = name
        __props__.__dict__["snippet"] = snippet
        __props__.__dict__["tfid"] = tfid
        __props__.__dict__["vlan_tag"] = vlan_tag
        return VlanInterface(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arps(self) -> pulumi.Output[Optional[Sequence['outputs.VlanInterfaceArp']]]:
        """
        ARP configuration
        """
        return pulumi.get(self, "arps")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="ddnsConfig")
    def ddns_config(self) -> pulumi.Output['outputs.VlanInterfaceDdnsConfig']:
        """
        Dynamic DNS configuration specific to the Vlan Interfaces.
        """
        return pulumi.get(self, "ddns_config")

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Default interface assignment
        """
        return pulumi.get(self, "default_value")

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The device in which the resource is defined
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter(name="dhcpClient")
    def dhcp_client(self) -> pulumi.Output['outputs.VlanInterfaceDhcpClient']:
        """
        Vlan interfaces DHCP Client Object
        """
        return pulumi.get(self, "dhcp_client")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder in which the resource is defined
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter(name="interfaceManagementProfile")
    def interface_management_profile(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Interface management profile
        """
        return pulumi.get(self, "interface_management_profile")

    @_builtins.property
    @pulumi.getter
    def ips(self) -> pulumi.Output[Optional[Sequence['outputs.VlanInterfaceIp']]]:
        """
        VLAN Interface IP Parent
        """
        return pulumi.get(self, "ips")

    @_builtins.property
    @pulumi.getter
    def mtu(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        MTU
        """
        return pulumi.get(self, "mtu")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        L3 sub-interface name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def snippet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The snippet in which the resource is defined
        """
        return pulumi.get(self, "snippet")

    @_builtins.property
    @pulumi.getter
    def tfid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tfid")

    @_builtins.property
    @pulumi.getter(name="vlanTag")
    def vlan_tag(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        VLAN tag
        """
        return pulumi.get(self, "vlan_tag")

