import * as autoscaling from '@aws-cdk/aws-autoscaling';
import * as ec2 from '@aws-cdk/aws-ec2';
import * as iam from '@aws-cdk/aws-iam';
import * as cdk from '@aws-cdk/core';
import * as spotone from 'cdk-spot-one';
/**
 * @stability stable
 */
export declare enum SpotInstanceType {
    /**
     * @stability stable
     */
    ONE_TIME = "one-time",
    /**
     * @stability stable
     */
    PERSISTENT = "persistent"
}
/**
 * @stability stable
 */
export declare enum InstanceInterruptionBehavior {
    /**
     * @stability stable
     */
    HIBERNATE = "hibernate",
    /**
     * @stability stable
     */
    STOP = "stop",
    /**
     * @stability stable
     */
    TERMINATE = "terminate"
}
/**
 * @stability stable
 */
export declare enum BlockDurationMinutes {
    /**
     * @stability stable
     */
    ONE_HOUR = 60,
    /**
     * @stability stable
     */
    TWO_HOURS = 120,
    /**
     * @stability stable
     */
    THREE_HOURS = 180,
    /**
     * @stability stable
     */
    FOUR_HOURS = 240,
    /**
     * @stability stable
     */
    FIVE_HOURS = 300,
    /**
     * @stability stable
     */
    SIX_HOURS = 360
}
/**
 * @stability stable
 */
export interface SpotOptions {
    /**
     * @stability stable
     */
    readonly spotInstanceType?: SpotInstanceType;
    /**
     * @stability stable
     */
    readonly validUntil?: string;
    /**
     * @stability stable
     */
    readonly maxPrice?: string;
    /**
     * @stability stable
     */
    readonly instanceInterruptionBehavior?: InstanceInterruptionBehavior;
    /**
     * @stability stable
     */
    readonly blockDurationMinutes?: BlockDurationMinutes;
}
/**
 * @stability stable
 */
export interface LaunchTemplateOptions {
    /**
     * @stability stable
     */
    readonly machineImage?: ec2.IMachineImage;
    /**
     * @stability stable
     */
    readonly instanceType?: ec2.InstanceType;
    /**
     * @stability stable
     */
    readonly spotOptions?: SpotOptions;
    /**
     * @stability stable
     */
    readonly userData?: ec2.UserData;
    /**
     * @stability stable
     */
    readonly instanceProfile?: iam.CfnInstanceProfile;
}
/**
 * @stability stable
 */
export interface AutoScalingGroupOptions extends LaunchTemplateOptions {
    /**
     * The vpc for the AutoScalingGroup.
     *
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * default capacity size for the Auto Scaling Group.
     *
     * @default 1
     * @stability stable
     */
    readonly defaultCapacitySize?: number;
}
/**
 * @stability stable
 */
export interface SpotFleetOptions extends AutoScalingGroupOptions {
    /**
     * VPC subnet selection.
     *
     * @default ec2.SubnetType.PRIVATE
     * @stability stable
     */
    readonly vpcSubnet?: ec2.SubnetSelection;
    /**
     * The timestamp of the beginning of the valid duration.
     *
     * @default - now
     * @stability stable
     */
    readonly validFrom?: string;
    /**
     * The timestamp of the beginning of the valid duration.
     *
     * @default - unlimited
     * @stability stable
     */
    readonly validUntil?: string;
    /**
     * Whether to terminate the fleet with expiration.
     *
     * @default true
     * @stability stable
     */
    readonly terminateInstancesWithExpiration?: boolean;
}
/**
 * @stability stable
 */
export declare class Provider extends cdk.Construct {
    private readonly defaultInstanceType;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string);
    /**
     * @stability stable
     */
    get amazonLinuxAmiImageId(): string;
    /**
     * @stability stable
     */
    getOrCreateVpc(scope: cdk.Construct): ec2.IVpc;
    /**
     * @stability stable
     */
    createInstanceProfile(id: string): iam.CfnInstanceProfile;
    /**
     * Create Launch Template.
     *
     * @param id launch template id.
     * @param options launch template options.
     * @stability stable
     */
    createLaunchTemplate(id: string, options?: LaunchTemplateOptions): ec2.CfnLaunchTemplate;
    /**
     * Create EC2 Spot Fleet.
     *
     * @param id fleet id.
     * @param options spot fleet options.
     * @stability stable
     */
    createFleet(id: string, options: SpotFleetOptions): ec2.CfnSpotFleet;
    /**
     * Create AutoScaling Group.
     *
     * @param id AutoScaling Group ID.
     * @param options AutoScaling Group options.
     * @stability stable
     */
    createAutoScalingGroup(id: string, options: AutoScalingGroupOptions): autoscaling.AutoScalingGroup;
    /**
     * @stability stable
     */
    createInstance(id: string, optons: spotone.SpotInstanceProps): spotone.SpotInstance;
}
