# -*- coding: utf-8 -*-

import numpy as np


def istft(X, n_fft, n_hop):
    """
    ISTFT (Inverse-STFT) 2-D matrix and return transformed 1-D wave.

    Parameters
    ----
    X : 2-D matrix, shaped frames x bins
        Target matrix to ISTFT, generated by STFT

    n_fft : int
        Window size of IFFT

    n_hop : int
        Hop size of ISTFT

    """

    y = np.zeros(np.shape(X)[0] * n_hop + n_fft - n_hop)
    for i, s in enumerate(range(0, len(y) - n_fft + 1, n_hop)):
        y[s:s + n_fft] += np.fft.ifft(X[i]).real
    return y
