You can delete unused sections.

## PR Title Convention

Please prefix your pull request title with one of the following tags for clarity:

- `[DOC]` for documentation updates
- `[FIX]` for bug fixes
- `[FEAT]` for new features
- `[REFACTOR]` for code improvements
- `[TEST]` for tests
- `[CI]` for CI/CD or automation updates
- `[CLEANUP]` for general maintenance

Example:
> `[FIX] Correct dimension handling in OSNAP reader`

**Description:**

Please describe your changes clearly and concisely.

- What is the purpose of this pull request?
- What issue(s) does it address? Please link them (e.g., closes #12).
- Briefly explain the approach taken.

**Checklist:**

- [ ] I have followed the [coding conventions](https://amoccommunity.github.io/amocarray/conventions.html).
- [ ] I have updated or added tests to cover my changes.
- [ ] I have updated the documentation if needed.
- [ ] I have run `pytest` to check that all tests pass.
- [ ] I have run `pre-commit run --all-files` to lint and format the code.

**Related Issues / Pull Requests:**

Link any related issues, pull requests, or discussions:
- Fixes #
- Related to #

**Additional Notes:**

Include any additional information reviewers might need:

- Screenshots (if UI/outputs are affected)
- Design decisions or trade-offs
- Anything reviewers should look at closely

