# Docker plugins


Don't use the constructor directly. Instead use 
```python
from dockertown import docker

my_docker_plugin = docker.plugin.install("vieux/sshfs:latest")
# or
my_docker_plugin = docker.plugin.inspect("vieux/sshfs:latest")
# or
list_of_plugins = docker.plugins.list()
```
For type hints, use this

```python
from dockertown import Plugin

def print_name(plugin: Plugin):
    print(plugin.name)
```


## Attributes

It attributes are the same that you get with the command line:
`docker plugin inspect ...`

To get a complete description of those attributes, you 
can take a look at the [daemon api reference page](https://docs.docker.com/engine/api/v1.40/#operation/PluginInspect) 
and click on "200 No error".

An example is worth many lines of descriptions.

```
In [1]: from dockertown import docker

In [2]: plugin = docker.plugin.install("vieux/sshfs:latest")

In [4]: def super_print(obj):
   ...:     print(f"type = {type(obj)}, value = {obj}")
   ...:

@INSERT_GENERATED_CODE@
```

## Methods

{{autogenerated}}
