## How to use Docker contexts

Docker contexts allow you to connect to docker daemons other than the local one. This is similar to the `-H` argument of the Docker command.

Contexts commands allow you to declare, save, list local and remote Docker daemons and Kubernetes endpoints that you have.

An exemple here with dockertown:

```python
from dockertown import docker, DockerContextConfig

new_context = docker.context.create(
    "my_remote_ssh_server",
    docker=DockerContextConfig(host="ssh://ubuntu@52.57.163.75"),
    description="my server ssh with a lot more power"
)
print(docker.context.list())
# [dockertown.Context(name='default', endpoints={'docker': ContextEndpoint(host='unix:///var/run/docker.sock', skip_tls_verify=False)}),
# dockertown.Context(name='my_remote_ssh_server', endpoints={'docker': ContextEndpoint(host='ssh://ubuntu@52.57.163.75', skip_tls_verify=False)})]
new_context.use()
# it's the same to use docker.context.use("my_remote_ssh_server") or docker.context.use(new_context)

print(docker.ps()) # will list the containers in the remote server
# [dockertown.Container(id=...), dockertown.Container(id=...)]
# return to the local docker daemon
docker.context.use("default")
print(docker.ps()) # will list the containers running locally
# [dockertown.Container(id=...)]
```

Note that for this simple use case, it's equivalent to use the `-H` option of the Docker client like so:
```python
from dockertown import DockerClient

docker = DockerClient(host="ssh://ubuntu@52.57.163.75")

print(docker.ps())
```

{{autogenerated}}