# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EventTriggerArgs', 'EventTrigger']

@pulumi.input_type
class EventTriggerArgs:
    def __init__(__self__, *,
                 app_id: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 config_collection: Optional[pulumi.Input[str]] = None,
                 config_database: Optional[pulumi.Input[str]] = None,
                 config_full_document: Optional[pulumi.Input[bool]] = None,
                 config_full_document_before: Optional[pulumi.Input[bool]] = None,
                 config_match: Optional[pulumi.Input[str]] = None,
                 config_operation_type: Optional[pulumi.Input[str]] = None,
                 config_operation_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 config_project: Optional[pulumi.Input[str]] = None,
                 config_providers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 config_schedule: Optional[pulumi.Input[str]] = None,
                 config_service_id: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 event_processors: Optional[pulumi.Input['EventTriggerEventProcessorsArgs']] = None,
                 function_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 unordered: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a EventTrigger resource.
        :param pulumi.Input[str] app_id: The ObjectID of your application.
               * For more details on `project_id` and `app_id` see: https://www.mongodb.com/docs/atlas/app-services/admin/api/v3/#section/Project-and-Application-IDs
        :param pulumi.Input[str] project_id: The unique ID for the project to create the trigger.
        :param pulumi.Input[str] type: The type of the trigger. Possible Values: `DATABASE`, `AUTHENTICATION`,`SCHEDULED`
        :param pulumi.Input[str] config_collection: Optional for `DATABASE` type. The name of the MongoDB collection that the trigger watches for change events. The collection must be part of the specified database.
        :param pulumi.Input[str] config_database: Required for `DATABASE` type. The name of the MongoDB database to watch.
        :param pulumi.Input[bool] config_full_document: Optional for `DATABASE` type. If true, indicates that `UPDATE` change events should include the most current [majority-committed](https://docs.mongodb.com/manual/reference/read-concern-majority/) version of the modified document in the fullDocument field.
        :param pulumi.Input[str] config_match: Optional for `DATABASE` type. A [$match](https://docs.mongodb.com/manual/reference/operator/aggregation/match/) expression document that MongoDB Realm includes in the underlying change stream pipeline for the trigger. This is useful when you want to filter change events beyond their operation type. The trigger will only fire if the expression evaluates to true for a given change event.
        :param pulumi.Input[str] config_operation_type: Required for `AUTHENTICATION` type. The [authentication operation type](https://docs.mongodb.com/realm/triggers/authentication-triggers/#std-label-authentication-event-operation-types) to listen for. Possible Values: `LOGIN`, `CREATE`, `DELETE`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] config_operation_types: Required for `DATABASE` type. The [database event operation types](https://docs.mongodb.com/realm/triggers/database-triggers/#std-label-database-events) to listen for. This must contain at least one value. Possible Values: `INSERT`, `UPDATE`, `REPLACE`, `DELETE`
        :param pulumi.Input[str] config_project: Optional for `DATABASE` type. A [$project](https://docs.mongodb.com/manual/reference/operator/aggregation/project/) expression document that Realm uses to filter the fields that appear in change event objects.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] config_providers: Required for `AUTHENTICATION` type. A list of one or more [authentication provider](https://docs.mongodb.com/realm/authentication/providers/) id values. The trigger will only listen for authentication events produced by these providers.
        :param pulumi.Input[str] config_schedule: Required for `SCHEDULED` type. A [cron expression](https://docs.mongodb.com/realm/triggers/cron-expressions/) that defines the trigger schedule.
        :param pulumi.Input[str] config_service_id: Required for `DATABASE` type. The ID of the MongoDB Service associated with the trigger.
        :param pulumi.Input[bool] disabled: Default: `false` If `true`, the trigger is disabled.
        :param pulumi.Input['EventTriggerEventProcessorsArgs'] event_processors: An object where each field name is an event processor ID and each value is an object that configures its corresponding event processor. The following event processors are supported: `AWS_EVENTBRIDGE` For an example configuration object, see [Send Trigger Events to AWS EventBridge](https://docs.mongodb.com/realm/triggers/eventbridge/#std-label-event_processor_example).
               * `event_processors.0.aws_eventbridge.config_account_id` - (Optional) AWS Account ID.
               * `event_processors.0.aws_eventbridge.config_region` - (Optional) Region of AWS Account.
        :param pulumi.Input[str] function_id: The ID of the function associated with the trigger.
        :param pulumi.Input[str] name: The name of the trigger.
        :param pulumi.Input[bool] unordered: Only Available for Database Triggers. If true, event ordering is disabled and this trigger can process events in parallel. If false, event ordering is enabled and the trigger executes serially.
        """
        pulumi.set(__self__, "app_id", app_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "type", type)
        if config_collection is not None:
            pulumi.set(__self__, "config_collection", config_collection)
        if config_database is not None:
            pulumi.set(__self__, "config_database", config_database)
        if config_full_document is not None:
            pulumi.set(__self__, "config_full_document", config_full_document)
        if config_full_document_before is not None:
            pulumi.set(__self__, "config_full_document_before", config_full_document_before)
        if config_match is not None:
            pulumi.set(__self__, "config_match", config_match)
        if config_operation_type is not None:
            pulumi.set(__self__, "config_operation_type", config_operation_type)
        if config_operation_types is not None:
            pulumi.set(__self__, "config_operation_types", config_operation_types)
        if config_project is not None:
            pulumi.set(__self__, "config_project", config_project)
        if config_providers is not None:
            pulumi.set(__self__, "config_providers", config_providers)
        if config_schedule is not None:
            pulumi.set(__self__, "config_schedule", config_schedule)
        if config_service_id is not None:
            pulumi.set(__self__, "config_service_id", config_service_id)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if event_processors is not None:
            pulumi.set(__self__, "event_processors", event_processors)
        if function_id is not None:
            pulumi.set(__self__, "function_id", function_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if unordered is not None:
            pulumi.set(__self__, "unordered", unordered)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Input[str]:
        """
        The ObjectID of your application.
        * For more details on `project_id` and `app_id` see: https://www.mongodb.com/docs/atlas/app-services/admin/api/v3/#section/Project-and-Application-IDs
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The unique ID for the project to create the trigger.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the trigger. Possible Values: `DATABASE`, `AUTHENTICATION`,`SCHEDULED`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="configCollection")
    def config_collection(self) -> Optional[pulumi.Input[str]]:
        """
        Optional for `DATABASE` type. The name of the MongoDB collection that the trigger watches for change events. The collection must be part of the specified database.
        """
        return pulumi.get(self, "config_collection")

    @config_collection.setter
    def config_collection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_collection", value)

    @property
    @pulumi.getter(name="configDatabase")
    def config_database(self) -> Optional[pulumi.Input[str]]:
        """
        Required for `DATABASE` type. The name of the MongoDB database to watch.
        """
        return pulumi.get(self, "config_database")

    @config_database.setter
    def config_database(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_database", value)

    @property
    @pulumi.getter(name="configFullDocument")
    def config_full_document(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional for `DATABASE` type. If true, indicates that `UPDATE` change events should include the most current [majority-committed](https://docs.mongodb.com/manual/reference/read-concern-majority/) version of the modified document in the fullDocument field.
        """
        return pulumi.get(self, "config_full_document")

    @config_full_document.setter
    def config_full_document(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "config_full_document", value)

    @property
    @pulumi.getter(name="configFullDocumentBefore")
    def config_full_document_before(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "config_full_document_before")

    @config_full_document_before.setter
    def config_full_document_before(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "config_full_document_before", value)

    @property
    @pulumi.getter(name="configMatch")
    def config_match(self) -> Optional[pulumi.Input[str]]:
        """
        Optional for `DATABASE` type. A [$match](https://docs.mongodb.com/manual/reference/operator/aggregation/match/) expression document that MongoDB Realm includes in the underlying change stream pipeline for the trigger. This is useful when you want to filter change events beyond their operation type. The trigger will only fire if the expression evaluates to true for a given change event.
        """
        return pulumi.get(self, "config_match")

    @config_match.setter
    def config_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_match", value)

    @property
    @pulumi.getter(name="configOperationType")
    def config_operation_type(self) -> Optional[pulumi.Input[str]]:
        """
        Required for `AUTHENTICATION` type. The [authentication operation type](https://docs.mongodb.com/realm/triggers/authentication-triggers/#std-label-authentication-event-operation-types) to listen for. Possible Values: `LOGIN`, `CREATE`, `DELETE`
        """
        return pulumi.get(self, "config_operation_type")

    @config_operation_type.setter
    def config_operation_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_operation_type", value)

    @property
    @pulumi.getter(name="configOperationTypes")
    def config_operation_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Required for `DATABASE` type. The [database event operation types](https://docs.mongodb.com/realm/triggers/database-triggers/#std-label-database-events) to listen for. This must contain at least one value. Possible Values: `INSERT`, `UPDATE`, `REPLACE`, `DELETE`
        """
        return pulumi.get(self, "config_operation_types")

    @config_operation_types.setter
    def config_operation_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "config_operation_types", value)

    @property
    @pulumi.getter(name="configProject")
    def config_project(self) -> Optional[pulumi.Input[str]]:
        """
        Optional for `DATABASE` type. A [$project](https://docs.mongodb.com/manual/reference/operator/aggregation/project/) expression document that Realm uses to filter the fields that appear in change event objects.
        """
        return pulumi.get(self, "config_project")

    @config_project.setter
    def config_project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_project", value)

    @property
    @pulumi.getter(name="configProviders")
    def config_providers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Required for `AUTHENTICATION` type. A list of one or more [authentication provider](https://docs.mongodb.com/realm/authentication/providers/) id values. The trigger will only listen for authentication events produced by these providers.
        """
        return pulumi.get(self, "config_providers")

    @config_providers.setter
    def config_providers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "config_providers", value)

    @property
    @pulumi.getter(name="configSchedule")
    def config_schedule(self) -> Optional[pulumi.Input[str]]:
        """
        Required for `SCHEDULED` type. A [cron expression](https://docs.mongodb.com/realm/triggers/cron-expressions/) that defines the trigger schedule.
        """
        return pulumi.get(self, "config_schedule")

    @config_schedule.setter
    def config_schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_schedule", value)

    @property
    @pulumi.getter(name="configServiceId")
    def config_service_id(self) -> Optional[pulumi.Input[str]]:
        """
        Required for `DATABASE` type. The ID of the MongoDB Service associated with the trigger.
        """
        return pulumi.get(self, "config_service_id")

    @config_service_id.setter
    def config_service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_service_id", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Default: `false` If `true`, the trigger is disabled.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="eventProcessors")
    def event_processors(self) -> Optional[pulumi.Input['EventTriggerEventProcessorsArgs']]:
        """
        An object where each field name is an event processor ID and each value is an object that configures its corresponding event processor. The following event processors are supported: `AWS_EVENTBRIDGE` For an example configuration object, see [Send Trigger Events to AWS EventBridge](https://docs.mongodb.com/realm/triggers/eventbridge/#std-label-event_processor_example).
        * `event_processors.0.aws_eventbridge.config_account_id` - (Optional) AWS Account ID.
        * `event_processors.0.aws_eventbridge.config_region` - (Optional) Region of AWS Account.
        """
        return pulumi.get(self, "event_processors")

    @event_processors.setter
    def event_processors(self, value: Optional[pulumi.Input['EventTriggerEventProcessorsArgs']]):
        pulumi.set(self, "event_processors", value)

    @property
    @pulumi.getter(name="functionId")
    def function_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the function associated with the trigger.
        """
        return pulumi.get(self, "function_id")

    @function_id.setter
    def function_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the trigger.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def unordered(self) -> Optional[pulumi.Input[bool]]:
        """
        Only Available for Database Triggers. If true, event ordering is disabled and this trigger can process events in parallel. If false, event ordering is enabled and the trigger executes serially.
        """
        return pulumi.get(self, "unordered")

    @unordered.setter
    def unordered(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "unordered", value)


@pulumi.input_type
class _EventTriggerState:
    def __init__(__self__, *,
                 app_id: Optional[pulumi.Input[str]] = None,
                 config_collection: Optional[pulumi.Input[str]] = None,
                 config_database: Optional[pulumi.Input[str]] = None,
                 config_full_document: Optional[pulumi.Input[bool]] = None,
                 config_full_document_before: Optional[pulumi.Input[bool]] = None,
                 config_match: Optional[pulumi.Input[str]] = None,
                 config_operation_type: Optional[pulumi.Input[str]] = None,
                 config_operation_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 config_project: Optional[pulumi.Input[str]] = None,
                 config_providers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 config_schedule: Optional[pulumi.Input[str]] = None,
                 config_schedule_type: Optional[pulumi.Input[str]] = None,
                 config_service_id: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 event_processors: Optional[pulumi.Input['EventTriggerEventProcessorsArgs']] = None,
                 function_id: Optional[pulumi.Input[str]] = None,
                 function_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 trigger_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 unordered: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering EventTrigger resources.
        :param pulumi.Input[str] app_id: The ObjectID of your application.
               * For more details on `project_id` and `app_id` see: https://www.mongodb.com/docs/atlas/app-services/admin/api/v3/#section/Project-and-Application-IDs
        :param pulumi.Input[str] config_collection: Optional for `DATABASE` type. The name of the MongoDB collection that the trigger watches for change events. The collection must be part of the specified database.
        :param pulumi.Input[str] config_database: Required for `DATABASE` type. The name of the MongoDB database to watch.
        :param pulumi.Input[bool] config_full_document: Optional for `DATABASE` type. If true, indicates that `UPDATE` change events should include the most current [majority-committed](https://docs.mongodb.com/manual/reference/read-concern-majority/) version of the modified document in the fullDocument field.
        :param pulumi.Input[str] config_match: Optional for `DATABASE` type. A [$match](https://docs.mongodb.com/manual/reference/operator/aggregation/match/) expression document that MongoDB Realm includes in the underlying change stream pipeline for the trigger. This is useful when you want to filter change events beyond their operation type. The trigger will only fire if the expression evaluates to true for a given change event.
        :param pulumi.Input[str] config_operation_type: Required for `AUTHENTICATION` type. The [authentication operation type](https://docs.mongodb.com/realm/triggers/authentication-triggers/#std-label-authentication-event-operation-types) to listen for. Possible Values: `LOGIN`, `CREATE`, `DELETE`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] config_operation_types: Required for `DATABASE` type. The [database event operation types](https://docs.mongodb.com/realm/triggers/database-triggers/#std-label-database-events) to listen for. This must contain at least one value. Possible Values: `INSERT`, `UPDATE`, `REPLACE`, `DELETE`
        :param pulumi.Input[str] config_project: Optional for `DATABASE` type. A [$project](https://docs.mongodb.com/manual/reference/operator/aggregation/project/) expression document that Realm uses to filter the fields that appear in change event objects.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] config_providers: Required for `AUTHENTICATION` type. A list of one or more [authentication provider](https://docs.mongodb.com/realm/authentication/providers/) id values. The trigger will only listen for authentication events produced by these providers.
        :param pulumi.Input[str] config_schedule: Required for `SCHEDULED` type. A [cron expression](https://docs.mongodb.com/realm/triggers/cron-expressions/) that defines the trigger schedule.
        :param pulumi.Input[str] config_service_id: Required for `DATABASE` type. The ID of the MongoDB Service associated with the trigger.
        :param pulumi.Input[bool] disabled: Default: `false` If `true`, the trigger is disabled.
        :param pulumi.Input['EventTriggerEventProcessorsArgs'] event_processors: An object where each field name is an event processor ID and each value is an object that configures its corresponding event processor. The following event processors are supported: `AWS_EVENTBRIDGE` For an example configuration object, see [Send Trigger Events to AWS EventBridge](https://docs.mongodb.com/realm/triggers/eventbridge/#std-label-event_processor_example).
               * `event_processors.0.aws_eventbridge.config_account_id` - (Optional) AWS Account ID.
               * `event_processors.0.aws_eventbridge.config_region` - (Optional) Region of AWS Account.
        :param pulumi.Input[str] function_id: The ID of the function associated with the trigger.
        :param pulumi.Input[str] function_name: The name of the function associated with the trigger.
        :param pulumi.Input[str] name: The name of the trigger.
        :param pulumi.Input[str] project_id: The unique ID for the project to create the trigger.
        :param pulumi.Input[str] trigger_id: The unique ID of the trigger.
        :param pulumi.Input[str] type: The type of the trigger. Possible Values: `DATABASE`, `AUTHENTICATION`,`SCHEDULED`
        :param pulumi.Input[bool] unordered: Only Available for Database Triggers. If true, event ordering is disabled and this trigger can process events in parallel. If false, event ordering is enabled and the trigger executes serially.
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if config_collection is not None:
            pulumi.set(__self__, "config_collection", config_collection)
        if config_database is not None:
            pulumi.set(__self__, "config_database", config_database)
        if config_full_document is not None:
            pulumi.set(__self__, "config_full_document", config_full_document)
        if config_full_document_before is not None:
            pulumi.set(__self__, "config_full_document_before", config_full_document_before)
        if config_match is not None:
            pulumi.set(__self__, "config_match", config_match)
        if config_operation_type is not None:
            pulumi.set(__self__, "config_operation_type", config_operation_type)
        if config_operation_types is not None:
            pulumi.set(__self__, "config_operation_types", config_operation_types)
        if config_project is not None:
            pulumi.set(__self__, "config_project", config_project)
        if config_providers is not None:
            pulumi.set(__self__, "config_providers", config_providers)
        if config_schedule is not None:
            pulumi.set(__self__, "config_schedule", config_schedule)
        if config_schedule_type is not None:
            pulumi.set(__self__, "config_schedule_type", config_schedule_type)
        if config_service_id is not None:
            pulumi.set(__self__, "config_service_id", config_service_id)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if event_processors is not None:
            pulumi.set(__self__, "event_processors", event_processors)
        if function_id is not None:
            pulumi.set(__self__, "function_id", function_id)
        if function_name is not None:
            pulumi.set(__self__, "function_name", function_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if trigger_id is not None:
            pulumi.set(__self__, "trigger_id", trigger_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if unordered is not None:
            pulumi.set(__self__, "unordered", unordered)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ObjectID of your application.
        * For more details on `project_id` and `app_id` see: https://www.mongodb.com/docs/atlas/app-services/admin/api/v3/#section/Project-and-Application-IDs
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="configCollection")
    def config_collection(self) -> Optional[pulumi.Input[str]]:
        """
        Optional for `DATABASE` type. The name of the MongoDB collection that the trigger watches for change events. The collection must be part of the specified database.
        """
        return pulumi.get(self, "config_collection")

    @config_collection.setter
    def config_collection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_collection", value)

    @property
    @pulumi.getter(name="configDatabase")
    def config_database(self) -> Optional[pulumi.Input[str]]:
        """
        Required for `DATABASE` type. The name of the MongoDB database to watch.
        """
        return pulumi.get(self, "config_database")

    @config_database.setter
    def config_database(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_database", value)

    @property
    @pulumi.getter(name="configFullDocument")
    def config_full_document(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional for `DATABASE` type. If true, indicates that `UPDATE` change events should include the most current [majority-committed](https://docs.mongodb.com/manual/reference/read-concern-majority/) version of the modified document in the fullDocument field.
        """
        return pulumi.get(self, "config_full_document")

    @config_full_document.setter
    def config_full_document(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "config_full_document", value)

    @property
    @pulumi.getter(name="configFullDocumentBefore")
    def config_full_document_before(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "config_full_document_before")

    @config_full_document_before.setter
    def config_full_document_before(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "config_full_document_before", value)

    @property
    @pulumi.getter(name="configMatch")
    def config_match(self) -> Optional[pulumi.Input[str]]:
        """
        Optional for `DATABASE` type. A [$match](https://docs.mongodb.com/manual/reference/operator/aggregation/match/) expression document that MongoDB Realm includes in the underlying change stream pipeline for the trigger. This is useful when you want to filter change events beyond their operation type. The trigger will only fire if the expression evaluates to true for a given change event.
        """
        return pulumi.get(self, "config_match")

    @config_match.setter
    def config_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_match", value)

    @property
    @pulumi.getter(name="configOperationType")
    def config_operation_type(self) -> Optional[pulumi.Input[str]]:
        """
        Required for `AUTHENTICATION` type. The [authentication operation type](https://docs.mongodb.com/realm/triggers/authentication-triggers/#std-label-authentication-event-operation-types) to listen for. Possible Values: `LOGIN`, `CREATE`, `DELETE`
        """
        return pulumi.get(self, "config_operation_type")

    @config_operation_type.setter
    def config_operation_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_operation_type", value)

    @property
    @pulumi.getter(name="configOperationTypes")
    def config_operation_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Required for `DATABASE` type. The [database event operation types](https://docs.mongodb.com/realm/triggers/database-triggers/#std-label-database-events) to listen for. This must contain at least one value. Possible Values: `INSERT`, `UPDATE`, `REPLACE`, `DELETE`
        """
        return pulumi.get(self, "config_operation_types")

    @config_operation_types.setter
    def config_operation_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "config_operation_types", value)

    @property
    @pulumi.getter(name="configProject")
    def config_project(self) -> Optional[pulumi.Input[str]]:
        """
        Optional for `DATABASE` type. A [$project](https://docs.mongodb.com/manual/reference/operator/aggregation/project/) expression document that Realm uses to filter the fields that appear in change event objects.
        """
        return pulumi.get(self, "config_project")

    @config_project.setter
    def config_project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_project", value)

    @property
    @pulumi.getter(name="configProviders")
    def config_providers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Required for `AUTHENTICATION` type. A list of one or more [authentication provider](https://docs.mongodb.com/realm/authentication/providers/) id values. The trigger will only listen for authentication events produced by these providers.
        """
        return pulumi.get(self, "config_providers")

    @config_providers.setter
    def config_providers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "config_providers", value)

    @property
    @pulumi.getter(name="configSchedule")
    def config_schedule(self) -> Optional[pulumi.Input[str]]:
        """
        Required for `SCHEDULED` type. A [cron expression](https://docs.mongodb.com/realm/triggers/cron-expressions/) that defines the trigger schedule.
        """
        return pulumi.get(self, "config_schedule")

    @config_schedule.setter
    def config_schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_schedule", value)

    @property
    @pulumi.getter(name="configScheduleType")
    def config_schedule_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "config_schedule_type")

    @config_schedule_type.setter
    def config_schedule_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_schedule_type", value)

    @property
    @pulumi.getter(name="configServiceId")
    def config_service_id(self) -> Optional[pulumi.Input[str]]:
        """
        Required for `DATABASE` type. The ID of the MongoDB Service associated with the trigger.
        """
        return pulumi.get(self, "config_service_id")

    @config_service_id.setter
    def config_service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_service_id", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Default: `false` If `true`, the trigger is disabled.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="eventProcessors")
    def event_processors(self) -> Optional[pulumi.Input['EventTriggerEventProcessorsArgs']]:
        """
        An object where each field name is an event processor ID and each value is an object that configures its corresponding event processor. The following event processors are supported: `AWS_EVENTBRIDGE` For an example configuration object, see [Send Trigger Events to AWS EventBridge](https://docs.mongodb.com/realm/triggers/eventbridge/#std-label-event_processor_example).
        * `event_processors.0.aws_eventbridge.config_account_id` - (Optional) AWS Account ID.
        * `event_processors.0.aws_eventbridge.config_region` - (Optional) Region of AWS Account.
        """
        return pulumi.get(self, "event_processors")

    @event_processors.setter
    def event_processors(self, value: Optional[pulumi.Input['EventTriggerEventProcessorsArgs']]):
        pulumi.set(self, "event_processors", value)

    @property
    @pulumi.getter(name="functionId")
    def function_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the function associated with the trigger.
        """
        return pulumi.get(self, "function_id")

    @function_id.setter
    def function_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_id", value)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the function associated with the trigger.
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the trigger.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique ID for the project to create the trigger.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique ID of the trigger.
        """
        return pulumi.get(self, "trigger_id")

    @trigger_id.setter
    def trigger_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trigger_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the trigger. Possible Values: `DATABASE`, `AUTHENTICATION`,`SCHEDULED`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def unordered(self) -> Optional[pulumi.Input[bool]]:
        """
        Only Available for Database Triggers. If true, event ordering is disabled and this trigger can process events in parallel. If false, event ordering is enabled and the trigger executes serially.
        """
        return pulumi.get(self, "unordered")

    @unordered.setter
    def unordered(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "unordered", value)


class EventTrigger(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 config_collection: Optional[pulumi.Input[str]] = None,
                 config_database: Optional[pulumi.Input[str]] = None,
                 config_full_document: Optional[pulumi.Input[bool]] = None,
                 config_full_document_before: Optional[pulumi.Input[bool]] = None,
                 config_match: Optional[pulumi.Input[str]] = None,
                 config_operation_type: Optional[pulumi.Input[str]] = None,
                 config_operation_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 config_project: Optional[pulumi.Input[str]] = None,
                 config_providers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 config_schedule: Optional[pulumi.Input[str]] = None,
                 config_service_id: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 event_processors: Optional[pulumi.Input[Union['EventTriggerEventProcessorsArgs', 'EventTriggerEventProcessorsArgsDict']]] = None,
                 function_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 unordered: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        ## # Resource: EventTrigger

        `EventTrigger` provides a Event Trigger resource.

        Note: If the `app_id` changes in the EventTrigger resource, it will force a replacement and delete itself from the old Atlas App Services app if it still exists then create itself in the new  Atlas App Services app. See [Atlas Triggers](https://www.mongodb.com/docs/atlas/app-services/triggers/) to learn more.

        ## Example Usage

        ### S

        ### Example Usage: Database Trigger with Function
        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.EventTrigger("test",
            project_id="PROJECT ID",
            app_id="APPLICATION ID",
            name="NAME OF THE TRIGGER",
            type="DATABASE",
            function_id="FUNCTION ID",
            disabled=False,
            config_operation_types=[
                "INSERT",
                "UPDATE",
            ],
            config_database="DATABASE NAME",
            config_collection="COLLECTION NAME",
            config_service_id="SERVICE ID",
            config_match=\"\"\"{
          "updateDescription.updatedFields": {
            "status": "blocked"
          }
        }
        \"\"\",
            config_project="{\\"updateDescription.updatedFields\\":{\\"status\\":\\"blocked\\"}}",
            config_full_document=False,
            config_full_document_before=False,
            event_processors={
                "aws_eventbridge": {
                    "config_account_id": "AWS ACCOUNT ID",
                    "config_region": "AWS REGIOn",
                },
            })
        ```

        ### Example Usage: Database Trigger with EventBridge
        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.EventTrigger("test",
            project_id="PROJECT ID",
            app_id="APPLICATION ID",
            name="NAME OF THE TRIGGER",
            type="DATABASE",
            disabled=False,
            unordered=False,
            config_operation_types=[
                "INSERT",
                "UPDATE",
            ],
            config_operation_type="LOGIN",
            config_providers=["anon-user"],
            config_database="DATABASE NAME",
            config_collection="COLLECTION NAME",
            config_service_id="1",
            config_match="{\\"updateDescription.updatedFields\\":{\\"status\\":\\"blocked\\"}}",
            config_project="{\\"updateDescription.updatedFields\\":{\\"status\\":\\"blocked\\"}}",
            config_full_document=False,
            config_full_document_before=False,
            config_schedule="*",
            event_processors={
                "aws_eventbridge": {
                    "config_account_id": "AWS ACCOUNT ID",
                    "config_region": "AWS REGIOn",
                },
            })
        ```

        ### Example Usage: Authentication Trigger
        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.EventTrigger("test",
            project_id="PROJECT ID",
            app_id="APPLICATION ID",
            name="NAME OF THE TRIGGER",
            type="AUTHENTICATION",
            function_id="1",
            disabled=False,
            config_operation_type="LOGIN",
            config_providers=["anon-user"])
        ```

        ### Example Usage: Scheduled Trigger
        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.EventTrigger("test",
            project_id="PROJECT ID",
            app_id="APPLICATION ID",
            name="NAME OF THE TRIGGER",
            type="SCHEDULED",
            function_id="1",
            disabled=False,
            config_schedule="*")
        ```

        ## Import

        Event trigger can be imported using project ID, App ID and Trigger ID, in the format `project_id`--`app_id`-`trigger_id`, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/eventTrigger:EventTrigger test 1112222b3bf99403840e8934--testing-example--1112222b3bf99403840e8934
        ```
        For more details on this resource see [Triggers resource](https://www.mongodb.com/docs/atlas/app-services/admin/api/v3/#tag/triggers) in Atlas App Services Documentation.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_id: The ObjectID of your application.
               * For more details on `project_id` and `app_id` see: https://www.mongodb.com/docs/atlas/app-services/admin/api/v3/#section/Project-and-Application-IDs
        :param pulumi.Input[str] config_collection: Optional for `DATABASE` type. The name of the MongoDB collection that the trigger watches for change events. The collection must be part of the specified database.
        :param pulumi.Input[str] config_database: Required for `DATABASE` type. The name of the MongoDB database to watch.
        :param pulumi.Input[bool] config_full_document: Optional for `DATABASE` type. If true, indicates that `UPDATE` change events should include the most current [majority-committed](https://docs.mongodb.com/manual/reference/read-concern-majority/) version of the modified document in the fullDocument field.
        :param pulumi.Input[str] config_match: Optional for `DATABASE` type. A [$match](https://docs.mongodb.com/manual/reference/operator/aggregation/match/) expression document that MongoDB Realm includes in the underlying change stream pipeline for the trigger. This is useful when you want to filter change events beyond their operation type. The trigger will only fire if the expression evaluates to true for a given change event.
        :param pulumi.Input[str] config_operation_type: Required for `AUTHENTICATION` type. The [authentication operation type](https://docs.mongodb.com/realm/triggers/authentication-triggers/#std-label-authentication-event-operation-types) to listen for. Possible Values: `LOGIN`, `CREATE`, `DELETE`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] config_operation_types: Required for `DATABASE` type. The [database event operation types](https://docs.mongodb.com/realm/triggers/database-triggers/#std-label-database-events) to listen for. This must contain at least one value. Possible Values: `INSERT`, `UPDATE`, `REPLACE`, `DELETE`
        :param pulumi.Input[str] config_project: Optional for `DATABASE` type. A [$project](https://docs.mongodb.com/manual/reference/operator/aggregation/project/) expression document that Realm uses to filter the fields that appear in change event objects.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] config_providers: Required for `AUTHENTICATION` type. A list of one or more [authentication provider](https://docs.mongodb.com/realm/authentication/providers/) id values. The trigger will only listen for authentication events produced by these providers.
        :param pulumi.Input[str] config_schedule: Required for `SCHEDULED` type. A [cron expression](https://docs.mongodb.com/realm/triggers/cron-expressions/) that defines the trigger schedule.
        :param pulumi.Input[str] config_service_id: Required for `DATABASE` type. The ID of the MongoDB Service associated with the trigger.
        :param pulumi.Input[bool] disabled: Default: `false` If `true`, the trigger is disabled.
        :param pulumi.Input[Union['EventTriggerEventProcessorsArgs', 'EventTriggerEventProcessorsArgsDict']] event_processors: An object where each field name is an event processor ID and each value is an object that configures its corresponding event processor. The following event processors are supported: `AWS_EVENTBRIDGE` For an example configuration object, see [Send Trigger Events to AWS EventBridge](https://docs.mongodb.com/realm/triggers/eventbridge/#std-label-event_processor_example).
               * `event_processors.0.aws_eventbridge.config_account_id` - (Optional) AWS Account ID.
               * `event_processors.0.aws_eventbridge.config_region` - (Optional) Region of AWS Account.
        :param pulumi.Input[str] function_id: The ID of the function associated with the trigger.
        :param pulumi.Input[str] name: The name of the trigger.
        :param pulumi.Input[str] project_id: The unique ID for the project to create the trigger.
        :param pulumi.Input[str] type: The type of the trigger. Possible Values: `DATABASE`, `AUTHENTICATION`,`SCHEDULED`
        :param pulumi.Input[bool] unordered: Only Available for Database Triggers. If true, event ordering is disabled and this trigger can process events in parallel. If false, event ordering is enabled and the trigger executes serially.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EventTriggerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: EventTrigger

        `EventTrigger` provides a Event Trigger resource.

        Note: If the `app_id` changes in the EventTrigger resource, it will force a replacement and delete itself from the old Atlas App Services app if it still exists then create itself in the new  Atlas App Services app. See [Atlas Triggers](https://www.mongodb.com/docs/atlas/app-services/triggers/) to learn more.

        ## Example Usage

        ### S

        ### Example Usage: Database Trigger with Function
        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.EventTrigger("test",
            project_id="PROJECT ID",
            app_id="APPLICATION ID",
            name="NAME OF THE TRIGGER",
            type="DATABASE",
            function_id="FUNCTION ID",
            disabled=False,
            config_operation_types=[
                "INSERT",
                "UPDATE",
            ],
            config_database="DATABASE NAME",
            config_collection="COLLECTION NAME",
            config_service_id="SERVICE ID",
            config_match=\"\"\"{
          "updateDescription.updatedFields": {
            "status": "blocked"
          }
        }
        \"\"\",
            config_project="{\\"updateDescription.updatedFields\\":{\\"status\\":\\"blocked\\"}}",
            config_full_document=False,
            config_full_document_before=False,
            event_processors={
                "aws_eventbridge": {
                    "config_account_id": "AWS ACCOUNT ID",
                    "config_region": "AWS REGIOn",
                },
            })
        ```

        ### Example Usage: Database Trigger with EventBridge
        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.EventTrigger("test",
            project_id="PROJECT ID",
            app_id="APPLICATION ID",
            name="NAME OF THE TRIGGER",
            type="DATABASE",
            disabled=False,
            unordered=False,
            config_operation_types=[
                "INSERT",
                "UPDATE",
            ],
            config_operation_type="LOGIN",
            config_providers=["anon-user"],
            config_database="DATABASE NAME",
            config_collection="COLLECTION NAME",
            config_service_id="1",
            config_match="{\\"updateDescription.updatedFields\\":{\\"status\\":\\"blocked\\"}}",
            config_project="{\\"updateDescription.updatedFields\\":{\\"status\\":\\"blocked\\"}}",
            config_full_document=False,
            config_full_document_before=False,
            config_schedule="*",
            event_processors={
                "aws_eventbridge": {
                    "config_account_id": "AWS ACCOUNT ID",
                    "config_region": "AWS REGIOn",
                },
            })
        ```

        ### Example Usage: Authentication Trigger
        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.EventTrigger("test",
            project_id="PROJECT ID",
            app_id="APPLICATION ID",
            name="NAME OF THE TRIGGER",
            type="AUTHENTICATION",
            function_id="1",
            disabled=False,
            config_operation_type="LOGIN",
            config_providers=["anon-user"])
        ```

        ### Example Usage: Scheduled Trigger
        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.EventTrigger("test",
            project_id="PROJECT ID",
            app_id="APPLICATION ID",
            name="NAME OF THE TRIGGER",
            type="SCHEDULED",
            function_id="1",
            disabled=False,
            config_schedule="*")
        ```

        ## Import

        Event trigger can be imported using project ID, App ID and Trigger ID, in the format `project_id`--`app_id`-`trigger_id`, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/eventTrigger:EventTrigger test 1112222b3bf99403840e8934--testing-example--1112222b3bf99403840e8934
        ```
        For more details on this resource see [Triggers resource](https://www.mongodb.com/docs/atlas/app-services/admin/api/v3/#tag/triggers) in Atlas App Services Documentation.

        :param str resource_name: The name of the resource.
        :param EventTriggerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EventTriggerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 config_collection: Optional[pulumi.Input[str]] = None,
                 config_database: Optional[pulumi.Input[str]] = None,
                 config_full_document: Optional[pulumi.Input[bool]] = None,
                 config_full_document_before: Optional[pulumi.Input[bool]] = None,
                 config_match: Optional[pulumi.Input[str]] = None,
                 config_operation_type: Optional[pulumi.Input[str]] = None,
                 config_operation_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 config_project: Optional[pulumi.Input[str]] = None,
                 config_providers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 config_schedule: Optional[pulumi.Input[str]] = None,
                 config_service_id: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 event_processors: Optional[pulumi.Input[Union['EventTriggerEventProcessorsArgs', 'EventTriggerEventProcessorsArgsDict']]] = None,
                 function_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 unordered: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EventTriggerArgs.__new__(EventTriggerArgs)

            if app_id is None and not opts.urn:
                raise TypeError("Missing required property 'app_id'")
            __props__.__dict__["app_id"] = app_id
            __props__.__dict__["config_collection"] = config_collection
            __props__.__dict__["config_database"] = config_database
            __props__.__dict__["config_full_document"] = config_full_document
            __props__.__dict__["config_full_document_before"] = config_full_document_before
            __props__.__dict__["config_match"] = config_match
            __props__.__dict__["config_operation_type"] = config_operation_type
            __props__.__dict__["config_operation_types"] = config_operation_types
            __props__.__dict__["config_project"] = config_project
            __props__.__dict__["config_providers"] = config_providers
            __props__.__dict__["config_schedule"] = config_schedule
            __props__.__dict__["config_service_id"] = config_service_id
            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["event_processors"] = event_processors
            __props__.__dict__["function_id"] = function_id
            __props__.__dict__["name"] = name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["unordered"] = unordered
            __props__.__dict__["config_schedule_type"] = None
            __props__.__dict__["function_name"] = None
            __props__.__dict__["trigger_id"] = None
        super(EventTrigger, __self__).__init__(
            'mongodbatlas:index/eventTrigger:EventTrigger',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_id: Optional[pulumi.Input[str]] = None,
            config_collection: Optional[pulumi.Input[str]] = None,
            config_database: Optional[pulumi.Input[str]] = None,
            config_full_document: Optional[pulumi.Input[bool]] = None,
            config_full_document_before: Optional[pulumi.Input[bool]] = None,
            config_match: Optional[pulumi.Input[str]] = None,
            config_operation_type: Optional[pulumi.Input[str]] = None,
            config_operation_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            config_project: Optional[pulumi.Input[str]] = None,
            config_providers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            config_schedule: Optional[pulumi.Input[str]] = None,
            config_schedule_type: Optional[pulumi.Input[str]] = None,
            config_service_id: Optional[pulumi.Input[str]] = None,
            disabled: Optional[pulumi.Input[bool]] = None,
            event_processors: Optional[pulumi.Input[Union['EventTriggerEventProcessorsArgs', 'EventTriggerEventProcessorsArgsDict']]] = None,
            function_id: Optional[pulumi.Input[str]] = None,
            function_name: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            trigger_id: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            unordered: Optional[pulumi.Input[bool]] = None) -> 'EventTrigger':
        """
        Get an existing EventTrigger resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_id: The ObjectID of your application.
               * For more details on `project_id` and `app_id` see: https://www.mongodb.com/docs/atlas/app-services/admin/api/v3/#section/Project-and-Application-IDs
        :param pulumi.Input[str] config_collection: Optional for `DATABASE` type. The name of the MongoDB collection that the trigger watches for change events. The collection must be part of the specified database.
        :param pulumi.Input[str] config_database: Required for `DATABASE` type. The name of the MongoDB database to watch.
        :param pulumi.Input[bool] config_full_document: Optional for `DATABASE` type. If true, indicates that `UPDATE` change events should include the most current [majority-committed](https://docs.mongodb.com/manual/reference/read-concern-majority/) version of the modified document in the fullDocument field.
        :param pulumi.Input[str] config_match: Optional for `DATABASE` type. A [$match](https://docs.mongodb.com/manual/reference/operator/aggregation/match/) expression document that MongoDB Realm includes in the underlying change stream pipeline for the trigger. This is useful when you want to filter change events beyond their operation type. The trigger will only fire if the expression evaluates to true for a given change event.
        :param pulumi.Input[str] config_operation_type: Required for `AUTHENTICATION` type. The [authentication operation type](https://docs.mongodb.com/realm/triggers/authentication-triggers/#std-label-authentication-event-operation-types) to listen for. Possible Values: `LOGIN`, `CREATE`, `DELETE`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] config_operation_types: Required for `DATABASE` type. The [database event operation types](https://docs.mongodb.com/realm/triggers/database-triggers/#std-label-database-events) to listen for. This must contain at least one value. Possible Values: `INSERT`, `UPDATE`, `REPLACE`, `DELETE`
        :param pulumi.Input[str] config_project: Optional for `DATABASE` type. A [$project](https://docs.mongodb.com/manual/reference/operator/aggregation/project/) expression document that Realm uses to filter the fields that appear in change event objects.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] config_providers: Required for `AUTHENTICATION` type. A list of one or more [authentication provider](https://docs.mongodb.com/realm/authentication/providers/) id values. The trigger will only listen for authentication events produced by these providers.
        :param pulumi.Input[str] config_schedule: Required for `SCHEDULED` type. A [cron expression](https://docs.mongodb.com/realm/triggers/cron-expressions/) that defines the trigger schedule.
        :param pulumi.Input[str] config_service_id: Required for `DATABASE` type. The ID of the MongoDB Service associated with the trigger.
        :param pulumi.Input[bool] disabled: Default: `false` If `true`, the trigger is disabled.
        :param pulumi.Input[Union['EventTriggerEventProcessorsArgs', 'EventTriggerEventProcessorsArgsDict']] event_processors: An object where each field name is an event processor ID and each value is an object that configures its corresponding event processor. The following event processors are supported: `AWS_EVENTBRIDGE` For an example configuration object, see [Send Trigger Events to AWS EventBridge](https://docs.mongodb.com/realm/triggers/eventbridge/#std-label-event_processor_example).
               * `event_processors.0.aws_eventbridge.config_account_id` - (Optional) AWS Account ID.
               * `event_processors.0.aws_eventbridge.config_region` - (Optional) Region of AWS Account.
        :param pulumi.Input[str] function_id: The ID of the function associated with the trigger.
        :param pulumi.Input[str] function_name: The name of the function associated with the trigger.
        :param pulumi.Input[str] name: The name of the trigger.
        :param pulumi.Input[str] project_id: The unique ID for the project to create the trigger.
        :param pulumi.Input[str] trigger_id: The unique ID of the trigger.
        :param pulumi.Input[str] type: The type of the trigger. Possible Values: `DATABASE`, `AUTHENTICATION`,`SCHEDULED`
        :param pulumi.Input[bool] unordered: Only Available for Database Triggers. If true, event ordering is disabled and this trigger can process events in parallel. If false, event ordering is enabled and the trigger executes serially.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EventTriggerState.__new__(_EventTriggerState)

        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["config_collection"] = config_collection
        __props__.__dict__["config_database"] = config_database
        __props__.__dict__["config_full_document"] = config_full_document
        __props__.__dict__["config_full_document_before"] = config_full_document_before
        __props__.__dict__["config_match"] = config_match
        __props__.__dict__["config_operation_type"] = config_operation_type
        __props__.__dict__["config_operation_types"] = config_operation_types
        __props__.__dict__["config_project"] = config_project
        __props__.__dict__["config_providers"] = config_providers
        __props__.__dict__["config_schedule"] = config_schedule
        __props__.__dict__["config_schedule_type"] = config_schedule_type
        __props__.__dict__["config_service_id"] = config_service_id
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["event_processors"] = event_processors
        __props__.__dict__["function_id"] = function_id
        __props__.__dict__["function_name"] = function_name
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["trigger_id"] = trigger_id
        __props__.__dict__["type"] = type
        __props__.__dict__["unordered"] = unordered
        return EventTrigger(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[str]:
        """
        The ObjectID of your application.
        * For more details on `project_id` and `app_id` see: https://www.mongodb.com/docs/atlas/app-services/admin/api/v3/#section/Project-and-Application-IDs
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="configCollection")
    def config_collection(self) -> pulumi.Output[str]:
        """
        Optional for `DATABASE` type. The name of the MongoDB collection that the trigger watches for change events. The collection must be part of the specified database.
        """
        return pulumi.get(self, "config_collection")

    @property
    @pulumi.getter(name="configDatabase")
    def config_database(self) -> pulumi.Output[str]:
        """
        Required for `DATABASE` type. The name of the MongoDB database to watch.
        """
        return pulumi.get(self, "config_database")

    @property
    @pulumi.getter(name="configFullDocument")
    def config_full_document(self) -> pulumi.Output[bool]:
        """
        Optional for `DATABASE` type. If true, indicates that `UPDATE` change events should include the most current [majority-committed](https://docs.mongodb.com/manual/reference/read-concern-majority/) version of the modified document in the fullDocument field.
        """
        return pulumi.get(self, "config_full_document")

    @property
    @pulumi.getter(name="configFullDocumentBefore")
    def config_full_document_before(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "config_full_document_before")

    @property
    @pulumi.getter(name="configMatch")
    def config_match(self) -> pulumi.Output[str]:
        """
        Optional for `DATABASE` type. A [$match](https://docs.mongodb.com/manual/reference/operator/aggregation/match/) expression document that MongoDB Realm includes in the underlying change stream pipeline for the trigger. This is useful when you want to filter change events beyond their operation type. The trigger will only fire if the expression evaluates to true for a given change event.
        """
        return pulumi.get(self, "config_match")

    @property
    @pulumi.getter(name="configOperationType")
    def config_operation_type(self) -> pulumi.Output[str]:
        """
        Required for `AUTHENTICATION` type. The [authentication operation type](https://docs.mongodb.com/realm/triggers/authentication-triggers/#std-label-authentication-event-operation-types) to listen for. Possible Values: `LOGIN`, `CREATE`, `DELETE`
        """
        return pulumi.get(self, "config_operation_type")

    @property
    @pulumi.getter(name="configOperationTypes")
    def config_operation_types(self) -> pulumi.Output[Sequence[str]]:
        """
        Required for `DATABASE` type. The [database event operation types](https://docs.mongodb.com/realm/triggers/database-triggers/#std-label-database-events) to listen for. This must contain at least one value. Possible Values: `INSERT`, `UPDATE`, `REPLACE`, `DELETE`
        """
        return pulumi.get(self, "config_operation_types")

    @property
    @pulumi.getter(name="configProject")
    def config_project(self) -> pulumi.Output[str]:
        """
        Optional for `DATABASE` type. A [$project](https://docs.mongodb.com/manual/reference/operator/aggregation/project/) expression document that Realm uses to filter the fields that appear in change event objects.
        """
        return pulumi.get(self, "config_project")

    @property
    @pulumi.getter(name="configProviders")
    def config_providers(self) -> pulumi.Output[Sequence[str]]:
        """
        Required for `AUTHENTICATION` type. A list of one or more [authentication provider](https://docs.mongodb.com/realm/authentication/providers/) id values. The trigger will only listen for authentication events produced by these providers.
        """
        return pulumi.get(self, "config_providers")

    @property
    @pulumi.getter(name="configSchedule")
    def config_schedule(self) -> pulumi.Output[str]:
        """
        Required for `SCHEDULED` type. A [cron expression](https://docs.mongodb.com/realm/triggers/cron-expressions/) that defines the trigger schedule.
        """
        return pulumi.get(self, "config_schedule")

    @property
    @pulumi.getter(name="configScheduleType")
    def config_schedule_type(self) -> pulumi.Output[str]:
        return pulumi.get(self, "config_schedule_type")

    @property
    @pulumi.getter(name="configServiceId")
    def config_service_id(self) -> pulumi.Output[str]:
        """
        Required for `DATABASE` type. The ID of the MongoDB Service associated with the trigger.
        """
        return pulumi.get(self, "config_service_id")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[bool]:
        """
        Default: `false` If `true`, the trigger is disabled.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="eventProcessors")
    def event_processors(self) -> pulumi.Output[Optional['outputs.EventTriggerEventProcessors']]:
        """
        An object where each field name is an event processor ID and each value is an object that configures its corresponding event processor. The following event processors are supported: `AWS_EVENTBRIDGE` For an example configuration object, see [Send Trigger Events to AWS EventBridge](https://docs.mongodb.com/realm/triggers/eventbridge/#std-label-event_processor_example).
        * `event_processors.0.aws_eventbridge.config_account_id` - (Optional) AWS Account ID.
        * `event_processors.0.aws_eventbridge.config_region` - (Optional) Region of AWS Account.
        """
        return pulumi.get(self, "event_processors")

    @property
    @pulumi.getter(name="functionId")
    def function_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the function associated with the trigger.
        """
        return pulumi.get(self, "function_id")

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Output[str]:
        """
        The name of the function associated with the trigger.
        """
        return pulumi.get(self, "function_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the trigger.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The unique ID for the project to create the trigger.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> pulumi.Output[str]:
        """
        The unique ID of the trigger.
        """
        return pulumi.get(self, "trigger_id")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the trigger. Possible Values: `DATABASE`, `AUTHENTICATION`,`SCHEDULED`
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def unordered(self) -> pulumi.Output[bool]:
        """
        Only Available for Database Triggers. If true, event ordering is disabled and this trigger can process events in parallel. If false, event ordering is enabled and the trigger executes serially.
        """
        return pulumi.get(self, "unordered")

