# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetEncryptionAtRestResult',
    'AwaitableGetEncryptionAtRestResult',
    'get_encryption_at_rest',
    'get_encryption_at_rest_output',
]

@pulumi.output_type
class GetEncryptionAtRestResult:
    """
    A collection of values returned by getEncryptionAtRest.
    """
    def __init__(__self__, aws_kms_config=None, azure_key_vault_config=None, google_cloud_kms_config=None, id=None, project_id=None):
        if aws_kms_config and not isinstance(aws_kms_config, dict):
            raise TypeError("Expected argument 'aws_kms_config' to be a dict")
        pulumi.set(__self__, "aws_kms_config", aws_kms_config)
        if azure_key_vault_config and not isinstance(azure_key_vault_config, dict):
            raise TypeError("Expected argument 'azure_key_vault_config' to be a dict")
        pulumi.set(__self__, "azure_key_vault_config", azure_key_vault_config)
        if google_cloud_kms_config and not isinstance(google_cloud_kms_config, dict):
            raise TypeError("Expected argument 'google_cloud_kms_config' to be a dict")
        pulumi.set(__self__, "google_cloud_kms_config", google_cloud_kms_config)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="awsKmsConfig")
    def aws_kms_config(self) -> 'outputs.GetEncryptionAtRestAwsKmsConfigResult':
        """
        Amazon Web Services (AWS) KMS configuration details and encryption at rest configuration set for the specified project.
        """
        return pulumi.get(self, "aws_kms_config")

    @property
    @pulumi.getter(name="azureKeyVaultConfig")
    def azure_key_vault_config(self) -> 'outputs.GetEncryptionAtRestAzureKeyVaultConfigResult':
        """
        Details that define the configuration of Encryption at Rest using Azure Key Vault (AKV).
        """
        return pulumi.get(self, "azure_key_vault_config")

    @property
    @pulumi.getter(name="googleCloudKmsConfig")
    def google_cloud_kms_config(self) -> 'outputs.GetEncryptionAtRestGoogleCloudKmsConfigResult':
        """
        Details that define the configuration of Encryption at Rest using Google Cloud Key Management Service (KMS).
        """
        return pulumi.get(self, "google_cloud_kms_config")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        Unique 24-hexadecimal digit string that identifies your project.
        """
        return pulumi.get(self, "project_id")


class AwaitableGetEncryptionAtRestResult(GetEncryptionAtRestResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEncryptionAtRestResult(
            aws_kms_config=self.aws_kms_config,
            azure_key_vault_config=self.azure_key_vault_config,
            google_cloud_kms_config=self.google_cloud_kms_config,
            id=self.id,
            project_id=self.project_id)


def get_encryption_at_rest(project_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEncryptionAtRestResult:
    """
    ## # Data Source: EncryptionAtRest

    `EncryptionAtRest` describes encryption at rest configuration for an Atlas project with one of the following providers:

    [Amazon Web Services Key Management Service](https://docs.atlas.mongodb.com/security-aws-kms/#security-aws-kms)
    [Azure Key Vault](https://docs.atlas.mongodb.com/security-azure-kms/#security-azure-kms)
    [Google Cloud KMS](https://docs.atlas.mongodb.com/security-gcp-kms/#security-gcp-kms)

    > **IMPORTANT** By default, Atlas enables encryption at rest for all cluster storage and snapshot volumes.

    > **IMPORTANT** Atlas limits this feature to dedicated cluster tiers of M10 and greater. For more information see: https://www.mongodb.com/docs/atlas/reference/api-resources-spec/#tag/Encryption-at-Rest-using-Customer-Key-Management

    > **NOTE:** Groups and projects are synonymous terms. You may find `groupId` in the official documentation.

    ## Example Usage

    ### S

    ### Configuring encryption at rest using customer key management in AWS
    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    setup_only = mongodbatlas.CloudProviderAccessSetup("setup_only",
        project_id=atlas_project_id,
        provider_name="AWS")
    auth_role = mongodbatlas.CloudProviderAccessAuthorization("auth_role",
        project_id=atlas_project_id,
        role_id=setup_only.role_id,
        aws={
            "iam_assumed_role_arn": test_role["arn"],
        })
    test_encryption_at_rest = mongodbatlas.EncryptionAtRest("test",
        project_id=atlas_project_id,
        aws_kms_config={
            "enabled": True,
            "customer_master_key_id": kms_key["id"],
            "region": atlas_region,
            "role_id": auth_role.role_id,
        })
    cluster = mongodbatlas.AdvancedCluster("cluster",
        project_id=test_encryption_at_rest.project_id,
        name="MyCluster",
        cluster_type="REPLICASET",
        backup_enabled=True,
        encryption_at_rest_provider="AWS",
        replication_specs=[{
            "region_configs": [{
                "priority": 7,
                "provider_name": "AWS",
                "region_name": "US_EAST_1",
                "electable_specs": {
                    "instance_size": "M10",
                    "node_count": 3,
                },
            }],
        }])
    test = mongodbatlas.get_encryption_at_rest_output(project_id=test_encryption_at_rest.project_id)
    pulumi.export("isAwsKmsEncryptionAtRestValid", test.aws_kms_config.valid)
    ```

    ### Configuring encryption at rest using customer key management in Azure
    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    test_encryption_at_rest = mongodbatlas.EncryptionAtRest("test",
        project_id=atlas_project_id,
        azure_key_vault_config={
            "enabled": True,
            "azure_environment": "AZURE",
            "tenant_id": azure_tenant_id,
            "subscription_id": azure_subscription_id,
            "client_id": azure_client_id,
            "secret": azure_client_secret,
            "resource_group_name": azure_resource_group_name,
            "key_vault_name": azure_key_vault_name,
            "key_identifier": azure_key_identifier,
        })
    test = mongodbatlas.get_encryption_at_rest_output(project_id=test_encryption_at_rest.project_id)
    pulumi.export("isAzureEncryptionAtRestValid", test.azure_key_vault_config.valid)
    ```

    > **NOTE:** It is possible to configure Atlas Encryption at Rest to communicate with Azure Key Vault using Azure Private Link, ensuring that all traffic between Atlas and Key Vault takes place over Azure’s private network interfaces. Please review `EncryptionAtRestPrivateEndpoint` resource for details.

    ### Configuring encryption at rest using customer key management in GCP
    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    test_encryption_at_rest = mongodbatlas.EncryptionAtRest("test",
        project_id=atlas_project_id,
        google_cloud_kms_config={
            "enabled": True,
            "service_account_key": "{\\"type\\": \\"service_account\\",\\"project_id\\": \\"my-project-common-0\\",\\"private_key_id\\": \\"e120598ea4f88249469fcdd75a9a785c1bb3\\",\\"private_key\\": \\"-----BEGIN PRIVATE KEY-----\\\\nMIIEuwIBA(truncated)SfecnS0mT94D9\\\\n-----END PRIVATE KEY-----\\\\n\\",\\"client_email\\": \\"my-email-kms-0@my-project-common-0.iam.gserviceaccount.com\\",\\"client_id\\": \\"10180967717292066\\",\\"auth_uri\\": \\"https://accounts.google.com/o/oauth2/auth\\",\\"token_uri\\": \\"https://accounts.google.com/o/oauth2/token\\",\\"auth_provider_x509_cert_url\\": \\"https://www.googleapis.com/oauth2/v1/certs\\",\\"client_x509_cert_url\\": \\"https://www.googleapis.com/robot/v1/metadata/x509/my-email-kms-0%40my-project-common-0.iam.gserviceaccount.com\\"}",
            "key_version_resource_id": "projects/my-project-common-0/locations/us-east4/keyRings/my-key-ring-0/cryptoKeys/my-key-0/cryptoKeyVersions/1",
        })
    test = mongodbatlas.get_encryption_at_rest_output(project_id=test_encryption_at_rest.project_id)
    pulumi.export("isGcpEncryptionAtRestValid", test.google_cloud_kms_config.valid)
    ```


    :param str project_id: Unique 24-hexadecimal digit string that identifies your project.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('mongodbatlas:index/getEncryptionAtRest:getEncryptionAtRest', __args__, opts=opts, typ=GetEncryptionAtRestResult).value

    return AwaitableGetEncryptionAtRestResult(
        aws_kms_config=pulumi.get(__ret__, 'aws_kms_config'),
        azure_key_vault_config=pulumi.get(__ret__, 'azure_key_vault_config'),
        google_cloud_kms_config=pulumi.get(__ret__, 'google_cloud_kms_config'),
        id=pulumi.get(__ret__, 'id'),
        project_id=pulumi.get(__ret__, 'project_id'))


@_utilities.lift_output_func(get_encryption_at_rest)
def get_encryption_at_rest_output(project_id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEncryptionAtRestResult]:
    """
    ## # Data Source: EncryptionAtRest

    `EncryptionAtRest` describes encryption at rest configuration for an Atlas project with one of the following providers:

    [Amazon Web Services Key Management Service](https://docs.atlas.mongodb.com/security-aws-kms/#security-aws-kms)
    [Azure Key Vault](https://docs.atlas.mongodb.com/security-azure-kms/#security-azure-kms)
    [Google Cloud KMS](https://docs.atlas.mongodb.com/security-gcp-kms/#security-gcp-kms)

    > **IMPORTANT** By default, Atlas enables encryption at rest for all cluster storage and snapshot volumes.

    > **IMPORTANT** Atlas limits this feature to dedicated cluster tiers of M10 and greater. For more information see: https://www.mongodb.com/docs/atlas/reference/api-resources-spec/#tag/Encryption-at-Rest-using-Customer-Key-Management

    > **NOTE:** Groups and projects are synonymous terms. You may find `groupId` in the official documentation.

    ## Example Usage

    ### S

    ### Configuring encryption at rest using customer key management in AWS
    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    setup_only = mongodbatlas.CloudProviderAccessSetup("setup_only",
        project_id=atlas_project_id,
        provider_name="AWS")
    auth_role = mongodbatlas.CloudProviderAccessAuthorization("auth_role",
        project_id=atlas_project_id,
        role_id=setup_only.role_id,
        aws={
            "iam_assumed_role_arn": test_role["arn"],
        })
    test_encryption_at_rest = mongodbatlas.EncryptionAtRest("test",
        project_id=atlas_project_id,
        aws_kms_config={
            "enabled": True,
            "customer_master_key_id": kms_key["id"],
            "region": atlas_region,
            "role_id": auth_role.role_id,
        })
    cluster = mongodbatlas.AdvancedCluster("cluster",
        project_id=test_encryption_at_rest.project_id,
        name="MyCluster",
        cluster_type="REPLICASET",
        backup_enabled=True,
        encryption_at_rest_provider="AWS",
        replication_specs=[{
            "region_configs": [{
                "priority": 7,
                "provider_name": "AWS",
                "region_name": "US_EAST_1",
                "electable_specs": {
                    "instance_size": "M10",
                    "node_count": 3,
                },
            }],
        }])
    test = mongodbatlas.get_encryption_at_rest_output(project_id=test_encryption_at_rest.project_id)
    pulumi.export("isAwsKmsEncryptionAtRestValid", test.aws_kms_config.valid)
    ```

    ### Configuring encryption at rest using customer key management in Azure
    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    test_encryption_at_rest = mongodbatlas.EncryptionAtRest("test",
        project_id=atlas_project_id,
        azure_key_vault_config={
            "enabled": True,
            "azure_environment": "AZURE",
            "tenant_id": azure_tenant_id,
            "subscription_id": azure_subscription_id,
            "client_id": azure_client_id,
            "secret": azure_client_secret,
            "resource_group_name": azure_resource_group_name,
            "key_vault_name": azure_key_vault_name,
            "key_identifier": azure_key_identifier,
        })
    test = mongodbatlas.get_encryption_at_rest_output(project_id=test_encryption_at_rest.project_id)
    pulumi.export("isAzureEncryptionAtRestValid", test.azure_key_vault_config.valid)
    ```

    > **NOTE:** It is possible to configure Atlas Encryption at Rest to communicate with Azure Key Vault using Azure Private Link, ensuring that all traffic between Atlas and Key Vault takes place over Azure’s private network interfaces. Please review `EncryptionAtRestPrivateEndpoint` resource for details.

    ### Configuring encryption at rest using customer key management in GCP
    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    test_encryption_at_rest = mongodbatlas.EncryptionAtRest("test",
        project_id=atlas_project_id,
        google_cloud_kms_config={
            "enabled": True,
            "service_account_key": "{\\"type\\": \\"service_account\\",\\"project_id\\": \\"my-project-common-0\\",\\"private_key_id\\": \\"e120598ea4f88249469fcdd75a9a785c1bb3\\",\\"private_key\\": \\"-----BEGIN PRIVATE KEY-----\\\\nMIIEuwIBA(truncated)SfecnS0mT94D9\\\\n-----END PRIVATE KEY-----\\\\n\\",\\"client_email\\": \\"my-email-kms-0@my-project-common-0.iam.gserviceaccount.com\\",\\"client_id\\": \\"10180967717292066\\",\\"auth_uri\\": \\"https://accounts.google.com/o/oauth2/auth\\",\\"token_uri\\": \\"https://accounts.google.com/o/oauth2/token\\",\\"auth_provider_x509_cert_url\\": \\"https://www.googleapis.com/oauth2/v1/certs\\",\\"client_x509_cert_url\\": \\"https://www.googleapis.com/robot/v1/metadata/x509/my-email-kms-0%40my-project-common-0.iam.gserviceaccount.com\\"}",
            "key_version_resource_id": "projects/my-project-common-0/locations/us-east4/keyRings/my-key-ring-0/cryptoKeys/my-key-0/cryptoKeyVersions/1",
        })
    test = mongodbatlas.get_encryption_at_rest_output(project_id=test_encryption_at_rest.project_id)
    pulumi.export("isGcpEncryptionAtRestValid", test.google_cloud_kms_config.valid)
    ```


    :param str project_id: Unique 24-hexadecimal digit string that identifies your project.
    """
    ...
